/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2012 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *-------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Confidential.
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 *   Phone (781) 276 - 4000
 *   Fax   (781) 276 - 4001
 *
 *   hs_resp.c
 *
 *   Functions that are used to decide how to respond to received messages
 *   in a G.hs session.
 *
 *-------------------------------------------------------------------------
 */
// *****************************************************************************************/
// hs_resp_cpe.c
//
// History
//
// 10/07/2013 Sriram : Endless G.Hs training session in case of missing common mode in CO / CPE capabilities
//  Grep for XDSLRTFW-961 :BugFix_ALL_ALL_ALL_Hsk_NAKEF_Error
//
// 28/08/2013 Ram: CPE does not pass through G.HS phase when it is set in AVDSL mode. However, Link goes to
//                 showtime in VDSL2 ONLY mode. Vinax v1.4 CO is sending MS with wrong profile information
//                 when CLR contains ADSL info. Fix: Send CLR again without ADSL info when CO is Vinax v1.4
//                 Grep for XDSLRTFW-1184: BugFix_ALL_ALL_IFTN_No_Connect_In_AVDSL_Mode (Start_End)
//
// 07/01/2014 Hanyu: Added code to resolve the showtime link drop issue against EVLT-F/CNXT DSLAM in bonding mode:
//                   1. Bug fix for VRx to receive the PME Aggregation command/registor when the CNXT CO sends
//                      both BONDING_PME_DISCOVERY and BONDING_PME_AGGREGATION in Bonding SP2.
//                   2. Force to indicate bonding bit to workaround CNXT CO issue in CO CL message.
//                   Grep for XDSLRTFW-1514 XDSLRTFW-1437 IOP_A_US_VDSL2_EVLT_F_CNXT_Bond_LinkDrop
//
// 24/01/2014 Hanyu: COMMENTED OUT Generic bug fix to parse combined BONDING_PME_DISCOVERY and BONDING_PME_AGGREGATION in one O-CL SP2 message
//                   to reduce IOP risk due to FW release time constraint.
//                   This fix has been reviewed by FW and API team. It should be enabled to replace the "if(...) else if(...)" in the next release.
//                   Grep for XDSLRTFW-1514 XDSLRTFW-1437 BugFix_A_DS_VDSL2_ALL_Bond_Ghs
//
// *****************************************************************************************/
#include "common.h"
#include "vdsl_state.h"
#include "gdata.h"
#include "ghs.h"
#include "rx_ops.h"
#include "states.h"
#include "fifo.h"
#include "ghs.h"
#include "ghs_cpe.h"
#include "cmv.h"
#include "profile.h"
#include "vdsl_xception.h"
#include "vdsl_const.h"

FlagT CheckForValidTransceiverID(InfoField_t *t_Info);

// Debug TransceiverId (start_end)
// Debug code for testing the feature, which can be later removed!!!
uint8 guc_DestroyTransId = 0;

/* =============================================== */
/* static function prototypes */
/* =============================================== */
void  PrepareCLR();
void  ResponseToCL();
//#define HANDLE_BONDING_IN_PHY (1)

/* ==== processing for R_HS_INITIAL ==== */
void R_HS_INITIAL_state ()
{
   //XDSLRTFW-1901: ADSL/VDSL ACTIVATION STATE MACHINE (START_END)
   gsa_IndirectStat0[2]=VDSL2_INITIAL_TRANSACTION_STATE;
   switch (gt_hsc.s_InitialMsg)
   {
   case START_WITH_CLR:
      PrepareCLR();
      gt_hsc.s_NextState = R_HS_SEND_CLR;
      break;

   case START_WITH_MS:
      PrepareMS();
      gt_hsc.s_NextState = R_HS_SEND_MS;
      break;

   case START_WITH_MR:
      gpt_TxInfo->uc_Type  = M_MR;
      gt_hsc.s_NextState = R_HS_SEND_MR;
      break;

      /* new state from Revision 2 */
   case START_WITH_MP:
      // MP message is same as MS message, i.e. can be used by the CO directly as MS or
      // can be fully ignored.
      PrepareMS();
      gpt_TxInfo->uc_Type = M_MP;
      gt_hsc.s_NextState = R_HS_SEND_MP;
      break;
   }

   gs_TxMsgBufCnt = FormMessage( gpt_TxInfo, gpuca_TxMsgBuf );
}


/* ==== processing for R_HS_SEND_MS (ATU-R selects a mode of operation) ==== */
void R_HS_SEND_MS_state()
{
   //XDSLRTFW-1901: ADSL/VDSL ACTIVATION STATE MACHINE (START_END)
   gsa_IndirectStat0[2]=VDSL2_MS;
   switch ( gpt_RxInfo->uc_Type )
   {

   case M_NAK_NR:
      //XDSLRTFW-1901: ADSL/VDSL ACTIVATION STATE MACHINE (START_END)
      gsa_IndirectStat0[2]=VDSL2_NAK_NR;
   case M_NAK_NS:
      gt_hsc.s_NextState = R_HS_INITIAL;
      break;

   case M_ACK1:
      //XDSLRTFW-1901: ADSL/VDSL ACTIVATION STATE MACHINE (START_END)
      gsa_IndirectStat0[2]=VDSL2_MS_OK_ACK1;
      Do_ClearDown();
      gt_hsc.l_SelectedMode = SelectMode( gpt_TxInfo );       /*  Select mode of operation based on xmitted MS message */
      break;

   case M_ACK2:
      //XDSLRTFW-1901: ADSL/VDSL ACTIVATION STATE MACHINE (START_END)
      gsa_IndirectStat0[2]=VDSL2_PARIAL_MS_ACK2;
      if(gft_WholeTxMsgComplete == FALSE) // yes, we also know we haven't sent complete msg yet
      {
         gt_hsc.s_NextState = R_HS_SEND_MS;
      }
      else // sorry, we believe we've already sent complete msg. Sth must by wrong in transmition, then.
      {
         guc_NotUnderstood = TRUE;
      }

      break;

   case M_REQ_MR:
      gpt_TxInfo->uc_Type  = M_MR;
      gs_TxMsgBufCnt     = FormMessage( gpt_TxInfo, gpuca_TxMsgBuf );
      gt_hsc.s_NextState = R_HS_SEND_MR;

      break;

   case M_REQ_CLR:
      PrepareCLR();
      gs_TxMsgBufCnt     = FormMessage( gpt_TxInfo, gpuca_TxMsgBuf );

      gt_hsc.s_NextState = R_HS_SEND_CLR;

      break;

   default:
      guc_NotUnderstood = TRUE;

      break;
   }
}


/* ==== processing for R_HS_CL_OK ==== */
void R_HS_CL_OK_state()
{
   //------------------
   // VDSL_BONDING
   //------------------
#ifdef VDSL_BONDING

   FlagT ft_DoubleClrExhange = FALSE;
   uint16 us_PME_BitPosition;
   InfoField_t *pt_RxCL;   // received capability list of the other party
   InfoField_t *pt_TxCL;   // transmitted capability list of CPE

   pt_RxCL = gpt_RxInfo;
   pt_TxCL = gpt_TxInfoSave;

   if ((pt_RxCL->uc_ID_SPar1_03 & BONDING) &&
         (pt_RxCL->uc_BondingNP2 & BONDING_ETHERNET) &&
         (pt_TxCL->uc_BondingNP2 & BONDING_ETHERNET))
   {
#ifdef DEBUG_TRAIL
//      DebugTrail1(1,DEBUG_TRAIL_BONDING_TRAIL_ENABLE,0,(int16)0xFF10);
#endif // DEBUG_TRAIL
      // Clear all 4 disc and aggr set/clear status bits,
      // which means it's a 'get' commmand by default
      gt_Bonding_DiscAggr_Status.s_PAF_status &= ~(0x40 | 0x20 | 0x10 | 0x8);

//      if (pt_RxCL->uc_BondingSP2 & BONDING_PME_DISCOVERY) {
      // XDSLRTFW-1514 XDSLRTFW-1437 IOP_A_US_VDSL2_EVLT_F_CNXT_Bond_LinkDrop (START)
      // Bug fix for VRx to receive the PME Aggregation command when the CNXT CO sends both BONDING_PME_DISCOVERY and BONDING_PME_AGGREGATION in Bonding SP2
      if ( (pt_RxCL->uc_BondingSP2 & BONDING_PME_DISCOVERY) &&
            ((gul_fe_G994VendorID != CNXT_VENDOR_ID) || ((gul_fe_G994VendorID == CNXT_VENDOR_ID) && (!(pt_RxCL->uc_BondingSP2 & BONDING_PME_AGGREGATION)))) )
      {
         // XDSLRTFW-1514 XDSLRTFW-1437 IOP_A_US_VDSL2_EVLT_F_CNXT_Bond_LinkDrop (END)
         // XDSLRTFW-1514 XDSLRTFW-1437 BugFix_A_DS_VDSL2_ALL_Bond_Ghs (START)
         // Generic bug fix to parse combined BONDING_PME_DISCOVERY and BONDING_PME_AGGREGATION in one O-CL SP2 message
         //if (pt_RxCL->uc_BondingSP2 & BONDING_PME_DISCOVERY)
         //{
         // XDSLRTFW-1514 XDSLRTFW-1437 BugFix_A_DS_VDSL2_ALL_Bond_Ghs (END)
         // PME discovery command
         StoreInfoField_Bonding_NPar3(pt_RxCL, BONDING_PME_DISCOVERY);

#ifdef DEBUG_TRAIL
//         DebugTrail1(7,DEBUG_TRAIL_BONDING_TRAIL_ENABLE,0,
//                     (int16)0xFF11,
//                     gt_Bonding_DiscAggr_Control.sa_DiscCode[0],
//                     gt_Bonding_DiscAggr_Control.sa_DiscCode[1],
//                     gt_Bonding_DiscAggr_Control.sa_DiscCode[2],
//                     gt_Bonding_DiscAggr_Status.sa_DiscCode[0],
//                     gt_Bonding_DiscAggr_Status.sa_DiscCode[1],
//                     gt_Bonding_DiscAggr_Status.sa_DiscCode[2]);
#endif // DEBUG_TRAIL

         // See whether to set or clear Discovery register:
         if (pt_RxCL->uca_BondingDisc[0] & 0x1)
         {
            // clear if same
#ifdef DEBUG_TRAIL
//            DebugTrail1(1,DEBUG_TRAIL_BONDING_TRAIL_ENABLE,0,(int16)0xFF12);
#endif // DEBUG_TRAIL
            // Indicate Discovery Clear if Same
            gt_Bonding_DiscAggr_Status.s_PAF_status |= 0x40;
            // Clear if Same is mutually exclusive with Set if Clear, therefore reset Set if Clear bit
            gt_Bonding_DiscAggr_Status.s_PAF_status &= ~0x20;


#if HANDLE_BONDING_IN_PHY
            if ( (gt_Bonding_DiscAggr_Status.sa_DiscCode[0] == gt_Bonding_Continue.sa_DiscCode[0]) &&
                  (gt_Bonding_DiscAggr_Status.sa_DiscCode[1] == gt_Bonding_Continue.sa_DiscCode[1]) &&
                  (gt_Bonding_DiscAggr_Status.sa_DiscCode[2] == gt_Bonding_Continue.sa_DiscCode[2]) )
            {
               gt_Bonding_Continue.sa_DiscCode[0] = 0;
               gt_Bonding_Continue.sa_DiscCode[1] = 0;
               gt_Bonding_Continue.sa_DiscCode[2] = 0;
//               DebugTrail1(1,DEBUG_TRAIL_BONDING_TRAIL_ENABLE,0,(int16)0xFF13);
            }
#endif
         }
         else
         {
//               DebugTrail1(1,DEBUG_TRAIL_BONDING_TRAIL_ENABLE,0,(int16)0xFF14);

            // Indicate Discovery Set if clear
            gt_Bonding_DiscAggr_Status.s_PAF_status |= 0x20;
            // Set if Clear is mutually exclusive with Clear if Same, therefore reset Clear if Same bit
            gt_Bonding_DiscAggr_Status.s_PAF_status &= ~0x40;

//               DebugTrail1(1,DEBUG_TRAIL_BONDING_TRAIL_ENABLE,0,(int16)gt_Bonding_DiscAggr_Status.s_PAF_status);

#if HANDLE_BONDING_IN_PHY
            // set if clear
            if ( (gt_Bonding_Continue.sa_DiscCode[0] == 0) &&
                  (gt_Bonding_Continue.sa_DiscCode[1] == 0) &&
                  (gt_Bonding_Continue.sa_DiscCode[2] == 0) )
            {
               gt_Bonding_Continue.sa_DiscCode[0] = gt_Bonding_DiscAggr_Status.sa_DiscCode[0];
               gt_Bonding_Continue.sa_DiscCode[1] = gt_Bonding_DiscAggr_Status.sa_DiscCode[1];
               gt_Bonding_Continue.sa_DiscCode[2] = gt_Bonding_DiscAggr_Status.sa_DiscCode[2];

//               DebugTrail1(1,DEBUG_TRAIL_BONDING_TRAIL_ENABLE,0,(int16)0xFF15);
            }
#endif
         }

#if HANDLE_BONDING_IN_PHY
         // Update TxInfo bonding NPar3 params:
         InitializeInfoField_Bonding_NPar3(pt_TxCL);
#endif
         ft_DoubleClrExhange = TRUE;
      }
      else if (pt_RxCL->uc_BondingSP2 & BONDING_PME_AGGREGATION)
      {
         // XDSLRTFW-1514 XDSLRTFW-1437 BugFix_A_DS_VDSL2_ALL_Bond_Ghs (START)
         // Generic bug fix to parse combined BONDING_PME_DISCOVERY and BONDING_PME_AGGREGATION in one O-CL SP2 message
         //if (pt_RxCL->uc_BondingSP2 & BONDING_PME_AGGREGATION)
         //{
         // XDSLRTFW-1514 XDSLRTFW-1437 BugFix_A_DS_VDSL2_ALL_Bond_Ghs (END)

         // XDSLRTFW-1514 XDSLRTFW-1437 IOP_A_US_VDSL2_EVLT_F_CNXT_Bond_LinkDrop (START)
         if (gul_fe_G994VendorID == CNXT_VENDOR_ID)
         {
            // Force to indicate bonding bit to workaround CNXT CO issue in CO CL message
            pt_RxCL->uca_BondingAggr[5] |= 0x01;
            gt_Bonding_Continue.sa_PMEAggr_data[1] |= 0x0001;
         }
         // XDSLRTFW-1514 XDSLRTFW-1437 IOP_A_US_VDSL2_EVLT_F_CNXT_Bond_LinkDrop (END)

         // PME aggregation command
         StoreInfoField_Bonding_NPar3(pt_RxCL, BONDING_PME_AGGREGATION);
//         DebugTrail1(3,DEBUG_TRAIL_BONDING_TRAIL_ENABLE,0,
//                     (int16)0xFF16,
//                     (int16)gt_Bonding_DiscAggr_Status.sa_PMEAggr_data[0],
//                     (int16)gt_Bonding_DiscAggr_Status.sa_PMEAggr_data[1]);


         // See whether to set or clear PME Aggr register bit:
         us_PME_BitPosition = (gt_Bonding_DiscAggr_Control.s_PCS_control >> 8) & 0x1F;
         if (pt_RxCL->uca_BondingAggr[5] & 0x1)
         {

//            DebugTrail1(1,DEBUG_TRAIL_BONDING_TRAIL_ENABLE,0,(int16)0xFF17);

#if HANDLE_BONDING_IN_PHY
            // Set bit
            // Also updating the bit on the control variable (cnfg cmv)
            if (us_PME_BitPosition < 16)
            {
               gt_Bonding_Continue.sa_PMEAggr_data[1] |= (1<<us_PME_BitPosition);
            }
            else
            {
               gt_Bonding_Continue.sa_PMEAggr_data[0] |= (1<<(us_PME_BitPosition-16));
            }
#endif

            // Indicate PME aggr. Set command received
            gt_Bonding_DiscAggr_Status.s_PAF_status |= 0x8;
            // Aggr. Set and Clear are mutually exclusive, therefore reset Clear status bit
            gt_Bonding_DiscAggr_Status.s_PAF_status &= ~0x10;
            // Reset previous Discovery Clear if Same status.
            gt_Bonding_DiscAggr_Status.s_PAF_status &= ~0x40;

         }
         else
         {
//            DebugTrail1(1,DEBUG_TRAIL_BONDING_TRAIL_ENABLE,0,(int16)0xFF18);

#if HANDLE_BONDING_IN_PHY
            // Clear bit
            if (us_PME_BitPosition < 16)
            {
               gt_Bonding_Continue.sa_PMEAggr_data[1] &= ~((uint16)(1<<us_PME_BitPosition));
            }
            else
            {
               gt_Bonding_Continue.sa_PMEAggr_data[0] &= ~((uint16)(1<<(us_PME_BitPosition-16)));
            }
#endif
            // Indicate PME aggr. Clear (i.e. set 0) command received
            gt_Bonding_DiscAggr_Status.s_PAF_status |= 0x10;
            // Aggr. Set and Clear are mutually exclusive, therefore reset Set status bit
            gt_Bonding_DiscAggr_Status.s_PAF_status &= ~0x8;
            // Reset previous Discovery Set if Clear status.
            gt_Bonding_DiscAggr_Status.s_PAF_status &= ~0x20;

         }

#if HANDLE_BONDING_IN_PHY
         // Update TxInfo bonding NPar3 params:
         InitializeInfoField_Bonding_NPar3(pt_TxCL);
#endif
         ft_DoubleClrExhange = TRUE;
      }
   }

   // Note: This check is sufficient, because the bit "TRANSCEIVER_ID" is only be set,
   //       when the feature is enabled.
   if(gpt_TxInfoSave->uc_ID_SPar1 & TRANSCEIVER_ID)
   {
      if ((pt_RxCL->uc_ID_SPar1 & TRANSCEIVER_ID) && (pt_RxCL->uc_ID_SPar2_TransId & CO_TRANSCEIVER_ID))
      {
         // Copy CO TransceiverId to the TxInfoSave struct, so that the information gets
         // be transmitted in every further message to the CO. This is the from standard requested
         // echoing of the transceiverId.
         gpt_TxInfoSave->uc_ID_SPar2_TransId |= CO_TRANSCEIVER_ID;
         gpt_TxInfoSave->ul_CoTransId = pt_RxCL->ul_CoTransId;
      }
   }
   else
   {
      if(TESTArray[TEST_XDSLRTFW_CONFIG] & TEST_XDSLRTFW_CONFIG_XTALK_CONNECT)
      {
         if ((pt_RxCL->t_VDSL2_Info.uc_SI_NPar2_02 & V2_VECTOR_FULL_FRIENDLY) ||
               ((pt_RxCL->t_VDSL2_Info.uc_SI_SPar2_02 & V2_G_VECTOR_MASKS) &&
                (pt_RxCL->t_VDSL2_Info.uc_Gvector & (V2_GVECTOR_US_MASK|V2_GVECTOR_DS_MASK))) ||
               (TESTArray[TEST_XDSLRTFW_CONFIG] & TEST_XDSLRTFW_CONFIG_XTALK_COMMON))
         {
            gpt_TxInfoSave->uc_ID_SPar1 |= TRANSCEIVER_ID;
            if(!((gul_fe_G994VendorID == IFX_VENDOR_ID) && (((gus_fe_G994VendorSpecific >> 12) & 0x000F) <= 12)))
            {
               guc_ClrControl &= ~CLR_SEND_NOT_TRANCSEIVER_ID;
               ft_DoubleClrExhange = TRUE;
            }
         }
      }
   }

   if (ft_DoubleClrExhange)
   {
//      DebugTrail1(1,DEBUG_TRAIL_BONDING_TRAIL_ENABLE,0,(int16)0xFF19);

      gt_hsc.s_InitialMsg = START_WITH_CLR;
      gt_hsc.s_CL_Exchanged = FALSE;
   }
   else
#endif      // end VDSL_BONDING
   {
      gt_hsc.s_CL_Exchanged = TRUE;

      // check whether we should resend CLR by comparing CLR/CL
      if(gft_CL_CLR_Comparison == 0)
      {
         if ((OPTNArray[OPTN_GhsControl] & OPTN_GHS_RESP_MASK)==OPTN_RTRespTxMsg_MR )
         {
            gt_hsc.s_InitialMsg = START_WITH_MR;
         }
         else if ((OPTNArray[OPTN_GhsControl] & OPTN_GHS_RESP_MASK)==OPTN_RTRespTxMsg_MS)
         {
            gt_hsc.s_InitialMsg = START_WITH_MS;
         }
         else if ((OPTNArray[OPTN_GhsControl] & OPTN_GHS_RESP_MASK)==OPTN_RTRespTxMsg_MP)
         {
            gt_hsc.s_InitialMsg = START_WITH_MP;
         }
         else
         {
            gt_hsc.s_InitialMsg = START_WITH_MR;  // Default: CPE sends MR
            if(gpt_TxInfoSave->uc_ID_SPar2_TransId & CO_TRANSCEIVER_ID)
            {
               gt_hsc.s_InitialMsg = START_WITH_MP;
            }
         }
      }
      else
      {
         gt_hsc.s_CL_Exchanged = FALSE;
         gt_hsc.s_InitialMsg = START_WITH_CLR;
      }
   } //if (ft_DoubleClrExhange)


   // XDSLRTFW-1395 (Start_End)
   // Fixes for Vinax v1.0, Vinax v1.4 and Vinax v2.1/2 CO only.
   {
      FlagT tf_ReStartGhs;

      tf_ReStartGhs = FALSE;

      if(gul_fe_G994VendorID == IFX_VENDOR_ID)
      {
         int16 s_PlatformType;

         s_PlatformType = ((gus_fe_G994VendorSpecific >> 12) & 0x000F);

         if ((s_PlatformType == 9) || (s_PlatformType == 10))
         {
            // Vinax v1.0 to Vinax v1.4 CO are not supporting TransceiverId code points!
            if ((gpt_TxInfoSave->uc_ID_SPar1 & TRANSCEIVER_ID) &&
                  ((guc_ClrControl & CLR_SEND_NOT_TRANCSEIVER_ID) == 0))
            {
               guc_ClrControl |= CLR_SEND_NOT_TRANCSEIVER_ID;
               tf_ReStartGhs = TRUE;
            }

            // XDSLRTFW-1184: BugFix_ALL_ALL_IFTN_No_Connect_In_AVDSL_Mode (Start_End)
            // Bug: Modem does not pass through G.HS phase when ADSL modes are set together with VDSL.
            //      However, Link goes to showtime in VDSL2 ONLY mode. Vinax v1.4 CO is sending MS with
            //      wrong profile information when CLR contains ADSL info.
            // Fix: Send CLR again without ADSL info!
            //
            // Note: IF-case is needed to avoid a second CLR-CL-ACK1 transaction, when the
            //       API-config is VDSL only!
            if ((guc_ClrControl & CLR_SEND_NOT_ADSL_MODES) == 0)
            {
               // Resend CLR without ADSL capability
               gpt_TxInfoSave->uc_SI_SPar1 = 0;
               gpt_TxInfoSave->uc_SI_SPar1_02 &= (T1_MCM_VDSL>>8);
               gpt_TxInfoSave->uc_SI_SPar1_03 = 0;
               gpt_TxInfoSave->uc_SI_SPar1_04 = 0;
               gpt_TxInfoSave->uc_SI_SPar1_05 &= (G993_2 | G993_1_ANSI_T1_424);

               guc_ClrControl |= CLR_SEND_NOT_ADSL_MODES;
               gt_hsc.s_InitialMsg = START_WITH_CLR;
            }

            // XDSLRTFW-1216: BugFix_ALL_ALL_IFTN_No_Connect_In_Bonding_Mode (Start_End)
            // Bug: G.Hs failure is seen with Vinax v1.4 (ECI VTUC24) CO when bonding bit is SET in CLR.
            //      CO doesn't support bonding bit and sends CL with out any mode (VDSL or ADSL) set.
            //      Further responses from CO indicate G.Hs FCS error (probably CO has dropped the link).
            // Fix: Since CO has dropped the link, restart from tone dectection phase and send new CLR
            //      without bonding bit SET.
            if ((gt_Bonding_DiscAggr_Control.s_PCS_control & CNFG_PAF_ENABLE_MASK) &&
                  ((guc_ClrControl & CLR_SEND_NOT_BONDING_INFO) == 0))
            {
               //Resend CLR without Bonding capability
               guc_ClrControl |= CLR_SEND_NOT_BONDING_INFO;
               tf_ReStartGhs = TRUE;
            }
         }
         else if ((s_PlatformType == 11) || (s_PlatformType == 12))
         {
            // Vinax v2 CO is not supporting TransceiverId code points!
            if ((gpt_TxInfoSave->uc_ID_SPar1 & TRANSCEIVER_ID) &&
                  ((guc_ClrControl & CLR_SEND_NOT_TRANCSEIVER_ID) == 0) &&
                  (gft_CL_CLR_Comparison == 0x8))
            {
//               gpt_TxInfoSave->uc_ID_SPar1 &= ~(TRANSCEIVER_ID);
//               gpt_TxInfoSave->uc_ID_SPar2_TransId = 0;
               guc_ClrControl |= CLR_SEND_NOT_TRANCSEIVER_ID;
               tf_ReStartGhs = TRUE;
            }
         }

         if (tf_ReStartGhs)
         {
            // Needed to reinitialize HS variables
            gs_HandShake_Cnt = 0;

            //Restart from begining
            gs_TxNextState = R_SILENT0_TX;
            gpF_TxStateFunc = (PtrToFunc)RSilent0TxF;
            gs_RxNextState = R_C_SILENT1_RX;
            gpF_RxStateFunc = (PtrToFunc)RCSilent1RxF;
         }
      }
   }
   // XDSLRTFW-1216: BugFix_ALL_ALL_IFTN_No_Connect_In_Bonding_Mode (End)


   //XDSLRTFW-1080 IOPFix_US_All_All_Ghs_NO_MNAKCD (start_end)
   if(((gft_CL_CLR_Comparison == 0x8) || (gft_FW_Initiate_Retrain == 0x1)) &&
         (gul_fe_G994VendorID == IFX_VENDOR_ID))
   {
      gt_hsc.s_NextState = R_HS_NOT_UNDERSTOOD;
   }
   else
   {
      gt_hsc.s_NextState = R_HS_INITIAL;

      if(CheckForValidTransceiverID(gpt_RxInfoSave) == FALSE)
      {
         // If the VTU-R receives a CL or MS message that contains a VTU-R ID different
         // from the VTU-R ID sent in the CLR message, then the VTU-R shall respond with
         // a NAK-CD message followed by the G.994.1 session cleardown procedure specified
         // in clause 11.3/G.994.1.
         gpt_TxInfo->uc_Type = M_NAK_CD;
         gs_TxMsgBufCnt = FormMessage( gpt_TxInfo, gpuca_TxMsgBuf );

         gt_hsc.s_NextState = R_HS_NOT_UNDERSTOOD;
      }
   }
}
/* ==== processing for R_HS_SEND_MR ==== */
void R_HS_SEND_MR_state()
{
   gsa_IndirectStat0[2]=VDSL2_MR;  //XDSLRTFW-1901: VDSL ACTIVATE STATE MACHINE (START_END)
   switch ( gpt_RxInfo->uc_Type )
   {

   case M_MS:
      ResponseToMS();
      break;

   case M_REQ_MS:
      PrepareMS();
      gt_hsc.s_NextState = R_HS_SEND_MS;
      break;

   case M_REQ_CLR:
      PrepareCLR();
      gt_hsc.s_NextState = R_HS_SEND_CLR;
      break;

   default:
      guc_NotUnderstood = TRUE;
      break;
   }

   gs_TxMsgBufCnt = FormMessage( gpt_TxInfo, gpuca_TxMsgBuf );
}


/* ==== processing for R_HS_SEND_MP ==== */
void R_HS_SEND_MP_state()
{
   //XDSLRTFW-1901: ADSL/VDSL ACTIVATION STATE MACHINE (START_END)
   gsa_IndirectStat0[2]=VDSL2_MP;
   switch ( gpt_RxInfo->uc_Type )
   {
   case M_MS:
      ResponseToMS();
      break;

   case M_REQ_CLR:
      PrepareCLR();
      gt_hsc.s_NextState = R_HS_SEND_CLR;
      break;

   default:
      guc_NotUnderstood = TRUE;
      break;
   }

   gs_TxMsgBufCnt = FormMessage( gpt_TxInfo, gpuca_TxMsgBuf );
}


/* ==== processing for R_HS_SEND_CLR ==== */
void R_HS_SEND_CLR_state()
{
   gsa_IndirectStat0[2]=VDSL2_CLR; //XDSLRTFW-1901: ADSL/VDSL ACTIVATION STATE MACHINE (START_END)
   switch ( gpt_RxInfo->uc_Type )
   {

   case M_CL:
      ResponseToCL();

      //XDSLRTFW-1216: BugFix_ALL_ALL_IFTN_No_Connect_In_Bonding_Mode (Start)
      //No need to form message when we want to restart G.Hs session from begining
      if(gs_TxNextState != R_SILENT0_TX)
      {
         gs_TxMsgBufCnt = FormMessage( gpt_TxInfo, gpuca_TxMsgBuf );
      }
      //XDSLRTFW-1216: BugFix_ALL_ALL_IFTN_No_Connect_In_Bonding_Mode (End)

      break;

   case M_ACK2:
      if(gft_WholeTxMsgComplete == FALSE) // yes, we also know we haven't sent complete msg yet
      {
         gt_hsc.s_NextState = R_HS_SEND_CLR;
         gs_TxMsgBufCnt     = FormMessage( gpt_TxInfo, gpuca_TxMsgBuf );
      }
      else // sorry, we believe we've already sent complete msg. Sth must by wrong in transmition, then.
      {
         guc_NotUnderstood = TRUE;
      }

      break;

   default:
      guc_NotUnderstood = TRUE;
      break;
   }
}


/* ==== processing for R_HS_MS_OK ==== */
void R_HS_MS_OK_state()
{
   //XDSLRTFW-1901: ADSL/VDSL ACTIVATION STATE MACHINE (START_END)
   gsa_IndirectStat0[2]=VDSL2_MS_OK_ACK1;
   gt_hsc.s_NextState = R_HS_EXIT;   /*  indicate eend of HS message exchange */
}


/* ==== processing for R_HS_RESTART ==== */
void R_HS_RESTART_state()
{

   gt_hsc.s_NextState = R_HS_EXIT;  /*  indicate end of HS message exchange */
   gt_hsc.l_SelectedMode = RESTART_HS_NearEnd;  //XDSLRTFW-961 :BugFix_ALL_ALL_ALL_Hsk_NAKEF_Error(Start_End)
}

/* ==== processing for R_HS_NOT_READY, R_HS_NOT_SUPPORTED ==== */
void R_HS_NOT_READY_state()
{
   gt_hsc.s_NextState = R_HS_INITIAL;
}


void R_HS_NOT_SUPPORTED_state()
{
   gt_hsc.s_NextState = R_HS_INITIAL;
}

/* ==== processing for R_HS_NOT_UNDERSTOOD ==== */
void R_HS_NOT_UNDERSTOOD_state()
{
   gt_hsc.s_NextState    = R_HS_EXIT; /*  cleardown */
   gt_hsc.l_SelectedMode = RESTART_VIA_CLEARDOWN;
}

/* ==== processing for R_HS_PARTIAL_MS ==== */
void R_HS_PARTIAL_MS_state()
{
   ResponseToMS();
   gs_TxMsgBufCnt = FormMessage( gpt_TxInfo, gpuca_TxMsgBuf );
}

/* ==== processing for R_HS_PARTIAL_CL ==== */
void R_HS_PARTIAL_CL_state()
{
   ResponseToCL();

   gs_TxMsgBufCnt = FormMessage( gpt_TxInfo, gpuca_TxMsgBuf );
}


// New state of Rev 3
void R_HS_RETRANSMIT_state (void)
{

}



/*^^^
 *-------------------------------------------------------------------
 *
 *  Name: ResponseToMS
 *
 *  Abstract: Decide how to respond to MS message
 *
 *  Returns: None
 *
 *  Global Variables Used:
 *          gpt_RxInfo             - (I) received message
 *          gpt_TxInfo             - (O) message to be transmitted in response
 *          guc_EscFromFR_Flag     - (I)
 *          guc_EscToFR_Flag       - (O)
 *          guc_SilenceRequestFlag - (O)
 *          guc_CL_Exchange_Flag   - (I)
 *          guc_NoCommonModeFlag   - (O)
 *          gt_StateMachCntrl      - (O)
 *
 *  Notes: Does not receive additional Non-Standard Information, unless the current
 *          state is R_HSHS_PARTIAL_MS, i.e. Non-Standard Info already began.
 *
 *-------------------------------------------------------------------
 *^^^
 */
void ResponseToMS(void)
{
   //XDSLRTFW-1901: ADSL/VDSL ACTIVATION STATE MACHINE (START_END)
   gsa_IndirectStat0[2]=VDSL2_MS;
   /* ---- recieve all the segments if any                              ---- */
   /* ---- This condition may need to be changed vendor discretionarily ---- */
   if ((gt_hsc.s_DecodeResult == INCOMPLETE_STANDARD) ||
         (gt_hsc.s_DecodeResult == INCOMPLETE_NON_STANDARD))
   {
      gpt_TxInfo->uc_Type = M_ACK2;
      gt_hsc.s_NextState = R_HS_PARTIAL_MS;
      //XDSLRTFW-1901: ADSL/VDSL ACTIVATION STATE MACHINE (START_END)
      gsa_IndirectStat0[2]=VDSL2_PARIAL_MS_ACK2;
   }
   /* ---- otherwise select mode of operation and exit handshake ---- */
   else
   {
      // Against some Iknaos based VDSL1 DSLAMs the CPE needs to send Mode Request without
      // any CL-CLR exchange. For such cases we do not send not supported incase capabilities
      // have not been exchanged
      /* first check whether we at least get one CL/CLR exchange */
      if ((gt_hsc.s_CL_Exchanged == FALSE) && !(gul_dbgGHSControl & DISABLE_CL_EXCHANGED_CHECK) )
      {
         /* ---- If capabilities haven't been exchanged, indicate Not Supported Mode ---- */
         gpt_TxInfo->uc_Type = M_NAK_NS;
         //XDSLRTFW-1901: ADSL/VDSL ACTIVATION STATE MACHINE (START_END)
         gsa_IndirectStat0[2]=VDSL2_NAK_NS;
         gt_hsc.s_NextState = R_HS_NOT_SUPPORTED;
      }
      else
      {
         /* ---- select mode of operation based on received MS message ---- */
         gt_hsc.l_SelectedMode = SelectMode(gpt_RxInfo);

//         if(gt_hsc.l_SelectedMode == G993_2)
         {
            if(CheckForValidTransceiverID(gpt_RxInfo) == FALSE)
            {
               // If the VTU-R receives a CL or MS message that contains a VTU-R ID different
               // from the VTU-R ID sent in the CLR message, then the VTU-R shall respond with
               // a NAK-CD message followed by the G.994.1 session cleardown procedure specified
               // in clause 11.3/G.994.1.
               gt_hsc.l_SelectedMode = RESTART_VIA_CLEARDOWN;
            }
         }

         /* ---- accept selected mode ---- */
         if (gt_hsc.l_SelectedMode != NOT_SELECTED)
         {
            if(gt_hsc.l_SelectedMode == RESTART_VIA_CLEARDOWN)
            {
               gpt_TxInfo->uc_Type = M_NAK_CD;
               gt_hsc.s_NextState = R_HS_NOT_UNDERSTOOD;
            }
            else
            {
               gpt_TxInfo->uc_Type = M_ACK1;
               gt_hsc.s_NextState = R_HS_MS_OK;
            }
         }
         else
         {
            if ((guc_ClrControl & CLR_SEND_NOT_ADSL_MODES) == 0)
            {
               EnterFailStates(E_CODE_GHS_S_XDSL_MODE);
            }
            else if (gt_hsc.l_SelectedMode == G9701)
            {
               EnterFailStates(E_CODE_G_FAST_SWITCH);
            }
            else
            {
               /* ---- If capabilities have been exchanged, indicate Not Supported Mode ---- */
               gpt_TxInfo->uc_Type = M_NAK_NS;
               //XDSLRTFW-1901: ADSL/VDSL ACTIVATION STATE MACHINE (START_END)
               gsa_IndirectStat0[2]=VDSL2_NAK_NS;
               gt_hsc.s_NextState = R_HS_NOT_SUPPORTED;
            }
         }
      }
   }   /*  else (select mode) */
}   /*  ResponseToMS */


/*^^^
 *-------------------------------------------------------------------
 *
 *  Name: ResponseToCL
 *
 *  Abstract: Decide how to respond to a CL message
 *
 *  Returns: None
 *
 *  Global Variables Used:
 *
 *  Notes: Always receive additional Non-Standard Information for a CL message
 *
 *-------------------------------------------------------------------
 *^^^
 */
void ResponseToCL(void)
{
   /* ---- recieve all the segments if any                              ---- */
   /* ---- This condition may need to be changed vendor discretionarily ---- */
   if ( (gt_hsc.s_DecodeResult == INCOMPLETE_STANDARD)
         || (gt_hsc.s_DecodeResult == INCOMPLETE_NON_STANDARD) )
   {
      gpt_TxInfo->uc_Type  = M_ACK2;
      gt_hsc.s_NextState = R_HS_PARTIAL_CL;
      //XDSLRTFW-1901: ADSL/VDSL ACTIVATION STATE MACHINE (START_END)
      gsa_IndirectStat0[2]=VDSL2_PARTIAL_CL_ACK2;
   }
   else
   {
      CopyInfoField( gpt_RxInfo, gpt_RxInfoSave);    /*  save for later use or monitoring */

      gpt_TxInfo->uc_Type = M_ACK1;
      gt_hsc.s_NextState = R_HS_CL_OK;
      //XDSLRTFW-1901: ADSL/VDSL ACTIVATION STATE MACHINE (START_END)
      gsa_IndirectStat0[2]=VDSL2_CL_OK_ACK1;
      if((!(gul_fe_G994VendorID == IFX_VENDOR_ID)) &&
            ((gft_CL_CLR_Comparison == 0x8) || (gft_FW_Initiate_Retrain == 0x1)))
      {
         // XDSLRTFW-1080 IOPFix_US_All_All_Ghs_NO_MNAKCD (start_end)
         // For IFX/Lantiq COs don't indicate clear down (M_NAK_CD) from CPE in case of "No common mode".
         // Drop the link after Tx ACK(1), so that the CO sees a timeout or CRC.
         gpt_TxInfo->uc_Type = M_NAK_CD;
         gt_hsc.s_NextState = R_HS_NOT_UNDERSTOOD;
      }
      if ( gpt_RxInfo->uc_SI_SPar1_05 == G9701)
      {
         EnterFailStates(E_CODE_G_FAST_SWITCH);
      }
   }
   gs_cl_bonding = gpt_RxInfo->uc_ID_SPar1_03;
}   /*  ResponseToCL */


/*^^^
 *-------------------------------------------------------------------
 *
 *  Name: PrepareCLR
 *
 *  Abstract: Sets up parameters for a CLR
 *
 *  Returns: None
 *
 *  Global Variables Used:
 *
 *  Notes:
 *
 *-------------------------------------------------------------------
 *^^^
 */
volatile uint16 gus_WaitForBondingDataCnt;

void PrepareCLR(void)
{

#ifdef VDSL_BONDING
   // Note (15 Mar 2012): The first CLR also needs data from API

//   DebugTrail1(1,DEBUG_TRAIL_BONDING_TRAIL_ENABLE,0,(int16)0xFF40);

   //----------------------------------
   // if bonding is enabled,
   // 1. set macrostate to notify network processor
   // that the phy requires access to the bonding registers.
   // 2. (not shown) network processor notes macro state,
   // reads status to determine command type (set, clear, get),
   // updates registers if necessary, sends CONTINUE
   // message
   // 3. (not shown) PHY receives continue message and
   // updates the bonding registers with the received data
   // 4. reset macrostate to GHS
   // 5. place bonding information into data TxInfo
   //
   //----------------------------------
   if (gt_Bonding_DiscAggr_Control.s_PCS_control & CNFG_PAF_ENABLE_MASK)
   {
      int16 s_continue;

//      DebugTrail1(1,DEBUG_TRAIL_BONDING_TRAIL_ENABLE,0,(int16)0xFF41);

      //----------------------------------
      // set macrostate to GHS_BONDING_CLR
      //----------------------------------
      gsa_IndirectStat0[0] = STAT_BondingCLR;
      gusa_MONI_ModemStat_Status[0] = MONI_STAT_GHS_BONDING_CLR;

//      DebugTrail1(1,DEBUG_TRAIL_BONDING_TRAIL_ENABLE,0,(int16)0xFF4a);

      //----------------------------------
      // wait for Network Processor to process
      // any pending commands and return
      // remote discovery register and aggregate data
      //----------------------------------
      // reset continue bit
      gt_Bonding_Continue.s_continue &= ~0x1;

#if HANDLE_BONDING_IN_PHY
      // simulate the setting of the bit by network processor .
      gt_Bonding_Continue.s_continue |= 0x1;
#endif
      if (TESTArray[TEST_TwoPortMode] & TEST_ForceBondingContinue)
      {
         // simulate the setting of the bit by network processor.
         gt_Bonding_Continue.s_continue |= 0x1;
      }

      // !! Note: Needs to use volatile here. Otherwise compiler
      // will optimize out the memory read.
      s_continue = *(volatile int16*)(&(gt_Bonding_Continue.s_continue));
      while ((s_continue & 1) == 0)
      {
         gus_WaitForBondingDataCnt++;
         s_continue = *(volatile int16*)(&(gt_Bonding_Continue.s_continue));
      }

      //----------------------------------
      // Update TxInfo bonding NPar3 params:
      //----------------------------------
      //XDSLRTFW-1216: BugFix_ALL_ALL_IFTN_No_Connect_In_Bonding_Mode (Start_End)
      if ((guc_ClrControl & CLR_SEND_NOT_BONDING_INFO) == 0)
      {
         gpt_TxInfoSave->uc_ID_SPar1_03 = BONDING;
         gpt_TxInfoSave->uc_BondingNP2  = BONDING_ETHERNET;
         gpt_TxInfoSave->uc_BondingSP2  = (BONDING_PME_DISCOVERY | BONDING_PME_AGGREGATION | BONDING_PME_IDENTIFICATION);  // XDSLRTFW-2382 (Start_End)


         //Initialize NPar3 Discovery and PME aggregation fields:
         InitializeInfoField_Bonding_NPar3(gpt_TxInfoSave);
      }
   } //if (gt_Bonding_DiscAggr_Control.s_PCS_control & 0x1)

   //----------------------------------
   // set macrostate back to STAT_GhsState
   //----------------------------------
   gsa_IndirectStat0[0] = STAT_GhsState;
   gusa_MONI_ModemStat_Status[0] = MONI_STAT_GHS;
#endif //#ifdef VDSL_BONDING
#ifdef DEBUG_TRAIL
//   DebugTrail1(1,DEBUG_TRAIL_BONDING_TRAIL_ENABLE,0,(int16)0xFF42);
#endif
   CopyInfoField(gpt_TxInfoSave, gpt_TxInfo);

   gpt_TxInfo->uc_Type = M_CLR;
#ifdef DEBUG_TRAIL
//   DebugTrail1(1,DEBUG_TRAIL_BONDING_TRAIL_ENABLE,0,(int16)0xFF43);
#endif
   gs_clr_bonding = gpt_TxInfo->uc_ID_SPar1_03;
}   // PrepareCLR

FlagT CheckForValidTransceiverID(InfoField_t *pt_Info)
{
   FlagT tf_Return;

   tf_Return = TRUE;
   if (TESTArray[TEST_XDSLRTFW_CONFIG] & TEST_XDSLRTFW_CONFIG_XTALK_CONNECT)
   {
      if((pt_Info->uc_ID_SPar1 & TRANSCEIVER_ID) && (gpt_TxInfoSave->uc_ID_SPar1 & TRANSCEIVER_ID))
      {
         // Debug TransceiverId (start)
         // Debug code for testing the feature, which can be later removed!!!
         if(guc_DestroyTransId != 0)
         {
            pt_Info->ul_CpeTransId |= (guc_DestroyTransId << 25);
         }
         // Debug TransceiverId (end)

         if(pt_Info->ul_CpeTransId != gpt_TxInfoSave->ul_CpeTransId)
         {
            tf_Return = FALSE;
         }
      }
   }
#ifdef DEBUG_TRAIL
//   gsa_StatesTrail[0] = (pt_Info->ul_CpeTransId >> 16);
//   gsa_StatesTrail[1] = (pt_Info->ul_CpeTransId & 0xffff);
//   gsa_StatesTrail[2] = (gpt_TxInfoSave->ul_CpeTransId >> 16);
//   gsa_StatesTrail[3] = (gpt_TxInfoSave->ul_CpeTransId & 0xffff);
//   gsa_StatesTrail[4] = tf_Return;
#endif
   return(tf_Return);
}

