/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
#ifndef _ADSL_FEATURE_MAP_H
#define _ADSL_FEATURE_MAP_H

// ******************************************************************
// ADSLFeatureMap.h
//
// History
//
// ******************************************************************


#define ADSL_FEATURE_SUPPORTED          (1)
#define ADSL_FEATURE_NOT_SUPPORTED      (0)


//Refer to CMV 'DSL 19' in Message Spec ver 2.7 - Sec 6.4.5, 6.4.6

//Parameter 2
#define ADSL_Feature_ATM_Off_ChiP_Bonding                     (ADSL_FEATURE_NOT_SUPPORTED)
#define ADSL_Feature_ATM_On_Chip_Bonding                      (ADSL_FEATURE_NOT_SUPPORTED)

#define ADSL_Feature_PTM_OffChip_Bonding_BACP                 (ADSL_FEATURE_NOT_SUPPORTED)
#define ADSL_Feature_PTM_OnChip_Bonding_BACP                  (ADSL_FEATURE_NOT_SUPPORTED)
#define ADSL_Feature_PTM_OffChip_Bonding_GHS_Based            (ADSL_FEATURE_SUPPORTED)
#define ADSL_Feature_PTM_OnChip_Bonding_GHS_Based             (ADSL_FEATURE_NOT_SUPPORTED)
#define ADSL_Feature_PTM_TC_ADSL2_ADSL2P                      (ADSL_FEATURE_SUPPORTED)

   #define ADSL_Feature_Annex_M_J_US_PSD_Shaping              (ADSL_FEATURE_SUPPORTED)
   #define ADSL_Feature_Annex_M_J_US_Mask_Selection           (ADSL_FEATURE_SUPPORTED)
   #define ADSL_Feature_Annex_M                               (ADSL_FEATURE_SUPPORTED)
   #define ADSL_Feature_Annex_J                               (ADSL_FEATURE_NOT_SUPPORTED)
   #define ADSL_Feature_Annex_I                               (ADSL_FEATURE_NOT_SUPPORTED)
   #define ADSL_Feature_Annex_B                               (ADSL_FEATURE_NOT_SUPPORTED)
   #define ADSL_Feature_T1413                                 (ADSL_FEATURE_SUPPORTED)
   #define ADSL_Feature_Annex_A_L                             (ADSL_FEATURE_SUPPORTED)

//Parameter 3
#define ADSL_Feature_NTR                                      (ADSL_FEATURE_NOT_SUPPORTED)
#define ADSL_Feature_CIPolicy                                 (ADSL_FEATURE_NOT_SUPPORTED)
#define ADSL_Feature_PreEmption_And_ShortPkts                 (ADSL_FEATURE_NOT_SUPPORTED)
#define ADSL_Feature_DELT                                     (ADSL_FEATURE_SUPPORTED)
#define ADSL_Feature_Dual_Latency                             (ADSL_FEATURE_NOT_SUPPORTED)
#define ADSL_Feature_ShortInit                                (ADSL_FEATURE_NOT_SUPPORTED)
#define ADSL_Feature_VirtualNoise                             (ADSL_FEATURE_SUPPORTED)
#define ADSL_Feature_Erasure_Decoding_Force_INP               (ADSL_FEATURE_SUPPORTED)
#define ADSL_Feature_L2                                       (ADSL_FEATURE_SUPPORTED)

#define ADSL_Feature_G_INP_ReTx_US_DS_SRA                     (ADSL_FEATURE_NOT_SUPPORTED)
#define ADSL_Feature_G_INP_ReTx_DS_SRA                        (ADSL_FEATURE_NOT_SUPPORTED)
#define ADSL_Feature_G_INP_ReTx_US_DS                         (ADSL_FEATURE_NOT_SUPPORTED)
#define ADSL_Feature_G_INP_ReTx_DS                            (ADSL_FEATURE_SUPPORTED)

#define ADSL_Feature_SRA                                      (ADSL_FEATURE_SUPPORTED)
#define ADSL_Feature_BitSwap                                  (ADSL_FEATURE_SUPPORTED)

//Parameter 4
#define ADSL_Feature_MicroFilterDetection_And_HybridData      (ADSL_FEATURE_SUPPORTED)
#define ADSL_Feature_RealTimeTrace                            (ADSL_FEATURE_NOT_SUPPORTED)
#define ADSL_Feature_ClearEOC                                 (ADSL_FEATURE_NOT_SUPPORTED)

#endif // _ADSL_FEATURE_MAP_H
