/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2006 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
#ifndef _BITLOAD_H
#define _BITLOAD_H

/**********************************************************************
 *
 * Aware DMT Technology. Proprietary and Confidential.
 *
 * ADDRESS:          40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 * TELEPHONE:        781.276.4000
 * FAX:              781.276.4001
 * WEB:              http://www.aware.com
 *
 * FILE:             bitload.h
 * DESCRIPTION:      Header file for bit loading.
 *
 **********************************************************************/

// gus_BitloadErrorCode: error code for bitloading
#define BITLOAD_NO_ERROR                  (0)
#define BITLOAD_ERROR_ZERO_RATE           (1)
#define BITLOAD_ERROR_MIN_RATE_NOT_MET    (2)
#define BITLOAD_ERROR_CONTRACT_DIVERGE    (3)
#define BITLOAD_ERROR_ADD_BITS            (4)
#define BITLOAD_ERROR_TRIM_BITS           (5)
#define BITLOAD_ERROR_ADD_BITS_TCM        (6)
#define BITLOAD_ERROR_TRIM_BITS_TCM       (7)
#define BITLOAD_ERROR_EVEN_1BIT_TONES     (8)
#define BITLOAD_ERROR_EVEN_1BIT_TONES1    (9)
#define BITLOAD_ERROR_EVEN_1BIT_TONES2   (10)
#define BITLOAD_ERROR_FINAL_CHECK        (11)
#define BITLOAD_ERROR_ODD_1BIT_TONES     (12)
#define CHGBAT_RETCODE_VIOLATES_MARGIN   (13)
#define CHGBAT_RETCODE_CANT_CHANGE_LP1   (14)
#define BITLOAD_ERROR_UNEXPECTED_CASE1   (15)
#define BITLOAD_ERROR_UNEXPECTED_CASE2   (16)
#define BITLOAD_ERROR_UNEXPECTED_CASE3   (17)
#define CHGBAT_RETCODE_CANT_CHANGE_BAT1  (18)
#define CHGBAT_RETCODE_CANT_CHANGE_BAT2  (19)
#define BITLOAD_ERROR_INVALID_MAXNOMATP  (20)
#define CHGBAT_RETCODE_CANT_CHANGE_LP2   (21)
#define CHGBAT_RETCODE_CANT_CHANGE_LP3   (22)
#define CHGBAT_RETCODE_CANT_CHANGE_LP4   (23)
#define BITLOAD_ERROR_INVALID_MREFPSD    (24)
#define SRA_ERROR_NOT_FEASIBLE           (25)
#define SRA_EXCEED_MAX_TONES             (26)
#define SRA_LP_LIMIT_REACHED             (27)
#define CHGBAT_RETCODE_CANT_CHANGE_LP5   (28)
#define SRA_ERROR_BITLOAD_NOT_FEASIBLE   (29)
#define SRA_ERROR_RETX_FRAMING_NOT_FEASIBLE   (30)



#define SRA_TR115_SHIFT_OFFSET_1DB       10
#define SRA_TR115_SHIFT_OFFSET_1DOT3DB   13

#define SHIFT_TO_TARGET_SRNM              1
#define SHIFT_TO_SHIFT_THRESH             2
#define SHIFT_TO_PROTECT_IMPROVE          4
#define SHIFT_TO_RATE_IMPROVE             8

/**********************************************************************
 * FUNCTIONS
 **********************************************************************/

// Bitload.c
void InitBitloading(void);
void BgInitBitloading(void);
FlagT BitloadFixedRate(int32 l_BitsPerSymbol);
void ComputeSNRM_NOMATP(void);
void BgBitloadExplicitRate(void);
void ComputeMaxDataRate(void);
void OffsetSNRRequired(int16 s_Margin, int16* psa_SNRRequired);
int16 GetCodingGain(int16 s_R, FlagT ft_TcmFlag);
void ComputeSumFGainLinSq(int16 s_FineGain_dB, uint16 *pus_ncloaded, int32 *pl_SumFGainLinSq);



// Bitload_VDSL2.c
FlagT CalcChannelCapacity(int16 s_R, int32 *pl_MaxSumLp);
void BgBitloadAdaptiveRate_VDSL2(void);
void BgGenFramingATTNDR_VDSL2(void);

#endif // _BITLOAD_H
