/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2004 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
#ifndef _BITSWAPDECISION_V2_H_
#define _BITSWAPDECISION_V2_H_

/*
 *------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Confidential.
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413
 *   Phone (781) 276 - 4000
 *   Fax   (781) 276 - 4001
 *
 *   BitswapDecision_VDSL2.h
 *
 *   Header file corresponding to BitswapDecision_VDSL2.c
 *
 *------------------------------------------------------------------------
 */

#include "typedef.h"

#define MAX_NUM_BITSWAP_TONES                   (128)    //maximum number of bitswap tones allowed
#define BITSWAP_TRIGGER_DELTA_DB                (3<<8)   //3 dB in Q8.8
#define BITSWAP_MIN_SNR_MARGIN                  (2<<8)   //2 dB in Q8.8
#define REDUCE_LP_DELTA_BITSWAP                 (50)     //= N: constraint 2N+4 < 128
#define E_CODE_BITSWAP_DECISION_NO_ERROR        (0)
#define E_CODE_BITSWAP_DECISION_ADD_BITS1       (1)
#define E_CODE_BITSWAP_DECISION_ADD_BITS2       (2)
#define E_CODE_BITSWAP_DECISION_CUT_BITS        (3)
#define E_CODE_BITSWAP_DECISION_MARGIN          (4)
#define E_CODE_BITSWAP_DECISION_LP              (5)
#define E_CODE_BITSWAP_DECISION_TONES           (6)
#define E_CODE_BITSWAP_NUM1BIT_TONES            (7)
#define E_CODE_BITSWAP_TONEREORDER              (8)
#define E_CODE_BITSWAP_NUM_TONES_GAIN_SWAP      (9)
#define E_CODE_BITSWAP_DECISION_TONES_GAIN_SWAP (10)
#define E_CODE_BITSWAP_INFO_ALGO_STARTED         (11) //XDSLRTFW-3807

// XDSRTFW-442: Feature_All_All_All_All_Vdsl2Sra [Start]
// SRA sub states
#define SRA_INIT                       0
#define SRA_CHANGE_INACTIVE_TABLES     1
#define SRA_IN_PROGRESS                2
#define SRA_PROCESS_DONE               3
#define SRA_DONE                       4
#define SRA_RETX_FRM                   5

// SRA Fail code definations
#define SRA_ALGO_FINDS_NECESSARY_BITS_FOR_CHANGING       0
#define SRA_ALGO_SATISFY_MAX_NUM_BITSWAP_TONES           1
#define SRA_ALGO_FAILED_MAX_NUM_BITSWAP_TONES            2
#define SRA_FAILED_BITLOAD_NOT_FEASIBLE                  3


void RxSRADecision_VDSL2(void);
// XDSRTFW-442: Feature_All_All_All_All_Vdsl2Sra [End]


// function prototype
void RxBitSwapDecisionForTest_VDSL2(void);
void RxSRADecisionForTest_VDSL2(void);
void BgRxBitSwapDecision_VDSL2(void);
void RxBitSwapGainConversion_VDSL2(void);
void DistributeFineGains(uint8 *puca_RxBat, int16 *psa_RxFineGains, int16 *psa_SNRBuffer, RxToneFlags p_ActiveTones_ToConsider);
int16 ReduceFineGains_InCaseOfFgOverShoot(uint8 *puca_RxBat, int16 *psa_RxFineGains, int16 *psa_SNRBuffer, RxToneFlags p_ActiveTones_ToConsider); //XDSLRTFW-3807
//XDSLRTFW-464 : DS_MARGIN_LOWER_TO_BRCM_DISTRIBUTE_FINEGAIN (Start)
void DistributeFineGainsForShowtime(uint8 *puca_RxBat, int16 *psa_RxFineGains, int16 *psa_SNRBuffer, RxToneFlags p_ActiveTones_ToConsider);
//XDSLRTFW-464 : DS_MARGIN_LOWER_TO_BRCM_DISTRIBUTE_FINEGAIN (End)
void ChangeRxGainsForBitSwap(void);
#endif   //_BITSWAPDECISION_V2_H_
