/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2004 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
#ifndef _BITSWAPHANDLER_H_
#define _BITSWAPHANDLER_H_

/*
 *------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Confidential.
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413
 *   Phone (781) 276 - 4000
 *   Fax   (781) 276 - 4001
 *
 *   BitswapHandler.h
 *
 *   Header file corresponding to BitswapHandler.c
 *
 *------------------------------------------------------------------------
 */

#include "typedef.h"


// Bitswap state machine states
#define BITSWAP_INIT             (0)
#define BITSWAP_GAIN_CONVERSION        (1)
#define BITSWAP_GAIN_CONVERSION_WAIT   (2)
#define BITSWAP_DECISION            (3)
#define BITSWAP_DECISION_WAIT       (4)
// XDSRTFW-442: Feature_All_All_All_All_Vdsl2Sra [Start]
#define BITSWAP_DECISION_WAIT_PART1    (5)
#define BITSWAP_DECISION_WAIT_PART2    (6)
#define DYNAMIC_POWER_ADJUSTMENT_WAIT   (14)
#define BITSWAP_RELOAD_GAINS_WAIT      (7)
#define BITSWAP_CHANGE_GAIN_WAIT    (8)
#define  BITSWAP_REQUEST               (9)
#define BITSWAP_STEADY_STATE_WAIT       (10)
#define  BITSWAP_DONE               (11)
#define SRA_DECISION_WAIT               (12)
#define BITSWAP_WAIT_TABLECOPY          (13)
#define  BITSWAP_NOT_INITIATED        (15)
//#define   BITSWAP_REQUEST               (3)
#define  BITSWAP_REQUEST_ACKNOWLEDGED (16)
// XDSRTFW-442: Feature_All_All_All_All_Vdsl2Sra [End]
// Bitmap for the RX bit-swap control flag
#define RX_BITSWAP_BGT_MISMATCH        (1)

// BG Bitswap Request state
#define BSR_INTERPRETATION_IDLE      (1)
#define BSR_INTERPRETATION_ONGOING   (2)

// function prototype
void RxBitswapHandler_VDSL2(void);


#endif   // _BITSWAPHANDLER_H_
