/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2007 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   filename: DDSnrFdqHandler.h
*
*   Header file for DDSnrFdqHandler.c.
*
*-------------------------------------------------------------------------------
*/

#ifndef _DDSNRFDQHANDLER_H
#define _DDSNRFDQHANDLER_H

// states used in DDSnrFdqHandler()
#define DD_SNRFDQ_INIT             (0)
#define DD_SNRFDQ_SETUP            (1)
#define DD_SNRFDQ_HW_READY         (2)
#define DD_SNRFDQ_CALC             (3)
#define DD_SNRFDQ_RXPOWER          (4)
#define DD_SNRFDQ_RXPOWER_WAIT     (5)
#define DD_SNRFDQ_NEXT_TONEGROUP   (6)
#define DD_SNRFDQ_CALC_MARGIN      (7)
#define DD_SNRFDQ_CALC_MARGIN_WAIT (8)

#define DD_SNRFDQ_DONE            (-1)

// substates used for SNR update in DDSnrFdqHandler()
#define DD_SNR_NOISE_ACC         (0)
#define DD_SNR_CALC              (1)
#define DD_SNR_DONE              (-1)

// substates used for FDQ update and RX Power Measurement in DDSnrFdqHandler()
#define DD_FDQ_READ              (0)
#define DD_FDQ_UPDATE            (1)
#define DD_FDQ_LOAD              (2)
#define DD_FDQ_DONE              (-1)

void DDSnrFdqHandler(void);
void DDSnrSubHandler(void);
void DDFdqSubHandler(void);
void BgDDFdqAdapt(void);
void BgDDRxPowerCalc(void);
void BgCalcShowtimeSnrMargin(void);
void ComparePilotMetric(void);

#endif // _DDSNRFDQHANDLER_H
