/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2001 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
#ifndef _DSLENGIN_H
#define _DSLENGIN_H

/**********************************************************************
 *
 * Aware DMT Technology. Proprietary and Confidential.
 *
 * ADDRESS:          40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 * TELEPHONE:        781.276.4000
 * FAX:              781.276.4001
 * WEB:              http://www.aware.com
 *
 * FILE:             dslengin.h
 * DESCRIPTION:      Header file that defines the API to the DSL Engine.  The DSL Engine
 *                must implement all of the functions declared here.  The implementation
 *                details will be engine-specific.
 *
 **********************************************************************/

/***************************************************************************
*
* These functions define the common DSL Engine API.
* NOTE: Functions of type 'extern LoadingFunction'
* are queued and executed later using the task-layer AddFunctionToFifo() and
* ExecuteQueuedLoadingFunctions() functions.  These loading functions should not
* be called directly, i.e. they should only be executed as part of a call to
* ExecuteQueuedLoadingFunctions().
*
***************************************************************************/

LoadingFunction InsertTxCE;
LoadingFunction DisableTxCE;
LoadingFunction StartTxWin;
LoadingFunction ChangeTxCE_ForFirstSym;
LoadingFunction ChangeTxCE_ForLastSym;
LoadingFunction ConfigTxFrameSize;
LoadingFunction InsertRxCE;
//LoadingFunction RestoreRxWindowCoeffSize;
LoadingFunction DisableRxCE;
LoadingFunction ChangeRxCE_PreFirstSym;
LoadingFunction ChangeRxCE_ForFirstSym;
LoadingFunction ChangeRxFftLength_PreLastSym;
LoadingFunction ChangeRxFftLength_ForLastSym;
LoadingFunction ConfigRxFrameSize;
LoadingFunction LoadParrParms;
LoadingFunction ReadParrStatus;
LoadingFunction EnableParr;
LoadingFunction DisableParr;

#endif   /* _DSLENGIN_H */

