/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2004 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
#ifndef _DEBUGBUFFER_H
#define _DEBUGBUFFER_H

/**********************************************************************
 *
 * Aware DMT Technology. Proprietary and Confidential.
 *
 * ADDRESS:          40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 * TELEPHONE:        781.276.4000
 * FAX:              781.276.4001
 * WEB:              http://www.aware.com
 *
 * FILE:             DebugBuffer.h
 * DESCRIPTION:      Header file for DebugBuffer.h
 *
 **********************************************************************/

#ifdef DEBUG_TRACES

//-------------------------------------------------------------------
// Debug Buffer - Error/condition Identifiers
//-------------------------------------------------------------------
#define NO_SPACE_INTERNAL_BUFFER 0x0F
#define NO_DMA_ERROR_DEBUG 0x0000
#define INTERNAL_BUFFER_FULL 0xBBBB
#define EXCEEDS_MAX_ARGUMENTS 0x0005
#define NO_DEBUG_BUFFER_ERROR 0x0001

//-------------------------------------------------------------------
// Debug Buffer - gt_DebugBuffControl Identifiers
//-------------------------------------------------------------------
#define GHS_TRAINING_CAPTURE_DISABLE_MASK 0x0001
#define SHOW_TIME_CAPTURE_DISABLE_MASK    0x0002
#define US_RETX_ONLY_CAPTURE_DISABLE_MASK 0x0004
#define SHOW_TIME_EVENT_DISABLE_MASK      0x0008

#define SHOW_TIME_US_RETX_CAPTURE_ENABLE_CHECK 0X0004

#define LOG_PER_X_SYMBOL_DEBUG_BUFFER 44

//--------------------------------------------------------------------
// Debug Buffer - Memory Identifiers
//--------------------------------------------------------------------

#define SDRAM_RAW_DUMP_SHOWTIME_START_INDEX 2000
#define DEBUG_INTERNAL_BUFFER_MAX_SIZE_BYTES 4000
#define DEBUG_INTERNAL_PING_OR_PONG_BUFFER_MAX_SIZE_BYTES 2000
#define RAW_DUMP_MAX_SDRAM_SIZE_BYTES 20000
#define SDRAM_RAW_DUMP_SHOWTIME_SIZE_BYTES 18000


//--------------------------------------------------------------------
//  Debug Buffer - Message Delimiters
//------------------------------------------------------------------

#define DEBUG_BUFFER_DELIMETER_GHS_END 0xDBDBDBDB
#define DEBUG_BUFFER_DELIMITER_VDSL2 0xEEEEEEEE
#define DEBUG_BUFFER_DELIMETER_TRAINING_END 0xBCBCBCBC
#define DEBUG_BUFFER_DELIMITER_GHS_START 0xCDCDCDCD
#define DEBUG_BUFFER_DELIMITER_REPEAT_EVERY_X_SYM 0xAEAEAEAE
#define DEBUG_BUFFER_DELIMITER_SYC_SYM_START 0xEFEFEFEF
#define DEBUG_BUFFER_DELIMITER_SYC_SYM_END 0xFBFBFBFB



int32 LogMessages(int16 s_count, ... );

void ShowtimeDebugBuffUpdate(void);
void ShowtimeDebugBuffSuperframeUpdate(void);
int32 LogShowtimeData(uint8 *puc_base_addr , uint16 us_num_bytes);
void DMAtoSDRAM(int32 *pl_addr_source ,int16 s_size_bytes);
#define DEBUG_EVT_SYM_CNT_ZERO                0
#define DEBUG_EVT_GHS_ENTERED_TX              1
#define DEBUG_EVT_GHS_ENTERED_RX              2
#define DEBUG_EVT_CHDISC_ENTERD_TX            3
#define DEBUG_EVT_CHDISC_ENTERD_RX            4
#define DEBUG_EVT_MIN_USMARGIN                7
#define DEBUG_EVT_EXCEPTION                   8
#define DEBUG_EVT_CONSECUTIVE_US_CRC8         9
#define DEBUG_EVT_LOS                         10
#define DEBUG_EVT_NLOS                        11
#define DEBUG_EVT_OLR_DS_STATS                12
#define DEBUG_EVT_OLR_US_STATS                13
#define DEBUG_EVT_OLR_LP                      14
#define DEBUG_EVT_OLR_HANDLER_INFO            15
#define DEBUG_EVT_OLR_SRA_DECISION            16
#define DEBUG_EVT_OLR_SRA_DECISION_DONE       17

#define DEBUG_EVT_RX_BGT_OLR_ACTIVE           20
#define DEBUG_EVT_RX_BGT_OLR_InACTIVE         21
#define DEBUG_EVT_TX_BGT_MISMATCH             22
#define DEBUG_EVT_TX_BGT_UPDATE               23
#define DEBUG_EVT_SEF_STATE_CHANGE            24

#define DEBUG_EVT_CRC_NE_FE                   25
#define DEBUG_EVT_MARGIN_NE_FE                26
#define DEBUG_EVT_FE_LINE_PRIMITIVE           27

#define DEBUG_BUFF_EVT_ELEMENT_MAX   249
#define DEBUG_BUFF_EVT_MAXPAYLOAD    6

typedef struct
{
    int32       RxSymbolCount;
    uint16      EventID;
    uint8       aPayload[DEBUG_BUFF_EVT_MAXPAYLOAD];
}  T_DebugBuffEvtElement;

typedef struct
{
    int32                       EvtTraceBufStatus;
    int16                       EvtTraceBufCnt;
    int16                       EvtTraceBufIndex;
    int16                       aEvtTraceBufResv[4];
    T_DebugBuffEvtElement       aEvtTraceBuf[DEBUG_BUFF_EVT_ELEMENT_MAX];
}  T_DebugBuffEvt;

typedef union
{
   uint16 gusa_DebugBuf[DEBUG_INTERNAL_BUFFER_MAX_SIZE_BYTES/2]; // buffer used to store the Handshake , Training and showtime debug values
   T_DebugBuffEvt tDebugBuffEvt;
} DebugBuffer_t;

//void DebugBuffWriteEv(uint8 EventID, uint8 PayloadLen, uint8 *pPayloadData);
void DebugBuffWriteEv(uint8 EventID, uint8 PayloadLen, void *pPayloadData);
#endif // #ifdef DEBUG_TRACES

#endif /* _DEBUGBUFFER_H*/


