/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2007 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/****************************************************************************
;  Aware DMT Technology. Proprietary and Confidential.
;
;   40 Middlesex Turnpike, Bedford, MA 01730-1413
;  Phone (781) 276 - 4000
;   Fax   (781) 276 - 4001
;
;
;  File Name: dec_adapt.h
;
;  This is the header file for dec_adapt.c
;
*****************************************************************************/
#ifndef _DEC_ADAPT_H
#define _DEC_ADAPT_H

// Define DEC Rx and Tx capture flag states
#define IDLE_STATE 0
#define START_STATE 1
#define ACTIVE_STATE 2
#define DONE_STATE 3

// Define DEC adaptation state machine states
#define DEC_UPDATE_FRAME_ALIGN             (1)
#define DEC_UPDATE_MEASURE_TXFRAME_NUMBER  (2)
#define DEC_UPDATE_SET_TX_OFFSET           (3)
#define DEC_UPDATE_RX_TX_CAPTURE           (4)
#define DEC_UPDATE_RX_ERROR                (5)
#define DEC_UPDATE_ERROR_CORR              (6)
#define DEC_UPDATE_ERROR_CORR_WAIT         (7)
#define DEC_UPDATE_CALC_COEF               (8)
#define DEC_UPDATE_LOAD_COEF               (9)
#define DEC_UPDATE_RESET                   (10)
#define DEC_UPDATE_WAIT_FOR_OLR            (11)
#define DEC_UPDATE_REINIT_AFTER_OLR        (12)

// Define DEC adaptation LMS background tasks states
#define DEC_ADAPT_LMS_CORR_ONGOING         (1)
#define DEC_ADAPT_LMS_CORR_DONE            (2)
#define DEC_ADAPT_LMS_UPDATE_ONGOING       (3)
#define DEC_ADAPT_LMS_UPDATE_DONE          (4)

// Used in computation of running average of Rx synch frame data
#define RX_AVG_SCALE 0x01

// Macros used in LMS update algorithm
#define RX_CAPT_BUF_LEN          (16)
#define LOG2_RX_CAPT_BUF_LEN     (4)

#define MAX_DEC_INPUT_SAMPLES       (240) // Maximum size of DEC input capture buffer

#define  DEC_UPDATE_WORD_SIZE    (16)
#define  ERROR_FRAC_COEF_WIDTH      (15)  // Q1.15
#define ERROR_COEF_WIDTH         (ERROR_FRAC_COEF_WIDTH + 1) // = 16
#define TXDATA_FRAC_COEF_WIDTH      (15)  // Q1.15
#define TXDATA_WIDTH          (TXDATA_FRAC_COEF_WIDTH + 1) // = 16
#define DEC_FRAC_COEF_WIDTH         (31)  // Q1.31
#define DEC_WIDTH             (1+DEC_FRAC_COEF_WIDTH) // = 32

#define LSB_DEC_UPDATE_MSP       (DEC_UPDATE_WORD_SIZE - LOG2_RX_CAPT_BUF_LEN)   // = 12
#define DEC_UPDATE_LSP_MASK         (0xffff >> LOG2_RX_CAPT_BUF_LEN) // = 0x0fff
#define DEC_UPDATE_LSP_WIDTH     (LSB_DEC_UPDATE_MSP) // = 12
#define DEC_UPDATE_MSP_WIDTH     (ERROR_COEF_WIDTH - LSB_DEC_UPDATE_MSP)   // = 16 - 12 = 4
#define DEC_UPDATE_LOWER_PRODUCT_WIDTH (DEC_UPDATE_LSP_WIDTH + TXDATA_WIDTH) // = 12 + 16 = 28
#define DEC_UPDATE_UPPER_PRODUCT_WIDTH (DEC_UPDATE_MSP_WIDTH + TXDATA_WIDTH) // = 4 + 16 = 20
#define DEC_PRODUCT_LSP_SHIFT    (32 - (DEC_UPDATE_LOWER_PRODUCT_WIDTH + LOG2_RX_CAPT_BUF_LEN)) // = 0, shift applied to avoid overflow
#define DEC_PRODUCT_FRAC_COEF_WIDTH (ERROR_FRAC_COEF_WIDTH + TXDATA_FRAC_COEF_WIDTH + 1)  // Q1.39

#define DEC_UPDATE_LOWER_SUM_WIDTH  (DEC_UPDATE_LOWER_PRODUCT_WIDTH + LOG2_RX_CAPT_BUF_LEN)  // = 32
#define DEC_UPDATE_UPPER_SUM_WIDTH  (DEC_UPDATE_UPPER_PRODUCT_WIDTH + LOG2_RX_CAPT_BUF_LEN) // = 24
#define DEC_SUM_SHIFT            (32 - DEC_UPDATE_UPPER_SUM_WIDTH + 1) // = 9

#define DEC_SUM_INT_COEF_WIDTH      (1 + LOG2_RX_CAPT_BUF_LEN) // Q5.39
#define DEC_SUM_WIDTH            (DEC_SUM_INT_COEF_WIDTH + DEC_PRODUCT_FRAC_COEF_WIDTH) // = 44

// Other Constants
#define DEC_ADAPT_INITIAL_MU      (10) // LMS initial stepsize = 2^(-DEC_ADAPT_INITIAL_MU), if negative mu>1
#define TOTAL_AVG_SYNC_SYMBOLS   (128) // Number of synch frames used to update averaging of the reference Rx synch
                              // frame before starting the LMS updates.
#define LOG2_TOTAL_AVG_SYNC_SYMBOLS (7)


#define DEC_ADAPT_ENABLE_FRAMENUM (4)  // Number of frames before the synch frame to enable the Rx capture

// Target Rx error capture offset (offset sample into Rx sync frame)
#define TARGET_RX_ERR_CAPT_OFFSET 60

// Macros used for transmitting out of band energy
#define FIRST_OUT_OF_BAND_TONE   1
#define LAST_OUT_OF_BAND_TONE 32
#define MEDLEY_OUT_OF_BAND_LEVEL 0x05B1   // 15 dB below nominal
#define SHOW_OUT_OF_BAND_LEVEL 0x0800  // 12 dB below nominal

// function prototypes
void ShowtimeDecUpdates(void);
void LmsErrorCorrelation(int32 *pla_error_corr, int32 *pla_error, int16 *psa_TxData);
void LmsUpdate(void);
void DecUpdateTxTc(int16 s_TxFrameCnt);

//#define DEBUG_DEC_UPDATE

#ifdef DEBUG_DEC_UPDATE
void DebugDecUpdate(void);

#define OPT_LPBK_DEC 1
#define UNITY_DEC 2
#define CLEAR_DEC 3
#endif

// Freq weighting definitions
#define  UPDATE_GUARD_BITS    4        // maximum = log2(s_err_len);
#define  FREQWTFILT_GUARD_BITS   5     // maximum = LOG2_FREQWT_FILTER_LEN
#define  FREQWT_FILTER_LEN2      81    // filter_len/2 + 1  (symmetric filter)
#define FREQWT_FILTER_SHIFT      15    // The filter is in 1.15 format

#endif //_DEC_ADAPT_H      Do not add anything below this line.
