/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2006 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
#ifndef _DETECT_SIGNAL_H_
#define _DETECT_SIGNAL_H_

/*
 *------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Confidential.
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413
 *   Phone (781) 276 - 4000
 *   Fax   (781) 276 - 4001
 *
 *   DetectSignalHandler.h
 *
 *   This file declares the function prototypes from DetectSignalHandler.c
 *
 *------------------------------------------------------------------------
 */

// Signal detection state machine states
#define DETECT_SIGNAL_INIT             (0)
#define DETECT_SIGNAL_INIT_PER_BAND       (1)
#define DETECT_SIGNAL_WAIT_FOR_HW_SET     (2)
#define DETECT_SIGNAL_SILENCE          (3)
#define DETECT_SIGNAL_ONSET_INIT_PER_BAND (4)
#define DETECT_SIGNAL_ONSET_WAIT_FOR_HW_SET  (5)
#define DETECT_SIGNAL_ONSET               (6)
#define  DETECT_SIGNAL_DONE               (7)

//Constants used in DetectSignalHandler()
#define LOG2_NUM_FRAMES_FOR_SILENCE_EST   (5)   //log2 # of frames to estimate silence power
#define NUM_FRAMES_FOR_SILENCE_EST     (1<<LOG2_NUM_FRAMES_FOR_SILENCE_EST)
#define NUM_NONSILENCE_SYMBOLS_THRESH  (32)
#define SIG_POW_THRESH_SCALE        (4)
#define MIN_SIG_POW_THRESH          (200)

// function prototype
void DetectSignalHandler(void);

#endif   // _DETECT_SIGNAL_H_
