/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/**********************************************************************************************

**********************************************************************************************/
#ifndef DSH_INTERFACE_H
#define DSH_INTERFACE_H


#include "DshStreamAndEventDefines.h"
#include "typedef.h"

#define SIZE_STRYMON_REG_DUMP 22
/// Structure of a single debug stream queue entry
typedef struct _DSH_QueueEntry_t{
   /// Stream ID of the Debug Stream
   uint16 us_Id;
   /// debug stream counter
   uint16 us_Status;
   /// the size of the debug data
   uint16 us_Size;
   /// Number of bytes to be left for sending
   uint16 us_Length;
   /// a CRC16 over the stream's data
   uint16 us_Crc;
   /// global time stamp
   uint32 ul_SymCount;
   /// should point to global payload which should exist until msg is actually sent out.
   uint16 * p_Data;
   /// the callback function to be called after the stream has been sent. Might be 0 for "no callback"
   void (*Func)(P_DSH_Statics, P_DSH_QueueEntry);
} DSH_QueueEntry_t;


/// DSH channel statics
typedef struct _DSH_Statics_t
{
   /// The flag indicates the background handler to dispatch the last stream from queue
   FlagT ft_CleanUpLastStream;
   /// Write index into debug stream queue
   int8 c_QueueWrIdx;
   /// Read index into debug stream queue
   int8 c_QueueRdIdx;
   /// Fill level of debug stream queue
   int8 c_QueueFill;
    /// stream counter
   uint8 c_StreamNum;

   /// The debug stream queue
   DSH_QueueEntry_t ta_Queue[DSH_QUEUE_DEPTH];

   FlagT ft_Overflow;
   FlagT ft_BufferFlush;
   uint8 uca_Buffer[DSH_BUFFER_SIZE];
   int16 s_BufferWrIdx;
   int16 s_BufferRdIdx;
   int16 s_BufferFill;

} DSH_Statics_t;


// DSH Background state
typedef struct
{
   uint16 us_Handle;
   uint16 us_TxState;
   uint16 us_RxState;
   uint16 us_QueueDepth;
   uint16 us_SymbolCnt;
   uint16 us_Padding;
   uint32 ul_TotalSymbolCnt;
}DSH_BgState_t;


// Struct to report Fsm State
typedef struct
{
   uint32 ul_FsmState;
   int16 gsa_IndirectStat0;
//   uint16 us_PowerState; can be used to indicate the power states: L0 = show time, L2 = low power mode, L3 = not show time
} DSH_ModemFsmState;


// For debugging PLL
typedef struct {
   int8 gft_EnablePLL;
   int16 gs_PhaseError;
   int32 gl_pll_freq_offset;
   int32 gl_pll_loopfilter_out;
} DebugPLL_t;

// XDSLRTFW-3280 - Start - PLL improvement / pilot tone selection improvement
// For debugging MulitPilot
typedef struct {
   int16 s_PilotToneIdx0_Re;
   int16 s_PilotToneIdx0_Im;
   int16 s_PllRefToneIdx0_Re;
   int16 s_PllRefToneIdx0_Im;
   int16 gs_PhaseErrorIdx0;
   int16 s_PilotToneIdx1_Re;
   int16 s_PilotToneIdx1_Im;
   int16 s_PllRefToneIdx1_Re;
   int16 s_PllRefToneIdx1_Im;
   int16 gs_PhaseErrorIdx1;
   int16 s_PilotToneIdx2_Re;
   int16 s_PilotToneIdx2_Im;
   int16 s_PllRefToneIdx2_Re;
   int16 s_PllRefToneIdx2_Im;
   int16 gs_PhaseErrorIdx2;
} DebugPilot_t;
// XDSLRTFW-3280 - Start - PLL improvement / pilot tone selection improvement

/// data type used as mask entry.
/**
    The number of bits are (sizeof(DSH_MaskEntry_t) << 3)
*/
typedef uint32 DSH_MaskEntry_t;


/// DTI background handler, called by event system
/**
   If the queues fill level is other than 0 the next entry indicated by the queue's read index
   is sent. If the stream exceeds the payload size of the mailbox system it is fragmented into
   several messages. To keep track of the fragments the status and length information of the entry
  is updated in the queue. Same applies to the data pointer. Once it's done the read index is
   incremented.

   @return A non zero value will tell the background thread to schedule the service again.

*/
extern void DSH_BgService( void );

extern void DSH_FgService( void );


/**
   Send small pieces of data as one buffered stream. This is not a feature to stream
   large data. A typical size of data is around a few bytes only.

   @param uc_EventId      use one of DSH_EVT_
   @param uc_BlockSize    the number of bytes to read
   @param p_Data          pointer to data

   @return 0 on success, -1 on error
*/

extern int32 DSH_SendEvent(uint8 uc_EventId, uint8 uc_BlockSize, void * p_Data);

/// Add a debug message to the queue
/**
   Add a debug stream to the handler. The request might be skipped if the stream id's mask bit is not set.
   In this case the function returns successfull but it won't stream the data.
   Checks whether the requested stream is enabled for the current channel or corresponds to the IPTC debug stream data forwarding function
   and then add the stream data to the debug stream handlers queue. If the debug handlers queue is full
   an autonomuous message "HMH_EVT_DBG_BUFFER_OVERFLOW" is send to the host and the function
   returns with error code "-1" without adding data to the queue.

   @note The stream's data memory is owned by the caller. The DSH module and the subsequent HMH module will only
           share a pointer to the memory. Thus if the caller overwrites the memory befor it has been sent by
           the HMH module, the stream will be corrupted.

   @note For future notice: To make debug streaming corruption safe it would need to copy the memory chunk
           between DSH and HMH module. As debug streaming wasn't safe in the past (Vinax Rev2) it was decided
           to save the work and the resources to make it safe. If corrupt debug streaming ever becomes
           a problem in the future take this notice as a point to start.

   @note      Stream Id "DSH_IPTC_DBG_DATA_FORWARD" is treated special - the stream Id is not checked against the stream enable mask in
                  tCmdDbgDebugStreamConfigure and against the channels global debug stream enable mask - it is always forwarded to the host.
                  This fulfills the requirements for IPTC Debug stream forwarding which contains debug stream data for all channels of the data processing slice
                  and shall therefore happen transparently regardless of this channels stream enable mask.

   @param us_StreamID     one of the above defined IDs
   @param uc_BlockSize    length of debug stream data in bytes
   @param p_Data        pointer to debug stream data

   @return StreamNum+1, or 0 if debug streams on this channel are globally disabled or if the data could be successfully queued in, -1 if the queue is full
*/

int32 DSH_SendStream(uint16 us_StreamID, uint16 uc_BlockSize, void * p_Data);

#endif //DSH_INTERFACE_H
