/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/**********************************************************************************************

**********************************************************************************************/
#ifndef DSH_STREAMANDEVENTDEFINES_H
#define DSH_STREAMANDEVENTDEFINES_H

//======================



//=========================================================================
// Common Defines
//=========================================================================
#define DSH_PROTOCOL_VERSION 0x4000

// number of bytes in buffer befor a stream message is sent.
#define DSH_BUFFER_FILL_THRESHOLD  200
/// size of debug stream queue
#define DSH_QUEUE_DEPTH            18
/// size of the byte buffer to hold buffered streams
#define DSH_BUFFER_SIZE            370
#define MAX_MAILBOX_PAYLOAD_LENGTH 256

/// maximum number of debug stream ids.
/**
    Must be a multiple of T_DSH_MaskEntry's number of bits as each id is represented as a bit.
*/
#define DSH_CTRL_MAX_NUM             160



#define DSH_EVENT_DBG_STR           0x0001
#define DSH_EVENT_EVT_BUF           0x0002
#define DSH_EVENT_HEADER_SIZE 6

/// mask for debug stream source for Tracee to differentiate between CPE CO debug streams
#define DSH_STREAM_MASK             0x0C00
/// Stream coming from CO
#define DSH_STREAM_SOURCE_CO        0x0000
/// Stream coming from CPE
#define DSH_STREAM_SOURCE_CPE       0x0400
/// Stream coming from whatever (reserved for future)
#define DSH_STREAM_SOURCE_WHATEVER  0x0800
/// this flag is set when the stream's payload had to be padded by one byte to have an even size.
#define DSH_STREAM_SIZE_IS_ODD      0x1000
/// Overflow in debug stream queue
#define DSH_OVERFLOW_INDICATION     0x2000
/// Next fragment of debug stream data
#define DSH_NEXT_FRAGMENT           0x0000
/// first fragment of debug stream data
#define DSH_FIRST_FRAGMENT          0x4000
/// last fragment of debug stream data
#define DSH_LAST_FRAGMENT           0x8000
/// mask for fragment bits in debug stream status field
#define DSH_MASK_FRAGMENT           0xC000


//=========================================================================
// Stream IDs
//=========================================================================

/* Debug Streams: VDSL2 SOC Message Subtypes */

//******************************************************************************
// Common Streams for CPE & CO but mainly intended for ADSL!!! (0x0000 - 0x0031)

//******************************************************************************

/** A macro state change happened. For ADSL1, ADSL2/2+, VDSL */
#define DSH_FSM_STATE                0x0001
/** This stream holds all kind of short data that needs buffering,
    e.g. state and substate changes, G.HS messages...
    For ADSL1, ADSL2/2+, VDSL */
#define DSH_STATE_TRAIL              0x0002
/** AFE register dump. */
#define DSH_AFE_REGISTERS            0x0003


/** For VDSL */
/** log outgoing OHC TX messages, both commands and responses */
#define DSH_OCH_TX_MESSAGES          0x0030
/** log incoming OHC RX messages, both command sand responses */
#define DSH_OCH_RX_MESSAGES          0x0031


//*************************************************************************************
// CO non-standard Streams !!! DO NOT USE ANY OF THESE STREAM IDs !!! (0x0032 - 0x0050)
//*************************************************************************************

// DO NOT ADD STREAMS IN THIS STREAM ID RANGE



//*************************************************************************************
// CPE non-standard Streams  Feel free to add streams with these IDs  (0x0051 - 0x006E)
//*************************************************************************************

// Feel free to add streams in this stream id range
/** Channel Discover SNR */
#define DSH_CD_SNR                   0x0051
/** Transceiver Training SNR */
#define DSH_TRTR_SNR                 0x0052
/** Medley SNR */
#define DSH_VDSL2_MEDLEY_SNR         0x0053
/** Showtime SNR */
#define DSH_SHOWTIME_SNR             0x0054
/** Channel Discover Receive PSD */
#define DHS_RX_PSD                   0x0055
/** US PSD related: gt_TxPsdControl*/
#define DSH_TX_PSD_CONTROL           0x0056
/** US PSD related: pt_MaxPsdDescIn */
#define DSH_MAX_PSD_DESC_IN          0x0057
/** US PSD related: pt_ActPsdDescOut */
#define DSH_Max_PSD_DESC_OUT         0x0058
/** Strymon register dump */
#define STRYMON_CONF                 0x0059
/** DS Ceiling values  **/
#define DSH_PROPOSED_CEILING_DS      0x005A
/** Hybrid metric  **/
#define DSH_HYBRID_METRIC            0x005B
/** Quiet line Noise */
#define DSH_QLN                      0x005C
/** HLOG */
#define DSH_HLOG                     0x005D
/** ADC Noise */
#define DSH_QLN_PSD_DB               0x005E
/** ADC Noise */
#define DSH_ADC_NOISE_PSD            0x005F
/** Debug vars for OP_Vect1 detector e.g Trace gl_MaxEnergy, l_NoisPwrAcc and gs_AlignmentOffset **/
#define OP_VECT1_DETECT_DBG          0x0060
/** Debug vars for OP_Vect1 alignment */
#define OP_VECT1_ALIGNMENT_DBG       0x0061
/** @todo add description  **/
#define OP_VECT1_DETECT_DBG2         0x0062
/** @todo add description  **/
#define OP_VECT1_EXIT_DBG            0x0063
/** gpsa_IlvDbgBuffer dump */
#define DSH_ILV_DBG_BUFFER_PLL       0x0064
/** @todo add description  **/
#define OP_SYNCHROV1_TRACE           0x0065
/** DS Framer **/
#define DSH_DS_FRAMER                0x0066
/** DS Data rate in LP0 and LP1 computed from the Framer  **/
#define DSH_DS_DATA_RATE             0x0067
/** Complete pilot tone array and config **/
#define DSH_PILOT_TONE_ARRAY         0x0068
/** Skipped switching to new pilot tone **/
#define DSH_SKIP_PT_SWITCHING        0x0069
/** RxPathCompensation */
#define DSH_RX_PATH_COMP_DB          0x006A


//***************************************************************************************
// CPE & CO standard Streams - Feel free to add streams with these IDs  (0x006F - 0x009F)
//***************************************************************************************

// Only intended for streams which are standardized and can be used by CO & CPE e.g. SOC messages

/** O-ACK, for VDSL2 */
#define DSH_O_ACK                    0x0080
/** O-SIGNATURE, for VDSL2 */
#define DSH_O_SIGNATURE              0x0081
/** O-UPDATE, for VDSL2 */
#define DSH_O_UPDATE                 0x0082
/** O-MSG1, for VDSL2 */
#define DSH_O_MSG1                   0x0083
/** O-PRM, for VDSL2 */
#define DSH_O_PRM                    0x0084
/** O-TA-UPDATE, for VDSL2 */
#define DSH_O_TA_UPDATE              0x0085
/** O-TPS, for VDSL2 */
#define DSH_O_TPS                    0x0086
/** O-PMS, for VDSL2 */
#define DSH_O_PMS                    0x0087
/** O-PMD, for VDSL2 */
#define DSH_O_PMD                    0x0088
/** O-PRM-LD,For VDSL2 */
#define DSH_O_PRM_LD                 0x0089
/** O-MSG-LD,For VDSL2 */
#define DSH_O_MSG_LD                 0x008A
/** O-REPEAT_REQUEST, for VDSL2 */
#define DSH_O_REPEAT_REQUEST         0x008B
/** O-ACK_SEG, for VDSL2 */
#define DSH_O_ACK_SEG                0x008C
/** R-ACK, for VDSL2 */
#define DSH_R_ACK                    0x0090
/** R-MSG1, for VDSL2 */
#define DSH_R_MSG1                   0x0091
/** R-UPDATE, for VDSL2 */
#define DSH_R_UPDATE                 0x0092
/** R-MSG2, for VDSL2 */
#define DSH_R_MSG2                   0x0093
/** R-PRM, for VDSL2 */
#define DSH_R_PRM                    0x0094
/** R-TA-UPDATE, for VDSL2 */
#define DSH_R_TA_UPDATE              0x0095
/** R-TPS-ACK, for VDSL2 */
#define DSH_R_TPS_ACK                0x0096
/** R-PMS, for VDSL2 */
#define DSH_R_PMS                    0x0097
/** R-PMD, for VDSL2 */
#define DSH_R_PMD                    0x0098
/** R-PRM-LD,For VDSL2 */
#define DSH_R_PRM_LD                 0x0099
/** R-MSG-LD,For VDSL2 */
#define DSH_R_MSG_LD                 0x009a
/** R-ERROR-FEEDBACK,For VDSL2, Vectoring */
#define DSH_R_ERROR_FEEDBACK         0x009b
/** R-REPEAT_REQUEST, for VDSL2 */
#define DSH_R_REPEAT_REQUEST         0x009c
/** R-ACK-SEG, for VDSL2 */
#define DSH_R_ACK_SEG                0x009d

/** send content of  tMTK_AckVersionInfoGet. This stream is always on.*/
#define DSH_VERSION_INFO             0x009F
/** @} */ /* _DEBUG_STREAMTYPE_DEF_ */



//=========================================================================
// Event IDs
//=========================================================================

// Common event IDs, only add IDs which are applicable for CO and CPE (0/0x0000 - 63/0x003F)

#define DSH_EVT_SYM_CNT_ZERO                0x0000
#define DSH_EVT_STATE_CHANGE                0x0001
#define DSH_EVT_SUB_STATE_CHANGE            0x0002
#define DSH_EVT_LOS                         0x0003
#define DSH_EVT_NLOS                        0x0004
#define DSH_EVT_MIN_USMARGIN                0x0005
#define DSH_EVT_EXCEPTION                   0x0006
#define DSH_EVT_CONSECUTIVE_US_CRC8         0x0007
#define DSH_EVT_GHS_RX                      0x000A
#define DSH_EVT_GHS_TX                      0x000B
#define DSH_EVT_OLR_DS_STATS                0x000C
#define DSH_EVT_OLR_US_STATS                0x000D
#define DSH_EVT_OLR_CO_REJECTED_US_BS       0x000E
#define DSH_EVT_OLR_CO_REJECTED_DS_BS_BUSY  0x000F
#define DSH_EVT_OLR_STATISTICS              0x0010
#define DSH_EVT_DSM_TX_MSG                  0x0011
#define DSH_EVT_DSM_RX_MSG                  0x0012
#define DSH_EVT_OCH_BYTEPOOL                0x0013
#define DSH_EVT_APS_DATA                    0x0014
#define DSH_EVT_TX_PHASE_REVERSAL           0x0015
#define DSH_EVT_RX_PHASE_REVERSAL           0x0016
#define DSH_EVT_RX_IBIT_CHANGE              0x0017
#define DSH_EVT_TX_IBIT_CHANGE              0x0018
#define DSH_EVT_ERB_L2_DATA                 0x0019
#define DSH_EVT_BGTASK_INFO                 0x001A

//*************************************************************************************
// CO Only Events!!! DO NOT USE ANY OF THESE STREAM IDs !!! (64/0x0040 - 95/0x005F)
//*************************************************************************************

// DO NOT ADD EVENTS IN THIS ID RANGE


//*************************************************************************************
// CPE Only Events!!! DO NOT USE ANY OF THESE STREAM IDs !!! (96/0x0060 - 63/0x007E)
//*************************************************************************************

// Feel free to add streams in this stream id range

/** PGA reconfiguration values  **/
#define DSH_EVT_PGA_RECONFIGURE            0x0060  // This debug stream is not used in VRX518, but the ID is blocked, since decoding script for VR9/VRx318 exist
/** @todo add description  **/
#define DSH_EVT_PLL_STATE                  0x0061
/** Debug info for bitswap algo fail **/
#define DSH_EVT_BITSWAP_ALGO_FAIL          0x0062
/** @todo add description  **/
#define DSH_EVT_ABANDON_OLR                0x0063
/** OP_VECT1_DEBUG Trace REVERB and SEGUE decision for O_P_SYNCHRO_V1 detection **/
#define DSH_EVT_OP_VECT1_ALIGNMENT_DBG     0x0064
/** @todo add description  **/
#define DSH_EVT_NOSYNCSYM_ENGY_CNT         0x0065
/** PGA reconfiguration values for VRX518 **/
#define DSH_EVT_PGA_RECONFIGURE_VRX518     0x0066
/** @todo add description  **/
#define DSH_EVT_START_COUNTER              0x0067
/** @todo add description  **/
#define DSH_G997_FAIL_OCCURED              0x0068
/** Hybrid setting to be tested during Hybrid training  **/
#define DSH_EVT_HYBRID_SETTING             0x0069
/** Hybrid metric  **/
#define DSH_EVT_HYBRID_METRIC              0x006A

/** Codeswap request issue */
#define DSH_EVT_CODESWAP_ISSUE             0x006C

// Debug code to analyze codeswap requests (commented out by default in order to avoid flooding Tracee with events which are only required for specific debugging)
/** Codeswap request added */
//#define DSH_EVT_CODESWAP_ADDED             0x006D
/** Codeswap request executed */
//#define DSH_EVT_CODESWAP_EXECUTED          0x006E
/** Mailbox busy notification */
//#define DSH_EVT_MAILBOX_BUSY               0x006F

/** @todo add description  **/
#define DSH_EVT_CPE_SYM_ZERO_DEBUG         0x0070
/** @todo add description  **/
#define DSH_EVT_QTRX_NOT_DONE              0x0071
/** @todo add description  **/
#define DSH_EVT_RXQTP_NOT_DONE             0x0072
/** All 3 pilot tones  **/
#define DSH_EVT_PILOT_TONES                0x0073
/** Max cycles for phase error calculation **/
#define DSH_EVT_PLL_Cycles                 0x0074

/****************************************************************************************************************************/


#ifdef ILV_DBG_BUFFER
//*************************************************************************************
// Interleaver Debug Buffer related variables and defines
//*************************************************************************************
#define ILV_DBG_BUFFER_SIZE   16384    //16kByte
#define ILV_DBG_MAX_PARAMETER     8    //limit amount of debug variables to avoid MIPS overflow

// Debug content selector defines
#define ILVDBG_PLL_ANYLYSIS                   0x0001
#define ILVDBG_OP_VECT1_DETECT_DBG            0x0002
#define ILVDBG_OP_VECT1_ALIGNMENT_DBG         0x0004
#define ILVDBG_VEC_DEBUG_TRACE_OPSYNCHROV1    0x0008
#endif ILV_DBG_BUFFER


#endif DSH_STREAMANDEVENTDEFINES_H
