/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2008 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
#ifndef _GENFRAMINGPARAMS_VDSL2_H
#define _GENFRAMINGPARAMS_VDSL2_H

/*******************************************************************************
*
*  Aware DMT Technology. Proprietary and Confidential.
*
*  40 Middlesex Turnpike, Bedford, MA 01730-1413
*  Phone (781) 276 - 4000
*  Fax   (781) 276 - 4001
*
*  filename: GenFramingParams_VDSL2.h
*
*******************************************************************************/

//==========================================================
// Function Prototype
//==========================================================
extern int16 GetFramingParamsInput(void);

// Main function to be called from other module
extern FlagT FormVDSL2FramingParams(VDSL2FramingParamsInputs_t *pt_Input, VDSL2Config_t *pt_Output);

    FlagT FormVDSL2FramingParamsRetx(VDSL2FramingParamsInputs_t *pt_Input, VDSL2Config_t *pt_Output);

   FlagT RtxFramingVdsl_V1_OhcCalc(VDSL2Config_t *pt_Output);
   FlagT RtxFramingVdsl_V1(uint32 ul_LpAvailable, VDSL2Config_t *pt_Output);
   int16 GetMaxDtuSizePerProfile(int16 s_Direction);
   //XDSLRTFW-3493(Start)
   FlagT RtxFramingVdsl_V3(uint32 ul_LpAvailable, VDSL2Config_t *pt_Output);
   //XDSLRTFW-3493(End)

   int16 coprimecheck(int16 a,int16 b);
   int16 ceil16(int16 s_num, int16 s_den);
   int32 ceil32(int32 l_num, int16 s_den);
   uint32 ceil32u(uint32 Num, uint16 Den);

   void CheckVDSL2RetxFramingParams(void);

   void SetInputFramingParameters(void);

// Helper functions
extern void Find_MinORMax_Of2Fractions(FlagT ft_FindMAX, uint16 *pus_Result_numer, uint16 *pus_Result_denom, uint16 us_Y_numer, uint16 us_Y_denom);
extern void FindAlphaPlusOther(uint16 *pusa_alpha_numer, uint16 *pusa_alpha_denom, uint16 *pus_alphaplus_other_numer, uint16 *pus_alphaplus_other_denom);
extern void FindAlphaMinusOther(uint16 *pusa_alpha_numer, uint16 *pusa_alpha_denom, uint16 *pus_alphaminus_other_numer, uint16 *pus_alphaminus_other_denom);

extern void FindAlphaMinusFinal(uint16 *pus_alphaminus_numerator, uint16 *pus_alphaminus_denominator,
                        uint16 *pus_alphaminus_other_numer, uint16 *pus_alphaminus_other_denom,
                        uint16 *pus_alphaminus_mindelay_numer, uint16 *pus_alphaminus_mindelay_denom);

extern void FindAlphaPlusFinal(uint16 *pus_alphaplus_numerator, uint16 *pus_alphaplus_denominator,
                        uint16 *pus_alphaplus_other_numer, uint16 *pus_alphaplus_other_denom,
                        uint16 *pus_alphaplus_maxdelay_numer, uint16 *pus_alphaplus_maxdelay_denom);

extern int16 CheckCoPrime(int16 s_D, int16 s_CWSize);

//XDSLRTFW-1619: VDSL_CI_Policy1_2 (Start/End)
FlagT CiPolicyOneMaximizeINP(VDSL2FramingParamsInputs_t *pt_Input );

//==========================================================
// Constant Definitions
//==========================================================
// Constants used in PERBp computation
#define QMAX           17000
#define DR0             7880

#define QMAX_35B      (QMAX<<1)
#define DR0_35B       (DR0<<1)

// Deinterleaver size limit (governs CWSize and Dp)
#define DILV_MEM_SIZE   34048

// In fixed rate test, standard allows a lee-way of +8kbps
#define FIXRATE_LEEWAY  8

// Min/Max PERp as defined by the Standard
#define MIN_PER         0
#define MAX_PER         20

// Min/Max Gp as defined by the Standard
#define MIN_G           1
#define MAX_G           32

// Max Tp as defined by the Standard
#define MAX_T           64

// Min/Max Rp as defined by the Standard
#define MIN_R           0
#define MAX_R           16

// Min/Max Mp as defined by the Standard
#define MIN_M           1
#define MAX_M           16

// Min/Max CWSize as defined by the Standard
#define MIN_CWSIZE      1
#define MAX_CWSIZE      255

// Search range for Dp = 34/2
#define D_SEARCH_RANGE  (17)

//XDSLRTFW-1619: VDSL_CI_Policy1_2 (Start)
/**  Maximize the net data rate and minimize the excess margin with respect to
     the maximum noise margin MAXSNRM through gain scalings.*/
#define MAX_NETRATE 0x0

/**  Maximize the net data rate and minimize the excess margin with respect to
     the maximum noise margin MAXSNRM through INP increase*/
#define MAX_INP 0x1

/**  Maximize the net data rate and if equal to the maximum net data rate,
     maximize SNRM for the bearer channel. Minimize the excess margin with respect
     to the maximum noise margin MAXSNRM through gain scalings. */
#define MAX_NETRATE_THEN_SNRM 0x2
//XDSLRTFW-1619: VDSL_CI_Policy1_2 (End)

// Error/Status code for FormVDSL2FramingParams()
#define VDSL2FRAMEPARAMGEN_ERR_INVALID_MININP            (0x0001)
#define VDSL2FRAMEPARAMGEN_ERR_MINRATE_GT_MAXRATE        (0x0002)
#define VDSL2FRAMEPARAMGEN_ERR_MAXRATE_BELOW_32KBPS         (0x0004)
#define VDSL2FRAMEPARAMGEN_ERR_INVALID_MINMSGOHR         (0x0008)
#define VDSL2FRAMEPARAMGEN_ERR_INVALID_MAXMSGOHR         (0x0010)
#define VDSL2FRAMEPARAMGEN_ERR_DMAX_GT_4096              (0x0020)
#define VDSL2FRAMEPARAMGEN_ERR_1OVERSMAX_TOO_BIG         (0x0040)
#define VDSL2FRAMEPARAMGEN_ERR_MINDELAY_GT_MAXDELAY         (0x0080)
#define VDSL2FRAMEPARAMGEN_ERR_INVALID_MAXDELAY          (0x0100)
#define VDSL2FRAMEPARAMGEN_ERR_BC0_DISABLE               (0x0200)
#define VDSL2FRAMEPARAMGEN_ERR_BC1_ENABLE             (0x0400)
#define VDSL2FRAMEPARAMGEN_ERR_INPUT_CONSTRAINT_NOT_FEASIBLE (0x0800)
#define VDSL2FRAMEPARAMGEN_ERR_CHANNEL_CAPACITY_CALC     (0x1000)

#endif _GENFRAMINGPARAMS_VDSL2_H
