/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2003 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
#ifndef _HDLC_H
#define _HDLC_H

/**********************************************************************
 *
 * Aware DMT Technology. Proprietary and Confidential.
 *
 * ADDRESS:          40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 * TELEPHONE:        781.276.4000
 * FAX:              781.276.4001
 * WEB:              http://www.aware.com
 *
 * FILE:             HDLC.h
 * DESCRIPTION:      Header file for HDLC.c
 *
 **********************************************************************/

#include "typedef.h"

//TxHDLCMsgHandler states
#define HDLC_TX_START_NEW_MSG       (1)
#define HDLC_TX_MSG_INDEX           (2)
#define HDLC_TX_SEGM_INDEX          (3)
#define HDLC_TX_PAYLOAD             (4)
#define HDLC_TX_FCS_OCTET1          (5)
#define HDLC_TX_FCS_OCTET2          (6)
#define HDLC_TX_CLOSING_FLAG        (7)
#define HDLC_TX_CLOSING_FLAG_DONE   (8)
#define HDLC_TX_WAIT_ACK_SEG     (9)

//RxHDLCMsgHandler states
#define RX_HDLC_MSG_DECODE_MSG_INIT                 (0)
#define RX_HDLC_MSG_DECODE_DEMODULATE_MSG           (1)
#define RX_HDLC_MSG_DECODE_CHECK_MSG_FCS            (2)
#define RX_HDLC_MSG_DECODE_INTERPRET_MSG            (3)
#define RX_HDLC_MSG_DECODE_LEAVE_TRAIL              (4)
#define RX_HDLC_MSG_DECODE_IDLE                     (5)

#define SOC_MAX_NUM_MSG_SEGMENTS      (15)
#define SOC_MAX_MSG_SEGMENT_SIZE      (1024)
#define SOC_MAX_MSG_SEGMENT_35B_SIZE  (2048)

// HDLC message (frame):
//     - SOC segment/payload bytes: 1 to 1024 or 2048
//     - 4 header bytes:            Address(1) + Control(1) + FCS(2)
#define HDLC_MIN_MSG_LENGTH            (5)
#define HDLC_MAX_MSG_LEN               (SOC_MAX_MSG_SEGMENT_SIZE+2+2)
#define HDLC_MAX_MSG_LEN_35B           (SOC_MAX_MSG_SEGMENT_35B_SIZE+2+2)

// MAX_HDLC MSG_bytes, i.e. (SOC payload + header) for the max number of SOC segments.
// Note: The max SOC msg length is without HDLC header protocoll overhead bytes!
//       First the plain HDLC frames get be stored before per segment the overhead bytes
//       get removed by an inpalce buffer operation.
#define MAX_MSG_LEN                    (HDLC_MAX_MSG_LEN * SOC_MAX_NUM_MSG_SEGMENTS)

#define HDLC_FLAG                      (0x7E)

// HDLC FIFO attributes.
typedef struct {
    uint8  *puca_OctetBuffer;   /* pointer to octet buffers */
    int16  s_CurFIFODepth;
    int16  s_MaxFIFODepth;
    int16  s_PreFIFODepth;
    uint8  uc_PreSegmentIdx;
    uint8  uc_NumOfSegments;
    int16  sa_SegmentLength[SOC_MAX_NUM_MSG_SEGMENTS];
    int16  s_StartFlag;     //Flag to search for the beginning/end of HDLC frame
} HDLC_Fifo_attrib_t;

// HDLC FCS Error info
typedef struct {
    uint8 uc_LastGoodMsgCode;
    uint8 uc_MsgSegmentIdx;
    uint8 uc_NumMsgSegments;
   uint8 uc_Reserved;
} RxSocMsgFCSErrInfo_t;

/**********************************************************************
 * FUNCTIONS
 **********************************************************************/
void TxHDLCMsgHandler(void);
void RxHDLCMsgHandler(void);
void InitHDLCFifo(uint8 *puca_OctetBuffer, HDLC_Fifo_attrib_t *pt_FIFO);
uint8 GetNextHDLCTxOctet(uint8 *puc_HDLCPayload);

void ReceiveHDLCOctet(uint8 uc_octet, uint8 *puca_OctetBuffer, HDLC_Fifo_attrib_t *pt_FIFO);
void BkgdCheckRxHDLCMsgFCS(void);
int16 CheckRxHDLCMsgFCS(HDLC_Fifo_attrib_t *pt_FIFO) ;
int16 OctetTransparency(uint8 *puca_InBuf, int16 s_NumOfInBytes, uint8 *puca_OutBuf);
#endif // _HDLC_H

