/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2005 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   filename: MfdqHandler.h
*
*   Header file for MfdqHandler.c.
*
*-------------------------------------------------------------------------------
*/

#ifndef _MFDQHANDLER_H
#define _MFDQHANDLER_H

#define MFDQ_TRAIN_INIT          (0)
#define MFDQ_TRAIN_INIT_WAIT     (1)
#define MFDQ_TRAIN_HW_READY         (2)
#define MFDQ_TRAIN_READ_HW       (3)
#define MFDQ_TRAIN_ACCUM         (4)
#define MFDQ_TRAIN_ACCUM_WAIT    (5)
#define MFDQ_TRAIN_CALC_MFDQ     (6)
#define MFDQ_TRAIN_LOAD_MFDQ     (7)
#define MFDQ_TRAIN_DONE          (8)

#define MFDQ_YY_SHIFT            (26)
#define MFDQ_YE_SHIFT            (26)
#define MFDQ_YD_SHIFT            (13)
#define MFDQ_EE_SHIFT            (26)
#define MFDQ_ED_SHIFT            (13)
#define MFDQ_DD_SHIFT            (0)
#define MFDQ_MAX_UP_SCALE_SHIFT     (MFDQ_EE_SHIFT-2)

// MFDQ error code
#define MFDQ_NO_ERROR            (0x0000)
// errors which aborts the entire MFDQ computation
#define MFDQ_TONE_SELECT_FAIL    (0x0001)
#define MFDQ_ABORT_MASK          (0x000F)
// errors which occurs per tone basis and may not interfere other MFDQ computation
// set if there is more than one occurrence
#define MFDQ_UPSCALE_FAIL        (0x0100)
#define MFDQ_COEFF_OVFLOW        (0x0200)
#define MFDQ_COEFF_ADJ_OVFLOW    (0x0400)

void MfdqHandler(void);

#endif // _MFDQHANDLER_H
