/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2005 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
#ifndef _PGAHANDLER_H_
#define _PGAHANDLER_H_

/*
 *------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Confidential.
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413
 *   Phone (781) 276 - 4000
 *   Fax   (781) 276 - 4001
 *
 *   PGAHandler.h
 *
 *   This file declares the function prototypes from PGAHandler.c
 *
 *------------------------------------------------------------------------
 */
#include "typedef.h"

//VRX518_AFE ;target rms value
#define PD_DB        (0x49a9) // desired power of input signal
                              // = 10log10((2^15/6.8)^2) Q8.8 format
                              // = 73.66 dB

// No extra margin of 1.16dB has to be taken into account. It is rather a correction factor
// one need to consider to calculate the correct rms-value at ADC-in.
// So the digital value is 1.16dB lower than at ADC-out. If you want to compare to Full Scale value
// then you need to add 1.16dB to the measured value.
// The drawback of this asymmetry is not a required higher PGA-margin it rather means that we lose resolution.
#define PGA_ANALOG_MARGIN_TO_AVOID_DIGITAL_CLIPPING 0x129         // Q8.8 297

// PGA handler state machine states
#define PGA_INIT                    (1)
#define PGA_WAIT_CORNER_RAISE       (2)
#define PGA_WAIT_SET_UNITY_FILTER   (3)
#define PGA_WAIT_ADC_OVERFLOWS      (4)
#define PGA_CHECK_ADC_OVERFLOW      (5)
#define PGA_ACCURATE_TRAIN_START    (6)
#define PGA_CALC                    (7)
#define PGA_SET                     (8)
#define PGA_WAIT_RESTORE_CORNER     (9)
#define PGA_WAIT                    (10)
#define PGA_DONE                    (11)
#define PGA_CLEAR_OVERFLOW          (12)
#define PGA_RESET_PLL_REF           (13)

// PGA retrain states
#define PGA_RETRAIN_IDLE            (1)
#define PGA_RETRAIN_XMITTING        (2)
#define PGA_RETRAIN_FDQDONE         (3)


// PLL Reference Average
#define PLL_AVG_IDLE          (1)
#define PLL_AVG_ACCUM         (2)
#define PLL_AVG_DONE          (3)
#define PLL_AVG_PHASE_ERROR   (4)

// function prototype
void PGAHandler(void);
void BgAdjustQlnForPga(void);
uint32 InvDB(int16 dB);
void LoadRxVarGain();
void ComputePLLRefAvg(PT_ArrIdx_te PilotIdx, int16 *ps_real, int16 *ps_imag, uint16 us_NumSymbolsAvg, uint16 us_Log2_NumSymbolsAvg);


#endif   // _PGAHANDLER_H_
