/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2003 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
#ifndef _PSDHANDLER_H_
#define _PSDHANDLER_H_

/*
 *------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Confidential.
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413
 *   Phone (781) 276 - 4000
 *   Fax   (781) 276 - 4001
 *
 *   PsdHandler.h
 *
 *   This file declares the function prototypes from PsdHandler.c
 *
 *------------------------------------------------------------------------
 */
#include "typedef.h"

// PSD state machine states
#define PSD_INIT        (0)
#define  PSD_SETUP         (1)
#define PSD_WAIT_FOR_HW_SET   (2)
#define  PSD_ACCUM         (3)
#define PSD_NEXT_TONEGROUP  (4)
#define  PSD_ANALYSIS      (5)
#define  PSD_CALC_DONE     (6)

// PSD state machine calculation type
#define  PSD_CALC_TYPE_NOMSRDBUFF               (0x0) // do not overwrite the measured buffer (usually SNR buffer)
                                             // i.e., per-tone PSD will not be kept
                                             // This option is used in the PGA training
                                             // where the per-tone PSD is not needed

#define  PSD_CALC_TYPE_INITMSRDBUFF_AND_INC        (0x1) // init. the measured buffer to 0 and
                                             // then store per-tone PSD in the buffer
                                             // This option is used for the normal PSD calculation

#define  PSD_CALC_TYPE_ADDMSRDBUFF_AND_INC         (0x2) // do not init. the measured buffer
                                             // but add the newly computed per-tone PSD to the corresponding
                                             // value in the buffer
                                             // This option is used to compute the PSD-based SNR
                                             // Typically the per-tone QLN PSD is first computed and its nagated
                                             // value is first stored in the measured buffer
                                             // Then the PSD value of signal is added to the measured buffer
                                             // in per-tone basis

// function prototype
void PsdHandler(void);

#endif   // _PSDHANDLER_H_
