/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------------
*
*   Lantiq GmBH
*   Proprietary and Confidential.
*
*
*
*
*
*   filename: ShowtimeERBHandler.h
*
*   This file contains foreground (FG) functions for Vectoring ERB formation.
*
*-------------------------------------------------------------------------------
*/

/*
*-------------------------------------------------------------------------------
*
*  ShowtimeERBHandler.h
*   History
*
*
*
*  28/05/2013 Varun - Added the #define "MAX_DMA_BUSY_COUNT" so as define the maximum number of DMA try if busy
*  condition prevails for starting DMA in L2 nack Channel
*
*  Search for "XDSLRTFW-969 FEATURE_ALL_ALL_ALL_Debug_Buffer"
*
*-------------------------------------------------------------------------------
*/

#define FORM_ERB_DISABLE                              (0)
#define CONFIGURE_ERB                                 (1)
#define FORM_ERB_MAIN_HEADER                          (2)
#define FORM_ERB_VBB_DATA                             (3)
#define FORM_ERB_LAST_SEGMENT                         (4)
#define FORM_ERB_CRC                                  (5)
#define FORM_ERB_SET_BIT                              (6)
#define FORM_ERB_COMPLETION                           (7)
#define FORM_ERB_L2_BACKCHANNEL_HEADER_FOR_TESTING    (8)
#define FORM_ERB_L2_BACKCHANNEL_DATA_FOR_TESTING      (9)  // XDSLRTFW-2548
#define FORM_ERB_L2_WAIT                              (10)
#define FORM_ERB_L2_TRIGGER_DMA                       (11)
#define FORM_ERB_L2_SET_BIT                           (12)

#define OCTET_INCREMENT_FLAG                       0x0100
#define SET_OWNER_BIT_ERB_DESCRIPTOR               (0x80000000)      // XDSLRTFW-3567 (Start_End)

#define ERB_DMA_STATE_0_IDLE                       (0)
#define ERB_DMA_STATE_1_CONFIGURE_DMA              (1)
#define ERB_DMA_STATE_2_TRIGGER_DMA                (2)
#define ERB_DMA_STATE_3_TRIGGERED_DMA              (3)

// States in showtime
// EOC_ERB_TRANSMISSION_STATE
//    0: ST_ERBS_OFF                      : ERB are turned off
//    1: GET_NEW_ST_ERB_CONFIGURATION     : ERB parameters are being calculated:
//    2: ST_ERBS_ON                       : ERBs are on and valid parameters are available
#define ST_ERBS_OFF                          (0)
#define GET_NEW_ST_ERB_CONFIGURATION         (1)
#define ST_ERBS_ON                           (2)

void ShowtimeErbHandler (void);
void Reverse_Packet(void);
uint16 PackBitsInByteBufferST(uint8 *pt_OutputBufferCurrentIndex,uint8 *pt_OutputBufferCurrentIndex1,  int16 s_Value, uint8 uc_WordLength,
                          uint8 uc_CurrentPosition);
