/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2006 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
#ifndef _SNR_FRAME_ALIGN__HANDLER_H_
#define _SNR_FRAME_ALIGN__HANDLER_H_

/*
 *------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Confidential.
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413
 *   Phone (781) 276 - 4000
 *   Fax   (781) 276 - 4001
 *
 *   SnrFrameAlignHandler.h
 *
 *   This file declares the function prototypes from SnrHandler.c
 *
 *------------------------------------------------------------------------
 */

#define SNR_BASED_FRAME_ALIGN_INIT                        (0)
#define SNR_BASED_FRAME_ALIGN_SAVE_ORIG_FDQ               (1)
#define SNR_BASED_FRAME_ALIGN_LOAD_TDQ                    (2)
#define SNR_BASED_FRAME_ALIGN_LOAD_RXVARGAIN              (3)
#define SNR_BASED_FRAME_ALIGN_ADJ_PRETDQ_FA               (4)
#define SNR_BASED_FRAME_ALIGN_RESET1                     (20)
#define SNR_BASED_FRAME_ALIGN_LOAD_FDQ                    (5)
#define SNR_BASED_FRAME_ALIGN_WAIT_FOR_HW_SET_LOAD_FDQ    (6)
#define SNR_BASED_FRAME_ALIGN_POSTTDQ_FA                  (7)
#define SNR_BASED_FRAME_ALIGN_SET                         (8)
#define SNR_BASED_FRAME_ALIGN_RESET                       (9)
#define SNR_BASED_FRAME_ALIGN_CALC_SNR                   (10)
#define SNR_BASED_FRAME_ALIGN_UPDATE                     (11)
#define SNR_BASED_FRAME_ALIGN_DONE                       (12)
#define SNR_BASED_FRAME_ALIGN_TRAIN_FDQ                  (13)


#define NUM_FRAME_REALIGNMENT_POINTS                    (17) // Needs to be a positive odd number.
#define FRAME_REALIGNMENT_STEP                          (30) // Needs to be >= 1.
#define FRAME_REALIGNMENT_STEP_8K_FFT_IFFT              (60) // Needs to be >= 1.
#define FRAME_REALIGNMENT_LOG2_NUM_SNR_TRAINING_SYMBOLS  (5) // reduced # of training symbols for SNR calculation within SnrFrameAlignHandler

// function prototype
void SnrFrameAlignHandler(void);
void SearchHighestSnrSum(void);
void AdjustFdqforTdq(void);

#endif // _SNR_FRAME_ALIGN__HANDLER_H_

