/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2005 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
#ifndef _REVERBSNR_B_DMT_H
#define _REVERBSNR_B_DMT_H

/**********************************************************************
 *
 * Aware DMT Technology. Proprietary and Confidential.
 *
 * ADDRESS:          40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 * TELEPHONE:        781.276.4000
 * FAX:              781.276.4001
 * WEB:              http://www.aware.com
 *
 * FILE:             ReverbSnr_b_DMT.h
 * DESCRIPTION:      Header file for ReverbSnr_b_DMT.c.
 *
 **********************************************************************/

/**********************************************************************
 * CONSTANTS
 **********************************************************************/
#define SNR_SIG_MANT       (0x5147) // 10*log10(2^27) in 8.8 format

#define CONST_GAIN_8192_DB    (0x2722) // 10*log10(8192) in 8.8 format

// gusa_ConstGainPow_dB(i) = 20*log10(const_gain_i/const_gain_2)
// see table 5 in QT spec
#define CONST_GAIN_POW2_DB    (0) // 10*log10(1) in 8.8 format
#define CONST_GAIN_POW3_DB    (0x04c5) // 10*log10(3) in 8.8 format
#define CONST_GAIN_POW4_DB    (0x06fd) // 10*log10(5) in 8.8 format
#define CONST_GAIN_POW5_DB    (0x0a00) // 10*log10(10) in 8.8 format
#define CONST_GAIN_POW6_DB    (0x0d38) // 10*log10(21) in 8.8 format
#define CONST_GAIN_POW7_DB    (0x1021) // 10*log10(41) in 8.8 format
#define CONST_GAIN_POW8_DB    (0x134b) // 10*log10(85) in 8.8 format
#define CONST_GAIN_POW9_DB    (0x162d) // 10*log10(165) in 8.8 format
#define CONST_GAIN_POW10_DB      (0x1954) // 10*log10(341) in 8.8 format
#define CONST_GAIN_POW11_DB      (0x1c34) // 10*log10(661) in 8.8 format
#define CONST_GAIN_POW12_DB      (0x1f5a) // 10*log10(1365) in 8.8 format
#define CONST_GAIN_POW13_DB      (0x2239) // 10*log10(2645) in 8.8 format
#define CONST_GAIN_POW14_DB      (0x255f) // 10*log10(5461) in 8.8 format
#define CONST_GAIN_POW15_DB      (0x283f) // 10*log10(10581) in 8.8 format

#define MIN_SNR_DB               (-3*256) // the minimum SNR value allowed (Q8.8)
#define OUT_OF_RANGE_SNR_PER_TONE   (0x8000) // special value for meaningless SNR (Q8.8)

/**********************************************************************
 * VARIABLES
 **********************************************************************/

/**********************************************************************
 * FUNCTIONS
 **********************************************************************/
void BgSnrCalc(void);
void SnrCalc(int32 *pla_NoisePower, int16 *psa_snr, int16 s_first_chan, int16 s_last_chan);

#endif /* _REVERBSNR_B_DMT_H */

