/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2003 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
#ifndef _TIMINGADVANCEHANDLER_H_
#define _TIMINGADVANCEHANDLER_H_

/*
 *------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Confidential.
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413
 *   Phone (781) 276 - 4000
 *   Fax   (781) 276 - 4001
 *
 *   TimingAdvance.h
 *
 *   This file declares the function prototypes from TimingAdvanceHandler.c
 *
 *------------------------------------------------------------------------
 */

// ***********************************************************************************************************
// TimingAdvanceHandler.h
//
// History
//
// 27/11/2012 Ram: Merged IOP fix corresponding to JIRA XDSLRTFW-458
//            Grep for: "XDSLRTFW-458: IOP_ALL_VDSL2_ALL_TACorrection"
//
// ************************************************************************************************************


#include "typedef.h"
#include "vdsl_compiler.h"

#define TIMING_ADVANCE_INIT                     (0)
#define TIMING_ADVANCE_CALCULATION              (1)
#define TIMING_ADVANCE_RESET                    (2)
#define TIMING_ADVANCE_WAIT                     (3)
#define TIMING_ADVANCE_GET_COUNTERS_FOR_TEST    (4)
#define TIMING_ADVANCE_CHECK                    (5)
#define TIMING_ADVANCE_DONE                     (6)

// Fix delay is introduced by the Tx/Rx filters.
// Example: 17a for VRx518
// - Rx_cic (FIR), Rx_wdf2, Rx_decim (FIR), Rx_SRC (FIR) and Rx_IIR -> direction analog to digital
// Rx_cic (FIR)     group delay = 6;     In/OutRate = 288MHZ     -> transform to IFFT = 35MHZ -> ceil(6/8)    =  1 IFFT sample
// Rx_wdf2          group delay = 4;     In/OutRate = 288/144MHZ -> transform to IFFT = 35MHZ -> ceil(4/4)    =  1 IFFT sample
// Rx_decim (FIR)  - group delay = 15.5;  In/OutRate = 144/72MHZ  -> transform to IFFT = 35MHZ -> ceil(15.5/4) =  4 IFFT sample
// Rx_SRC   (FIR)  - group delay = 24;    In/OutRate = 72/35MHZ   -> transform to IFFT = 35MHZ -> ceil(24/2)   = 12 IFFT sample
//                                                                                                             ----------------
//                                                                                                               18
// - Tx_IIR, Tx_SRC, Tx_Iterp1, Tx_Iterp2 and Tx_wdf2    -> direction digital to analog
// Tx_SRC     group delay = 24;          In/OutRate = 35/72MHZ   -> transform to IFFT = 35MHZ -> ceil(24/2)   = 12 IFFT sample
// Tx_Iterp1  group delay = 0;           In/OutRate = 72/72MHZ   -> transform to IFFT = 35MHZ -> ceil(0)      =  0 IFFT sample
// Tx_Iterp2  group delay = 23;          In/OutRate = 72/144MHZ  -> transform to IFFT = 35MHZ -> ceil(23/4)   =  6 IFFT sample
// Tx_wdf2    group delay = 4;           In/OutRate = 144/288MHZ -> transform to IFFT = 35MHZ -> ceil(4/8)    =  1 IFFT sample
//                                                                                                             ----------------
//                                                                                                               19
//                                                                                                             ----------------
//                                                                                                   total     = 37
// Note: Tx_IIR and Rx_IIR are variable and therefore done during runtime.
#define  TIMING_ADVANCE_TX_RX_PATH_DELAY_4KHZ                (37)   // Filter group delay without delay buffer for IIR and SCR
                                                                    // IFFT samples at 35MHz, i.e. 8192 IFFT.
#define  TIMING_ADVANCE_TX_RX_PATH_DELAY_4KHZ_35B_8K16K_FFT  (3)    // Filter group delay without delay buffer for IIR and SCR
                                                                    // IFFT samples at 35MHz, i.e. 8192 IFFT.
#define  TIMING_ADVANCE_TX_RX_PATH_DELAY_8KHZ               (152)   // not being measured yet

// It is suggested to choose an initial value that corresponds to a loop length of 1500 m.
// Note: "Initial value of timing advance" indicates the initial timing advance, and
//        - shall be expressed either in multiples of 2 samples if profile 35b is used with extended IDFT Size or
//        - in samples
//       at the UPSTREAM sampling rate corresponding to the IDFT size communicated during the ITU-T G.994.1 handshake phase.
//       Therefore, it is not allowed to use an odd value in case the upstream is running with the extended IDFT Size (i.e. 16k FFT size).
//       Reason is that the value must be divided by two for transmission over the SOC and then the odd information will be lost.
#define  TIMING_ADVANCE_CHANNEL_DELAY_4KHZ_35B_8K16K_FFT    (266)   // Timing advance corresponding the 7.5 usec assumed channel delay (8k FFT) - 1500m
                                                                    // Note: BDCM is using a value of 266. Normally the 265 should also work, because the value corresponds to the
                                                                    //       8k FFT size.
#define  TIMING_ADVANCE_CHANNEL_DELAY_4KHZ                  (265)   // Timing advance corresponding the 7.5 usec assumed channel delay (8k FFT) - 1500m
//#define  TIMING_ADVANCE_CHANNEL_DELAY_8KHZ                  (530)   // Timing advance corresponding the 7.5 usec assumed channel delay (8k FFT) - 1500m
#define  TIMING_ADVANCE_CHANNEL_DELAY_8KHZ                  (265)   // This TA value is optimized for loops around 700m (typically, 30a band plans don't link beyond 1100m)

//XDSLRTFW-458: IOP_ALL_VDSL2_ALL_TACorrection (start_end)
#define  TIMING_ADVANCE_MAX_CAP                             (300) // This value derived from the experiments such that Echo effect is not seen in DS band.


// function prototype
void TimingAdvanceHandler(void);

#endif   // _TIMINGADVANCEHANDLER_H_
