/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2005 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
#ifndef _TONE_REORDER_H
#define _TONE_REORDER_H

/**********************************************************************
 *
 * Aware DMT Technology. Proprietary and Confidential.
 *
 * ADDRESS:          40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 * TELEPHONE:        781.276.4000
 * FAX:              781.276.4001
 * WEB:              http://www.aware.com
 *
 * FILE:             ToneReorder.h
 * DESCRIPTION:      Header file for ToneReorder.c
 *
 **********************************************************************/

#define NORMAL_TONE_ORDER     (0)
#define NO_TONE_ORDER         (1)
#define ILV_TONE_ORDER        (2)      //interleaved tone-reordering

#define RX_NUM_OUT_BAND_ZERO_BIT_TONE  (2)
#define RX_OUT_BAND_ZERO_BIT_TONE_1    (0)
#define RX_OUT_BAND_ZERO_BIT_TONE_2    (1)
#define TX_OUT_BAND_ZERO_BIT_TONE      (2)

/**********************************************************************
 * FUNCTIONS
 **********************************************************************/
FlagT ToneOrdering(int16 s_direction, uint8 *puca_BAT, uint8 *puca_ExtGains, int16 s_NumTones, int16 s_MaxBitsPerTone, int16 *psa_ToneIndices);
FlagT FillUnusedToneInTrt(uint8 *puca_ExtGains, int16 *psa_ToneIndices, int16 s_StartIndex, int16 s_EndIndex);
void BgFormRxTRT(void);
FlagT FormTRT(FlagT ft_direction);
FlagT ReorderTRT_Rx(void);
FlagT ReorderTRT_Tx(void);
FlagT FillUnusedToneInTRT(void);
void WriteTRT(uint16 us_word, int16 *ps_start, int16 *ps_end, int16 *ps_band);
uint16 ReadTRT(int16 *ps_start, int16 *ps_end, int16 *ps_band);
void Unpack_TRT(FlagT ft_direction, int16 *psa_outbuf, int16 *ps_Num0bitTones, int16 *ps_Num1bitTones);
void ReorderTones(FlagT ft_direction, int16 *psa_toneorderTCM,int16 *psa_toneorderTCM_1bits, int16 *psa_toneorderTCM_above1bits);

#endif /* _TONE_REORDER_H */

