/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2005 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   TxPSDCOntrol.h
*
*  This header file contains functions to allow the modem to set PSD Masks.
*
*-------------------------------------------------------------------------
*/

#ifndef _TXPSD_CONTROL_H
#define _TXPSD_CONTROL_H

// TxPSDControl.c
FlagT GetUPBOab(int16 s_toneIdxIn, int16 *ps_aOut, int16 *ps_bOut, int16 *ps_BandIndex);
int16 GetUPBOAttenLevel(int16 s_toneIdxIn, int16 s_attenLevelIn);
void CleanUpPsdBrkpt(int16 s_MaxNumBrkpts, PSDDescriptorTable_t *pt_PSDDescOut);
void InterpolatePSDUtil(int16 s_MaxNumBrkpts, PSDDescriptorTable_t *pt_PSDDescIn, int16 s_MinAtten,
                        int16 *ps_min_atten_dB, PSDDescriptorTable_t *pt_PSDDescOut);
void ConfigIfftScales(void);
void ConfigTxVarGain(int16 s_TxNomPsd);
void SetTransmitGains(void);

// InterpolatePSDUtil_tssi.c
void InterpolatePSDUtil_tssi(int16 s_MaxNumBrkpts,
                  PSDDescriptorTable_t *pt_PSDDescIn,
                  PSDDescriptorTable_t *pt_PSDDescIn_UsTxAtten,
                  int16 s_MinAtten,
                  int16 *ps_min_atten_dB,
                  PSDDescriptorTable_t *pt_PSDDescOut);

// CalcAtpCeil.c
int16 CalcAtp(int16 s_ceil, int16 s_MaxNomPsdIn, PSDDescriptorTable_t *pt_PSDDescMaxIn,int16 s_NumOfBands, int16 *sa_BandLeftChannel, int16 *sa_BandRightChannel, int16 s_NumOfTones_RxOrTx);
int16 CalcAtpCeil(int16 s_MaxAtp, int16 s_MaxNomPsdIn, void *pt_PSDDescMaxIn, int16 s_NumOfBands, int16 *sa_BandLeftChannel, int16 *sa_BandRightChannel, int16 s_NumOfTones_RxOrTx);

// ConvertLogToLinear.c
void ConvertLogToLinear(uint16 *pusa_LinearPSDOut, uint16 pusa_LogPSDOut);

// quick_PSDsort.c
void quick_PSDsort(PSDDescriptorTable_t* UnsortedList, int16 left, int16 right);

// Switch_TxFineGains_Tssi.c
void Switch_TxFineGains_Tssi(void);

#define LTG_LOAD_IRIDIA    (0)
#define LTG_LOAD_STRYMON   (1)
#define LTG_LOAD_AFE_BKGRND   (2)
#define LTG_LOAD_WAIT      (3)
#define LTG_LOAD_AFE_DONE  (4)
#define LTG_LOAD_DONE      (5)

// LoadTransmitGains.c
void LoadAfeTransmitGains(void);
void LoadTransmitGains(void);

// sleep.c
void ClearTransmitGains(void);

#endif // _TXPSD_CONTROL_H
