/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1998 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
#ifndef _RETX_H
#define _RETX_H

/****************************************************************************
;  Aware DMT Technology. Proprietary and Confidential.
;
;   40 Middlesex Turnpike, Bedford, MA 01730-1413
;  Phone (781) 276 - 4000
;   Fax   (781) 276 - 4001
;
;
;  File Name: retx.h
;
*****************************************************************************/


// ***********************************************************************************************************
// retx.h
//
// History
//
// 16/07/2013 Palaksha: Changes related to RRC Golay code word extration,Golay Decoding, RRC Evaluation
//            Grep for: XDSLRTFW-1076: Feature_ALL_ALL_ALL_R7_GolayRRC
//
// ************************************************************************************************************


#include "common.h"
#include "mtkernel.h"
#include "sys_const.h"
#include "socmessage.h"
#include "SnrFrameAlignHandler.h"
#include "voc.h"
#include "data_alloc.h"
#include "states.h"
#include "pll.h"
#include "afe.h"
#include "DecAdapt.h"
#include "DebugBuffer.h"


#define SIZETT       63        // Qtx is typically any integer from 1 to 63. Size the table to Qtx for the reference state machine
#define NUM_RRC_BYTES   3
#define NUM_RRC_BITS    24
#define PAD_BYTE_VALUE (0xFF)
#define US_RETX_FRAMING_TYPE_1 0
#define US_RETX_FRAMING_TYPE_3 2
#define RTX_US_DELAY_MAX_DEFAULT  (20)
//shine ratio is expressed as a multiple of 0.001 later
#define RTX_US_SHINERATIO_DEFAULT  (2)

//XDSLRTFW-1076: Feature_ALL_ALL_ALL_R7_GolayRRC (Start)
// Function prototypes
void ReadRRCFifo(void);
FlagT RRCGolayDecode(void);
void RRC_Evaluation(void);
//XDSLRTFW-1522 (Start)
void CalculateActualINP(int16* ps_INP_Shine, int16* ps_INP_Rein, ReTx_ComputeInp_Params_t t_ComputeInp_Params);
void CalculateActualSHINE_INP(int16* ps_INP_Shine, ReTx_ComputeInp_Params_t t_ComputeInp_Params);
void CalculateActualREIN_INP(int16* ps_INP_Rein, ReTx_ComputeInp_Params_t t_ComputeInp_Params);
//XDSLRTFW-1522 (End)
void Calc_Rates_UsReTx(VDSL2ComputeRates_t *pt_ComputeRates, int16 s_fs, int32 *pl_OHRate, int32 *pl_NetDataRate);
//XDSLRTFW-1076: Feature_ALL_ALL_ALL_R7_GolayRRC (End)

//XDSLRTFW-1052 Feature_US_VDSL2_ALL_UsReTx_WrTCtoILV_RdILVtoDTB (Start)
void UsReTx_WrTCtoILV_RdILVtoDTB(int16 s_TransferSize_Lp1);

//Read pointer Handler (reading ILV retx buffer and writing to DTB)
   void  UsReTx_RdFromILVtoDTB(int16 s_TransferSize_Lp1);
//Write pointer Handler (Writing from TC layer to ILV retx buffer
   void  UsReTx_WrFromTCtoILV(int16 s_TransferSize_Lp1);
   void CheckForRetransmission(void);
//XDSLRTFW-1052 Feature_US_VDSL2_ALL_UsReTx_WrTCtoILV_RdILVtoDTB (End)



#endif //_RETX_H
