/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
#ifndef _VDSL_FEATURE_MAP_H
#define _VDSL_FEATURE_MAP_H

// ******************************************************************
// VDSLFeatureMap.h
//
// History
// 26/11/2012 Varun : Updated the features supported in VDSL DSL 20.
//                    Grep for XDSLRTFW-1412
//
// 01/12/2015 Ram: Updated VDSL Feature map with R9 release content
// ******************************************************************


#define VDSL_FEATURE_SUPPORTED          (1)
#define VDSL_FEATURE_NOT_SUPPORTED      (0)

// XDSLRTFW-3637 (Start)
// Refer DSL 20 of MCAT 3.1
// Parameter 3
#define VDSL_FEATURE_NTR                                    (VDSL_FEATURE_NOT_SUPPORTED)
#define VDSL_FEATURE_PRE_EMPTION_AND_SHORT_PACKETS          (VDSL_FEATURE_NOT_SUPPORTED)
#define VDSL_FEATURE_ERASURE_DECODING                       (VDSL_FEATURE_NOT_SUPPORTED)
#define VDSL_FEATURE_INTRA_DTU_INTERLEAVING_US              (VDSL_FEATURE_SUPPORTED)
#define VDSL_FEATURE_INTRA_DTU_INTERLEAVING_DS              (VDSL_FEATURE_SUPPORTED)
#define VDSL_FEATURE_US_DS_RETX_PAF                         (VDSL_FEATURE_SUPPORTED)
#define VDSL_FEATURE_PTM_OFFCHIP_BONDING_BACP               (VDSL_FEATURE_NOT_SUPPORTED)
#define VDSL_FEATURE_MICROFILTER_DETECTION_HYBRID_DATA      (VDSL_FEATURE_NOT_SUPPORTED)
#define VDSL_FEATURE_AFE_POWER_DOWN                         (VDSL_FEATURE_SUPPORTED)      // XDSLRTFW-3647 (Start_End)

// Parameter 4
// Reserved

// Parameter 5
// Reserved for Internal Features
// XDSLRTFW-3637 (End)

#endif // _VDSL_FEATURE_MAP_H
