/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright C 2016 Intel Corporation
    Copyright (C), 1994-2011 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
#ifndef _CMV_H
#define _CMV_H
/*******************************************************************************
*
*
*  Aware DMT Technology. Proprietary and Confidential.
*
*  40 Middlesex Turnpike, Bedford, MA 01730-1413
*  Phone (781) 276 - 4000
*  Fax   (781) 276 - 4001
*
*  filename: cmv.h
*
*  CMV address and bit field definitions
*
*******************************************************************************/

// ***********************************************************************************************************
// cmv.h
//
// History
//
//
// 16/05/2012 Vinjam: Code Pointers connected to Downstream Virtual Noise feature
//    Enabling/disabling of downstream virtual noise feature control is moved from "CMV MONI 4" to "CMV DSL 0",
//      as per VR9 Message Specifications (1.6.1).
//      Grep for XDSLRTFW-439: Feature_All_DS_All_All_SupportDsTxRefVirtualNoise
//
// 08/08/2012 Vinjam: Added a CMV (TEST 40 0 Bit-0) to force upstream fine gains to unity (0x2000).
//                    CMV is disabled by default. It is added for testing purpose only to validate CPE Tx PSD as per Standard.
//                    If the CMV is enabled, it disables the upstream bitswap to avoid change in forced upstream Tx finegains for PSD measurement.
//                    Grep for XDSLRTFW-503 Task_All_US_All_All_ForceFineGainsToUnityForPSDmeasurement
//
// 23/08/2012 VENKATESH: Workaround for XDSLRTFW-506 Lower DS Rates with INP > 2 cases & No Connect with INP = 16
//                       CMV INFO 232 Index 1 Bit 0x4 included, Default Enabled
//                       Grep for XDSLRTFW-506-TELEFONICA_MAXPROFILE-WORKAROUND-INP-CASES
//
// 29/8/2012 Vinjam: Changed CMV (from "TEST 40 0 0x1" to "TEST 28 0 0x2") to force upstream fine gains to unity
//                    CMV is changed to keep it same across ARx & VRx platforms.
//                    CMV is disabled by default. It is added for testing purpose only to validate CPE Tx PSD as per Standard.
//                    If the CMV is enabled, it disables the upstream bitswap to avoid change in forced upstream Tx finegains for PSD measurement.
//                    Grep for XDSLRTFW-503 Task_All_US_All_All_ForceFineGainsToUnityForPSDmeasurement
//
// 18/09/2012 Ram: 1. Added code to support ReTx CMV - INFO 229 (to check if DS showtime is in ReTx mode or not)
//                 2. Moved the CMV "INFO2_BIT_PATTERN_SEL" from INFO-229 to INFO-233.
//                 Grep for: "XDSLRTFW-443: Feature_DS_VDSL2_All_ReTx_CMV_INFO_229"
//
// 27/11/2012 Ram: Merged IOP fix corresponding to JIRA XDSLRTFW-458
//                 Grep for: "XDSLRTFW-458: IOP_ALL_VDSL2_ALL_TACorrection"
//
// 17/01/2013 Ram: Fix added for JIRA 285 - Implement a 'Feature MAP' indicating the features supported by VDSL FW
//                 Added a new variable to implement CMV 'DSL 20' (Refer Msg Spec ver 1.9 for more details on CMV)
//                 Grep for XDSLRTFW-285: Feature_ALL_ALL_ALL_Config_Modem_Feature_Map
//
// 15/01/2013 Kannan: Added CMV to control AFE init fail indication.
//                Grep for: "XDSLRTFW-118: VR9_VRX318_AFE_Init_Fail_Indication"
//
//15/01/2013 Kannan: Added Macro state "STAT_PreFailState" to indicate Pre Fail state (LinkDownState).
//                   Added CNTL[3] CMV for orderly shutdown and added CNTR[56] CMV to
//                   hold the state machine in Link down state to read he debug data
//                   and to pull the TX_CB data..
//                   Grep for: "XDSLRTFW-710 VR9_VRX318_PDBRAM_Handover_OrderlyShutDown"
// 29/01/2013 Sooraj: 1. Added CMV "DSL 0 0x0008" for enabling/disabling AELEM feature
//                    2. Added "CMV INFO 234" used to convey the AELEM status
//                Grep for: XDSLRTFW-487_VR9_VRX318_VDSL2_All_AELEM_Support
//
// 18/2/2013 Vinjam: Corrected enabling of upstream & downstream bitswaps as per VRx Msg Spec using "CMV OPTN 15"
//             Grep for XDSLRTFW-720 Bug_All_VDSL2_All_FixBitSwapApiControl
// 19/2/2013 Mahesh  Corrected the DS SRA rate check "CMV OPTN 15"
//                  Grep for XDSRTFW-442: Feature_All_All_All_All_Vdsl2Sra
//
// 25/02/2013 Ram: Fix added for JIRA 285 - Implement a 'Feature MAP' indicating the features supported by ADSL FW
//                 Added a new variable to implement CMV 'DSL 19' (Refer Msg Spec ver 1.9 for more details on CMV)
//                 Grep for XDSLRTFW-285: Feature_ALL_ALL_ALL_Config_Modem_Feature_Map
//
// 27/02/2013 Mahesh: Added crystal drive changes for Jira - XDSLRTFW -561
//                       new CMV DSL 25 added
//                       Grep for XDSLRTFW-561 Enhancement_All_All_All_FreqOffset
//
// 05/04/2013 Abu : XDSLRTFW-794
//                  Add CMV "Test 40 0" to enable A43 GHs activation tones with BJ LIF module in Vectoring mode
//                  Grep for XDSLRTFW-794: NewFeatures_All_VdslVectoring_All_CmvTest40
//
// 12/04/2013 Vinjam : Enabled the hash define to enable the downstream virtual noise feature
//                     Grep for XDSLRTFW-749 Fix_All_DS_All_DownStreamVirtualNoise
//
// 24/04/2013 Vinjam: Added a new "IOP generic bits" to Customer IOP bits (CMV INFO 232 3 Bit#0) to enable/disable conveying AELEM capability in G.Hs CLR Message.
//                 It is controlled by Operator bits (CMV DSL 21). Based on the operator bits (DSL 21), Customer IOP bit (CMV INFO 232 3 Bit#0) will be enabled/disabled.
//                 Grep for XDSLRTFW-789 IOP_ALL_ALL_ALL_AelemCapabilityInGHsCLRMsg
//
// 06/05/2013 Varun : Added CMVs(DSL 26 0 to DSL 29 0) to status and controlling of Debug Buffer opereation
//                   Grep for "XDSLRTFW-598 FEATURE_ALL_ALL_ALL_Debug_Buffer" and
//                "XDSLRTFW-600 FEATURE_ALL_ALL_ALL_Debug_Buffer"
//
// 26/06/2013 Ram: Added new CMV DSL 31 to read G.Hs Handshake Control structure using DCT
//            Grep for XDSLRTFW-360 Enh_All_All_All_GetHandshakeControlInfo
//
// 11/07/2013 Vinjam: Added new IOP bit to toggle the Firmware version (first digit, chip ID) string sent in G.Hs
//            CMV allotted: CMV INFO 232 3 Bit#1, default set to "0" (i.e. sends FW version as 7.x.x.x).
//            Reason for this: (i) Old deployed Avinax Firmware supports VDSL2 ReTx for VR9 FW (5.x.x.x.x.x) only. So
//            to bring up VDSL2 ReTx with old Avinax DSLAM, send VRx318 FW version as 5.x.x.x (instead of 7.x.x.x) in G.Hs.
//            (ii) VRx318 FW sends FW version as 7.x.x.x with new Avinax firmware for VDSL2 ReTx.
//            Grep for XDSLRTFW-1085 IOP_ALL_ALL_ALL_ToggleChipID_InGHsVersionString
//
// 24/07/2013 Vinjam: Added new IOP bit to change the GHs Revision between "2" & "3".
//            CMV allotted: CMV INFO 232 2 Bit#2, default set to G.Hs revision as "2".
//            Grep for XDSLRTFW-1093 IOP_ALL_ALL_ALL_GHsRevisionChange
//
// 27/08/2013 Varun : Added new CMV CNTR 58 0 ==> US ReTx DTU Status counters
//                                  CNTR 59 0 ==> Us ReTx Performance Counters
//                                 INFO 237 0 ==> Us ReTx O PMS PARAMETERS(Ex - US Framing type selected, Qtx,lb,Q,V)
//                                  CNFG 84 0 ==> configure US Delay in DTUS and Symbols
//                                  RATE 3 0  ==> US ReTX ETR , Actual receiver delay , Actual INP shine and rein
//                    Grep for "XDSLRTFW-1193 Feature_US_VDSL2_ALL_UsReTx_CMV"
//
// 19/09/2013 Varun : Added new CMV INFO 238 0 ==> gives the Max mips count(Foregraound + Tc task) in showtime if test 0 0 is 0x1000
//                   Grep for "XDSLRTFW-1243 Feature_ALL_VDSL2_ALL_CMV_MipsProfiling"
//
// 02/12/2013 Varun : Added CMV INFO 239 0 to record max and min delay in dtus for US retx ack
//                   Grep for XDSLRTFW-1422
//
// 18/12/2013 Kannan: Added test cmv TEST 28 0 0x2000 to enable 5 secs shine noise fix, it is enabled by default
//                    This is applicable if DS ReTx is ON in showtime.
//                    Grep for XDSLRTFW-1104
//
// 29/01/2014 Abu: XDSLRTFW-1535 CMV Controlled Link Drop
//                 Grep : XDSLRTFW-1535 CMV_Controlled_Link_Drop
//
//
// 15/12/2014 Prashant: Following things are implemented wrt RetxDegug feature
//            1. Transmitter should offer an RRC codeword capture feature for up to 256 RRC CWs and capturing is started with the
//               first RRC CW where Nack[1:0] is unequal 0b00. (256 * 24bits to be stored).
//               Capture can be enabled by setting gt_RtxDbgCapture.us_RtxUsRrcCaptureCnt to 0. Once set to zero,
//               capture will start from first bad dtu and gt_RtxDbgCapture.us_RtxUsRrcCaptureCnt will be incremented upto 255.
//               To re-capture again set gt_RtxDbgCapture.us_RtxUsRrcCaptureCnt to 0.
//            2. Transmitter should offer the possibility to measure the actual roundtrip in number of DTUs per DTU from DTU TX insertion
//               until getting the first ACK info and should report the max./min. value captured during operation. (This already exist)
//               Reseting the measurement during operation is suppoterd now.
//            3. The structure RtxDbgCapture_t has been mapped to a new CMV INFO 241.
//    Grep for XDSLRTFW-1622
//
// 8/10/14 Vinay: Added code to support reporting of 3 more parameters (Recieve signal, Transmit signal, SOC message) to STAT 0
//                Grep for XDSLRTFW-1901
//
// 05/08/2015 Vinay: Added two more field to DSL 3 ( DSL 3 17 and DSL 3 18) to accomadate the pilot tone constellation for the pilot tone(only 1 being used).
//                   The first field represents the real part and the second field represents the imaginary part of the constellation.
//                   Grep: XDSLRTFW-214
//
// 30/09/2015 Vinay: Added a new CMV(CNFG 89) to support PME ID in bonding. The PME ID can be configured using the CMV in vdsl.scr
//                   Grep for XDSLRTFW-2382
//
// 21/9/2016 Sriram shastry  : NBN / VR9 DS performance is 100,871Mbps, expected is 103Mbps. vectoring+US&DS Retx
//       Internal 1-symbol HRTrx reduction in case of [RTX + G.Vector] operation for all  CO.
//       The test cases Vect=off with internal memory split show that the operator should not rely on a good internal split decision.
//       The internal split is not well-balanced for the wished service rates.
//       According to 998.4: + 1 sym can be ignored for vectoring+ 1 DTU (processing needs to wait for the last bit of each DTU)(+ 1 symbol because  of US/DS sync symbol alignment)
//       According to equation 1 of 9.5.1/G.998.4, it can be checked that the minimum required Qtx calculated by this equation (with the communicated HRT values and with the selected
//       framing parameters Q, NFEC1, L1) results to a required number of RTX buffer bytes Qtx*Q*H which exceeds the selected physical buffer size of MAXDELAYOCTETds/2 according to
//       D1.1/G.998.4 and would lead to a violation. It doesn't lead to a violation if the mentioned equation 1 doesn't take into account the extra +1 symbol
//       Added  debug code to  simulate  FW Internal Rein like disturber
//       1-symbol reduction in Qtx,min calculation:
//       It can be seen as a gap compensation. If only the ACK related gap occurs in the drawn triangle from start of Tack until end of Tret then
//       the +1 symbol in the Qtx,min calculation has to be taken into account. But if both gaps, the ACK related gap as well as the TX related gap,
//       occur within this triangle then these gaps are compensating each other w.r.t. Qtx,min demand and it is not needed to take into account the
//       +1 symbol in the Qtx,min calculation.
//       If both gaps occur in the triangle, two cases can be distinguished SSdsOffset >= 0 (SSds comes after SSus) and SSds <= 0 (Ssus comes after SSds).
//       For SSdsOffset >= 0, the ds gap must be located within Tret, the right triangle part. For SSdsOffset <= 0, the ds gap must be located within Tack,
//       the left triangle part.
//       If both transceivers have no DTU specific HRT contribution (HRT_RX_D=0, HRT_TX_D=0) then the only DTU specific contribution in the total roundtrip
//       is the DTU transmission time itself which is already considered extra in the Qtx,min equation (not included in the HRTs, outside Tack/Tret) and
//       shown in the drawings before the triangle.
//       So from the figures it could be derived:
//       No +1 symbol in the Qtx,min calculation needed if  -HRT_RX <= SSdsOffset <= HRT_TX
//       But w.r.t. the mentioned uncertainty in which HRTs the PMD associated transmission times are included the range should be reduced by a symbol, i.e.
//       No +1 symbol in the Qtx,min calculation needed if  -HRT_RX+1 <= SSdsOffset <= HRT_TX-1
//       CMV Description : TEST 52 0 "Value"  can be used to over write, Internal HRT Rx Symb used in RTX  Framing generation.
//       Default setting : Disable [ TEST 52 0 0]
//       Grep for : XDSLRTFW-2858
//
// 12/09/2017 Hanyu Liu: Added Operator select AT_T for CMV DSL 21 0 0xE and CTL for CMV DSL 21 0 0x11 to disable conveying AELEM capability in G.Hs CLR messages.
//                  Grep: XDSLRTFW-3470 XDSLRTFW-2724 IOP_ALL_US_CNXT_DISABLE_AELEM_GHS
//
//07/02/2018 Sriram shastry: VRX518: VDSL2 35b Vect. Sync Prob. with ADTRAN IUVDSL:48:SVM:F
//         No sync issue is seen when the maxETR is higher than maxNDR. Due to  CO Mis configuration
//         CPE fail with E_CODE_RX_LOW_PILOT_TONE_POWER.So the solution is cap max ETR to max NDR if maxETR > maxNDR
//         cmv description : TEST 55 0 1
//         (Default:ON)
//         Search  pattern : XDSLRTFW-3677
//
// 13/06/2018 Hanyu Liu: Added/defined CMV TEST 52 bit11:8 Tx-PSD mode TEST_TX_PSD_CONTROL_CTL_MODE = 5
//          for CTL operator to boost US1&US2 by 1.0dB. CMV default setting: Disable TEST 52 0 (mask 0x0F00)
// Search  for XDSLRTFW-3833
//
// 20/08/2018: Sriram Shastry : XDSLRTFW-232-Coding/decoding of US- and DS-tssi in O-PRM and R-PRM not correct
// 1. Performance optimization is done up to now only for US0 oPOTS configuration (US0-spectrum: tone 6-32)
// 2. If US oPOTS is used we force the out-of-band TSSI values for the CO TDQ training phase to: ...
//    Lower OOB tone Idx (0,4 are shaped with 6.0dB dB TxATTEN ) and  Upper OOB tone idx (36 =-0.0 dB &
//    tone idx 54 = -62.0 dB) TxATTEN is applied).
// 3. All other modes still use the old code
// 4. Added  new Tx IIR filter for  ISI optimization
// 5. Upstream performance optimization is  controlled by cmv. TEST 49 BITMASK- 9. Enabled by default
// Grep for XDSLRTFW-232
//
// ************************************************************************************************************

#include "cmv_data.h"
#include "Vdsl_const.h"
//
// Modem Monitor/Control
//

#define MONIMAP_SIZE       18

#define MONI_MODEM_STAT          0x0
   // Parameter 2
   #define MONI_STAT_RESET                   (0x0001 << 0)  // 0x0001
   #define MONI_STAT_T1413                   (0x0001 << 1)  // 0x0002
   #define MONI_STAT_GHS                     (0x0001 << 2)  // 0x0004
   #define MONI_STAT_FULL_INIT               (0x0001 << 3)  // 0x0008
   #define MONI_STAT_SHOW_TC_NOSYNC          (0x0001 << 4)  // 0x0010
   #define MONI_STAT_SHOW_TCSYNC             (0x0001 << 5)  // 0x0020
   #define MONI_STAT_DIAG_MODE               (0x0001 << 6)  // 0x0040
   #define MONI_STAT_PRE_FAIL                (0x0001 << 7)  // 0x0080
   #define MONI_STAT_FAIL                    (0x0001 << 8)  // 0x0100
   #define MONI_STAT_SHOW_TCSYNC_FIRSTTIME   (0x0001 << 9)  // 0x0200
   #define MONI_STAT_READY                   (0x0001 << 10) // 0x0400
   #define MONI_STAT_DIAG_COMPLETE           (0x0001 << 11) // 0x0800
   #define MONI_STAT_MFD                     (0x0001 << 12) // 0x1000
   #define MONI_STAT_MFD_COMPLETE            (0x0001 << 13) // 0x2000
   #define MONI_STAT_GHS_BONDING_CLR         (0x0001 << 14) // 0x4000
   #define MONI_TEST_STATE                   (0x0001 << 15) // 0x8000
   // Parameter 3
   #define MONI_DSL_POWER_DOWN               (0x0001 << 0)  //0x0001    // XDSLRTFW-3647 (Start_End)

#define MONI_LINE_FAILURES_NE    0x1

   #define MONI_NE_FAIL_LOS         (0x0001 << 0)
   #define MONI_NE_FAIL_LOF         (0x0001 << 1)
   #define MONI_NE_FAIL_LPR         (0x0001 << 2)
   #define MONI_NE_FAIL_RFI         (0x0001 << 3)
   #define MONI_NE_FAIL_NCD_LP0     (0x0001 << 4)
   #define MONI_NE_FAIL_NCD_LP1     (0x0001 << 5)
   #define MONI_NE_FAIL_LCD_LP0     (0x0001 << 6)
   #define MONI_NE_FAIL_LCD_LP1     (0x0001 << 7)
   #define MONI_NE_FAIL_NCD_BC0     (0x0001 << 8)
   #define MONI_NE_FAIL_NCD_BC1     (0x0001 << 9)
   #define MONI_NE_FAIL_LCD_BC0     (0x0001 << 10)
   #define MONI_NE_FAIL_LCD_BC1     (0x0001 << 11)

#define MONI_LINE_FAILURES_FE    0x2
   #define MONI_FE_FAIL_LOS         (0x0001 << 0)
   #define MONI_FE_FAIL_LOF         (0x0001 << 1)
   #define MONI_FE_FAIL_LPR         (0x0001 << 2)
   #define MONI_FE_FAIL_RFI         (0x0001 << 3)
   #define MONI_FE_FAIL_NCD_LP0     (0x0001 << 4)
   #define MONI_FE_FAIL_NCD_LP1     (0x0001 << 5)
   #define MONI_FE_FAIL_LCD_LP0     (0x0001 << 6)
   #define MONI_FE_FAIL_LCD_LP1     (0x0001 << 7)
   #define MONI_FE_FAIL_NCD_BC0     (0x0001 << 8)
   #define MONI_FE_FAIL_NCD_BC1     (0x0001 << 9)
   #define MONI_FE_FAIL_LCD_BC0     (0x0001 << 10)
   #define MONI_FE_FAIL_LCD_BC1     (0x0001 << 11)

#define MONI_AUTO_RESTART        0x4
   #define MONI_RESTART_AT_FAIL        0x0001
   #define MONI_EnableDiagMode            0x0004

   #define MONI_EnableBondingExchangeOnly 0x0080

#define MONI_SHOW_FAILURES_NE    0x5
   #define MONI_SHOW_FAIL_NE_LOS       (0x0001 << 0)
   #define MONI_SHOW_FAIL_NE_LOF       (0x0001 << 1)
   #define MONI_SHOW_FAIL_NE_LPR       (0x0001 << 2)
   #define MONI_SHOW_FAIL_NE_RFI       (0x0001 << 3)
   #define MONI_SHOW_FAIL_NE_NCD_LP0      (0x0001 << 4)
   #define MONI_SHOW_FAIL_NE_NCD_LP1      (0x0001 << 5)
   #define MONI_SHOW_FAIL_NE_LCD_LP0      (0x0001 << 6)
   #define MONI_SHOW_FAIL_NE_LCD_LP1      (0x0001 << 7)
   #define MONI_SHOW_FAIL_NE_NCD_BC0      (0x0001 << 8)
   #define MONI_SHOW_FAIL_NE_NCD_BC1      (0x0001 << 9)
   #define MONI_SHOW_FAIL_NE_LCD_BC0      (0x0001 << 10)
   #define MONI_SHOW_FAIL_NE_LCD_BC1      (0x0001 << 11)

#define MONI_SHOW_FAILURES_FE    0x6
   #define MONI_SHOW_FAIL_FE_LOS       (0x0001 << 0)
   #define MONI_SHOW_FAIL_FE_LOF       (0x0001 << 1)
   #define MONI_SHOW_FAIL_FE_LPR       (0x0001 << 2)
   #define MONI_SHOW_FAIL_FE_RFI       (0x0001 << 3)
   #define MONI_SHOW_FAIL_FE_NCD_LP0      (0x0001 << 4)
   #define MONI_SHOW_FAIL_FE_NCD_LP1      (0x0001 << 5)
   #define MONI_SHOW_FAIL_FE_LCD_LP0      (0x0001 << 6)
   #define MONI_SHOW_FAIL_FE_LCD_LP1      (0x0001 << 7)
   #define MONI_SHOW_FAIL_FE_NCD_BC0      (0x0001 << 8)
   #define MONI_SHOW_FAIL_FE_NCD_BC1      (0x0001 << 9)
   #define MONI_SHOW_FAIL_FE_LCD_BC0      (0x0001 << 10)
   #define MONI_SHOW_FAIL_FE_LCD_BC1      (0x0001 << 11)

#define MONI_TR1_ALARMENABLE     0x7
   #define MONI_FECS_ENABLE      (0x0001 << 0)
   #define MONI_ES_ENABLE        (0x0001 << 1)
   #define MONI_SES_ENABLE       (0x0001 << 2)
   #define MONI_LOSS_ENABLE      (0x0001 << 3)
   #define MONI_UAS_ENABLE       (0x0001 << 4)
   #define MONI_CRC_ENABLE       (0x0001 << 5)
   #define MONI_FEC_ENABLE       (0x0001 << 6)

#define MONI_FEREADTRIGGER         0x8 // trigger for retrieving far-end PMD param's

#define MONI_CLEAREOC_TRIGGER_CONTROL  9
#define MONI_CLEAREOC_AUTOMSG_CONTROL 10
#define MONI_CLEAREOC_STATUS        11

#define MONI_CORRUPTCRC_CONTROL     12 // control for Corrupt CRC Eoc diag cmd
#define MONI_CORRUPTCRC_STATUS      13 // status of Corrupt CRC
#define MONI_SETANDREADTIME_CONTROL 14 // control for Set-time and Read-time Eoc cmds
// XDSRTFW-442: Feature_All_All_All_All_Vdsl2Sra [Start]
#define MONI_USShowtimeEvents_Mask        15
   #define MONI_US_SOS_ENABLE    (0x0001 << 0)
   #define MONI_US_SRA_ENABLE       (0x0001 << 1)


#define MONI_DSShowtimeEvents_Mask        16
   #define MONI_DS_SOS_ENABLE       (0x0001 << 0)
   #define MONI_DS_SRA_ENABLE       (0x0001 << 1)
// XDSRTFW-442: Feature_All_All_All_All_Vdsl2Sra [End]

//L2_Back_Channel
#define MONI_EVT_DSM_ERRORVECTORREADY   17
//==============================================================================
// INFO register address field definitions
//==============================================================================

#define INFOMAP_SIZE             120

//------------------------------------------
// State Machine variables
//------------------------------------------
#define INFO_TxState             0
#define INFO_RxState             1
#define INFO_TxNextState            2
#define INFO_RxNextState            3
#define INFO_TxStateJumpFrom        4
#define INFO_RxStateJumpFrom        5

// JumpTo CMVs are no longer valid, they are also removed from MP files.
// Two new global variables "gpF_TxStateJumpTo" and "gpF_RxStateJumpTo"will
// be added in and initialized as Done State function pointer.
// THERE IS NO CMV CONTROL FOR IT. The only way to changes their value is
// by a "memory write" command in WinHost.

#define INFO_DebugTrail             7

#define INFO_Reverb2SnrBuf          8
#define INFO_Reverb3SnrBuf          9
#define INFO_MedleySnrBuf           10
#define INFO_SnrBuf                 11

#define INFO_DECdelay               12
#define INFO_DECExponent            13
#define INFO_DECTaps             14

#define INFO_AECdelay               15
#define INFO_AECExponent            16
#define INFO_AECTaps             17

#define INFO_TDQExponent            18
#define INFO_TDQTaps             19

#define INFO_FDQExponent            20
#define INFO_FDQTaps             21

#define INFO_ActiveBat               22
#define INFO_InactiveBat            23
#define INFO_ActiveFineGains        24
#define INFO_InactiveFineGains         25
#define INFO_ActiveExtendedGains    26
#define INFO_InactiveExtendedGains     27
#define INFO_PollEOCData            28    // CO specific
#define INFO_CSNRMargin             29    // CO specific

//------------------------------------------
// Initialization Messages - these
// addresses are reused within different
// standards in order to save memory.
//------------------------------------------


//------------------------------------------
// Inialization Messages - ADSL
//------------------------------------------
#define INFO_RCMsgs1             30
#define INFO_RMsgs1                 31
#define INFO_RMsgRA                 32
#define INFO_RCMsgRA             33
#define INFO_RMsg2                  34
#define INFO_RCMsg2                 35
#define INFO_BitLoadOK              36
#define INFO_RCRates1               37
#define INFO_RRates1Tab             38
#define INFO_RMsgs1Tab              39
#define INFO_RMsgRATab              40
#define INFO_RRatesRA               41
#define INFO_RCRatesRA              42
#define INFO_RRates2             43
#define INFO_RCRates2               44
#define INFO_PackedRMsg2            45

//------------------------------------------
// Inialization Messages - VDSL
//------------------------------------------
#define INFO_DsContract             30
#define INFO_UsContract             31
#define INFO_DsConfig               32
#define INFO_UsConfig               33
#define INFO_DsConfigVDSL2          34
#define INFO_UsConfigVDSL2          35


//------------------------------------------
//
//------------------------------------------

#define INFO_RxBitSwapFlag          46
#define INFO_TxBitSwapFlag          47
#define INFO_ShowtimeSNRUpdateCount    48
#define INFO_ShowtimeFDQUpdateCount    49
#define INFO_ShowtimeDECUpdateCount    50
#define INFO_CopyRxBuffer           51
#define INFO_RxToneBuf              52
#define INFO_TxToneBuf                  53
#define INFO_Version             54 //firmware version
#define INFO_TimeStamp                  55

#define INFO_COSystemVendorID       56 // CO System Vendor ID (overhead messaging)
#define INFO_COSystemSerialNum         57 // CO System Serial Number (overhead messaging)
#define INFO_COSystemVersionNum        58 // CO System Version Number (overhead messaging)
#define INFO_BulkMemory             59 // Points to start of bulk memory
#define INFO_CPESystemVendorID         60 // CPE System Vendor ID (overhead messaging)
#define INFO_CPESystemVersionNum    61 // CPE System Version Number (overhead messaging)
#define INFO_CPESystemSerialNum        62 // CPE System Serial Number (overhead messaging)

#define INFO_DSBlackoutTone             63  // Pointer to guca_RMsgPCBTab[4]

#define INFO_COG9941VendorID        64 // 4 octed Vendor ID exchanged in GHS
#define INFO_CPEG9941VendorID       65 // 4 octed Vendor ID exchanged in GHS

#define INFO_COAuxInvInfo               66 // Auxiliary Inventory Info
#define INFO_CPEAuxInvInfo              67 // Auxiliary Inventory Info

//G997 DS/US Attenuation, Margin, etc. - Section 7.5.1.4-17 of the G997 Spec.
#define  INFO_DsSignalAndMargin              68
#define  INFO_UsSignalAndMargin              69




#define INFO_LD_OtherDS             70 // Offset 0: Success/Fail Code, 1:Last State Xmitted, 2:HLIN Scale.
#define INFO_LD_OtherUS             71 // Offset 0:
#define INFO_HLIN_DS             72
#define INFO_HLIN_US             73 // Available in Loop Diagnostics mode only.
#define INFO_HLOG_DS             74
#define INFO_HLOG_US             75 // Available in Loop Diagnostics mode only.
#define INFO_QLN_DS              76
#define INFO_QLN_US              77 // Available in Loop Diagnostics mode only.
#define  INFO_SNR_US             78
#define  INFO_ChannelMeasurement_DS 79 // used to get Hlin scale, measurement time, and G
#define  INFO_ChannelMeasurement_US 80 // used to get Hlin scale, measurement time, and G
#define INFO_ME_HDLC_TxBuffer    81 //
#define INFO_ME_HDLC_RxBuffer    82 //
#define INFO_ME_HDLC_Params         83 //

#define INFO_PsdBuf              84 // mapped to SNR buffer

#define  INFO_SNR_DS             85


#ifdef DEBUG_TRAIL
// The INFO 86 CMV is used to specify the type of data to be logged and the point
// in time at which to start logging.

#define INFO_DebugTrailControl      86
#define INFO_DebugTrailStatus    87
#endif // DEBUG_TRAIL

// The INFO 87 CMV is used by the ME to read the status of the logging, i.e. how
// much data has been logged.

#define INFO_FEDATA                 88


#define INFO_US_OLRPMCnt         95  // US OLRPM Counter (no PM yet)
#define INFO_DS_OLRPMCnt         96  // DS OLRPM Counter (no PM yet)

#define INFO_TIMESTATUS             97  // Status of "Time Sync" Eoc Cmd and also
                                        // time in ISO 8601 format

#define INFO_InitRxHsTonesPower     98  // GHS tone power


// The INFO 115 is used to enable/disable  the  output  of  so-called  "debug  streams"  with  additional  debug  information
#define INFO_DEBUG_STREAM_CONTROL    115
   //@todo: AH shall we define this here?
   #define CMV_INFO115_CONTROL_MASK 0x0001
   #define CMV_INFO115_CONTROL_POS  0x0000

// The INFO 116 is used to write a bit mask to configure which messages are output in the debug stream
#define INFO_DEBUG_STREAM_CONFIGURE  116
// The INFO 117 is an auto message indicating a stream buffer overflow on the host controller
#define INFO_EVT_DBG_BUFFER_OVERFLOW 117
// The INFO 118 is an auto message containing debug stream content
#define INFO_EVT_DBG_DEBUG_STREAM    118
// XDSLRTFW-3898(Start)
#define INFO_RECONF_HYB_COEFF        119
// XDSLRTFW-3898(End)

//==============================================================================
// INFO2 register address field definitions
//==============================================================================

// WARNING: this 2 sizes don't match with the actual amount of messages. Please review!!
#ifndef BIT_PATTERN_TEST
//#define INFO2MAP_SIZE                   21
#define INFO2MAP_SIZE                   42
#else //#ifdef BIT_PATTERN_TEST
//#define INFO2MAP_SIZE                   32
#define INFO2MAP_SIZE                   47
#endif //#ifdef BIT_PATTERN_TEST

#define INFO2_DS_Band_Ctrl             (0) // Downstream Band Control
#define INFO2_US_Band_Ctrl             (1) // Upstream Band Control
#define INFO2_RFI_Band_Ctrl               (2) // Downstream RFI Bands

#define INFO2_FE_OperatingModes           (3) // FE Supported Modes in CLx
#define INFO2_FE_StdInfo_CL               (4) // FE Standard Info in CLx

// VDSL2 only: Used to reflect profile selected
// Points to a structure of type ProfileActual_t
#define INFO2_Profile_Actual           (5) // VDSL2 Profile Selected

#define INFO2_ImageType                (9)   // Image Type

#define INFO2_ATN_SNRM_PER_BAND_DS          (10) // DS ATN and SNRM per band
#define INFO2_ATN_SNRM_PER_BAND_US          (11) // US ATN and SNRM per band

// Used to REPORT Actual DS PSD
// Points to a structure of type DsPSDDescriptorTable_t
#define INFO2_DS_ACT_PSD                 (12) // DS actual PSD

// Used to REPORT Actual US PSD
// Points to a structure of type UsPSDDescriptorTable_t
#define INFO2_US_ACT_PSD                 (13) // US actual PSD

#define INFO2_KL0_ELECTRICAL_LENGTH         (14) // Electrical Length Estimate (kl0)

#define INFO2_AFE_FILTERS              (15) // Electrical Length Estimate (kl0)

#define INFO2_pwr_Cnfg_Param_Actual       (16) // Actual Power/ PSD Configuration parameters

 // XDSRTFW-442: Feature_All_All_All_All_Vdsl2Sra [Start]

#define INFO2_RA_ModeDS                     (17) // Actual RA Mode - Downstream
#define INFO2_RA_ModeUS                     (19) // Actual RA Mode - Upstream

 // XDSRTFW-442: Feature_All_All_All_All_Vdsl2Sra [End]
//-------------------------------------------------------------------------------------
// Bonding is also known as PAF (PME Aggregate Function)

#define INFO2_Bonding_DiscAggr_Status     (21) // Points to structure of type (Bonding_DiscAggr_Status_t)




// INFO2_Bonding_DiscAggr_Status[0]

// [0]   :  Remote PAF Supported - 0:Not Supported, 1: PAF:Supported
// [1]   :  Discovery Operation Results - 0: Successful 1: Not Successful
// [2]   :  Aggregate Operation Results - 0: Successful 1: Not Successful
// [3]   :  Set Indicator - 0:  1: Aggregate Set operation received
// [4]   :  Clear Indicator - 0:  1: Aggregate Clear operation received
// [15:5]:     Reserved

#define INFO2_PAF_SUPPORTED_MASK 1
#define INFO2_PAF_SUPPORTED_SHIFT   0

#define INFO2_DISC_OP_RESULT_MASK   1
#define INFO2_DISC_OP_RESULT_SHIFT  1

#define INFO2_AGGR_OP_RESULT_MASK   1
#define INFO2_AGGR_OP_RESULT_SHIFT  2

#define INFO2_SET_OP_IND_MASK    1
#define INFO2_SET_OP_IND_SHIFT      3

#define INFO2_CLR_OP_IND_MASK    1
#define INFO2_CLR_OP_IND_SHIFT      4


// INFO2_Bonding_DiscAggr_Status[1-3] - Discovery Code

// INFO2_Bonding_DiscAggr_Status[4-5] - Aggregate Data

//-------------------------------------------------------------------------------------

#define INFO2_TX_Gain_Offset_dB            (22) // TX EGT offset (used by the host to extract the TX gi from TX EGT)

#ifdef BIT_PATTERN_TEST

#define INFO2_NUM_MISMATCH             (22)
#define INFO2_IFFT_ARRAY               (23)
#define INFO2_FFT_ARRAY                (24)
#define INFO2_BIT_PATERN_VAL           (25)
#define INFO2_LOOP_DELAY               (26)
#define INFO2_COMPARELOG_ENABLE           (27)  //Bit Log Enable
#define INFO2_RXTONEBUF                (28)  //rxtone buf
#endif //BIT_PATTERN_TEST
#define INFO2_CutUS0Psd                (30)
#define INFO2_IOP_LATN_KL0             (31)

//XDSLRTFW-506-TELEFONICA_MAXPROFILE-WORKAROUND-INP-CASES
// This CMV bit is for IOP Fixes
#define INFO2_CUSTOMER_IOPBITS         (32)
   //XDSLRTFW-458: IOP_ALL_VDSL2_ALL_TACorrection (start)
   #define ECI_DPBO_LONGREACH_PILOT    (1 << 0)
   #define ECI_DPBO_TACORRECTION       (1 << 1)
//   #define NotUsed                   (1 << 2)
   #define ECI_TXECHO_PILOT_FIXES      (1 << 3)
//   #define NotUsed                   (1 << 4)
   //XDSLRTFW-458: IOP_ALL_VDSL2_ALL_TACorrection (end)
   //XDSLRTFW-522: IOP_US_VDSL2_ALL_US_Data_Rate_Variation_In_BT_ECI_Tests (start_end)
   #define ECI_PILOT1_TONEIDX_BIAS     (1 << 6)
   #define ECI_KL0_WORKAROUND          (1 << 8)

//XDSLRTFW-477 PERF_DS_ALL_ALL_TX_BAND_SWITCH
   #define TELEFONICA_CHANGE_TXBAND   (1 << 0)
   #define TELEFONICA_17A_DS_CEIL_OPT (1 << 1)
   //Not used now
   #define TELEFONICA_MAX_RATE_CONFIG (1 << 2)

//XDSLRTFW-610 IOP_US_ALL_VDMF_NoConnectUPBO (Start)
   #define TELIASONERA_UPBO_NOCONNECT (1 << 0)

   //XDSLRTFW-1836 : FH Workaround for Wrong Profile
   #define GENERIC_HANDLE_WRONG_PROFILE   (1 << 0)
//XDSLRTFW-1085 IOP_ALL_ALL_ALL_ToggleChipID_InGHsVersionString (Start_End)
   #define GENERIC_TOGGLE_CHIP_ID_IN_GHS_VERSION  (1 << 1)
//XDSLRTFW-1093 IOP_ALL_ALL_ALL_GHsRevisionChange (Start_End)
   #define GENERIC_GHS_REVISION_CHANGE_IN_GHS_MSGS  (1 << 2)
//XDSLRTFW-1162
//   #define GENERIC_SWITCH_HLOG_REPORTING_ITU_AND_BBF       (1<<4) // (XDSLRTFW-1436 Start_End)

//XDSLRTFW-443: Feature_DS_VDSL2_All_ReTx_CMV_INFO_229 (Start)
#define INFO2_RETX_STATUS              (29)  //ReTX Status: DS showtime in ReTx mode or not
#ifdef BIT_PATTERN_TEST
#define INFO2_BIT_PATTERN_SEL          (33)  //Bit Pattern Select
#endif
//XDSLRTFW-443: Feature_DS_VDSL2_All_ReTx_CMV_INFO_229 (End)

// XDSLRTFW-487_VR9_VRX318_VDSL2_All_AELEM_Support
#define INFO2_AELEM_UPBO                    (34)
//   XDSLRTFW-565 IOP_US_ALL_HaweVDMF_UPBO_FEXT_WITHOUT_CO_GHS_SUPPORT
#define INFO2_IOP_UPBO_FEXT               (35)

//XDSLRTFW-554 BUG_US_ALL_ALL_PSDVIOLATION
#define INFO2_US_PSD_BOOST          (36)

//XDSLRTFW-1193 Feature_US_VDSL2_ALL_UsReTx_CMV(START)
#define INFO2_US_RETX_O_PMS_PARAMETERS (37)

//XDSLRTFW-1193 Feature_US_VDSL2_ALL_UsReTx_CMV(END)

//XDSLRTFW-1243 Feature_ALL_VDSL2_ALL_CMV_MipsProfiling (Start_End)
#define INFO2_MIPS_FOREGROUND_TCTASK_VALUES (38)

//XDSLRTFW-1422(Start_End)
#define INFO2_USRETX_DELAY_ESTIMATE (39)

// XDSLRTFW-1877 : VDSL2 IFEC ATTNDR (Start)
#define INFO2_IMPROVED_ATTNDR_ACT_PARAMS (40)
// XDSLRTFW-1877 : VDSL2 IFEC ATTNDR (End)

// XDSLRTFW-1877 : VDSL2 IFEC ATTNDR (Start)
#define INFO2_ReTxDbgCapture (41)
// XDSLRTFW-1877 : VDSL2 IFEC ATTNDR (End)

// A place holder from MCAT
#define INFO2_PSDMASKds       (42)

// XDSLRTFW-2843
// A place holder for INFO 243 from R9
#define INFO2_USPSD_COMPENSATION_RELATED_PARAMS    (43)

// XDSLRTFW-3565 (Start_End)
// XDSLRTFW-3711 (Start_End)
#define INFO2_PPE_CLOCK_GET   (44)

// XDSLRTFW-3344 (Start)
#define INFO2_HLOG_PERTONE             (45)
#define INFO2_QLN_PERTONE              (46)
// XDSLRTFW-3344 (End)

//==============================================================================
// RATE register address field definitions
//==============================================================================

#define RATEMAP_SIZE             4

#define RATE_UsRate                 0
#define RATE_DsRate                 1
#define RTX_Status_Param_DS         2
//XDSLRTFW-1193 Feature_US_VDSL2_ALL_UsReTx_CMV(START_END)
#define RTX_Status_Param_US         3

//------------------------------------------
// previous definitions
//------------------------------------------
//#define RATE_USFastBytes          4
//#define RATE_USIntlBytes          5
//#define RATE_USFastCheckBytes        6
//#define RATE_USIntlCheckBytes        7
//#define RATE_USIntlDepth          8
//#define RATE_USSymCodeWord           9
//#define RATE_USFastCodeWordSize         10
//#define RATE_USIntlCodeWordSize         11
//#define RATE_DSFastBytes          12
//#define RATE_DSIntlBytes          13
//#define RATE_DSFastCheckBytes        14
//#define RATE_DSIntlCheckBytes        15
//#define RATE_DSIntlDepth          16
//#define RATE_DSSymCodeWord           17
//#define RATE_DSFastCodeWordSize         18
//#define RATE_DSIntlCodeWordSize         19

//==============================================================================
// PLAM (Physical Layer Management) register address field definitions
// (See G997.1 for reference)
//==============================================================================

#define PLAMMAP_SIZE             6 // XDSLRTFW-1479 (Start_End) [Others were for ADSL, so reduced size in VDSL]

/*             */
/* Failure Flags  */
/*             */
#define PLAM_NearEndFailureFlags    0
#define PLAM_FarEndFailureFlags        1
#define PLAM_TR1AlarmIndicators        2
#define PLAM_DataPathFailures       5 // XDSLRTFW-1479 (Start_End)

   /*                         */
   /* Near End Failure Flags Bit Definitions */
   /*                         */
   /* ADSL Failures */
   #define PLAM_LOS_FailureBit            LOS_FAILURE_BIT
   #define PLAM_LOF_FailureBit            LOF_FAILURE_BIT
   #define PLAM_LPR_FailureBit            LPR_FAILURE_BIT
   #define PLAM_LOM_FailureBit            LOM_FAILURE_BIT
   #define PLAM_LOL_FailureBit            LOL_FAILURE_BIT
   #define PLAM_ESE_FailureBit            ESE_FAILURE_BIT
   #define PLAM_PRO_FPO_FailureBit        PRO_FPO_FAILURE_BIT
   #define PLAM_LINIT_FailureBit       LINIT_FAILURE_BIT

   /* ATM Failures */
   #define PLAM_NCD_LP0_FailureBit        NCD_LP0_FAILURE_BIT
   #define PLAM_NCD_LP1_FailureBit        NCD_LP1_FAILURE_BIT
   #define PLAM_LCD_LP0_FailureBit        LCD_LP0_FAILURE_BIT
   #define PLAM_LCD_LP1_FailureBit        LCD_LP1_FAILURE_BIT
   #define PLAM_NCD_BC0_FailureBit        NCD_BC0_FAILURE_BIT
   #define PLAM_NCD_BC1_FailureBit        NCD_BC1_FAILURE_BIT
   #define PLAM_LCD_BC0_FailureBit        LCD_BC0_FAILURE_BIT
   #define PLAM_LCD_BC1_FailureBit        LCD_BC1_FAILURE_BIT

//==============================================================================
// CNTL register address and bit field definitions
//==============================================================================

#define CNTLARRAY_SIZE                  4  //XDSLRTFW-710 VR9_VRX318_PDBRAM_Handover_OrderlyShutDown (START_END)

#define CNTL_ModemControl               0

   #define CNTL_ModemReset             0x0
   #define CNTL_ModemIdle              0x1 // Allows tests to read data when complete
   #define CNTL_ModemStart             0x2
   #define CNTL_FinalFailState         0x4 //XDSLRTFW-2186(Start-End)
   #define CNTL_LD_POWERDOWN           0x7 // Power down // XDSLRTFW-3647 (Start_End)
   #define CNTL_ModemSleep             0x8 // configuration for sleep substate
   #define CNTL_ModemStop              0xF
   #define CNTL_ModemLoopback          0x10
   #define CNTL_ExplicitRate           0x20 /* Bit 5 indicates Explicit Rate control */
   #define CNTL_FalconStart            0x80 /* Bit 7 indicates Falcon support */

#define CNTL_Control1                    1
#define CNTL_ModemModeSwitch            0x1

    #define MODESWITCH_SOFT_RESET                     0x0
    #define ONE_PORT_ADSL                             0x1A
    #define ONE_PORT_VDSL                             0x1B
    #define TWO_PORT_ADSL                             0x2A
    #define TWO_PORT_VDSL                             0x2B
    #define SWITCH_DUAL_PORT_TO_SINGLE_PORT_MODE      0x8000   // XDSLRTFW-3447
//XDSLRTFW-710 VR9_VRX318_PDBRAM_Handover_OrderlyShutDown (START)
#define CNTL_ShutDownRequest            3

//CNTL[3] CNTL_ShutDownRequest
//Bit 0:      L3 Orderly Shutdown Request
//When enabled, the modem sends a L3 orderly shutdown request to the remote side.
//Bit 1:      Orderly Shutdown Request
//                When enabled, DSL-FW shuts down the DSL-link orderly. After shutdown DSL-FW changes Modem State to FAILSTATE.
    #define CNTL_L3OrderlyShutDown      0x1
    #define CNTL_OrderlyShutDown        0x2
//XDSLRTFW-710 VR9_VRX318_PDBRAM_Handover_OrderlyShutDown (END)

//==============================================================================
// STAT register address and bit field definitions
//==============================================================================

#define STATARRAY_SIZE              22

// STAT 0, 1 and 2 are indirect CMV's
#define STAT_0_SIZE                 (5)            //XDSLRTFW-1901: ADSL/VDSL ACTIVATION STATE MACHINE (START_END)
#define STAT_1_SIZE                 (2)
#define STAT_5_SIZE                 ((sizeof(FailStateInfo_t)+1)/2)

// STAT register address field
#define STAT_MacroState             0
#define STAT_Mode                   1
#define STAT_DMTFramingMode         2
#define STAT_SleepState             3
#define STAT_Misc                   4
#define STAT_FE_L3_ReqStatus        STAT_Misc
#define STAT_FailureState           5
/************************************************************************************************
 * STAT_OLRStatus provides status of OLR
 *16-bit STAT_OLRStatus_DS
 *  [1:0]   :  OLR status 00=IDLE,  01=OLR_IN_PROGRESS, 10=OLR_Completed, 11=OLR_Aborted
 *  [3:2]:     Reserved
 *  [5:4]:     OLR_Type (1:bitswap; 2: DRR; 3: SRA)
 *  [7:6]:     Reserved
 *  [10:8]:    >0=Request. 0=not.   For DS, # of request transmissions/retransmissions (3 bits).
 *  [11]:      1=Receive Response, 0=not
 *  [15:12]:   Reserved
 *********************************************************************************************
 */
#define STAT_OLRStatus_DS           6

/************************************************************************************************
 * STAT_OLRStatus provides status of OLR
 * 16-bit STAT_OLRStatus_US CMV
 *  [1:0]   :  OLR status 00=IDLE,  01=OLR_IN_PROGRESS, 10=OLR_Completed, 11=OLR_Aborted
 *  [3:2]:     Reserved
 *  [5:4]:     OLR_Type (1:bitswap; 2: DRR; 3: SRA)
 *  [7:6]:     Reserved
 *  [8]:    1=Request Received. 0=not.
 *  [10:9]:     Reserved
 *  [11]:      1=Response Sent, 0=not
 *  [15:12]:   Reserved
 *********************************************************************************************
*/
#define STAT_OLRStatus_US           7

/************************************************************************************************
 * STAT_PMStatus provides status of PM
 * 16-bit STAT_PMStatus CMV
 *  [1:0]   :  PM Status 00=IDLE,  01=PM_IN_PROGRESS, 10=PM_Completed, 11=PM_Aborted
 *  [2] :      0=ATU_R initiated PM; 1 = ATU_C initiated PM
 *  [3]:    Reserved
 *  [5:4]:     PM_Type (1:Simple Request; 2: L2 request; 3: L2 trim)
 *  [7:6]:     Reserved
 *  [10:8]:    >0=Request. 0=not.   # of request transmissions/retransmissions (3 bits).
 *  [11]:      1=Response, 0=not
 *  [15:12]:   Reserved
 *********************************************************************************************
 */
#define STAT_PMStatus               8

/*************************************************************
 * 16-bit STAT_OLRError_DS, STAT_OLRError_US, STAT_PMError
 * [3:0]:          OLR/PM response reason code
 * [7:4]:          OLR/PM Internal error code
 * [15:8]:         OLR/PM Reserved for future
 *************************************************************
 */
#define STAT_OLRError_DS            9
#define STAT_OLRError_US            10
#define STAT_PMError             11


// STAT_MacroState
// MacroState reflects the high level state of the modem
#define STAT_ResetState                0x0000
#define STAT_ReadyState                0x0001
#define STAT_FailState                 0x0002
#define STAT_DiagModeComplete          0x0003
#define STAT_GhsState                  0x0005
#define STAT_FullInitState             0x0006
#define STAT_ShowTimeState             0x0007
#define STAT_ShowTimeTCSyncState       0x0008
#define STAT_LoopDiagMode              0x0009
#define STAT_T1413                     0x000E
#define STAT_PreFailState              0x000F
#define STAT_BondingCLR                0x0010
#define STAT_MFD                       0x0012
#define STAT_MFD_COMPLETE              0x0013
#define STAT_DSL_POWER_DOWN_STATE      0x0014   // XDSLRTFW-3647 (Start_End)
#define STAT_TestState                 0x00F0

// STAT_Mode
// ConfigurationMode indicates the mode of the current ADSL Link. In general, a modem may use
// G.Hs or some other mechanism to negotiate the specific mode of operation.
// The OPTN_modeControl CMV is used to select a set of desired modes.
// The STAT_Mode CMV indicates which mode was actually selected.

// gsa_Stat1_Mode[0]
#define STAT_ConfigMode_T1413       0x0001
#define STAT_ConfigMode_G992_2_AB   0x0002
#define STAT_ConfigMode_G992_1_A    0x0004
#define STAT_ConfigMode_G992_1_B    0x0008
#define STAT_ConfigMode_G992_1_C    0x0010
#define STAT_ConfigMode_G992_2_C    0x0020

#define STAT_ConfigMode_G992_3_A    0x0100
#define STAT_ConfigMode_G992_3_B    0x0200
#define STAT_ConfigMode_G992_3_I    0x0400
#define STAT_ConfigMode_G992_3_J    0x0800
#define STAT_ConfigMode_G992_3_L    0x1000

#define STAT_ConfigMode_G992_4_A    0x2000
#define STAT_ConfigMode_G992_4_I    0x4000

#define STAT_ConfigMode_G992_5      0x8000

#define STAT_ConfigMode_G992_1_ALL     (STAT_ConfigMode_G992_1_A | STAT_ConfigMode_G992_1_B | STAT_ConfigMode_G992_1_C)
#define STAT_ConfigMode_G992_2_ALL     (STAT_ConfigMode_G992_2_AB | STAT_ConfigMode_G992_2_C)
#define STAT_ConfigMode_G992_3_ALL     (STAT_ConfigMode_G992_3_A | STAT_ConfigMode_G992_3_B | STAT_ConfigMode_G992_3_I | STAT_ConfigMode_G992_3_J | STAT_ConfigMode_G992_3_L)
#define STAT_ConfigMode_G992_4_ALL     (STAT_ConfigMode_G992_4_A | STAT_ConfigMode_G992_4_I)
#define STAT_ConfigMode_G992_5_ALL     (STAT_ConfigMode_G992_5)
#define STAT_ConfigMode_ADSL2_ALL      (STAT_ConfigMode_G992_3_ALL | STAT_ConfigMode_G992_4_ALL | STAT_ConfigMode_G992_5_ALL)

// gsa_Stat1_Mode[1]
#define STAT_ConfigMode_G993_1         0x0001      //VDSL 1
#define STAT_ConfigMode_G993_2         0x0004      //VDSL 2

// STAT_DMTFramingMode
// FramingMode indicates the DMT framing mde negotiated during initialization. The framing mode
// status is not applicable in BIS mode and its value is undefined
#define STAT_FramingModeMask        0x0003

// STAT_Misc

#define STAT_OverlappedSpectrum        0x0008
#define STAT_TCM                 0x0010
#define STAT_TDQ_at_1104            0x0020
#define STAT_T1413_Signal_Detected     0x0040
#define STAT_AnnexL_US_Mask1_PSD        0x1000  //indicate we actually selected G992.3 AnnexL US PSD mask1
#define STAT_AnnexL_US_Mask2_PSD        0x2000  //indicate we actually selected G992.3 AnnexL US PSD mask2

// STAT_FailureState
// when the MacroSTate indicates the fail state, FailureState provides a failure code

//STAT_OLRStatus:
#define STAT_OLRPM_IDLE                 0x0000
#define STAT_OLRPM_IN_PROGRESS          0x0001


#define STAT_OLRPM_L3_IN_PROGRESS       0x0000
#define STAT_OLRPM_L3_REJECTED          0x0001
#define STAT_OLRPM_L3_ACCEPTED          0x0002
#define STAT_OLRPM_L3_FAILED            0x0003


#define STAT_OLRPM_RESPONSE             0x0800
#define STAT_CO_L3_REQ_GRANTED         0x8000   // Indicates CO has requested and we have granted transition to L3.
#define STAT_CO_L3_REQ                0x4000 // Indicates CO has requested transition to L3.

#define STAT_OLR_BITSWAP                0x0010
#define STAT_OLR_DRR             0x0020
#define STAT_OLR_SRA             0x0030

//STAT_PMStatus_US:
#define STAT_PM_L0                   0x0000
#define STAT_PM_L2                   0x0002
#define STAT_PM_L3                   0x0003
#define STAT_PM_CO_REQ                  0x0004
#define STAT_PM_SIMPLE_REQ              0x0010
#define STAT_PM_L2_REQ              0x0020
#define STAT_PM_L2_TRIM_REQ            0x0030

#define  STAT_ME_PMREQ_STATUS       20    // Tells ME the result of its PM (L3) request.
#define  STAT_ME_PMREQ_ERROR           21    // Tells ME the result of its L3 request.

//Same as STAT_PM_STATUS with an addition definition as below
#define STAT_PowerMode              18    // holds the power management state, L0, L2



// STAT_OLRError_DS, STAT_OLRError_US
//4 bit response reason code:
#define RESP_BUSY                0x01
#define RESP_INVALID_PARAMETERS        0x02
#define RESP_NOT_ENABLED            0x03
#define RESP_NOT_SUPPORTED          0x04

//4 bit internal error code (common for OLR and PM)
#define REQ_INVALID_BiGi               0x10
#define REQ_INVALID_Lp                 0x20
#define REQ_INVALID_Bpn                0x30
#define REQ_INVALID_FRAMING_CONSTRAINT    0x40
#define REQ_NOT_IN_L0_STATE               0x50
#define REQ_NOT_IN_L2_STATE               0x60
#define REQ_INVALID_PCB                0x70
#define REQ_VIOLATES_MARGIN               0x80
#define SYNCFRAME_INDICATOR_TIMEOUT       0x90
#define  REQ_L3_RESPONSE_TIMEOUT          (SYNCFRAME_INDICATOR_TIMEOUT)

//STAT_PMError
//4 bit response reason code:
#define RESP_STATE_NOT_DESIRED           0x03
#define RESP_INFEASIBLE_PARAMETERS       0x04


//==============================================================================
// TEST register address and bit field definitions
//==============================================================================
// TEST register address field
//--------------------------------
#define TEST_Control                             (0) // TEST_0 // test control flag (Cocomo only) - may be used to debug target build??
#define TEST_Mode                                (1) // TEST_1 // controls cocomo connectity type (Cocomo only)
#define TEST_InitState                           (2) // TEST_2 // indicate initial state (Cocomo only)
#define TEST_ExitSymbolCountLSW                  (3) // TEST_3 // low 16-bit exit symbol count (Cocomo only)
#define TEST_ExitSymbolCountMSW                  (4) // TEST_4 // high 16-bit exit symbol count (Cocomo only)
#define TEST_TestSFCnt                           (5) // TEST_5 // superframe count used to terminate test (Cocomo only)
#define TEST_LoopbackMode                        (6) // TEST_6 // indicate different loopback mode
#define TEST_LogToneIndex                        (7) // TEST_7
#define TEST_TxSubState                          (8) // TEST_8
#define TEST_RxSubState                          (9) // TEST_9
#define TEST_TxTestTone                         (10) // TEST_10
#define TEST_BitSwapFromTone                    (11) // TEST_11
#define TEST_BitSwapToTone                      (12) // TEST_12
#define TEST_RxTestPilotTone                    (13) // TEST_13
#define TEST_SrcFRNominalOffset                 (14) // TEST_14
#define TEST_AlignmentOffset                    (15) // TEST_15
#define TEST_TimingAdvance                      (16) // TEST_16
#define TEST_TxCPLength                         (17) // TEST_17
#define TEST_TxCSLength                         (18) // TEST_18
#define TEST_TxBetaLength                       (19) // TEST_19
#define TEST_RxCPLength                         (20) // TEST_20
#define TEST_RxCSLength                         (21) // TEST_21
#define TEST_RxBetaLength                       (22) // TEST_22
#define TEST_PGA_required                       (23) // TEST_23
#define TEST_MaxNumHybrSettings                 (24) // TEST_24
#define TEST_AFERegAccess                       (25) // TEST_25 // TEST 25 is now indirect CMV
#define TEST_25_SIZE             (3)                            // TEST 25 is now indirect CMV
#define TEST_NumOneBitTone                      (26) // TEST_26
#define TEST_ReconfigControl                    (27) // TEST_27
#define TEST_Control3                           (28) // TEST_28
#define TEST_SRA_StartTone                      (29) // TEST_29     // New OLR CMVs
#define TEST_SRA_NumTones                       (30) // TEST_30     // New OLR CMVs
#define TEST_SRA_delta                          (31) // TEST_31     // New OLR CMVs
#define TEST_TwoPortMode                        (32) // TEST_32
#define TEST_BIT_PATTERN                        (33) // TEST_33
#define TEST_StoreSramControl                   (34) // TEST_34      // enable/disable data to SRAM
#define TEST_ChangeVendorID                     (35) // TEST_35      // specify which vendor ID to send
#define TEST_ErbData                            (36) // TEST_36      // L2_Back_Channel
                                                     // TEST_37
                                                     // TEST_38
                                                     // TEST_39
#define TEST_STR_IIR_HYB_LIF_CONFIG             (40) // TEST_40      // Configure different AFE Hybrid and Strymon IIR filter Combination
#define TEST_XDSLRTFW_CONFIG                    (41) // TEST_41
#define TEST_CMVCTRL_LINKDROP                   (42) // TEST_42      // XDSLRTFW-1535 CMV_Controlled_Link_Drop(start-end)
#define TEST_NUM_SYM_DS_RETX_FRAMING            (43) // TEST_43      // XDSLRTFW-1610
#define TEST_FREEZE_CPE_TX                      (44) // TEST_44      // XDSLRTFW-1887 - Freeze CPE Tx in states according to WT-138
#define TEST_ERB_ST_TX_CONTROL                  (45) // TEST_45      // XDSLRTFW-2014 / XDSLRTFW-2250, ST = Showtime;
#define TEST_Control4                           (46) // TEST_46
#define TEST_HP2_CONFIG                         (47) // TEST_47      // only for debug will be removed later
#define TEST_TCNOSYNC                           (48) // TEST_48      // XDSLRTFW-2050
#define TEST_JIRA2257_CONFIG                    (49) // TEST_49      // only for debug will be removed later
#define TEST_GHS_LOG                            (50) // TEST_50      // XDSLRTFW-2288
#define TEST_35B_CONTROL                        (51) // TEST_51      // only for debug will be removed later
#define TEST_TX_PSD_CONTROL                     (52) // TEST_52      // XDSLRTFW-2534  XDSLRTFW-2450
#define TEST_DS_RETX_HRT                        (53) // TEST_53      // XDSLRTFW-2858
#define TEST_DS_ACE                             (54) // TEST_54      // XDSLRTFW-3165
#define TEST_CO_ERR_CONF_CONTROL                (55) // TEST_55      // XDSLRTFW-3677 - CO mis/error control settings
#define TEST_SetHybrid_Index                    (56) // TEST_56      // XDSLRTFW-3898 - force  debug hybrid variable index
#define TESTARRAY_SIZE                          (TEST_SetHybrid_Index+1)


// TEST cmv bit field definitions
//----------------------------------
// NewFeatures_All_VdslVectoring_All_CmvTest40 (Start_End)
// TEST_STR_IIR_CONFIG defination
#define  TEST_STR_IIR_HYB_LIF_CONFIG_AUTO            0x0000
#define  TEST_STR_IIR_POTS_HYB_LIF_BJ                0x0001  // AVM HW uses BJ LIF module. With this test cmv FW configures BJ Hybrid with POTS strymon Tx IIR Filter and Transmits A43 Ghs tone set

// TEST_Control                           (0) - Bitmap
#define TEST_ChannelControl                          0x0001 // if set, channel is on (Cocomo only)
#define TEST_NoiseControl                            0x0002 //0x0080 // if set, noise is added (Cocomo only)
#define TEST_EchoControl                             0x0004 //0x0002
#define TEST_ConnControl                             0x0008 // if set, connectivity (Cocomo only)
#define TEST_PGAControl                              0x0010 // if set, enable PGA (Cocomo only)
//#define TEST_BISUSTCMDisable                         0x0020 // BIS US TCM Disable (for Showtime Only Tests)
//#define TEST_BertControl
#define TEST_TestSFControl                           0x0100 // if set, test terminates at TEST_TestSFCnt (Cocomo only)
//#define TEST_AlphaeusControl                         0x0400
//#define TEST_ForceBitSwap                            0x0800
#define TEST_TaskProfileControl                      0x1000 // if set, enable task profiling
#define TEST_LogSnrFdqControl                        0x2000 // if set, log SNR/FDQ updates during showtime
//#define TEST_ConnType                                0x4000   // Specifies which channel DLL is used. Must be used in conjunction with TEST_ConnControl. 0 = DLI, 1 = Sachmo
//#define TEST_AlphaeusTPEnable                        0x8000  // Alphaeus transparent mode enable
// TEST_Mode                               (1) - Bitmap
#define STANDARD_STRYMON_CONNECT                     (0x00)      //0x00 - standard strymon connectivity
#define FFT_FREQ_DOMAIN_CONNECT                      (0x01)      //0x01 - FFT freq domain connectivity
#define FFT_TIME_DOMAIN_CONNECT                      (0x02)      //0x02 - FFT time domain connectivity
#define ST_FREQ_DOMAIN_CONNECT                       (0x03)      //0x03 - Showtime freq domain connectivity (For CPE build to be used with Mutliport CO only)
#define ST_TIME_DOMAIN_CONNECT                       (0x10)      //0x10 - Showtime time domain connectivity (For CPE build to be used with Mutliport CO only)                                                     //others - reserved
// TEST_InitState                          (2) - Bitmap
#define FFT_TIME_DOMAIN_CONNECT8192     (0x04)      //0x04 - FFT time domain connectivity but for the FFT of 8192
#define ST_FREQ_DOMAIN_CONNECT8192      (0x05)      //0x05 - Showtime freq domain connectivity for the QT of 8192
#define FFT_FREQ_DOMAIN_CONNECT8192     (0x06)      //0x06 - FFT freq domain connectivity for the QT of 8192
#define TEST_GhsInitState                            (0x0000)
#define TEST_TrainInitState                          (0x0001)
#define TEST_ShowtimeInitState                       (0x0002)
#define TEST_TestInitState                           (0x0003)
// TEST_ExitSymbolCountLSW                 (3) - Bitmap
// TEST_ExitSymbolCountMSW                 (4) - Bitmap
// TEST_TestSFCnt                          (5) - Bitmap
// TEST_LoopbackMode                       (6) - Bitmap
#define TEST_LpbkDisabled                            (0x0000) // loopback is disabled (default)
#define TEST_LpbkAtDTB                               (0x0001) // loopback at TxDTB to RxDTB buffer
#define TEST_LpbkAtQT                                (0x0002) // loopback at TX QT output to RX QT input buffer
#define TEST_LpbkAtFFT                               (0x0003) // loopback at IFFT output to FFT input buffer

// TEST_NumOneBitTone                     (26) - Bitmap
// TEST_ReconfigControl                   (27) - Bitmap
//#define TEST_OvhdMessaging                           (0x0001)
#define TEST_ForceBitswap                            (0x0002)
//#define TEST_TestBitswap                             (0x0004)
#define TEST_TestOLR                                 (0x0008)
//#define TEST_ForceFR                                 (0x1000)
#define TEST_AbandonSRA                              (0x0010)
// Bit#8 (0x0100 )
// TEST_Control3                         (28) - Bitmap
#define TEST_ForceDownStreamFineGainsToUnity        (0x0001) // XDSLRTFW-503
#define TEST_ForceUpStreamFineGainsToUnity          (0x0002) // XDSLRTFW-503 Task_All_US_All_All_ForceFineGainsToUnityForPSDmeasurement (Start)
#define TEST_Control3_Test28_Bit2Mask               (0x0004)
#define TEST_Control3_Test28_NewHs                  (0x0008)
#define TEST_EnableImprovedATTNDR                   (0x0010) // XDSLRTFW-1877 : VDSL2 IFEC ATTNDR (Start_End)
#define TEST_Control3_Test28_Bit6Mask               (0x0040) // XDSLRTFW-1707_30a_RTX_DsUs (Start_End) CMV TEST 28 0 0x00C0
#define TEST_Control3_Test28_Bit7Mask_DISDEBUGTRACE (0x0080) // XDSLRTFW-1707_30a_RTX_DsUs (Start_End)
#define TEST_EnableTxDelayMin                       (0x0200)
#define TEST_EnableGHSToneMaskOutVectoring          (0x0400) // XDSLRTFW-1318 : To enable GHS Tone Mask out for vectoring
#define TEST_GHS_DisableTxPathAfeDfeCustomSettings  (0x0800) //XDSLRTFW-3292 Enable Low Pass Tx Iir filters during Handshake
#define TEST_GHS_Fix                                (0x1000) // XDSLRTFW-636
#define TEST_DisableAutoMsgTcMode                   (0x2000) // XDSLRTFW-3105
#define TEST_Control3_Ena_A21OldLifHyb              (0x4000) // 1 Old LIF A21 Hybrid coefficients,0 ==> New LIF A21 Hybrid coefficients (Default)
#define TEST_DisableL3Mode                          (0x8000) // disable L3 mode
// TEST_SRA_StartTone                    (29) - Bitmap
// TEST_SRA_NumTones                     (30) - Bitmap
// TEST_SRA_delta                        (31) - Bitmap
// TEST_TwoPortMode                      (32) - Bitmap
#define TEST_2PortModeEnable                         (0x0001) // 0: One-Port Mode, 1: Two-Port Mode
#define TEST_PortSelect                              (0x0002) // 0: Port0, 1: Port 1
#define TEST_ForceBondingContinue                    (0x0004) // 0: default, 1: minic 'continue' command from API
 // XDSLRTFW-3447(Start)
#define TEST_POFI_POCO_PD                            (0x0010)
#define TEST_LINE_DRIVER_PD                          (0x0020)
 // XDSLRTFW-3447(End)
// TEST_BIT_PATTERN                      (33) - Bitmap
#define TEST_BIT_PATTERN_ENABLE                      (0x0001)
#define TEST_ECHO_PATH_DELAY_MEASURE                 (0x0002) // enable echo path delay measurement
// TEST_StoreSramControl                 (34) - Bitmap
#define TEST_SAVE_MEDLEY_SNR_ENABLE                  (0x0001) // save medley snr to SRAM: 0: disable, 1:enable
#define TEST_SAVE_DISC_EchoOn_PSD_ENABLE             (0x0002) // save discovery phase echo-on PSD to SRAM: 0: disable, 1:enable
#define TEST_SAVE_DISC_EchoOff_PSD_ENABLE            (0x0004) // save discovery phase echo-off PSD to SRAM: 0: disable, 1:enable
#define TEST_SAVE_DISC_SNR_ENABLE                    (0x0008) // save discovery phase SNR to SRAM: 0: disable, 1:enable
#define TEST_SAVE_PERIODIC1_SNR_ENABLE               (0x0010) // save periodic1 snr to SRAM: 0: disable, 1:enable
#define TEST_SAVE_VECTOR_ERB                         (0x0020) // save error vector to SRAM: 0: disable, 1:enable
#define TEST_SAVE_VECTOR_ERB_AUTOMSG                 (0x0040) // send automsg after saving error vector to SRAM
#define TEST_SAVE_VECTOR_ERB_INCDATA                 (0x0080) // incremental pattern error vector to SRAM:
#define TEST_SAVE_VECTOR_ERB_CONSTDATA               (0x0100) // constant pattern error vector to SRAM:
#define TEST_SAVE_VECTOR_ERB_WRITE_ONETIME           (0x0200) // write error vector to SRAM only once,else repeated every superframe
#define TEST_SAVE_VECTOR_DEBUG_L2_ENABLE             (0x8000) // Enable L2 back channel debugging in Non Vectoring or Vectoring-EOC mode
// TEST_STR_IIR_HYB_LIF_CONFIG           (40) - Bitmap
// TEST_XDSLRTFW_CONFIG                  (41) - Bitmap
//#define TEST_XDSLRTFW_NOT_USED                       (0x0001) // free
//#define TEST_XDSLRTFW_NOT_USED                       (0x0002) // free
#define TEST_XDSLRTFW_CONFIG_FLOS                    (0x0004) // 0: disable, 1:enable
#define TEST_XDSLRTFW_CONFIG_XTALK_COMMON            (0x0008) // 0: disable, 1:enable
#define TEST_XDSLRTFW_CONFIG_FLAG_ONLY               (0x0010) // 0: disable, 1:enable
#define TEST_XDSLRTFW_CONFIG_XTALK_CONNECT           (0x0020) // 0: disable, 1:enable
#define TEST_XDSLRTFW_CONFIG_VEC_HYBRID              (0x0040) // 0: disable, 1:enable  // TEST_XDSLRTFW_CONFIG_VEC_HYBRID = 0  AND  TEST_XDSLRTFW_CONFIG_VEC_HYBRID_ECHO = 0  => SNR  based
#define TEST_XDSLRTFW_CONFIG_VEC_HYBRID_ECHO         (0x0080) // 0: disable, 1:enable  // TEST_XDSLRTFW_CONFIG_VEC_HYBRID = 1  AND  TEST_XDSLRTFW_CONFIG_VEC_HYBRID_ECHO = 0  => GAIN based
                                                                                       // TEST_XDSLRTFW_CONFIG_VEC_HYBRID = 1  AND  TEST_XDSLRTFW_CONFIG_VEC_HYBRID_ECHO = 1  => ECHO based
#define TEST_XDSLRTFW_CONFIG_SKIP_OPVEC1_LOSS        (0x0100) // 0: disable, 1:enable
#define TEST_XDSLRTFW_CONFIG_VEC_RESYNC_CALC         (0x0200) // 0: disable, 1:enable
#define TEST_XDSLRTFW_CONFIG_SKIP_PLL_OP_TrainingV1  (0x0400) // 0: disable, 1:enable
#define TEST_XDSLRTFW_CONFIG_SKIP_PLL_OP_TEQ         (0x0800) // 0: disable, 1:enable
#define TEST_XDSLRTFW_CONFIG_SKIP_PLL_OP_Pilot3      (0x1000) // 0: disable, 1:enable
#define TEST_XDSLRTFW_CONFIG_SKIP_PLL_OP_Periodic2   (0x2000) // 0: disable, 1:enable
#define TEST_XDSLRTFW_CONFIG_SKIP_PLL_O_TA_Update    (0x4000) // 0: disable, 1:enable
//#define TEST_XDSLRTFW_NOT_USED                       (0x8000) // free
// TEST_CMVCTRL_LINKDROP                 (42) - Bitmap
// TEST_NUM_SYM_DS_RETX_FRAMING          (43) - Bitmap
// TEST_FREEZE_CPE_TX                    (44) - Bitmap
#define TEST_FREEZE_CPE_TX_R_P_PERIODIC_1            (0x0001)
#define TEST_FREEZE_CPE_TX_R_P_CHANNEL_DISCOVERY_2   (0x0002)
#define TEST_FREEZE_CPE_TX_R_P_MEDLEY                (0x0004)
#define TEST_FREEZE_CPE_TX_SHOWTIME                  (0x0008)
#define TEST_FREEZE_CPE_TX_SHOWTIME_UNITY_GAIN       (0x0010)
// TEST_ERB_ST_TX_CONTROL                 (45) - Bitmap
#define TEST_ERB_ST_TX_CONTROL_STOP_VALUE_MASK       (0x7FFF) // ERB "STOP" number range - dependent of the CNTRL bit
#define TEST_ERB_ST_TX_CONTROL_N_VALUE_MASK          (0x007F) // ERB "Nth" number range - dependent of the CNTRL bit
#define TEST_ERB_ST_TX_CONTROL_N_RELOAD_BIT_POS           (7) // Start of ERB "Nth" reload number range
#define TEST_ERB_ST_TX_CONTROL_N_RELOAD_VALUE_MASK   (0x3F80) // ERB "Nth" reload number range - dependent of the CNTRL bit
#define TEST_ERB_ST_TX_CONTROL_RES_MASK              (0x4000) // Reserved for future use
#define TEST_ERB_ST_TX_CONTROL_CNTRL_MASK            (0x8000) // 1 - Every Nth ST ERB is not being transmitted, i.e. N any value of TEST_ERB_ST_TX_CONTROL_VALUE_MASK
                                                              // 0 - Stop sending pre-defined number of ST DS error vector in L2 mode.
// TEST_Control4                          (46) - Bitmap
#define TEST_Control4_Reset_PPE_BytePtr_Bit0_Mask    (0x0001) // 1 ==> Enable resetting PPE Byte pointer,
                                                              // 0 ==> Disable resetting PPE byte pointer
                                                               // XDSLRTFW-1784 (Showtime Margin Equalization)
#define TEST_Control4_Showtime_NoiseMgn_Equ_Bit1_Mask (0x0002) // 1 ==> Enable Showtime Noise margin Equalization,
                                                               // 0 ==> Disable Showtime Noise margin Equalization
#define TEST_Control4_SRA_LimitAtMgn_Bit2_Mask       (0x0004)  // 1 ==> Enable
                                                               // 0 ==> Disable flag to limit per tone margin at threshold
                                                               //       while performing DS Upshift SRA

#define TEST_Control4_Ena_StAdma_Queue_Bit3_Mask     (0x0008)  // 1 ==> Enable to use of ADMA queue in showtime to save DSP MIPS in Rx TC Mips (default)
                                                               // 0 ==> Disable of the ADMA queue and DSP wait till each ADMA operation get completed.

#define TEST_Control4_Ena_512TonesPerGroup_StDdSnrFdq_Bit4_Mask   (0x0010)  // 1 ==> Enable to use 512 tones per group in showtime for DD SNR Fdq update (default)
                                                                            // 0 ==> Enable to use 256 tones per group in showtime for DD SNR Fdq update

#define TEST_Control4_Ena_DSReTxForcedFraming_Bit5_Mask   (0x0020) // 1 ==> Enable to force the DS ReTx framing through CNFG 91
                                                                   // 0 ==> DS ReTx Forced framing is not applicable (default).
#define TEST_Control4_35bHwConfigIn17a_Bit6_Mask          (0x0040) // 1 ==> Enable the 35B HW config in TX path
                                                                   // 0 ==> Disable the 35B HW config in TX path
//XDSLRTFW-2168 (Start)
#define TEST_Control4_HRT_5_0_Scheduling_35b_Bit7_Mask    (0x0080) // 1 ==> Enable HRT 5,0 scheduling for 35B mode (default)
                                                                   // 0 ==> Disable HRT 5,0 scheduling for 35B mode.
#define TEST_Control4_HRT_5_0_LimitDsRate_35b_Bit8_Mask   (0x0100) // 1 ==> Enable to Limit DS Data Rate to 320Mbps with HRT 5,0 scheduling for 35B mode.
                                                                   // 0 ==> Disable DS data rate limitation for HRT 5,0 scheduling for 35B mode(Default).
//XDSLRTFW-2168 (End)

//XDSLRTFW-3300 (Start)
#define TEST_Control4_HRT_5_0_CapMaxDsBits14_35b_Bit9_Mask (0x0200)  // 1 ==> Enable to Limit max DS bits to 14 for short loops with HRT 5,0 scheduling(Default).
                                                                     // 0 ==> Disable to use default max 14Bit constellation.
//XDSLRTFW-3300 (End)

//XDSLRTFW-3493(Start)
#define TEST_Control4_Enhanced_ReTx_Framing_Bit10_Mask     (0x0400)  // 1 ==> Enable to use enhanced ReTx framing (Default).
                                                                     // 0 ==> Disable to use Enhanced ReTx framing.
//XDSLRTFW-3493(End)

#define TEST_Control4_Autonomous_State_Event_Msg_Bit11_Mask  (0x0800)  // 1==> Enable Autonomous State Event Messaging, 0==> Disable Autonomous State Event Messaging (Default) ////XDSLRTFW-4050


// TEST_HP2_CONFIG                        (47) - Bitmap
// HP2 config testing - "Test CMV 47" -> dms 2F44 0 1 x with x = 0,1,2,4,8,1,32,64,128,256,512 and 0x4000/0x8000
// FW default: 0x2D1.
#define TEST_HP2_CONFIG_RESET                        (0x0000) // All bits cleared
//#define Not_used                                     (0x0001) //
//#define Not_used                                     (0x0002) //
#define TEST_HP2_CONFIG_AGC2_START_6DB               (0x0004) // Set AGC2 gain to 6dB instead of 0dB for AGC2 training
#define TEST_HP2_CONFIG_AGC1_START_xDB               (0x0008) // Set AGC1 gain to a configured value between -6 to 12dB instead of 0dB for AGC1 training
//#define Not_used                                     (0x0010) //
#define TEST_HP2_CONFIG_US0_HYB_TBL                  (0x0020) //
#define TEST_HP2_CONFIG_DC_TO_ZERO                   (0x0040) // Set DC to zero
#define TEST_HP2_CONFIG_USE_SNR_HYB_FOR_US0          (0x0080) // Use SNR based hybrid selection for long loops, i.e. US0 only
#define TEST_HP2_CONFIG_PSD_HANDLER_SWITCH           (0x0100) // Switches to normal PsdHandler() and not the special PsdHandler_HybTrn()
//#define Not_used                                     (0x0200) //
#define TEST_HP2_CONFIG_CMV_CONFIG_ALWAYS            (0x4000) // Use the setting always, i.e. not for US0 only
#define Not_used                                     (0x8000)
// TEST_TCNOSYNC                          (48) - Bitmap
// TEST_JIRA2257_CONFIG                   (49) - Bitmap
// #define Not used                                    (0x0001)
#define TEST_JIRA2257_SKIP_TX_BAND_SWITCH            (0x0002)
// #define Not used                                    (0x0004)
#define TEST_JIRA2257_CLEAR_US0_ONLY                 (0x0008)
//#define Not used                                     (0x0010)
#define TEST_JIRA2257_ADSL_LD_H                      (0x0020)
#define TEST_JIRA2257_VDSL_FILTER                    (0x0040)
#define TEST_JIRA2257_SKIP_VDSL_AFE_TRIM1            (0x0080)
#define TEST_JIRA2257_GHS_US0                        (0x0100)
#define TEST_ENABLE_TXTSSI_SHAPE                     (0x0200)  // XDSLRTFW-232(Start_End)
//XDSLRTFW-2288 (Start)
// TEST_GHS_LOG                          (50) - Bitmap
#define TEST_GHS_LOG_ENABLE                          (0x0001)
#define TEST_GHS_INC_THRESHOLD                       (0x0002) //notused (for further debug)
#define HALT_AFTER_TONE_DETECTION                    (0x0008)
#define TEST_GHS_PWR_6dB_Less                        (0x0010)
#define TEST_GHS_HP2_ADSL_Set                        (0x0020)
#define TEST_GHS_INC_AVG                             (0x0800) //notused (for further debug)
#define TEST_GHS_AVG_FULL_BAND                       (0x1000)
#define TEST_GHS_GOTO_FAIL                           (0x2000)
#define TEST_GHS_LOG_TONE_BUF                        (0x4000) //ADSL (for further debug)
#define TEST_GHS_LOG_US_TONES                        (0x8000) //ADSL (for further debug)
//XDSLRTFW-2288 (End)

// TEST_35B_CONTROL                      (51) - Bitmap
//#define Not_used                                         (0x0001)
//#define Not_used                                         (0x0002)
#define TEST_35B_HALFROUNDTRIP_RX                        (0x0004)
#define TEST_35B_DISABLE_BDCM_TRT                        (0x0008)

// TEST_TX_PSD_CONTROL                   (52) (TEST_52)
// bits  0- 3
#define TEST_TX_PSD_CONTROL_COMPENSATION                 (0x0001)  //XDSLRTFW-2534
#define TEST_TX_PSD_CONTROL_BIT_1                        (0x0002)  // unused
#define TEST_TX_PSD_CONTROL_SEL_PSDCompensation          (0x0004)  // For enabling the PSD interp instead of Sample hold
#define TEST_TX_PSD_DISABLE_TX_TSSI                      (0x0008)
// bits  4- 7
#define TEST_TX_PSD_CONTROL_US0_BAND                     (0x0010)  //XDSLRTFW-3302
#define TEST_TX_PSD_CONTROL_REDUCE_KL0_BY_10_PERC        (0x0020)  //XDSLRTFW-3212 reduce default kl0 estimation by 10 percent
#define TEST_TX_PSD_CONTROL_REDUCE_KL0_BY_20_PERC        (0x0040)  //XDSLRTFW-3212 reduce default kl0 estimation by 20 percent
#define TEST_TX_PSD_CONTROL_BIT_7                        (0x0080)  // unused
// bits  8-11 - define the Tx-PSD mode      (0x0F00)
#define TEST_TX_PSD_CONTROL_R12_DEFAULT_MODE                  (0)  //XDSLRTFW-2450 (Disable US PSD boost feature and use R12 default code)
#define TEST_TX_PSD_CONTROL_BRCM_MODE                         (1)  //XDSLRTFW-3212 (increase PSD BRCM-like by 1.0dB)
#define TEST_TX_PSD_CONTROL_KPN_MODE                          (2)  //XDSLRTFW-3212 (increase PSD BRCM-like by 1.5dB on short loops)
#define TEST_TX_PSD_CONTROL_MREFPSD_p07dB_MODE                (3)  //XDSLRTFW-3212
#define TEST_TX_PSD_CONTROL_BRCM_MODE_IN_VECTORING_ONLY       (4)  //XDSLRTFW-3212 (increase PSD BRCM-like by 1.0dB only in Vectoring)
#define TEST_TX_PSD_CONTROL_CTL_MODE                          (5)  //XDSLRTFW-3833 increase PSD BRCM-like by 1.0dB plus add-ons for CenturyLink

#define TEST_TX_PSD_CONTROL_DEBUG_MODE                       (15)  //XDSLRTFW-3212
// bits 12-15
#define TEST_TX_PSD_CONTROL_BIT_12                       (0x1000)  // unused
#define TEST_ENA_RXGAIN_IMPEDANCEVAR_CORRECTION          (0x4000)  //XDSLRTFW-3596 To Enable RX gain correction(RX absolute gain error and input impedance variation correction) using DSL EFUSE data
#define TEST_TX_LINEDRIVER_POWERDOWN_MODE_ENABLE         (0x8000)  //To Make Line driver in Power down mode; Recommended to not enable this bit, unless you are very sure!


// TEST_DS_ACE                           (54) - Bitmap
#define TEST_DS_ACE_HYB_ONLY_POS                         (8)
#define TEST_DS_ACE_HYB_ONLY_EN                          (1 << TEST_DS_ACE_HYB_ONLY_POS)
#define TEST_DS_ACE_PGA_DIS_POS                          (7)
#define TEST_DS_ACE_PGA_DIS                              (1 << TEST_DS_ACE_PGA_DIS_POS)
#define TEST_DS_PREFI_CAP_EN_POS                         (6)
#define TEST_DS_PREFI_CAP_EN                             (1 << TEST_DS_PREFI_CAP_EN_POS)
#define TEST_DS_PREFI_CAP_DIS_POS                        (5)
#define TEST_DS_PREFI_CAP_DIS                            (1 << TEST_DS_PREFI_CAP_DIS_POS)
#define TEST_DS_ACE_FINAL_DIS_POS                        (4)
#define TEST_DS_ACE_FINAL_DIS                            (1 << TEST_DS_ACE_FINAL_DIS_POS)

#define TEST_DS_ACE_MODE_MASK                            ACE_MODE_MASK
// XDSLRTFW-3677 (Start)
// TEST_CO_ERR_CONF_CONTROL                      (55) - BitMap
#define TEST_OVER_WRITE_MAXETR_WITHMAXNDR                (0x1)
// XDSLRTFW-3677 (End)

#define VRX_OK                (0)
#define VRX_FAIL              (1)
//==============================================================================
// OPTN register address and bit field definitions
//==============================================================================
#define OPTNARRAY_SIZE                            30

// OPTN 0, 2 and 4 are indirect CMV's
#define OPTN_0_SIZE                                2
#define OPTN_2_SIZE                                4
#define OPTN_4_SIZE                                6
#define OPTN_28_SIZE                               2
#define OPTN_29_SIZE                               ((SNR_OFFSET_TONEGROUPS)*2+1) //XDSLRTFW-3823

#define OPTN_ModeControl                           0
#define OPTN_DMTLinkControl                        1
#define OPTN_AlgControl                            2
#define OPTN_GhsControl                            3
#define OPTN_FilterControl                         4
#define OPTN_HWConfiguration                       5
#define OPTN_AnnexControl                          6
#define OPTN_ModeControl1                          7  /* this is for future use */
#define OPTN_FFTBufferControl                      8
#define OPTN_StateMachineCtrl                      9
#define OPTN_Log2NumShowtimeFDQTrainingSymbols    10
#define OPTN_Log2NumShowtimeSNRTrainingSymbols    11
#define OPTN_Log2NumShowtimeDECTrainingSymbols    12
#define OPTN_ATMAddrConfig                        13
#define OPTN_ATMNumCellConfig                     14
#define OPTN_OLRControl                           15
#define OPTN_FFTControl                           16
#define OPTN_IFFTControl                          17
#define OPTN_LineDriver                           18  /* controls the board dependent line driver configuration */
#define OPTN_FeParamControl                       25
#define OPTN_NoiseMarginChange                    28

//----------- OPTN bit field definitions start -----------------
//--------------------------------------------------------------
// OPTN_ModeControl
/* Mode control defines the allowable operating modes of an ADSL link. In general, a modem may */
/* use G.Hs or some other mechanism to negotiate the specific mode of operation.               */
/* The OPTN_ModeControl CMV is used to select a set of desired modes                           */
/* The STAT_ModeControl CMV indicates which mode was actually selected */
// gsa_Optn0_ModeControl[0]
#define OPTN_ConfigMode_T1413             0x0001
#define OPTN_ConfigMode_G992_5_M          0x0002
#define OPTN_ConfigMode_G992_1_A          0x0004
#define OPTN_ConfigMode_G992_1_B          0x0008
#define OPTN_ConfigMode_G992_3_I          0x0010
#define OPTN_ConfigMode_G992_3_J          0x0020
#define OPTN_ConfigMode_G992_5_I          0x0040
#define OPTN_ConfigMode_G992_5_J          0x0080
#define OPTN_ConfigMode_G992_3_A          0x0100
#define OPTN_ConfigMode_G992_3_B          0x0200
//XDSLRTFW-2137 (Start_End)
#define OPTN_ConfigMode_G992_2_AB         0x0400
#define OPTN_ConfigMode_G992_3_L_Mask1    0x0800
#define OPTN_ConfigMode_G992_3_L_Mask2    0x1000
#define OPTN_ConfigMode_G992_3_M          0x2000
#define OPTN_ConfigMode_G992_5_B          0x4000
#define OPTN_ConfigMode_G992_5_A          0x8000

// OPTN_ModeControl[1]
#define OPTN_ConfigMode_G993_1            0x0001         //VDSL 1
//#define Reserved                        0x0002
#define OPTN_ConfigMode_G993_2            0x0004            //VDSL 2
#define OPTN_ConfigMode_CNXT              0x0010            //Far End - CNXT
#define OPTN_ConfigMode_IKAN              0x0020            //Far End - IKAN
#define OPTN_ConfigMode_Sniffer           0x8000            //Sniffer Mode
#define OPTN_ConfigMode_G9701             0x0100            // G.Fast (G.9701)   // XDSLRTFW-2298

//----------------------------------------
// OPTN_DMTLinkControl
/* DMTLinkControl controls a set of DMT specific parameters including framing mode, number of */
/* latency paths, S=1/2 disable, and dual latency disable */
#define OPTN_FMMask                       0x000F
#define OPTN_FM0                          0x0000
#define OPTN_FM1                          0x0001
#define OPTN_FM2                          0x0002
#define OPTN_FM3                          0x0003

#define OPTN_SHALF_Disable                0x0100
#define OPTN_DualLatency_Disable          0x0200
#define OPTN_RS16Support_Disable          0x0400
#define OPTN_TransferModeMask             0xF000
#define OPTN_STM_TransferMode             0x1000
#define OPTN_ATM_TransferMode             0x2000

//----------------------------------------
// OPTN_AlgControl[0]
#define OPTN_DecUpdateDisable             0x0004      //disables showtime DEC adaptation if set

// OPTN_AlgControl[1]
#define OPTN_PGADnldDisable               0x0001      //disables programming of PGA (though PGA algorithm is run)
#define OPTN_HybridDnldDisable            0x0002      //disables programming of Hybrid (though Hybrid algorithm is run)
#define OPTN_PARRDisable                  0x0004      //disables PARR
#define OPTN_MFDQInitDisable              0x0008      //disables MFDQ training during initialization
#define OPTN_MedleyMultiSynchDisable      0x0010      //disables Medley Multisynch search (necessary, or set synch points to 1)
#define OPTN_8KHzFrameRateEnable          0x0020      //1 Selects 8 KHz Frame Rate
#define OPTN_WindowDisable                0x0040      //disables windowing (necessary?)
#define OPTN_UPBO_Selector                0x0080      // 0/1 = US PSD determined from Max/Ref PSD
#define OPTN_UseForcedPilot               0x0100
#define OPTN_CeilingOptDisable            0x0200    //disables the PSD Ceiling optimization algorithm
#define OPTN_TdqDisable                   0x0400      //disables TDQ training if set
#define OPTN_DecDisable                   0x0800      //disables DEC training if set
#define OPTN_AdjustUsCeilingDisable       0x1000
// RESERVED                                 0x2000
// RESERVED                                 0x4000
#define OPTN_LattnCtrlClippingPCB         0x8000      // enables LATTN controled clipping-PCB required for Huawei linecard with
                                                    // to avoid clipping in 24V line-driver design
// OPTN_AlgControl[2]
#define OPTN_TxTcmDisable                 0x0001
#define OPTN_RxTcmDisable                 0x0002
#define OPTN_SFDQUpdatesDisable           0x0010
#define OPTN_MFDQUpdatesDisable           0x0020
#define OPTN_SNRUpdatesDisable            0x0040
#define OPTN_RxFineGainDisable            0x0080
#define OPTN_TxPSDCtrlDisable             0x0100
#define OPTN_NTRDisable                   0x0200
#define OPTN_RxIlvTrtDisable              0x0400
#define OPTN_TxSRADisable                 0x0800
#define OPTN_RxSRADisable                 0x1000
// RESERVED                                 0x2000
#define OPTN_USExtSMaxDisable             0x4000  // disables US optional extended Smax
#define OPTN_DSExtSMaxDisable             0x8000  // disables DS optional extended Smax

// OPTN_AlgControl[3]
#define OPTN_Config_4096_TONES            0x0000
#define OPTN_Config_1024_TONES            0x0001
#define OPTN_Config_512_TONES             0x0002
#define OPTN_DoubleTrainEnable            0x000E  //double train change tones from 4096 to 1024
#define OPTN_DynamicChange                0x000F  //change the number of tones on the fly.

#define OPTN_Config_8192DSUS_TONES      0x0004 //VDSL 35C operation
#define OPTN_Config_8192DS_TONES        0x0005 //VDSL 35B operation

// OPTN_FilterControl[0]
#define OPTN_TX_MASK_Filter_Select        0x00FF
#define OPTN_RX_MASK_Filter_Select        0xFF00
#define OPTN_RX_Filter_Select_POS         8

#define TX_PSD_COMPENSATION_TABLE_SIZE             (148)
#define IIR_FILTER_NO_CHANGE                       (-1)
//VDSL filters
#define OPTN_BYPASS_Filter_Select                  0x0000
#define OPTN_POTS_Filter_Select                    0x0001
#define OPTN_POTS_DOUBLE_Filter_Select             0x0002
#define OPTN_ISDN_Filter_Select                    0x0003
#define OPTN_35B_VDSL_Filter_Select                0x0004
#define OPTN_35B_VDSL_POTS_DOUBLE_Filter_Select    0x0005
#define OPTN_35B_VDSL_ISDN_Filter_Select           0x0006
//US0 only FIlters
#define OPTN_POTS_LP_Filter_Select                 0x0007
#define OPTN_ISDN_LP_Filter_Select                 0x0008
#define OPTN_POTS_DOUBLE_LP_Filter_Select          0x0009
#define OPTN_POTS_QUAD_LP_Filter_Select            0x000A
#define OPTN_35B_POTS_LP_Filter_Select             0x000B
#define OPTN_35B_ISDN_LP_Filter_Select             0x000C
#define OPTN_35B_POTS_DOUBLE_LP_Filter_Select      0x000D
#define OPTN_35B_POTS_QUAD_LP_Filter_Select        0x000E


// OPTN_FilterControl[1]
#define OPTN_Tx_Filter_Enable             0x0001
#define OPTN_Rx_Filter_Enable             0x0002
#define OPTN_Tx_Filter_Auto_Reconfig      0x4000
#define OPTN_Rx_Filter_Auto_Reconfig      0x8000

// Defines related to "OPTN_4_SIZE"
#define OPTN_4_IDX0_FILTER_CONF           0
#define OPTN_4_IDX1_FILTER_CTRL           1
#define OPTN_4_IDX2_FILTER_ACT            2
#define OPTN_4_IDX3_FILTER_GHS            3
#define OPTN_4_IDX4_FILTER_CD             4
#define OPTN_4_IDX5_FILTER_TTR            5

//----------------------------------------
// OPTN_PwrManControl
#define OPTN_PwrManWakeUpGhs              0x1
#define OPTN_PwrManWakeUpFR               0x2

//----------------------------------------
// OPTN_GhsControl
/* **************************************************************************
 * CPE Control:
 * for OPTN_GhsControl, we will assign 16bit word as follows
 * bit 0~3: set the control over which start(initial) message CPE will send:

      BIT: 2  1  0
          0  0  1  CLR
          0  1  0  MR
          0  1  1  MS
          1  0  0  MP

  * bit 4~6: set the control over which message will be sent when we get at lease one CL/CLR exchange
        BIT: 5  4
           0  1  MS
          1  0  MR
          1  1  MP

  * bit 15: RT initiated G.hs sample sessions one through eight.  Session one is default.
        BIT: 15
           1  means session one

  ******************************************************************************/
#define OPTN_GHS_ST_GHS                      0x8000
#define OPTN_GHS_INIT_MASK                   0x000F
#define OPTN_GHS_RESP_MASK                   0x00F0

#define OPTN_RTInitTxMsg_CLR                 0x0001
#define OPTN_RTInitTxMsg_MR                  0x0002
#define OPTN_RTInitTxMsg_MS                  0x0003
#define OPTN_RTInitTxMsg_MP                  0x0004

#define OPTN_RTRespTxMsg_MS                  0x0010
#define OPTN_RTRespTxMsg_MR                  0x0020
#define OPTN_RTRespTxMsg_MP                  0x0030

//----------------------------------------
// OPTN_GhsControl
/* **************************************************************************
  CO Control:
  for OPTN_GhsControl, we will assign 16bit word as follows
  This flag is to control the response to CPE's MR and MS messages in functions
  "ResponseToMR()" and "ResponseToMS()" respectively.

   Responses to MS-Msg:
   Default        (0)   Transmit ACK(1) if CL/CLR was exchanged and if mode supported, else transmit REQ_CLR.
   NAKNR_ON_MS    (1) Transmit NAK_NR, even if CL/CLR was exchanged and if mode supported.
   REQMR_ON_MS    (2) Transmit MR even if CL/CLR was exchanged and if mode is supported.
   NO_CLR_REQ     (4) Do not transmit REQ_CLR if CL/CLR was not exchanged.

   Responses to MR-Msg:
   Default        (0)   Transmit MS if CL/CLR was exchanged, else transmit REQ_CLR.
   NO_CLR_REQ     (4) Do not transmit REQ_CLR if CL/CLR was not exchanged.
   MR_FORCE_REQMS (8) Transmit REQ_MS if CO receives a NAK_NS for its previous MS message.

  ******************************************************************************/
#define OPTN_COResp_Default             (0)         // default response
#define OPTN_COResp_NAKNR_ON_MS         (1)        // Transmit NAK_NR, even if CL/CLR was exchanged and if mode supported.
#define OPTN_COResp_REQMR_ON_MS         (2)        // Transmit MR even if CL/CLR was exchanged and if mode is supported.
#define OPTN_COResp_NO_CLR_REQ          (4)        // Do not transmit REQ_CLR if CL/CLR was not exchanged.
#define OPTN_COResp_MR_FORCE_REQMS      (8)        // Transmit REQ_MS if CO receives a NAK_NS for its previous MS message.

//--------------------------------------------------------------
// OPTN_AnnexControl
// G.992.1 Annex C
#define OPTN_AnnexCModeControlMask           0x000F
#define OPTN_AnnexC_FullMode                 0x0001
#define OPTN_AnnexC_LiteMode                 0x0002
#define OPTN_AnnexC_MultMode                 0x0003
#define OPTN_AnnexC_DualBitMap               0x0010   /* enables dual bit map mode */

// G.992.3 Annex A/L1/L2 US PSD Mask preferred
#define OPTN_G992_3_AnnexA_PreferredModeMask 0x3000
#define OPTN_G992_3_AnnexA_PreferredModeA    0x0000         /* default AnnexA PSD mask */
#define OPTN_G992_3_AnnexA_PreferredModeL1   0x1000         /* AnnexL wide spectrum upstream PSD mask */
#define OPTN_G992_3_AnnexA_PreferredModeL2   0x2000         /* AnnexL narrow spectrum upstream PSD mask */

//----------------------------------------
// OPTN_StateMachineCtrl
#define OPTN_Skip_RLineProbe                 0x0001    /* Bis only */
#define OPTN_IncludeDSBlackoutBits           0x0002    /* Bis only */
#define OPTN_FFT1024_Enable                  0x0008   // set rx fft length of 1024

//Fe Read Control
#define OPTN_FeTestParamEnable               0x0010   //FE Test Param Read Control
#define OPTN_FePMCountersEnable              0x0008   //Inventory, PM counters Read Control
#define OPTN_FeTestParamPollingTime          0x1      //Showtime Polling time

#define OPTN_G992_5_14thOrderPRBS_Enable     0x0010   // if set, use 14th order prbs medley sequence in g992_5 mode

//----------------------------------------
//OPTN_ATMAddrConfig
// Bits 4:0    are Utopia address for BC1
// Bits 9:5    are Utopia address for BC0
#define OPTN_UTPADDR_BC1                     0x001F
#define OPTN_UTPADDR_BC0                     0x03E0

//----------------------------------------
//OPTN_ATMNumCellConfig
#define OPTN_RX_BC0_NUM_CELL_PAGES           0x000F /* Bits 0:3 */
#define OPTN_TX_BC0_NUM_CELL_PAGES           0x00F0 /* Bits 4:7 */

//----------------------------------------
// XDSRTFW-442: Feature_All_All_All_All_Vdsl2Sra [Start]
// OPTN_OLRControl : CMV OPTN 15
#define OPTN_US_SRAEnable                    0x0002
#define OPTN_DS_SRAEnable                    0x0004
#define OPTN_DS_SRARateCheck                 0x0008

//XDSLRTFW-720 Bug_All_VDSL2_All_FixBitSwapApiControl (Start)
#define OPTN_TxBitSwapEnable                 0x0010
#define OPTN_RxBitSwapEnable                 0x0020
//XDSLRTFW-720 Bug_All_VDSL2_All_FixBitSwapApiControl (End)

#define OPTN_DS_SRAStrictRateCheck           0x0040
//SRA Rate Check Mask for OPTN_SRAControl
#define OPTN_DS_SRARATECheckMask             0x0048
// XDSRTFW-442: Feature_All_All_All_All_Vdsl2Sra [End]

//----------------------------------------
// OPTN_LineDriver
// Independant Line Driver denotes a new board with Independant controls
// In all cases the external line driver is used
// When OPTN_IndependantLineDriver bit is set the internal line driver is powered down for power savings
// When OPTN_IndependantLineDriver bit is clear both line drivers are power off the same lines and are powered up
#define OPTN_IndependantLineDriver           0x0001
#define OPTN_GPIO0_HI                        0x0002      // Note: Holden board has an inverter so write to 1 for off
#define OPTN_GPIO1_HI                        0x0004      // Note: Holden board has an inverter so write to 1 for off
#define OPTN_TR68_POLARITY                   0x0008
#define OPTN_GPIO2_HI                        0x0010      // Note: Holden board has an inverter so write to 1 for off
#define OPTN_VDSLFilterSelect                0x0020

//----------------------------------------
// OPTN_NoiseMarginChange[1]
#define OPTN_NoiseMarginChange_NM_Ctrl_NMS_EN     0x0001
#define OPTN_NoiseMarginChange_NM_Ctrl_NMS_HW_EN  0x0002
#define OPTN_NoiseMarginChange_NM_Ctrl_NMS_DELTA  0x0004
#define OPTN_NoiseMarginChange_NM_Ctrl_NMS_NoSnr  0x0008
#define OPTN_NoiseMarginChange_NM_Ctrl_NMS_PllRef 0x0010
#define OPTN_NoiseMarginChange_NM_Ctrl_NMS_SNRLOG 0x0020  // Save 3dB SNR in MedleySnr buffer

#define Disable_All_NMS_Related_Features          0x0


//----------------------------------------
// OPTN_AlgControl[1] + OPTN_NoiseMarginChange[1] for variable "gs_MedleyFrameSynchEnableFlag"
#define EN_MEDLEY_SNR_FRAMEALIGNMENT          0x0001
#define EN_MEDLEY_SKIP_FINAL_FDQSNR           0x0002
#define EN_MEDLEY_SKIP_FIRST_FDQ              0x0004
// Not used                                   0x0008
// Not used                                   0x0010
#define EN_MEDLEY_FINAL_SNR                   0x0020

#define EN_CHDIS_SKIP_TONE9_MARKER_SYM_FDQ    0x0100
#define EN_CHDIS_SKIP_TONE9_MARKER_SYM_SNR    0x0200
#define EN_TTRAINING_FDQ_AFTER_PERIODIC       0x0400
#define EN_TTRAINING_FDQ_END                  0x0800




//==============================================================================
// CNFG register address field */
//==============================================================================
// CNFG register address field
//--------------------------------
#define CNFG_TPS_TC_DS0                       (0) // points to a structure of type (TPS_TC_BearerChannel_t)
#define CNFG_TPS_TC_DS1                       (1) // points to a structure of type (TPS_TC_BearerChannel_t)
#define CNFG_TPS_TC_US0                       (2) // points to a structure of type (TPS_TC_BearerChannel_t)
#define CNFG_TPS_TC_US1                       (3) // points to a structure of type (TPS_TC_BearerChannel_t)
#define CNFG_Overhead_Requirements            (4)
#define CNFG_PMS_TC_DS0                       (5) // points to a structure of type (PMS_TC_LatencyPath_t)
#define CNFG_PMS_TC_DS1                       (6) // points to a structure of type (PMS_TC_LatencyPath_t)
#define CNFG_PMS_TC_US0                       (7) // points to a structure of type (PMS_TC_LatencyPath_t)
#define CNFG_PMS_TC_US1                       (8) // points to a structure of type (PMS_TC_LatencyPath_t)
//#define CNFG_PMD_PARAMETERS                 (9) // Unused

#define CNFG_tx_Cnfg_BCtoLP                  (10) // Used to configure Tx BC to LP mapping etc (explicit rate tests)
                                                  // Points to a structure of type BC_LP_TPS_Map_t
#define CNFG_tx_Cnfg_Rate                    (11) // rate in 64kbps
#define CNFG_tx_Cnfg_N                       (12) // codeword size
#define CNFG_tx_Cnfg_R                       (13) // check bytes
#define CNFG_tx_Cnfg_I                       (14) // interleave block length
#define CNFG_tx_Cnfg_M                       (15) // interleave depth parameter
                                                  // VDSL1 only: Used to configure Tx framing parameters (explicit rate tests)
                                                  // Points to a structure of type Contract_t

#define CNFG_Bonding_DiscAggr_Control        (17) // Bonding is also known as PAF (PME Aggregate Function)
                                                  // Points to structure of type (Bonding_DiscAggr_Control_t)

#define CNFG_rx_Cnfg_BCtoLP                  (20) // Used to configure Rx BC to LP mapping etc (explicit rate tests)
                                                  // Points to a structure of type BC_LP_TPS_Map_t
#define CNFG_rx_Cnfg_Rate                    (21) // rate in 64kbps
#define CNFG_rx_Cnfg_N                       (22) // codeword size
#define CNFG_rx_Cnfg_R                       (23) // check bytes
#define CNFG_rx_Cnfg_I                       (24) // interleave block length
#define CNFG_rx_Cnfg_M                       (25) // interleave depth parameter
                                                  // VDSL1 only: Used to configure Rx framing parameters (explicit rate tests)
                                                  // Points to a structure of type Contract_t

#define CNFG_Snr_Margin                      (34) // SNR Margin Configuration (MIN/TAR/MAX margins)
                                                  // Points to a structure of type SnrMgnConfig_t
#define CNFG_pwr_Cnfg_Param                  (35) // Power/PSD Configuration parameters (MAXPSD, NOMPSD, NOMATP)
                                                  // Points to a structure of type PwrConfigParam_t
#define CNFG_DS_Band_Ctrl                    (36) // Downstream Band Control
#define CNFG_US_Band_Ctrl                    (37) // Upstream Band Control
                                                  // Points to a structure of type BandDescriptorTable_t
#define CNFG_DS_MAX_PSD_Brkpt_Ctrl           (38) // DS Transmit PSD Breakpoint Control (CO only)
                                                  // Points to a structure of type DsPSDDescriptorTable_t
// VDSL1 CO only: Used to configure REF US PSD
// Points to a structure of type UsPSDDescriptorTable_t
#define CNFG_US_REF_PSD_Brkpt_Ctrl           (39) // US Reference PSD Breakpoint Control
// CO only: Used to configure MAX US PSD
// Points to a structure of type UsPSDDescriptorTable_t
#define CNFG_US_MAX_PSD_Brkpt_Ctrl           (40) // US Max PSD Breakpoint Control
// Used to configure RFI BAND
// Points to a structure of type BandDescriptorTable_t
#define CNFG_RFI_Band_Ctrl                   (43) // Downstream RFI Bands
// VDSL2 only: Used to configure profile
// Points to a structure of type ProfileControl_t
#define CNFG_Profile_Ctrl                    (44) // VDSL2 Profile Control
// Used to configure GHS carrier set
#define CNFG_GHS_CarSet                      (45) // GHS Carrier Set Configuration
// VDSL2 CO only: Used to configure UPBO PSD
// Points to a structure of type UPBOPSDDescriptorTable_t
#define CNFG_UPBO_PSD_Brkpt_Ctrl             (46) // Upstream Power Backoff Breakpoint Control

#define CNFG_VirtNoiseDS_PSD_Brkpt_Ctrl      (47) // Downstream virtual noise PSD Breakpoint Control
#define CNFG_VirtNoiseUS_PSD_Brkpt_Ctrl      (48) // Upstream virtual noise PSD Breakpoint Control
#define CNFG_Alphaeus_Config                 (49) // Alphaeus configuration
#define CNFG_Modem_Config                    (50) // other miscellaneous configurations not well defined
#define CNFG_GAIN_CALIBRATION                (51) // TX and RX gain For debug/calibration purpose
#define CNFG_UPBO_CONTROL                    (52) // Upstream Power Back Off Control
#define CNFG_PARRTONES                       (53) // configure tones and scaling for PVEC calculation
#define CNFG_PARRThreshold                   (54) // TBD
#define CNFG_DilvPartition                   (55) // control partition of dilv memory between US and DS
#define CNFG_CeilingOptBandPlanEnable        (56) // enable ceiling optimization per band plan
#define CNFG_MfdqHwWkArnd                    (57) // MFDQ HW workaround parameters
#define CNFG_Misc                            (58) // miscellaneous configuration settings
#define CNFG_AfeFilters                      (59) // define bit field for ACE filter
#define CNFG_Brkpt_Alternate_Threshold       (60) // Threshold used to select Alternate set of DS and US Breakpoints
#define CNFG_DS_MAX_PSD_Brkpt_Alternate_Ctrl (61) // Alternate set of DS and US Breakpoints
#define CNFG_US_MAX_PSD_Brkpt_Alternate_Ctrl (62)

#define CNFG_DSAutoSRA_Ctrl                  (69) // DS SRA control parameters
#define CNFG_USAutoSRA_Ctrl                  (70) // US SRA control parameters
#ifdef VDSL2_SOS
   #define CNFG_Ds_SOS_Params                (71)
   #define CNFG_Us_SOS_Params                (72)

   #define CNFG_SOS_BR_DS0                   (73)
   #define CNFG_SOS_BR_DS1                   (74)

   #define CNFG_SOS_BR_US0                   (75)
   #define CNFG_SOS_BR_US1                   (76)
#endif //#ifdef VDSL2_SOS

#define CNFG_RTX_CTRL_DS_US                  (80) // DS/US ReTX control/parameters

#define CNFG_DSM_CTRL                        (82) // Enables/Disabled Vector or Vector-friendly operation
#define CNFG_CMD_MAC_FRAMECONFIGURE          (83) // Configures VTU-R MAC address
#define CNFG_US_RETX_DELAY_PARAMS            (84)
#define CNFG_AMEND2_ILV_MEM_AVAIL            (85)
#define CNFG_DBG_IMPROVED_ATTNDR             (86)
#define CNFG_RX_PSD_EXTERNAL_COMPENSATION    (87) // XDSLRTFW-2260
#define CNFG_TX_PSD_EXTERNAL_COMPENSATION    (88) // XDSLRTFW-2260
#define CNFG_BONDING_PME_ID                  (89) // XDSLRTFW-2382
#define CNFG_TXPSD_BOOST                     (90)  // XDSLRTFW-2818
#define CNFG_RETX_FORCED_FRAMING             (91)  // XDSLRTFW-3020
#define CNFG_SOS_Config_CPE                  (92)  // XDSLRTFW-3848 (Start_End)
#define CNFG_FAST_DsSRA_Config               (93)  // XDSLRTFW-4051
#define CNFGMAP_SIZE                 (CNFG_FAST_DsSRA_Config+1)

// CNFG cmv bit field definitions
//----------------------------------

// INFO2_Bonding_DiscAggr_Status[0]
// [0]   :  PAF Enable - 0:Disable: 1: PAF:Enable
// [15:1]:     Reserved
#define CNFG_PAF_ENABLE_MASK     1
#define CNFG_PAF_ENABLE_SHIFT    0

// INFO2_Bonding_DiscAggr_Status[1]
// [0]:     Reserved
// [2:1]:      Discovery Control - 01:Ready,  00:Set if Clear, 11: Clear if Same, 10: Get
// [3]:     Reserved
// [5:4]:      Aggregation Control - 01:Ready,  00:Set,  11: Invalid, 10: Get
// [15:6]:     Reserved
#define CNFG_PAF_DISC_CNTL_MASK     0x3
#define CNFG_PAF_DISC_CNTL_SHIFT 1
#define CNFG_PAF_AGGR_CNTL_MASK     0x3
#define CNFG_PAF_AGGR_CNTL_SHIFT 4


// INFO2_Bonding_DiscAggr_Status[2-4] - Discovery Code
// CPE: INFO2_Bonding_DiscAggr_Status[5-6] - Aggregate Data
// CO: INFO2_Bonding_DiscAggr_Status[6] - Set/Clear control for Aggregate Set command
#define CNFG_PAF_AGGR_CNTL_SET_MASK    0x1
#define CNFG_PAF_AGGR_CNTL_SET_SHIFT   0

// CNFG_Profile_Ctrl                     (44) - Bitmap
#define CNFG_V2_PROFILE_NONE_MASK           (0x00)
#define CNFG_V2_PROFILE_8A_MASK             (0x01)
#define CNFG_V2_PROFILE_8B_MASK             (0x02)
#define CNFG_V2_PROFILE_8C_MASK             (0x04)
#define CNFG_V2_PROFILE_8D_MASK             (0x08)
#define CNFG_V2_PROFILE_12A_MASK            (0x10)
#define CNFG_V2_PROFILE_12B_MASK            (0x20)
#define CNFG_V2_PROFILE_17A_MASK            (0x40)
#define CNFG_V2_PROFILE_30A_MASK            (0x80)
#define CNFG_V2_PROFILE_35B_MASK            (0x100)
// #define Not allowed to be used            (0x8000)
#define CNFG_V2_PROFILE_8xALL_MASK          (CNFG_V2_PROFILE_8A_MASK | \
                                             CNFG_V2_PROFILE_8B_MASK | \
                                             CNFG_V2_PROFILE_8C_MASK | \
                                             CNFG_V2_PROFILE_8D_MASK)
#define CNFG_V2_PROFILE_12xALL_MASK         (CNFG_V2_PROFILE_12A_MASK | CNFG_V2_PROFILE_12B_MASK)
#define CNFG_V2_PROFILE_ALL_MASK            (CNFG_V2_PROFILE_8xALL_MASK |  \
                                             CNFG_V2_PROFILE_12xALL_MASK | \
                                             CNFG_V2_PROFILE_17A_MASK |    \
                                             CNFG_V2_PROFILE_30A_MASK |    \
                                             CNFG_V2_PROFILE_35B_MASK)

// V2_US0MODE_ANXA
#define CNFG_V2_ANXA_US0_NONE_MASK          (0x0)
#define CNFG_V2_ANXA_US0_EU_32_MASK         (0x1)
#define CNFG_V2_ANXA_US0_EU_36_MASK         (0x2)
#define CNFG_V2_ANXA_US0_EU_40_MASK         (0x4)
#define CNFG_V2_ANXA_US0_EU_44_MASK         (0x8)
#define CNFG_V2_ANXA_US0_EU_48_MASK         (0x10)
#define CNFG_V2_ANXA_US0_EU_52_MASK         (0x20)
#define CNFG_V2_ANXA_US0_EU_56_MASK         (0x40)
#define CNFG_V2_ANXA_US0_EU_60_MASK         (0x80)
#define CNFG_V2_ANXA_US0_EU_64_MASK         (0x100)
#define CNFG_V2_ANXA_US0_ADLU_32_MASK       (0x200)
#define CNFG_V2_ANXA_US0_ADLU_36_MASK       (0x400)
#define CNFG_V2_ANXA_US0_ADLU_40_MASK       (0x800)
#define CNFG_V2_ANXA_US0_ADLU_44_MASK       (0x1000)
#define CNFG_V2_ANXA_US0_ADLU_48_MASK       (0x2000)
#define CNFG_V2_ANXA_US0_ADLU_52_MASK       (0x4000)
#define CNFG_V2_ANXA_US0_ADLU_56_MASK       (0x8000)
#define CNFG_V2_ANXA_US0_ADLU_60_MASK       (0x10000)
#define CNFG_V2_ANXA_US0_ADLU_64_MASK       (0x20000)
#define CNFG_V2_ANXA_US0_IN_12B_MASK        (0x40000)
#define CNFG_V2_ANXA_US0_IN_17A_MASK        (0x80000)
#define CNFG_V2_ANXA_US0_EU_128_MASK        (0x100000)
#define CNFG_V2_ANXA_US0_ADLU_128_MASK      (0x200000)
#define CNFG_V2_ANXA_US0_EU_ALL_MASK        (CNFG_V2_ANXA_US0_EU_32_MASK | CNFG_V2_ANXA_US0_EU_36_MASK | CNFG_V2_ANXA_US0_EU_40_MASK | CNFG_V2_ANXA_US0_EU_44_MASK | CNFG_V2_ANXA_US0_EU_48_MASK | CNFG_V2_ANXA_US0_EU_52_MASK | CNFG_V2_ANXA_US0_EU_56_MASK | CNFG_V2_ANXA_US0_EU_60_MASK | CNFG_V2_ANXA_US0_EU_64_MASK | CNFG_V2_ANXA_US0_EU_128_MASK)
#define CNFG_V2_ANXA_US0_ADLU_ALL_MASK      (CNFG_V2_ANXA_US0_ADLU_32_MASK | CNFG_V2_ANXA_US0_ADLU_36_MASK | CNFG_V2_ANXA_US0_ADLU_40_MASK | CNFG_V2_ANXA_US0_ADLU_44_MASK | CNFG_V2_ANXA_US0_ADLU_48_MASK | CNFG_V2_ANXA_US0_ADLU_52_MASK | CNFG_V2_ANXA_US0_ADLU_56_MASK | CNFG_V2_ANXA_US0_ADLU_60_MASK | CNFG_V2_ANXA_US0_ADLU_64_MASK | CNFG_V2_ANXA_US0_ADLU_128_MASK)
#define CNFG_V2_ANXA_US0_ALL_MASK           (CNFG_V2_ANXA_US0_EU_ALL_MASK | CNFG_V2_ANXA_US0_ADLU_ALL_MASK | CNFG_V2_ANXA_US0_IN_12B_MASK | CNFG_V2_ANXA_US0_IN_17A_MASK)
// V2_US0MODE_ANXB
#define CNFG_V2_ANXB_US0_NONE_MASK          (0x0)
#define  CNFG_V2_ANXB_US0_25_138_MASK       (0x1)
#define CNFG_V2_ANXB_US0_25_276_MASK        (0x2)
#define CNFG_V2_ANXB_US0_120_276_MASK       (0x4)
#define CNFG_V2_ANXB_US0_IN_12B_MASK        (0x8)
#define CNFG_V2_ANXB_US0_IN_17A_MASK        (0x10)
#define CNFG_V2_ANXB_US0_ALL_MASK           (CNFG_V2_ANXB_US0_25_138_MASK | CNFG_V2_ANXB_US0_25_276_MASK | CNFG_V2_ANXB_US0_120_276_MASK | CNFG_V2_ANXB_US0_IN_12B_MASK | CNFG_V2_ANXB_US0_IN_17A_MASK)
// V2_US0MODE_ANXC
#define CNFG_V2_ANXC_US0_NONE_MASK          (0x0)
#define CNFG_V2_ANXC_US0_25_138kHz_Type_b_MASK (0x1)
#define CNFG_V2_ANXC_US0_25_276kHz_Type_b_MASK (0x2)
#define CNFG_V2_ANXC_US0_25_138kHz_Type_co_MASK (0x10)
#define CNFG_V2_ANXC_US0_25_276kHz_Type_co_MASK (0x20)
#define CNFG_V2_ANXC_US0_IN_12B_MASK        (0x1000)
#define CNFG_V2_ANXC_US0_IN_17A_MASK        (0x2000)
#define CNFG_V2_ANXC_US0_ALL_MASK           (CNFG_V2_ANXC_US0_25_138kHz_Type_b_MASK | CNFG_V2_ANXC_US0_25_276kHz_Type_b_MASK | CNFG_V2_ANXC_US0_25_138kHz_Type_co_MASK | CNFG_V2_ANXC_US0_25_276kHz_Type_co_MASK | CNFG_V2_ANXC_US0_IN_12B_MASK | CNFG_V2_ANXC_US0_IN_17A_MASK )
// CNFG_GHS_CarSet                       (45) - Bitmap
#define CNFG_GHS_CAR_SET_A43                (1<<0) // ADSL(A); ADSL2(A,B); ADSL2+(A,I); VDSL2 w/US0
#define CNFG_GHS_CAR_SET_A43C               (1<<1) // ADSL2+(A,I,J,M) Cabinet-Case
#define CNFG_GHS_CAR_SET_B43                (1<<2) // ADSL(B); ADSL2(B); ADSL2+(B); VDSL2 w/US0
#define CNFG_GHS_CAR_SET_B43C               (1<<3) // ADSL2+(B)
#define CNFG_GHS_CAR_SET_C43                (1<<4) // ADSL(C,H,I); ADSL2(C)
#define CNFG_GHS_CAR_SET_J43                (1<<5) // ADSL2(J,M); ADSL2+(J,M)
#define CNFG_GHS_CAR_SET_V43                (1<<6) // VDSL2 wo/US0
#define CNFG_GHS_CAR_SET_V43P               (1<<7) // VDSL1 o POTS
#define CNFG_GHS_CAR_SET_V43I               (1<<8) // VDSL1 o ISDN
// CNFG_RTX_CTRL_DS_US                   (80) - Bitmap
#define CNFG_CPE_RETX_INCAPABLE             (0x000)
#define CNFG_CPE_DS_RETX_CAPABLE            (0x001)
#define CNFG_CPE_DS_US_RETX_CAPABLE         (0x002)
#define CNFG_DS_INTRA_DTU_ILV_CAPABLE       (0x008)
#define CNFG_US_INTRA_DTU_ILV_CAPABLE       (0x010)
                                            // Note: This is a force bit to enables/disable extended memory in SOC messages
                                            //       (R-MSG2: Parameter MAXDELAYOCTET_ext_R).
                                            //       Support of G.998.4 Anx D in Handshake is indicated acc. to G.998.4
                                            //       Amd3 (only if G.993.5 is supported); Indication during SOC is done
                                            //       independent from MS content for Amd2.
#define CNFG_RETX_EXTENDED_MEMORY_FORCE_SOC (0x100)
                                            // Note: Enables/Disables extended memory support according to G.998.4
                                            //       Amd3, meaning indication in G.HS and SOC messages (R-MSG2: Parameter MAXDELAYOCTET_ext_R).
                                            //       Support of G.998.4 Anx D in Handshake is indicated only if G.993.5
                                            //       is supported (acc. to G.998.4 Amd3).
#define CNFG_RETX_EXTENDED_MEMORY_AMD3      (0x200)
// CNFG_DSM_CTRL                         (82) - Bitmap
#define CNFG_DSM_CTRL_DSM_SUPPORT           (0x01) // Enable/Disable DS, US Vectoring
#define CNFG_DSM_CTRL_ANXY_SUPPORT          (0x02) // Enable/Disable Vector Friendly operation


// Masks for miscellaneous configuration (CNFG_Misc)
#define CNFG_MISC_SIZE  1
//@note: This is only used for Vinax CO and was not used by CPE. Hence commenting out and reusing the bit to
// T1.413 support in VDSL
//#define CNFG_Misc_DistributeTxRxProcessing      (0x0001) // clock gating control
//reserved
#define CNFG_MISC_NON_STANDARD_HSK_MASK           (0x1)
#define CNFG_MISC_NON_STANDARD_HSK_T1413_MASK     (0x2)

#define CNFG_Misc_LOSDetectionWorkaround     (0x0004) // LOS detection based on power only or power+SEF
#define CNFG_Misc_INPFix                     (0x0008) // Framing fix for improved INP protection

#define CNFG_Misc_SendShortCLR_G992_1                          (0x0010) // send short CLR for G992.1 mode
#define CNFG_Misc_SendShortCLR_G992_3                          (0x0020) // send short CLR for G992.3 mode
#define CNFG_Misc_SendShortCLR_G992_5                          (0x0040) // send short CLR for G992.3 mode
#define CNFG_Misc_HlogReportStdVsCustm                         (0x0080) // Standard_Vs_CustomerReq_HLOG_Reporting (XDSLRTFW-1436 Start_End)
#define CNFG_MISC_VRX518_ENABLE_GPIO14_FOR_DYING_GASP          (0x0100) //XDSLRTFW-3688 Control of GPIO14 to indicate dying gasp


// XDSLRTFW-4051: Fast downstream up shift SRA (Start)
// Bit field used for CNFG_FAST_DsSRA_Config
#define CNFG_FAST_DsSRA_Config_MaskBit0                        (0x0001) // value 1: Enable feature only for BRCM vector engine, value 0: enable feature for all vector engine
#define CNFG_FAST_DsSRA_Config_MaskBit1                        (0x0002)
#define CNFG_DISABLE_FAST_DS_UPSHIFT_SRA                       (0x8000)
// XDSLRTFW-4051: Fast downstream up shift SRA (End)

//==============================================================================
// CNTR register address and bit field definitions
// implements G997 counter parameters.
//==============================================================================

#define CNTRMAP_SIZE             (64)   //XDSLRTFW-710 VR9_VRX318_PDBRAM_Handover_OrderlyShutDown (START_END)

/*                */
/* Performance Counts   */
/*                */
#define     CNTR_TR1_Control                  0  /* Threshold TR1 for which Line Performance results need to be kept */
#define     CNTR_LinePerf_Alarm_Threshold     1  /* Performance levels of each param at whih alarm can be created */
#define     CNTR_NE_LinePerf_Running          2
#define     CNTR_NE_LinePerf_TR1_Curr_Prev    3
#define     CNTR_FE_LinePerf_Running          4
#define     CNTR_FE_LinePerf_TR1_Curr_Prev    5
#define     CNTR_LineInitPerf_Running         6
#define     CNTR_LineInitPerf_TR1_Curr_Prev   7
#define     CNTR_NE_CRC_Running               8
#define     CNTR_NE_CRC_TR1_Curr_Prev         9
#define     CNTR_NE_FEC_Running              10
#define     CNTR_NE_FEC_TR1_Curr_Prev        11
#define     CNTR_FE_CRC_Running              12
#define     CNTR_FE_CRC_TR1_Curr_Prev        13
#define     CNTR_FE_FEC_Running              14
#define     CNTR_FE_FEC_TR1_Curr_Prev        15

#define     CNTR_NE_HEC_Running              16
#define     CNTR_NE_HEC_TR1_Curr_Prev        17
#define     CNTR_NE_CD_Running               18
#define     CNTR_NE_CD_TR1_Curr_Prev         19
#define     CNTR_NE_CU_Running               20
#define     CNTR_NE_CU_TR1_Curr_Prev         21
#define     CNTR_NE_IBE_Running              22
#define     CNTR_NE_IBE_TR1_Curr_Prev        23

#define     CNTR_NE_TX_IDLE_CELL_Running     24
#define     CNTR_NE_TX_NON_IDLE_CELL_Running 25

#define     CNTR_FE_HEC_Running              26
#define     CNTR_FE_HEC_TR1_Curr_Prev        27
#define     CNTR_FE_CD_Running               28
#define     CNTR_FE_CD_TR1_Curr_Prev         29
#define     CNTR_FE_CU_Running               30
#define     CNTR_FE_CU_TR1_Curr_Prev         31
#define     CNTR_FE_IBE_Running              32
#define     CNTR_FE_IBE_TR1_Curr_Prev        33
#define     CNTR_NE_CRC_NonInhibit           35
#define     CNTR_NE_FEC_NonInhibit           36
//37
//38
#define     CNTR_NE_SEF_Defect_Count         39
#define     CNTR_FE_SEF_Defect_Count         40

#define CNTR_RETX_OVHD_COUNTER               43
#define CNTR_RETX_EFTR               0                 // 2 words
#define CNTR_RETX_EFTR_PREV          2                 // 2 words
#define CNTR_RETX_EFTR_MIN           4                 // 2 words
#define CNTR_RETX_EFTR_MIN_PREV      6                 // 2 words

#define CNTR_RETX_DTU_STATS                  44
#define CNTR_RETX_RETRANSMITTED_DTUS 0
#define CNTR_RETX_CORRECTED_DTUS     2
#define CNTR_RETX_UNCORRECTED_DTUS   4
#define     CNTR_NE_PTM_BC0                  45
#define     CNTR_FE_PTM_BC0                  47
#define     CNTR_FE_PTM_BC1                  48
#define     CNTR_NE_PTM_BC1                  49

#define     CNTR_NE_ATM_BC0                  46
#define     CNTR_NE_ATM_BC1                  50
#define     CNTR_FE_ATM_BC0                  51
#define     CNTR_FE_ATM_BC1                  52


#define     CNTR_NE_TX_CELLS_BC0            53
#define     CNTR_NE_TX_CELLS_BC1            54
#define     CNTR_DSM_STATS_GET              55
//XDSLRTFW-710 VR9_VRX318_PDBRAM_Handover_OrderlyShutDown (START)
//Counter is used to force required amount of symbols
//Min: CNTR[56], Max: PPE_ACK_WAIT_TIMEOUT
#define     CNTR_PRE_FAIL_STATE_WAIT_COUNT   56
//CNTR[56] CNTR_PRE_FAIL_STATE_WAIT_COUNT
//16 bit counter to hold the state machine to read the debug information
//during TC later tear down state, pre fail state.
//CNTR[57] CNTR_NO_OF_SYM_IN_PRE_FAIL_STATE
//CNTR[57] indicates no of symbols spent in Pre fail state(LinkDownState)
#define     CNTR_NO_OF_SYM_IN_PRE_FAIL_STATE   57
//XDSLRTFW-710 VR9_VRX318_PDBRAM_Handover_OrderlyShutDown (END)

//XDSLRTFW-1193 Feature_US_VDSL2_ALL_UsReTx_CMV(START)
#define CNTR_US_RETX_DTU_STATUS_COUNTERS                58
      #define CNTR_US_RETX_RETRANSMITTED_DTUS            0       // 32 bit
      #define CNTR_US_RETX_CORRECTED_DTUS                2       // 32 bit
      #define CNTR_US_RETX_UNCORRECTED_DTUS              4       // 32 bit


#define CNTR_US_RETX_PERF_CNT_STATS                     59
      #define CNTR_US_RETX_Errror_Free_Bits_CNT          2       // 32 bit
      #define CNTR_US_RETX_EFTR_MIN                      4       // 32 bit
      #define CNTR_US_RETX_LEFTR_DEFECT_SECONDS          6       // 32 bit
//XDSLRTFW-1193 Feature_US_VDSL2_ALL_UsReTx_CMV(END)

// XDSLRTFW-3359 (Start_End)
#define CNTR_US_SRA_REJECT                              (60)
#define CNTR_DS_SRA_REJECT                              (61)
//XDSLRTFW-3362 (Start)
#ifdef PROFILE_TASKS_35B
//CNTR to get exclusive showtime
#define CNTR_CASCADE_MODE_35B_ST_MIPS                  (62)
//CNTR to get both Training and showtime overall TC & NTC MIPS
#define CNTR_CASCADE_MODE_35B_TC_NTC_MIPS              (63)
#endif //#ifdef PROFILE_TASKS_35B
//XDSLRTFW-3362 (End)

// CNTR[CNTR_TR1_Control]
#define CNTR_TR1_Enable                0x0001
#define CNTR_TR1_AutoMsg_Enable        0x0002
#define CNTR_TR1_CntrInhibit_Enable    0x0004

//==============================================================================
// CNTR register address and bit field definitions
// implements G997 counter parameters.
//==============================================================================

#define ALGSMAP_SIZE             1

//==============================================================================
// SELT register address and bit field definitions
//==============================================================================
#define SELTMAP_SIZE             5

#define SELT_Qln                 (0) // Quite Line Noise
#define SELT_Uer                 (1) // Uncalibrated Echo response
#define SELT_UerVar                 (2) // Uncalibrated Echo response Variance
#define SELT_AmpScale               (3) // Number of scalebacks
#define SELT_QlnVar                 (4) // Number of scalebacks

//==============================================================================
// DSL register address and bit field definitions
//==============================================================================
//XDSLRTFW-561 Enhancement_All_All_All_FreqOffset [Start_End]
#define DSLMAP_SIZE                (40)

#define DSL_4_SIZE                 ((sizeof(AFEConfig_t)+1)/2)  //XDSLRTFW-3705 (Start_End)

#define DSL_FeaturesControl                         (0) // DSL_0
#define DSL_EDcontrol                               (1) // DSL_1
#define DSL_AlgControl4                             (2) // DSL_2   //#define DSL_PSDcontrol              2
#define DSL_DS_PILOT_INDEX                          (3) // DSL_3
#define DSL_AFE_READ_WRITE                          (4) // DSL_4
#define DSL_LPR_TRIGGER                             (5) // DSL_5
#define DSL_ADC_TRIM_READ_WRITE                     (6) // DSL_6   // Stefan: 12/19/2017: Unused in VRx518? //SMS00972960
#define DSL_STATUS_AFE_DFE_3GLP                     (7) // DSL_7

#define DSL_HYBRID_TYPE                             (9) // DSL_9
#define DSL_LD_MODE                                (10) // DSL_10
#define DSL_AFE_CHIPID                             (11) // DSL_11
#define DSL_BONDING_CONTINUE                       (12) // DSL_12
#define DSL_OPTIONS                                (13) // DSL_13
#define DSL_TC_STATUS                              (14) // DSL_14
#define DSL_PPE_CLOCK_CONTROL                      (15) // DSL_15


#define DSL_ADSL_FEATURE_MAP                       (19) // DSL_19 //XDSLRTFW-285: Feature_ALL_ALL_ALL_Config_Modem_Feature_Map
#define DSL_VDSL_FEATURE_MAP                       (20) // DSL_20 //XDSLRTFW-285: Feature_ALL_ALL_ALL_Config_Modem_Feature_Map
#define DSL_OPERATOR_SELECT                        (21) // DSL_21

#define DSL_TC_MODE_USED                           (23) // DSL_23 //XDSLRTFW-521 NewFeatures_ALL_ALL_ALL_ATMVDSL2 //Bit 0 -> EFM Loaded = 0x1 //Bit 1 -> ATM Loaded = 0x2//snv
#define DSL_FW_InternalControl                     (24) // DSL_24 //XDSLRTFW-118 VR9_VRX318_AFE_Init_Fail_Indication (START)
#define DSL_CRYSTAL_OFFSET                         (25) // DSL_25 //XDSLRTFW-561 Enhancement_All_All_All_FreqOffset
#define DSL_DEBUGBUFF_STATUS                       (26) // DSL_26 //XDSLRTFW-598 XDSLRTFW-600 FEATURE_ALL_ALL_ALL_Debug_Buffer
#define DSL_DEBUGBUFF_GHS_TO_EXCHANGE              (27) // DSL_27 //XDSLRTFW-598 XDSLRTFW-600 FEATURE_ALL_ALL_ALL_Debug_Buffer
#define DSL_DEBUGBUF_SHOWTIME                      (28) // DSL_28 //XDSLRTFW-598 XDSLRTFW-600 FEATURE_ALL_ALL_ALL_Debug_Buffer
#define DSL_DEBUGBUF_CONTROL_SHOWTIME              (29) // DSL_29 //XDSLRTFW-598 XDSLRTFW-600 FEATURE_ALL_ALL_ALL_Debug_Buffer
#define DSL_CONFIG_REINIT_THRESH                   (30) // DSL_30 //XDSLRTFW-956 : ENH_DS_ALL_ALL_SESx_ESx_LOMx
#define DSL_HNSK_CONTROL_INFO                      (31) // DSL_31 //XDSLRTFW-360 Enh_All_All_All_GetHandshakeControlInfo (Start_End)
#define DSL_APS_STATUS                             (32) // DSL_32 // Place holder from MCAT
#define DSL_LATN_THROSHELD_FOR_US_BAND_SWITCHING   (33) // DSL_33 // XDSLRTFW-2842 // Place holder from R9
#define DSL_PPE_CLOCK_CONFIGURE                    (34) // DSL_34 // XDSLRTFW-3565 (Start_End)
#define DSL_PPA_FW_VERSION                         (35) // DSL_35
#define DSL_PPE_FW_VERSION                         (36) // DSL_36
#define DSL_PREV_FAILSTATE                         (37) // DSL_37 // Place holder from VRx518-R4
#define DSL_PREV_EXCEPTION_CODES                   (38) // DSL_38 // Place holder from VRx518-R4
#define DSL_DBG_ALLOWED_TONE_INFO                  (39) // DSL_39

//----------------------------------------
// DSL_FeaturesControl : CMV DSL_0
// mapped to: gus_FeaturesControl
//XDSLRTFW-439: Feature_All_DS_All_All_SupportDsTxRefVirtualNoise (Start)
//XDSLRTFW-749 Fix_All_DS_All_DownStreamVirtualNoise (Start_End)
#define DSL_EnableDSVirtualNoise        0x0001   // enable DS virtual noise
#define DSL_EnableAELEM                 0x0008   // enable AELEM feature //XDSLRTFW-439: Feature_All_DS_All_All_SupportDsTxRefVirtualNoise


// XDSLRTFW-3631 (Start)
//----------------------------------------
// DSL_OPERATOR_SELECT : CMV DSL_21
//New CMV 21 used for Operator Select
#define NO_OPERATOR     (0)
#define DTAG            (1)
#define BT              (2)
#define TELEFONICA      (3)
#define FT              (4)
#define KPN             (5)
#define TELIASONERA     (6)
#define FIBER_HOME      (7)
#define CT              (8)
#define TW              (9)
#define VODAFONE        (10)
#define COMLABS_NORWAY  (11)
#define OTE_GREECE      (12)
#define TELMEX          (13) //Telecom Mexico
#define AT_T            (14) //AT&T USA //XDSLRTFW-3470 XDSLRTFW-2724 IOP_ALL_US_CNXT_DISABLE_AELEM_GHS (START_END)
#define SWISSCOM        (15)
#define NETGEAR         (16)
#define CTL             (17) //CenturyLink USA //XDSLRTFW-3470 XDSLRTFW-2724 IOP_ALL_US_CNXT_DISABLE_AELEM_GHS (START_END)
#define TELECOM_ITALIA  (18)
#define MT_HUNGARY      (19) // Magyar Telekom XDSLRTFW-3212 (Start_End)
#define TTNET           (20) // Turk Telekom
// XDSLRTFW-3631 (End)


//----------------------------------------
//DSL_FW_InternalControl : CMV DSL 24
//Bits in this group may be used for DSL FW specific controls such as
//debug, enable/disable certain algorithms etc, i.e Internal to the
//FW control.
#define DSL_VR9_VRX318_AFE_INIT_FAIL_ENABLE     (0x0001)
#define DSL_REPORT_US_NDR_AS_ETR_AT_INIT        (0x0002) //XDSLRTFW-3489 (Start_End)
#define DSL_ERASE_SRAM_VARS                     (0x8000)
//XDSLRTFW-118 VR9_VRX318_AFE_Init_Fail_Indication (END)


//-------------------------------------
// DSL_OPTIONS : CMV DSL_13
// mapped to: gus_ApiOptions
// definitions for DSL_OPTIONS cmv
//-------------------------------------
#define OPTION_NTR_DISABLE                (0x0000)
#define OPTION_NTR_ENABLE                 (0x0001)
#define OPTION_RSRVD_ADSL_EXTFRAMING      (0x0002) // Stefan: 12/19/2017: Unused in VRx518?
#define OPTION_RSRVD_ADSL_NLNF            (0x0004) // Stefan: 12/19/2017: Unused in VRx518? //XDSLRTFW-2442
#define OPTION_XO_LOW_OSC_DRIVE           (0x0008) // Stefan: 12/19/2017: Unused in VRx518? //XDSLRTFW-2442

//-------------------------------------
// DSL_ADC_TRIM_READ_WRITE : CMV DSL_6
// DSL 6 0; us_options
// Stefan: 12/19/2017: Unused in VRx518?
#define ADC_TRIM_READ_ONLY                0x0000   //If B0 = 0; Read only Enabled; default;
#define ADC_TRIM_OVER_WRITE_STAGE1        0x0001   //If B0 = 1; Over write Enabled; If B1 = 0 for stage 1 only
#define ADC_TRIM_OVER_WRITE_STAGE12       0x0011   //If B0 = 1; Over write Enabled; If B1 = 1 for stage 1 & 2 both

// XDSLRTFW-3662 (Start)
// Please refer the register DREG3 (PPE shared buffer address 0x7DC3) in document "PPE DSL Notifications", Sec 2.2.1 and point-b
// for the mask and reference value
#define PPE_FW_VERSION_MASK         0xFFFF0000
#define PPE_FW_VERSION_SHIFT        16
#define PPE_FW_VERSION_REFERENCE    0xA5A5


//==============================================================================
// Function prototypes
//==============================================================================

void CmvInit_PowerUp(void);
void CMVLatchAtLinkStart(void);
void UpdateINFOMapHWBufPtrs(void);

#endif // _CMV_H
