/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 2001 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */

#ifndef _CMV_DATA_H
#define _CMV_DATA_H

/*******************************************************************************
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   filename: cmv_Data.h
*
*   Header file for cmv_Data.h
*
*******************************************************************************/

// *****************************************************************************************************************************
// cmv_Data.h
//
// History
//
// 18/02/2013 Vinjam: Report downstream "ActInpNoErasure" & "ActInpErasure" through "CMV RATE 1 [14:15]" & "CMV_RATE 1 [16:17] respectively.
//            Also, Report upstream "ActInpNoErasure" & "ActInpErasure" through "CMV RATE 0 [14:15]" & "CMV_RATE 0 [16:17] respectively.
//            Grep for XDSLRTFW-727 FIX_All_VDSL2_All_ActInpAsPerVRxMsgSpec
//
// 05/3/2013 Vinjam: Report Delay in 0.01 milli seconds granularity to the near-end
//           Grep for XDSLRTFW-744 Enh_All_VDSL2_All_IntlvDelayIn1By100ms
//
// 24/07/2013 Ram: Incorporated review comments from Stefan. Look at JIRA 1098 for review comments.
//                 Grep for XDSLRTFW-1098: BugFix_DS_VDSL2_ALL_SES_Not_Incrementing_In_ReTx
// *****************************************************************************************************************************

#include "typedef.h"
#include "hmp_data.h"
#include "vdsl_const.h"

//==============================================================================
// Rate info structure (mapped to RATE CMV)
//==============================================================================

//XDSLRTFW-1098: BugFix_DS_VDSL2_ALL_SES_Not_Incrementing_In_ReTx (Start)
typedef struct {
    uint16 us_RateLSW; // rate LSW (in multiple of Kbps).
    uint16 us_RateMSW; // rate MSW (in multiple of Kbps).
} RateKbps_t;
//XDSLRTFW-1098: BugFix_DS_VDSL2_ALL_SES_Not_Incrementing_In_ReTx (End)

// Note: assume MaxS = 64, MaxD = 3072, Min_fs = 4
//       then the final delay might be > 0x7fff, so use uint16 for reporting IntlvDelay
typedef struct {
    //XDSLRTFW-1098: BugFix_DS_VDSL2_ALL_SES_Not_Incrementing_In_ReTx (Start)
    // per latency variables
    RateKbps_t t_CurRate[NUM_DATA_PATHS];   // Actual current rate.
    RateKbps_t t_PrevRate[NUM_DATA_PATHS];  // Actual previous rate.
    //XDSLRTFW-1098: BugFix_DS_VDSL2_ALL_SES_Not_Incrementing_In_ReTx (End)
    uint16      us_IntlDelay[NUM_DATA_PATHS]; // interleave delay (in 0.01 ms) //XDSLRTFW-744 Enh_All_VDSL2_All_IntlvDelayIn1By100ms (Start_End)
    int16       s_D[NUM_DATA_PATHS];         // interleave depth D=M*I+1 (in bytes)
    int16       s_TcmParityInfo[NUM_DATA_PATHS]; // Tcm Enabled flag + parity bytes.
    //XDSLRTFW-727 FIX_All_VDSL2_All_ActInpAsPerVRxMsgSpec (Start)
   int16    s_ActInpNoErasure[NUM_DATA_PATHS];  // INP with no erausre decoding value
   int16       s_ActInpErasure[NUM_DATA_PATHS];    //INP with erasure decoding value
    //XDSLRTFW-727 FIX_All_VDSL2_All_ActInpAsPerVRxMsgSpec (End)
   uint32 ul_ADR;//in Kbps
   uint32 ul_TDR;//in Kbps
   uint32 ul_OHRate[NUM_DATA_PATHS]; //in 28.4 format kbps
   uint32 ul_LineRate;//in bits/second

} RateInfo_t;

// MONI CMV - for FE PMD Test Param retrieval, for ME
typedef struct {
    uint16 us_trigger;

    uint16 us_StartIndex;
    uint16 us_EndIndex;
} FEReadTrigger_t;

// MONI CMV - for trigger of Eoc msgs
typedef struct {
  uint16 b_TxTrigger : 1;
  uint16 reserved    : 15;
} ClearEocTrigger_t;

// MONI CMV - for enable/disable of autonomous msgs when Clear Eoc
// msgs are rcvd or sent
typedef struct {
  uint16 b_TxAutoStatusMsgEn : 1;
  uint16 b_RxAutoStatusMsgEn : 1;
  uint16 b_AutoDataMsgEn     : 1;
  uint16 reserved2           : 13;
} ClearEocAutoMsgControl_t;

// MONI CMV - for status of Clear Eoc msgs
typedef struct {
  uint16 us_TxStatus   : 2; // 0 idle, 1 in progess, 2 complete, 3 error
  uint16 us_reserved1  : 14;
  uint16 us_RxStatus   : 2; // 0 idle, 1 in progress, 2 data available, 3 error
  uint16 us_reserved2  : 14;
} ClearEocStatus_t;

typedef struct {
  uint16 b_CpeTx        : 1; // 1 CPE sends corrupt CRC to CO, 0 CPE stops sending
  uint16 b_CpeRx        : 1; // 1 CPE receives corrupt CRC from CO, 0 CO stops sending
  uint16 us_reserved    : 14;
} CorruptCRCControl_t;

typedef struct {
    uint16 b_CpeTx              : 1; // 1 CPE is sending corrupt CRC to CO, 0 CPE is not sending
    uint16 b_CpeRx              : 1; // 1 CPE is receiving corrupt CRC from CO, 0 CO is not sending
    uint16 b_EocCpeTxMsgPending : 1;
    uint16 b_EocCpeRxMsgPending : 1;
    uint16 us_reserved2         : 12;
} CorruptCRCStatus_t;

typedef struct {
  uint16 us_EocCmd     : 2; // 1 start Eoc SetTime Msg, 2 start Eoc GetTime Msg, 0 idle
  uint16 b_AutoMsgEn   : 1; // 1 send auto msg when time has been synchronized at both ends of the link.
  uint16 us_reserved   : 13;
} TimeSyncControl_t;

typedef struct {
  uint16 us_EocStatus  : 2; // 0 done or idle, 1 in progress, 2 error
  uint16 us_reserved   : 14;
  uint8 us_FETime_HH;
  uint8 us_FETime_MM;
  uint8 us_FETime_SS;
  uint8 us_dummy;
  uint8 us_RunningTime_HH;
  uint8 us_RunningTime_MM;
  uint8 us_RunningTime_SS;
} TimeStatus_t;

//L2_Back_Channel
//Refer Message catalog - MODEM MONITOR 17
typedef struct{
    uint16 us_ErrVecProcResult; //ERB Event Result Code
    uint16 us_ErrVecSize;       //L2 Backchannel Error Vector Date Size:  L2 Back channel Header size (27) + Error vector data size
}MoniErbMsg_t;

// CMV block name array pointers
extern int16 CNTLArray[];
extern int16 gs_prev_CNTL00;    // previous copy of CNTL 0 0 CMV value

extern int16 STATArray[];
extern int16 *STAT_0_Map[];
extern int16 *STAT_1_Map[];
extern int16 *STAT_5_Map[];
extern int16 gsa_IndirectStat0[];
extern int16 gsa_Stat1_Mode[];

extern int16 *INFOMap[];
extern int16 *INFO2Map[];

extern int16 *RATEMap[];
extern RateInfo_t t_USRateInfo;
extern RateInfo_t t_DSRateInfo;

extern int16 TESTArray[];
extern int16 *TEST_25_Map[];

extern int16 OPTNArray[];
extern int16 *OPTN_0_Map[];
extern int16 *OPTN_2_Map[];
extern int16 *OPTN_4_Map[];
extern int16 *OPTN_28_Map[];
extern int16 *OPTN_29_Map[];
extern int16 gsa_Optn0_ModeControl[];
extern int16 gsa_Optn2_AlgControl[];
extern int16 gsa_Optn4_FilterControl[];

extern int16 *PLAMMap[];

extern int16 *CNFGMap[];
extern int16 gsa_Cnfg_Misc[];

//L2_Back_Channel
extern uint16 gus_DsmCtrlCmv;

extern int16 *CNTRMap[];

extern int16 *ALGSMap[];

extern int16 MONIArray[];
extern int16 *MONIMap[];

extern int16 *SELTMap[];
extern int16 *DSLMap[];
extern int16 *DSL_4_Map[];  //XDSLRTFW-3705 (Start_End)


extern int16 gs_MpWinhostControl;
extern int16 gs_ModemOperationRequired;
extern int16 gs_ModemOperationRequiredShadow;

extern uint16 gusa_MONI_ModemStat[2];
extern uint16 gusa_MONI_ModemStat_Status[];
extern uint32 gul_Pre_MONI_ModemStat_Status;
extern int16 gs_MONI_LineFailure_NE;
extern int16 gs_MONI_LineFailure_FE;
extern int16 gs_MONI_AutoRestart;
//XDSLRTFW-956 : ENH_DS_ALL_ALL_SESx_ESx_LOMx
extern int16 gsa_MONI_ShowFailure_NE[2];
extern int16 gs_MONI_ShowFailure_FE;

extern FEReadTrigger_t gt_MONI_FEReadTrigger; // For triggering FE data retrieval

// Trigger, control and status for Clear-Eoc Msgs
extern ClearEocTrigger_t gt_MONI_CEocTrigger;
extern ClearEocAutoMsgControl_t gt_MONI_CEocAutoMsgCtrl;
extern ClearEocStatus_t gt_MONI_CEocStat;

// Control and Status for Tx/Rx Corrupt CRC Eoc Msgs
extern CorruptCRCControl_t gt_MONI_CrptCRCCtrl;
extern CorruptCRCStatus_t gt_MONI_CrptCRCStat;

// Control and Status for Eoc Get/Set Time Commands
extern TimeSyncControl_t gt_MONI_TimeSyncCtrl;
extern TimeStatus_t gt_TimeStat;

extern AutoMsgPayLoadEntry_t gt_ModemReadyPayLoad;
extern uint16 gus_BootupResultCode;

extern AutoMsgPayLoadEntry_t gt_ModemStatPayLoad;
extern AutoMsgPayLoadEntry_t gt_ModemStatFailPayLoad;
extern int16 gsa_PrevStat[];

extern AutoMsgPayLoadEntry_t gt_LineFailureNEPayLoad;
//XDSLRTFW-956 : ENH_DS_ALL_ALL_SESx_ESx_LOMx
extern int16 gsa_prev_g997_Failure_Flag_NE[2];

extern AutoMsgPayLoadEntry_t gt_LineFailureFEPayLoad;
extern int16 gs_prev_g997_Failure_Flag_FE;

extern AutoMsgPayLoadEntry_t gt_Tr1RolloverPayLoad;
extern int16 gs_Tr1RolloverPayload;
extern FlagT gft_Tr1RolloverFlag;

extern AutoMsgPayLoadEntry_t gt_Tr1AlarmPayLoad;
extern FlagT gft_SendTr1AlarmFlag;

extern AutoMsgPayLoadEntry_t gt_FEDataPayload;
extern FlagT gft_SendFEDataFlag;

extern AutoMsgPayLoadEntry_t gt_CEocStatPayload;
extern FlagT gft_SendCEocStatFlag;

extern AutoMsgPayLoadEntry_t gt_CEocMsgPayload;
extern FlagT gft_SendCEocMsgFlag;

extern FlagT gft_SendTimeSyncMsgFlag;
// XDSRTFW-442: Feature_All_All_All_All_Vdsl2Sra [Start]
extern AutoMsgPayLoadEntry_t gt_ShowDSEventsPayload;
extern FlagT gft_SendDSShowEventsFlag;

extern AutoMsgPayLoadEntry_t gt_ShowUSEventsPayload;
extern FlagT gft_SendUSShowEventsFlag;
// XDSRTFW-442: Feature_All_All_All_All_Vdsl2Sra [End]

// Vector_Back_Channel
extern AutoMsgPayLoadEntry_t gt_ErbEvtPayload;
extern FlagT gft_SendErbEventFlag;
extern MoniErbMsg_t gt_MONI_ErbMsg;

// Bonding and TC information
extern AutoMsgPayLoadEntry_t gt_Bonding_TC;
extern FlagT gft_autonomous_msg_flag;
extern FlagT gft_bonding_TC_autonomous_sent;

extern HMP_DebugStreamMsg_t gt_DebugStreamMsg;

#endif // _CMV_DATA_H
