/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2002 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1432
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   filename: dec_handler.h
*
*   This is the include file for dec_handler.c.
*
*-------------------------------------------------------------------------------
*/
#ifndef _DEC_HANDLER_H
#define _DEC_HANDLER_H

// TX DEC handler states
#define TX_DEC_INIT        (0)
#define TX_DEC_QUIET    (1)
#define TX_DEC_TRAIN    (2)
#define TX_DEC_EXIT        (3)
#define TX_DEC_DONE        (4)
#define TX_DEC_PERFORMANCE  (5)

// RX DEC handler states
#define  RX_DEC_INIT       (0)
#define RX_DEC_CALC_DC     (1)
#define RX_DEC_CALC_WAIT   (2)
#define RX_DEC_AVG_FRAME   (3)
#define  RX_DEC_CALC_XCORR (4)
#define  RX_DEC_CALC_DEC      (5)
#define RX_DEC_SELECT_DELAY   (6)
#define RX_DEC_MSE_RES     (7)
#define  RX_DEC_LOAD_DEC      (8)
#define  RX_DEC_EXIT       (9)
#define  RX_DEC_DONE       (10)
#define RX_DEC_PERFORMANCE  (11)
#define RX_DEC_MEARSURE_RES (12)
#define RX_DEC_MEARSURE_EC_PATH     (13)
#define RX_DEC_MEARSURE_DEC_PATH (14)


// Definitions
#define DC_OFFSET_WT_LEN            (4)      // Wait length for calculating DC of Rx input frames
#define DC_OFFSET_CALC_LEN          (2)      // Calculate DC over 2 frames
#define LOG2_DC_OFFSET_CALC_LEN        (1)      // log2(DC_OFFSET_CALC_LEN)
#define NUM_RES_FRAMES              (4)      // num of frames to compute the residual

//// Wait length for calculating the xcorrelations
   #define CALC_DEC_WT_LEN          (5)      //This count must be greater than NUM_IFFT_BUFFERS                               //so all the IFFT buffers were filled the desired PN signal

// Strymon Rx path delay between summing junction output and FFT input
#define RX_TDQ_DELAY (1)
#define RX_VAR_GAIN_DELAY (0)
#define RX_WIN_DELAY (2)
#define STRYMON_RX_PATH_DELAY (RX_TDQ_DELAY + RX_VAR_GAIN_DELAY + RX_WIN_DELAY)

// Strymon Tx path delay prior to DEC input FIFO
#define TX_VAR_GAIN_DELAY (1)
#define TX_WIN_DELAY (0)
#define STRYMON_TX_PATH_DELAY (TX_VAR_GAIN_DELAY + TX_WIN_DELAY)

//Loopback modes
#define NO_LOOPBACK     (0)
#define ARGO_LOOPBACK   (1)
#define DEC_LOOPBACK (2)


// Prototypes
void DecHandlerTx(void);
void DecHandlerRx(void);
void UpsampleBuff16(int16 *psa_inbuf, int16 *psa_outbuf, int16 s_BuffSize, int16 s_upsampleRate);
void UpsampleBuff32(int16 *psa_inbuf, int32 *pla_outbuf, int16 s_BuffSize, int16 s_upsampleRate);
void SetupPNsignalForDECXcorr(int16 *psa_PNsingalForEC, int16 *psa_SharedYMem, int16 s_ec_sub_order);
void SumInputBuf(int16 *psa_RxTDSampleBuf, int16 s_RxFftLength, int32 *pl_Sum);
void BgEcXcorr(void);
void EcXcorr(int16 *psa_Xbuf, int16 *psa_Ybuf, int16 s_ec_sub_order, int32 *pla_Xcorr);
void IlvXcorr(int32 *pla_XcorrSubBuf, int32 *pla_XcorrWholeBuf, int16 idx_period);
int32 EcEnergyLoop(int16 *psa_InputBuf, int16 s_length, int16 s_shift);
void BgCalcEC(void);
void CalcEC(int32 *pla_Xcorr, int32 l_Energy, int16 *psa_ec_h, int16 *ps_ec_h_exp);
int32 FindPeak(int32 *pla_Xcorr, int16 length);
void ComputeEcMantissa(int16 s_energy, int16 *sa_xcorr, int16 *psa_ec_h, int16 length);
void AdjustTxPathDelay(int16 s_delay);
void AdjustEC(void);
void BgAdjustEC(void);
void ReadEC(void);
void LoadEC(void);
void ClearEC(void);
void EnableEC(void);
void MaskOffRxDecimOut(void);
void ComputeSumAbs(int16 *gpsa_InSampleBuf, int16 s_Length, int32 *pl_Output);

// TEST CODE
#define DEBUG_DEC_TRAIN

void EnableTxToRxLoopback(void);
void EnableDecLpbk(void);
void MaskOffRxDecimOut(void);

//Test DEC code

#endif // _DEC_HANDLER_H
