/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2004 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/****************************************************************************
;   Aware DMT Technology. Proprietary and Confidential.
;
;   40 Middlesex Turnpike, Bedford, MA 01730-1413
;   Phone (781) 276 - 4000
;   Fax   (781) 276 - 4001
;
;
;   File Name: eoc.h
;
;   Header file for EOC code.
;
*****************************************************************************/
// ***********************************************************************************************************
// eoc.h
//
// History
//
// 07/05/2013 ChihWen: Segmenting the block-read-ack message once its length is more than buffer size.
//                  1. For NVLT-C CO, replacing multi-read-ack with block-read-ack message.
//                  2. Properly segmenting the block-read-ack message once its length is more than buffer size.
//            Grep for: XDSLRTFW-795 Enhance_ALL_VDSL2_All_SegmentedBlockReadAck
//
//01-08-2013 Varun/Palaksha: "XDSLRTFW-1055 VDSL2 US ReTx: Overhead message changes for US ReTx Transmit"
//       Calculation or(and)  sending of below things
//     (i) In  response  to  a  Test Parameter Single  Read  command  if US retransmission is enabled
//      - INP_act_SHINE (Far-end RTX Transmitter Actual Impulse Noise protection against SHINE)
//      - INP_act_REIN (Far-end RTX Transmitter Actual Impulse Noise protection against REIN)
//    (ii)In Response to Management counter Single  Read  command  if US retransmission is enabled send Counter of rtx-tx
//    (iii)Upon reception of the Enter RTX_TESTMODE command, the VTU-R shall acknowledge it with an
//         ACK response. Afterwards, the VTU-R shall acknowledge all received DTUs if retransmission is
//         enabled  in  the  DS  direction  and  shall  stop  retransmitting  any  DTU  if  retransmission  is
//         enabled in upstream. Upon  reception  of  the  Leave  RTX_TESTMODE  command,  the  VTU-R  shall  resume
//         the  normal behaviour of retransmission in the direction where it is enabled
//    grep for XDSLRTFW-1055 Feature_US_VDSL2_ALL_UsReTx_TxOvhdTestMgmtDiag
//
//01-08-2013 Varun/Palaksha: "XDSLRTFW-1056: VDSL2 US ReTx Overhead message changes for US ReTx Receive"
//    reception of below things in  response  to  a  Single  Read  command  if US retransmission is enabled
//      -  ETR (RTX Receiver Expected Throughput)
//      - delay_act_RTX (RTX Receiver Actual Delay)
//       Modified the code so as to capture FE management counters in ReTx mode as below if US retransmission is enabled
//       - rtx-c(counter of corrected DTU)
//       - rtx-uc( counter of uncorrected DTU)
//       - Counter of ''leftr'' defect seconds
//       - Counter of error free bits
//       -   EFTR_min
//      grep for XDSLRTFW-1056 Feature_US_VDSL2_ALL_UsReTx_RxOvhdTestMgmt
//
// ************************************************************************************************************
#ifndef _EOC_H
#define _EOC_H

#include "hdlc.h"

//XDSLRTFW-795 Enhance_ALL_VDSL2_All_SegmentedBlockReadAck (START_END)
#define OVHD_MSG_SEGMENTATION

#define MAX_NSF_MSG_LEN (16)

// -------------- Constants (COMMON) ----------------------------------------------
// If an Snmp msg then the 1st 2 bytes are 0x814C
#define   MAX_ME_EOC_MSG_SIZE            510

// When the host requests FE data-- this is the max number of sub-carrier
// groups that can be sent to the host (memory limitation issue)
#define EOC_NUM_SCGs_FEDATA            60

// Inventory msg
#define VENDOR_ID_LENGTH                0x08
#define VERSION_NUM_LENGTH              0x10
#define SERIAL_NUM_LENGTH               0x20
#define MAX_AUX_INFO_BYTES              (64)

// EOC Debug Trail Length
#define EOC_TRAIL_LEN                   128

#define   EOC_MESSAGE_BUFFER_SIZE         (2788)   //MAX_TX_EOC_MSG_SIZE + MAX_RX_EOC_MSG_SIZE + (MAX_RX_EOC_MSG_SIZE - 6) + (MAX_TX_EOC_MSG_SIZE - 6)

// -------------- Constants (VDSL1) ----------------------------------------------


// -------------- Constants (VDSL2) ----------------------------------------------
// XDSRTFW-442: Feature_All_All_All_All_Vdsl2Sra [Start]
#define SRA_RECONFIG_SYMBOL         (65)   // zero based PMD frame count
#define BITSWAP_RECONFIG_SYMBOL      (9)

// Auto SRA related constants
#define MAX_LP_CHANGED_PER_SNRUPDATE (1000)
#define MAX_TONES_CHANGED_PER_SRA    (100)
#define LP_CHANGE_PER_BKGD_TASK      (10)
// XDSRTFW-442: Feature_All_All_All_All_Vdsl2Sra [End]

// We limit Sum{Lp} >= 16 as the feasible Lp configuation in L2 mode. This is to guarantee enough number
// of loaded tones (>10) in L2 mode so that we can avoid possible false detection of L2 Exit symbol.
// Note: This limit is specifically set for Socrates firmware, not a general one in BIS spec.
#define MIN_SUPPORTED_SUMLP_IN_L2_MODE   16
#define MIN_PM_REQ_PCB_VALUE            0
#define MAX_PM_REQ_PCB_VALUE            40

#define MAX_TX_EOC_MSG_SIZE        700
#define MAX_RX_EOC_MSG_SIZE        700
#define MAX_TX_EOC_BUFFER_SIZE     (MAX_TX_EOC_MSG_SIZE - 6)

#define OVHD_HIGH_PRIORITY         (0)
#define OVHD_NORMAL_PRIORITY       (1)
#define OVHD_LOW_PRIORITY          (2)
#define MAX_OVHD_PRIORITY          (3)

#define MIN_OVHD_MESSAGE_LEN       (4)
#define MAX_OVHD_MESSAGE_LEN       (1024)

/**************************/
/* BIS INDICATOR BITS     */
/**************************/
#define LOS_IB               (0x7F)
#define SEF_IB               (0xBF)
#define LPR_IB               (0xDF)
#define LCD_BC0_IB           (0x7F)
#define LCD_BC1_IB           (0xBF)


/****************************/
/* OVHD MESSAGE DESIGNATORS */
/****************************/

/* Highest priority message */
#define RECONFIG_CMD_DESIG               0x01

//#ifdef MTK_VECTORING_SUPPORT
#define EOC_CMD_G9935_ERRORFB_DESIG         0x18
//#endif

/* Normal priority message */
#define EOC_CMD_DESIG                      0x41
#define TIME_CMD_DESIG                     0x42
#define INVENTORY_CMD_DESIG                0x43
#define CNTL_PAR_RD_CMD_DESIG              0x04
#define MGMT_CNTR_RD_CMD_DESIG             0x05
#define POWER_MGMT_CMD_DESIG               0x07
#define CLEAR_EOC_CMD_DESIG                0x08
#define NSF_FACILITY_CMD_DESIG             0x3F

//#ifdef MTK_VECTORING_SUPPORT
#define EOC_CMD_G9935_UPDATE_PILOTSEQ_DESIG 0x11
//#endif

/* Low priority message */
#define PMD_TEST_PAR_RD_CMD_DESIG          0x81
#define NSF_FACILITY_LOW_CMD_DESIG         0xBF

/* Segment ACK Designator*/
#define SEGMENT_ACK_PRIOR0                  0xF0
#define SEGMENT_ACK_PRIOR1                  0xF1
#define SEGMENT_ACK_PRIOR2                  0xF2

/**************************/
/* EOC COMMAND TYPES */
/**************************/
#define PERFORM_SELF_TEST              0x01
#define UPDT_TEST_PARAMETER            0x02
#define START_TX_CORR_CRC              0x03
#define END_TX_CORR_CRC                0x04
#define START_RX_CORR_CRC              0x05
#define END_RX_CORR_CRC                0x06
#define ENTER_RTX_TESTMODE             0x07
#define LEAVE_RTX_TESTMODE             0x08
#define EOC_ACK                        0x80
#define SELF_TEST_ACK                  0x01

/****************/
/* REASON CODES */
/****************/
#define BUSY                         0x01
#define INVALID_PAR                  0x02
#define NOT_ENABLED                  0x03
#define NOT_SUPPORTED                0x04
#define INSUFF_MARGIN                0x01
#define STATE_NOT_DESIRED            0x03
#define INFEASIBLE_PARAMETER         0x04

/**************************/
/*  SEGMENT ACK MSG TYPE*/
/**************************/
#define SEGMENT_ACK_TYPE                0x01

/**************************/
/* RECONFIG COMMAND TYPES */
/**************************/
#define BITSWAP_REQ                 0x04
#define DRR_REQ                     0x05
#define SRA_REQ                     0x06
#define SOS_REQ                     0x07  //XDSLRTFW-3932(Start_End)
#define SRA_RETX_REQ                0x08
#define SOS_RETX_REQ                0x09  //XDSLRTFW-3932(Start_End)

#define DEFER_BITSWAP               0x81
#define DRR_REJECT                  0x82
#define SRA_REJECT                  0x83
#define SOS_REJECT                  0x84  //XDSLRTFW-3932(Start_End)
#define SRA_RETX_REJECT             0x85
#define SOS_RETX_REJECT             0x86  //XDSLRTFW-3932(Start_End)

//#ifdef MTK_VECTORING_SUPPORT
/***************************/
/* VECTORING COMMAND TYPES */
/***************************/
#define CMD_TYPE_ERROR_FB_REQUEST        0x01
#define CMD_TYPE_CHANGE_PILOT_SEQ        0x01
#define CMD_TYPE_CHANGE_US_FDPS_SEQ      0x02
#define PILOTSEQ_INTERRUPTION_NOTALLOWED 0x01
#define PILOTSEQ_INTERRUPTION_ALLOWED    0x02
//#endif

/**********************/
/* TIME COMMAND TYPES */
/**********************/
#define SET_TIME                   0x01
#define TIME_READ                  0x02

#define TIME_READ_ACK              0x82
#define TIME_ACK                   0x80

/**************************/
/* INVENTORY COMMAND TYPES*/
/**************************/
#define IDENT_READ                    0x01
#define AUX_IDENT_READ                0x02
#define SELF_TEST_RES_READ            0x03
#define PMD_CAP_READ                  0x04
#define PMS_TC_CAP_READ               0x05
#define TPS_TC_CAP_READ               0x06

#define IDENT_READ_ACK                0x81
#define AUX_IDENT_READ_ACK            0x82
#define SELF_TEST_RES_READ_ACK        0x83
#define PMD_CAP_READ_ACK              0x84
#define PMS_TC_CAP_READ_ACK           0x85
#define TPS_TC_CAP_READ_ACK           0x86

/****************************************/
/* CONTROL PARAMETER READ COMMAND TYPES */
/****************************************/
#define PMD_CNTRL_PAR_READ            0x01
#define PMS_TC_PAR_READ               0x02
#define TPS_TC_PAR_READ               0x03

#define PMD_CNTRL_PAR_READ_ACK         0x81
#define PMS_TC_PAR_READ_ACK            0x82
#define TPS_TC_PAR_READ_ACK            0x83

/*****************************************/
/* MANAGEMENT COUNTER READ COMMAND TYPES */
/*****************************************/
#define MGMT_CNTR_READ                0x01

#define MGMT_CNTR_READ_ACK            0x81

/*****************************************/
/* POWER MANAGEMENT COMMAND TYPES       */
/*****************************************/
#define STATE_TRANS_REQ               0x01
#define L2_REQ                        0x02
#define L2_TRIM_REQ                   0x03

#define STATE_TRANS_GRANT             0x80
#define STATE_TRANS_REJECT            0x81
#define L2_GRANT                      0x82
#define L2_REJECT                     0x83
#define L2_TRIM_GRANT                 0x84
#define L2_TRIM_REJECT                0x85

#define PLUS_L2_GRANT                 0x86

/* PM L3 state machine internal states */
#define WAITING_FOR_L3_REQUEST               1
#define WAITING_FOR_QUEUE_IN_HDLC_TX_QUEUE   2
#define WAITING_FOR_L3_RESPONSE              3

/* Possible outcomes to CPE-initiated L3 request */
#define PM_L3_GRANT_RECEIVED                 1
#define PM_L3_REJECT_RECEIVED                2
#define PM_L3_RESPONSE_TIMEOUT               3
// IOP_ALL_ALL_ALL_USDSSRA_PML2_PML3_mode (START_End)
#define PM_L3_RESPONSE_DISABLED              4

/***************************/
/* CLEAR EOC COMMAND TYPES */
/***************************/

#define CLEAR_EOC_MSG               0x01
#define CLEAR_EOC_ACK               0x80
#define CLEAR_EOC_NACK              0x81
#define CLEAR_EOC_NOT_SUPPORT       0x04

/****************************************/
/* NON STANDARD FACILITY COMMAND TYPES  */
/****************************************/
#define NSF                           0x01
#define NSF_ACK                       0x80
#define NSF_NEG_ACK                   0x81


/****************************************/
/* TEST PARAMETER READ COMMAND TYPES   */
/****************************************/
#define SINGLE_READ                         0x01
#define MULT_READ                           0x04
#define MULT_READ_BACKWARD_COMPATIBILITY    0x02
#define NEXT_MULT_READ                      0x03
#define BLOCK_READ                          0x05
#define BLOCK_READ_BACKWARD_COMPATIBILITY   0x04
#define VECTOR_BLOCK_READ                   0x06
#define SCALAR_READ                         0x07

#define SINGLE_READ_ACK                     0x81
#define MULT_READ_ACK                       0x82
#define PMD_TEST_PAR_READ_NACK              0x80
#define BLOCK_READ_ACK                      0x84
#define VECTOR_BLOCK_READ_ACK               0x86
#define SCALAR_READ_ACK                     0x87

#define EOC_MAX_SCG                     512 // max # sub-carrier groups

//#ifdef MTK_VECTORING_SUPPORT
/****************************************/
/*   G.993.5 VECTORING COMMAND TYPES     */
/****************************************/
#define EOC_G9935_ACK                    0x80     // Table 8-7/G993.5 Octet 2
#define EOC_G9935_NACK                   0x81     // Table 8-7/G993.5 Octet 2

#define EOC_G9935_INVALID_PARAMS         0x01     // Table 8-8/G993.5
#define EOC_G9935_STOP_ERRORFB           0x02     // Table 8-8/G993.5 Octet 2
//#endif

/****************************************/
/* TEST PARAMETER READ ID VALUES      */
/****************************************/
#define TEST_PARAM_HLOG_ID            0x01
#define TEST_PARAM_QLN_ID             0x03
#define TEST_PARAM_SNR_ID             0x04
#define LINE_ATTENUATION              0x21
#define SIGNAL_ATTENUATION            0x22
#define SIGNAL_TO_NOISE_MARGIN        0x23
#define ATTAIN_NET_DATA_RATE          0x24
#define NE_ACTUAL_TRANSMIT_POWER      0x25
#define FE_ACTUAL_TRANSMIT_POWER      0x26
#define FE_ACTUAL_INP_IFEC            0x27
#define FE_ACTUAL_SNRM_ROC            0x28

#define FE_INP_act_SHINE              0x41
#define FE_INP_act_RINE               0x42
//XDSLRTFW-1055 Feature_US_VDSL2_ALL_UsReTx_TxOvhdTestMgmtDiag (Start_End)
#define US_INP_act_SHINE              0x41
#define US_INP_act_REIN               0x42

#define RETX_RECEIVER_ETR             0x43
#define RETX_RECEIVER_ACTUAL_DELAY    0x44
//XDSLRTFW-1056 Feature_US_VDSL2_ALL_UsReTx_RxOvhdTestMgmt (start_End)
#define USRETX_RECEIVER_ETR           0x43
#define USRETX_RECEIVER_ACTUAL_DELAY  0x44

/****************************************/
/* REGISTER LENGTHS                       */
/****************************************/
#define TIME_REG_LENGTH               0x08
#define SELF_TEST_REG_LENGTH          0x04

/*********************************/
/* POWER MANAGEMENT STATES       */
/*********************************/
#define L0_STATE                  0x0
#define L2_STATE                  0x1
#define L3_STATE                  0x3

/*********************************/
/* SRA                      */
/*********************************/
#define SIMPLE_REQ_CNT           (0)
#define UNEXPECTED_OLR_ERROR_CNT (1)
#define UTC_RESP_CNT             (2)
#define PERFORM_CNT              (3)
#define TIMEOUT_CNT              (4)

#define DEFAULT_SRA_SETTLING_TIME     (1)      //This is in seconds
#define DEFAULT_SRA_DELTA_LP_CHANGE   (1)      //This has to be in dBs
#define TDTU_STOP_MIN                (11)      //Min Tdu_Stoppage in symbols

// these are valid values for uc_Source of TxOvhdMsgInfoStruct_t and TxOvhdMsgInfoRequest_t.
#define RESPONSE_SOURCE          0
#define AUTO_CMD_SOURCE          1
#define ME_CMD_SOURCE            2
#define MAX_SOURCE_TYPE          3

// queue size:
// o for response, 1;
// o for commands, 2 for autonomous, 1 for ME.
// o the allocated size per source could be different for diff priorities.
//   e.g., priority 0 will not available for ME_CMD_SOURCE.

#define MAX_EOC_AUTO_CMD        6
#define MAX_EOC_ME_CMD          1
#define MAX_EOC_RESPONSE        6
#define EOC_QUEUE_LENGTH        (MAX_EOC_AUTO_CMD + MAX_EOC_ME_CMD + MAX_EOC_RESPONSE)

// return values from TxEocSendRequest()
#define EOC_QUEUE_ADDED         1
#define EOC_QUEUE_FULL          2
#define EOC_QUEUE_BUSY          3
#define EOC_QUEUE_BUSY_SEGMENT  4

#define SECONDS_PER_MINUTE              60
#define MINUTES_PER_HOUR                60
#define HOURS_PER_DAY                   24

#define EOC_TRAIL_TXDELIM               0xAA
#define EOC_TRAIL_RXDELIM               0xBB
#define EOC_TRAIL_BUSYDELIM             0xAD
#define EOC_TRAIL_TIMEOUTDELIM          0xAE
#define EOC_TRAIL_QFULLDELIM            0xAF

// size in words
#define RX_CLEAR_EOC_DATA_SIZE   128

#define EOC_CEOC_TXSTAT_TXIDLE        0
#define EOC_CEOC_TXSTAT_TXINPROGRESS  1
#define EOC_CEOC_TXSTAT_TXCOMPLETE    2
#define EOC_CEOC_TXSTAT_TXERROR       3

#define EOC_CEOC_RXSTAT_RXIDLE        0
#define EOC_CEOC_RXSTAT_RXINPROGRESS  1
#define EOC_CEOC_RXSTAT_DATAAVAILABLE 2
#define EOC_CEOC_RXSTAT_RXERROR       3

#define EOC_TXRXCORRUPTCRC_ERROR      2

#define EOC_TIMECMD_TXINPROGRESS      1
#define EOC_TIMECMD_TXERROR           2

// Bit field definitions for use by gul_RxEocMsgIndicator
#define INVENTORY_IDENT_READ_MSG          0x00000001
#define INVENTORY_AUX_IDENT_READ_MSG      0x00000002


//XDSLRTFW-2184
#define MSB_WORD_MASK (0xFFFF0000)
#define LSB_WORD_MASK (0x0000FFFF)
#define FE_QLN_OFFSET (256)
#define FE_SNR_OFFSET (512)

#define BLOCK_READ_CMD     (0x1)
#define VEC_BLOCK_READ_CMD (0x2)

//----------------- Data structures (COMMON) --------------------------------------
// ME EOC parameters
typedef struct {
   int16 s_MaxAllowedTxMsgLength;   // Max allowed Tx EOC message length in bytes. Read only by ME
   int16 s_MaxAllowedRxMsgLength;   // Max allowed Rx EOC message length in bytes. Read only by ME
   int16 s_ME_EocTxMsgLength;       // Size in bytes of the command msg waiting to be sent in the
                                    // ME_EOC Tx Buffer. Written by ME for each msg sent
   int16 s_ME_EocRxMsgLength;       // Size in bytes of the received response msg in the
                                    // ME_EOC Rx Buffer. Written by ATU-R for each response received
} ME_EOC_Params_t;


// For EOC Buffers
typedef struct {
    uint16 us_NumBytes : 10;
    uint16 reserved    : 6;
    uint8 uca_MEMsg[MAX_ME_EOC_MSG_SIZE];
} CEocMsgStruct_t;

// For FE Data retrieval
typedef struct {
    uint16 us_Hlog;
    uint8 uc_Qln;
    uint8 uc_Snr;
} pmdTestParms_t;

typedef struct {
    uint16 us_reserved;

    uint16 us_StartIndex;
    uint16 us_EndIndex;

    uint16 us_HlogMeasureTime;
    uint16 us_SnrMeasureTime;
    uint16 us_QlnMeasureTime;

    pmdTestParms_t pmdTestParams[EOC_NUM_SCGs_FEDATA];
} FEData_t;

// XDSLRTFW-2774 (Start)
typedef struct {
    uint16 us_Hlog[MAX_TESTPARAMETER_ARRAY_SIZE];
    uint8  uc_Qln[ MAX_TESTPARAMETER_ARRAY_SIZE];
    uint8  uc_Snr[ MAX_TESTPARAMETER_ARRAY_SIZE];
    uint16 us_HlogMeasureTime;
    uint16 us_SnrMeasureTime;
    uint16 us_QlnMeasureTime;
    uint16 us_reserved;
} FEDataArrays_t;
// XDSLRTFW-2774 (End)

//----------------- Data structures (VDSL1) --------------------------------------


//----------------- Data structures (VDSL2) --------------------------------------

// EOC OvhdMessage Fifo structure
typedef struct {
   uint8 *MessageBuffer;   // pointer to memory for all buffers
   int16 BufferSize;       // number of locations in buffer
   int16 IndexOfOldest;
   int16 NextAvailable;
   int16 ErrorCode;
   uint16 us_OvflowCnt;    // Fifo overflow counter
}MessageOvhdFifo_t;

typedef struct {
   uint8   message_priority;    //  EOC message priority
    uint8   cntrl_field;        //  EOC message control field
   uint16  gus_FCS;             //  EOC message FCS
} EocMsgStruct_t;

typedef struct {
   uint8   uc_self_test_reg[SELF_TEST_REG_LENGTH]; // Self test result register
} OvhdRegStruct_t;

// this structure is the definition of Tx EOC queue item
typedef struct {
   uint8   uc_message_type;
   uint8   uc_message_designator;
   uint8   uc_defer_reason_code;
   uint8   uc_Source;
   uint8   uc_Segmented;
   uint8   uc_TestParameterId;
   uint16  us_param_rd_carrier_index;
   uint16  us_param_rd_start_carrier_index;
   uint16  us_param_rd_stop_carrier_index;
   FlagT   ft_MECmd;
} TxOvhdMsgInfoStruct_t;

// this structure is used to pass message info to TxEocSendRequest()
// Currently, it looks the same as TxOvhdMsgInfoStruct_t, but it might be diff later.
typedef struct {
   uint8   uc_message_type;
   uint8   uc_message_designator;
   uint8   uc_defer_reason_code;
   uint8   uc_Source;
   uint8   uc_Segmented;
   uint8   uc_TestParameterId;
   uint16  us_param_rd_carrier_index;
   uint16  us_param_rd_start_carrier_index;
   uint16  us_param_rd_stop_carrier_index;
   FlagT   ft_MECmd;
   uint16  us_numbytes;
} TxOvhdMsgInfoRequest_t;
extern TxOvhdMsgInfoRequest_t gt_OlrPm_TxOvhdMsgInfoInput;   // this one is used to pass message

/* Structure used in Tx OLR  */
typedef struct {
    int16   s_txOLRPMEvent;
   /* Specifies the state in TxOLR i.e. LOAD_TABLES, etc */
   uint8   uc_txOLRState;
   int16   s_ReconfigSymCnt;
   int16   s_ReTxSymCnt;
   // Retransmitted Response Count
   uint16 s_ResponseReXmitCnt;
} TxOLRVars_t;
extern TxOLRVars_t      gt_TxOLRVars;

/* Structure used in Rx OLR  */
typedef struct {
   /* Specifies the events in RxOLR/PM i.e. RECONFIG_Lp etc */
   int16   s_rxOLRPMEvent;
   /* Specifies the state in RxOLR/PM i.e. LOAD_TABLES, etc */
   uint8   uc_rxOLRPMState;
   int16   s_ReconfigSymCnt;
   uint16 s_RequestReXmitCnt;

} RxOLRPMVars_t;
extern RxOLRPMVars_t   gt_RxOLRPMVars;
                                             // info between OLR decision/PM to TC task
typedef struct {
   uint8 uc_ReadIndex;                        // points to to-be-sent message
   uint8 uc_WriteIndex;                     // points to next available queue item.
   uint8 uc_Semaphore;                        // to prevent FG/BG queue access conflicts
   FlagT ft_ack_expected;                     // TRUE if expecting a response for this priority
   uint8 uc_ExpectedDesignator;
   uint8 uc_ExpectedMsgType;
   uint8 uc_ExpectedTestParamId;
   uint16 us_ovhd_timer;
   uint8 uca_MaxMsgTypeCount[MAX_SOURCE_TYPE];      // Max messages per source for this priority
   uint8 uca_MsgTypeCount[MAX_SOURCE_TYPE];      // keep track of submitted messages per source

   uint16 s_TotalCmdSent;
   uint16 s_TotalRespRecv;
   uint16 s_TotalCmdRecv;
   uint16 s_TotalRespSent;

   uint8 uc_Source;                        // source type

   int32 lRxSymCnt;                                // for EOC timeouts

   uint16 us_param_rd_carrier_index;
   uint16 us_param_rd_start_carrier_index;
   uint16 us_param_rd_stop_carrier_index;

   FlagT ft_MECmd;
} TxEocControl_t;
//Following typedef specifically required for Scalar read command, should remember the requested ID when the response comes from the CO
typedef struct {
   uint8 uc_TestParameterId;

} RxOvhdMsgInfoRequest_t;
extern RxOvhdMsgInfoRequest_t gt_OlrPm_RxOvhdMsgInfoInput;   // this one is used to pass message

// this struct is used by Rx Clear EOC code
typedef struct {
   int16 *gpus_RxClearEocBuf;
   int16 gs_RxClearEocBuf_Length;
   int16 gs_RxClearEocBuf_ReadIndex;
   int16 gs_RxClearEocBuf_WriteIndex;
   int16 gs_RxClearEocBuf_OverflowCnt;
} RxClearEocBuf_t;

//OLR/PM counter, including bitswap, DRR, SRA for now
// Counter structure
typedef struct {
   uint16 us_SimpleOLRPMReq_Cnt;
   uint16 us_ExtendOLRPMReq_Cnt;
   uint16 us_OLRPMUTCResp_Cnt;
   uint16 us_ActualOLRPMPerform_Cnt;
   uint16 us_RespTimeOut_Cnt;
}OLRPMCnt_t;
// NOTE: If the number of words in this struct changes then
//       AUTO_MSG_MONI_HEADER_1 and AUTO_MSG_MONI_HEADER_3
//       must be updated to match!!
typedef struct {
   OLRPMCnt_t t_BitswapCnt;
   OLRPMCnt_t t_DRRCnt;
   OLRPMCnt_t t_SRACnt;
}OLRPMCntInfo_t;




//--------------- External variables (COMMON) -----------------------------
// Near-end Inventory message arrays
extern uint8 guca_ne_SystemVendorID[VENDOR_ID_LENGTH];
extern uint8 guca_ne_SystemVersionNum[VERSION_NUM_LENGTH];
extern uint8 guca_ne_SystemSerialNum[SERIAL_NUM_LENGTH];

// Far-end Inventory message arrays
extern uint8 guca_fe_SystemVendorID[VENDOR_ID_LENGTH];
extern uint8 guca_fe_SystemVersionNum[VERSION_NUM_LENGTH];
extern uint8 guca_fe_SystemSerialNum[SERIAL_NUM_LENGTH];

// Auxiliary Info (mapped to CMV)
extern uint8 guca_ne_AuxInvInfo[MAX_AUX_INFO_BYTES];
extern uint8 guca_fe_AuxInvInfo[MAX_AUX_INFO_BYTES];

// ME EOC parameters
extern ME_EOC_Params_t gt_ME_EocParams;

#ifdef CLEAR_EOC
// For EOC Buffers
extern CEocMsgStruct_t gt_INFO_CEocTxBuf;
extern CEocMsgStruct_t gt_INFO_CEocRxBuf;
#endif

// For FE Data retrieval
extern FEData_t gt_FEData;
extern FEDataArrays_t gt_FEParams;

// EOC Message Buffer
extern uint8 guca_EocMsgBuffers[EOC_MESSAGE_BUFFER_SIZE];

//--------------- External variables (VDSL1) ------------------------------


//--------------- External variables (VDSL2) ------------------------------

/* ===================================================*/
/* global variable declarations for Tx overhead bytes */
/* ===================================================*/
extern EocMsgStruct_t gt_TxEocMsg;
extern MessageOvhdFifo_t gt_TxEocMsgFifo;

// Flag used to indicate that a Tx EOC message is available for processing
extern FlagT gft_StartTxEOC;

/* ===================================================*/
/* global variable declarations for Rx overhead bytes */
/* ===================================================*/
extern EocMsgStruct_t gt_RxEocMsg;
extern MessageOvhdFifo_t gt_RxEocMsgFifo;
extern uint16 gus_rx_msg_index;

// Rx Clear EOC CMV structure
extern RxClearEocBuf_t gt_RxClearEocBuf_CMV;

// EOC ovhd msg variables
extern int16 gsa_Rx_OvhdMsgSegIndx[3];   //CO requested segmented ovhd msg index
extern int16 gsa_Tx_OvhdMsgSegIndx[3]; //RT xmitted segmented ovhd msg index
extern int16 gs_OvhdMsgFirstTone;      //First tone for each ovhd msg segment
extern int16 gs_MaxTonePerOvhdMsg;      //Maximum # of tones that could be held in one ovhd msg
extern FlagT gfta_FirstOvhdMsgSeg[3];      //Flag indicate whether we are forming the first ovhd msg segment

//XDSLRTFW-3107
extern uint32 gul_first_OHC_bytes;
extern uint16 gus_first_OHC_bytes_cnt;
extern FlagT gft_UsOlrInProgress;
extern int32 gla_RxMessageTimer[MAX_OVHD_PRIORITY];

extern uint16 gus_param_rd_carrier_index_Rx; // For PMD Test Param MULT_READ command
extern int16 gs_param_rd_carrier_index_Tx; // For PMD Test Param MULT_READ command
extern FlagT gft_EocME_FEBlockReadPending; // For PMD Test Param BLOCK_READ command
extern uint16 gus_EocFEData_AutoMsgIx; // Index field of the FE Data auto-msg
extern uint16 gus_EocCEocMsg_AutoMsgIx; // Index field of the Clear-Eoc-Msg auto-msg
extern int16 gs_EocCEocMsgLen; // The number of words sent in the Clear-Eoc-Msg auto-msg

extern FlagT gft_CorruptSRADRR;

extern OvhdRegStruct_t gt_TxOvhdRegister;
extern OvhdRegStruct_t gt_RxOvhdRegister;

// EOC Tx queue
extern TxOvhdMsgInfoStruct_t gta_TxOvhdMessage[MAX_OVHD_PRIORITY][EOC_QUEUE_LENGTH];

// EOC Tx queue control
extern TxEocControl_t gta_TxEocControlInfo[MAX_OVHD_PRIORITY];

// Tx EOC processing
extern uint8 *guca_tx_eoc_msg_buffer;

// Rx EOC processing
extern FlagT gft_escape_octet_received ;
extern uint8 *guca_rx_eoc_msg_buffer;

// Save the current EOC msg length
extern uint16 gus_eoc_msg_len;

// Flag indicate that CO has sent SET TIME command
extern FlagT gft_COSetTimer;

extern FlagT gft_UpdateTestPar;
extern FlagT gft_DsUsReTxDiagEnter;
extern int32 gl_self_test_result;

// Clear EOC
extern FlagT gft_TransferClearEocData;
extern uint8 guc_CEOCThreeBytesBuf[3];

// EOC timer for autonomous messages
extern uint8 guc_EocTimerCount;
extern uint16 gus_EocTimerInterval;
extern uint16 gus_FeParamTimerInterval;
extern uint16 gus_EocFramesPer100ms;

// debug counters displayed in ATE output
extern uint16 gusa_EocNumTimeouts[MAX_OVHD_PRIORITY];
extern uint16 gus_EocDesignatorErr;
extern uint16 gus_EocAckExpErr;
extern uint16 gus_EocBadPrioVal;
extern uint16 gus_EocSegmentAck;
extern uint16 gus_EocEscRcvd;
extern uint16 gus_EocLenTooSmall;
extern uint16 gus_EocLenTooBig;
extern uint16 gus_EocBadFCS;
extern uint16 gus_EocFCSCalcErr;
extern uint16 gus_EocTxIndex;
extern uint16 gus_EocRxIndex;

// flag set when inventory resp is received
extern uint16 gus_EocInvMsgResp;

// Global debug var used to indicate any Rx EOC messages
extern uint32 gul_RxEocMsgIndicator;

extern OLRPMCntInfo_t gt_DsOLRPMCnt;
extern OLRPMCntInfo_t gt_UsOLRPMCnt;

extern uint8 guc_ClearEOCAckType;

// Substitute the usage of MULT_READ and BLOCK_READ macros with guc_MULT_READ and guc_BLOCK_READ respectively.
// Initialize guc_MULT_READ to MULT_READ and guc_BLOCK_READ by BLOCK_READ by default and re-initialize them to
// 2 and 4 in post-handshake only if backward compatibility is necessary.
extern uint8 guc_MULT_READ, guc_BLOCK_READ;
extern uint16 gus_OlrDiscardCnt;

//--------------- Function prototypes (COMMON) ----------------------------
extern void TxEocInit(void);
extern void RxEocInit(void);


//--------------- Function prototypes (VDSL1) -----------------------------


//--------------- Function prototypes (VDSL2) -----------------------------

uint8 Tx_prior0_ovhd_msg_handler(uint8 *puca_msg_buffer, uint16 *pus_msg_length, TxOvhdMsgInfoStruct_t *pt_TxOvhdMsgInfo);
uint8 Tx_prior1_ovhd_msg_handler(uint8 *puca_msg_buffer, uint16 *pus_msg_length, TxOvhdMsgInfoStruct_t *pt_TxOvhdMsgInfo);
uint8 Tx_prior2_ovhd_msg_handler(uint8 *puca_msg_buffer, uint16 *pus_msg_length, TxOvhdMsgInfoStruct_t *pt_TxOvhdMsgInfo);
FlagT TxEocNextSendMessage(int32 l_PriorityIndex, TxOvhdMsgInfoStruct_t *pt_NextTxOvhdMsgInfo);
void OvhdMsg_Timeout_Handler(int32 l_PriorityIndex);
void CheckEocTimeOut(void);
void AddMessageToOvhdFifo(MessageOvhdFifo_t *fifo, uint8 message);
int16 RemoveMessageFromOvhdFifo(MessageOvhdFifo_t *fifo, uint8 *message);
void Update_OLRPMCnt(OLRPMCntInfo_t* pt_OLRPMCnt, int16 s_OLRPMType, int16 s_countType);
void PM_L3_State_Machine(void);

// Form messages of priority 2
uint8 Form_nsf_facility_msg(uint8 *puca_msg_buffer, uint16 *pus_msg_length, TxOvhdMsgInfoStruct_t *pt_TxOvhdMsgInfo);
uint8 Form_test_param_read_msg(uint8 *puca_msg_buffer, uint16 *pus_msg_length, TxOvhdMsgInfoStruct_t *pt_TxOvhdMsgInfo);

//form single read parameters
uint16 Form_SingleRd_Cmd_msg(uint8* puca_msg_buffer, uint16 k);

// Tx EOC Queue
int32 TxEocSendRequest(int32 l_PriorityIndex, TxOvhdMsgInfoRequest_t t_TxOvhdMsgInfoInput);

// Tx EOC Processor
void TxOvhdProcessor(void);

// Form messages of priority 1
uint8 Form_time_msg(uint8 *puca_msg_buffer, uint16 *pus_msg_length,
                     TxOvhdMsgInfoStruct_t *pt_TxOvhdMsgInfo);
uint8 Form_Inventory_msg(uint8 *puca_msg_buffer, uint16 *pus_msg_length,
                     TxOvhdMsgInfoStruct_t *pt_TxOvhdMsgInfo);
uint8 Form_EOC_msg(uint8 *puca_msg_buffer, uint16 *pus_msg_length,
                     TxOvhdMsgInfoStruct_t *pt_TxOvhdMsgInfo);
uint8 Form_mgmt_counter_read_msg(uint8 *puca_msg_buffer, uint16 *pus_msg_length,
                     TxOvhdMsgInfoStruct_t *pt_TxOvhdMsgInfo);
uint8 Form_Clear_EOC_msg(uint8 *puca_msg_buffer, uint16 *pus_msg_length,
                     TxOvhdMsgInfoStruct_t *pt_TxOvhdMsgInfo);
//#ifdef MTK_VECTORING_SUPPORT
// Form messages of priority 0
uint8 Form_G9935_ErrorFB_msg(uint8 *puca_msg_buffer, uint16 *pus_msg_length,
                     TxOvhdMsgInfoStruct_t *pt_TxOvhdMsgInfo);
uint8 Form_G9935_PilotUpdateResp_msg(uint8 *puca_msg_buffer, uint16 *pus_msg_length,
                     TxOvhdMsgInfoStruct_t *pt_TxOvhdMsgInfo);
//#endif


// OH msg timeout handler
void OvhdMsg_Timeout_Handler(int32 l_PriorityIndex);
void UsOvhdMsg_Timeout_Handler(int32 l_PriorityIndex);
void CheckUSEocTimeOut(void);

// Rx EOC Processor
void RxOvhdProcessor(void);
void Rx_ovhd_msg_handler(void);
void Rx_prior0_ovhd_msg_handler(uint8* puca_msg_buffer, TxOvhdMsgInfoRequest_t* t_TxOvhdMsgInfoInput);
void Rx_prior1_ovhd_msg_handler(uint8* puca_msg_buffer, TxOvhdMsgInfoRequest_t* t_TxOvhdMsgInfoInput,
                                TxEocControl_t *pt_TxEocControlInfo);
void Rx_prior2_ovhd_msg_handler(uint8* puca_msg_buffer, TxOvhdMsgInfoRequest_t* t_TxOvhdMsgInfoInput);
void rx_reconfig_cmd_handler(uint8* puca_buffer, TxOvhdMsgInfoRequest_t* t_TxOvhdMsgInfoInput);

//#ifdef MTK_VECTORING_SUPPORT
void rx_eoc_ErrorFB_msg_handler(uint8* puca_buffer, TxOvhdMsgInfoRequest_t* t_TxOvhdMsgInfoInput);
void rx_eoc_G9935_PilotUpdate_msg_handler(uint8* puca_buffer, TxOvhdMsgInfoRequest_t* t_TxOvhdMsgInfoInput);
//#endif

void rx_eoc_msg_handler(uint8* puca_buffer, TxOvhdMsgInfoRequest_t* t_TxOvhdMsgInfoInput,
                        TxEocControl_t *pt_TxEocControlInfo);
void rx_time_cmd_handler(uint8* puca_buffer, TxOvhdMsgInfoRequest_t* t_TxOvhdMsgInfoInput);
void rx_inventory_cmd_handler(uint8* puca_buffer, TxOvhdMsgInfoRequest_t* t_TxOvhdMsgInfoInput);
void rx_mgmt_par_rd_handler(uint8* puca_buffer, TxOvhdMsgInfoRequest_t* t_TxOvhdMsgInfoInput);
// XDSLRTFW-650 / XDSLRTFW-1384 (Start_End)
void rx_power_mgmt_rd_handler(uint8* puca_buffer, TxOvhdMsgInfoRequest_t* t_TxOvhdMsgInfoInput);

void rx_single_rd_param_handler(uint8* puca_buffer,TxOvhdMsgInfoRequest_t* t_TxOvhdMsgInfoInput,uint8 uc_msg_type,int32 k);

void rx_clear_eoc_handler(uint8* puca_buffer, TxOvhdMsgInfoRequest_t* t_TxOvhdMsgInfoInput);
void rx_nsf_facility_cmd_handler(uint8* puca_buffer, TxOvhdMsgInfoRequest_t* t_TxOvhdMsgInfoInput);
void rx_test_param_rd_handler(uint8* puca_buffer, TxOvhdMsgInfoRequest_t* t_TxOvhdMsgInfoInput);
void Perform_Self_test(void);

#ifdef OVHD_MSG_SEGMENTATION
void rx_segment_ack_handler(uint8 uc_message_priority, uint8* puca_msg_buffer, TxOvhdMsgInfoRequest_t* t_TxOvhdMsgInfoInput);
#endif

// Autonomous messages
void EOC_AutoMsg_Task(void);
void EOC_AutoMsg_Task_100ms(void);

// eoc trail
void EocTrail(uint8 trailDelim, uint8 uc_message_designator, uint8 uc_message_type,
             uint16 us_msg_length);

// Function to clear flags that indicate FE data retrieval is on process
void CheckMsgPendingFlags(const uint8 uc_designator, const uint8 uc_msgtype,
                          const FlagT ft_MECmd, const FlagT ft_timedout);


void CopyFeHlog(const uint16 us_CarrierGroup, const uint16 us_MeasureTime, const uint16 us_Hlog);
void CopyFeQln(const uint16 us_CarrierGroup, const uint16 us_MeasureTime, const uint8 uc_Qln);
void CopyFeSnr(const uint16 us_CarrierGroup, const uint16 us_MeasureTime, const uint8 uc_Snr);


#endif /* _EOC_H */
