/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2004 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   filename: g997.h
*
*   Header file for G997 related defines.
*
*-------------------------------------------------------------------------------
*/

#ifndef _G997_H
#define _G997_H

//==============================================================================
// G997 constants
//==============================================================================

#define MIN_MARGIN_COUNT_THRESHOLD  3514      /* 58.58 * x in sec */


// The following constants are for either 4 kHz or 8 kHz mode.
#define CRCS_TO_DECLARE_SES                 (18)       // ??
#define NUM_OF_100MS_PER_15MIN              (15*60*10) // 15 mins = 900 s = 9000 * 100 ms.
#define DEFAULT_PERFORMANCE_THRESHOLD     (15*60)     // 15 mins = 900 s: should check Recommendation M.2100 for default

#define VDSL1_4P3KHZ_FRAMES_PER_100MS       (431)   // # frames per 100ms when cores run at 4.3125KHz (i.e. during READY and GHS)
#define VDSL1_8P6KHZ_FRAMES_PER_100MS       (2*VDSL1_4P3KHZ_FRAMES_PER_100MS) // # frames per 100ms when cores run at 8.625KHz
// The following constants are for VDSL1 in 4 kHz mode.
// VDSL1 has 10 symbols per superframe.
#define VDSL1_4KHZ_FRAMES_PER_100MS          (400)   // # frames per 100ms
#define VDSL1_4KHZ_PMDFRAMES_PER_1_SEC (4000)
#define VDSL1_4KHZ_PMDFRAMES_PER_2_5SEC   (10000)  // 2.5*4000
#define VDSL1_4KHZ_PMDFRAMES_PER_10_SEC   (10*VDSL1_4KHZ_PMDFRAMES_PER_1_SEC)
#define VDSL1_4KHZ_PMDFRAMES_PER_15_SEC   (15*VDSL1_4KHZ_PMDFRAMES_PER_1_SEC)

// The following constants are for VDSL1 in 8 kHz mode.
#define VDSL1_8KHZ_FRAMES_PER_100MS         (2*VDSL1_4KHZ_FRAMES_PER_100MS)
#define VDSL1_8KHZ_PMDFRAMES_PER_1_SEC    (2*VDSL1_4KHZ_PMDFRAMES_PER_1_SEC)
#define VDSL1_8KHZ_PMDFRAMES_PER_2_5SEC   (2*VDSL1_4KHZ_PMDFRAMES_PER_2_5SEC)
#define VDSL1_8KHZ_PMDFRAMES_PER_10_SEC   (2*VDSL1_4KHZ_PMDFRAMES_PER_10_SEC)


// defines for G997 Link state
#define G997_LINK_IDLE      0
#define G997_LINK_UNAVAIL   1
#define G997_LINK_AVAIL     2

// defines for train state
#define G997_TRAIN_IDLE     0
#define G997_TRAIN_DMT_FULL     1
#define G997_TRAIN_DMT_LITE     2
#define G997_TRAIN_BIS_FULL     3
#define G997_TRAIN_BIS_LITE     4
#define G997_TRAIN_PLUS       5
#define G997_TRAIN_DMT_LITE_FAST 6
#define G997_TRAIN_BIS_FULL_FAST 7
#define G997_TRAIN_BIS_LITE_FAST 8
#define G997_TRAIN_T1413      9

// defines for Line Unavailable state machine
#define UAS_STATE_LINE_UNAVAIL   0
#define UAS_STATE_LINE_AVAIL     1

#define LINE_FAILURES_DEFAULT_G997                  (0x11)

//Defined bits use to indicate G997 Failures in PLAM CMV 0
#define LOS_FAILURE_BIT             0x0001
#define LOF_FAILURE_BIT             0x0002
#define  LPR_FAILURE_BIT               0x0004
#define LOM_FAILURE_BIT             0x0008
#define NCD_LP0_FAILURE_BIT            0x0010   //Not yet implemented
#define NCD_LP1_FAILURE_BIT            0x0020   //Not yet implemented
#define LCD_LP0_FAILURE_BIT            0x0040   //Not yet implemented
#define LCD_LP1_FAILURE_BIT            0x0080   //Not yet implemented
#define NCD_BC0_FAILURE_BIT            0x0100   //Not yet implemented
#define NCD_BC1_FAILURE_BIT            0x0200   //Not yet implemented
#define LCD_BC0_FAILURE_BIT            0x0400   //Not yet implemented
#define LCD_BC1_FAILURE_BIT            0x0800   //Not yet implemented
#define LOL_FAILURE_BIT             0x1000
#define ESE_FAILURE_BIT             0x2000
#define PRO_FPO_FAILURE_BIT            0x4000   //PRO at CO and FPO at CPE
#define LINIT_FAILURE_BIT           0x8000   //Not yet implemented

// XDSLRTFW-1479 (Start)
#define DATAPATH_NCD_NE_BC0             0x0001
#define DATAPATH_LCD_NE_BC0             0x0002
#define DATAPATH_NCD_FE_BC0             0x0100
#define DATAPATH_LCD_FE_BC0             0x0200
// XDSLRTFW-1479 (End)

//XDSLRTFW-956 : ENH_DS_ALL_ALL_SESx_ESx_LOMx
//ESx & SESx are on Byte 1
#define SESX_FAILURE_BIT            0x0001
#define ESX_FAILURE_BIT             0x0002

#define ATM_FAILURES_DEFAULT_G997                   (0xff)

#define NUM_OF_SYSTEMPERF_SEC_G997              (10)

//==============================================================================
// G997 function prototypes
//==============================================================================

// g997_init.c
void G997_InitHandler_PowerUp(void);
void G997_InitCounterHandler(void);
void G997_InitStructureHandler(void);
// local
void InitLineFailureStruct(G997_LineFailure_t *pt_LF);

void InitSystemPerfThresholdStruct(G997_LinePerfThreshold_t *pt_SPT);
void InitAlarmIndicatorStruct(G997_TR1AlarmIndicators_t *pt_SPT);
void InitAlarmAutoMessageEnableStruct(G997_MONI_TR1AlarmEnable_t *pt_SPT);
void InitAtmFailureStruct(G997_AtmFailure_t *pt_AF);
void InitCntrlStruct(G997_Cntrl_t *pt_Ct);

// g997_showinit.c
void G997_RestartHandler(void);

// g997.c
void G997_SymbolBased_Task(void);
void G997_SuperFrame_Task(void);
void G997_FailureCounterUpdate(int16* ps_count, FlagT ft_present);
void ProcessG997Failures(G997_Failure_State_t* pt_Defect, uint8 uc_AnomDefIndicator, uint16 *pus_FailFlag,
                         uint16 us_ReInitTriggerFlag, int16 s_PMDFramesPerIBStructure);

// local
void G997_1sec_Task(void);
void G997_1sec_Task_VDSL2(void);
void G997_Copy_TR1_Counters(void);
void G997_Clear_TR1_Counters(void);
void G997_TR1_Task(void);
void G997_CheckTR1FailureChange(void);
void G997_SetFailuresActive(void);
void G997_CheckRxFailure(void);
void G997_CheckTxFailure(void);
void G997_CheckUsMargin(void);
void SetBit(int32 s_in, int32 s_thres, int32 *ps_res, int32 *ps_i);
void SetTwoBits(int16 s_in, int16 s_act_thres, int16 s_inact_thres, int16 *ps_act_res, int16 *ps_inact_res, int16 *ps_i);
void UpdateSecCounter(int32 *ps_cnt, int32 *ps_SecCnt);
void UpdateSecCounter_running(int32 *ps_cnt, int32 *ps_SecCnt);
void UpdateSecCounter_running_delayed(int32 *pl_cnt, int32 *pl_SecCnt, uint16* delay_buf);
void UpdateSecCounter_running_inhibited(int32* p_cnt, int32* p_cnt_curr_reading, void* p_cnt_last_10_sec, uint8 reset, uint8 changed_from_unavail_to_avail);
void UpdateRunningCounter(int32 *ps_RunningCnt, int32 *ps_SecCnt);
void printIBStatus();
#endif // _G997_H
