/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2004 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   filename: g997_typedef.h
*
*   Header file for G997 structure definitions.
*
*-------------------------------------------------------------------------------
*/

// ***********************************************************************************************************
// g997_typedef.h
//
// History
//
// 05/12/2012 Ram: Aligning the struct 'G997_SignalAndMarginParams_t' according to Msg Spec ver 1.8:- CMV 'INFO 68'
//                 Grep for 'XDSLRTFW-466: BugFix_DS_VDSL2_ALL_Align_As_Per_CMV_INFO_68'
//
//01-08-2013 Varun/Palaksha: "XDSLRTFW-1056: VDSL2 US ReTx Overhead message changes for US ReTx Receive"
//    reception of below things in  response  to  a  Single  Read  command  if US retransmission is enabled
//    -  ETR (RTX Receiver Expected Throughput)
//    - delay_act_RTX (RTX Receiver Actual Delay)
//       Modified the code so as to capture FE management counters in ReTx mode as below if US retransmission is enabled
//    - rtx-c(counter of corrected DTU)
//    - rtx-uc( counter of uncorrected DTU)
//    - Counter of ''leftr'' defect seconds
//    - Counter of error free bits
//    -  EFTR_min
//    grep for XDSLRTFW-1056 Feature_US_VDSL2_ALL_UsReTx_RxOvhdTestMgmt
//
// ************************************************************************************************************

#ifndef _G997_TYPEDEF_H
#define _G997_TYPEDEF_H

// Definition of variables used in Failure condition state machine
#define STEADY_STATE       1
#define TRIGGERED_STATE    2
#define FAILED_STATE       3

//==============================================================================
// G997 structure definitions
//==============================================================================


//G997_NE_LinePerf_t - Section 7.2.1.1 of the G997 Spec.
typedef struct
{
   int32 l_FECS_L_count;      // G997 7.2.1.1.1 - NE FECs seconds
   int32 l_ES_L_count;        // G997 7.2.1.1.2 - NE FE Errored seconds
   int32 l_SES_L_count;       // G997 7.2.1.1.3 - NE FE Severely Errored seconds
   int32 l_LOSS_L_count;      // G997 7.2.1.1.4 - NE FE Loss of Signal seconds
   int32 l_UAS_L_count;       // G997 7.2.1.1.5 - NE FE Unavailable seconds
}G997_NE_LinePerf_t;
//==============================================================================

//G997_NE_Curr_Prev_LinePerf_t - Section 7.2.1.1 of the G997 Spec.
typedef struct
{
   G997_NE_LinePerf_t t_Current;  // Current NE TR1 Period Line performance
   G997_NE_LinePerf_t t_Previous; // Previous NE TR1 Period Line performance
}G997_NE_Curr_Prev_LinePerf_t;

//==============================================================================

//G997_FE_LinePerf_t - Section 7.2.1.2 of the G997 Spec.
typedef struct
{
   int32 l_FECS_LFE_count;    // G997 7.2.1.2.1 - FE FECs seconds
   int32 l_ES_LFE_count;      // G997 7.2.1.2.2 - FE Errored seconds
   int32 l_SES_LFE_count;     // G997 7.2.1.2.3 - FE Severely Errored seconds
   int32 l_LOSS_LFE_count;    // G997 7.2.1.2.4 - FE Loss of Signal seconds
   int32 l_UAS_LFE_count;     // G997 7.2.1.2.5 - FE Unavailable seconds
}G997_FE_LinePerf_t;
//==============================================================================

//G997_FE_Curr_Prev_LinePerf_t - Section 7.2.1.2 of the G997 Spec.
typedef struct
{
   G997_FE_LinePerf_t t_Current;  // Current FE TR1 Period Line performance
   G997_FE_LinePerf_t t_Previous; // Previous FE TR1 Period Line performance
}G997_FE_Curr_Prev_LinePerf_t;
//==============================================================================

// G997_LineInitPerf_t
typedef struct {
   int32 l_FullInitCount;
   int32 l_FailedFullInitCount;
   int32 l_ShortInitCount;
   int32 l_FailedShortInitCount;
}G997_LineInitPerf_t;

//==============================================================================

// G997_LineInitPerf_t
typedef struct {
   G997_LineInitPerf_t t_Current;
   G997_LineInitPerf_t t_Previous;
}G997_Curr_Prev_LineInitPerf_t;

//==============================================================================

//G997_NE_ChMonCRC - Section 7.2.2.1.1 of the G997 Spec.
typedef struct
{
   int32 la_CV_C_count[NUM_DATA_PATHS];      // G997 7.2.2.1.1 - NE CRC-8 count for LP0 and LP1
}G997_NE_ChMonCRC_t;
//==============================================================================

//G997_NE_Curr_Prev_ChMonCRC - Section 7.2.2.1.1 of the G997 Spec.
typedef struct
{
   G997_NE_ChMonCRC_t t_Current;  //Current NE TR1 period Chanel performance
   G997_NE_ChMonCRC_t t_Previous; //Previous NE TR1 period Chanel performance
}G997_NE_Curr_Prev_ChMonCRC_t;

//==============================================================================

//G997_FE_ChMonCRC - Section 7.2.2.2.1 of the G997 Spec.
typedef struct
{
   int32 la_CV_CFE_count[NUM_DATA_PATHS]; // G997 7.2.2.2.1 - FE CRC-8 count for LP0 and LP1
}G997_FE_ChMonCRC_t;
//==============================================================================

//G997_FE_Curr_Prev_ChMonCRC - Section 7.2.2.2.1 of the G997 Spec.
typedef struct
{
   G997_FE_ChMonCRC_t t_Current;  //Current NE TR1 period Chanel performance
   G997_FE_ChMonCRC_t t_Previous; //Previous NE TR1 period Chanel performance
}G997_FE_Curr_Prev_ChMonCRC_t;
//==============================================================================

//G997_NE_ChMonFEC - Section 7.2.2.1.2 of the G997 Spec.
typedef struct
{
   int32 la_FEC_C_count[NUM_DATA_PATHS];     // G997 7.2.2.1.2 - NE RS corrected frames for LP0/ LP1
   int32 la_FECV_C_count[NUM_DATA_PATHS];    // Aware specific - NE of FE Uncorrected Codeword count for LP0/ LP1
   int32 la_CW_C_count[NUM_DATA_PATHS];      // Aware specific - NE or FE Codeword count for LP0/ LP1
}G997_NE_ChMonFEC_t;

//==============================================================================

//G997_NE_Curr_Prev_ChMonFEC - Section 7.2.2.1.2 of the G997 Spec.
typedef struct
{
   G997_NE_ChMonFEC_t t_Current;
   G997_NE_ChMonFEC_t t_Previous;
}G997_NE_Curr_Prev_ChMonFEC_t;

//==============================================================================

//G997_FE_ChMonFEC - Section 7.2.2.2.2 of the G997 Spec.
typedef struct
{
   int32 la_FEC_CFE_count[NUM_DATA_PATHS];      // G997 7.2.2.2.2 - FE RS corrected frames for LP0/ LP1
   int32 la_FECV_CFE_count[NUM_DATA_PATHS];     // Aware specific - FE of FE Uncorrected Codeword count for LP0/ LP1
   int32 la_CW_CFE_count[NUM_DATA_PATHS];       // Aware specific - FE or FE Codeword count for LP0/ LP1
}G997_FE_ChMonFEC_t;
//==============================================================================

//G997_FE_Curr_Prev_ChMonFEC - Section 7.2.2.2.2 of the G997 Spec.
typedef struct
{
   G997_FE_ChMonFEC_t t_Current;
   G997_FE_ChMonFEC_t t_Previous;
}G997_FE_Curr_Prev_ChMonFEC_t;

//============================================================================
//G997 Failure State Machine
//
typedef struct {
   uint16 us_NextState;              // States can be INIT, STEADY, TRIGGERED or FAILED
   uint16 us_PrevState;              // Previous state; Used to detect state transitions.
   uint32 ul_Duration;               // Duration for which device is in current state
   uint32 ul_Duration_reset;         // Duration for which device is in current state
   uint32 ul_FailureSetPeriod;       // Superframes for which defect must be present
                                       // for failure to be declared
   uint32 ul_FailureResetPeriod;     // Superframes for which defect must be absent
                                       // after failure for Failure to be cleared
   uint16 us_FailureBitNumber;       // Bit position in PLAM CMV 0 to indicate failure type
   uint32 ul_ReInitPeriod;           // Superframes for which defect must be present
                                       // for Re-Init to be declared
}G997_Failure_State_t;
//==============================================================================

// G997_LineFailures
typedef struct{
   //XDSLRTFW-2094/2050
   G997_Failure_State_t t_OOS;   //OOS is defined as an indication by CPE only when it detects
                                 //a OOS condition at the CPE.
   G997_Failure_State_t t_LOS;   //G997 7.1.1.1.1 - Loss of Signal failure. 2.5Sec to get to
                                 //failure and 10 secs to get out of failure
   G997_Failure_State_t t_LOF;   //G997 7.1.1.1.2 - Loss of Framing Failure. 2.5Sec to get to
                                 //failure and 10 secs to get out of failure
   G997_Failure_State_t t_LPR;   //G997 7.1.1.1.3 - Loss of Power - 2.5sec after DGASP from CPE.
                                 //Failure cleared after 10 sec. Input at CPE, output for CO.
   G997_Failure_State_t t_LOM;   //Alcatel Recommendation - Average SNR fell below the
                                 //threshold set by the Operator. 20 Sec to failure and
                                 //10 sec out of it.
   G997_Failure_State_t t_LOL;   //RFC 3728 - Loss of Link - When CO is in LOS but no DGASP
                                 //came from CPE. No duration tied to this failure.
   G997_Failure_State_t t_ESE;   //Alcatel Recommendation - 10 seconds of continuous SES or
                                 //no communication with OAM. 10 Secs to failure 0 secs to reset.
   G997_Failure_State_t t_PRO;   //G993.1 - PRO is defined as a local power switch off by operator.
                                 //In case of PRO, Bit 6 in TX IB2 is set. No duration is tied
                                 //to this failure.
   G997_Failure_State_t t_FPO;   //FPO is defined as an indication by CPE only when it detects
                                 //a PRO condition at the CPE. The ME sets Bit 6 in Tx IB2 at the CPE
                                 //to inform the CO that the CPE is under
                                 //power failure condition. No duration is tied to this failure.
  //XDSLRTFW-956 : ENH_DS_ALL_ALL_SESx_ESx_LOMx
   G997_Failure_State_t t_ESx;
   G997_Failure_State_t t_SESx;
}G997_LineFailure_t;

//==============================================================================
// G997 LOS defect structure - used to monitor signal level and detect LOS condition
typedef struct{
   int16 s_MonitorToneIndex;
   int16 s_SymbolCnt;
   int16 s_Log2NumFramesToAccum;
   int16 l_TonePower;
   int16 l_TonePowerThreshold;
}G997_LosDefectDetect_t;

//==============================================================================
// G997_LinePerf_help
typedef struct{
   int16 s_TR1_failure;             //Bit Mapped indicator for Line Performance threshold exceed faults.
   int32 l_1Sec_CRC8_L_count;       // NE number of crc errors detected within 1 second interal in Q8.8 format
   int16 s_UAS_L_State;             // Line Unavailable state : 1 -> Line available, 0 -> Line unavailable
   int16 s_UAS_L_TriggerCnt;        // Consecutive SES seconds cnt while line is available
                                    // OR Consecutive no SES seconds cnt while line is unavailable
   int16 s_1Sec_CRC8_FE_count;      // FE number of crc errors detected within 1 second interal
   int16 s_UAS_LFE_State;           // FE UAS detected within 1 second interal
   int16 s_Sec_SES_LFE_count;       // FE SES detected within 1 second interal
   int16 s_10secCnt;
}G997_LinePerf_help_t;

//==============================================================================
// G997_LinePerf_sec
typedef struct {
   int16 s_TR1_failure;          //Bit Mapped indicator for Line Performance threshold exceed faults.
   int16 s_LOSS_L_sec_count;     // near end loss-of-signal-defects count (1 second intervals with errors)
   int16 s_ECS_L_sec_count;      // near end FEC-F anomalies count (1 second intervals with errors)
   int16 s_ES_L_sec_count;       // near end CRC-anomaly-LOS-SEF-LPR-defect count (1 second intervals with errors)
   int16 s_SES_L_sec_count;      // near end CRC-anomaly-LOS-SEF-LPR-defect count (1 second intervals with at least 18 errors)
   int16 s_UAS_L_sec_count;      // near end UnAvailableSeconds (1 second intervals with at leat 10 contiguous SES-Ls)
   int16 s_LOSS_LFE_sec_count;   // far end loss-of-signal-defects count (1 second intervals with errors)
   int16 s_ECS_LFE_sec_count;    // far end FEC-F anomalies count (1 second intervals with errors)
   int16 s_ES_LFE_sec_count;     // far end CRC-anomaly-LOS-SEF-LPR-defect count (1 second intervals with errors)
   int16 s_SES_LFE_sec_count;    // far end CRC-anomaly-LOS-SEF-LPR-defect count (1 second intervals with at least 18 errors)
   int16 s_UAS_LFE_sec_count;    // far end UnAvailableSeconds (1 second intervals with at leat 10 contiguous SES-Ls)
}G997_LinePerf_sec_t;
//==============================================================================

// G997_SystemPerfThreshold

typedef struct
{
   int32 l_dummyvar_align1;   // Used to get this data structure allocated from a double word boundary
   int16 l_dummyvar_align2;   // Used to get the next members of this structure allocated contiguously
   int16 l_FECS_L_count;      // G997 7.2.1.1.1 - NE FECs seconds
   int16 l_ES_L_count;        // G997 7.2.1.1.2 - NE Errored seconds
   int16 l_SES_L_count;       // G997 7.2.1.1.3 - NE Severely Errored seconds
   int16 l_LOSS_L_count;      // G997 7.2.1.1.4 - NE Loss of Signal seconds
   int16 l_UAS_L_count;       // G997 7.2.1.1.5 - NE Unavailable seconds
   int32 l_CRC_L_count;       // G997 7.2.1.1.5 - NE CRC count
   int32 l_FEC_L_count;       // G997 7.2.1.1.5 - NE FEC count
}G997_LinePerfThreshold_NE_t;

typedef struct
{
   int16 l_dummyvar_align2;   // Used to get the next members of this structure allocated contiguously
   int16 l_FECS_LFE_count;    // G997 7.2.1.1.1 - FE FECs seconds
   int16 l_ES_LFE_count;      // G997 7.2.1.1.2 - FE Errored seconds
   int16 l_SES_LFE_count;     // G997 7.2.1.1.3 - FE Severely Errored seconds
   int16 l_LOSS_LFE_count;    // G997 7.2.1.1.4 - FE Loss of Signal seconds
   int16 l_UAS_LFE_count;     // G997 7.2.1.1.5 - FE Unavailable seconds
   int32 l_CRC_LFE_count;     // G997 7.2.1.1.5 - FE CRC count
   int32 l_FEC_LFE_count;     // G997 7.2.1.1.5 - FE FEC count
}G997_LinePerfThreshold_FE_t;

//G997_LinePerfThreshold_t - Section 7.2.1.1 of the G997 Spec.
typedef struct
{
   G997_LinePerfThreshold_NE_t t_NE_Alarm;
   G997_LinePerfThreshold_FE_t t_FE_Alarm;
   int16 s_MaxUpdate;            // time interval to check for change of indications
   int16 s_CurUpdate;            // time interval to check for change of indications
   int16 s_Prev_TR1_failure;     // prev state of TR1 indications
   int16 s_Mask_TR1_failure;     // enable mask for reporting
}G997_LinePerfThreshold_t;

//==============================================================================

//==============================================================================

typedef struct
{
   int32 la_HEC_P_count[ATM_NUM_BC]; // Section 7.2.4.1.1 - near end HEC error count
}G997_NE_AtmPerf_HEC_t;

typedef struct
{
   G997_NE_AtmPerf_HEC_t t_Current;
   G997_NE_AtmPerf_HEC_t t_Previous;
}G997_NE_Curr_Prev_HEC_t;

typedef struct
{
   int32 la_HEC_PFE_count[ATM_NUM_BC]; // Section 7.2.4.2.1 - far end HEC error count
}G997_FE_AtmPerf_HEC_t;

typedef struct
{
   G997_FE_AtmPerf_HEC_t t_Current;
   G997_FE_AtmPerf_HEC_t t_Previous;
}G997_FE_Curr_Prev_HEC_t;

typedef struct
{
   int32 la_CD_P_count[ATM_NUM_BC]; // Section 7.2.4.1.2 - near end CD_P count
}G997_NE_AtmPerf_CD_t;

typedef struct
{
   G997_NE_AtmPerf_CD_t t_Current;
   G997_NE_AtmPerf_CD_t t_Previous;
}G997_NE_Curr_Prev_CD_t;

typedef struct
{
   int32 la_CD_PFE_count[ATM_NUM_BC]; // Section 7.2.4.2.2 - far end CD_PFE count
}G997_FE_AtmPerf_CD_t;

typedef struct
{
   G997_FE_AtmPerf_CD_t t_Current;
   G997_FE_AtmPerf_CD_t t_Previous;
}G997_FE_Curr_Prev_CD_t;

typedef struct
{
   int32 la_CU_P_count[ATM_NUM_BC]; // Section 7.2.4.1.3 - near end CU_P count
}G997_NE_AtmPerf_CU_t;

typedef struct
{
   G997_NE_AtmPerf_CU_t t_Current;
   G997_NE_AtmPerf_CU_t t_Previous;
}G997_NE_Curr_Prev_CU_t;

typedef struct
{
   int32 la_CU_PFE_count[ATM_NUM_BC]; // Section 7.2.4.2.3 - far end CU_PFE count
}G997_FE_AtmPerf_CU_t;

typedef struct
{
   G997_FE_AtmPerf_CU_t t_Current;
   G997_FE_AtmPerf_CU_t t_Previous;
}G997_FE_Curr_Prev_CU_t;

typedef struct
{
   int32 la_IBE_P_count[ATM_NUM_BC]; // Section 7.2.4.1.4 - near end CU_P count
} G997_NE_AtmPerf_IBE_t;

typedef struct
{
   G997_NE_AtmPerf_IBE_t t_Current;
   G997_NE_AtmPerf_IBE_t t_Previous;
}G997_NE_Curr_Prev_IBE_t;

typedef struct
{
   int32 la_IBE_PFE_count[ATM_NUM_BC]; // Section 7.2.4.2.4 - far end CU_PFE count
} G997_FE_AtmPerf_IBE_t;

typedef struct
{
   G997_FE_AtmPerf_IBE_t t_Current;
   G997_FE_AtmPerf_IBE_t t_Previous;
}G997_FE_Curr_Prev_IBE_t;

typedef struct
{
   int32 la_ICELL_P_count[ATM_NUM_BC]; // Aware Section 2.2.4.1.5 - near end Tx Idle Cell count
}G997_NE_AtmPerf_ICELL_t;

typedef struct
{
   int32 la_UCELL_P_count[ATM_NUM_BC]; // Aware Section 2.2.4.1.6 - near end Tx Non-Idle Cell count
}G997_NE_AtmPerf_UCELL_t;

// G997_AtmPerf
typedef struct {
   int32 la_DCELL_count[ATM_NUM_BC]; // number of dropped cells
   int32 la_ICELL_count[ATM_NUM_BC]; // idle cell count
}G997_AtmPerf_t;
//==============================================================================

// G997_AtmFailure
typedef struct {
   G997_Failure_State_t t_NCD[ATM_NUM_BC];
   G997_Failure_State_t t_LCD[ATM_NUM_BC];
} G997_AtmFailure_t;
//==============================================================================

// G997_Cntrl
typedef struct {
   int16 s_HighSymCount;               // counter incremented on symbol rate 4312,5 for genrating 100ms timer
   int16 s_1SecSym_Count;              // symbol counter for generating 1sec timer
   int16 s_Interval_Count;             // current 100ms counter (Tr1 interval)
   int16 s_MaxInterval_Count;          // length of TR1 interval in units of 100ms
   int16 s_TR1_enabled;                // 0=counter work with wrap arround, 1 = Counter are copied,reset on end of TR1 interval
   int16 s_Cntr_Reset_Control;         // 0=counter work with wrap arround, 1 = Counter are copied,reset on end of TR1 interval
   int16 s_Interval_Adjust;            // number of 100ms units for shortening the current TR1 interval
   int16 s_TxSymb_Count;               // only used for GDMT for CWI count? symbol counter used for generating codeword timer/counter
   int16 s_CWStatus_SyncSymbl;         // contains the hardware codeword status fetched during the sync symbol
   int16 s_Failure_Update_Count;       // 100ms counter for failure timer
   int16 s_Failure_MaxUpdate_Count;    // timer value for check when to send failure message to the host
   int16 s_LinkState;                  // IDLE=0, UNAVAIL=1, AVAIL=2
   int16 s_TrainState;                 // IDLE, DMT_FULL, DMT_LITE, DMT_LITE_FAST, BIS_FULL, BIS_LITE, BIS_FULL_FAST, BIS_LITE_FAST, BIS_PLUS
   int16 s_FE_FPO_indication;          // =0 if no DGASP received and 1 if DGASP received
   int16 s_US_Margin_Underflow_Count;  // counts number of consequtive superframes with lower margin than configured
   int16 s_InitialCrc_HoldOff;
   int16 s_EOC_AutoMsg_100ms_State;
   int16 s_TR1_State;
}G997_Cntrl_t;

//==============================================================================
//G997 DS/US Attenuation, Margin, etc. - Section 7.5.1.4-17 of the G997 Spec.
//
typedef struct {

   //XDSLRTFW-466: BugFix_DS_VDSL2_ALL_Align_As_Per_CMV_INFO_68 (Start)
   //Commenting out to align with MSG Spec 1.8
   //uint16   ft_NTR_Transport;          // Mode to enable NTR Transport
   uint16 Reserved;
   //XDSLRTFW-466: BugFix_DS_VDSL2_ALL_Align_As_Per_CMV_INFO_68 (End)

   // PMD Parameters:
   uint16   us_LoopAttenuation;        // US/DS Loop Attenuation
   uint16   us_SignalAttenuation;      // US/DS Signal Attenuation
   int16    s_SnrMargin;               // US/DS SNR Margin
   uint32   ul_AttainableDataRate;     // US/DS Attainable Data Rate
   int16    s_ActualAggregateXmtPwr;   // US/DS Aggregate Actual transmit power
   int16    s_ActualAggregatePSD;      // US/DS Aggrregate actual transmit PSD
   uint16   us_LineStatus;             // US/DS TCM Support, VN support, NTR Status DS

   // XDSLRTFW-3752 (Start_End)
   uint16   us_BDR;                    // ERB Backchannel datarate in terms of kbps, applicable only to US
   //XDSLRTFW-466: BugFix_DS_VDSL2_ALL_Align_As_Per_CMV_INFO_68 (Start)
   //Commenting out the variables, to align with MSG Spec 1.8
   //uint16   us_dummy;               // to align the following long word ul_LineRate
   //uint32   ul_LineRate;            // US/ DS Line Rate
   //XDSLRTFW-466: BugFix_DS_VDSL2_ALL_Align_As_Per_CMV_INFO_68 (End)
} G997_SignalAndMarginParams_t;

typedef struct
{
   uint16 us_NEAlarmIndicators;
   uint16 us_FEAlarmIndicators;
   uint16 us_NEAlarmIndicators_Previous;
   uint16 us_FEAlarmIndicators_Previous;
   uint16 us_AlarmTimeStamps;
} G997_TR1AlarmIndicators_t;

typedef struct
{
   uint16 us_TR1AlarmMessageEnable_NE;
   uint16 us_TR1AlarmMessageEnable_FE;
} G997_MONI_TR1AlarmEnable_t;

//--------------------------------
//PTM related
//--------------------------------
#ifdef PPE_ENGINE
/*
typedef struct {
   uint32 ula_tx_pkt_cnt[NUM_BEARER_CHANNELS];
   uint32 ula_rx_pkt_cnt[NUM_BEARER_CHANNELS];
   uint32 ula_rx_crc_cnt[NUM_BEARER_CHANNELS];
   uint32 ula_rx_coding_err_cnt[NUM_BEARER_CHANNELS];
} G997_PtmPerfCnts_t;

typedef struct {
   G997_PtmPerfCnts_t t_Current;
   G997_PtmPerfCnts_t t_Previous;
} G997_PtmPerf_Cur_Prev_t;
*/
#endif //#ifdef PPE_ENGINE

//PTM performance counter
typedef struct {
   uint32 ul_CRC_P_cnt;   //near/far end crc-p
   uint32 ul_CVC_P_cnt;   //near/far end cv-p (coding violation)
   uint32 ul_CRC_NP_cnt;   //near/far end crc-np
   uint32 ul_CVC_NP_cnt;   //near/far end cv-np (coding violation)
} G997_NE_FE_PtmPerf_t;


//ATM performance counter
typedef struct {
   uint32 ul_HEC_P_count;   //near/far end HEC error count
   uint32 ul_CD_P_count;    //near/far end CD_P count
   uint32 ul_CU_P_count;    //near/far end CU_P count
   uint32 ul_IBE_P_count;   //near/far end idle cell w/ bit error count
} G997_NE_FE_AtmPerf_t;


//tx cell counters
typedef struct
{
   uint32 ul_UCELL_P_count;  //near end Tx User Cell count
   uint32 ul_ICELL_P_count;  //near end Tx Idle Cell count
} G997_NE_AtmPerf_TX_UICELL_t ;

//XDSLRTFW-1056 Feature_US_VDSL2_ALL_UsReTx_RxOvhdTestMgmt(START)
typedef struct
{
   //mapped to CMV CNTR 58 0
   uint32 l_USRetransmittedDtuCnt;// is a NE counter inclued here for the sake of CMV mapping
   uint32 ul_Corrected_Dtu_cnt;
   uint32 ul_Uncorrected_Dtu_cnt;

   //following are the ReTx Performance parameters and mapped to CMV CNTR 59 0
   uint32 ul_Error_Freebits_cnt;
   uint32 ul_Eftr_min; //bits/sec
   uint32 ul_Leftr_DefectSeconds_cnt;

} G997_ReTx_MgmtCnt_t;

//XDSLRTFW-1056 Feature_US_VDSL2_ALL_UsReTx_RxOvhdTestMgmt(END)



#endif // _G997_TYPEDEF_H
