/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C) 2015, 2016: Lantiq Beteiligungs-GmbH & Co. KG
    Copyright (C), 1994-2012 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------
*******************************************************************************
*******************************************************************************
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   gdata.h
*
*       This file is the include file for gdata.c
*
*-------------------------------------------------------------------------
*/

// ***********************************************************************************************************
// gdata.h
//
// History
//
// 16/05/2012 Vinjam: Enabling/Disabling Downstream Virtual Noise feature control is moved from CMV MONI 4 to
//            CMV DSL 0, as per VR9 Message Specifications (1.6.1). Also contains code pointers connected to
//                        Down stream virtual noise feature
//            Grep for XDSLRTFW-439: Feature_All_DS_All_All_SupportDsTxRefVirtualNoise
//
// 10/07/2012 Vinjam: Added a buffer to store actual Show time SNR with out virtual noise.
//                     Grep for XDSLRTFW-439: Feature_All_DS_All_All_SupportDsTxRefVirtualNoise
//
// 18/09/2012 Ram: 1. Added code to support ReTx CMV - INFO 229 (to check if DS showtime is in ReTx mode or not)
//                 Grep for: "XDSLRTFW-443: Feature_DS_VDSL2_All_ReTx_CMV_INFO_229"
//
// 27/11/2012 Ram: Merged IOP fix corresponding to JIRA XDSLRTFW-458
//            Grep for: "XDSLRTFW-458: IOP_ALL_VDSL2_ALL_TACorrection"
//
// 17/01/2013 Ram: Fix added for JIRA 285 - Implement a 'Feature MAP' indicating the features supported by VDSL FW
//                 Added a new variable to implement CMV 'DSL 20' (Refer Msg Spec ver 1.9 for more details on CMV)
//                 Grep for XDSLRTFW-285: Feature_ALL_ALL_ALL_Config_Modem_Feature_Map
//
// 15/01/2013 Kannan: Added variable for CMV to control AFE init fail indication.
//                Grep for: "XDSLRTFW-118: VR9_VRX318_AFE_Init_Fail_Indication"
//
// 29/01/2013 Sooraj: Added variables to support CMV "INFO 234" used to convey the AELEM status
//                 Grep for: XDSLRTFW-487_VR9_VRX318_VDSL2_All_AELEM_Support (START)
//01/02/2013 Kannan: Global variable declaration for PDBRAM handover and Orderly shutdown
//                Grep for: "XDSLRTFW-710 VR9_VRX318_PDBRAM_Handover_OrderlyShutDown"
//
// 15/01/2013 Hanyu: Added code to update VDSL2 DS Attainable Net Data Rate (ATTNDRds) in Showtime.
//            grep for: XDSLRTFW-539 FEATURE_ALL_VDSL2_ATTNDR_Update
//
// 25/02/2013 Ram: Fix added for JIRA 285 - Implement a 'Feature MAP' indicating the features supported by DDSL FW
//                 Added a new variable to implement CMV 'DSL 19' (Refer Msg Spec ver 1.9 for more details on CMV)
//                 Grep for XDSLRTFW-285: Feature_ALL_ALL_ALL_Config_Modem_Feature_Map
// 06/05/2013 Varun : Added variables and buffers for the Debug buffer operation
//                                        Grep for "XDSLRTFW-598 FEATURE_ALL_ALL_ALL_Debug_Buffer" and
//                                        Grep for "XDSLRTFW-600 FEATURE_ALL_ALL_ALL_Debug_Buffer"
//
// 29/5/2013 Vinjam: Removed global variable gt_Bonding_DiscAggr_ControlCMV as it is redundant
//           Code changes are done for XDSLRTFW-230 Bug_All_All_All_HercCnfg17_CleanUp (valid for VDSL2 & ADSL2)
//
// 05/07/2013 Varun : Added variable to update the timestamp  in ReTx mode
//                                        Grep for "XDSLRTFW-1047 Feature_US_VDSL2_ALL_UsReTx"
// 22/07/2013 Varun : Added variables and buffers to be used only in showtime in ReTx mode(defined in the section : DATA_ONE_PORT_SHOW_DATA_BEGIN)
//                    Grep for: XDSLRTFW-1076: Feature_ALL_ALL_ALL_R7_GolayRRC
//
// 30/10/2013 Anantha Ramu: Defined new error state "E_CODE_ATTNDR_CALC_FAIL"
//                          grep for: XDSLRTFW-1285 Feature_US_VDSL2_ALL_UsReTxAmend2_ATTNDR
//
// 18/12/2013 Kannan: Added variable for 5 secs shine noise test to enable/disable the FDQ
//            Grep for XDSLRTFW-1104
// 03/01/2014 Anantha Ramu: Added variables gsa_PllRefTone_unscale, gsa_PllRefTone_scale
//            Grep for XDSLRTFW-1271 DSReTx_uncorrected_DTUs_PLL_changes
//
// 30/10/2014 Anantha Ramu: Added variables for Intra DTU interleaving.
//                          Grep for "XDSLRTFW-1617"
//
// 15/12/2014 Prashant: Following things are implemented wrt RetxDegug feature
//            1. Transmitter should offer an RRC codeword capture feature for up to 256 RRC CWs and capturing is started with the
//               first RRC CW where Nack[1:0] is unequal 0b00. (256 * 24bits to be stored).
//               Capture can be enabled by setting gt_RtxDbgCapture.us_RtxUsRrcCaptureCnt to 0. Once set to zero,
//               capture will start from first bad dtu and gt_RtxDbgCapture.us_RtxUsRrcCaptureCnt will be incremented upto 255.
//               To re-capture again set gt_RtxDbgCapture.us_RtxUsRrcCaptureCnt to 0.
//            2. Transmitter should offer the possibility to measure the actual roundtrip in number of DTUs per DTU from DTU TX insertion
//               until getting the first ACK info and should report the max./min. value captured during operation. (This already exist)
//               Reseting the measurement during operation is suppoterd now.
//            3. The structure RtxDbgCapture_t has been mapped to a new CMV INFO 241.
//    Grep for XDSLRTFW-1622
//
// 21/9/2016 Sriram shastry  : NBN / VR9 DS performance is 100,871Mbps, expected is 103Mbps. vectoring+US&DS Retx
//    Internal 1-symbol HRTrx reduction in case of [RTX + G.Vector] operation for all  CO.
//    The test cases Vect=off with internal memory split show that the operator should not rely on a good internal split decision.
//    The internal split is not well-balanced for the wished service rates.
//    According to 998.4: + 1 sym can be ignored for vectoring+ 1 DTU (processing needs to wait for the last bit of each DTU)(+ 1 symbol because  of US/DS sync symbol alignment)
//    According to equation 1 of 9.5.1/G.998.4, it can be checked that the minimum required Qtx calculated by this equation (with the communicated HRT values and with the selected
//    framing parameters Q, NFEC1, L1) results to a required number of RTX buffer bytes Qtx*Q*H which exceeds the selected physical buffer size of MAXDELAYOCTETds/2 according to
//    D1.1/G.998.4 and would lead to a violation. It doesn't lead to a violation if the mentioned equation 1 doesn't take into account the extra +1 symbol
//      Added  debug code to  simulate  FW Internal Rein like disturber
//    1-symbol reduction in Qtx,min calculation:
//    It can be seen as a gap compensation. If only the ACK related gap occurs in the drawn triangle from start of Tack until end of Tret then
//    the +1 symbol in the Qtx,min calculation has to be taken into account. But if both gaps, the ACK related gap as well as the TX related gap,
//    occur within this triangle then these gaps are compensating each other w.r.t. Qtx,min demand and it's not needed to take into account the
//    +1 symbol in the Qtx,min calculation.
//    If both gaps occur in the triangle, two cases can be distinguished SSdsOffset >= 0 (SSds comes after SSus) and SSds <= 0 (Ssus comes after SSds).
//    For SSdsOffset >= 0, the ds gap must be located within Tret, the right triangle part. For SSdsOffset <= 0, the ds gap must be located within Tack,
//    the left triangle part.
//    If both transceivers have no DTU specific HRT contribution (HRT_RX_D=0, HRT_TX_D=0) then the only DTU specific contribution in the total roundtrip
//    is the DTU transmission time itself which is already considered extra in the Qtx,min equation (not included in the HRTs, outside Tack/Tret) and
//    shown in the drawings before the triangle.
//    So from the figures it could be derived:
//    No +1 symbol in the Qtx,min calculation needed if  -HRT_RX <= SSdsOffset <= HRT_TX
//    But w.r.t. the mentioned uncertainty in which HRTs the PMD associated transmission times are included the range should be reduced by a symbol, i.e.
//    No +1 symbol in the Qtx,min calculation needed if  -HRT_RX+1 <= SSdsOffset <= HRT_TX-1
//      CMV Description : TEST 52 0 "Value"  can be used to over write, Internal HRT Rx Symb used in RTX  Framing generation.
//       Default setting : Disable [ TEST 52 0 0]
//    Grep for : XDSLRTFW-2858
//
// 18/09/2013 Hanyu: IOP fixes against EVLT-F/CNXT in A8D profile
//   1. IOP adjustment to reduce estimated KL0 from loop length ~2800ft to ~3800ft to connect to showtime.
//   2. Switched to US0 band if KL0 is greater than 25.8dB (~3700ft) to fix the no sync issue.
//      Grep for XDSLRTFW-3470 XDSLRTFW-735 IOP_A_US_VDSL2_EVLT_F_CNXT_NoSync3200ft
//
//   3. Added 0.6dB to final KL0 to reduce UPBO and boost US power by ~0.5dB to get comparable US data rate with BRCM CPE.
//      Grep for XDSLRTFW-3470 XDSLRTFW-735 IOP_A_US_VDSL2_EVLT_F_CNXT_USdatarate
//
// 20/08/2018: Sriram Shastry : XDSLRTFW-232-Coding/decoding of US- and DS-tssi in O-PRM and R-PRM not correct
// 1. Performance optimization is done up to now only for US0 oPOTS configuration (US0-spectrum: tone 6-32)
// 2. If US oPOTS is used we force the out-of-band TSSI values for the CO TDQ training phase to: ...
//    Lower OOB tone Idx (0,4 are shaped with 6.0dB dB TxATTEN ) and  Upper OOB tone idx (36 =-0.0 dB &
//    tone idx 54 = -62.0 dB) TxATTEN is applied).
// 3. All other modes still use the old code
// 4. Added  new Tx IIR filter for  ISI optimization
// 5. Upstream performance optimization is  controlled by cmv. TEST 49 BITMASK- 9. Enabled by default
// Grep for XDSLRTFW-232
//
//14/12/2018 Sriram Shastry :XDSLRTFW-4052 : Low upstream data rates in 30a profile
// improvement for Kl0 alogorithm estimation for  30a profile
//   Control option to use AELEM for reporting KL0
//   Control option to set  Kl0 in RMSG1
//   Control option to set AELEM method instead of  KL0 method
//   Control option to Enable/disble psdpreprocessing (inter polation) 
//   Initialize AELEM structure (gt_AELEM_UPBOInfo) 
//  Grep for XDSLRTFW-4052
// ************************************************************************************************************

#include "common.h"
#include "mtkernel.h"
#include "sys_const.h"
#include "socmessage.h"
#include "SnrFrameAlignHandler.h"
#include "voc.h"
#include "data_alloc.h"
#include "states.h"
#include "pll.h"
#include "afe.h"
#include "DecAdapt.h"
#include "DebugBuffer.h"
#include "Us_Rtx.h"
#include "DshInterface.h"

#include "VRX_AfeCommonConst.h"
#include "VRX_AfeCommonData.h"
#include "AFED_Constants.h"
#include "AFED_Data.h"
#include "AFED_Functions.h"
#include "AFED_ReadWriteModify.h"
#include "cmv.h"

#ifdef VRX518_BRINGUP_DEBUG
extern uint32  gul_dbg_LogControl;
extern uint32  gul_dbg_LogControl_Status;
#endif

//XDSLRTFW-3493(Start)
extern uint32 gula_LpMin[HQV_MAX_ROWS];
extern uint32 gula_LpMax[HQV_MAX_ROWS];
extern HQV_ETRu_t gt_HQV_ETRu[HQV_MAX_ROWS];
extern uint16 gusa_n_tones_per_Bi[MAX_BI_INDEX];
extern uint8 guca_CGv[15 * 15];
extern uint8 guc_DS_ReTx_iDTU_R;
//XDSLRTFW-3493(End)

//XDSLRTFW-3362 (Start)
#ifdef PROFILE_TASKS_35B
extern  CasFwTasksMips_t gt_CasFwTasksMipsCnt;
extern uint32 gul_MaxPllCycles;
//Cascaded mode: Training and Showtime Mips count to know overall Mips consumption
//in TC & NTC tasks.
extern CascadeMaxMipsCnt_t gt_CascadeTcNtcMaxMipsCnt[CASCADE_NUM_TC_NTC_FW_TASKS];
#endif //#ifdef PROFILE_TASKS_35B
//XDSLRTFW-3362 (End)

extern int32  gl_RxTimer_RxPMSStart;
extern int32  gl_RxTimer_RxPMSDone;
extern int32  gl_RxTimer_MaxRxPMSDone;
extern int32  gl_TxTimer_MaxTxPMSDone;
extern int32  gl_TxTimer_TxPMSDone;

//XDSLRTFW-3189 (Start)
extern int16 gs_MemSize_DsReTx_MinDtus_ReqOverQtx;
extern int16 gs_MemSize_UsReTx_Qtx_Overhead_R;
extern uint16 gus_MaxDTUSizeDS_iDTU;
extern uint16 gus_MaxDTUSizeUS_iDTU;
//XDSLRTFW-3189 (End)
//XDSLRTFW-2392 (Cascaded scheduling - Start)
extern uint8 guc_CasMode_enable;
extern uint8 guc_Start_CasMode_Int;
extern int16 gs_dbg_DelayRxPms;
extern uint32 gul_RxTimer_FftStart;
extern uint32 gul_RxTimer_FftStop;
extern int32 gl_RxTimer_RxTcStart;
extern int32 gl_RxTimer_RxNTcStart;
extern int32 gl_RxTimer_MaxRxNTc;
extern int32 gl_RxTimer_MaxRxTc;
//XDSLRTFW-2392 (Cascaded scheduling - End)

extern uint16 gus_delay_snr_update;
//XDSLRTFW-1617 (Start)
extern int16 gs_bad_dtu;
extern uint32 gul_TX_LP1_UCODE_ADDR;
extern uint32 gul_RX_LP1_UCODE_ADDR;
extern uint32 gul_TX_LP1_UCODE_ADDR;
extern uint32 gl_ilvSize;
extern uint32 gl_ilvSize1;
//XDSLRTFW-1617 (End)

extern uint16 gus_ERB_DMA_STATE;
extern FlagT gft_ERB_VBB_Header_Configure;
extern FlagT gft_ERB_Main_Header_Configure;
extern FlagT gft_ERB_Compute_Data;
extern FlagT gft_ERB_Configure_DMA;
extern FlagT gft_Trigger_DMA;
extern FlagT gft_Compute_CRC;
extern FlagT gft_ERB_Buffer_Selector;
extern FlagT gft_ERB_Segment_Done;
extern FlagT gft_CRC_Computed;
extern FlagT gft_Triggered_DMA;
extern FlagT gft_ERB_Last_Segment;
extern FlagT gft_ERB_Descriptor_Wraparound;
extern uint8 guc_SegmentCode;
extern uint8 guc_NumOfSegments;
extern uint8 guc_erb_descriptor_index;
extern uint8 guc_ping_pong;
extern uint8 guc_erb_descriptor_index_Previous;
extern uint16 gus_PPD_ByteCounter_For_Segment;         // number of PROTOCOL PAYLOAD DATA in current segment
extern uint16 gus_ErbByteCounter_Previous;
extern uint16 gus_ByteCounter_For_Reversing;
extern uint16 gus_Start_Addr_Reversing;
extern uint16 gsa_Header_Length[MAX_NUM_ERB_SEGMENTS];
extern uint32 gul_ERB_CRC;
extern uint32 gul_DREG_ERB_Descriptor_Base;
extern uint32 gul_DREG_ERB_Number;
extern uint32 gul_NumofRemaining_Bytes_ERB;
extern ERBDescriptor gt_ERBDescriptor[MAX_NUM_ERB_SEGMENTS];
extern uint16 gus_NumberOfErrorVectorsPerSymbol;
extern uint32 *gpul_ERB_Descriptor;
extern uint8 *gpuca_StErbBuffer_CRC;
extern uint8 guc_owner_bit_set;

// XDSLRTFW-2629 (Start)
extern FlagT gft_Mailbox_thru_SDRAM;
extern FlagT gft_XDMA_Mailbox_Busy;
extern FlagT gft_Mailbox_XDMA_Triggered;
extern int32 gl_Source_Address;
extern int32 gl_Dest_Address;
extern int16 gus_Length;
extern uint32 gul_XDMA_Busy_Cnt;
extern FlagT gft_Interrupt_Mailbox;
// XDSLRTFW-2629 (End)

//XDSLRTFW-2162 (Start)
extern uint16 gus_partial_DTU_bytes;
extern uint16 gus_DTU_bytes;
extern FlagT gft_IDILV_DS_SRA_event;
//XDSLRTFW-2162 (End)

// XDSLRTFW-3591 (Start_End)
extern uint8 guc_Showtime_Entered;

// XDSLRTFW-3344 (Start)
extern FlagT gft_Swap_HLog_QLN_Offchip;
extern int16 gsa_RxHLog_PerTone_Internal[RX_MAX_NUM_TONES];
extern uint8 guca_QLN_PerTone_Internal[RX_MAX_NUM_TONES];
extern int16 gs_QlnHlogCorrection;
extern int32 gl_RxPathTotalGain;
// XDSLRTFW-3344 (End)

// XDSLRTFW-3662 (Start)
extern uint16 gusa_PPA_FW[2];
extern uint16 gusa_PPE_FW[2];
// XDSLRTFW-3662 (End)

//XDSLRTFW-2341 (Start)
extern FlagT gft_US_IDILV_ucode;
extern FlagT gft_IDILV_US_SRA_event;
//XDSLRTFW-2341 (End)
extern FlagT gft_PingPongDtb;
extern FlagT gft_DisablePingPongDtb;


#define E_CODE_OHC_FRAMING_GEN_FAIL             (0x0040)
#define E_CODE_RETX_FRAMING_GEN_FAIL            (0x0080)
//XDSLRTFW-1285 Feature_US_VDSL2_ALL_UsReTxAmend2_ATTNDR(Start_End)
#define E_CODE_ATTNDR_CALC_FAIL                                 (0x0100)


//-----------------------------------------------
// Globals for retx
//-----------------------------------------------
extern int32 gl_FramingGenErrCode;
extern uint16 gus_SelectedFramingParam;  //XDSLRTFW-2547(Start_End)

extern int16 gl_delay_octet_LP0;
extern uint8 guc_maxdtuout;
extern int16 GTM[];
extern uint8 guca_HQV[];
//XDSLRTFW-1617 (Start-End)
//Array of H, Q & V values for Intra DTU Interleaving.
extern uint8 guca_HQV_IDILV[];
extern uint8 guca_HQV_IDILV_Pow2[];

extern RRC_Stat_t gt_RrcStat;
extern ReTX_Stats_t gt_ReTXStats;
extern ReTX_Params_t gt_ReTXParams;
//XDSLRTFW-443: Feature_DS_VDSL2_All_ReTx_CMV_INFO_229 (Start)
extern uint16 gus_DsUsReTxStatus;
//XDSLRTFW-443: Feature_DS_VDSL2_All_ReTx_CMV_INFO_229 (End)
extern uint16 gus_PPE_INPUT_MAX; //XDSLRTFW-2942 (Start_End)
extern ReTx_RxDebug gt_ReTxDebug;

extern QretxTableEntry_t gta_QretxTable[];   // [QRETX_TRANS_TABLE_SIZE];


//XDSLRTFW-1393 (Start)
extern FlagT gft_DsSraReTxInit;
extern FlagT gft_Qrx_Full;

//To detect DTU Stoppage period
extern uint8 gft_SRAInvSync_Detected;
extern FlagT gft_DTU_Stoppage_Detected;
extern FlagT gft_Start_DTU_Stoppage_Detection;
extern uint8 guc_DTU_Stoppage_Detect_Cntr;
extern uint8 guc_DTU_Status_Arr_Indx;
extern DTU_Status_t gt_DTU_Status_Arr[];
//XDSLRTFW-1393 (End)

extern int32 gl_NoRetxMsg;         // bit-0 set = RETX not detected in OSMG1
// bit-1 set = RETX not detected in OTPS
// bit-2 set = msg is not amend 1&3 compliant in OTPS
// bit-3 set = RETX not detected in OPMS


#ifdef DEBUG_GINP_MSGS
// debug ReTX training messages
extern uint8 guc_DebugReTXTrainingMsg; // 1 - debug OMSG1; 2 - debug OPTS; 3 - OPMS
extern uint8 *gpuca_GINP_MsgBuf;
extern int32 gl_GINP_StartIdx;
extern int32 gl_GINP_MsgLength;
#endif

// XDSLRTFW-1157: BugFix_DS_VDSL2_ALL_PacketDrop_In_ReTX_Mode (Start)
extern uint8 guc_QRxFullCntr; //XDSLRTFW-3182 (Start_End)
extern uint8 guc_QRetxTableFullCntr;
//XDSLRTFW-1353: BugFix_DS_VDSL2_ALL_PacketLoss_In_ReTX_Mode_With_HigherNDR (Start)
extern uint16 gus_DropPktCntr;
extern uint16 gus_BufOverWriteCntr;
//XDSLRTFW-1353: BugFix_DS_VDSL2_ALL_PacketLoss_In_ReTX_Mode_With_HigherNDR (End)
//XDSLRTFW-1617 (Start)
extern FlagT gft_Intra_DTU_Ilv_DS;
extern uint8 guc_DS_ReTx_Max_D_CO_support;
extern uint8 guc_ReTx_US_D;
extern uint8 guc_ReTx_DS_D;
extern uint8 guc_IntraDtu_DS_D;
extern uint32 gul_Bytes_in_fifo;
//XDSLRTFW-1617 (End)
// XDSLRTFW-1157: BugFix_DS_VDSL2_ALL_PacketDrop_In_ReTX_Mode (End)

//XDSLRTFW-1243 Feature_ALL_VDSL2_ALL_CMV_MipsProfiling(START)
extern FlagT gft_MipsAvgStart1;
extern long long int gl_MaxMIPSCntSumN;
extern int32 gl_MaxMIPSCntAvg;
extern int16 gs_MipsCntRun;
extern int32 gl_FGMipsCnt[1024];
//XDSLRTFW-1243 Feature_ALL_VDSL2_ALL_CMV_MipsProfiling(END)

//XDSLRTFW-1393 (Start)
//XDSLRTFW-3807 Improve bitswap algorithm in VRX518 code(Start)
#ifdef ENABLE_RETX_DS_DEBUG
extern uint8 guc_ReTxDebugBufWrEnable;
extern uint16 gus_ReTxDebugBufIdx;
extern uint8 *gpuca_ReTxDebugBuf;
extern uint8 guca_RetxDebugBuffer[];
#endif
//XDSLRTFW-1393 (End)
//XDSLRTFW-3807 Improve bitswap algorithm in VRX518 code(End)

#ifdef BS_INSIDE_DEBUG
extern int16 gsa_PerToneMargin[];
extern int16 gsa_BSDebugBuf[];
extern int16 gs_DSDebugBufCnt;
#endif
//XDSLRTFW-1571 (Start)
#ifdef ENABLE_THREE_NEEDLE_TEST
extern uint8 guc_StartThreeNeedle;
extern uint8 guc_ThreeNeedleBadDTUCount;
extern uint8 guc_ThreeNeedleCount;
extern uint8 guc_CountToNextNeedle;
extern uint16 gus_ThreeNeedleDurationCount;
extern uint16 gus_ThreeNeedleDuration;
#endif

extern QueueNode_t gt_NodeList[]; //Max_QRx => Max_QTx*3 = 63*3;
extern QueueStatus_t gt_FreeBufList;
extern uint8 guca_InpBufList[];
extern uint8 guc_InpBufListIndx;
//extern uint32 *gpul_ILVBWrptrTable;
//XDSLRTFW-1571 (End)

extern FlagT gft_EnterL3State;
extern uint8 guc_PM_L3_InternalState;       //Global variable for PM L3 State Machine
extern uint8 guc_PM_L3_Response;            //Global variable for PM L3 State Machine
//US ReTX related Global variables Start
//XDSLRTFW-1047 Feature_US_VDSL2_ALL_UsReTx(START_END)
//Time stamp byte of ReTx DTU => counts the number of tx symbols
extern uint8 guc_TS_byte_Retx;
extern FlagT gft_Enable_UsReTx;

//XDSLRTFW-3255 (Start)
// ERB related BAR registers
extern uint32 gul_BAR14;
extern uint32 gul_BAR17;
extern FlagT gft_BAR_Not_Configured;
//XDSLRTFW-3255 (End)

//XDSLRTFW-1707_30a_RTX_DsUs  (Start)
#ifdef ENABLE_RETX_US_DEBUG
int32 gpla_UsReTxBufWrAddrDebug[3];
int16 gsa_UsReTxBufWrSize[3];
extern int16 gs_UsretxDebug1;
#endif

extern int16 gs_HQV_MaxIdx;
extern int16 gs_HQV_MinIdx;
extern int16 gs_rxILVBaseAddrOffset;

//XDSLRTFW-1707_30a_RTX_DsUs  (End)

//XDSLRTFW-1076: Feature_ALL_ALL_ALL_R7_GolayRRC (start)
// RRC------------
//extern unsigned long long int gul_NackMask;
extern FlagT gft_RRCworkaround;

//XDSLRTFW-1076: Feature_ALL_ALL_ALL_R7_GolayRRC(START)
extern uint16 gusa_ReTxTable[SIZETT];
extern uint8 guc_TS_Discard_Th;
extern int16 gs_ReTxTable_wr_pointer;
//XDSLRTFW-1076: Feature_ALL_ALL_ALL_R7_GolayRRC(END)
extern int16 gs_DTUSizeDS, gs_DTUPayloadSizeDS, gs_DsQRx, gs_DsQTx, gs_QTx;
extern uint16 gus_DebugVar1;
//XDSLRTFW-1052 Feature_US_VDSL2_ALL_UsReTx_WrTCtoILV_RdILVtoDTB (Start)
//Debug
#ifdef ENABLE_RETX_US_DEBUG1
extern uint16 gusa_ReTxDebugBuf[5];
extern uint32 gula_PalakDebug[5];
#endif
extern int16 gs_DTU_size;
extern FlagT gft_RetransmitReq;
//XDSLRTFW-1052 Feature_US_VDSL2_ALL_UsReTx_WrTCtoILV_RdILVtoDTB (End)

extern uint32 gul_RRC_data;
//XDSLRTFW-3101 (Start_End)
extern uint16 gus_RRC_BadCW; //Counter for bad DS RRC code word
extern int16 gft_InitialRRC;
extern int16 gs_RRCOffset; // keeps track of how many tones are used to bitload RRC bits.
extern int16 gs_Delta_DTU_TX;
extern uint8 guc_PrevAbsoluteDtuCountLsbs;
extern int32 gl_TxAbsoluteDTUCount;
extern uint16 gs_num_RndTrip_Errors;

extern FlagT gft_REIN_NoiseUS;
extern int16 gs_US_InterArrivalTime;
extern int16 gs_num_US_REIN_impulses;
extern int16 gs_max_num_US_REIN_impulses;
extern uint16 gs_num_corrupted_RRCs;
extern uint16 gs_corrupted_RRC_cnt;
extern FlagT gft_corruptRRC;
extern uint16 gus_log_index;
extern uint16 gus_retx_log_type;

extern long long int gl_RrcValid; // 64 bit variable
extern int16 gsa_size_num_bytes_transfer[3];
extern int32 gpla_ReTxWrPtrTable[3];
extern int32 gl_UsReTxBufWrRunningAddr;
extern int32 gl_UsReTxBufEndAddr;
extern uint16 gusa_RdDataSize[2];
extern uint8 guca_DTU_Status[3];
extern uint16 gs_num_discarded_DTUs;
extern  uint32 gul_retransmitted_delta;
extern int16 gs_DTU_id;
extern int16 gs_DtuSizeIncr;
extern int16 gs_running_PMSSize;
extern int16 gs_running_DTUSize;
extern FlagT gft_UsReTxSraStopRrcEval; //XDSLRTFW-1380 BugFix_UsSraUncorrectDTUReinShine (start_end)
extern FlagT gft_UsReTxSraTRansDetect;
extern FlagT gft_StopNewDtu;
//XDSLRTFW-1830 (START)
extern uint8 guc_StNewDtuTc;
extern uint8 guc_StPartialDtuTc;
extern uint8 guc_num_Dtu_EndBoundary;
extern int16 gs_DTUtc_Size, gs_RTXusR_Size, gs_DTUi_SizeInr;
//XDSLRTFW-1830 (END)
extern uint8 guc_FirstQtxSymCnt;
//US ReTX related Global variables End
//XDSLRTFW-1076: Feature_ALL_ALL_ALL_R7_GolayRRC (End)

//Noise Margin Equalization Global vars
//XDSLRTFW-1784 (Showtime Margin Equalization - START)
extern  uint8  guc_MarginEqualization_ExitCode;
extern  uint8  guc_GainSwapCntr;
extern  uint8  guc_dbg_bitswap_decision_1;
extern  uint8  guc_dbg_bitswap_decision_2;
extern  uint8  guc_dbg_bitswap_decision_3;
extern  uint8  guc_slow_gainswap_cnt;
extern  uint8  guc_Save_RxGain_Mgn_dB;
extern  int16  gs_Margin_Hi_Prev;       // Largest negative number.
extern  int16  gs_Margin_Lo_Prev;       // Largest positive number.
extern  int32  gla_dbg_RxFineGain_dB[4096];
extern  int32  gla_dbg_RxPerToneMgn[4096];
//XDSLRTFW-1784 (Showtime Margin Equalization - END)

//=============================================================================
// Pause routine
//=============================================================================
// XDSLRTFW-2186(Start)
extern FlagT gft_PauseOff, gft_Resume;
extern int16 gs_PauseMarker;
// XDSLRTFW-2186(end)

//==============================================================================
// G994 Vendor information
//==============================================================================

extern G994_VendorInformation_t gt_ne_VendorInformation;
extern G994_VendorInformation_t gt_fe_VendorInformation;

extern uint32 gul_ne_G994VendorID;
extern uint16 gus_ne_CountryCode;
extern uint16 gus_ne_G994VendorSpecific;
extern uint16 gusa_FW_version_number[];

extern uint32 gul_fe_G994VendorID;
extern uint16 gus_fe_CountryCode;
extern uint16 gus_fe_G994VendorSpecific;
extern uint32 gul_fe_G994VendorID_NS;
extern uint16 gus_fe_CountryCode_NS;

// INTEROP flags based on vendor ID and/or vendor specific info
extern FlagT gft_IfxAtmPtmFix;

//================================================================
// Common shared memory blocks
//================================================================

// Multi-purpose buffers.  This buffer is used for different purposes at different stages.
extern int16 gsa_CommonMemoryBlock0[COMMON_MEM_BLOCK_SIZE];

#ifdef ILV_DBG_BUFFER
//If IlvDbgBuffer is enabled, the interleaver/deinterleaver memory size is reduced by ILV_DBG_BUFFER_SIZE. The free memory can then be used as debug buffer
extern int16 gs_IlvDbgBufferControl;           // Control field for IlvDbgBuffer.
#define ILV_DBG_BUF_CNTRL_ENABLE_MASK        1 // bit 0: IlvDbgBuffer Enable (TRUE = Enable, FALSE = Disable)
#define ILV_DBG_BUF_CNTRL_ENABLE_POS         0
#define ILV_DBG_BUF_CNTRL_MODE_MASK          1 // bit 1: IlvDbgBuffer Mode   (1 = Circular, 0 = One shot)
#define ILV_DBG_BUF_CNTRL_MODE_POS           1
#define ILV_DBG_BUF_CNTRL_STAT_SELECT_MASK   7 // bit 2:4 Trigger selector 0=STAT0[0], 1=STAT0[1], 2=STAT0[2], 3=STAT0[3], 4=STAT0[4]Bit
#define ILV_DBG_BUF_CNTRL_STAT_SELECT_POS    2
const extern uint32 *glp_IlvDbgBufferStart;    // This is a const pointer marking the start of the IlvDbgBuffer
extern int16 *gpsa_IlvDbgBuffer;               // This pointer shall be used as write pointer
extern FlagT gft_WriteToIlvDbgBuffer;          // True = Debug variables are written to IlvDbgBuffer (this variable is set by gs_IlvDbgBufferStartTrigger/gs_IlvDbgBufferStopTrigger)
extern int16 gs_IlvDbgBufferStartTrigger;      // StartTrigger
extern int16 gs_IlvDbgBufferStopTrigger;       // StopTrigger
extern int16 gs_IlvDbgBufferDecimator;         // Decimator factor (write every xth symbol to IlvDbgBuffer)
extern int16 gs_IlvDbgBufferDecimatorCnt;
extern int16 gs_IlvDgbBufferContentSelector;   // Bitmask to select debug content written to IlvDbgBuffer
extern int16 gs_IlvDbgBufferBytesPerCycle;     // Variable which hold the amount of bytes written to IlvDbgBuffer per cycle
extern int16 gs_IlvDbgBytesPerCycleModSize;    // Holds the result of ILV_DBG_BUFFER_SIZE mod gs_IlvDbgBufferBytesPerCycle
extern FlagT gft_IlvDbgBufferPingPong_Prev;
extern FlagT gft_IlvDbgBufferPingPong;
#define PING 0
#define PONG 1
#endif //ILV_DBG_BUFFER
extern int16 gs_IlvDbgBufferWriteIdx;          // Marks the write position inside the IlvDbgBuffer


// This buffer holds a temporary copy of debug streams to avoid that the debug content gets overwritten before it arrives at Tracee
/* Messages which don't get backed-up O-Signature, R-Ack, O-PMD, R-PMD (+loop diagnostic messages)
 * Usage:
 * gsa_DebugStreamBuffer[0] R-MSG1
 * gsa_DebugStreamBuffer[1] O-Update
 * gsa_DebugStreamBuffer[2] R-Update
 * gsa_DebugStreamBuffer[3] O-PRM
 * gsa_DebugStreamBuffer[4] R-PRM
 * gsa_DebugStreamBuffer[5] R-TA-Update
 * -----Reuse buffer
 * gsa_DebugStreamBuffer[0] O-TA-Update
 * gsa_DebugStreamBuffer[1] O-MSG1
 * gsa_DebugStreamBuffer[2] R-MSG2
 * gsa_DebugStreamBuffer[3] O-TPS
 * gsa_DebugStreamBuffer[4] R-TPS-Ack
 * gsa_DebugStreamBuffer[5] O-PMS
 * * -----Reuse buffer
 * gsa_DebugStreamBuffer[0] R-PMS

 */
extern gsa_DebugStreamBuffer[6][256];
extern int32 gta_StrymonRegDump[SIZE_STRYMON_REG_DUMP][2];
extern uint8 guca_SavedEGT[TX_MAX_NUM_TONES];   //buffer used to save the previous EGT table in VDSL2
                                                                                                //it is only used during the discovery phase and training phase


// Do not declare these pointers as 'const'. Also: Must be initialized here!.
extern int16 *gpsa_CommonMemoryBlock0;
extern int16 *gpsa_CommonMemoryBlock1;
extern uint8 *gpuca_SavedTxEGT;
extern uint8 guca_EGT_save[128];                        // Used to store FDQ exp for Tssi tones during R-P-TEQ

//gpsa_PsdForAnalysis will be used early in training to hold the PSD used for the PsdAnalysis (LATN, SATN, HLOG)
//it will reside in the TX SOC portion of Common Memory.  It can reside 2 segments into this memory since
//the multisegments are not used until the longer bits/gains messages
extern int16 *gpsa_PsdForAnalysis;

// XDSLRTFW-3935 Wrong HLOG reporting in DPBO range
extern FDQ_t gt_ChDisc_Fdq;

//================================================================
// X memory blocks
//================================================================

extern int32 gla_SharedBuffer_X[SHARED_X_BLOCK_SIZE_LW];

//================================================================
// Y memory blocks
//================================================================

extern int32 gla_SharedBuffer_Y[SHARED_Y_BLOCK_SIZE_LW];
extern int16 gsa_MfdqTones[MAX_MFDQ_TONES*2]; // MFDQ tone table
extern int16 *gsa_FbckTones; // MFDQ feedback tone table

extern int32 gla_ConstDecGain[16];

//================================================================
// Deinterleaver memory blocks
//================================================================
extern int16* gpsa_DILVB_SharedMemory;

//================================================================
// Exec layer variables:
//================================================================

extern FlagT gft_EnableCntlNack; // temporary
extern FlagT gft_IssueSoftReset;
extern FlagT gft_AllowSoftReset; // used to filter CNTL_0_0_0 msg
extern FlagT gft_LinkInitiated; // used to filter CNTL_0_0_x msg where x != 0
extern FlagT gft_RunPostGhsInit; // force to run post GHS initialization at link start
extern FlagT gft_MPMessageCheckBG; // if 1, MP handling is done in BG, if 0, it is done in FG

extern Bonding_TC_Info gt_Bonding_TC_Info;

// XDSLRTFW-3359 (Start_End)
extern US_SRA_Stats_t gt_US_SRA_Stats;

// XDSLRTFW-3367 (Start_End)
extern DS_OLR_Reject_t gt_DS_OLR_Reject_t;
//================================================================
// State machine variables:
//================================================================

extern int16 SizeTcb;

extern PtrToFunc gpF_TxStateFunc;               //Global function pointer to TX state function
extern PtrToFunc gpF_RxStateFunc;               //Global function pointer to RX state function
extern PtrToFunc gpF_TxStateJumpTo;             //Global function pointer to TX jump state
extern PtrToFunc gpF_RxStateJumpTo;             //Global function pointer to RX jump state
extern PtrToFunc gpF_BgTask;

extern int16 gs_TCStateID;              //denotes which side (TX or RX) current TC function is running in.
extern int16 gs_FGStateID;              //denotes which side (TX or RX) current FG function is running in.
extern int16 gs_BGStateID;

extern int16 gs_zero_cmv;

extern FlagT gft_SkipTCTasks;
extern FailStateInfo_t gt_FailStateInfo;
extern FailStateInfo_t gt_FailStateInfo_Prev;
extern uint32 gula_FailStateHistory[5];

extern int16 gs_TxState;                                        /* current Tx state */
extern int16 gs_RxState;                                        /* current Rx states */
extern int16 gs_TxSubState;                                     /* current Tx substate */
extern int16 gs_RxSubState;                                     /* current Rx substate */
extern int16 gs_TxSubStateCnt;                          /* TX substate symbol counts */
extern int16 gs_RxSubStateCnt;              /* RX substate symbol counts */
extern int32 gl_TxSymbolCount;                          /* Tx state symbol counts */
extern int32 gl_TotalTxSymbolCount;                     /* Tx state symbol counts since LinkStart */
extern volatile int32 gl_RxSymbolCount;                          /* Rx state symbol counts */
extern int32 gl_TxTcCount;                                      /* TX TC task counts */
extern int32 gl_RxTcCount;                                      /* TX TC task counts */
extern int32 gl_TxStateTimeOutCount; // maximum TX state count
extern int32 gl_RxStateTimeOutCount; // maximum RX state count
extern int32 gl_GHSTimeOutCount;
extern int32 gl_SynchroTimeoutCnt;                      // variable to control the timeout threshold at discovery phase
extern int32 gl_TxRxSymbolCountDiff;        /* When TA lengthens a TX frame, one needs to account for */
                                            /* the potential order change of TX and RX interrupts. This */
                                                                                /* variable will keep track of that change. */
extern int32 gl_TxFixedStateLength;
extern int32 gl_RxFixedStateLength;

extern int16 gs_MinOPQuiet1StateLength; //minimum length of O-P-Quiet1 state
extern int16 gs_MaxOPQuiet1StateLength; //maximum length of O-P-Quiet1 state
extern int16 gs_Log2NumSymbolsToMeasureQln;     //log2 of number of symbols used to measure the quiet line noise

extern int16 gs_RPSynchroTxTransitionCount; /* Rx Count following O-P-SYNCHRO1 detection on     */
                                                                                        /* which to transition Tx State */
extern int16 gs_ORMsg2RxTransitionCount;        /* this variable is temporary */
extern int32 gl_TxBridgeStateSymbolCount;
extern int32 gl_TxRPQuiet2SymbolCount;
extern int16 gs_RxState_prev;               /* current Rx states */
extern int32 gl_HandshakePhaseSymCnt_start;  // marks the start of each phase
extern int32 gl_RPVector1PhaseSymCnt_start;
extern int32 gl_DiscoveryPhaseSymCnt_start;
extern int32 gl_TrainPhaseSymCnt_start;
extern int32 gl_AnalysisPhaseSymCnt_start;

extern int32 gl_HandshakePhaseSymCnt;
extern int32 gl_DiscoveryPhaseSymCnt;           //count of the number of symbols in discovery phase
extern int32 gl_TrainPhaseSymCnt;                       //count of the number of symbols in training phase
extern int32 gl_AnalysisPhaseSymCnt;            //count of the number of symbols in analysis/exchange phase
extern int32 gl_HybTrSymcnt_start;                      //marks start of hybrid training
extern int32 gl_HybTrSymcnt_end;                        //marks end of hybrid training
extern FlagT gft_StartHybTrn;                           // Indicates start of Hybrid Training


extern int16 gs_TxNextState, gs_RxNextState;                                    /*  next states */
extern int16 gs_TxStopState,  gs_RxStopState;                                   /*  stop states */
extern int16 gs_TxDoneState, gs_RxDoneState;                                    /*  done states */
extern int16 gs_TxStateJumpTo, gs_RxStateJumpTo;                                /*  jump-to states */
extern int16 gs_TxStateJumpFrom, gs_RxStateJumpFrom,gs_RxSubStateJumpFrom;                    /*  jump-from states */

extern TCB_t gt_TaskArray[NUM_TCB_BUFFERS];     /* allow at most NUM_TCB_BUFFERS tasks */
extern PtrToFunc gt_BGTaskArray[NUM_BG_BUFFERS];
extern FunctionFifo_t gt_BGTaskFifoBuf,*gp_BGTaskFifo;
extern int16 gs_TxBkgdProcessFlag;              //flag to indicate the state of TX background process
extern int16 gs_RxBkgdProcessFlag;              //flag to indicate the state of a RX background process
extern int16 gs_RxProcessFlag;                  //flag to indicate the state of a RX process

/* use Fifos to allow multiple loading functions per TC task    */
// First entry of array is # of valid entries in rest of array, so add +1 to array size.
extern PtrToLoadingFunction gp_TxLoadingFunctionFifo[LOADING_FUNCTION_FIFO_SIZE+1];
extern PtrToLoadingFunction gp_RxLoadingFunctionFifo[LOADING_FUNCTION_FIFO_SIZE+1];
extern PtrToLoadingFunction gp_RxLoadingFunctionFifo_FC[LOADING_FUNCTION_FIFO_SIZE+1];

extern FlagT gft_OKToSendBGFlag;                //flag used to hold off R/O-BG message until code swap is complete

extern int16 gs_EnableTimeoutCheckFlag;  //flag to control whether or not to do timeout check
extern uint32 gul_TxTimer;                              //timer used by TX states
extern uint32 gul_RxTimer;                              //timer used by RX states

//TX variables
extern int16 gs_WhichOPPilotState;              //can be 1, 2, or 3
extern int16 gs_FirstLink;

//RX variables
extern int16 gs_PeriodicSnrCalcEnableFlag;      //TRUE: enable SNR calculation during Periodic state
extern int16 gs_RxMedleyStateFlag;              //TRUE: indicate that the RX side enter Medley state

extern int16 gs_TxRxMessaging;

//================================================================
// Tones/Samples buffer variables:
//================================================================
extern int16 gs_TxNumTones;
extern int16 gs_RxNumTones;
extern int16 gs_TxNumTonesUsed; // # of in-band tones
extern int16 gs_RxNumTonesUsed; // # of in-band tones

//==============================================================================
/* Band Control Internal variables. */
//==============================================================================
extern int16 gsa_TxBandLeftChannel[MAX_NUM_TX_BANDS];
extern int16 gsa_TxBandRightChannel[MAX_NUM_TX_BANDS];
extern int16 gs_NumOfTxBands;
extern int16 gs_CurrentTxBand;
extern int16 gs_HighestAllowedTxTone;
extern int16 gs_HighestLoadedTxTone;   // XDSLRTFW-2059
extern uint16 gusa_SwitchingThreshTxBands[TX_BANDS_SWITCH_ARRAY_SIZE];
extern uint16 gusa_SwitchingThreshRxHyb[RX_HYB_SWITCH_ARRAY_SIZE];
extern uint16 gus_SwitchingCriterionVal;

extern int16 gsa_TxBandLeftChannelOSignature[MAX_NUM_TX_BANDS];
extern int16 gsa_TxBandRightChannelOSignature[MAX_NUM_TX_BANDS];
extern int16 gs_NumOfTxBandsOSignature;
extern int16 gsa_RxBandLeftChannelOSignature[MAX_NUM_RX_BANDS];
extern int16 gsa_RxBandRightChannelOSignature[MAX_NUM_RX_BANDS];
extern int16 gs_NumOfRxBandsOSignature;
extern int16 gs_NumOfRxBandsOPrm;
extern int16 gsa_RxBandLeftChannelOPrm[MAX_NUM_RX_BANDS];
extern int16 gsa_RxBandRightChannelOPrm[MAX_NUM_RX_BANDS];

extern int16 gsa_RxBandLeftChannel[MAX_NUM_RX_BANDS];
extern int16 gsa_RxBandRightChannel[MAX_NUM_RX_BANDS];
extern int16 gsa_BitloadLeftChannel[MAX_NUM_RX_BANDS];
extern int16 gsa_BitloadRightChannel[MAX_NUM_RX_BANDS];
extern int16 gs_NumOfRxBands;
extern int16 gs_CurrentRxBand;
extern int16 gs_LowestAllowedRxTone;
extern int16 gs_HighestAllowedRxTone;
extern int16 gs_MIN_BAND_METRIC;
extern int16 gs_MIN_BAND_METRIC_START;
extern int16 gs_NumOfTonesInBand;

//#ifdef MTK_VECTORING_SUPPORT
extern int16 gs_NumOfVecRxBands;
extern int16 gsa_RxVecBandLeftChannel[MAX_NUM_RX_BANDS];
extern int16 gsa_RxVecBandRightChannel[MAX_NUM_RX_BANDS];
//#endif

extern int16 gsa_RFIBandLeftChannel[MAX_NUM_RFI_BANDS];
extern int16 gsa_RFIBandRightChannel[MAX_NUM_RFI_BANDS];
extern int16 gs_NumOfRFIBands;

extern int16 gsa_DsBlackoutBandLeftChannel[MAX_NUM_BLACKOUT_BANDS];
extern int16 gsa_DsBlackoutBandRightChannel[MAX_NUM_BLACKOUT_BANDS];
extern int16 gs_NumOfDsBlackoutBands;

extern int16 gsa_UsBlackoutBandLeftChannel[MAX_NUM_BLACKOUT_BANDS];
extern int16 gsa_UsBlackoutBandRightChannel[MAX_NUM_BLACKOUT_BANDS];
extern int16 gs_NumOfUsBlackoutBands;

extern int16 gsa_EstRxBandLeftChannel[MAX_NUM_RX_BANDS];
extern int16 gsa_EstRxBandRightChannel[MAX_NUM_RX_BANDS];
extern int16 gs_NumOfEstRxBands;

extern FlagT gft_US0BandUsed;
extern FlagT gft_US0BandUsedInCD;

extern int16 gs_SelectBandStart, gs_SelectBandSize;
extern int16 gs_MinSnrThreshForFACluster;
#ifdef GHS_TN_DBG
//DebugCode
extern int32 *gpla_RxTone_Buffer; //XDSLRTFW-2364 (Start_End)
extern FlagT gft_TonesDetected;
extern FlagT gft_Log_Symbol_Count_Start;
extern uint16 gs_RxIndex;
#endif
//==============================================================================
/* Band Control CMV variables.                                                          */
/*   these structures are programmed via CMV and copied to      */
/*   the internal variables at Link Start.                                      */
//==============================================================================
extern int16 gs_TxLog2IfftLength;
extern int16 gs_TxIfftLength;
extern int16 gs_TxCPLength;
extern int16 gs_TxCSLength;
extern int16 gs_TxGain;                 //Used by GenerateSynSymLookUpData to set the signal level
extern int16 gsa_TxSingleToneBuf[2];    //Used by LoadSingleToneToIfftBuf to set the signal level

extern int16 gs_RxFftRsh;
extern int16 gs_RxLog2FftLength;
extern int16 gs_RxFftLength;
extern int16 gs_RxCPLength;
extern int16 gs_RxCSLength;
extern int16 gs_RxRefToneLevel;

extern uint32 gul_TxIfftRate;
extern uint32 gul_RxFftRate;
extern uint32 gul_RXIIR_reg;
extern uint32 gul_DecimCfg_reg;
extern int32 gl_Active_BGTN_Size;
extern int16 gs_Active_TxEGT_Size;
extern int16 gs_TxAbgtOffset;
extern int16 gs_RxAbgtOffset;
extern int16 gs_TxFrameAlignRemain;
extern int16 gs_RxFrameAlignRemain;
extern FlagT gft_EnableQtStall;

extern FlagT gft_IFFT_On;
extern FlagT gft_TxDataPump_On;
extern FlagT gft_EnableGetRxTones;
extern FlagT gft_CopyPilotFromRegisters;
extern FlagT gft_PrintRxTones;
extern FlagT gft_RxMedleyTransition;
extern FlagT gft_EnableRxTimeDomainRead;        //set to TRUE to enable capture of time-domain input samples
extern int16 gs_PeriodicPllDisable;             //if set to 1, disable the PLL during transition between
                                                                                //periodic state to non-periodic state or vice versa
extern FlagT gft_EctPllDisable;                 //if set to 1, disable the PLL while receiving the ECT signal

extern int16 *gpsa_RxToneBuf;           // Tone buffer after FFT (and FDQ) (Rx)
extern int16 *gpsa_RxTDSampleBuf;       // pointer to the RX time-domain sample buffer
extern int16 gs_RxToneOffset;
extern int16 gs_RxToneOffsetSave;
extern int16 gs_RtvSelect;

extern uint16 gus_AFE_RxMode, gus_AFE_TxMode;
extern uint16 gus_DAC_Rate, gus_ADC_Rate;
extern uint16 gus_TxSRC_InRate,gus_TxSRC_UpsamplingFactor,gus_TxSRC_OutRate;

extern uint8 guc_ch_id;
extern uint8 guc_PortMode;
extern uint8 guc_num_ports;
extern int16 gs_RtvSelectLastFrame;
extern FlagT gft_UpdateVRegShadowFifo;          //if set to TRUE, update the strymon shadow fifo register

//populated when running  TRT reorder.
extern int16 gs_Tblcpy_Num0bit[2] ,gs_Tblcpy_NumGT1bit[2] ;
extern int16 gs_unpairedBatZeroTone[2];

extern int32 *gpla_SnrAccuBuf;
extern int32 *gpla_RxAccumBuf;
extern int16 *gpsa_RxRepBuf;
extern int16 gs_LeftChannel, gs_RightChannel;
extern int16 gs_NumChannelsPerGroup;
extern int16 gs_NumChannelsPerGroupSave;
extern int16 gs_NumChannelsDetect;


#ifdef HW_SNR_FDQ
extern int16 gs_LeftChannel_AsyncFDQ, gs_RightChannel_AsyncFDQ;
extern int16 gs_CurrentRxBand_AsyncFDQ;
extern uint32 gul_FD_RNG0Shadow;
extern uint32 gul_FD_RNG0CNTShadow;
extern uint32 gul_RX_MISC_Shadow;
#endif

extern int16 gs_TxVarGain;              // Tx gain mantissa
extern int16 gs_TxVarGainExp;   // Tx gain exponent
extern int16 gs_RxVarGain;              // Rx gain mantissa
extern int16 gs_RxVarGainExp;   // Rx gain exponent
extern int16 gs_RxVarGainMarginDB;      //Rx gain margin in q8.8 dB form
extern int16 gs_RxVarGainDB_NoEcho; // Rx gain in q8.8 dB form; without echo during Ch Disc phase
extern int16 gs_RxVarGainDB_EchoOnly; // Rx gain in q8.8 dB form; only with echo during Ch Disc phase
extern int16 gs_RxVarGainDB_ChDisc; // Rx gain in q8.8 dB form; with echo during Ch Disc
extern int16 gs_RxVarGainDB_NoEcho_Train; // Rx gain in q8.8 dB form; without echo during Training phase
extern int16 gs_RxVarGainDB_Dbg;

//==============================================================================
// AFE & PGA control variables
//==============================================================================

extern int32 gl_Pa;                              /* average received power */
extern int16 gs_PGA_required;                    /* receommended PGA, in dB (Q8.8) */
extern int16 gs_PGA_required_Pre;                /* receommended PGA before compensation, in dB (Q8.8) */

extern int16 gs_PGA_required_FlatAnalogFilter;   // PGA required when analog Filter is set to Flat
//extern int16 gs_PGA_margin;                    /* margin added for PGA calculation  */
extern int16 gs_PGA_margin_AGC1;                 /* margin added for PGA calculation  */
extern int16 gs_PGA_margin_AGC2;                 /* margin added for PGA calculation  */
extern int16 gsa_PgaCorrection;
extern int16 gs_Pga_XtakNoiseScale;
extern int16 gs_Pga_XtakNoiseScaleCtrl;

extern int16 gs_PGA_set;                         /* current PGA setting, in dB (Q8.8) */
extern int16 gs_PGA_set_GHS;                     /* PGA setting used in Ghs, in dB (Q8.8) */
extern int16 gs_PGA_set_EchoOnly;                /* PGA setting (only with echo during Ch Disc phase), in dB (Q8.8) */
extern int16 gs_PGA_set_ChDisc;                  /* PGA setting with Echo during Ch Disc, in dB (Q8.8) */
extern int16 gs_PGA_set_NoEcho_Train;            /* PGA setting (without echo during Training phase), in dB (Q8.8) */
extern int16 gs_PGA_required_In_PropCeilCalc;    /* PGA value in Proposed Ceil calc */
extern int16 gs_PGA_required_In_GHS;             /* Initial PGA value for GHS */
extern int16 gs_PGA_init_In_Train;               /* Initial PGA value for training */

extern int16 gs_HwSettleTime;
extern int16 gs_RTVxCfgLatency;

extern int16 gs_MaxFreqDomainValueTone;
extern int16 gs_MaxFreqDomainValue;

extern int16 gs_AvRxTimePwr;                            // Average time domain received power per sample
extern int16 gs_MaxRxTonePwr;                           // The maximum of the received tone power among all tones (8.8)
extern int32 gl_LinMaxRxTonePwr;

extern int16 gs_AvRxTimePwr_NoEcho;                                             // without echo during Ch Disc phase
extern int16 gs_AvRxTimePwr_ChDisc;                                             // with Echo during Ch Disc
extern int16 gs_AvRxTimePwr_NoEcho_Train;

extern int16 gs_MaxRxTonePwr_NoEcho;                                            // without echo during Ch Disc phase
extern int16 gs_MaxRxTonePwr_ChDisc;                                            // with Echo during Ch Disc
extern int16 gs_MaxRxTonePwr_NoEcho_Train;

// PGA settings during PSD collection for PSD analysis (LATN, SATN, HLOG)
extern FlagT gft_UnityRxVarGain;
extern int16 gs_PGA_set_Qln;
extern int16 gs_RxVarGainDB_Qln;
extern int16 gs_HybridGain_Qln;

extern uint8 guc_PgaState;
extern uint8 gft_PGADnldEnable;

extern int16 gs_PgaHandlerState;
extern int16 gs_PgaHandlerRun;

extern int16 gs_FdqAlgLog2NumFramesToAccum_Saved;
extern int16 gs_SnrAlgLog2NumFramesToAccum_Saved;
extern int16 gs_PsdAlgLog2NumFramesToAccum_Saved;
extern int16 gs_FinalSnrAlgLog2NumFramesToAccum;
//#ifdef MTK_VECTORING_SUPPORT

//XDSLRTFW-2059 (Start)
extern PSDCompData_t gt_PSDCompData;
extern uint32 gul_CompTableSourceAddrsOffset;
extern uint32 gul_CompTableDestinationAddrs;
extern uint32 gul_CompTableSize;
//XDSLRTFW-2059 (End)

extern uint32 gula_RrcCaptureBuffer[];  // Buffer for capturing RRC CodeWords // XDSLRTFW-1622 (Start_End)
extern int16 gsa_TrnVectoringBuffer[]; // Buffer for capturing 2048 Training constellation error points used only in O-P Vector2 state
extern int16 gsa_StVectoringBuffer[]; // Buffer for capturing 2048 Showtime constellation points
extern int16 gsa_SyncSymConstelForOlr[]; // Buffer for capturing 30 showtime OLR related constellation points
extern uint8 *gpuca_StErbBuffer; // XDSLRTFW-2049 Final ERB output buffer pointer for showtime

extern uint16 gsa_ERB_Part0[80];
extern uint16 gsa_ERB_Part1[80];

extern uint32 gul_SyncSybmolRef; //Store Reference SEGUE constellation points for Showtime Sync Symbol (two bits for each constellation, only sign bit)
extern FlagT gft_FastLosEnabled;
extern int16 gs_VectorHandlerState;
extern int16 gs_RxFrmCnt, gs_TxFrmCnt, gs_RxSuperFrmCnt, gs_TxSuperFrmCnt,gs_RxVecFrmCnt, gs_DSVec_N_SSC;
extern uint32 gul_EOC_ErrorFB_CMD_count;
extern int16 gsa_Indx_RxSyncFrm[2];
extern uint16 gus_VectoringOptionsEnabled;
extern uint16 gus_VceT35CountryCode;
extern uint32 gul_VceProviderCode;
extern uint32 gul_VceVersionNumber;
extern uint32 gul_CpeTransId;
extern FlagT gft_DSVectoringEnabled;
extern FlagT gft_PilotseqInterruptionNotAllowed;
//XDSLRTFW-1621 DeltInVectoring (Start/End)
extern FlagT gft_DeltInVectoringMode;
extern int16 gs_VecIndx_PilotSeq,gs_VecIndx_PilotSeq_comp, gs_VecNPilotLength_US;
extern int16 gs_MsgReceiveOPSYNCHROV1Flag;
extern int16 gs_VecRPVector1PSDCutback; // check these are needed or not
extern int8  gc_VecUSSyncOffset; // this veriable represents US sync symbol offset defined in Table 10-2/G993.5 field#5
extern int8  gc_VecDeltaRxTxSyncSym;
extern int16 gs_DSSyncPosition_cnt;
extern int32 gl_USPilotSeqRaw;
extern uint8 guc_SwitchGlobalTimeout;
extern uint8 guc_RxPwrIndicator;  //XDSLRTFW-2467
extern FlagT gft_FirstRxSyncSybmolInShowtime;
extern uint8 guc_VecDebugSwitchEnable;
extern uint8 guc_VectorPowerRightShifts;
extern uint8 guc_VectorPowerRightShiftsMax;
extern FlagT gft_ExecuteShadowing;
extern uint32 gul_QtpTxPrbsMisc_Shadow;

extern uint16 gus_ReTxOptionsEnabled;

extern int16 gs_Debug0, gs_Debug3, gs_Debug4, gs_Debug5, gs_Debug6, gs_Debug7, gs_Debug8, gs_Debug9, gs_Debug10;

extern int16 gs_ForcedMaxRate_DS;
extern int16 gs_ForcedMinRate_DS;
extern int16 gs_ForcedMinINP_DS;
extern int16 gs_ForcedMaxDelay_DS;
extern int16 gs_EnableForcedFailState;

extern int16 gs_NumFramesFastPLLStabilization_ChDiscV1;
extern int16 gs_NumFramesSlowPLLStabilization_ChDiscV1;
extern int16 gs_NumFramesFastPLLStabilization_TrainV1;
extern int16 gs_NumFramesSlowPLLStabilization_TrainV1;

extern int16 gs_NumFramesFastPLLStabilization_ChDisc1;
extern int16 gs_NumFramesSlowPLLStabilization_ChDisc1;
extern int16 gs_NumFramesFastPLLStabilization_Train1;
extern int16 gs_NumFramesSlowPLLStabilization_Train1;

//OP-VECTOR Detector variables
extern int32 gla_EnergyArr[];
extern int32 gl_NoiseEnergyAverage;
extern int32 gl_EnergyExit;
extern int32 gl_EnergyFourAdjFrm;
extern int32 gl_MaxEnergy;
extern int32 gl_MaxEnergyPrev;
extern int16 gs_OPVector1_SyncSymCnt;
extern int16 gus_NoSyncSymbolEnergyCnt;

extern int16 gs_PhaseErrorThresholdConstant;

extern int16 gs_RTV0Probe;
extern int16 gs_CGShiftFactor;
extern int16 gs_NoOfRTV0ToneToCapture;
extern int16 gs_IR_NPR_DECIM;
extern uint32 gl_IR_TCM_CTRL_Shadow;
extern uint32 gul_QTRxNotDone;

extern uint32 gul_RX_MISC_Shadow2;
extern uint32 gul_ItlvMemSizeReTxRMsg2; // This Variable value transmitted in R-MSG2.G.INP.Field10.
                                 // After implementing G.INP Amd 2, this variable can be removed!
extern int16 gs_RxSuperFrmCnt_ForEOC;

extern int16 gsa_DebugCA[20];
extern int16 gsa_DebugCB[20];
extern int16 gs_DebugCnt;

extern int16 gs_QTDebugCnt;
extern uint8 guc_TxRxCommunicator;

extern int16 gs_TxQTRunAfterStall;       // zero indicates stall
extern int16 gs_RxQTRunAfterStall;       // zero indicates stall



extern uint8 guc_RxFirstShwotimeSymbol;
extern FlagT gft_TxFirstShwotimeSymbol;

extern uint16 gus_RefGain; // 0x2000 = Unity Gain in 2.13 format
extern FlagT gft_IT_MISC_RefGainEna;
extern int16 *gpsa_IIBA,*gpsa_IIBB;
extern int32 *gpla_IIBC;


extern int16 *gpsa_MonitorConstallation ;
extern DecMsg_PMS_VDSL2_Vectoring_t gt_DecMsg_O_PMS_G9935;
extern int16 gs_RxSuperFrmCnt_in_Showtime;
extern int16 gs_NoOfEocTransmitted1;
extern int16 gs_NoOfEocTransmitted2;
extern int16 gs_NoOfEocTransmitted3;
extern int16 gs_EocDebug[16];
extern uint16 gus_DCTOptimization;
extern uint16 gus_RxToneTobeCranched;
extern uint16 gus_ErbByteCounter;

extern int8 gc_FormErbInShowtimeState;
extern uint8 guc_G9935_CurrentVectorredBand;
extern uint8 guc_CurrentBitPositionInByte;

extern uint8 guc_G9935_NumBands;
extern uint8 guc_Padding;
extern uint8 guc_FBlock;

// ERB Transmission state in showtime
// 0: ERB are turned off
// 1: ERB parameters are being calculated
// 2: ERBs are on and valid parameters are available
extern volatile uint8 guc_EOC_ERB_TRANSMISSION_STATE;

extern uint16 gusa_Fsub[8];
extern uint16 gusa_Lw[8];
extern uint16 gusa_Bmin[8];
extern uint16 gusa_Bmax[8];

// XDSLRTFW-3507 (Start)
extern ERBParams_t gt_PrevErbParams;
extern uint16 gus_ERB_Params_Changed;
// XDSLRTFW-3507 (End)

//#endif
extern int16 gs_PauseControl; // this variable is introduced to control Pause in different state machine

extern uint16 gus_SyncSymbolPattern1;   // XDSLRTFW-958 BUGFIX_DS_VDSL2_VECTORING_O_P_SYNCHRO_V4 (end)
extern uint16 gus_SyncSymbolPattern2;   // XDSLRTFW-958 BUGFIX_DS_VDSL2_VECTORING_O_P_SYNCHRO_V4 (end)

extern uint16 gus_Saved_AnlgFCorner_cntl_word;

//XDSLRTFW-561 Enhancement_All_All_All_FreqOffset [Start]
extern int16 gs_InitFreqOffsetDelta;
//XDSLRTFW-561 Enhancement_All_All_All_FreqOffset [End]
extern int16 gs_lowOscOffset_ppm; //XDSLRTFW-2442

extern AFEConfig_t gt_AFEConfig;
extern GainCalibration_t gt_GainCalibration;
extern FlagT gft_DisableAdcCalibration;
extern FlagT gft_ModeSelectAdcCalibration;
extern FlagT gft_PollForADC_CalibrationInMedley;
//==============================================================================
// Hybrid Training variables
//==============================================================================
//To load VR9 AFE functions in the RxLoadingFunctionFifo
extern PtrToFunc gpF_AfeLoadFunc;
extern FlagT gft_LoadAfeFunctions;
extern FlagT gft_AFEBkgdTaskDone;

extern uint8 guc_ForceNumHybrid; //To force the no of required hybrids
extern uint8 guc_EnableHybCapacitorSearch;
extern uint8 guc_HybridAlgoCtrl;
extern uint8 gft_HybridTrainingEnable;
extern uint8 guc_HybridEchoAccu;

extern int16 gs_HybrTrHandlerState, gs_HybrTrHandlerCount;
extern int16 gs_HybTrStepSize;
extern int16 gs_HybTrIndex, gs_HybTrMaxIndex, gs_HybTrFinishUp;
extern int16 gs_HybTrMaxIndex_CapSearch;
extern int16 gs_MaxNumHybrSettings;
extern int16 gs_HybTrMaxIndex_save, gs_MaxNumHyb_save;
extern int16 gs_HybTrIterat_save;
extern int16 gs_HybTrIndexDbg;
extern int16 gs_HybNumUsBand;

extern int32 gl_HybTrMaxMetric;
extern int32 gl_HybTrMetric[VRX_MAX_NUM_ADAP_HYB_SETTINGS + VRX_NUM_CAP_SEARCH];

extern uint16 gs_PgaTrainingDbg;

extern int32 gl_ld_line_gain_db;

extern FlagT gft_EnablePsdMeasurementInPgaHandler;
extern FlagT gft_PSD_CALC_TYPE_INITMSRDBUFF_AND_INC;
extern FlagT gft_EnableDoublePGATrain;

extern FlagT gft_BypassRxAFE_HPF;
extern FlagT gft_EnableBypassRxAFE_HPF;
extern FlagT gft_EnableGlpOvflCheck;

//==============================================================================
// HW Specific Variables
//==============================================================================
//XDSLRTFW-710 VR9_VRX318_PDBRAM_Handover_OrderlyShutDown (START)
extern uint8 guc_8khz_count;
extern uint16 gus_Zep_Tx_DelayCnt;
extern uint16 gus_LinkDownState_SymCount;
//XDSLRTFW-710 VR9_VRX318_PDBRAM_Handover_OrderlyShutDown (END)
extern FlagT gft_LinkDownState_Cntrl;
// Indicator for the attached hybrid module, set by cmv OPTN 5
extern uint16 gus_HybridType;
extern uint16 gus_LD_Mode;
extern uint16 gus_CurrLDMode;

//XDSLRTFW-439: Feature_All_DS_All_All_SupportDsTxRefVirtualNoise (Start)
extern uint16 gus_FeaturesControl;
//XDSLRTFW-439: Feature_All1_DS_All_All_SupportDsTxRefVirtualNoise (End)
extern int16 gs_DSL_AlgControl4;

// LATN / SATN correction constants for various Line Interface Modules (HYBs) ( see OPTN 5 definition)
extern int16 gsa_LatnSatnCorrAdapHyb[] ;

extern int16 gsa_LatnSatnCorrFiltHyb[];

extern int32 gl_afe_fixed_gain; // Conversion factor for AFE effects (measured impirically), and to dBm/Hz.


//==============================================================================
// Timer variables
//==============================================================================

extern int32 gl_MaxTimePerFrame;
extern int16 gs_LpbkAlignmentOffset;
extern int32 gl_TxFcTimerCount;
extern int16 gs_RxFcTimerCount;
extern uint16 gus_TxQtTimerCount;
extern int32 gl_TxQtpTimerCount;
extern int16 gs_RxQtTimerCount;
extern int16 gs_RxQtpTimerCount;
extern int32 gl_StartReqTxTimerInt;
extern int32 gl_StartReqRxTimerInt;

#ifdef PROFILE_TASKS

extern int16 gsa_MaxMIPSCnt[NUM_OF_PROFILE_POINTS];
extern int16 gsa_MaxMIPSTxState[NUM_OF_PROFILE_POINTS];
extern int16 gsa_MaxMIPSTxSubState[NUM_OF_PROFILE_POINTS];
extern int16 gsa_MaxMIPSRxState[NUM_OF_PROFILE_POINTS];
extern int16 gsa_MaxMIPSRxSubState[NUM_OF_PROFILE_POINTS];

#endif //PROFILE_TASKS

#ifdef PROFILE_TASKS_VR9
extern int32 gla_MipsCnt[NUM_OF_MIPS_CNTS];
extern MaxMipsCnt_t gta_MaxMIPSCnt[2];
extern uint16 gus_MaxRxTcTime;
#endif //#ifdef PROFILE_TASKS_VR9

extern FlagT gft_EnableTaskProfile;
extern int16 gs_RxTimerRollOverFlag;    //0: roll over on Rx buffer swap, 1: roll over at max count
extern int32 gl_MaxRxTimerCnt;
extern  FlagT gft_LimitedRatecase;
extern  FlagT gft_AdaptiveRatecase, gft_FixedRatecase;


//==============================================================================
// Debug Buffer variables
//==============================================================================

#ifdef DEBUG_TRAIL
extern int16 gsa_StatesTrail[STATES_TRAIL_LENGTH];
extern int16 gsa_StatesTrailIndex;
#endif

#ifdef DEBUG_TRAIL
// Structures to provide CMV control/status of Debug Trails
extern DebugTrailControl_t gt_debugTrailControl;
extern DebugTrailStatus_t gt_debugTrailStatus;
#endif // DEBUG_TRAIL

#ifdef DEBUG_TRACES
//XDSLRTFW-600 FEATURE_ALL_ALL_ALL_Debug_Buffer[START]
//XDSLRTFW-598 FEATURE_ALL_ALL_ALL_Debug_Buffer[START]

//structure instant which is used for control/status of Debuf buff
extern DebugBufStatus_t gt_debugBufStatus;

extern DebugBufferStatus_t gt_DebugBufferStatus;
extern DebugBufferControl_t gt_DebugBuffControl;

extern uint32 gul_DMA_Busy_Error;

// variabels used for mips calculation in Debug buffer
#ifdef MIPS_PROFILE_USRETX
extern int32 gl_mipsdebug1,gl_mipsdebug2,gl_mipsdebug3,gl_mipsdebug4,gl_mipsdebug5,gl_mipsdebug6;
#endif

extern uint8 guc_StLengthFlag;
//structure used in showtime for debug buffer
extern DebugShowTimeBuffSymbol_t gt_DebugBuffSymbol;
extern DebugShowTimeBuffSuperframe_t gt_DebugBuffSuperframe;
extern DebugShowTimeBuffUsReTxOnly_t gt_DebugShowTimeBuffUsReTxOnly;




//Debug buffer variables declaration
extern uint8 *gpuca_DebugBuff_PingPong;

extern uint8 *gpuca_offChipBuffShowtime;
extern uint32 gul_LenoffChipBuffShowtime;

extern uint16 gus_LenDebugBuff;
extern uint16 *gpusa_debugBuff; // pointer to debug buffer used to dump handshake , training and showtime info
//pointer to the SDRAM buffer guc_offChipDebugBuff
extern uint8 *gpuca_offChipBuff;
//temporary declaration
extern DebugBuffer_t gt_DebugBuff;
extern uint8 guc_ShowtimeEnter;

//XDSLRTFW-598 FEATURE_ALL_ALL_ALL_Debug_Buffer[END]
//XDSLRTFW-600 FEATURE_ALL_ALL_ALL_Debug_Buffer[END]

#endif // #ifdef DEBUG_TRACES


// Structures to provide CMV control and filter of Debug Streams
extern DebugStreamControl_t gt_debugStreamControl;
extern DebugStreamConfigure_t gt_debugStreamConfigure;
extern DSH_Statics_t gt_DshStatics;
extern uint16 gus_Dbg_RequeueCnt;
extern uint16 gus_RequeueBGFunction;
extern uint16 gus_Dbg_DSH_skip_BGF_add;
extern uint16 gus_Dbg_msg_length;
extern uint32 gul_DSH_SymCount;
extern DSH_ModemFsmState *gpt_DSH_ModemFsmState;
// consider to remove this variable when common pilot tone structure is available
extern DebugPLL_t gta_DebugPll;
extern DebugPilot_t gta_DebugPilot;
extern FlagT gft_EnablePilotStream;
extern int16 gs_DSH_PrevFsmState;
extern uint8 guc_DSH_VersionInfoStreamed;

extern int16 gs_Prev_TxOvhdMsg_length;
extern uint8 guc_EVB_DebugBuff_flag;



//==============================================================================
// active/inactive pointers to HW Ping-Pong tables
//==============================================================================
extern uint8 *ghpuca_TxBat_Active; // HW pointer to active TX bit allocation table (BAT)
extern uint8 *ghpuca_RxBat_Active; // HW pointer to active RX bit allocation table (BAT)
extern int16 *ghpsa_TxFineGains_Active; // HW pointer to active TX fine gain table (GST)
extern int16 *ghpsa_RxFineGains_Active; // HW pointer to active RX fine gain table (GST)
extern uint8 *ghpuca_TxExtGains_Active; // HW pointer to active TX extended gain table (EGT)
extern int16 *ghpsa_TxToneOrder_Active; // HW pointer to active TX tone ordering table (TRT)
extern int16 *ghpsa_RxToneOrder_Active; // HW pointer to active RX tone ordering table (TRT)

extern uint8 *ghpuca_TxBat_Inactive; // HW pointer to inactive TX bit allocation table (BAT)
extern uint8 *ghpuca_RxBat_Inactive; // HW pointer to inactive RX bit allocation table (BAT)
extern int16 *ghpsa_TxFineGains_Inactive; // HW pointer to inactive TX fine gain table (GST)
extern int16 *ghpsa_RxFineGains_Inactive; // HW pointer to inactive RX fine gain table (GST)
extern uint8 *ghpuca_TxExtGains_Inactive; // HW pointer to inactive TX extended gain table (EGT)
extern uint8 *ghpuca_RxExtGains_Inactive; // HW pointer to inactive RX extended gain table (EGT)
extern int16 *ghpsa_TxToneOrder_Inactive; // HW pointer to inactive TX tone ordering table (TRT)
extern int16 *ghpsa_RxToneOrder_Inactive; // HW pointer to inactive RX tone ordering table (TRT)

//==============================================================================
// other pointers to HW buffers
//==============================================================================
extern int16 *ghpsa_SFDQMantissa;

extern uint8 *ghpuca_SFDQExponet;

extern int16 gs_FixedFdqMant;
extern uint8 guc_FixedFdqExp;

#ifdef USE_FRAME_BUFFERS
extern int16 *ghpsa_rxframebuffer;
extern int16 *ghpsa_txframebuffer;
#endif /*  USE_FRAME_BUFFERS */

// Modem configuration variables
extern uint16 gus_ModemMode; // CO or CPE
extern uint16 gus_PhysicalTransportMode; // PTM/STM/ATM mapping
// gus_TpsTcType used for forming and interpretting O-MSG1, R-MSG2, O-TPS messages
extern uint16 gus_TpsTcType[];
// Flag to select between ATM/PTM cores (valid only for HW platforms with a PTM core)
extern FlagT gft_TcTypeSelected;
// general modem configuration / VDSL-mode only configurations
extern ModemConfig_t gt_ModemConfig;

#ifdef PPE_ENGINE

//PPE configuration variables
extern uint32 gula_DREG_AT_CFG_Cnfg[NUM_BEARER_CHANNELS];
extern uint32 gula_DREG_AR_CFG_Cnfg[NUM_BEARER_CHANNELS];

//PPE TX counter shadow registers
extern uint32 gula_DREG_AT_CELL_Shadow[NUM_BEARER_CHANNELS];
extern uint32 gula_DREG_AT_IDLE_CNT_Shadow[NUM_BEARER_CHANNELS];

//PPE RX counter shadow registers
extern uint32 gula_DREG_AR_CELL_Shadow[NUM_BEARER_CHANNELS];
extern uint32 gula_DREG_AR_IDLE_CNT_Shadow[NUM_BEARER_CHANNELS];
extern uint32 gula_DREG_AR_AIIDLE_CNT_Shadow[NUM_BEARER_CHANNELS];
extern uint32 gula_DREG_AR_BE_CNT_Shadow[NUM_BEARER_CHANNELS];
extern uint32 gula_DREG_AR_HEC_CNT_Shadow[NUM_BEARER_CHANNELS];
extern uint32 gula_DREG_AR_CD_CNT_Shadow[NUM_BEARER_CHANNELS];
extern uint32 gula_DREG_AR_OVDROP_CNT_Shadow[NUM_BEARER_CHANNELS];
extern uint32 gula_DREG_AR_CERRN_CNT_Shadow[NUM_BEARER_CHANNELS];
extern uint32 gula_DREG_AR_CERRNP_CNT_Shadow[NUM_BEARER_CHANNELS];
extern uint32 gula_DREG_AR_CVN_CNT_Shadow[NUM_BEARER_CHANNELS];
extern uint32 gula_DREG_AR_CVNP_CNT_Shadow[NUM_BEARER_CHANNELS];

/*
extern G997_PtmPerfCnts_t gt_g997_PtmPerf_Running_NE;
extern G997_PtmPerf_Cur_Prev_t gt_g997_PtmPerf_Cur_Prev_NE;
extern G997_PtmPerfCnts_t gt_g997_PtmPerf_Running_FE;
extern G997_PtmPerf_Cur_Prev_t gt_g997_PtmPerf_Cur_Prev_FE;
*/
#endif //#ifdef PPE_ENGINE

extern G997_NE_AtmPerf_TX_UICELL_t              gt_g997_AtmPerf_TX_UICELL[];
extern G997_NE_FE_AtmPerf_t                             gt_g997_AtmPerf_NE[];
extern G997_NE_FE_AtmPerf_t                             gt_g997_AtmPerf_FE[];
extern G997_NE_FE_PtmPerf_t                             gt_g997_PtmPerf_NE[];
extern G997_NE_FE_PtmPerf_t                             gt_g997_PtmPerf_FE[];
//==============================================================================
// Modem configuration variables (CMV able)
// Data structures that ME 'generally' configures
// In normal mode of operation used by CO only
// We connect these in RT mode too for sleep state, showtime only tests etc
//==============================================================================
// TPS-TC Bearer Channel Control supported
extern TPS_TC_BearerChannel_t gta_DsBearerChannel[];
extern TPS_TC_BearerChannel_t gta_UsBearerChannel[];

// PMS-TC Latency Path Control
extern PMS_TC_LatencyPath_t gta_DsLatencyPath[];
extern PMS_TC_LatencyPath_t gta_UsLatencyPath[];
extern uint8 guc_DsOneOverSmax;
extern uint8 guc_DsMinMsgOHR;                           //in unit of kbps
extern uint8 guc_DsDynamicInlvEnable;           //1: enable, 0: disable
extern uint8 guc_UsOneOverSmax;
extern uint8 guc_UsMinMsgOHR;                           //in unit of kbps
extern uint8 guc_UsDynamicInlvEnable;           //1: enable, 0: disable

extern MinMsgOHR_t gt_MinMsgOHRConfig;          //structure used for CMV control of min overhead rate

// SNR margin configuration (DS/US target/max/min)
extern SnrMgnConfig_t gt_SnrMgnConfig;
extern NoiseMarginChange_t gt_NoiseMarginChange;
extern SNROffsetChange_t gt_SNROffsetBitLoad[];
extern SNROffsetControl_t gta_SNROffset; //XDSLRTFW-3823
extern int16 gs_ToneGroupIdx;

extern AutoSRA_t gt_RxAutoSRA_Ctrl;

// Band Config variables
extern BandDescriptorTable_t    gt_TxBandControl;
extern BandDescriptorTable_t    gt_RxBandControl;
extern RFIBandDescriptorTable_t gt_RFIBandControl;

// IIR Filter config variables
extern int16 gs_TxIIRFilterSelect;
extern int16 gs_RxIIRFilterSelect;
extern int16 gs_TxPathAfeDfeCustomSettings;



// PSD Configuration Variables
extern PwrConfigParam_t         gt_PwrConfigParamCMV;
extern PwrConfigParam_t         gt_PwrConfigParam;
extern int16 gs_MAX_US0_CEILING;
extern int16 gsa_Dn_MaxNomPSD[MAX_NUM_DS_BANDS];
extern DsPSDDescriptorTable_t gt_MaxDsPSDDescriptorTableCMV;
extern UsPSDDescriptorTable_t gt_MaxUsPSDDescriptorTableCMV;
extern UsPSDDescriptorTable_t gt_RefUsPSDDescriptorTableCMV;
extern DsPSDDescriptorTable_t gt_MaxDsPSDDescriptorTable;
extern UsPSDDescriptorTable_t gt_MaxUsPSDDescriptorTable;
extern UsPSDDescriptorTable_t gt_RefUsPSDDescriptorTable;
extern UPBOPSDDescriptorTable_t gt_UPBOPSDDescriptorTable;

// XDSLRTFW-487_VR9_VRX318_VDSL2_All_AELEM_Support (START)
extern uint16 gus_ELEDsMin;
extern uint8 guc_ELEDsBands;
extern uint8 guc_ELEUsBands;
extern AELEM_UPBOInfo_t gt_AELEM_UPBOInfo;
// XDSLRTFW-487_VR9_VRX318_VDSL2_All_AELEM_Support (END)


extern UsTssiPSDDescriptorTable_t gt_UsTSSIPSDDescriptorTable;
extern UsRawTssiPSDDescriptorTable_t gt_TxPathGainPSDDescriptorTable_ADSLPP;

extern FlagT gft_EnableRxPathCorrectionForKl0;
extern FlagT gft_EnableRxPathCorrection;
extern RxPathGainPSDDescriptorTable_t gt_RxPathGainPSDDescriptorTable_HYB_UNKNOWN;

// New PSD tables for Modified LIF
extern RxPathGainPSDDescriptorTable_t gt_RxPathGainPSDDescriptorTable_VRX518_HYB_ABJ_35M;
extern RxPathGainPSDDescriptorTable_t gt_RxPathGainPSDDescriptorTable_VRX518_HYB_ABJ_17M;

extern RxPathGainPSDDescriptorTable_t gt_RxPathGainPSDDescriptorTable_VRX518_HYB_ABJ_35M_A21;
extern RxPathGainPSDDescriptorTable_t gt_RxPathGainPSDDescriptorTable_VRX518_HYB_ABJ_17M_A21;
extern RxPathGainPSDDescriptorTable_t gt_RxPathGainPSDDescriptorTable_VRX518_HYB_ABJ_8M_A21;

extern RxPathGainPSDDescriptorTable_t gt_RxPathGainPSDDescriptorTable_VRX518_NewHYB_ABJ_Dfe17Src35Afe35_30M;


extern FlagT gft_DisallowInbandTssi;
extern FlagT gft_disable_tx_tssi;
extern int16 gs_interp_psd_with_tssi;
extern UsRawTssiPSDDescriptorTable_t gt_UsTxAttenPSDDescriptorTable_POTS;
extern UsRawTssiPSDDescriptorTable_t gt_UsTxAttenPSDDescriptorTable_ISDN;
extern UsRawTssiPSDDescriptorTable_t gt_UsTxAttenPSDDescriptorTable_POTS_2;
extern UsRawTssiPSDDescriptorTable_t gt_UsTxAttenPSDDescriptorTable_POTS_3;
extern UsRawTssiPSDDescriptorTable_t gt_UsTxAttenPSDDescriptorTable_Transparent;
extern PSDDescriptorTable_t gt_DBG_UsTSSIPSDDescriptorTable;        // XDSLRTFW-232 (Start_End)
extern PSDDescriptorTable_t gt_Shape_UsTSSIPSDDescriptorTable;      // XDSLRTFW-232 (Start_End)


extern int16 gs_min_atten_dB;
extern int16 gs_MaxUsPsdCompensation;

// Profile Control
extern ProfileControl_t gt_ProfileControl;

//==============================================================================
// Modem Actual Variables
//==============================================================================
// Actual Profile Selected
extern ProfileActual_t  gt_ProfileAct;

// Actual TPS-TC Bearer Channel Control negotiated between VTU-R and VTU-O
extern TPS_TC_BearerChanAct_t gta_DsBearerChanAct[NUM_BEARER_CHANNELS];
extern TPS_TC_BearerChanAct_t gta_UsBearerChanAct[NUM_BEARER_CHANNELS];

// Actual latency path parameters negotiated between VTU-R and VTU-O
extern PMS_TC_LatencyPathAct_t gta_DsLpAct[NUM_DATA_PATHS];
extern PMS_TC_LatencyPathAct_t gta_UsLpAct[NUM_DATA_PATHS];
extern uint8 guc_DsOneOverSmaxAct;
extern uint8 guc_DsMinMsgOHRAct;                                //in unit of kbps
extern uint8 guc_DsDynamicInlvEnableAct;                //1: enable, 0: disable
extern uint8 guc_UsOneOverSmaxAct;
extern uint8 guc_UsMinMsgOHRAct;                                //in unit of kbps
extern uint8 guc_UsDynamicInlvEnableAct;                //1: enable, 0: disable

// Band Actual variables
extern BandDescriptorTable_t    gt_TxBandControl_Act;
extern BandDescriptorTable_t    gt_RxBandControl_Act;
extern RFIBandDescriptorTable_t gt_RFIBandControl_Act;

// PSD Actual Variables
#if defined(VR9_SAVE_CDPSD)
extern DsRefPSDDescriptorTable_t gt_DsCDPSDDescriptorTable;
extern UsPSDDescriptorTable_t    gt_UsCDPSDDescriptorTable;
#endif
extern DsRefPSDDescriptorTable_t gt_DsREFPSDDescriptorTable;
extern UsPSDDescriptorTable_t    gt_UsREFPSDDescriptorTable;

// LATN, SATN and SNRM per Rx band
extern AttenSnrMPerRxBand_t gt_AttenSnrMPerRxBand;
extern AttenSnrMPerRxBand_t gt_AttenSnrMPerRxBand_FE;
extern CustomerIOPBits_t gt_CustomerIopBits;

//XDSLRTFW-458: IOP_ALL_VDSL2_ALL_TACorrection (Start)
extern Dsl_Operator_Select_t            gt_Dsl_Operator_Select;
//XDSLRTFW-458: IOP_ALL_VDSL2_ALL_TACorrection (End)

//XDSLRTFW-521 NewFeatures_ALL_ALL_ALL_ATMVDSL2
extern uint16 gus_TcModeUsed_PPE;

//XDSLRTFW-118 VR9_VRX318_AFE_Init_Fail_Indication (START_END)
extern uint16 gus_DSL_FW_InternalControl;

//================================================================
// Algorithm Handlers variables:
//================================================================
extern int16 gs_AlgHandlerState, gs_AlgHandlerCount;
extern int16 gs_AlgNumFramesToAccum, gs_AlgLog2NumFramesToAccum;
extern int16 gs_AlgNumTonesToProcess;
extern int16 *gpsa_AlgMsrdBuffer;

//PSD Control variables
extern TxPsdControl_t gt_TxPsdControl;
extern UPBOControl_t gt_UPBOControl;

extern int16 gs_Kl0Threshold_LimitUsCeiling;     // short loop where kl0 of 9.5 dB is about 1000ft
extern int16 gs_DeltaUsPsdCeilValue;             // max. PSD difference between US0 and max USx working variabe,         format [0.1 dB]
extern int16 gs_DeltaUsPsdCeilValue_ChDis;       // max. PSD difference between US0 and max USx at discovery phase,      format [0.1 dB]
extern int16 gs_DeltaUsPsdCeilValue_TrTrain;     // max. PSD difference between US0 and max USx at transceiver training, format [0.1 dB]
extern int16 gs_AppliedUpboCeiling;

extern int16 gs_Us0Ds1PsdDiff;
extern FlagT gft_EnableUS0PsdCut;
extern FlagT gft_IOP_UPBO_FEXT;

extern uint8 guc_ClearTransmitGainsState;
extern uint8 guc_SetTransmitGainsState;
extern uint8 guc_LoadTransmitGainsState;

//================================================================
//Detect signal onset
//================================================================
extern int16 gs_NumChannels[];
extern int16 gs_PowInnerRshCnt[];
extern int16 gs_SigPowerScale;
extern int32 gl_SigPower;
extern int32 gl_SigPowThresh;
extern int32 gl_SigPowThreshPerBand[];
extern int16 gs_SigDetectBandIdx;
extern FlagT gft_EnableMultiBandSigDetect;


//================================================================
//Frame alignment variables
//================================================================

extern FrameAlignConfig_t gt_FrameAlignConfig;

extern int16 gs_AlignmentOffset;
extern int16 gs_CumulativeAlignmentOffset;
extern uint8 gft_FrameAlignRemoveOutliers;
extern uint8 guc_FrameAlignmentState;      /* Frame Alignment status flag */
extern int16 gs_NumFrameAlignClusters;
extern int16 gs_FrameAlignIteration;
extern int16 gs_MaxOffsetCount;
extern int16 gs_MaxFAOffset_at_convergence;



//================================================================
// Medley state frame realignment
// SnrFrameAlignHandler variables:
//================================================================

extern SnrFrameAlignConfig_t gt_SnrFrameAlignConfig;

extern int16 gs_MedleyFrameSynchEnableFlag;     //TRUE: perform medley frame synch, FALSE, not perform
extern int16 gs_MaxMedleyAlignOffset;           //the maximum frame realignment offset
extern int16 gs_BestSynchPointIdx;                      //the best frame synch point index
extern int16 gs_CurrSynchPointIdx;                      //the current frame synch point index
extern int32 gl_BestSnrSum;                                     //the highest SNR sum
extern int32 gla_MedleySnrSum[NUM_FRAME_REALIGNMENT_POINTS];
extern uint8 guc_RotateFDQState;
extern FlagT gft_RestoreOrigFdq;
extern int16 gs_RxCPLength_save;
extern int16 gs_SyncSearchMode;

//================================================================
//FDQ variables
//================================================================

extern FdqConfig_t gt_FdqConfig;

extern int16 gsa_pre_FDQ_coef[(MAX_NUM_CHANNELS_PER_GROUP<<1)]; // FDQ coefficient mantissa (MAX_NUM_CHANNELS_PER_GROUP = NUM_CHANNELS_PER_GROUP_1024, i.e. 1024*2 16-bit words)
extern uint8 guca_pre_FDQ_exp[MAX_NUM_CHANNELS_PER_GROUP];      // FDQ coefficient exponent

extern int16 *gpsa_BitSwapGain; //temporary buffer to store the gains affected by bitswap

extern uint8 *gpuca_BitSwapBat; //temporary buffer to store the bits affected by bitswap

extern uint8 guc_FdqTrainingState;      // FDQ training status flag
extern int16 gs_FDQTrainTypeCntrlFlag;
extern int16 gs_FDQTrainType;

extern int16 *gpsa_MedleyTempFDQCoeffs; // Used only in Medley for temporary FDQs.
extern uint8 *gpuca_MedleyTempFDQExps;  // Used only in Medley for temporary FDQs.

extern MfdqConfig_t gt_MfdqConfig;
extern MfdqHwWkArndConfig_t gt_MfdqHwWkArndConfig;

extern FlagT gft_EnableMfdq; // flag to enable/disable MFDQ training
extern FlagT gft_ForceMfdq; // flag to force MFDQ training
extern uint8 guc_MfdqTrainingState;

//================================================================
//SNR variables
//================================================================
extern SnrConfig_t gt_SnrConfig;
extern uint8 guc_SnrCalcState;
extern int16 *gpsa_MeasuredSnrBuf;                                      // pointer to measured SNRs
extern int16 gs_avg_snr;
extern int16 gs_num_active_rx_ch;

extern int16 *gsa_SnrBuf;
extern int16 gsa_SnrBuf_OnePortMode[];


//XDSLRTFW-439: Feature_All_DS_All_All_SupportDsTxRefVirtualNoise (Start_End)
extern int8 gca_SnrBuf_WithOutVN[];

extern int16 gsa_SnrBuf_TwoPortMode[];


// gusa_ConstGainPow_dB(i) = 20*log10(const_gain_i/const_gain_2)
extern int16 gusa_ConstGainPow_dB[RX_MAX_BITS_PER_TONE+1];

//================================================================
//PSD variables
//================================================================
extern PsdConfig_t gt_PsdConfig;
extern uint8 guc_PsdCalcState;
extern uint8 guc_QlnCalcState;
extern int8 gc_Log2NumFramesToAccumForPGA;

//Electrical length (kl0)
extern Kl0ElectricalLength_t gt_Kl0ElectricalLength;
extern int16 gs_kl0_estimate_threshold;
extern FlagT gft_disable_autorestart_on_kl0_thresh_fail;
extern FlagT gft_UPBO_is_enabled;
extern int16 gs_E_CODE_KL0_THRESHOLD_FAIL_count;
//Value to offset the computed Electrical length (in 0.1 dB format)
extern int16 gs_kl0_offset;
//Whether to estimate electrical length
extern int16 gs_get_estimate_kl0;
extern int16 gs_kl0_BoostAmount;
extern FlagT gft_DisableKl0PreProc;
extern FlagT gft_EnableKl0Boost;
extern int16 gs_Kl0PreProcDone;
//Whether to do signal and line attenuation calculations.
extern int16 gs_get_satn_latn;
extern int16 gs_SnrThreshForSATN;
extern FlagT gft_UseNewSATNCalc;
//XDSLRTFW-1388 (Start_End)
extern int16 gs_GuardBinKl0; //Use this as KL0 Start bin Debug

extern FlagT gft_Enable_psdpreproc_kl0; //XDSLRTFW-4052(Start_End)
extern uint16 gus_kl0_estimation_method;//XDSLRTFW-4052(Start_End)

extern int16 gsa_IOP_LATN_Kl0[10];
extern int16 gs_KL0_tone_count; //XDSLRTFW-2379 (Start_End)

// +1 because we use this same array to compute aggregate LATN/SATN across all the bands
//Near-end RX power per band
extern int32 gla_near_signal_power[MAX_NUM_RX_BANDS+1];
//Far-end TX power per band
extern int32 gla_far_signal_power[MAX_NUM_RX_BANDS+1];
//Difference of far-end tx minus near-end rx power
extern int16 gsa_satn_pb[MAX_NUM_RX_BANDS+1];
//LATn channel attenuation measurement
extern int32 gla_latn_pb[MAX_NUM_RX_BANDS+1];

//================================================================
//Timing advance variables
//================================================================
extern int16 gs_TimingAdvanceHandlerState;      // dedicated state variable for TimingAdvanceHandler
extern int16 gs_TimingAdvanceFixedDelay;        // Sum of const TX and RX filter delay (in samples at 4096 IDFT sample rate)
extern int16 gs_TimingAdvanceTxIirDelay;        // TX IIR filter delay                 (in samples at 4096 IDFT sample rate)
extern int16 gs_TimingAdvanceRxIirDelay;        // RX IIR filter delay                 (in samples at 4096 IDFT sample rate)
extern int16 gs_TargetTimingAdvance;            //current targeted timing advance value
extern int16 gs_TimingAdvance;                  //number of TX timing advance (in samples)
extern int16 gs_TimingAdvance_sav;
extern int16 gs_TimingAdvanceOffset;            //Additional offset for IOP fixes
extern int16 gs_TxTimerVal;                                     //variables used to measure tx/rx alignment
extern int16 gs_RxTimerVal;
extern int32 gl_txRxFrameOffset;                        // Strymon value for txRxframeOffset as latched in loading function.
extern int16 gs_ReduceInitFrameOffsetCnt;
extern int16 gs_RemoteTxCPLength;                       //TX CP length of the remote modem
extern int16 gs_RemoteTxBetaLength;                     //TX window length (beta) of the remote modem

extern int16 gs_TimingAdvanceTrailIndex;
extern int16 gsa_TaActualTrail[MAX_NUM_TA_ITERATIONS];                  //trail of actual Timing Advance applied
extern int16 gsa_TaAdjustTrail[MAX_NUM_TA_ITERATIONS];                  //trail of Timing Advance adjustments
extern int16 gsa_TaTargetTrail[MAX_NUM_TA_ITERATIONS];                  //trail of the targeted timing advance to be met
extern int16 gsa_TaActualTrailPre[MAX_NUM_TA_ITERATIONS];               //trail of actual Timing Advance applied
extern int16 gsa_TaAdjustTrailPre[MAX_NUM_TA_ITERATIONS];               //trail of Timing Advance adjustments
extern int16 gs_DbgFrameSkewErrorIndex;
extern int16 gs_DbgFrameSkewError;

extern int16 gs_EnableTaBugFix;         //if set to TRUE, use the new TA code
                                                                        //where the second TA is applied 5 symbols after R-ACK
extern FlagT gft_SkipCpAdjust;

extern FlagT gft_SNRM_MODE_workaround;

//================================================================
// TDQ variables and flags
//================================================================

extern int16 gs_bypass_tdq;
extern int16 gs_bypass_doubletrain;
extern int16 gs_trysecondtrain;
extern int16 gs_doubletrain_decision_offset;
extern int16 gs_ModemHwMode;


//================================================================
// DEC variables and flags
//================================================================

extern FlagT gft_EnableDEC;
extern FlagT gft_EnableDecUpdate;


//================================================================
//Misc variables and flags
//================================================================

//Misc flags and variables
extern uint16 gus_VdslCntlFlag;                 //each bit constrols different operation in training
extern uint16 gus_VdslStatusFlag;               //each bit indicates a operation status
extern int16 gs_SynchSymbolDetectCnt;   //symbol symbol detection count
extern FlagT gft_RegStartIfft;                  //if set to 1, IFFT is configured to register start mode
extern FlagT gft_ReverbSegue;                   //indicator of reverb or segue signal

//================================================================
// Bitloading vars:
//================================================================
extern BitloadParam_t gt_BitloadParam;
extern FlagT gft_RestrictDpTo1;

extern int32 gl_MaxLpLimit;                     //the maximum Lp allowed
extern uint16 gus_BitloadErrorCode; // indicates bitload error codes
extern uint16 gus_MedleyBitloadErrorCode; // indicates bitload error codes during Medley

extern int16 gs_RxExtraBits;           // extra bits allocated due to use of fine gains
extern int16 *gpsa_RxFineGainPlusBitChannel;  // RX fine gains marker array

extern int16 gs_extra_snrmargin_for_low_tones;
extern int16 gs_high_tone_for_extra_snrmargin;

extern RxToneFlags guca_RxBitswapToneSet;     // One-bit-per-tone array used to indicate which tones ...
                                              // ... have been changed when reallocating bits for a ...
                                              // ... bitswap or OLR.

extern RxToneFlags guca_RxSupportedToneSet;     // One-bit-per-tone array used to indicate which the tones...
                                                                                        // ... that are transmitted by far end (ie. tones in Rx Band Plan)...
                                                                                        // ... minus the pilot tone (incase of CPE) and minus the RFI band tones...
                                                                                        // ...Assuming that Bitload Band Plan is *SAME* as Rx Band Plan,...
                                                                                        // ...this tone array is also used to indicate bitloadable tones.
extern RxToneFlags guca_RxSupportedToneSet_Aelem;       // For AELEM
extern RxToneFlags guca_RxSupportedToneSet_temp;

extern int16 gsa_ConstellationSNR[RX_MAX_BITS_PER_TONE+1];            // required SNRs for all constellation sizes without margin.
extern int16 gsa_SNRRequired[RX_MAX_BITS_PER_TONE+1];                 // required SNRs for all constellation sizes.
extern uint16 gus_ncloaded;
extern uint16 gusa_ncloaded[MAX_NUM_RX_BANDS];        // Number of tones with bits allocated to them in each band.
extern int16 gs_TxMaxConstSize;                       // Maximum bits per tone allocated for TX path
extern int16 gs_RxMaxConstSize;                       // Maximum bits per tone allocated for RX path
extern int16 gs_RxMinConstSize;                       // Minimum bits per tone allocated for RX path
extern int16 gs_MaxToneForFast;                       // Number of tones whose bits are allocated to fast path
extern int16 gs_MinTargetSnrMargin;                   // Minimum target SNR margin
extern int16 gs_BsDecisionThreshold;                  // XDSLRTFW-3807 8.8dB formated Threshold for BS decision
// !! Debug code to test maximum bits per tone per band, i.e. max constellation per band!!
extern int16 gsa_RxMaxConstSize[MAX_NUM_RX_BANDS];    // Maximum bits per tone per band.

extern int32 gla_SumFGainLinSq[MAX_NUM_RX_BANDS];     // Sum of fine gain linear square of each band
extern int32 gla_AvgFGainLinSqInit[MAX_NUM_RX_BANDS]; // Sum of fine gain linear square of each band computed

//XDSLRTFW-477
extern int16 gs_SaveRxNumBands;
extern int16 gs_ChangeTxBand ;
extern int16 gs_PrevFirstToneLastBand;
//XDSLRTFW-477

extern int16 gs_RFIBand;                          //number of minima found
//XDSLRTFW-1200 : BUG_DS_ALL_ALL_QUAD_SUPPORT
extern int16 gs_TxAfeFilter;                      //AFE ADSL Mode Filter Programmed
extern int16 gsa_PsdAnalysis_out[RX_MAX_NUM_TONES];
// XDSLRTFW-487_VR9_VRX318_VDSL2_All_AELEM_Support (START)
extern int16 gsa_ELE_Tmp[];         // store intermediate ELE results (sqrt_f and ELE values)
extern uint8 guca_QLN_tmp[1024];
extern int16 gsa_PsdPerTone[RX_MAX_NUM_TONES];

// XDSLRTFW-487_VR9_VRX318_VDSL2_All_AELEM_Support (END)
//XDSLRTFW-464 : DS_MARGIN_LOWER_TO_BRCM_DISTRIBUTE_FINEGAIN (Start)
extern int32 gla_AvgFGainLinSqInitTrain[MAX_NUM_RX_BANDS];      //Sum of fine gain linear square of each band computed
extern int32 gla_AvgFGainLinInitTrain[MAX_NUM_RX_BANDS];        //Sum of fine gain linear square of each band computed
extern int32 gla_AvgFGaindBInitTrain[MAX_NUM_RX_BANDS]; //Sum of fine gain linear square of each band computed
extern int32 gla_AvgFGainLinSqRefTrain[MAX_NUM_RX_BANDS];
//XDSLRTFW-464 : DS_MARGIN_LOWER_TO_BRCM_DISTRIBUTE_FINEGAIN (End)
extern int32 gl_MaxSumLpSupported;            // Maximum number of bits supported without coding gain.
extern int32 gl_FinalSumLp;             // total number of bits per DMT symbol (should be less than gl_MaxSumLpSupported)
extern int16 gs_RxMinMargin;                  // Minimum SNR margin in Q8.8
extern int16 gs_RxMinMarginTone;              // Tone with the minimum SNR margin
extern int16 gs_RxAvFineGain;                 // Average fine gain in Q8.8
extern int16 gs_ExcessMarRedDB;               // Excess Margin reduction in DB (Q8.8)
extern int16 gs_ExcessMarFGReduction;         // Fine gain reduction in dB (Q8.8)
// XDSLRTFW-539 FEATURE_ALL_VDSL2_ATTNDR_Update (START_END)
extern int32 gl_SumMedleySNR; //gl_Medley_maxATTNDRds;         // Medley maximum ATTNDRds estimation for Showtime ATTNDRds updating

extern int16 gs_MaxMarginIterations;                    //the max. number of iterations allowed for margin reduction
extern int16 gs_min_fine_gain_MarginRed;                //the min. fine gain for margin reduction
extern int16 gs_MarginReductionEnableFlag;              //If set to 1, enable the code to limit the SNR margin (internal use)
extern int16 gs_DisableFGMarginReductionFlag;   //1: margin reduction is not controled by the fine gain
extern int16 gs_ApplyMarginReduction;                   //internal flag used in CalcSnrMargin()
extern int16 gs_UnloadedToneFGreduction_dB;

extern int16 gs_MedleyAvgMargin;
extern int16 gs_MedleyMinMargin;
extern int16 gs_MedleyMinMarginTone;
extern int16 gs_MedleyAvgFineGain;
extern int16 gs_CurRxBand_save;
extern int16 gs_ch_save;

extern uint32 gul_NOMATP_linear;                                //linear nominal agregate transmit power computed in bitloading
extern uint32 gul_NOMATP_linear_lw;                     //Lower word of linear NOMATP
extern uint32 gul_NOMATP_linear_hw;                     //High word of linear NOMATP
extern uint32 gul_MAXNOMATP_linear_lw;          //Lower word linear maximum NOMATP to compare with
extern uint32 gul_MAXNOMATP_linear_hw;          //High word linear maximum NOMATP to compare with
extern int16 gs_NOMATP_dBm;                                     //NOMATP in dBm as defined in the standard
extern int16 gs_MAXNOMATP_dBm;                          //MAXNOMATP in dBm as defined in the standard
extern int16 gs_MedleyNOMATP_dBm;                       //NOMATP in dBm of the remote modem sent during Medley state
extern int16 gs_PreMarginRedNOMATP_dBm;         //NOMATP in dBm prior to SNR margin reduction
extern int16 *gpsa_LinearPsdBuffer;                     //pointer to the mantissa of the interpolated linear PSD
extern int16 *gpsa_LinearPsdExpBuffer;          //pointer to the exponent of the interpolated linear PSD
extern int16 gs_LogSubCarrierSpace;                     //10log(4312.5)*10 or 10log(4312.5*2)*10
extern int16 gs_PsdOffset_dB;                           //the PSD offset in MREFPSD
extern FlagT gft_MAXNOMATP_Flag;                        //if set to 1, impose the MAXNOMATP limit
extern FlagT gft_UpdateNomAtp_Flag;

extern FlagT gft_SaveMarginPerTone;                     // debug flag to force SNR update to store margin rather than SNR
                                                                                        // and disable subsequent SNR calcuations.

extern FlagT gft_BitloadOK;                 // Indicates whether bit loading SUCCEEDED or FAILED.
extern FlagT gft_FineGainOn;                // Indicates if fine gain should be used (TRUE) or not (FALSE).
extern FlagT gft_TxTcmFlag;
extern FlagT gft_RxTcmFlag;
extern FlagT gft_DsErasureDecodingFlag;         // erasure capability of receiver
extern FlagT gft_NewBitLoadFlag;                                // flag (set to 1) means do bitload from scratch

extern int16 gs_RxMinTone; // used to set MIN_TONE in IR_TONE register
extern int16 gs_RxMaxTone; // used to set MAX_TONE in IR_TONE register
extern int16 gs_Tcm_Oh;
extern uint16 gus_Tx_Tcm_Num1bits;      // Number of 1 bit loaded tones in the TX BAT
extern uint16 gus_Rx_Tcm_Num1bits;      // Number of 1 bit loaded tones in the RX BAT
extern uint16 gus_Rx_1Bit_Index;        // index in TRT of first 1-bit tone
extern int16 gs_ChooseFgThresh;         //the initial value of s_threshold used in ChooseFineGains()

extern FlagT gft_extrafinegainallocated; // flag to allocate extra fine gain as soon as we can to take care of forceeven1 changes
extern FlagT gft_Flag_limitCause;

// Fine gains adjustment vars:
extern int16 gs_fgain_maxed_tones;            // Number of tones that have max fine gains.
extern int16 gs_fgain_adjust;                             // Amount of fine gain adjustment in Q8.8
extern int16 gs_max_fine_gain;                // Max fine gain in Q8.8
extern int16 gs_min_fine_gain;                // Min fine gain in Q8.8

extern FlagT gft_ToneOrderOK;                                   // flag to indicate tone ordering failure
extern int16 gs_TxToneOrderType;                                // Tx tone order type
extern int16 gs_RxToneOrderType;                                // Rx tone order type
extern int16 gs_ToneReorderErrorCode;                   // tone order error code

extern FlagT gft_EnableRxIlvTrt;
extern int16 gs_ilv_tone_order_parm_K;                  // calculated parameter for interleaved tone-reordering
extern int16 gs_ilv_tone_order_parm_L;                  // input parameter for interleaved tone-reordering
extern int16 gs_ilv_tone_order_num_empty_slots; // calculated parameter for interleaved tone-reordering

extern int16 gs_NumCheckByte; // # of check byte on which coding gain is determined
extern int16 gsa_TotalCodingGain[NUM_DATA_PATHS]; // total coding gain in dB applied to each path.
extern uint8 guca_RSCodingGain[MAX_NUM_CHECK_BYTE]; // RS coding gain table in Q4.4 format
extern int32 gla_MaxSumLp[MAX_NUM_CHECK_BYTE]; // maximum channel capacity for different value of check byte

extern VDSL2FramingParamsInputs_t gt_FormFramingParamsInputs_v2;

// Bit-field register to indicate the error code/status from FormVDSL2FramingParams()
extern int16 gs_VDSL2FrameParamGenStatus;

//The following is log2(K), K = 1, 2, 4, 8, 16 (ignore other terms)
extern int16 gsa_log2Tbl[17];

extern uint32 gul_DILV_MEM_SIZE;                         // I*D/2 must be less than this parameter (NE)
extern uint32 gul_FE_DILV_MEM_SIZE;                      // I*D/2 must be less than this parameter (FE)
extern uint32 gul_HW_ILV_MEM_SIZE[NUM_DATA_PATHS];       // HW interleaver memory limit
extern uint32 gul_HW_DILV_MEM_SIZE[NUM_DATA_PATHS];      // HW deinterleaver memory limit
extern uint32 gul_ilvb_size;                             // Actually used ILVB memory size
extern uint32 gul_dilvb_size;                            // Actually used DILVB memory size

extern FlagT gft_NE_IlvDilvMemType;                      // NE ILV/DILV memory type
extern FlagT gft_FE_IlvDilvMemType;                      // FE ILV/DILV memory type
extern uint32 gul_FE_HW_ILV_MEM_SIZE;                    // FE HW interleaver memory limit
extern uint32 gul_FE_HW_DILV_MEM_SIZE;                   // FE HW deinterleaver memory limit

extern int16 gs_ZEP_DTB_SIZE_TX_WDS;
extern int16 gs_ZEP_DTB_SIZE_RX_WDS;

extern int16 gs_ZEP_ILV_RAM_TXDTB_OFFSET;
extern int16 gs_ZEP_ILV_RAM_RXDTB_OFFSET;

extern int16 gs_ZEP_ILV_RAM_TXDTB_LP0_SIZE;
extern int16 gs_ZEP_ILV_RAM_TXDTB_LP2_SIZE;
extern int16 gs_ZEP_ILV_RAM_TXDTB_LP1_SIZE;

extern int16 gs_ZEP_ILV_RAM_RXDTB_LP0_SIZE;
extern int16 gs_ZEP_ILV_RAM_RXDTB_LP0_PONG_SIZE;
extern int16 gs_ZEP_ILV_RAM_RXDTB_LP2_SIZE;
extern int16 gs_ZEP_ILV_RAM_RXDTB_LP1_SIZE;

extern uint8 guc_RxUcodeHandle;
extern uint8 guc_TxUcodeHandle;

extern uint16 gus_PctMaxDelayOctetsForUS;                // Proportion of MAXDELAYOCTET or HW buffer size used for US (in Q1.15)

extern int16 gs_DataFrameRate;                           //in symbols/second
extern FlagT gft_AccurateFrameRateEnable, gft_computeDataRateFS6;

extern int32 gla_MaxInlvDelay[NUM_DATA_PATHS];
extern int32 gla_MaxInlvDelayUs[NUM_DATA_PATHS];

extern uint8 guc_minR, guc_maxM, guc_maxT, guc_maxG;
extern uint16 gus_DSearchRange;
extern FlagT gft_EnableINPFix;

// XDSLRTFW-3280 - Start - PLL improvement / pilot tone selection improvement
//================================================================
// PLL vars:
//================================================================

extern int16 gs_PhaseError;
extern int16 gs_MaxPhaseError;
extern int32 gl_pll_loopfilter_out;
extern int32 gl_pll_freq_offset;
extern FlagT gft_EnablePLL;
extern FlagT gft_PrevPLLState;

extern int16 gs_Kp_Fast, gs_Ki_Fast;
extern int16 gs_Kp_Slow, gs_Ki_Slow;

extern int16 gs_NumFramesPLLAcquisition;
extern int16 gs_NumFramesPLLRelock;
extern uint16 gs_PllWaitMedley;

extern FlagT gft_UpdateTimingRecoveryHWEnable;
extern FlagT gft_EnableNoiseShaping;
extern int16 gs_ForcePllShowLimit;
extern int32 gl_noise_shaping_quan_err;
extern int32 gl_constant_SRCFR_offset;
extern int16 gs_TiedClocks;
extern FlagT gft_DisableSRCBugWorkAround;
extern int16 gs_PLLAvgHandlerState;
extern int16 gs_PLLAvgHandlerCnt;
extern int16 gs_PLLSymbolsToAvg;
extern int16 gs_PLLSymbolsToAvgLog2;
extern FlagT gft_Try2ndBestPTIdx;
extern uint16 gs_PTSwitchMaxPhaseError;

// Variables to estimate line condition (used for PLL control, etc.) XDSLRTFW-2481
extern uint8  guc_EdMetricThresholdDuringExtNoise;
extern uint16 gus_MicroInterruptionDetectionCnt;
extern uint16 gus_SymbolWithLowEdMetricCnt;
extern int16  gs_PhaseErrorThresholdDuringMI;
extern int16  gs_PhaseErrorThresholdDuringExtNoise;
extern int16  gs_PhaseErrorThreshold;
extern uint16 gus_NoiseDetected;

extern uint16 gus_QlnLow;
extern uint16 gus_QlnHigh;


//PLL Debug Frquency Offset history
extern int16 gsa_pll_freq_offset_ppm_q4[];
extern int16 gs_PllRunningIndex;

//PLL Debug Phase Offset history
extern PllPhaseRotInfo_t gta_PllPhaseRotInfo[];
extern int16  gs_Last_Reported_Phase_Error;
extern int16  gs_SectorIdx_PhaseError;
extern int16  gs_Prev_SectorIdx_PhaseError;
extern int16  gs_NumOfIdenticalAdjacentPTPhases;
extern int16  gs_MinNumberOfAdjPhaseErrorsToDeclareNewPhase;
extern uint16 gus_PhaseErrorReporting_Idx;

//================================================================
// Pilot tone vars:
//================================================================

extern PilotConfig_t gt_PilotConfig;

extern FlagT gft_DeRotateMedleyPilot;
extern FlagT gft_EnableShowPllToneSwitch;
extern int16 gs_PilotSelectOffset;
extern int16 gs_PilotSelectRightEdgeOffset;
extern int16 gs_MaxPhaseErrorThreshold;
extern int16 gs_MaxPilotToneIndex;

extern int16 gsa_AvgRefPilotToneReal[MAX_NUM_PILOT_TONES];
extern int16 gsa_AvgRefPilotToneImag[MAX_NUM_PILOT_TONES];
extern int32 gla_AvgRefPilotToneReal[MAX_NUM_PILOT_TONES];
extern int32 gla_AvgRefPilotToneImag[MAX_NUM_PILOT_TONES];

extern int16 gs_FrameWithLowPilotPwrCnt;
extern int16 gs_MaxNumofCorruptedPilot;
extern int16 gs_Kl0_thresh_pilot_select;

extern uint8 guc_LosDefect_state;
extern int8 gc_log2_num_syms_for_avg;
extern int16 gs_num_syms_for_avg;
extern int16 gs_LosDefect_state_cnt;
extern int32 gl_AvgPilotPow_Thresh;
extern int32 gl_AvgPilotPow;

// XDSLRTFW-3280 - End - PLL improvement / pilot tone selection improvement

/* =============================================== */
/* global variable declarations for TDQ  */
/* =============================================== */
extern int16 gsa_pre_tdq_h[TDQ_LENGTH];         /* TDQ filter coefficients' mantissas */
extern int16 gs_pre_tdq_h_exp;                                  /* TDQ filter coefficients' common exponent */
extern int16 gs_TDQLen;

extern FlagT gft_ReconfigHw;
/* ====================================================== */
/* Array to hold the Qln and Hlog values */
/* ====================================================== */
extern uint8 guca_QLN[];

extern FlagT gft_StrongNoiseDetected;

extern int16 *gsa_RxHlog;

extern int16 gs_CarrierGroupSizeTx_Disc;
extern int16 gs_Log2CarrierGroupSizeTx_Disc;
extern int16 gs_CarrierGroupSizeRx_Disc;
extern int16 gs_Log2CarrierGroupSizeRx_Disc;
extern int16 gs_CarrierGroupSizeTx_Medley;
extern int16 gs_Log2CarrierGroupSizeTx_Medley;
extern int16 gs_CarrierGroupSizeRx_Medley;
extern int16 gs_Log2CarrierGroupSizeRx_Medley;

extern ChannelMeasurement_t gt_ChannelMeasurement_FE;   //measurement done by the far-end RX side
extern ChannelMeasurement_t gt_ChannelMeasurement_NE;   //measurement done by the near-end RX side

extern int32 gl_MaxBits_CeilingOpt_ADC;
extern int16 gs_NumTones_CeilingOpt_ADC;
extern int16 gs_ceil_adequate;
extern int16 gs_ceil_best;
extern FlagT gft_EnableProposedCeilingOpt;              //flag used to enable ceiling reduction for improved SNR
extern FlagT gft_EnableProposedCeiling;
extern int16 gs_CeilingOptBandPlanEnable;       // enable Ceiling Opt per band plan
extern int16 gs_ForceSpecialCeilValueDs_Cntl;   // Bit field to force special ceiling value for DS.
                                                // XDSLRTFW-1836 : Identify the wrong MaxNomPSD Values Calulated
extern int16 gs_Force_Dn_ProposedPsdCeiling;    // format: dB/10
                                                // special value      0: CPE calculates DS ceiling
                                                // special value 0x1000: no CPE limit on DS ceiling

extern FlagT gft_LimitUsCeiling;
extern FlagT gft_SlidingUsInitialCeiling;

/* ====================================================== */
/* global variable definitions for Tx/Rx Cyclic Extension */
/* ====================================================== */
extern int16 gs_TxCELength;     // TX cyclic extension length
extern int16 gs_RxCELength;     // RX cyclic extension length
extern int16 gs_TxBetaLength;   // the beta length for TX
extern int16 gs_RxBetaLength;   // the beta length for RX (that is the remote modem TX's beta length)
extern int16 gs_PreCELength;    // Previous CE length
extern int16 gs_m;              // parameter m in equation Tx/Rx-CELength = m*N/32
extern int16 gs_RxWindowLength; // Rx windowing length in samples
extern int16 gs_TxWindowLength; // Tx windowing length in samples
extern FlagT gft_ReduceChDiscoveryRxWindowLength; // Flag to reduce Channel Discovery Windowing length
extern FlagT gft_DisableTxWin;  //TRUE: disable TX windowing, FALSE: enable TX windowing
extern FlagT gft_DisableRxWin;  //TRUE: disable RX windowing, FALSE: enable RX windowing
extern FlagT gft_StartTxWin;

extern uint8 guca_NMS[RX_MAX_NUM_TONES];
extern int16 gsa_NMS_ResetPllRefToneInput_Re_Save[MAX_NUM_PILOT_TONES];
extern int16 gsa_NMS_ResetPllRefToneInput_Im_Save[MAX_NUM_PILOT_TONES];
extern int16 gs_NMS_AGC1_Gain_Save;
extern uint8 guc_NMS_AlgHandler;
extern FlagT gft_OKToSendBGFlag;                //flag used to hold off R/O-BG message until code swap is complete
// XDSLRTFW-3898(Start)
extern int32 gla_HybTrMetric_US0US1[VRX_MAX_NUM_ADAP_HYB_SETTINGS + VRX_NUM_CAP_SEARCH];
// Note: It is not allowed to change the order of the below 4 - arrays, i.e.
//       gla_HybMetricTrace, gsa_HybTrRxPathGain, gsa_HybTrMetricEcho and gsa_AceModeforHybridSelected.
//------------------------------
extern int32 gla_HybMetricTrace[2];
extern int16 gsa_HybTrRxPathGain[((VRX_MAX_NUM_ADAP_HYB_SETTINGS + VRX_NUM_CAP_SEARCH +1) >> 1) << 1]; // allocate always an even number of 16-bit data
extern int16 gsa_HybTrMetricEcho[((VRX_MAX_NUM_ADAP_HYB_SETTINGS + VRX_NUM_CAP_SEARCH +1) >> 1) << 1]; // allocate always an even number of 16-bit data
extern int16 gsa_AceModeforHybridSelected[VRX_MAX_NUM_ADAP_HYB_SETTINGS + VRX_NUM_CAP_SEARCH];
//------------------------------
extern uint16 gusa_HybridsForProfileSelected[VRX_MAX_NUM_ADAP_HYB_SETTINGS][VRX_HYB_NUM_SETTINGS];
extern uint16 *gpus_HybridsForProfileSelected;

extern int16 gsa_CapCpb_delta[VRX_NUM_CAP_CPB_SEARCH];
extern int16 gsa_CapCpb_delta_size;
extern int16 gsa_CapCpc_delta[VRX_NUM_CAP_CPC_SEARCH];
extern int16 gsa_CapCpc_delta_size;
// XDSLRTFW-3898(End)
extern int16 gsa_RxHlog_DS[];

extern uint8 guca_erb_ping_pong_buffer[1056];

// RX and TX (raised cosine) window coefficients
extern int16 gsa_WindowCoeffs[TX_WINDOW_LENGTH_8K_IFFT/2];
extern int16 gsa_WindowCoeffsBrcm[TX_WINDOW_LENGTH_8K_IFFT/2];

// 0 - do not perform frame realignment when there is CCp/CS length change
// 1 - perform frame realighment
extern int16 gs_EnablePeriodicFrameRealign;
extern int16 gs_RxTxCsDiff;
extern int16 gs_CsLength;
extern int16 gs_HandleRxCE_PeriodicStateStart_s_count;
extern int16 gs_HandleRxCE_PeriodicStateStart_StartSym_Offset;
extern int16 gs_HandleRxCE_PeriodicStateStart_EndSym_Offset;
extern int16 gs_HandleRxCE_Periodic2StateStart_StartSym_Offset;
extern int16 gs_HandleRxCE_Periodic2StateStart_EndSym_Offset;

extern int16 gs_TurnOffPLL_in_OPSYNCRO1;


extern FlagT gft_RxTxCsDiff_err;
extern FlagT gft_SkipSymbol;
extern int16 gs_FeModemLog2IfftSize;    //log2 of the IDFT size used bythe far-end modem

//================================================================
// TX/RX message control variable/flags
//================================================================

//TX side
extern int16 gs_TxHDLCMsgState;                 //HDLC message handler state
extern uint16 gus_TxHDLCMsgFCS;                 //FCS check word
extern int16 gs_UpdateTxMsgIdxFlag;             //flag indicating if the TX msg index should be updated or not
extern int16 gs_NumOctetsInTxHDLCMsg;   //number of octets in TX message payload
extern int16 gs_SendRAckFlag;                   //flag indicating which ACK message to send
extern int16 gs_FormMsgFlag;                    //flag to indicate if the message generation is done or not
extern int16 gs_NumRxRepeatRequest;     //number of times to resend O-UPDATE message
extern int16 gs_TxNumBytesPerSymbol;            //number of bytes modulated per TX symbol
extern uint8 *gpuca_TxSocMsg;                   //Pointer to TX Soc Messages
extern uint8 guc_TxHDLCMsgIndex;                //TX Message index
extern uint8 guc_TxMsgCode;                             //TX message code
extern uint8 guc_TxSegmentIdx;                  //TX segment index
extern int16 gs_NumTxRepeatRequest;             //number of REPEAT_REQUEST messages have been sent;
extern int16 gs_SendAckSegFlag;                 //indicate if ACK-SEG should be transmitted or not
extern int16 gs_RevAckSegFlag;                  //indicate if ACK-SEG is received or not

extern uint8 guc_MaxNumEocBytesPerSym;  //max. no. of EOC bytes per symbol
extern uint8 guc_MaxNumVocBytesPerSym;  //max. no. of EOC bytes per symbol
extern int16 gs_NumEocBytesPerSym;              //actual no. of EOC bytes per symbol
extern int16 gs_NumVocBytesPerSym;              //actual no. of EOC bytes per symbol
extern uint8 guca_TxSocResend[5];
//#ifdef MTK_VECTORING_SUPPORT
extern FlagT gft_TxHDLCSegmentedAutoRepeatMode;
extern uint8 guc_TxHDLCMsgIndexBackup;          //TX Message index backup for RP Vector 2 ERB message
//#endif //#ifdef MTK_VECTORING_SUPPORT
//RX Side
extern int16 gs_RxHDLCMsgState;                 //Rx HDLC message handler state
extern uint16 gus_RxHDLCMsgFCS;                 //FCS check word
extern int16 gs_RxWholeMsgLength;               //length of a complete RX message
extern int16 gs_RxMsgCheckOkFlag;               //Flag set to TRUE if the message check is ok, else FALSE
extern int16 gs_RxMsgErrorCode;                 //RX message decoding error code
extern int16 gs_MsgReceiveFlag;                 //Flag set to TRUE if a TX message has been received correctly
extern int16 gs_NumOfToneClustersForMsgDecode;          //number of tone clusters to use for decoding message
extern int16 gs_RxNumChannelsForMsgDecode;                      //=gs_NumOfToneClustersForMsgDecode*10
extern int16 gsa_SOCMsgRxToneClusterStarts[NUM_TONE_CLUSTERS_FOR_MSG_DECODING];  // The starting indices for
                                                                              // each msg decode tone cluster
extern int16 gs_RxNumBytesPerSymbol;                    //number of bytes modulated per RX symbol
extern uint8 guc_NumberOfPossibleRxMsgs;        //number of possible expected messages
extern uint8 guca_PossibleRxMsgCodes[];         //possible expected message codes
extern uint8 guc_RxMsgCode;                                     //RX Message code
extern uint8 guc_ExpectedMsgIdx;                        //RX expected message index
extern uint8 guc_RxHDLCMsgIndex;                        //RX Message index
extern uint8 guc_RxSegmentIdx;                          //RX segment index
extern uint8 guc_RxNumOfSegments;                       //number of segments in RX message
extern int16 gs_OContractIdx;                           //Index n of O-CONTRACTn

extern FlagT gft_StrictSynchroDetect;

extern HDLC_Fifo_attrib_t RxHDLCFifo;           //received HDLC message descriptor
extern uint8 *gpuca_RxHDLCMsgBuf;

extern uint8 guca_TxOctet[2];                   // contains the next HDLC byte(s) for transmission.
extern uint32 gl_SocTxDataForPrbs; // contains HDLC msg byte(s) in hw format for each VDSL frame during training.
//#ifdef MTK_VECTORING_SUPPORT
extern uint32 gl_SocTxDataForPrbs_ext[7];
//#endif
extern uint16 gus_PrbsState; // stores PRBS state

extern uint8 guc_ExchangePhaseTxNumBytesPerSymbol; //desired number of bytes modulated per TX symbol used in the exchange phase
extern uint8 guc_ExchangePhaseRxNumBytesPerSymbol; //desired number of bytes modulated per RX symbol used in the exchange phase

extern uint32 gul_SocMsgNotCompliedAmends;         // debug variable to keep track which amendments (in which msg) not complied.

// Soc Msg info saved in case of FCS error:
extern RxSocMsgFCSErrInfo_t  gt_RxSocMsgFCSErrInfo;

// ******************************************
// SOC (Special Operation Channel) Messages:
// ******************************************

//========================================
//TRAINING PHASE MESSAGES
//========================================

extern uint16 gus_OSignatureErrorCode;

        extern DecMsg_O_Signature_t gt_DecMsg_O_Signature;      //Decoded O-Signature Message
        extern DecMsg_O_Update_t gt_DecMsg_O_Update;            //Decoded O-Update Message

//VDSL2 messages and structures
        extern DecMsg_O_Signature_VDSL2_t gt_DecMsg_O_Signature_VDSL2;//Decoded O-Signature Message
    extern DecMsg_O_Update_VDSL2_t    gt_DecMsg_O_Update_VDSL2;   //Decoded O-UPDATE
    extern DecMsg_O_Prm_VDSL2_t       gt_DecMsg_O_Prm_VDSL2;      //Decoded O-PRM
        extern DecMsg_O_TA_Update_VDSL2_t gt_DecMsg_O_TA_Update;          //Decoded O-TA-UPDATE
    extern DecMsg_O_Msg1_VDSL2_t      gt_DecMsg_O_Msg1_VDSL2;     //Decoded O-MSG1
    extern DecMsg_O_TPS_VDSL2_t       gt_DecMsg_O_TPS_VDSL2;      //Decoded O-TPS

//XDSLRTFW-439: Feature_All_DS_All_All_SupportDsTxRefVirtualNoise (Start_End)
extern DsVnPSDDescriptorTable_t       gt_DS_RefVirtNoiseLevel_VDSL2; //Field16 O-SIG

extern UsVnPSDDescriptorTable_t       gt_US_RefVirtNoiseLevel_VDSL2; //Field18 O-SIG

extern int16 gs_RxNextState_ToBe;                       //Next RX state to be in (but may not immediately)
extern PtrToFunc gpF_RxStateFunc_ToBe;          //Next RX state function to be used ((but may not immediately)
extern int16 gs_RxNextStatePeriodicFlag;    //1: means peridodic state, 0 means no periodic state

extern int16 gs_TxNextState_ToBe;
extern PtrToFunc gpF_TxStateFunc_ToBe;

extern int32 gl_TxTeqLength;                            //duration of TX TEQ state length in symbol of 2N
extern int32 gl_TxEctLength;                            //duration of TX EC state length in symbol of 2N
extern int32 gl_TxPeriodicLength;                       //duration of TX Periodic EC state length in symbol of 2N
extern int32 gl_RxTeqLength;                            //duration of RX TEQ state length in symbol of (2N+Lce)
extern int32 gl_RxEctLength;                            //duration of RX ECT state length in symbol of (2N+Lce)
extern int32 gl_RxPeriodicLength;                       //duration of TX Periodic EC state length in symbol of (2N+Lce)

extern int32 gl_TxQuiet3Length;                 //duration of TX Quiet 3 state length in symbol of (2N)
extern int32 gl_RxPilot2Length;                 //duration of RX Pilot 2 state length in symbol of (2N+Lce)
extern int32 gl_RxPilot3Length;                 //duration of RX Pilot 3 state length in symbol of (2N+Lce)

// XDSRTFW-442: Feature_All_All_All_All_Vdsl2Sra [Start]

extern uint16 gs_MONI_US_OLREventMask;
extern uint16 gs_MONI_DS_OLREventMask;
extern uint8 guc_last_OLRPMMsgReceived;
extern uint16 gus_USShowtimeEvents;
extern uint16 gus_DSShowtimeEvents;

extern uint32 gul_rx_current_Lp[NUM_DATA_PATHS];
extern uint32 gul_tx_current_Lp[NUM_DATA_PATHS];

extern int16 gs_ExcessMarFGReduction_save;
extern AutoSRA_t gt_RxAutoSRA_Ctrl;             // RX SRA control parameters
//XDSLRTFW-1456
extern int16 gs_MinMsgOHR_save;

extern uint8 guc_SRAState;
extern FlagT gft_USRAInitiate;
extern FlagT gft_DSRAInitiate;
extern FlagT gft_RxSraInProgress;
extern FlagT gft_SNRUpdated_PostSRA;
extern FlagT gft_CapableRxAutoSRA;
extern FlagT gft_CapableTxSRA;
extern FlagT gft_EnableRxAutoSRA;
extern FlagT gft_EnableTxSRA;
// Auto SRA framing threshold
extern FlagT gft_SRARateViolated;
extern FlagT gft_SRA_FAIL;
extern uint8 guc_SraShiftControl;
extern uint8 guc_SraShiftOffset;

extern int16 gs_UTIME_Count;
extern int16 gs_DTIME_Count;
extern int32 gl_SRATotalLp_DeltaCnt, gl_SRATotalLp_Delta, gl_SRATotalLpDeltaMax;
extern int16 gs_MaxTones_SRAIteration;
extern int16 gs_delta_Lp;
extern int32 gl_ActualDeltaSumLp;
extern int16 gs_NoOfDsSraAfterSnrUpdate; // No of DS SRA count after last DS SNR update


extern uint32 gul_AutoSRALmin;
extern uint32 gul_AutoSRALmax;

extern uint16 gusa_Lmin[5];

extern uint32 gula_Lmax[7];
extern int16 gs_data_path;

extern uint16 gus_DsRAMode;
extern uint16 gus_UsActRAMode;

extern FlagT gft_BlockSRA;
extern uint8 guc_SraReject;
// XDSRTFW-442: Feature_All_All_All_All_Vdsl2Sra [End]

//CO requested training lengths
extern uint8 guc_CoReq_EcLength;                        //VTU-O EC training length in multiple of 64
extern uint8 guc_CoReq_TeqLength;                       //VTU-O TEQ training length in multiple of 64
extern uint8 guc_CoReq_RtTeqLength;                     //VTU-R TEQ training length in multiple of 64
extern uint8 guc_CoReq_PeriodicLength;          //Periodic signal length in multiple of 64

//CPE requested training lengths
extern uint8 guc_RtReq_EcLength;                        //VTU-R EC training length in multiple of 64
extern uint8 guc_RtReq_TeqLength;                       //VTU-R TEQ training length in multiple of 64
extern uint8 guc_RtReq_CoTeqLength;                     //VTU-O TEQ training length in multiple of 64
extern uint8 guc_RtReq_PeriodicLength;          //Periodic signal length in multiple of 64
extern uint8 guc_RtReq_RPTrainLength;           //duration of R-P-Training

extern uint8 guc_RtAct_RPTrainLength;           //duration of actual R-P-Training

extern int16 gs_VDSL2_MIN_R_IDLE_TX_TRAIN2;

//========================================
//CHANNEL ANALYSIS AND EXCHANGE MESSAGES
//========================================
extern Inlv_Descriptor_t gta_TX_DetailedInlvSetting[4];
extern Inlv_Descriptor_t gta_RX_DetailedInlvSetting[4];
extern R_O_Msg2_t gt_O_Msg2;                                    //O-MSG2
extern R_O_Msg2_t gt_R_Msg2;                                    //R-MSG2
extern Contract_t gt_tx_contract;       //TX contract
extern Contract_t gt_rx_contract;       //RX contract
extern int8 gc_RMargin;                                                 //R-MARGIN in 0.5 dB step size
extern uint8 guc_jmax;
//#ifdef MTK_VECTORING_SUPPORT
extern R_Msg1_G993_5 gt_R_Msg1_G993_5;
//#endif //MTK_VECTORING_SUPPORT


extern FlagT gft_StartTxShowinit;
extern FlagT gft_StartTxSynchro;
//==============================================================================
// PMS/PMD parameters
//==============================================================================
extern Config_t gt_tx_config; // TX PMS/PMD parameters
extern Config_t gt_rx_config; // RX PMS/PMD parameters

extern VDSL2Config_t gt_tx_config_v2;
extern VDSL2Config_t gt_rx_config_v2;
extern VDSL2Config_t gt_rx_config_v2_Attndr;

// XDSLRTFW-3898(Start)
extern Reconfig_Hyb_Coeff_t gt_Reconf_Hybrid_Coeff;
// XDSLRTFW-3898(End)

extern BC_LP_TPS_Map_t gt_tx_TPS_Map;
extern BC_LP_TPS_Map_t gt_rx_TPS_Map;

extern uint8 guc_data_path_tx;
extern uint8 guc_ohmsg_path_tx;
extern uint8 guc_data_path_rx;
extern uint8 guc_ohmsg_path_rx;

extern uint16 gus_dilvb_avail[NUM_DATA_PATHS];
extern uint16 gus_invalid_bytes[NUM_DATA_PATHS];

extern int16 gs_wt_step[NUM_DATA_PATHS];
extern int16 gs_rd_step[NUM_DATA_PATHS];

//==============================================================================
// variables used during showtime initialization
//==============================================================================
extern uint8 guc_TxShowInitState; // used in TxShowInitHandler()
extern uint8 guc_RxShowInitState; // used in RxShowInitHandler()
extern uint8 guc_BgTxShowInitState; // used in all background tasks in TxShowInitHandler()
extern uint8 guc_BgRxShowInitState; // used in all background tasks in RxShowInitHandler()
extern uint8 guc_TxDataPumpState; // used in TxDataPumpSetUp()
extern uint8 guc_RxDataPumpState; // used in RxDataPumpSetUp()

//==============================================================================
// variables used during showtime
//==============================================================================
extern uint16 gus_ShowtimeFGTask;
extern uint16 gus_ShowtimeControl; // showtime control flag (bit-field defined in vdsl_const.h)
extern uint16 gus_ShowtimeControlDDSave;
extern int16 gs_RxToneOffsetShadow;
extern int16 gs_first10secs_in_Showtime;
extern FlagT gft_ErrorFree_10sInShowtime;

extern uint8 guc_RxDataFrameState; // state used in RxDataFrameProcess()

extern int16 gs_CorruptCRCControl; // Showtime test control
extern uint8 guc_CrcOffHistory;
extern uint8 guc_SefHistory;

// variables used for test control, e.g.
// to "insert" CRC errors or FEC corrections
extern int16 gs_ZEP_FEC_override_cnt[NUM_DATA_PATHS];
extern int32 gul_ZEP_FEC_override_data;

extern int16 gs_ZEP_CRC_override_cnt[NUM_DATA_PATHS];
extern int16 gs_ZEP_CRC_override_data;
extern int16 gs_ALF_HEC_override_cnt[NUM_BEARER_CHANNELS];

//==============================================================================
// Showtime synch frame processing
//==============================================================================
extern int16 gs_TxPMDFrameCount;                // Tx PMD frame count (0 to 256)
extern volatile int16 gs_RxPMDFrameCount;                // Rx PMD frame count (0 to 256)
extern int16 gs_RxSynchFrameNumTones;   // # of tones to read from RTV buffer
extern int16 gs_RxSynchFrameOffset;             // offset into RTV buffer
extern int16 *gpsa_RxSynchFrame;                // pointer to Rx synch frame which is read from the RTV buffer that
                                                                                // contains the FDQ output

// Used for saving PRBS related registers which are needed for modulating Medley PRBS on unused
// tones (b_i=0 and g_i > 0) of data frames
extern int16 gusa_PrbsRegistersSav[NUM_PRBS_SAVE_REGS];

//==============================================================================
// variables used in decision-directed SNR/FDQ calculation
//==============================================================================
extern DDSnrFdqConfig_t gt_DDSnrFdqConfig;

extern int16 gs_DDSnrFdqState; // used in DDSnrFdqHandler()
extern int16 gs_DDSnrState; // used in DDSnrFdqHandler() to control SNR update separately
extern int16 gs_DDFdqState; // used in DDSnrFdqHandler() to control FDQ update separately
extern int16 gs_NumSnrUpdate; // # of SNR updates during showtime
extern int16 gs_NumFdqUpdate; // # of FDQ updates during showtime
extern int16 gs_NumRxPowerUpdate; // # of Rx Power updates during showtime
extern int16 gs_DDFdqAdaptSlew; // step-size used in SSLMS FDQ adaptation algorithm
extern FlagT gft_ApplyConstGain; // apply constellation gain on signal power during SNR calculation
extern uint8 guc_SNRFDQControl;

extern int16 *gpsa_FftOutputBuf; // pointer to FFT output buffer read from RTV buffer
extern int16 *gpsa_ErrOutputBuf; // pointer to error ouput buffer read from RTV buffer
extern int16 *gpsa_FftErrCorrBuf; // pointer to correlation output buffer between FFT output & error ouput
extern int16 *gpsa_ScratchPad_X; // pointer to scratch pad in X memory
extern int16 *gpsa_ScratchPad_Y; // pointer to scratch pad in Y memory

extern FlagT gft_EnableFdqUpdate;
extern FlagT gft_EnableSnrUpdate;

extern int16 gs_LOS_override_cnt;               // used to override the no. of LOS defects

extern DDRxPowerCalc_t gt_DDRxPowerCalc; // used for signal power calculation for LOS detection

extern FlagT gft_EnableFDQUpdateWorkaround;
extern int16 gs_DDSnrFdqCount;
extern int16 gs_DDFdqAdaptSlewSlow;
extern int16 gs_DDFdqAdaptSlewFast;
extern int16 gs_DDFdqSpeedupMaxCount;
extern FlagT gft_SkipBitswap;

//==============================================================================
// Overhead messaging variables
//==============================================================================

// Variables that defined how often the IBits should be processed and it's in terms of PMD frames (a.k.a. DMT symbols)
extern int16 gs_PMDFramesPerTxIBStructure;
extern int16 gs_PMDFramesPerRxIBStructure;

// IB variables
extern uint8 guca_TxIbMsgBuf[MAX_IB_BYTES_PER_SFRAME];
extern uint8 guca_RxIbMsgBuf[MAX_IB_BYTES_PER_SFRAME];

// Temporary IB storage - used to hold IBs until CRC is received.
// if CRC error occurs, then the IBs are discarded
extern uint8 guca_RxIbMsgBufTemp[MAX_IB_BYTES_PER_SFRAME];
// FeLprLosDelay is used to delay between FE LPR indicator
// and NE LOS check.  This allows time for LOS to appear.
extern int16 gs_FeLprLosDelay;
extern uint16 gusa_nSyncLoss[2];//Debug for XDSLRTFW-2050
extern TxIbDataStruct_t gt_TxIbData;
extern RxIbDataStruct_t gt_RxIbData;

// Test variables for introducing far end anomalies/defects in the form of indicator
// bytes(IBs) at one end and read out the received IBs content at the other end
extern int16 IB_override_count;
extern int16 IB_override_content[3];
extern int16 IB_readout_count;
extern int16 IB_readout_content[3];

// Flag used to write Tx IB to HW Fifo
extern FlagT gft_WriteTxIbHwFifo;

// VOC variables
extern uint8  *puca_NextTxVocMsgBytes;
extern uint16 us_NumNextTxVocMsgBytes;

extern uint8 guca_TxVocSwFifoBuf[TX_VOC_MSG_SWFIFO_LEN];
extern int16 gs_TxVocSwFifoDepth;
extern int16 gs_TxVocRdPtr;
extern int16 gs_TxVocWrPtr;
extern int16 gs_TxVocState;

extern uint8 guca_RxVocSwFifoBuf[RX_VOC_MSG_SWFIFO_LEN];
extern int16 gs_RxVocRdPtr;
extern int16 gs_RxVocWrPtr;
extern int16 gs_RxVocState;
extern uint8 guc_RxVocMsgType;
extern uint16 gus_RxVocMsgLen;
extern uint16 gus_RxVocMsgCnt;

/////////////////////////
// VDSL2 ovhd FIFOs
/////////////////////////

extern uint8 guca_TxOvhdSwFifoBuf[TX_OVHD_MSG_SWFIFO_LEN];
extern int16 gs_TxOvhdSwFifoDepth;
extern int16 gs_TxOvhdRdPtr;
extern int16 gs_TxOvhdWrPtr;
extern int16 gs_TxOvhdState;
extern int16 gs_TxOvhdMsgIndex;
extern int16 gs_NumOHFrames;

extern uint8 guca_RxOvhdSwFifoBuf[RX_OVHD_MSG_SWFIFO_LEN];
extern int16 gs_RxOvhdRdPtr;
extern int16 gs_RxOvhdWrPtr;
extern int16 gs_RxOvhdMsgIndex;
extern int16 gs_RxOvhdState;
extern int16 gs_RxOvhdSubState;

// Received sync byte in VDSL2
extern uint8 guc_RxSyncByte;

//==============================================================================
// variables used for NTR
//==============================================================================

extern FlagT gft_EnableNTR;
extern uint8 guc_TxNTRByte;
extern uint8 guc_RxNTRByte;
extern FlagT gft_NTR_Rcvd;


extern FlagT gft_NTR_use_212_Clock_units;


extern int32 gl_NTR_Offset;
extern int32 gl_NTRSRC_residual;
extern int16 gs_correct;

//variables for NTR drift tracking.

extern int32 gl_stu_count_212clocks;
extern int32 gl_ntr_drift_metric;
extern int32 gl_ntr_drift_metric_0;
extern int16 gs_enable_ntr_drift_correction;
extern int32 gl_ntr_drift_correction_amount;



//==============================================================================
// variables used for ATM PMS-TC layer
//==============================================================================
extern AlphaeusConfig_t gt_AlphaeusConfig;

//==============================================================================
// G997 related variables
//==============================================================================
extern int16 gs_G997_1sec_Task_Done_Flag;
extern int16 gs_100msecIntervalCount;

extern G997_NE_AtmPerf_HEC_t                    gt_g997_AtmPerf_HEC_Running_NE;
extern G997_NE_Curr_Prev_HEC_t                  gt_g997_AtmPerf_HEC_Curr_Prev_TR1_NE;
extern G997_FE_AtmPerf_HEC_t                    gt_g997_AtmPerf_HEC_Running_FE;
extern G997_FE_Curr_Prev_HEC_t                  gt_g997_AtmPerf_HEC_Curr_Prev_TR1_FE;
extern G997_NE_AtmPerf_CD_t                             gt_g997_AtmPerf_CD_Running_NE;
extern G997_NE_Curr_Prev_CD_t                   gt_g997_AtmPerf_CD_Curr_Prev_TR1_NE;
extern G997_FE_AtmPerf_CD_t                             gt_g997_AtmPerf_CD_Running_FE;
extern G997_FE_Curr_Prev_CD_t                   gt_g997_AtmPerf_CD_Curr_Prev_TR1_FE;
extern G997_NE_AtmPerf_CU_t                             gt_g997_AtmPerf_CU_Running_NE;
extern G997_NE_Curr_Prev_CU_t                   gt_g997_AtmPerf_CU_Curr_Prev_TR1_NE;
extern G997_FE_AtmPerf_CU_t                             gt_g997_AtmPerf_CU_Running_FE;
extern G997_FE_Curr_Prev_CU_t                   gt_g997_AtmPerf_CU_Curr_Prev_TR1_FE;
extern G997_NE_AtmPerf_IBE_t                    gt_g997_AtmPerf_IBE_Running_NE;
extern G997_NE_Curr_Prev_IBE_t                  gt_g997_AtmPerf_IBE_Curr_Prev_TR1_NE;
extern G997_FE_AtmPerf_IBE_t                    gt_g997_AtmPerf_IBE_Running_FE;
extern G997_FE_Curr_Prev_IBE_t                  gt_g997_AtmPerf_IBE_Curr_Prev_TR1_FE;
extern G997_NE_AtmPerf_ICELL_t                  gt_g997_AtmPerf_ICELL_Running_NE;
extern G997_NE_AtmPerf_UCELL_t                  gt_g997_AtmPerf_UCELL_Running_NE;
extern G997_AtmPerf_t                                   gt_g997_AtmPerf;

extern uint8 guc_LOSDefectType;
extern uint32 gul_NeSefDefectCounter;
extern uint32 gul_FeSefDefectCounter;
//XDSLRTFW-956 : ENH_DS_ALL_ALL_SESx_ESx_LOMx
//G997 Section 7.1.1
extern uint16                                                   gsa_g997_Failure_Flag_NE[2];    //Hooked to PLAM CMV 0
extern uint16                                                   gs_g997_Failure_Flag_FE;        //Hooked to PLAM CMV 1

extern uint16 gsa_g997_Failure_Flag_NE_latched[2];
//XDSLRTFW-956 : ENH_DS_ALL_ALL_SESx_ESx_LOMx
extern uint16 gs_g997_Failure_Flag_FE_latched;

extern G997_LineFailure_t                               gt_g997_FailureState_NE;        //Holds the state of failures described
                                                                                                                                        //in PLAM CMV 0
extern G997_LineFailure_t                               gt_g997_FailureState_FE;        //Holds the state of failures described
                                                                                                                                        //in PLAM CMV 1
extern G997_AtmFailure_t                                gt_g997_AtmFailure_NE;
extern G997_AtmFailure_t                                gt_g997_AtmFailure_FE;


extern  G997_NE_Curr_Prev_ChMonCRC_t    gt_g997_ChPerf_CRC_TR1_Curr_Prev_NE;
extern  G997_NE_ChMonCRC_t                              gt_g997_ChPerf_CRC_Running_NE;
extern  G997_FE_Curr_Prev_ChMonCRC_t    gt_g997_ChPerf_CRC_TR1_Curr_Prev_FE;
extern  G997_FE_ChMonCRC_t                              gt_g997_ChPerf_CRC_Running_FE;
extern  G997_NE_Curr_Prev_ChMonFEC_t    gt_g997_ChPerf_FEC_TR1_Curr_Prev_NE;
extern  G997_NE_ChMonFEC_t                              gt_g997_ChPerf_FEC_Running_NE;
extern  G997_FE_Curr_Prev_ChMonFEC_t    gt_g997_ChPerf_FEC_TR1_Curr_Prev_FE;
extern  G997_FE_ChMonFEC_t                              gt_g997_ChPerf_FEC_Running_FE;
extern  G997_NE_LinePerf_t                              gt_g997_LinePerf_Sec_NE;
extern  G997_FE_LinePerf_t                              gt_g997_LinePerf_Sec_FE;
extern  G997_NE_Curr_Prev_LinePerf_t    gt_g997_LinePerf_Current_Previous_TR1_NE;
extern  G997_NE_LinePerf_t                              gt_g997_LinePerf_Running_NE;
extern  G997_FE_Curr_Prev_LinePerf_t    gt_g997_LinePerf_Current_Previous_TR1_FE;
extern  G997_FE_LinePerf_t                              gt_g997_LinePerf_Running_FE;
extern  G997_Curr_Prev_LineInitPerf_t   gt_g997_LineInitPerf_Current_Previous_TR1;
extern  G997_LineInitPerf_t                             gt_g997_LineInitPerf_Running;
extern  G997_LinePerfThreshold_t                gt_g997_LinePerfThresholdControl;
extern  G997_LinePerf_help_t                    gt_g997_LinePerf_help;
extern  G997_LinePerf_sec_t                             gt_g997_LinePerf_sec_fail;
extern  G997_LinePerf_sec_t                             gt_g997_LinePerf_Prev_sec;

extern uint16 gusa_NonInhibit_CRC_Cntr_NE[NUM_DATA_PATHS];
extern uint16 gusa_NonInhibit_FEC_Cntr_NE[NUM_DATA_PATHS];

extern uint16 gusa_DeltaCRCsecp_NormFactor[NUM_DATA_PATHS];

// Variables to store the last-10-second history of SES and ES counters
extern uint16 gs_SES_Delay_Buf;
extern uint16 gs_ES_Delay_Buf;
extern FlagT gft_USx_Disable ; //XDSLRTFW-2040
//XDSLRTFW-956 : ENH_DS_ALL_ALL_SESx_ESx_LOMx
extern ReInit_Thresholds_t   gt_ReInit_Threshold;

// Intermediate counters to implement counters inhibited by UAS and SES,  such as CRC, FEC counters
// These counters will be incremented freely by the hardware but will be read and reset every second.
extern G997_NE_ChMonCRC_t gt_CRC_Curr_Reading;
extern G997_NE_ChMonCRC_t gt_CRC_Last_10_Sec;
extern uint32 gul_FEC_Curr_Reading[NUM_DATA_PATHS];
extern uint32 gul_FEC_Last_10_Sec[NUM_DATA_PATHS];
extern uint32 gul_FEC_Uncorr_Curr_Reading[NUM_DATA_PATHS];
extern uint32 gul_FEC_Uncorr_Last_10_Sec[NUM_DATA_PATHS];
extern uint32 gul_RS_CW_Curr_Reading[NUM_DATA_PATHS];
extern uint32 gul_RS_CW_Last_10_Sec[NUM_DATA_PATHS];
extern uint32 gul_FECS_Curr_Reading;
extern uint32 gul_FECS_Last_10_Sec;
extern uint8 guc_EnableInhibition;

extern FlagT gft_changed_from_unavail_to_avail;
extern FlagT gft_changed_from_avail_to_unavail;

// G997 control structure
extern G997_Cntrl_t gt_G997_Cntrl;

//Debug
extern uint16   gs_DefectTesting;                       //Debug variable to test Line/ ATM Failures
extern int16    gs_DefectCount;                         //Debug variable - number of defects faked.


//G997 DS/US Attenuation, Margin, etc. - Section 7.5.1.4-17 of the G997 Spec.
extern G997_SignalAndMarginParams_t gt_LineStatusDS;
extern G997_SignalAndMarginParams_t gt_LineStatusUS;
extern int16 gs_SnrMarginLomThresh;

//G997 Alarm Related Variables
extern G997_TR1AlarmIndicators_t gt_G997_TR1AlarmIndicators;
extern G997_MONI_TR1AlarmEnable_t gt_G997_MONI_TR1AlarmEnable;

//XDSLRTFW-1056 Feature_US_VDSL2_ALL_UsReTx_RxOvhdTestMgmt(START_END)
extern G997_ReTx_MgmtCnt_t gt_g997_ReTx_FE_MgmtCnt;

//XDSLRTFW-1193 Feature_US_VDSL2_ALL_UsReTx_CMV(START_END)
extern ConfigVar_USReTx_t gt_UsReTx_ConfigVar;

//XDSLRTFW-1422(START_END)
extern UsReTxDelay_DTU_t gt_UsReTx_DelayDTUs;

extern FlagT gft_Compute_delta;


//==============================================================================
// Bitswap related variables
//==============================================================================
extern FlagT gft_EnableTxBitSwap;            // TRUE means enabling TX bit swap feature
extern FlagT gft_EnableRxBitSwap;            // TRUE means enabling RX bit swap feature
extern FlagT gft_TxBitSwapFlag;              // TRUE means requesting TX bit swap
extern FlagT gft_RxBitSwapFlag;              // TRUE means requesting RX bit swap
extern uint16 gus_RxBitSwapStatus;                       // RX bitswap operation status

extern int32 gl_RxBitSwapDecisionErrorCode;
extern int16 gs_BitSwapErrorCode;            // Bitswap error codes.
extern uint8 guc_BitSwapReqIntrepretState;   // State of background BSR interpretation

extern int16 gs_REDUCE_LP_DELTA_BITSWAP;         // the maximum number of bits to cut in each bit-swap
extern int16 gs_BITSWAP_TRIGGER_DELTA;           // the snr margin drop threshold for triggering bit-swap
extern int16 gs_BITWAP_MIN_SNR_MARGIN;           // the minmum snr margin for triggering bit-swap
extern int16 gs_NumOfBitSwapTones;                       // the number of tones changed in a bit-swap

extern BitSwapInfoStruc_t gt_TxBitSwapInfo;  // structure for TX bit swap information
extern BitSwapInfoStruc_t gt_RxBitSwapInfo;  // structure for TX bit swap information

//XDSLRTFW-3807 Improve bitswap algorithm in VRX518 code(Start)
extern int16 gs_BsDecisionExtraThreshold;
extern uint32 gula_BSFailStat[12];           // BS Pass/Fail state statistics
extern FlagT gft_RmsFgOverShoot;
extern int16 gs_MaxFgReductionAfterRmsFgOverShoot;
//XDSLRTFW-3807 Improve bitswap algorithm in VRX518 code(End)
extern uint32 gula_SRAFailStat[10];         // SRA Pass/Fail state statistics

extern TxVOCMsgStruc_t gt_TxVocMsgBSR;           // structure containing TX BSR message
extern TxVOCMsgStruc_t gt_TxVocMsgBSA;           // structure containing TX BSA message
extern RxVOCMsgStruc_t gt_RxVocMsgBSR;       // structure containing RX BSR message
extern RxVOCMsgStruc_t gt_RxVocMsgBSA;           // structure containing RX BSA message

extern FlagT  gft_SendVocBSRMsg_Flag;        // Indicates if a VOC BSR message should be sent
extern FlagT  gft_SendVocBSAMsg_Flag;        // Indicates if a VOC BSA message should be sent

extern uint8  guc_VocTxMaxRetries;               // Maximum number of retries for a VOC message

extern uint8 guc_TxBFICount;                 // TX Bitswap Frame Interval (BFI) count [0:255]
extern uint8 guc_RxBFICount;                 // RX Bitswap Frame Interval (BFI) count [0:255]
extern uint8 guc_TxBFISubCount;              // TX BFI subcount [0:15]
extern uint8 guc_RxBFISubCount;              // RX BFI subcount [0:15]

extern uint8 guc_BitSwapState;

//moved to rate 0 and rate 1 respectively
//extern uint32 gul_TxLineRate;                         // Tx Line Rate
//extern uint32 gul_RxLineRate;                         // Rx Line Rate

//==============================================================================
//GHS variables
//==============================================================================
extern int16 gs_LoadGhsToneFlag;
extern FlagT gft_GotoFailStateOnTimeOut_FromHandshake;
extern int16 gs_GhsStateTrailEnableFlag;                //flag (if 1) to enable save the GHS state trail
extern uint8 guc_ClrControl;
extern uint8 guc_SI_SPar1_Optn0;
extern uint8 guc_SI_SPar3_Optn0;
extern uint8 guc_SI_SPar4_Optn0;
//XDSLRTFW-456 : CORRECT_ADSL_OCTETS_IN_VDSL_GHS_MSG
extern uint8 guc_SI_SPar5_Optn0;

//Variables define actual operation mode status
extern uint32 gul_OperationModeStatus_VDSL2;

//Variable define capable operation modes
extern uint32 gul_OperationModeCapable_VDSL2;

//Variable define capabilities in G.Fast
extern uint32 gul_OperationModeCapable_G_Fast;

//Variable defines actual operation mode: i.e., VDSL1 or VDSL2
extern uint16 gus_ModemOperationMode_Status;


//T1.413 variables
extern int16 gs_DetectCACT_State;
extern int16 gs_DetectCACT_AccumCount;
extern int32 gul_T1413_ACT_TimeOUT_Cnt;
//XDSLRTFW-2373
extern uint8 guc_T1413DetectCnt;
extern int16 gs_C_ACT_flag;
extern int16 gs_RxDetectCnt;

extern uint8 guc_AccumState;
extern uint8 guc_PgaToneState;



// VDSL_BONDING
//------------------
#ifdef VDSL_BONDING
// flag to enable switching to single port mode if CO does not bond.
extern FlagT gft_SinglePort_if_CO_notBonding;

// data structures to provide control and status of
// for GHs bonding negotiation
extern Bonding_DiscAggr_Control_t       gt_Bonding_DiscAggr_Control;
extern Bonding_DiscAggr_Status_t        gt_Bonding_DiscAggr_Status;
extern Bonding_Continue_t               gt_Bonding_Continue;
extern uint16 gus_Bonding_PME_ID;       // XDSLRTFW-2382 (Start_End)
extern int16 gs_DsMinDelayDeltaForBonding; // Delta between DS max delay and DS min delay in msec
#endif
//==============================================================================
/* The following variables are used to coordinate access to the ARC-to-ME Mailbox.              */
/* The flags guc_MPMsgResp/AutoReq, CodeSwapMsgReq, are set by the      */
/* messaging, Code Swap, respectively.  The ProcessTxMailbox                            */
/* function monitors these flags and coordinates the access to the ARC-to-ME Mailbox.   */
//==============================================================================

extern uint8    guc_MPMsgRespReq;
extern uint8    guc_MPMsgAutoReq;
extern uint8    guc_CodeSwapMsgReq;

// used by codeswap build
#include "codeswap.h"

#ifndef STANDALONE_FRAMING_TEST
//#include "LinkStart.h"
#endif

extern int32 gl_ImageSize;
extern SwapRequest_t gt_SwapRequestQueue[MAX_SWAP_REQUESTS];
extern SwapControl_t gt_SwapControl;

extern uint16 gs_MaxSwapDuration;

extern uint8 guc_RequestedPage;
extern uint8 guc_PrimPageHandle;
extern int16 gs_CodeSwapSection;
extern uint8 guc_InitialPage;
extern uint8 guc_RxSwapActivity;
extern uint8 guc_TxSwapActivity;

//==============================================================================
// PARR variables
//==============================================================================

extern int16 gs_parr_threshold_dBm_8p8;
extern TxParrConfig_t gt_TxParrConfig;
extern FlagT gft_TxParrEnabled;
extern int16 gs_TxParr_ScalarA;

extern int16 gsa_parr_peaks[5];


extern int16 gsa_parr_pvec[];
extern ParrTones_t gt_parr_pvec_tones;

//==============================================================================
// IFFT scale, txvargain, TX afe gain related variables
//==============================================================================

extern FlagT gft_EnableTxPSDCtrl;

extern int16 gs_TxIfftGain_dB;
extern int16 gs_avg_ifft_in_dB;
extern int16 gs_TxVarGainIn_dB;
extern int16 gs_TxVarGain_dB;
extern int16 gs_TxVarGain_Inadequacy_dB;
extern int16 gs_tx_afe_gain_setting_dB;
extern int16 gs_tx_afe_trim1_gain_dB;
extern int16 gs_max_fc_MHz;
extern int16 gs_tx_afe_gain_inadequacy_dB;
extern int16 gs_tx_iir_atten_dB;
extern FlagT gft_Allow_20p5_dBm_8b;
extern FlagT gft_Allow_17p5_dBm_8a;
extern int16 gs_frame_rate_is_8khz;
extern int16 gs_tx_power_dBm_line;
extern uint32 gul_ifft_scales_cntl_word;
extern uint32 gul_tx_vargain_cntl_word;
extern uint32 gul_35bLiteConfig;
extern uint16 gus_tx_afe_gain_cntl_word;
extern int16 gs_high_tone_tx_w_guard;
extern int16 gs_high_tone_rx_w_guard;
extern int16 gs_perc_gd_rx_AnlgFCorner;
extern int16 gs_perc_gd_tx_AnlgFCorner;
extern int16 gs_high_tone_tx;
extern int16 gs_high_tone_rx;
extern uint16 gs_N_u_tx_AnlgFCorner_cntl_word;
extern uint16 gs_N_u_rx_AnlgFCorner_cntl_word;
extern uint16 gs_N_u_rx_AnlgFCorner_cntl_word_save;
extern int16 gs_tx_psd_offset_dB_dbg;

extern int16 gs_TxVarGain_margin;
extern int16 gs_MAX_PERMISSIBLE_TXVGN_OUT_DB;
extern FlagT gft_EnableIfftScalesFix;
extern FlagT gft_EnableTxVarGainFix;
extern FlagT gft_EnableFixedPofiCorner;
extern FlagT gft_EnableFixedPofiCornerOverrule;
extern FlagT gft_EnableRxAnalogFilterCornerFix;

// Power Saving Flags
extern FlagT gft_PowerDownON;

// Lookup table for cosine values
extern int16 gsa_ShortCosTable[52];

//=============================================================
//Variables used in Diagnostic Mode
//=============================================================
extern uint8 guca_SNRBuf_FE[512];               //the buffer storing far end SNR per subcarrier group
extern uint8 guca_SNRBuf_NE[512];               //the buffer storing near end SNR per subcarrier group
extern uint8 guca_QLNBuf_FE[512];               //the buffer storing far end Quiet Line Noise
extern uint16 gusa_HlogBuf_FE[512];             //the buffer storing far end Hlog
extern uint16 gusa_HlinBuf_FE[3*512];   //the buffer storing far end Hlin
extern uint16 gusa_HlinBuf_NE[3*512];   //the buffer storing near end Hlin

extern uint8 *gpuca_SNRBuf_FE;                  //pointer to the buffer storing far end SNR per subcarrier group
extern uint8 *gpuca_QLNBuf_FE;                  //pointer to the buffer storing far end Quiet Line Noise
extern uint16 *gpusa_HlogBuf_FE;                //pointer to the buffer storing far end Hlog
extern uint16 *gpusa_HlinBuf_FE;                //pointer to the buffer storing far end Hlin
extern uint16 *gpusa_HlinBuf_NE;                //pointer to the buffer storing far end Hlin

//variables used for sending the SOC messages
extern uint16 gus_TxSocMsgBitBuf;               //word which hold the current SOC message bits to be sent
extern int16 gs_TxSocMsgBitPosition;    //bit position of the bit to be sent in gus_TxSocMsgBitBuf
extern int16 gs_NumOfTxSocBitRepeat;    //number of times when the same bit is repeatly sent
extern uint16 gus_NumSymbolsPerBit;
extern uint16 gus_NumSymbolsPerBitThresh;
extern FlagT gft_SocRepeatFlag;                         //flag, if TRUE, indicates resending the prevous message byte
extern FlagT gft_DisableTxDiagModulation;       //If TRUE, do not use the diag. mode modulation method
                                                                                        //but the regular initialization modulation method

//variable used for bit synchronization
extern int16 gs_BitSearchSymCount;
extern int16 gs_NumOfSymbolsForBitSearchAccum;
extern int16 gs_Log2NumOfSymbolsForBitSearchAccum;
extern int16 gs_BitSynchInterationCnt;
extern int32 gl_RxBitStartSym;

//variables used in for the byte synchronization
extern int16 gs_SegueSymCntPerBit;
extern int16 gs_SymCntPerBit;
extern int16 gs_RxNumSocBitPerByte;
extern uint8 guc_RxSocByte;

//misc variables
extern FlagT gft_TxStateInitFlag;
extern FlagT gft_RxMsgLdFlag;
extern FlagT gft_CodeSwapDoneFlag;

extern int32 gl_MedleyStateLength_Diag;
extern FlagT gft_DisableHlinCalc;

//XDSLRTFW-439: Feature_All_DS_All_All_SupportDsTxRefVirtualNoise (Start)
// virtual noise status flag variable
extern FlagT gft_DSVirtualNoiseStatus;
extern FlagT gft_USVirtualNoiseStatus;
extern FlagT gft_VirtualNoiseStatus_save;
extern FlagT gft_OldVNPsdFormat;
//XDSLRTFW-439: Feature_All_DS_All_All_SupportDsTxRefVirtualNoise (End)

//The following structures have been defined above and used in the normal modem operation
//we will reuse them in the diagnostic mode
//gt_AttenSnrMPerRxBand_FE      //structure storing far end LATN-pb, SATN-pb, SNRM-pb
//gt_LineStatusUS.ul_AttainableDataRate         //for ATTNDR
//gt_LineStatusUS.s_ActualAggregateXmtPwr       //For ACTATP

//These two variables are used through showtime so they cannot be placed
//in interlever memory
extern int32 gl_RxStateTimeOutCountLoopDiagMode;
extern int32 gl_TxStateTimeOutCountLoopDiagMode;

extern int16 gs_NumOfTxSocBits;                 //number of SOC message bits to be sent
extern FlagT gft_RunTxStateFuncFlag;    //flag, if TRUE, indicates always run the TX state function
extern FlagT gft_RxSocMsgDemodFlag;             //flag, if TRUE, enable demodulating of the RX SOC message
extern FlagT gft_TxSocMsgModFlag;

extern int16 gs_TxSyncToneType;
extern int16 gs_RxSyncToneType;
extern int16 gs_CurrRxSyncType;                         //RX synch type of current synch frame
extern int16 gs_NumTxSynchFlags;
extern int16 gs_NumRxSynchFlags;
extern FlagT gft_RxInvSynch;



#ifndef HW_TRT
extern int16 gs_TxTRT_write_band;
extern int16 gs_TxTRT_write_offset;

extern int16 gs_RxTRT_write_band;
extern int16 gs_RxTRT_write_offset;

extern int16 gs_TxTRT_read_band;
extern int16 gs_TxTRT_read_offset;

extern int16 gs_RxTRT_read_band;
extern int16 gs_RxTRT_read_offset;
extern int16 gs_TRT_readstate;
extern FlagT gft_use_framebuffer;
#endif //#ifndef HW_TRT

#ifdef DISTRIBUTE_TX_RX_PROCESS
extern FlagT gft_DistributeTxRxProcess;
extern FlagT gft_DistributeTxRxProcess_Save;
extern int32 gl_RxBSCount;
extern uint32 gul_RxTCStartTime;
extern uint32 gul_CCR1_Reg_BS;
extern uint32 gul_CCR1_Reg_QtDone;
#endif // DISTRIBUTE_TX_RX_PROCESS

extern int16 gsa_RxBitsInFifo[NUM_DATA_PATHS];
extern int16 gsa_TxBitsInFifo[NUM_DATA_PATHS];

extern int16 gs_rxnumfailures;
extern int16 gs_txnumfailures;
extern int16 gs_dbg_TxPmdCnt_TxFifoErr;
extern int16 gs_dbg_RxPmdCnt_RxFifoErr;
extern int32 gl_dbg_TxSymCnt_TxFifoErr;
extern int32 gl_dbg_RxSymCnt_RxFifoErr;

extern uint16 gus_ForceLPR;
extern uint16 gus_SetLPR;  // Tied to CMV DSL 5


extern FlagT gft_ADCOverflowed;


//
//
// DO NOT PUT NORMAL VARIABLES BEYOND THIS LINE
//
//

//==============================================================================
// DEBUG variables
// - can be used in all platforms for debug purpose
// - may be included for the target HW build
//==============================================================================

extern int16 *gpsa_LpbkBuf; // pointer to loopback buffer (used in showtime loopback mode)



extern uint32 gul_STR_OverflowData;  // strymon overflow debugging
extern uint32 gul_STR_OverflowMask;  // strymon overflow debugging
extern uint32 gul_STR_OverflowCount; // strymon overflow debugging
extern uint16 gus_ZEP_RxPMSNotDone, gus_ZEP_TxPMSNotDone;

#ifdef ENABLE_VR9_HW_ERR_CNT
extern FlagT gft_EnableCoreErrorCheck;
extern FlagT gft_IncludeGhsInTrain;

extern uint16 gsa_StrymonOverflowCnt_train[17];
extern uint16 gsa_StrymonOverflowCnt_medley[17];
extern uint16 gsa_StrymonOverflowCnt[17];

extern uint32 gul_FT_OverflowData;
extern uint16 gusa_FTOverflowCnt_train[2];
extern uint16 gusa_FTOverflowCnt_medley[2];
extern uint16 gusa_FTOverflowCnt[2];

extern uint32 gul_TXQT_ErrorData;
extern uint16 gsa_TxQTErrorCnt_train[4];        //TX QT error counts
extern uint16 gsa_TxQTErrorCnt_medley[4];
extern uint16 gsa_TxQTErrorCnt[4];

extern uint32 gul_RXQT_ErrorData;
extern uint16 gsa_RxQTErrorCnt_train[4];        //RX QT error counts
extern uint16 gsa_RxQTErrorCnt_medley[4];
extern uint16 gsa_RxQTErrorCnt[4];

#endif //#ifdef ENABLE_VR9_HW_ERR_CNT

extern FlagT guc_strymonReset;
extern FlagT gft_StrymonLpbkMode;         //configure strymon lookback mode

#ifdef LOG_FA_DEBUG_INFO

//Discovery phase frame alignment information
extern int16 gs_ToneSelect_FA_ChDisc;
extern int16 gs_NumCluster_FA_ChDisc;
extern int16 gs_FrameAlignIteration_ChDisc;
extern int16 gs_CumulativeAlignmentOffset_ChDisc;
extern int16 gsa_FrameAlignOffsets_ChDisc[MAX_NUM_FRAME_ALIGN_ITERATIONS];

//Training state frame alignment information
extern int16 gs_ToneSelect_FA_Train;
extern int16 gs_NumCluster_FA_Train;
extern int16 gs_FrameAlignIteration_Train;
extern int16 gs_CumulativeAlignmentOffset_Train;
extern int16 gsa_FrameAlignOffsets_Train[MAX_NUM_FRAME_ALIGN_ITERATIONS];


//Medley state frame alignment information
extern int16 gs_CumulativeAlignmentOffset_Medley;

//Shared by all the states
extern int16 gsa_FA_debug_buf[6*MAX_NUM_FRAME_ALIGN_ITERATIONS];
extern int16 gsa_FA_debug_buf_ChDisc[6*MAX_NUM_FRAME_ALIGN_ITERATIONS];
extern int16 gsa_FA_debug_buf_Train[6*MAX_NUM_FRAME_ALIGN_ITERATIONS];
extern int16 gsa_FA_debug_buf_Periodic2[6*MAX_NUM_FRAME_ALIGN_ITERATIONS];
extern int16 gsa_FrameAlignOffsets[MAX_NUM_FRAME_ALIGN_ITERATIONS];
#endif // LOG_FA_DEBUG_INFO

extern int16 gsa_VecSSyncAlignIn[15];
extern int16 gsa_VecSSyncAlignOut[15];
extern uint16 gs_VecSSyncAlignIdx;
extern int16 gsa_CeilingValues[NUM_CEILING_VALUES];
extern int32 *gpsa_OPVectorDbgBuffer32;

#ifdef LOG_SNR_FDQ_UPDATE
extern int16 gs_LogIndex;
extern int16 gs_ToneSelect;
extern int16 gsa_SnrLog[SNR_FDQ_UPDATE_LOG_LENGTH];
extern int16 gsa_FdqMantissaLog[2*SNR_FDQ_UPDATE_LOG_LENGTH];
extern int8 gca_FdqExponentLog[SNR_FDQ_UPDATE_LOG_LENGTH];
#endif // LOG_SNR_FDQ_UPDATE

// !! DEBUGGING
extern int16 gs_pilotbias;
extern int16 gs_ISDN_DISTURBER;
extern int32 gl_gain_lin;
extern int16 gs_HybridGain;

// save selected tone index for message decoding during different phases
extern int16 gs_ToneSelect_Msg_NoEcho;
extern int16 gs_NumCluster_Msg_NoEcho;
extern int16 gs_ToneSelect_Msg_ChDisc;
extern int16 gs_NumCluster_Msg_ChDisc;
extern int16 gs_ToneSelect_Msg_Train;
extern int16 gs_NumCluster_Msg_Train;
extern int16 gs_ToneSelect_Msg_AnaExc;
extern int16 gs_NumCluster_Msg_AnaExc;

// save debug info for pilot tone selection
extern int16 gs_PilotToneIdx_Initial;
extern int16 gs_PilotToneIdx_ChDisc;
extern int16 gs_PilotToneIdx_Train;
extern int16 gs_PilotToneIdx_Medley;

extern int16 gsa_SnrOfPilotTone_Initial[5]; // 5 for SNR around pilot tone
extern int16 gsa_SnrOfPilotTone_ChDisc[MAX_NUM_PILOT_TONES][5];
extern int16 gsa_SnrOfPilotTone_Train[MAX_NUM_PILOT_TONES][5];
extern int16 gsa_SnrOfPilotTone_Medley[MAX_NUM_PILOT_TONES][5];

extern int32 gla_SnrAccuBuf[((RX_MAX_NUM_TONES>>3)<<1)];
extern RT_DebugTiming_t *gpt_DebugTiming;
extern RT_DebugTiming_t gt_DebugTiming;

/* XDSLRTFW-2858 */
extern REIN_Test_Config_t  gt_REIN_Test_Config;
extern REIN_Test_Status_t  gt_REIN_Test_Status;
extern int16 gs_RxVarGain_Showtime;
extern int16 gs_CpeRxHalfRoundTripDelays_ForcedInFraming;
/* XDSLRTFW-2858 */

//===================================================
//Interop debug variables
//===================================================

extern int16 gs_DetectDelay;
extern int32 gl_ORTrainDelay;
extern int16 gs_ORPTrain1Delay;
extern int16 gs_dbgLogSocMsg;              // Default not to log SOC message
extern int16 gs_dbgLogSocMsgPause;         // Used to pause logging during AutoRepeat messages

extern int16 gs_DbgRecnfgCpCsBeta;
extern int16 gs_DbgTxBetaLength;
extern int16 gs_DbgTxCPLength;
extern int16 gs_DbgTxCSLength;
extern int16 gs_DbgRxBetaLength;
extern int16 gs_DbgRxCPLength;
extern int16 gs_DbgRxCSLength;
extern int16 gs_DbgRxWindowLength;
extern int16 gs_DbgTimingAdvanceTx;
extern int16 gs_DbgTimingAdvanceOffset;     // Offset to Timing Advance calculation used for test purposes
extern int16 gs_DbgTargetTimingAdvance;    // Initial target timing advance used for test


extern FlagT gft_dbg_DisableMedleyPRBS;
extern FlagT gft_dbg_ShowSnr;
extern int16 gs_dbg_ToneOffset;

extern int16 gs_DbgFramingDisableFlag;

extern FlagT gft_dbgDisableLoadSrcCoefPostGhs;
extern FlagT gft_DisableFailState;              //if set to 1, disallowe the modem go to fail state

extern int16 gs_dbgRxPilotThreshold;            // Threshold to compare recieved pilot tone
extern uint32 gul_dbgMiscControl;                       // 0x1                  -       RX: Disable PLL if recieved pilot tone is less than a configurable threshold
                                                                                        // 0x2                  -       Follow Version 4.5 of VDSL2 Draft Standard


extern int16 gs_dbgMaxOHR;


extern int16 gus_dbgMaxSEQp; //XDSLRTFW-3226 (Start_End)


extern uint8 guc_dbgFeModemLog2IfftSize;        // To force a given size of far ends IFFT

extern FlagT gft_dbgSkipLastTwoOPSynchro;
extern int16 gs_dbgDelayRPSynchro6;

//////////////////
// Handshake Hooks
//////////////////

// Handshake messaging
extern uint32 gul_dbgGHSControl;        // 0x1          - Ignore Mode Select Message
                                                                        // 0x2          - Disable T1 MCM Vdsl1 in SI Spar1
                                                                        // 0x4          - Support STM in SI Npar2 for VDSL1
                                                                        // 0x8          - Support Init CE Length in SI Spar2 for VDSL1

extern FlagT gft_CL_CLR_Comparison;
extern FlagT gft_GhsDbg;
extern int16 gs_NumPhaseReversals;
extern int16 gs_RxSubStateCnt1;
extern uint16 gusa_PreviousPhase[];
extern uint16 gusa_CurrentPhase[];
extern int16 gs_RxSubStateCnt2;
extern int16 gs_GHS_IdleStuckCnt;
extern int16 gs_GHS_NumPhaseReversalsDetect;
#if (defined VDSL_CO_60 && !defined IFX_REV2L) // For now, only for Rev2M
extern FlagT gft_EnableGhsTonesShaping;
#endif
extern FlagT gft_CL_CLR_Comparison;
extern FlagT gft_FW_Initiate_Retrain;
//////////////////
// Training Hooks
//////////////////

// Signal Detection Thresholds
extern int16 gs_dbg_NUM_NONSILENCE_SYMBOLS_THRESH;

// State transition timing
extern int16 gs_DbgRPSynchro1TransitionDelay;
extern int16 gs_DbgOPSynchro1TransitionDelay;
extern int16 gs_dbgDelayTxSynchro2;
extern int16 gs_dbgDelayRMsg2;
extern int16 gs_dbgRPTrain1Delay;
extern int16 gs_dbgROPTrain1Delay;

// SoC Messaging
extern uint32 gul_dbgSocMsgControl, gul_dbgSocMsgControl2;
extern int16 gs_dbgLimitUsMaxNomPsd;

// PRBS
extern uint8 guc_dbgMedleyTxPrbsSkipBits;
extern uint8 guc_dbgMedleyRxPrbsSkipBits;

// Bitloading and B/G/T Message Control
extern uint8 guc_dbgForceEvenNcLoaded;
extern uint32 gul_dbg_DILV_MEM_SIZE;
extern int16 gs_dbgTxBgMsgInsertZeros, gs_dbgRxBgMsgIgnoreZeros, gus_dbgTxBgMsgAppendBi0Gi1;

// Showtime Transition Timing
extern int16 gs_dbgAdvanceTxSynchro2, gs_dbgAdvanceEnableXTC, gs_dbgDelayTxShowTransition, gs_dbgDelayRxShowTransition;

//////////////////
// Showtime Hooks
//////////////////

// Showtime Data Pump
extern uint32 gul_dbgShowtimeControl;           // 0x1          -       TX: Register Start Tx FC
                                                                                        // 0x2          -       TX: Register Start Tx XTC
                                                                                        // 0x4          -       TX: Split Tx processing to isolate CRC byte
                                                                                        // 0x8          -       TX: Bit Reverse CRC and do not pass it through scrambler
                                                                                        // 0x10         -       RX: Fix CRC byte in the CWRAM to get around non-compliant far-end's
                                                                                        //                              that do not scramble the CRC
                                                                                        // 0x20         -       RX: Fix data byte in the BCR when CRC is not accessible in CWRAM due to PMS
                                                                                        //                              PMD frames being aligned to get around non-compliant far-end's that do not scramble the CRC

extern uint8 guc_dbgIncreaseFifoLength, guc_dbg_ZEP_MAX_RX_FC_RUN_CNT;
extern uint16 gus_dbgRecievedFcs;

// Globals to implelemt functionality provided by showtime Tx hooks
extern int16 gs_MuxFrameCount, gs_CodewordRateBufferSize, gs_PMDRateBufferSize, gs_AZRunCount, gsa_AZRunSize[4], gs_MuxFramePerOvhdSuperframe, gs_maxAZRunCount, gs_RxMuxFramePerOvhdSuperframe, gs_RxPmsPmdAlignedState;
// Globals to implelemt functionality provided by showtime Rx hooks
extern int16 gs_RxMuxFramePerOvhdSuperframe, gs_RxPmsPmdAlignedState;
extern uint16 gus_RxDtByteIdx, gus_RxCodewordsBuffered;
extern uint32 gul_dscrm;

//Keeps a count of the # of rogue HDLC octets
//Send a UTC on recieving threshold many rogue octets, -1 implies Disabled
extern int16 gs_dbgRogueHdlcOctets, gs_dbgRogueHdlcOctetThreshold;

extern FlagT gft_dbg_SkipTxSyncFrame; // debug feature to skip TX showtime sync frame
extern FlagT gft_dbg_SkipRxSyncFrame; // debug feature to skip RX showtime sync frame

//==============================================================================
// Sniffer Variables
//==============================================================================
extern uint32 gul_dbgSnifferControl;            // 0x1                  -       TX: Disable Transmitter
                                                                                        // 0x2                  -       Pre-pone GHS Codeswap
                                                                                        // 0x4                  -       Disable GHS state machine
                                                                                        // 0x8                  -       Disable GHS Timeout check
                                                                                        // 0x10                 -       Disable Training state machine
                                                                                        // 0x20                 -       RX: Enable Decision Directed Pilot
                                                                                        // 0x40                 -       RX: Enable Decision Directed Pilot
                                                                                        // 0x80                 -       RX: Bypass interpreting of recieved SoC message
                                                                                        // 0x80000000   -       Pause "gs_dbgSnifferPauseControl" symbols after Msg Detection
extern int16 gs_dbgSnifferMedleyTransitionControl/* 33- Co, 16 - Cpe */, gs_dbgSnifferRxToneOffsetControl;

// Pause Control
//extern uint8 guc_dbgSnifferMsgForPause;
//extern int16 gs_dbgSnifferWaitForPause;

// Log
extern uint8 guc_dbgSnifferLastSocMsgDetected;
extern int32 gl_dbgSnifferSynchroDetectedSymCnt, gl_dbgSnifferSocMsgDetectedSymCnt;

//==============================================================================
// DEBUG variables for simulation
// - used only for simulation platforms: COCOMO, ASIM, ARC
// - should be excluded for the target HW build
// - variables used for COCOMO and ASIM builds may be allocated to separate
//   memory space, which does not exist in real HW
//==============================================================================



#ifdef POLLING_CORE_INTERRUPTS
extern int16 gs_FDInterruptSource;
#endif

extern int16 gsa_ReverbSnrBuf[RX_MAX_NUM_TONES];

extern int16 gsa_MedleySnrBuf[RX_MAX_NUM_TONES];

extern int16 gsa_Periodic1SnrBuf[RX_MAX_NUM_TONES];
extern int16 gsa_DiscPsdBuf_EchoOff[RX_MAX_NUM_TONES];
extern int16 gsa_DiscPsdBuf_EchoOn[RX_MAX_NUM_TONES];
extern int16 gsa_RxHLog_PerTone[RX_MAX_NUM_TONES];
extern uint8 guca_QLN_PerTone[RX_MAX_NUM_TONES];
#ifdef DEBUG_TRACES
extern uint8 guca_offChipDebugBuff[RAW_DUMP_MAX_SDRAM_SIZE_BYTES];
#endif // #ifdef DEBUG_TRACES

//L2_Back_Channel
// XDSLRTFW-3492 (Start)
extern DSM_Stats_t gt_DsmStats;
extern uint16 gus_NumofSymbols_ERB_Computation;
extern uint16 gus_TotalNumofSymbols_ERB;
// XDSLRTFW-3492 (End)
extern MacFrameConfigure_t gt_MacFrameConfigure;

#ifdef SAVE_REVERB_FDQ
extern int16 gsa_ReverbFdqMantissa[2*RX_MAX_NUM_TONES];
extern uint8 guca_ReverbFdqExponent[RX_MAX_NUM_TONES];
#endif //SAVE_REVERB_FDQ

#ifdef SAVE_MEDLEY_FDQ
extern int16 gsa_MedleyFdqMantissa[2*RX_MAX_NUM_TONES];
extern uint8 guca_MedleyFdqExponent[RX_MAX_NUM_TONES];
extern int16 gsa_MedleyMfdqFFMantissa[2*MAX_MFDQ_TONES];
extern int16 gsa_MedleyMfdqFBMantissa[2*MAX_MFDQ_TONES];
extern uint8 guca_MedleyMfdqFBExponent[MAX_MFDQ_TONES];
#endif //SAVE_MEDLEY_FDQ


#if (defined(CAPTURE_AFE_TX_OUT) || defined(CAPTURE_AFE_RX_IN))
extern int16 gs_CoCpeFlag;      //0-> CO, 1->CPE
#endif

#ifdef CAPTURE_AFE_TX_OUT
extern int16 gs_CaptureAfeTxOutFlag;
extern int16 gs_TxAfeFrameCount;
extern int16 gs_TxPreAfeFrameCount;
extern FILE *fpAfeTx;
#endif //CAPTURE_AFE_TX_OUT

#ifdef CAPTURE_AFE_RX_IN
extern int16 gs_CaptureAfeRxInFlag;
extern int16 gs_RxAfeFrameCount;
extern int16 gs_RxPreAfeFrameCount;
extern FILE *fpAfeRx;
#endif //CAPTURE_AFE_RX_IN

//extern int16 gs_ncd_override_cnt[NUM_BEARER_CHANNELS];                // used to override the no. of NCD anomalies
//extern int16 gs_lom_override_cnt;                                                     // used to override the no. of LOM defect
//extern int16 gs_sef_override_cnt;                                                     // used to override the no. of SEF defect
//extern int16 gs_expected_sync_byte1;
//extern int16 gs_expected_sync_byte2;

//============== Variables used by the new Zephyr  ======================
extern uint32 gula_txILVBaseAddr[2];
extern uint32 gula_rxILVBaseAddr[2];
extern uint32 gul_RtxQBaseAddr;

extern uint32 gul_DTBLOOP_lastTxSize;

#ifdef CHECK_ILV_MEM_ERROR
extern int32 gl_IlvMemErr_Cnt;
#endif //CHECK_ILV_MEM_ERROR

//Data used for capture the scrambler input and output data
#ifdef ZEP_DEBUG_BLD

extern int16 gs_TxScamNumBytesPerSym;   //the estimated number of bytes per symbol to going to TX scrambler
extern int16 gs_CapturedTxScamSyms;             //the captured TX number of symbols
extern int16 gs_TxCapBufFullness;               //the number of bytes left in TX capture buffer
extern int16 gs_TxPreWRPTR;                             //the previous TX FIFO3 write pointer

extern int16 gs_RxScamNumBytesPerSym;   //the estimated number of bytes per symbol to going to RX scrambler
extern int16 gs_CapturedRxScamSyms;             //the captured RX number of symbols
extern int16 gs_RxCapBufFullness;               //the number of bytes left in RX capture buffer
extern int16 gs_RxPreWRPTR;                             //the previous RX FIFO3 write pointer

extern FlagT gft_TxFifo3Capture;                //TX FIFO3 capture flag: TRUE, FALSE or -1 (indicating the wrap around occurs)
extern FlagT gft_RxFifo3Capture;                //RX FIFO3 capture flag: TRUE, FALSE or -1 (indicating the wrap around occurs)


#endif //#ifdef ZEP_DEBUG_BLD

//number of latency used ... will be 1 for normal mode and 2 for ReTx of operation
extern uint8 guc_NumLantencyPath;

//---------------------------------------------------
// DSLMap cmv's
extern uint16 gus_ApiOptions;         //[DSL_OPTIONS]
extern uint16 gus_DSL_TC_Status;      //CMD_TC_StatusGet / DSL_TC_STATUS / DSL 14
extern uint16 gus_PpeClockControl;    //[DSL_PPE_CLOCK_CONTROL]

// XDSLRTFW-3565 (Start_End)
extern uint16 gus_PPEClockConfigure;
extern uint16 gus_PPEClock_Configured;

//---------------------------------------------------
// VR9 debug control variables
//---------------------------------------------------
extern int16 gs_CRI_DbgCntl;    //debug control variable for CRI
extern int16 gs_STR_DbgCntl;    //debug control variable for Strymon
extern uint8 guc_ftb_tx_qt;
extern uint8 guc_ftb_rx_qt;

extern FlagT gft_SkipTxQtStallCheck;
extern FlagT gft_SkipRxQtStallCheck;

//#ifdef VR9_ERASURE
extern FlagT gft_erasure_on;
extern int16 gs_wb_maxscore;
//#endif //VR9_ERASURE

extern uint16 gus_rmetric_scale;
extern uint32 gul_CntrTrellisTonePairs;
extern uint32 gul_MaxQtScore;
extern uint8 guc_msb;
//Erasure metrics to calculate the threshold to discard frames for DD
extern FlagT gft_frame_with_lowmetric, gft_Calculate_EdMetric_PilotPwr_Threshold; //XDSLRTFW-2481
extern FlagT gft_DisableDiscardFrame;
extern uint8 guc_metric_discard_threshold;
extern uint16 gus_metric_eval_cnt, gus_metric_eval_period;
extern uint8 guc_max_metric;
extern uint8 guc_min_metric;
extern uint32 gul_metric_value;
extern uint32 gul_num_frame_lowmetric;
extern uint16 gus_lowmetric_discard_cnt, gus_lowmetric_discard_max;
extern uint16 gus_lowmetric_detect_cnt, gus_lowmetric_detect_period;
extern uint16 gus_LowPowerSetting; //Low power setting in GPIO15 in dying gasp


#if defined (VR9_BRINGUP_DBG) || defined (BIT_PATTERN_TEST)
extern FlagT gft_EnableGetRxTime;
extern FlagT gft_TriggerGetRxTime;
extern int16 *gpsa_RxTimeBuffer;
extern FlagT gft_EnableGetIfftBuf;
extern FlagT gft_TriggerGetIfft;
extern int16 *gpsa_IfftBuffer;
extern FlagT gft_EnableGetGhsRxTones;
extern FlagT gft_TriggerGetGhsRxTones;
extern FlagT gft_BypassPGATrain;
extern FlagT gft_SkipInitAfeHSExit;

extern int16 gsa_ForcedToneIdx[];
extern int16 gsa_ForcedToneValue[];
#endif //#if defined (VR9_BRINGUP_DBG) || defined (BIT_PATTERN_TEST)

#ifdef LOG_PILOT_CONSTELLATION
extern uint16 *gpsa_PilotBuf;
extern int16 gs_PilotBufSize;
extern int16 gs_PilotLogSymStep;
extern int16 gs_PilotLogSymCnt;
extern int16 gs_PilotLogCnt;
extern FlagT gft_StartPilotLog;
extern FlagT gft_EnablePilotLog;
#endif //#ifdef LOG_PILOT_CONSTELLATION


#ifdef BIT_PATTERN_TEST
extern uint16 gus_BitPatternIndex;

extern uint8 guc_FindPathDelayState;
extern uint8 guc_FindSampleDiffState;
extern int16 gs_PathDelay; //loopback path delay

extern int16 gs_BitPatternToneOffset;
extern uint16 gus_BitPatternError;
extern uint16 gus_BitPatternVal;
extern uint32 gul_NumDiff;

extern int16 gs_DiffLogIndex;
extern int16 gs_CompareLog_Enable;
#endif //BIT_PATTERN_TEST

extern DbgAllowedToneInfo_t gt_DbgAllowedToneInfo;

extern uint16 gus_UseUS0OnlyCntrl;
extern FlagT gft_DisableUseUS0Only;
// XDSLRTFW-735 IOP_A_US_VDSL2_EVLT_F_CNXT_NoSync3200ft (START_END)
extern FlagT gft_EVLT_IOPtuning;

extern int16 gs_O_UpdateTAC_backup;
extern int16 gs_ForceTimingAdvanceCorrection;
extern int16 gs_MaxCapTAValue; //Debug variable to force max value of TAC (default MaxTAC is 300)
//XDSLRTFW-458: IOP_ALL_VDSL2_ALL_TACorrection (end)

extern ERBParams_t gt_ShowtimeErbParams;  // This variable stored the ERB parameters from the current  OHC Error Feedback request

//XDSLRTFW-285: Feature_ALL_ALL_ALL_Config_Modem_Feature_Map (Start)
extern ModemFeatureMap_t gt_VdslFeatureMap;
extern uint32 gul_ExceptionCode;
        //XDSLRTFW-1298 : ATTNDR fix
extern int32 gl_SumShowtimeSNR;  // Showtime ATTNDRds updating //snv
//XDSLRTFW-1522 (Start)
extern int32 gul_ATTNDR;
extern uint32 gul_RTmemMax;
//XDSLRTFW-1522 (End)
//XDSLRTFW-1285 Feature_US_VDSL2_ALL_UsReTxAmend2_ATTNDR(Start)
extern uint8 guc_attndr_method;
extern uint16 gus_attndr_REIN_INP_FE;
extern uint16 gus_attndr_SHINE_INP_FE;
extern uint16 gus_attndr_delay_FE;
//XDSLRTFW-1285 Feature_US_VDSL2_ALL_UsReTxAmend2_ATTNDR(End)
//XDSLRTFW-785: Bug_All_All_All_PsdAfeReg [Start_End]
extern uint16 gus_DacTrimVal;
//XDSLRTFW-285: Feature_ALL_ALL_ALL_Config_Modem_Feature_Map (End)

extern uint8 guc_seftrPrecFollowing;
extern uint8 guc_EftrLtETRby2OverObsPeriod;
//XDSLRTFW-2387 (Start)
extern FlagT  gft_ReducePilotThr;
extern uint8  guc_PilotSelectionFailure;
//XDSLRTFW-2387 (End)

//XDSLRTFW-1104 DSReTx_5sec_shine_noise (Start)
extern uint16 gus_FdqUpdateEnableCount;
extern int8  gc_FdqUpdateState;
extern int8  gc_Prev_FdqUpdateState;
//XDSLRTFW-1104 DSReTx_5sec_shine_noise (End)

// XDSLRTFW-1479 (Start)
extern DsStPilotDescriptorTable_t gt_DS_StPilotDescriptorTable;
extern DataPathFailures_t gt_DataPathFailures;
// XDSLRTFW-1479 (End)

// XDSLRTFW-1877 : VDSL2 IFEC ATTNDR (Start)
extern uint8 guc_ATTNDR_INP_Act_FE;
extern uint8 guc_ATTNDR_Delay_Act_FE;
extern uint8 guc_attndr_method_from_co;
extern FlagT gft_CalcAttndr;
extern FlagT gft_EnableImprovedATTNDR;
extern FlagT gft_ATTNDR_FrameGenFail;
extern uint16 gus_RpOpt_Attndr;
//XDSLRTFW-1522 (Start_End)
extern uint32 gul_ATTNDR_M0_ChCapacityBased;
extern uint32 gul_ATTNDR_max_delay_octets;
extern uint32 gul_Store_DILV_MEM_SIZE;
extern ConfigVar_Improved_ATTNDR_t gt_DbgImprovedATTNDR;
extern Improved_ATTNDR_ActParam_t gt_Improved_ATTNDR_ActParam;
//XDSLRTFW-1571 (Start_End)
extern FlagT gft_PauseOff;
extern FlagT gft_TestParam_Req; //XDSLRTFW-2184

//XDSLRTFW-1983
extern FlagT gft_ATM_PTM_MisMatch_TTNet;
extern uint16 gus_VendorSpecific_Info;
//XDSLRTFW-1983

extern int16 gs_cl_bonding;
extern int16 gs_clr_bonding;

// XDSLRTFW-1877 : VDSL2 IFEC ATTNDR (End)

// XDSLRTFW-1622 (Start_End)
extern RtxDbgCapture_t gt_RtxDbgCapture;

// XDSLRTFW-1958(Start_End)
extern uint32 gul_StoreExceptionCode;
extern uint8 guc_InitSuccessFailCode;

// XDSLRTFW-1924 (Start_End)
extern uint16 gus_curr_TC_mode_value;

// XDSLRTFW-1696 (start)
// FDPS variables
extern uint8 guca_FDPS1[8][64];
extern uint8 guca_FDPS2[8][64];
extern uint8 *gpuca_FDPSActive;
extern uint8 *gpuca_FDPSInActive;
extern uint8 guca_IndexIndependentPSActive[8];
extern uint8 guca_IndexIndependentPSInActive[8];
extern uint8 guca_CyclicalShiftOfSeqActive[8];
extern uint8 guca_CyclicalShiftOfSeqInActive[8];
extern uint8 guc_SignOfSeqActive;
extern uint8 guc_SignOfSeqInActive;
extern uint8 guc_NoOfAdditionalIPSActive;
extern uint8 guc_NoOfAdditionalIPSInActive;
extern uint16 gus_PSChangeReq;
extern uint16 gus_PSChangePerf;


  //XDSLRTFW-2260 (Start)
extern PSDCompDescriptorTable32_t gt_UsPsdCompensationTable;
extern PSDCompDescriptorTable16_t gt_DsPsdCompensationTable;
extern PSDCompDescriptorTableCombined_t gt_DsPSDCompensationTableCombined;
  //XDSLRTFW-2260 (End)
extern ReTxForcedFraming_t gt_ReTxForcedFraming;  //XDSLRTFW-3020

extern FastDsSraConfig_t gt_FastDsSraConfig;
extern int16 gs_SraNotEnableRejectionCnt;
extern uint16 gus_FastDsSraControl;
//
//
// DO NOT PUT VARIABLES BEYOND THIS LINE
//
//
