/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2010 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
#ifndef GHS_H
#define GHS_H

/***********************************************************************
 *
 * Aware DMT Technology. Proprietary and Confidential.
 *
 * ADDRESS:          40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 * TELEPHONE:        781.276.4000
 * FAX:              781.276.4001
 * WEB:              http://www.aware.com
 *
 * FILE:             ghs.h
 *
 * DESCRIPTION:      defines constants, typedefs, function prototypes
 *                                       used in handshaking.
 *
 **********************************************************************/
 //***************************************************************************************************************************
 // ghs.h

 // history
 // 10/07/2013 Sriram : Endless G.Hs training session in case of missing common mode in CO / CPE capabilities
 // Grep for XDSLRTFW-961 :BugFix_ALL_ALL_ALL_Hsk_NAKEF_Error
 // 10/07/2013 Sriram Shastry : Bug in check condition for setting up error code to indicate CO perfers ADSL mode
 // Grep for XDSLRTFW-1005 : BugFix_ALL_ALL_ALL_Hsk_LookforADSLAnnexbits
//***************************************************************************************************************************


//*******************
//**** CONSTANTS ****
//*******************

// Defines for variable "guc_ClrControl", i.e. GHS Clr control flag bitmap
#define CLR_SEND_NOT_ADSL_MODES      (1)
#define CLR_SEND_NOT_TRANCSEIVER_ID  (2)
#define CLR_SEND_NOT_BONDING_INFO    (4)

// Defines for variable "gs_LoadGhsToneFlag", i.e. GHS tone control flag bitmap
#define BITMAP_LOAD_SINGLE_TONE         (1)
#define BITMAP_LOAD_GHS_TONES           (2)
#define BITMAP_REGSTART_IFFT            (4)
#define BITMAP_LOAD_BIT_PATTERN         (8)
#define BITMAP_LOAD_T1413_TONE          (0x10)
// Codeswap state flag
#define PRE_GHS_CODESWAP_READY                                  0
#define PRE_GHS_CODESWAP_DONE                                   1
#define PRE_GHS_CODESWAP_RX_DETECT_DONE                 2

//---- Decoding result constants (for gt_hsc.s_DecodeResult) ----
#define DECODE_SUCCESS              (0)
#define INVALID_MESSAGE             (1)
#define FCS_ERROR                   (2)
#define INCOMPLETE_STANDARD         (3)
#define INCOMPLETE_NON_STANDARD     (4)
#define DECODE_IDLE                                     (5)

//---- selected mode code (for gt_hsc.l_SelectedMode) ----
#define NOT_SELECTED                (0x0000)   // no mode selected yet
#define NO_COMMON_MODE              (0x0300)   // no common mode selected
#define SILENCE                     (0x0500)   // silence mode (silence for about 1min)
#define RESTART_HS                  (0x0600)   // restart a handshake session (due to either timeout or errored frame)

//XDSLRTFW-961 :BugFix_ALL_ALL_ALL_Hsk_NAKEF_Error(Start)
#define RESTART_HS_NearEnd          (0x0600)   // restart a handshake session (due to either timeout or errored frame)
#define RESTART_HS_FarEnd           (0x0601)   // restart a handshake session (due to either timeout or errored frame)
//XDSLRTFW-961 :BugFix_ALL_ALL_ALL_Hsk_NAKEF_Error(End)
#define RESTART_VIA_CLEARDOWN       (0X0900)   // restart a handshake vis cleardown (mostly due to NAK-CD)
#define ESC_TO_FR                   (0x3000)   // escape to fast retrain
#define FULL_INIT                   (0x5000)   // normal exit to tranceiver training (full initialization)
#define G992_2_AB_ESC_TO_FR         (ESC_TO_FR | G992_2_AB)
#define G992_2_AB_FULL_INIT         (FULL_INIT | G992_2_AB)
#define NOT_SUPPORTED_IN_DUALPORT   (0x0700)   // dual port VR9 cannot support non-8x profiles
#define CO_NOT_BONDABLE             (0x0701)   // CO does not bond, switch to single port mode


/* ---- start-up message code (for gt_hsc.s_InitialMsg) ---- */
#define START_WITH_CLR                  (1)
#define START_WITH_MS                   (2)
#define START_WITH_MR                   (3)
#define START_WITH_MP                   (4)

//---- host command constants ----
#define NO_COMMAND          (0)         // no host command
#define START_GHS           (1)         // host command to start G.hs
#define START_FAST_RETRAIN  (2)         // host command to start Fast Retrain

#define FIRST_TONE_RTV_BUFF_FOR_V43_GHS_TONE_DET           (8) //XDSLRTFW-2425 XDSLRTFW-4227 (Start_End)
//---- HS PGA calculation constants ----
#define MAX_HS_TONE_POWER_DB_US_ONLY    (0x4087)        // RMS power of the upstream handshake tones divided by the number of carriers
                                                                                                        //== 10log10( ((2^15/sqrt(6))^2) ) Q8.8 format = 0x5287
                                                                                                        //the macro here was empirically reduced by 18 dB so that the final HS PGA-1 setting
                                                                                                        //is close to the final transceiver train PGA-1 setting
#define MAX_HS_TONE_POWER_DB_US_AND_DS  (0x3D84)
                                                                                                        // RMS power of the upstream and downstream handshake tones divided by the number of carriers
                                                                                                        //== 10log10( ((2^15/sqrt(6) / sqrt(2))^2) ) Q8.8 format = 0x4F84
                                                                                                        //== MAX_HS_TONE_POWER_DB_US_ONLY - 3 dB
                                                                                                        //the macro here was empirically reduced by 18 dB so that the final HS PGA-1 setting
#define HS_PGA_ACCUM_CNT                (32)    // number of symbols to accumulate RMS data for HS PGA calculations
#define LOG2_HS_PGA_ACCUM_CNT   (5)             // == log2(LOG2_HS_PGA_ACCUM_CNTs)
                                                                                //is close to the final transceiver train PGA-1 setting
#define HS_PGA_SET_WT_LEN               (8)
#define HS_PGA_CALC_INIT                (0)
#define HS_PGA_CALC_ACCUM               (1)
#define HS_PGA_CALC_LOADING_PGA (2)
#define HS_PGA_CALC_DONE                (3)

#define LSB_MASK            (0x01)      // mask to extract only the lab of an octet
#define MODULO_BY_8_MASK    (0x07)      // mask to take modulo by 8 ( 3 LSBs )
#define MODULO_BY_64_MASK   (0x3F)      // mask to take modulo by 8 ( 5 LSBs )

//---- HS Modulation constants----
#define NUM_CARRIER_SETS                (9)             // Number of carrier sets
#define NUM_CARRIER                             (3)             // Number of carrier frequencies per carrier set.
                                                                                // Note that it is 3 except for C43, for which it is 2.
                                                                                // Leave it as 3 for now since only A43 is implemented.

#define MAX_REQ_RTX_NUMBER      (3)             //  Limit of REQ_RTX msg number

#define LOG2_NUM_CARRIER                (1)             // == log2(NUM_CARRIER) truncated to an integer
#define RX_SYMBOL_BUF_SIZE              (8)             // DMT symbol memory size (used for a circular buffer for moving average)
#define SYMBOLS_PER_BIT         (8)             // Number of DMT symbos in a bit, 8 for G.994.1 Rev. 1
#define SYMBOLS_PER_OCTET       (64)    // Number of DMT symbols in an octet, naturally, 64

#define SUBBIT_START        (1)     // subbit index from which measurements are averaged for a bit
#define SUBBIT_END          (6)     // subbit index to which measurements are averaged for a bit

//---- HS Buffer sizes and block lengths----
#define MIN_MESSAGE_LEN         (4)     // minimum number of information octets in a message (see 10.4)
#define MAX_MESSAGE_LEN         (64)   // maximum number of information octets in a Rx/Tx message buffer
#define MESSAGE_BUF_LEN         (2*MAX_MESSAGE_LEN)     // length of guca_RxMsgBuf and guca_TxMsgBuf
#define DECODE_BUF_LEN          (4*MAX_MESSAGE_LEN)     // length of guca_MsgDecodeBuf.
                                                                                                        // This length MUST be at least the total possible standard information
                                                                                                        // length, which is 80 for G.994.1 Revision 1, plus the length of all
                                                                                                        // non-standard information to be received.
#define ENCODE_BUF_LEN                  (4*MAX_MESSAGE_LEN)     // length of guca_MsgEncodeBuf.

#define MAX_NUM_NS_BLOCK        (1)                                        // maximum number of Non-Standard Blocks: Vendor Specific
#define NS_HEADER_LENGTH        (6)
#define MAX_NS_VENDOR_INFO_LEN  (MAX_MESSAGE_LEN - (1+NS_HEADER_LENGTH))   // max length of Non-Standard vendor specific information

//---- HS State machine constants----
#define NUM_PREFIX_FLAG     (3)         // Number of mandatory FLAGs at the head of a message
#define NUM_POSTFIX_FLAG    (2)         // Number of mandatory FLAGs at the tail of a message
#define NUM_CLEARDOWN_GALF  (4)         // Number of GALFs needed when exiting G.hs session
#define NUM_CLEARDOWN_FLAG  (10)        // Number of FLAGs transmitted after GALF characters are received before silencing
                                                                        // (10 octets * 64 DMT symbols/octet = 14.85 ms < 500ms )


//---- Constants used for tone transmission/detections

#define LOG2_NUM_CTONES_DETECT_AVG              (3)             // Num of averaging during CTones detection
#define R_C_TONES_BURST_CNT                             (32)    // Threshold to declare C_Tones detection
                                                                                                // 50ms ~ 32 x ctones_detect_averaging(8)
#define R_C_TONES_DETECTION_FAILURE_CNT (4)             // Threshold to declare C_Tones detection failure

#define R_RECOV_TONE            20                                      //R recover tone number
#define R_RECOV_TONE_MIN        (R_RECOV_TONE-5)        //minimum tone index used for detection of R_RECOVER_TONE
#define R_RECOV_TONE_MAX        (R_RECOV_TONE+5)        //maximum tone index used for detection of R_RECOVER_TONE




                #define C_R_SILENT1_CNT         (138)                   // Minimum length of R_Silent1 to declare detection of it
                #define NUM_CLEARDOWN_SILENCE   (64)                    // Number of silence symbol at GHS termination
                #define CLEARDOWN_SILENCE_DETECT_CNT    (5)             // Length of silence to declare detection of it


#define DETECT_SCALE        (3<<8)                      // tone detection threshold
#define HALF_DETECT_BAND    (4)                         // The presence of a tone is checked over the range of
                                                                                        // [ desired tone - HALF_DETECT_BAND, desired tone + HALF_DETECT_BAND ]
#define FULL_DETECT_BAND (2*HALF_DETECT_BAND + 1)


#define C_R_TONE1_CNT                                   (69)            // Length of R_Tone1 for which the reference phase is calculated

#define C_R_SILENT1_DETECT_THRESH       (1/64)  // (= - 18.06 dB) in C_R_SILENT1, we detect the handshake tones if
                                                                                        // their average power is at least this fraction of their power
                                                                                        // in the initial handshake state.
#define LOG2_C_R_SILENT1_DETECT_THRESH  (6)

#define C_R_TONE_REQ_CNT        (50)    // Minimum length of R_Tone_Req to declare detection of it
#define CRRECOV_BURST_CNT       (16)    // Minimum length of R_RECOV to declare detection of it
#define HS_TONE_ACCUM_CNT               (1)             // number of symbols to measure the US HS tone power over
#define LOG2_HS_TONE_ACCUM_CNT  (0)             // == log2(HS_TONE_ACCUM_CNT)



#define MAX_NUM_REPEAT_MS_MSG   (6)     // Maximum number of times an MS message is repeated on reception of ACK2
#define MAX_NUM_REPEAT_CLR_MSG  (6)     // Maximum number of times a CLR message is repeated on reception of ACK2

#define TIME_16MS               (69)                    // 50ms = 69 symbols
#define TIME_50MS                               (216)                   // 50ms = 215.625 symbols
#define TIME_500MS              (2157)                  // 500ms = 2156.25 DMT symbols
#define HS_TONE_TIMEOUT         (2*TIME_500MS)  // timeout for tones = 1sec
#define HS_MSG_TIMEOUT          (8*TIME_500MS)  // timeout for messages = 4sec
#define REQUESTED_SILENCE       (258750L)               // length of the silence requested

#define GALF                (0x81)              // GALF character
#define FLAG                (0x7E)              // FLAG character

#define FLAG1_CNT           (3)                 // Number of Flags transmitted in C_Flag1
#define FCS_LEN             (2)                 // length of FCS octets

#define DELIMIT_1           ((uint8) 0x80)  // delimitting bit of level 1 parameters
#define DELIMIT_2           ((uint8) 0x40)  // delimitting bit of level 2 parameters
#define NEG_DELIMIT_1       ( ~DELIMIT_1 )
#define NEG_DELIMIT_2       ( ~(DELIMIT_1 | DELIMIT_2) )
#define PAR1_NUM_BIT        7
#define PAR2_NUM_BIT        6

//==== Message type (see Table 3) ====
#define M_MS                (0x00)
#define M_MR                (0x01)
#define M_CL                (0x02)
#define M_CLR               (0x03)
#define M_MP                (0x04)
#define M_ACK1              (0x10)
#define M_ACK2              (0x11)
#define M_NAK_EF            (0x20)
#define M_NAK_NR            (0x21)
#define M_NAK_NS            (0x22)
#define M_NAK_CD            (0x23)
#define M_REQ_MS            (0x34)
#define M_REQ_MR            (0x35)
#define M_REQ_CLR           (0x37)
#define M_REQ_RTX           (0x38) //new msg type defined in Revision3
#define M_NO_MSG            (0x39) //indicate no message is received

#define GHS_MAX_HS_MSG_TYPES    (0x40)

//====  G.hs message exchange states of CO ====

/* ----  g.hs message exchange states CPE ---- */
#define R_HS_INITIAL            (100)
#define R_HS_SEND_MR            (101)
#define R_HS_SEND_MS            (102)
#define R_HS_SEND_CLR           (103)
#define R_HS_MS_OK              (104)
#define R_HS_CL_OK              (105)
#define R_HS_PARTIAL_MS         (106)
#define R_HS_PARTIAL_CL         (107)
#define R_HS_NOT_READY          (108)
#define R_HS_NOT_SUPPORTED      (109)
#define R_HS_NOT_UNDERSTOOD     (110)
#define R_HS_RESTART            (111)
#define R_HS_SEND_MP            (112)  // new state in Revision 2
#define R_HS_RETRANSMIT         (113)  // new state in Revision 3
#define R_HS_EXIT               (114)

#define GHS_MAX_MESSAGE_STATES  (15)


/* ============================================================================================= */
/* Handshake parameters */
/* ============================================================================================= */
//Standard information field - G.992.1 Annex A NPar(2)
#define G9921A_R_ACK1                                           (1)
#define G9921A_R_ACK2                                           (2)
#define G9921A_STM                                                      (0x08)
#define G9921A_ATM                                                      (0x10)
#define G9921A_PTM                                                      (0x20)                          /* this mode is used only by bis */
//XDSLRTFW-456 : CORRECT_ADSL_OCTETS_IN_VDSL_GHS_MSG (START)
#define CLEAR_EOC_G997_1                                        (0x20)
#define UPSTREAM_1_32_DMT                                       (0x04)                                  /*  Upstream tones 1 to 32 for DMT (Annex B specific) */

//XDSLRTFW-2137 (Start)
//Standard information field - G.992.2 Annex AB NPar (2)
#define G9922AB_R_ACK1                 (0x01)
#define G9922AB_R_ACK2                 (0x02)
#define G9922AB_FAST_RETRAIN           (0x08)
#define G9922AB_RS16                   (0x10)
#define G9922AB_CLEAR_EOC_G997_1       (0x20)
//XDSLRTFW-2137 (End)


//Standard information field - G.992.3 Annex A NPar(2)
#define G9923AL_RESERVE0_4                                      (0x0)
#define NPAR2_NTR                                               (0x01)                                          /* Network timing reference */
#define SHORT_INIT                              (0x02)                                          /* G.bis PMD short initialization */
#define DIAGNOSTICS_MODE                (0x04)                                          /* G.bis PMD diagnostics mode */
#define UPSTREAM_1_32_BIS               (0x08)                                  /* Upstream tones 1 to 32 for BIS (Annex B specific) */
#define PSD_SHAPE_SUPPORT               (0x08)
//XDSLRTFW-456 : CORRECT_ADSL_OCTETS_IN_VDSL_GHS_MSG (END)

//Standard information field - G.992.3 Annex A SPar(2)
/* spar2 octet 1 */
#define SPECTRUM_BOUNDS_UP              (0x01)          /* G.bis PMD spectrum bounds upstream */
#define SPECTRUM_SHAPE_UP               (0x02)          /* G.bis PMD spectrum shaping upstream */
#define SPECTRUM_BOUNDS_DN              (0x04)          /* G.bis PMD spectrum bounds downstream */
#define SPECTRUM_SHAPE_DN               (0x08)          /* G.bis PMD spectrum shaping downstream */
#define TX_IMAGE_NYQ                    (0x10)          /* G.bis PMD transmit signal images above the Nyquist frequency */
// We changed the reserved bit to indicate whether we will provide AnnexL PSD Mask info
#define PSD_MASK                                (0x20)          // ADSL2 AnnexL PSD Mask

/* spar2 octet 2 */
#define OH_DATARATE_DN                                  (0x01)          /* G.bis PMS-TC overhead data rate downstream */
#define OH_DATARATE_UP                                  (0x02)          /* G.bis PMS-TC overhead data rate upstream     */
#define MAX_NUM_DS_TPSTC_FUNC_OF_EACH_TYPE      (0x04)  /* G.bis max number of downstream TPS-TC functions of each type */
#define MAX_NUM_US_TPSTC_FUNC_OF_EACH_TYPE      (0x08)  /* G.bis max number of upstream TPS-TC functions of each type */

/* spar2 octet 3 */
#define TPSTC_FUNC_STM_DN               (0x01)          /* G.bis TPS-TC function#0 STM downstream */
#define TPSTC_FUNC_STM_US               (0x02)          /* G.bis TPS-TC function#0 STM upstream */
#define TPSTC_FUNC_ATM_DN               (0x04)          /* G.bis TPS-TC function#0 ATM downstream */
#define TPSTC_FUNC_ATM_US               (0x08)          /* G.bis TPS-TC function#0 ATM upstream */
#define TPSTC_FUNC_PTM_DN               (0x10)          /* G.bis TPS-TC function#0 PTM downstream */
#define TPSTC_FUNC_PTM_US               (0x20)          /* G.bis TPS-TC function#0 PTM upstream */

/* spar2 octet 4 */
#define LATENCY_PATH_DN         (0x01)          /* G.bis PMS-TC downstream latency path#0 supported */
#define LATENCY_PATH_UP         (0x02)          /* G.bis PMS-TC upstream latency path#0 supported */

//Npar(3) Transmit-signal-images-above-the-Nyquist-frequency
#define  IFFT128_ZERO_FILLED          (0x1E)

//G992.3 AnnexL PSD mask
#define PSD_DS_NON_OVERLAPPED           (0x1)
#define PSD_DS_OVERLAPPED               (0x2)
#define PSD_US_WIDE_SPECTRUM            (0x1)
#define PSD_US_NARROW_SPECTRUM          (0x2)

#define PSD_MASK_ANXL_US        (PSD_US_WIDE_SPECTRUM | PSD_US_NARROW_SPECTRUM)                 // Bit1, Bit 2 indicates G992.3 AnnexL: Mask 1 and Mask 2 supported
#define PSD_MASK_ANXL_DS        (PSD_DS_NON_OVERLAPPED)                 // Bit1 indicates G992.3 DS non-overlapped spectrum Annex_L support


#define MIN_MSGOVERHEAD_DATARATE_DS             (4)                     /* data rate = 4*1000bits/sec */
#define MIN_MSGOVERHEAD_DATARATE_US             (4)                     /* data rate = 4*1000bits/sec */

#define MAX_DS_ATM_TPS_TC                               (1)
#define MAX_US_ATM_TPS_TC                               (1)
#define MIN_NET_DATARATE_COMMON_DS              (4)         /* = data rate/4000bps = 16Kbps/4000bps */
#define MIN_NET_DATARATE_COMMON_US              (4)         /* = data rate/4000bps = 16Kbps/4000bps */
#define MAX_NET_DATARATE_COMMON_DS              (4000)  /* = data rate/4000bps = 16Mbps/4000bps */
#define MAX_NET_DATARATE_COMMON_US              (960)   /* = data rate/4000bps = 3840Kbps/4000bps = 64*15 bits/symbol */
#define MIN_RES_NET_DATARATE_COMMON_DS  (4)             /* = data rate/4000bps = 16Kbps/4000bps */
#define MIN_RES_NET_DATARATE_COMMON_US  (4)             /* = data rate/4000bps = 16Kbps/4000bps */
#define MAX_LATENCY_COMMON                              (63)    /* The specail value defined in our code for the maximu delay, which means no limit boundary(in ms) */
#define BER_COMMON                                              (0x2)   /* 0x0 corresponds to a BER of 10^(-3) */
#define MIN_INP_COMMON                                  (0x00)  /* 0x00 special value meaning no impulse noise protection bound */
#define MAX_ONEOVERS_LP0_DS                             (16)    // S0min = 1/MAX_ONEOVERS_LP0_DS
#define MAX_D0_SUPPORT_MASK                             (0x3FFF)  //support optional D0 value: 96, 128, ..., 480, 511

/*******************************************************
G992.5
*******************************************************/

//Standard information field - G.992.5 Annex A NPar(2)
#define G9925_RESERVE0_4                                        (0x10)
#define MAX_NET_DATARATE_DS_G992_5                      (4000)



//==== constants for message parameters ====
#define REVISION1          (0x01)       // revision number 1 of G.994.1
#define REVISION2          (0x02)       // revision number 2 of G.994.1
#define REVISION3          (0x03)       // revision number 3 of G.994.1


//---- Identification field Vendor ID ----
#define COUNTRY_CODE       (0x0000)     // T.35 country code (2 octets)
                                        // The value of this parameter should be defined by the vendor.
                                        // If the bits in the first octet are not all set to binary one,
                                        // the bits in the second octet shall be set to binary zero.
#define VENDOR_ID          (0x00000000) // vendor ID default

//----  Identification field NPar1 ----
#define NON_STANDARD       (0x40)       // non-standard field

//---- Identification field SPar1  -----
//---- G.994.1 Table 9 / 9.0.x ---------
// Octet 1
#define NDR_UP             (0x01)         // net data rate upstream
#define NDR_DN             (0x02)         // net data rate downstream
#define DFC_UP             (0x04)         // data flow characteristics upstream
#define DFC_DN             (0x08)         // data flow characteristics downstream
#define R_SPLITTER         (0x10)         // xTU-R splitter information
#define C_SPLITTER         (0x20)         // xTU-C splitter information
#define TRANSCEIVER_ID     (0x40)         // Exchange of transceiver IDs during initialization
// Octet 2
#define RPL_BUF_SIZE_0          (10)           // size of buffer for Relative Power Level upto bonding bit
#define RPL_A43_UP                      (0x01)         // Relative Power Level for upstream carrier A43
#define RPL_A43_DN                      (0x02)         // Relative Power Level for downstream carrier A43
#define RPL_B43_UP                      (0x04)         // Relative Power Level for upstream carrier B43
#define RPL_B43_DN                      (0x08)         // Relative Power Level for downstream carrier B43
#define RPL_C43_UP                      (0x10)         // Relative Power Level for upstream carrier C43
#define RPL_C43_DN                      (0x20)         // Relative Power Level for downstream carrier C43
#define RPL_MASK_OCTET2    (0x3F)
// Octet 3
#define RPL_A4_UP                          (0x01)         // Relative Power Level for upstream carrier A4
#define RPL_A4_DN                          (0x02)         // Relative Power Level for downstream carrier A4
#define RPL_A43c_UP                     (0x04)         // Relative Power Level for upstream carrier A43c
#define RPL_A43c_DN                     (0x08)         // Relative Power Level for downstream carrier A43c
#define BONDING                         (0x10)         // Bonding
#define RPL_BUF_SIZE_1          (6)            // size of Relative Power Level fields after bonding bit.
#define RPL_J43_UP                      (0x20)         // Relative Power Level for upstream carrier J43
#define RPL_J43_DN                      (0x40)         // Relative Power Level for downstream carrier J43
// Octet 4
#define RPL_B43c_UP                     (0x01)         // Relative Power Level for upstream carrier B43c
#define RPL_B43c_DN                     (0x02)         // Relative Power Level for downstream carrier B43c
#define RPL_V43_UP                      (0x04)         // Relative Power Level for upstream carrier V43
#define RPL_V43_DN                      (0x08)         // Relative Power Level for downstream carrier V43

//---- Identification field NPar2  -----
//--------------------------------------
#define NDR_BITS            ((uint8) 0x1F)// mask for bits 5 to 1, which contain net data rate information
#define LARGE_NDR           ((uint8) 0x20)// bit that indicates whether net data rate is given by the
                                          // formula [NDR_BITS x 2Mbps] or the formula
                                          // [NDR_BITS x 64kbps]
#define LATENCY_BITS        ((uint8) 0x1F)// mask for bits 5 to 1, which contain latency information
#define LARGE_LATENCY       ((uint8) 0x20)// bit that indicates whether latency is given by the
                                          // formula [(4 + LATENCY_BITS) x 10 ms] or the formula
                                          // [LATENCY_BITS x 1 ms]
// G.994.1, Table 9.9, xTU-R splitter
#define LPF_VOICE           (0x01)        // LPF is voice
#define LPF_UISDN           (0x02)        // LPF is USA ISDN
#define LPF_EISDN           (0x04)        // LPF is European ISDN
#define LPF_NS              (0x20)        // Non-standard LPF
// G.994.1, Table 9.11, xTU-C splitter
#define HPF_VOICE           (0x01)        // HPF is voice
#define HPF_UISDN           (0x02)        // HPF is USA ISDN
#define HPF_EISDN           (0x04)        // HPF is European ISDN
#define HPF_VDSL            (0x08)        // HPF is VDSL
#define HPF_NS              (0x20)        // non-standard HPF
// G.994.1, Table 9.13, Transceiver ID NPar2
// G.994.1, Table 9.14, Transceiver ID SPar2
#define CO_TRANSCEIVER_ID   (0x01)        // Network side transceiver ID
#define CPE_TRANSCEIVER_ID  (0x02)        // Remote side transceiver ID

#define NUM_TRANSCEIVER_ID  5             // Number of transceiver ID octets, G.994.1 Amendment 3 (01/2014)

#ifdef VDSL_BONDING
//---- Bonding NPar2/Spar2 level ----
//---- NPar2 ----
#define BONDING_ETHERNET        (0x01)
#define BONDING_TDIM            (0x02)
#define BONDING_ATM                     (0x04)
#define BONDING_BACP            (0x08)

//---- SPar2 ----
#define BONDING_PME_DISCOVERY           (0x01)
#define BONDING_PME_AGGREGATION         (0x02)
#define BONDING_PME_IDENTIFICATION      (0x04)

#define BONDING_PME_READY               (0x1)
#define BONDING_PME_SET                 (0x0)
#define BONDING_PME_CLEAR               (0x3)
#define BONDING_PME_GET                 (0x2)
#define BONDING_PME_MASK                (0x3)
#endif

///////////////////////////////////
//---- Standard Information ---- //
///////////////////////////////////

//---- standard info NPar1 ----
#define VB_V8               (0x01)      // voiceband V.8
#define VB_V8BIS            (0x02)      // voiceband V.8bis
#define SILENT_PERIOD       (0x04)      // silent period request
#define G_PLOAM             (0x10)      // G.ploam
#define G997_1              (0x08)      // G.997.1

//---- standard info SPar1 Octet 1 ----
#define NUM_SI_SPAR1_OCTETS     (5)

// SPar1 Octet 1: G992_1_A, G992_1_B, G992_1_C, G992_2_A/B, G992_2_C, G992_1_H
// bits 0-7 of gta_ModemConfig[guc_port].ul_ADSL_Type
#define G992_DMT_MASK           (0xFF)
#define G992_1_A            (0x01)                      // G.992.1 Annex A
#define G992_1_B            (0x02)                      // G.992.1 Annex B
#define G992_1_C            (0x04)                      // G.992.1 Annex C
#define G992_2_AB           (0x08)                      // G.992.2 Annex A/B
#define G992_2_C            (0x10)                      // G.992.2 Annex C
#define G992_1_H                        (0x20)                  // G.992.1 Annex H
#define G992_1_I                        (0x40)                  // G.992.1 Annex I
#define ADSL_DMT_MASK       (G992_1_A | G992_1_B | G992_2_AB | G992_1_H | G992_1_I)
//---- standard info SPar1 Octet 2 ----
// SPar1 Octet 2: G991_2_A, G991_2_B, MCM VDSL, SCM VDSL
// bits 8-15 of gta_ModemConfig[guc_port].ul_ADSL_Type
#define G991_2_A                        (0x01)          // G.991.2 Annex A
#define G991_2_B            (0x02)              // G.991.2 Annex B
#define T1_MCM_VDSL                     ((0x04)<<8)             // Committee T1 MCM VDSL
#define T1_SCM_VDSL                     ((0x08)<<8)             // Committee T1 SCM VDSL
#define ETSI_MCM_VDSL           ((0x10)<<8)             // ETSI MCM VDSL
#define ETSI_SCM_VDSL           ((0x20)<<8)             // ETSI SCM VDSL
#define ADSL_SHDSL_MASK         (G991_2_A | G991_2_B)
//---- standard info SPar1 Octet 3 ----
// SPar1 Octet 3: G992_3_A, G992_3_B, G992_3_I, G992_3_J, G992_4_A, G992_4_I
// bits 16-23 of gta_ModemConfig[guc_port].ul_ADSL_Type
#define G992_BIS_MASK           (0xFF)
#define G992_3_A                        (0x01)  // G.992.3 Annex A
#define G992_3_B                        (0x02)  // G.992.3 Annex B
#define G992_3_I                        (0x04)  // G.992.3 Annex I
#define G992_3_J                        (0x08)  // G.992.3 Annex J
#define G992_4_A                        (0x10)  // G.992.4 Annex A
#define G992_4_I                        (0x20)  // G.992.4 Annex I
#define G992_3_C                        (0x40)  // G.992.3 Annex C
#define ADSL_BIS_MASK       (G992_3_A | G992_3_B| G992_3_I | G992_3_J | G992_4_A | G992_4_I)
//---- standard info SPar1 Octet 4 ----
// SPar1 Octet 4: G992_5_A, G992_5_B, G992_5_I
// bits 24-31 of gta_ModemConfig[guc_port].ul_ADSL_Type
#define G992_PLUS_MASK          (0xFF)
#define G992_5_A                        (0x01)  // G.992.5 Annex A
#define G992_5_B                        (0x02)  // G.992.5 Annex B
#define G992_5_I                        (0x04)  // G.992.5 Annex I
#define G992_3_M                        (0x08)  // G.992.3 Annex M
#define G992_5_J                        (0x10)  // G.992.5 Annex J
#define ADSL_PLUS_MASK      (G992_5_A | G992_5_B | G992_5_I | G992_3_M | G992_5_J)
//---- standard info SPar1 Octet 5 ----
// SPar1 Octet 5
#define G992_5_M                                        (0x01)                  // G.992.5 Annex M
#define G993_1_ANSI_T1_424                      (0x02)                  // G.993.1 ANSI_T1.424
#define G993_2                                          (0x20)                  // G.993.2 VDSL2
#define G9701                 (0x40)         // G.9701 G.Fast

//---- standard info NPar2 for VDSL1 ------------
#define V1_OPT_BAND_FOR_US                      (0x1)
#define V1_OPT_BAND_FOR_DS                      (0x2)
#define V1_STM                                          (0x08)
#define V1_ATM                                          (0x10)
#define V1_G997_1                                       (0x20)

//---- standard info SPar2 for VDSL1 ------------
#define V1_SUB_CH_INFO                          (0x1)
#define V1_US_BANDS                                     (0x2)
#define V1_DS_BANDS                                     (0x4)
#define V1_DFT_SIZE                                     (0x8)
#define V1_CE_LENGTH                            (0x10)
#define V1_RFI_BANDS                            (0x20)

//---- standard info NPar2 for VDSL2 ------------
//Table 11.67 Standard information field G.993.2 NPar(2) coding - Octet 1
#define V2_ADL_MODE                                     (0x1)
#define V2_VIRTUAL_NOISE_DS                     (0x2)
#define V2_LINEPROBE                            (0x4)
#define V2_LOOP_DIAG                            (0x8)
#define V2_PSD_SHAPING_US0                      (0x10)
#define V2_EQ_FEXT_UPBO                         (0x20)

//Table 11.67.1 Standard information field G.993.2 NPar(2) coding Octet 2
// please note that the support for VECTOR friendly stuff has not been added as it requires more
// then just adding a bit like for V2_ELE_METHOD1
#define V2_VECTOR_FRIENDLY       (0x01)   // G.993.5 friendly G.993.2 operation in the downstream direction.
                                          //     Note: If set to ONE, the bits "Full G.993.5 friendly G.993.2 operation"
                                          //     (see Annex Y) and "ITU-T G.993.5" shall be set to ZERO in the VTU-O MS message.

// XDSLRTFW-487_VR9_VRX318_VDSL2_All_AELEM_Support
#define V2_ELE_METHOD1           (0x02)   // VTU-O supports the Alternative Electrical Length Estimation Method (ELE-M1)

#define V2_VECTOR_FULL_FRIENDLY  (0x04)   // Full G.993.5-friendly G.993.2 operation.
                                          // Note: If set to ONE, the bits "G.993.5 friendly G.993.2 operation in the downstream direction"

//XDSLRTFW-2874 (Start)
#define V2_VECTOR_FULL_FRIENDLY_PILOT_SEQ_LEN_MULTI4_MASK   (0x08)
#define V2_VECTOR_FULL_FRIENDLY_FDPS_US_MASK                (0x10)
//XDSLRTFW-2874 (End)

//---- standard info SPar2 octet 1 for VDSL2 ------------
#define V2_PROFILES                             (0x01)
#define V2_US_BANDS                             (0x02)
#define V2_DS_BANDS                             (0x04)
#define V2_RFI_BANDS                            (0x08)
#define V2_DFT_SIZE                             (0x10)
#define V2_CE_LENGTH                            (0x20)


//---- standard info SPar2 octet 2 for VDSL2 ------------
// Table 11.68.0.1 of G.994.1
#define V2_ANNEX_A_US0_MASKS                    (0x01)
#define V2_ANNEX_B_US0_MASKS                    (0x02)
#define V2_ANNEX_C_US0_MASKS                    (0x04)
#define V2_G_VECTOR_MASKS                       (0x08)
#define V2_9984_EXTENSIONS_MASKS                (0x10)

//---- standard info NPar3 octet 1 for VDSL2 ------------
#define V2_PROFILE_8A                           (0x01)
#define V2_PROFILE_8B                           (0x02)
#define V2_PROFILE_8C                           (0x04)
#define V2_PROFILE_8D                           (0x08)
#define V2_PROFILE_12A                          (0x10)
#define V2_PROFILE_12B                          (0x20)

//---- standard info NPar3 octet 2 for VDSL2 ------------
#define V2_PROFILE_17A                          (0x1)
#define V2_PROFILE_30A                          (0x2)
#define V2_PROFILE_35B                          (0x4)

//---- standard info NPar3 octet 1 for VDSL2 ------------
#define V2_INITIAL_IDFT_SIZE                    (0x0F)
#define V2_INITIAL_IDFT_SIZE_35B                (0x10)

//---- standard info NPar3 octet 1 for VDSL2 ------------
#define V2_US0_A_EU_32                          (0x01)
#define V2_US0_A_EU_36                          (0x02)
#define V2_US0_A_EU_40                          (0x04)
#define V2_US0_A_EU_44                          (0x08)
#define V2_US0_A_EU_48                          (0x10)
#define V2_US0_A_EU_52                          (0x20)

//---- standard info NPar3 octet 2 for VDSL2 ------------
#define V2_US0_A_EU_56                          (0x1)
#define V2_US0_A_EU_60                          (0x2)
#define V2_US0_A_EU_64                          (0x4)

//---- standard info NPar3 octet 3 for VDSL2 ------------
#define V2_US0_A_ADLU_32                        (0x01)
#define V2_US0_A_ADLU_36                        (0x02)
#define V2_US0_A_ADLU_40                        (0x04)
#define V2_US0_A_ADLU_44                        (0x08)
#define V2_US0_A_ADLU_48                        (0x10)
#define V2_US0_A_ADLU_52                        (0x20)

//---- standard info NPar3 octet 4 for VDSL2 ------------
#define V2_US0_A_ADLU_56                        (0x1)
#define V2_US0_A_ADLU_60                        (0x2)
#define V2_US0_A_ADLU_64                        (0x4)

//---- standard info NPar3 octet 5 for VDSL2 ------------
#define V2_US0_A_IN_12B                         (0x1)
#define V2_US0_A_IN_17A                         (0x2)

//---- standard info NPar3 octets for VDSL2 ------------
//---- Corresponding to SPar2 octet 2, bit V2_ANNEX_B_US0_MASKS
// Octet1
#define V2_US0_B_25_138                         (0x1)
#define V2_US0_B_25_276                         (0x2)
#define V2_US0_B_120_276                        (0x4)
// Octet 2
#define V2_US0_B_IN_12B                         (0x1)
#define V2_US0_B_IN_17A                         (0x2)

//--- Table 11.68.9 - Standard information field - ITU-T G.993.2 ---
//--- Annex C US0 NPar(3) coding - Octet 1
// Corresponding to SPar2 octet 2, bit V2_ANNEX_C_US0_MASKS
// Octet1
#define V2_US0_C_25_138_B                       (0x1)
#define V2_US0_C_25_276_B                       (0x2)
// Octet2
#define V2_US0_C_25_138_CO                      (0x1)
#define V2_US0_C_25_276_CO                      (0x2)
// Octet 3
#define V2_US0_C_IN_12B                         (0x1)
#define V2_US0_C_IN_17A                         (0x2)

//--- Table 11.68.10 - Standard information field - ITU-T G.993.2 ---
//--- ITU-T G.993.5 NPar(3) coding Octet 1
// Corresponding to SPar2 octet 2, bit V2_G_VECTOR_MASKS
#define V2_GVECTOR_DS_MASK                      (0x01)
#define V2_GVECTOR_US_MASK                      (0x02)
#define V2_PILOT_SEQ_LEN_MULTI4_MASK            (0x04)
#define V2_FDPS_US_MASK                         (0x08)
#define V2_OP_VEC1_DURATION_EXT_MASK            (0x10)
#define V2_OP_VEC1_FLAG_TONES_MASK              (0x20)

//--- Table 11.68.11  - Standard information field - ITU-T G.993.2 ---
//--- G.998.4 Extensions NPar(3) coding Octet 1
// Corresponding to SPar2 octet 2, bit V2_9984_EXTENSIONS_MASKS
#define V2_G9984_ANNEXD_SUPPORT                 (0x01)

// --------------- G.Fast  ---------------
//---- standard info NPar2 for G.Fast ------------
// Table 11.69 of G994.1 (added in the Ammendment4)
#define G_Fast_Special_Probe_Sequence           (0x04)
#define G_Fast_Default_CE_Length                (0x08)
#define G_Fast_Default_Symbol_Periods_TDD_Frame (0x10)

//---- standard info SPar2 octet 1 for G.Fast ------------
// Table 11.70 of G994.1 (added in the Ammendment4)
#define G_Fast_Profiles                         (0x01)
#define G_Fast_Transmission_Band                (0x02)
#define G_Fast_Symbol_Position_TDD_Frame        (0x04)
#define G_Fast_RFI_Band                         (0x08)
#define G_Fast_Duration_Channel_Discovery       (0x10)
#define G_Fast_CE_Length                        (0x20)

//---- standard info SPar2 octet 2 for G.Fast ------------
// Table 11.70.0.1 of G994.1 (added in the Ammendment4)
#define G_Fast_Symbol_Period_TDD_Frame          (0x01)
#define G_Fast_International_Amateur_Radio_Band (0x02)
#define G_Fast_Scrambler_Seed                   (0x04)
#define G_Fast_Special_Probe_Sequence_Length    (0x08)
#define G_Fast_IDS                              (0x10)
#define G_Fast_SOC_Symbol_Repitition            (0x20)

//---- standard info SPar2 octet 3 for G.Fast ------------
// Table 11.70.0.2 of G994.1 (added in the Ammendment4)
#define G_Fast_DS_Initialzation_Data_Symbols    (0x01)
#define G_Fast_RMC_Offset                       (0x02)

//---- standard info NPar3 octet 1 for G.Fast ------------
// Table 11.70.1 of G994.1 (added in the Ammendment4)
#define G_Fast_Profile_106                      (0x01)
#define G_Fast_Profile_212                      (0x02)

//background task flag
#define BG_GHS_TASK_IDLE        (0)
#define BG_GHS_TASK_DONE        (1)
#define BG_GHS_TASK_GOING       (2)

//BIT MAP for "gs_GhsTerminateFlag" to indicating if TX or RX side has been terminated
#define GHS_TX_TERMINATE                (0x01)          // indicate TX reaches to GHS termination
#define GHS_RX_TERMINATE                (0x02)          // indicate RX reaches to GHS termination
#define GHS_TX_GHS_EXIT                 (0x04)          // indicate RX side that TX side exited GHS state
#define GHS_TX_FG_TRANSMIT_SILENT       (0x08)          // indicate RX side that TX side set the transmitter to silent
#define GHS_TERMINATE_STATE_BG_INIT           (0x10)    // Terminate state: BG_INIT
                                                        //  - InitModem_PostHandshake() has been submitted to the BG fifo
#define GHS_TERMINATE_STATE_FG_INIT           (0x20)    // Terminate state: FG_INIT
                                                        //  - LinkStart_ForPostGhse() has been submitted to the FG fifo
#define GHS_TERMINATE_STATE_INIT_MODEM_DONE   (0x30)    // Terminate state: INIT_MODEM_DONE
                                                        //  - Reconfiguration for Training is done; switch to training
#define GHS_TERMINATE_STATE_EXIT              (0x40)    // Terminate state: GHS_TERMINATE_STATE_EXIT
                                                        //  - Indication to other side

#define GHS_TERMINATE_STATE_MASK              (0xf0)

//BIT MAP for RTX control flag
#define GHS_ENABLE_REQ_RTX_BIT             (1)          // if set to 1, the modem should initiate REQ_RTX message for received errored frame
#define GHS_NEW_TX_MSG_BIT                 (2)          // if set to 1, indicating a new TX message is formed
#define GHS_NEW_RX_MSG_BIT                 (4)          // if set to 1, indicate a new RX message segment is received

//Handshake message debug control bitmap
#define IGNORE_FAREND_MS                                 (0x1)
#define DISABLE_T1_MCM_IN_SI_SPAR1                       (0x2)
#define SUPPORT_STM_IN_SI_NPAR2_VDSL1                    (0x4)
#define SUPPORT_INITCE_IN_SI_SPAR2_VDSL1                 (0x8)
#define DISABLE_CL_EXCHANGED_CHECK                      (0x10)
#define FORCE_NON_STANDARD_INFO                         (0x20)
#define FORCE_VENDOR_SPECIFIC_MODE_REQUEST              (0x40)
#define EXTENDED_TIME_IN_CTONE1                         (0x80)
#define INCREASE_CTONES_DETECT_THRESHOLD               (0x100)

// GHS Carrier Set index
#define GHS_CAR_SET_A43         (0)     // ADSL(A); ADSL2(A,B); ADSL2+(A,I); VDSL2 w/US0
#define GHS_CAR_SET_A43C        (1)     // ADSL2+(A,I,J,M) Cabinet-Case
#define GHS_CAR_SET_B43         (2)     // ADSL(B); ADSL2(B); ADSL2+(B); VDSL2 w/US0
#define GHS_CAR_SET_B43C        (3)     // ADSL2+(B)
#define GHS_CAR_SET_C43         (4)     // ADSL(C,H,I); ADSL2(C)
#define GHS_CAR_SET_J43         (5)     // ADSL2(J,M); ADSL2+(J,M)
#define GHS_CAR_SET_V43         (6)     // VDSL2 wo/US0
#define GHS_CAR_SET_V43P        (7)     // VDSL1 o POTS
#define GHS_CAR_SET_V43I        (8)     // VDSL1 o ISDN

//***************************
//****  TYPE DEFINITIONS ****
//***************************

//---- HandShake Control structure ----
typedef struct {

    int16 s_State;          // current handshake message exchange state
    int16 s_NextState;      // next handshake message exchange state
    int16 s_DecodeResult;   // Decoding Result of a received message
    int16 s_InitialMsg;     // message to initiate a transaction.
    int32 l_SelectedMode;
    int16 s_CL_Exchanged;   // flag indicating if capability lists have been exchanged
    int16 s_TxMsgComplete;  // flag indicating if message xmission is completed
    int16 s_RxMsgComplete;  // flag indicating if message reception is completed
    int16 s_TxNSBCnt;       // number of transmitted non-standard information blocks
    int16 s_RxNSBCnt;       // number of received non-standard information blocks

}   HandShakeControl_t;


//---- complex value ----
typedef struct {

    int16   s_X;    // real part
    int16   s_Y;    // imaginary part

}   Complex_t;


//---- Non-Standard Block structure ----
typedef struct {

    uint8 uc_NSLen;          // length of non-standard information
    // country code and provider ID shall be reused from InforField_t
    uint8 uca_NSVendorSpec[MAX_NS_VENDOR_INFO_LEN]; // vendor specific information array

} NonStandardBlock_t;

//---- ADSL specific Standard Information ----
typedef struct {

        //SI - NPar2
        uint8 uc_SI_NPar2_01;
        uint8 uc_SI_NPar2_02;
//XDSLRTFW-456 : CORRECT_ADSL_OCTETS_IN_VDSL_GHS_MSG
        uint8 uc_SI_NPar2_03;
        uint8 uc_SI_NPar2_04;
        uint8 uc_SI_NPar2_05;
   //XDSLRTFW-2137 (Start_End)
        uint8 uc_SI_NPar2_06;

        //SI - SPar2
        uint8 uc_SI_SPar2_02[4];
        uint8 uc_SI_SPar2_03[4];

} ADSL_Type_t;

//---- ADSL.bis specific SI.NPar3 Information ----
typedef struct {

uint16 us_NOMPSDus;
uint16 us_MAXNOMPSDus;
uint16 us_MAXNOMATPus;

uint16 us_txsignal_above_Nyq;
uint16 us_AnnexL_PSD_US;
uint16 us_AnnexL_PSD_DS;

uint16 us_DS_Overhead_DataRate;
uint16 us_US_Overhead_DataRate;

uint32 ul_Max_DS_TPS_TC;
uint32 ul_Max_US_TPS_TC;

uint16 us_DS_ATM_TPS_TC_Net_Min;
uint16 us_DS_ATM_TPS_TC_Net_Max;
uint16 us_DS_ATM_TPS_TC_Net_Reserve;
uint16 us_DS_ATM_TPS_TC_Delay_Max;
uint16 us_DS_ATM_TPS_TC_Err_Max;
uint16 us_DS_ATM_TPS_TC_INP_Min;

uint16 us_US_ATM_TPS_TC_Net_Min;
uint16 us_US_ATM_TPS_TC_Net_Max;
uint16 us_US_ATM_TPS_TC_Net_Reserve;
uint16 us_US_ATM_TPS_TC_Delay_Max;
uint16 us_US_ATM_TPS_TC_Err_Max;
uint16 us_US_ATM_TPS_TC_INP_Min;

uint16 us_DS_PMS_TC_Net_max;
uint16 us_DS_PMS_TC_Supported_S_min;
uint32 ul_DS_MAX_D0_SUPPORT_MASK;
uint16 us_US_PMS_TC_Net_max;

} ADSL_Bis_SI_Type_t;


//---- ADSL.plus specific SI.NPar3 Information ----
typedef struct {

uint16 us_NOMPSDus;
uint16 us_MAXNOMPSDus;
uint16 us_MAXNOMATPus;

uint16 us_txsignal_above_Nyq;
uint16 us_AnnexL_PSD_US;
uint16 us_AnnexL_PSD_DS;

uint16 us_DS_Overhead_DataRate;
uint16 us_US_Overhead_DataRate;

uint32 ul_Max_DS_TPS_TC;
uint32 ul_Max_US_TPS_TC;

uint16 us_DS_ATM_TPS_TC_Net_Min;
uint16 us_DS_ATM_TPS_TC_Net_Max;
uint16 us_DS_ATM_TPS_TC_Net_Reserve;
uint16 us_DS_ATM_TPS_TC_Delay_Max;
uint16 us_DS_ATM_TPS_TC_Err_Max;
uint16 us_DS_ATM_TPS_TC_INP_Min;

uint16 us_US_ATM_TPS_TC_Net_Min;
uint16 us_US_ATM_TPS_TC_Net_Max;
uint16 us_US_ATM_TPS_TC_Net_Reserve;
uint16 us_US_ATM_TPS_TC_Delay_Max;
uint16 us_US_ATM_TPS_TC_Err_Max;
uint16 us_US_ATM_TPS_TC_INP_Min;

uint16 us_DS_PMS_TC_Net_max;
uint16 us_DS_PMS_TC_Supported_S_min;
uint32 ul_DS_MAX_D0_SUPPORT_MASK;
uint16 us_US_PMS_TC_Net_max;

} ADSL_Plus_SI_Type_t;

//---- VDSL 1 specific Standard Information: Par2 and Par3 Block structure ----


//---- VDSL 2 specific Standard Information: Par2 and Par3 Block structure ----
typedef struct {

        //SI - NPar2
        uint8 uc_SI_NPar2;
    uint8 uc_SI_NPar2_02;

        //SI - SPar2
        uint8 uc_SI_SPar2_01;
        uint8 uc_SI_SPar2_02;

        //----------------- SI NPar3 ----------------------------
        uint8 uca_Profiles[2];

        // Used US and DS bands (maximum of 9 bands allowed in GHS message)
        // and each tone is described by 13 bits (requiring 3 bytes)
        uint8 uca_UsedUsBands[9*6];
        uint8 uca_UsedDsBands[9*6];

        //RFI bands ( maximum of 16 bands)
        //and each tone is described by 13 bits (requiring 3 bytes)
        uint8 uca_RFIBands[16*6];

        //FFT/IFFT size
        uint8 uc_fft_size;

        //Initial sample length of cyclic extension
        uint8 uca_CELength[3];

        // Annex A US0 PSD
        uint8 uca_US0_A_bands[5];

        // Annex B US0 PSD
        uint8 uca_US0_B_bands[2];

        // Annex C US0 PSD
        uint8 uca_US0_C_bands[3];

//#ifdef MTK_VECTORING_SUPPORT
        uint8 uc_Gvector;        // Table 11.68.10 in G.994.1
//#endif
   //XDSLRTFW-1693 (Start_End)
   uint8 uc_G9984_Extensions;    // Table 11.68.11 in G.994.1

        // These elements added to use same functions for VDSL1/VDSL2 decoding
        uint8 uc_NumUsBands;
        uint8 uc_NumDsBands;
        uint8 uc_NumRFIBands;

} VDSL2_Type_t;

//---- G.Fast specific Standard Information: Par2 and Par3 Block structure ----
typedef struct {
   //SI - NPar2
   uint8 uc_SI_NPar2;

   //SI - SPar2
   uint8 uc_SI_SPar2_01;
   uint8 uc_SI_SPar2_02;
   uint8 uc_SI_SPar2_03;

   //----------------- SI NPar3 ----------------------------
   uint8 uc_Profiles;

   // Duration of Channel discovery 1-1
   uint8 uc_duration_channel_discovery;

   // Number of symbol periods in TDD frame
   uint8 uc_symbol_period_TDD_frame;
   } G_Fast_Type_t;

//---- Information Field structure ----
typedef struct {

        //==== Identification Field ====

    uint8 uc_Type;           // message type field
    uint8 uc_Rev;            // revision number field

    // Vendor ID field
    // !! Note: The order of the three variables is not allowed to be changed!!
    uint16 us_Country;       // T.35 country code
    uint32 ul_Provider;      // provider code (Vendor ID, 4 octets)
    uint16 us_VendorInfo;    // vendor specific information (2 octets)

    // Parameter field
    uint8 uc_ID_NPar1;
    uint8 uc_ID_SPar1;
    uint8 uc_ID_SPar1_02;
    uint8 uc_ID_SPar1_03;
    uint8 uc_ID_SPar1_04;

    // Npar2
    uint8 uc_UpMaxNDR;       // maximum net data rate upstream
    uint8 uc_UpMinNDR;       // minimum net data rate upstream
    uint8 uc_UpAvgNDR;       // average net data rate upstream

    uint8 uc_DnMaxNDR;       // maximum net data rate downstream
    uint8 uc_DnMinNDR;       // minimum net data rate downstream
    uint8 uc_DnAvgNDR;       // average net data rate downstream

    uint8 uc_UpMaxLat;       // maximum latency upstream (units given by formula in Table 16 of G.hs)
    uint8 uc_UpAvgLat;       // average latency upstream (units given by formula in Table 17 of G.hs)

    uint8 uc_DnMaxLat;       // maximum latency downstream (units given by formula in Table 18 of G.hs)
    uint8 uc_DnAvgLat;       // average latency downstream  (units given by formula in Table 19 of G.hs)
    uint8 uc_ID_NPar2_O11;   // splitter information - Parameter field NPar2 Octet 11
    uint8 uc_ID_NPar2_O12;   // splitter information - Parameter field NPar2 Octet 12

//    uint8 uc_ID_NPar2_TransId; // NPar2 - Transceiver ID (No info so far)
    uint8 uc_ID_SPar2_TransId; // SPar2 - Transceiver ID
    uint32 ul_CoTransId;       // NPar3 - Network side transceiver ID
    uint32 ul_CpeTransId;      // NPar3 - Remote side transceiver ID

        // Relative power level information
        uint8 uc_UpA43Att;              // Attenuation in transmit power relative to maximum power for upstream A43
        uint8 uc_DnA43Att;              // Attenuation in transmit power relative to maximum power for downtream A43
        uint8 uc_UpB43Att;              // Attenuation in transmit power relative to maximum power for upstream B43
        uint8 uc_DnB43Att;              // Attenuation in transmit power relative to maximum power for downtream B43
        uint8 uc_UpC43Att;              // Attenuation in transmit power relative to maximum power for upstream C43
        uint8 uc_DnC43Att;              // Attenuation in transmit power relative to maximum power for downtream C43
        uint8 uc_UpA4Att;               // Attenuation in transmit power relative to maximum power for upstream A4
        uint8 uc_DnA4Att;               // Attenuation in transmit power relative to maximum power for downtream A4
    uint8 uc_UpA43cAtt;         // Attenuation in transmit power relative to maximum power for upstream A43c
        uint8 uc_DnA43cAtt;             // Attenuation in transmit power relative to maximum power for downtream A43c
#ifdef VDSL_BONDING
        uint8 uc_BondingNP2;            // Bonding type (Ethernet, TDIM, ATM, BACP)
        uint8 uc_BondingSP2;            //
        uint8 uca_BondingDisc[9];       // ClearIfSame bit and Disc register
        uint8 uca_BondingAggr[6];       // PME Aggr register
        uint8 uc_BondingId;                     // PME Identification info
#endif
        uint8 uc_UpJ43Att;              // Attenuation in transmit power relative to maximum power for upstream J43
        uint8 uc_DnJ43Att;              // Attenuation in transmit power relative to maximum power for downtream J43
        uint8 uc_UpB43cAtt;             // Attenuation in transmit power relative to maximum power for upstream B43c
        uint8 uc_DnB43cAtt;             // Attenuation in transmit power relative to maximum power for downtream B43c
    uint8 uc_UpV43Att;          // Attenuation in transmit power relative to maximum power for upstream V43
        uint8 uc_DnV43Att;              // Attenuation in transmit power relative to maximum power for downtream V43

    //==== Standard Information Field ====

    //---- Par1 General parameters ----
        uint8 uc_SI_NPar1;
    uint8 uc_SI_SPar1;          // Parameter field SPar1 Octet 1.
        uint8 uc_SI_SPar1_02;   // Parameter field SPar1 Octet 2.
        uint8 uc_SI_SPar1_03;   // Parameter field SPar1 Octet 3.
        uint8 uc_SI_SPar1_04;   // Parameter field SPar1 Octet 4.
        uint8 uc_SI_SPar1_05;   // Parameter field SPar1 Octet 5.

        //----- ADSL specific Par2
        ADSL_Type_t t_ADSL_Info;
        //----- ADSL.bis  specific NPar3

        ADSL_Bis_SI_Type_t t_Bis_SI_NPar3;

        //----- ADSL.bis  specific NPar3
        ADSL_Plus_SI_Type_t t_Plus_SI_NPar3;


        //---- VDSL2 specific Par2, Par3
        VDSL2_Type_t t_VDSL2_Info;

        // --- G.Fast specific Par2, Par3
        G_Fast_Type_t t_G_Fast_Info;

    //==== Non-Standard Information Field ====
    //==== country code and vendor ID shall be reused. ====
    uint8 uc_NumBlock;                               // number of non-standard blocks
        // Note: some vendors (e.g. CNXT) use a different provider code in the NS info field compared to
        // the one in the "regular" the vendor ID info block
    uint16 us_Country_NS;       // T.35 country code
    uint32 ul_Provider_NS;      // provider code (Vendor ID, 4 octets)
    NonStandardBlock_t ta_NS_Info[MAX_NUM_NS_BLOCK]; // array of non-standard blocks

        /* ==== Retransmission infomation block ==== */
        uint8 uc_last_received_msg_type;                                                /* REQ_RTX LCRM octet */
        uint8 uc_request_msg_segment_index;                                             /* REQ_RTX MSFN octet */

} InfoField_t;

// Far-end Operating Modes
typedef struct {
        uint8 uca_SupportedModes[6];
} FE_OperatingModes_t;

// Far-end VDSL2 standard information fields from capabilities list
typedef struct {

        // SI Npar2, Spar2_01 settings
        uint16 us_Npar2Spar2;

        // 0x00 - None,
        // 0x01 - V2_PROFILE_8A,0x02 - V2_PROFILE_8B, 0x04 - V2_PROFILE_8C,
        // 0x08 - V2_PROFILE_8D,0x10 - V2_PROFILE_12A,0x20 - V2_PROFILE_12B,
        // 0x40 - V2_PROFILE_17A,0x80 - V2_PROFILE_30A
        uint16 us_ProfileSupported;

        // 0x00 - None,
        // 0x01 - V2_ANXA_US0_EU_32,0x02 - V2_ANXA_US0_EU_36, 0x04 - V2_ANXA_US0_EU_40,
        // 0x08 - V2_ANXA_US0_EU_44,0x10 - V2_ANXA_US0_EU_48,0x20 - V2_ANXA_US0_EU_52,
        // 0x40 - V2_ANXA_US0_EU_56,0x80 - V2_ANXA_US0_EU_60,0x100 - V2_ANXA_US0_EU_64
        // 0x200 - V2_ANXA_US0_ADLU_32,0x400 - V2_ANXA_US0_ADLU_36, 0x800 - V2_ANXA_US0_ADLU_40,
        // 0x1000 - V2_ANXA_US0_ADLU_44,0x2000 - V2_ANXA_US0_ADLU_48,0x4000 - V2_ANXA_US0_ADLU_52,
        // 0x8000 - V2_ANXA_US0_ADLU_56,0x10000 - V2_ANXA_US0_ADLU_60,0x20000 - V2_ANXA_US0_ADLU_64
        // 0x40000 - V2_ANXA_US0_IN_12B,0x80000 - V2_ANXA_US0_IN_17A
        uint32 ul_AnxAUS0PsdSupported;

        // 0x00 - None,
        // 0x01 - V2_ANXB_US0_25_138,0x02 - V2_ANXB_US0_25_276, 0x04 - V2_ANXB_US0_120_276,
        // 0x08 - V2_ANXB_US0_IN_12B,0x10 - V2_ANXB_US0_IN_17A
        uint16 us_AnxBUS0PsdSupported;

        // 0x00 - None,
        uint16 us_AnxCUS0PsdSupported;
//#ifdef MTK_VECTORING_SUPPORT
    // 0x00 - None
        // 0x01 - DS Vectoring
        // 0x02 - US Vectoring
        // Is this really serving any purpose besides storing FE info ?
    uint16 us_G9935_G9984_Supported; // corresponds to Table 11.68.10/11 G.994.1
//#endif

        // IDFT size
        uint16 us_IDFTSize;

        uint16 us_CELengthSupported[2];

} VDSL2_FE_StdInfo_CL_t;

//***************************************
//*****  EXTERNAL GLOBAL VARIABLES ******
//***************************************

//---- global variables used for symbol re-alignment ----
extern FlagT gft_SymbolReAlignRequired;         // flag indicating symbol re-alignment is required
extern int16 gs_ReAlignSubState;                        // substate variable used only in RxSymbolReAlign().

//---- global variables used for startup options ----
extern int16 gs_HostCommand;                            // host command. host can start G.hs by setting this variable to START_GHS

//---- Handshake carrier sets ----
extern int16 gs_GhsCarSetCfg;           // E.g. A43, B43, etc., used to index tables below
extern int16 gs_GhsCarSetCfgInternal;
extern int16 gs_GhsCarSetActual;                // E.g. A43, B43, etc., used to index tables below

extern int16 gsa_UpCarSetTable[NUM_CARRIER_SETS][NUM_CARRIER];
extern int16 gsa_DnCarSetTable[NUM_CARRIER_SETS][NUM_CARRIER];

// Actual DS and US carrier sets used during GHS
extern int16 gsa_DnCarSet[NUM_CARRIER];
extern int16 gsa_UpCarSet[NUM_CARRIER];

extern int16 *gpsa_TxCarSetTable;
extern int16 *gpsa_RxCarSet;
extern int16 gsa_TxGhsToneBuf[2*NUM_CARRIER];           // GHS tone buffer to be loaded to the HW IFFT input buffer

//---- global variables for power calculation ----
extern int32 gl_InitRxHsTonesPower;     // the average power of the 3 upstream handshake tones when first detected by the modem.
extern int32 gl_HsToneSetPower;
extern int16 gs_HsTonePower_dB;
extern int16 gs_HsPgaCalcSymCnt;
extern FlagT gft_HsPgaCalcStatus;
extern int16 gs_PgaCalcDoneCnt;         // substate count on which PGA-1 calc completes

// XDSLRTFW-3599 : Vrx518: sporadically lower US DR in vectoring bundle with 46 CPEs in 17 profile (Start)
extern int32 gl_RCGalf2HsTonesPower;
extern int16 gs_RCGalf2HsTonePower_dB;
// XDSLRTFW-3599 : Vrx518: sporadically lower US DR in vectoring bundle with 46 CPEs in 17 profile (End)

// Debug code which can be removed later - start
extern uint16 gs_DnCarSet_ref;
extern int16 gs_TryNext;
extern int16 gs_CheckClipping;
// Debug code which can be removed later - end

//---- global variables and structures for DPSK modulation/demodulation ----
extern int16 gs_DETECT_SCALE;
extern int16 gs_TxAn_Prev;             // last bit symbol for xceiver
extern uint8 guc_TxOctet;              // Octet buffers for Tx
extern uint8 guc_RxOctet;              // Octet buffers for Rx
extern Complex_t gt_RxCurrentSymbol[NUM_CARRIER];                                       // current bit symbol for RX
extern Complex_t gt_RxLastSymbol[NUM_CARRIER];                                          // last bit symbol for RX
extern Complex_t gta_RxSymbolBuf[NUM_CARRIER][RX_SYMBOL_BUF_SIZE];   // memory of complex valued DMT symbols for designated carrier bins in Rx

extern uint8* gpuca_RxMsgBuf;                   //pointer to guca_RxMsgBuf[MESSAGE_BUF_LEN]
extern uint8* gpuca_DecodeBuf;                  //pointer to guca_DecodeBuf[DECODE_BUF_LEN]
extern uint8* gpuca_TxMsgBuf;                   //pointer to guca_TxMsgBuf[MESSAGE_BUF_LEN]
extern uint8* gpuca_EncodeBuf;                  //pointer to guca_EncodeBuf[ENCODE_BUF_LEN]

extern InfoField_t* gpt_RxInfo;                 // pointer to gt_RxInfo
extern InfoField_t* gpt_RxInfoSave;             // pointer to gt_RxInfoSave
extern InfoField_t* gpt_TxInfo;                 // pointer to gt_TxInfo
extern InfoField_t* gpt_TxInfoSave;             // pointer to gt_TxInfoSave

//---- Symbol and Octet Counters ----
extern int16 gs_RxGhsSymCnt;
extern int16 gs_TxMsgBufCnt;            // number of octets in a message to be transmitted
extern int16 gs_RxMsgBufCnt;            // number of octets in a message being received
extern int16 gs_DecodeBufCnt;           // number of octets in a total message being decoded
extern int16 gs_TxOctetCnt;                     // counts number of octets in a given TxSubState
extern int16 gs_RxOctetCnt;                     // counts number of octets in a given RxSubState
extern uint16 gus_NumberOfMsgOctetsSent;
extern uint16 gus_TotalNumberOfMsgOctets;
extern int16 gs_HandShake_Cnt;                  // number of times going through GHS
extern uint8 guc_RxGalfCnt;
extern int16 gft_WholeTxMsgComplete;

extern uint8 guc_TxHSMsg_SegmentCnt;                            // Tx Msg Segment counter
extern uint8 guc_RxHSMsg_SegmentCnt;                            // Rx Msg Segment counter
extern uint8 guc_RxHSReqRtx_cnt;                                        // The received HS REQ_RTX msg counter
extern uint8 guc_TxHSReqRtx_cnt;                                        // The transmitted HS REQ_RTX msg counter
extern uint8 guc_last_rx_msg_type;                      // type of last correctly received message segment
extern uint8 guc_last_tx_msg_type;                      // type of last correctly transmitted message segment
extern int16 gs_LastTxMsgBufCnt;                        // number of octets in the last message to be transmitted
extern int16 gft_RTXCtrlFlag;                           // flag to control retransmission operation

//---- global variables used for GHS message state machine ----
extern HandShakeControl_t gt_hsc;
extern uint8 guc_NotUnderstood;
extern FlagT gft_Previous_NAK_NS;
extern uint16 gus_ExtraBits;           // represent how many bits are set to 1 in the ignored CL/CLR octets.

//---- global variables for startup/clear down procedure
extern int16 gs_GhsTerminateFlag;

// Number of cleardown flags before the GALFs are sent (in the usual RT initiated cleardown)
extern int16 gs_num_cleardown_flags;
extern int16 gs_num_cleardown_flags_short;                              // triggered against BDCM

// Misc
extern uint8 guc_NewRxMsgType;

// Far-end Operating Modes
extern FE_OperatingModes_t gt_FE_OperatingModes;

// Far-end VDSL2 standard information fields from capabilities list
extern VDSL2_FE_StdInfo_CL_t gt_VDSL2_FE_StdInfo_CL;


// G994.1 Vendor ID information
extern G994_VendorInformation_t gt_ne_VendorInformation;
extern G994_VendorInformation_t gt_fe_VendorInformation;



// MsgHandler substate functions. Each one corresponds to one substate of gt_hsc.s_State
extern void (*MsgHandler_states [])(void);

//HSMsgHandler substate functions. Each one corresponds to one G.HS ATU_R state (see G.HS standard Figure 12.2)
void R_HS_INITIAL_state (void);
void R_HS_SEND_MR_state (void);
void R_HS_SEND_MS_state (void);
void R_HS_SEND_CLR_state (void);
void R_HS_MS_OK_state (void);
void R_HS_CL_OK_state (void);
void R_HS_PARTIAL_MS_state (void);
void R_HS_PARTIAL_CL_state (void);
void R_HS_NOT_READY_state (void);
void R_HS_NOT_SUPPORTED_state (void);
void R_HS_NOT_UNDERSTOOD_state (void);
void R_HS_RESTART_state (void);
void R_HS_SEND_MP_state (void);           // new state in Rev 2
void R_HS_RETRANSMIT_state (void);  // new state in Rev 3

//*****************************
//**** FUNCTION PROTOTYPES ****
//*****************************

void RFlag1TxF(void);
void RFlag2TxF(void);
void RGalf2TxF(void);
void RHSMsgTxF(void);;
void RSilent0TxF(void);
void RSilent1TxF(void);
void RTone1TxF(void);
void RTonesReqTxF(void);

void RCFlag1RxF(void);
void RCFlag2RxF(void);
void RCGalf1RxF(void);
void RCGalf2RxF(void);
void RCHSMsgRxF(void);
void RCSilent1RxF(void);
void RCTonesRxF(void);


/*** hndshk.c ***/
void RxSymbolReAlign(void);
FlagT PreHandshakeCodeswap(FlagT ft_trigger_codeswap);

/*** hs_tx.c ***/
void  TxMultiTones(int16 s_NCar, int16 s_TxScale);
void  TxBit(void);

/*** hs_rx.c ***/
void RxBit(int16 sa_CarSet[], int16 s_SubBit);
int16 DemodBit( Complex_t t_RxCurrentSymbol[], Complex_t t_RxLastSymbol[] );
void GetSymbol(int16 s_SubBit );
void TryAnotherToneSet(void);
int16 FastAtan(int16 y_in, int16 x_in);
int16 TestPhaseTransition( int16 s_SubBit );
Complex_t MovingAvg( Complex_t ta_Buf[], int16 s_BufLen, int16 s_Idx, int16 s_WindowLen );

/*** CIdleLinkRxF.c ***/
void DetectGHSLeakyBucket(int16 s_ToneFlag, int16 *ps_GHSLeakyBucketCnt);

/*** hs_init.c ***/
void InitGhsPointers(uint8* puca_HndshkBuf);
void InitializeStandardInfoField(InfoField_t * t_I);
#ifdef VDSL_BONDING
void InitializeInfoField_Bonding_NPar3(InfoField_t *t_I);
void StoreInfoField_Bonding_NPar3(InfoField_t *t_I, uint8 uc_FieldToStore);
#endif
void InitializeStandardInfoField_ADSL(ADSL_Type_t *pt_ADSL_I, InfoField_t *t_Info);
void InitializeStandardInfoField_VDSL2(VDSL2_Type_t *pt_VDSL2_I);
void InitializeStandardInfoField_GFast(G_Fast_Type_t *pt_G_Fast_I, InfoField_t *t_Info);
void Init30aBandPlan_VDSL2(VDSL2_Type_t *pt_VDSL2_I);

void InitializeHSC( HandShakeControl_t *pt_hsc );
void InitializeParameterInfoField(InfoField_t * t_I);

/*** hs_mesg.c ***/
void  CopyInfoField( InfoField_t *t_Source, InfoField_t *t_Target );
int16 FormMessage( InfoField_t *t_Info, uint8 uca_Msg[] );
void  BgDecodeMessage(void);
void  DecodeMessage( uint8 uca_Msg[], InfoField_t *t_Info );
int16 FormStandard(InfoField_t *t_Info, uint8 uca_M[], int16 idx );
int16 FormNonStandard(InfoField_t *t_Info, uint8 uca_M[], int16 idx );
int16 DecodeStandard( uint8 uca_M[], int16 idx, int16 s_MsgLen, InfoField_t *t_Info );
int16 DecodeNonStandard( uint8 uca_Msg[], int16 idx, int16 s_MsgLen, InfoField_t *t_Info );
int16 SkipExtraOctetAndCheckSegmentation(uint8 uca_M[], int16 idx, int16 s_MsgLen, int16 s_delimiter, int16 s_ActiveBlocks, int16 s_DecodedBlocks );
int16 SkipCountExtraOctetAndCheckSegmentation(uint8 uca_M[], int16 idx, int16 s_MsgLen, int16 s_delimiter, int16 s_ActiveBlocks, int16 s_DecodedBlocks );

int16 DecodeStandard_VDSL2(VDSL2_Type_t *pt_info, uint8 uca_M[], int16 idx, int16 s_MsgLen) ;

void SetArray2Struct(uint8 *uca_M, int16 *ps_idx, uint8 *puca_t_Info_data, int16 s_NumOfInputData);
void Common_CL_InfoSave(void);
void VDSL2_CL_InfoSave(void);


/*** hs_resp.c ***/
int32 SelectMode( InfoField_t *pt_MS_Info );
void PrepareMS(void);
void ResponseToRTX(void);
void UpdateMsgTypeForRTX(void);
void ResponseToErrorFrame(void);
void Do_ClearDown(void);
void HndshkTimeout(void);
FlagT Compare_CL_CLR(void);

/*** hs_resp_co.c or hs_resp_cpe.c ****/
void HSMsgHandler(void);
void ResponseToMR(void);
void ResponseToMS(void);
void DefaultResponseToMS(void);
void ResponseToCLR(void);

/*** hs_exit.c ****/
void TerminateHandshakeTx(void);
void TerminateHandshakeRx(void);
void TerminateSnifferGhs(void);


/*** hs_misc.c ***/

void InitPgaCalcForHandshake(void);
void PgaCalcForHandshake(int16 s_RxState);
void InitGHSVariables(void);


#endif  // GHS_H
