/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1999 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
#ifndef _IEEE_FLT_H
#define _IEEE_FLT_H

/**********************************************************************
 *
 * Aware DMT Technology. Proprietary and Confidential.
 *
 * ADDRESS:          40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 * TELEPHONE:        781.276.4000
 * FAX:              781.276.4001
 * WEB:              http://www.aware.com
 *
 * FILE:             ieee_flt.h
 * DESCRIPTION:      Header file for ieee_flt.c.
 *
 **********************************************************************/

/**********************************************************************
 * CONSTANTS
 **********************************************************************/
#define NEG32        0x80000000     /* sign bit only */
#define ONE32        0x3f800000     /* 1.0 */
#define ONE_HALF        0x3f000000      /* 0.5 */
#define TWO_TO_15TH     0x47000000      /* 32768 */
#define MASK8LOW     0x000000FF     /* mask on 8 lsbs */
#define MASK9LOW     0x000001FF     /* mask on 9 lsbs */
#define MASK8TO15    0x0000FF00     /* mask on next 8 */
#define MASK16TO23      0x00FF0000     /* mask on next 8 */
#define MASK16LOW    0x0000FFFF     /* mask on 8 lsbs */
#define MASK23LOW    0x007FFFFF     /* mask on 23 lsbs */
#define MASK24LOW    0x00FFFFFF     /* mask on 24 lsbs */
#define MASKBIT16    0x00010000     /* check carry bit 16 */
#define HIDDEN_BIT      0x00800000     /* just the hidden bit */
#define EXP32SHIFT_LOW  23          /* right shift for exponent of 32 bit word */
#define EXPONENT_BIAS   127            /* exponent in IEEE float is (e-127) */
#define EXP_INF_NAN     255
#define REAL_INF        0x7F800000
#define REAL_NEGINF     (REAL_INF | NEG32)
#define REAL_NAN        (REAL_INF + 1)
#define LOG10_2         0x3E9A209B

/**********************************************************************
 * FUNCTIONS
 **********************************************************************/

#ifdef FLOAT_IN_SW

Float32 int2f32(int16 s_xin);
Float32 int32toFloat32(int32 l_xin);
int16 f32toint16(Float32 f_in, int16 s_conv_mode);
int32 f32toint32(Float32 f_in, int16 s_conv_mode);
Float32 addf32(Float32 f_x, Float32 f_y);
Float32 subf32(Float32 f_x, Float32 f_y);
Float32 mpyf32(Float32 f_x, Float32 f_y);
Float32 divf32(Float32 f_x, Float32 f_y);
int cmpgtf32(Float32 f1, Float32 f2);
Float32 absf32(Float32 f_in);
Float32 sqrtf32(Float32 f_x);
int16 expf32(Float32 f_x);
Float32 pow2f32(int16 s_x);

#else

#define int2f32(x)         (FloatG)(x)
#define int32toFloat32(x)  (FloatG)(x)
#define f32toint16(x,m)    (x > 0 ? (int16)((FloatG)(x)+0.5) : (int16)((FloatG)(x)-0.5)) // assume m=0
#define f32toint32(x,m)    (x > 0 ? (int32)((FloatG)(x)+0.5) : (int32)((FloatG)(x)-0.5)) // assume m=0
#define addf32(x,y)        (FloatG)(x)+(FloatG)(y)
#define subf32(x,y)        (FloatG)(x)-(FloatG)(y)
#define mpyf32(x,y)        (FloatG)(x)*(FloatG)(y)
#define divf32(x,y)        (FloatG)(x)/(FloatG)(y)
//int cmpgtf32(Float32 f1, Float32 f2);
//Float32 absf32(Float32 f_in);
//Float32 sqrtf32(Float32 f_x);
//int16 expf32(Float32 f_x);
//Float32 pow2f32(int16 s_x);

#endif // FLOAT_IN_SW

#endif /* _IEEE_FLT_H */

