/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2006 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
#ifndef _MTKERNEL_H
#define _MTKERNEL_H

/**********************************************************************
 *
 * Aware DMT Technology. Proprietary and Confidential.
 *
 * ADDRESS:          40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 * TELEPHONE:        781.276.4000
 * FAX:              781.276.4001
 * WEB:              http://www.aware.com
 *
 * FILE:             mtkernel.h
 * DESCRIPTION:      Header file for multi-tasking kernel functions.
 *
 **********************************************************************/

/* Constants needed for Kernel  */
#define RX_FRAME_START (0)
#define RX_QT_DONE (1)
#define RX_FC_DONE (2)
#define TX_FRAME_START (3)
#define RX_TIMER_DONE (4)
#define TX_TIMER_DONE (5)
#define TX_IFFT_DONE (6)
#define RX_FFT_DONE (7)
#define TX_FC_DONE (8)
#define TX_QT_DONE (9)
#define TX_PARR_DONE (10)
//#define NUM_INTERRUPTS (TX_PARR_DONE+1)
#define RX_FC_NTR (11)
#define RX_QTP_DONE (12)      //Added to run QTP twice in a frame to generate PRBS for 8192 tones.
#define NUM_INTERRUPTS (RX_QTP_DONE+1)

// Constants for disabling all interrupts
#define TX_ALL (-1)
#define RX_ALL (-1)

#define STACK_SIZE   (5)
#define NUM_THREADS  (2)
#define NUM_TCB_BUFFERS NUM_INTERRUPTS  //(13)
// Increased background buffer size from 5 to 10. This was done to cope with the additional backround buffer demand
// the value of 15 was determined by testing and supervising gus_DSH_skip_BGF_add. With a value of 15 we rarely need to skip adding debug stream background function
#define NUM_BG_BUFFERS (15)
#define THREAD0      (0*4096)
#define THREAD1      (1*4096)
#define FGTASK0      (0)
#define FGTASK1      (1)

#define LOADING_FUNCTION_FIFO_SIZE  (10)   // defines the length of the fifo used
                                           // to hold the Tx and Rx Loading functions

// used for gs_TCStateID
#define PROCTONE_TX_TC_START        (1)
#define PROCTONE_TX_TC_END          (2)
#define PROCTONE_RX_TC_START        (3)
#define PROCTONE_RX_TC_END          (4)
#define PROCTIME_RX_TC_START        (5)
#define PROCTIME_RX_TC_END          (6)
#define SHOWTIME_TX_QT_TC_START     (7)
#define SHOWTIME_TX_QT_TC_END       (8)
#define SHOWTIME_RX_QT_TC_START     (9)
#define SHOWTIME_RX_QT_TC_END       (10)
#define SHOWTIME_RX_FC_TC_START     (11)
#define SHOWTIME_RX_FC_TC_END       (12)
#define BG_TASK_START               (13)
#define BG_TASK_END                 (14)

// used for logging TC & FG tasks for debug purpose
#define TASK_LOG_ARRAY_SIZE         (8) // should be 2^n

typedef void  (*PtrToFunc)(void);
typedef void (LoadingFunction)(void);               // Use for external declarations for all loading functions.
typedef LoadingFunction *PtrToLoadingFunction;
typedef PtrToLoadingFunction LoadingFunctionFifo[]; // Use for external declarations for all loading functions.

/* Task Control Block (TCB) */
typedef struct TCB_tag {
   PtrToFunc      TimeCriticalTask;     /* ptr to time-critical portion  */
   PtrToFunc      NonTimeCriticalTask;  /* ptr to non-time-critical portion */
   int16          TaskID;               /* Bit 15 determines if active, Bit14-12 determines Thread */
   struct TCB_tag *Next;                /* ptr to next TCB in Task Queue */
}TCB_t;


/* Structure used for a queue of task control blocks */
typedef struct {
   TCB_t *Front;
   TCB_t *Rear;
}Queue_t;

/* Structure for Function Fifo */
typedef struct {
   PtrToFunc *FunctionBuffer; /* pointer to buffer of functions */
   int16 BufferSize; /* number of locations in buffer */
   int16 IndexOfOldest;
   int16 NextAvailable;
   int16 PendingFunctionCount;
   int16 ErrorCode;
}FunctionFifo_t;

typedef struct {
   int32 l_bad_intr_cnt;
   int32 l_which_bad_intr;
   int32 l_blink_value;
   int32 l_ilink1_value;
   int32 l_ilink2_value;
} InterruptDebug_t;

/* Functions to set and reset interrupts */

void SetInterrupt(uint16 us_Interrupt);
void ResetInterrupt(uint16 us_Interrupt);

void KernelInit(void);
void MasterIntHandler(void);
void ForegroundHandler(void);

extern int16 gs_FGActive;
extern int16 gs_FGTaskPending;
extern uint8 guc_PortActive;

extern PortModeControl_t gt_PortModeControl;

extern InterruptDebug_t gt_intrpt_debug;
extern int16 gs_BgDbgCnt1;
extern int16 gs_BgDbgCnt2;

extern Queue_t TaskQueue[NUM_THREADS];    //XDSLRTFW-2392 (Cascaded scheduling - Start - End)

#endif /* _MTKERNEL_H */
