/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2006 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
#ifndef _NOMATP_H
#define _NOMATP_H

/**********************************************************************
 *
 * Aware DMT Technology. Proprietary and Confidential.
 *
 * ADDRESS:          40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 * TELEPHONE:        781.276.4000
 * FAX:              781.276.4001
 * WEB:              http://www.aware.com
 *
 * FILE:             nomatp.h
 * DESCRIPTION:      Header file for nomatp.c.
 *
 **********************************************************************/

/**********************************************************************
 * CONSTANTS
 **********************************************************************/
//4312.5 round up
#define SUBCARRIER_SPACE_4KHZ (4313)

//4312.5 * 2
#define SUBCARRIER_SPACE_8KHZ (8625)

//10log(4312.5)*256 in Q8.8
#define LOG_SUBCARRIER_SPACE_4KHZ   (9305)

//10log(4312.5*2)*256 in Q8.8
#define LOG_SUBCARRIER_SPACE_8KHZ   (10076)

/**********************************************************************
 * VARIABLES
 **********************************************************************/

/**********************************************************************
 * FUNCTIONS
 **********************************************************************/
FlagT CalcInitNOMATP(void);
FlagT CalcLinearPsdTable(void);
void CalcNOMATP(int16 *psa_RxFineGains);
void InterpolatePsd(int16 s_LeftBreakPoint, int16 s_RightBreakPoint,
               int16 s_LeftPsdLevel, int16 s_RightPsdLevel,
               int16 s_ToneIdx, int16 *ps_PsdLevel);
void CalcLinearPsd(int16 s_Psd_dB, int16 *ps_Psd_linear, int16 *ps_PsdExp_Linear);
void UpdateNOMATP(int16 s_ToneIdx, int32 l_GainSq);
void CalcFinalNOMATP(void);
void CalcLinearMAXNOMATP(void);
FlagT CheckNOMATPLimit(void);
void SignedAccum48(int32 l_Input, uint32 *pul_Acc48H, uint32 *pul_Acc48L);
#endif /* _NOMATP_H */


