/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2004 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
#ifndef _PLL_H
#define _PLL_H

/**********************************************************************
 *
 * Aware DMT Technology. Proprietary and Confidential.
 *
 * ADDRESS:          40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 * TELEPHONE:        781.276.4000
 * FAX:              781.276.4001
 * WEB:              http://www.aware.com
 *
 * FILE:             pll.h
 * DESCRIPTION:      Header file for PLL functions.
 *
 **********************************************************************/

/**********************************************************************
 * CONSTANTS
 **********************************************************************/
#define PLL_NOT_LOCKED              (0) /* PLL in acquisition mode */
#define PLL_LOCKED               (1) /* PLL in tracking mode   */
#define PLL_PI_RADIANS        (25736) /* 25736 = pi radians */
#define PLL_HALF_PI_RADIANS      (12868) /* 12868 = pi/2 radians */
#define PLL_QUARTER_PI_RADIANS   (6434) /* 6434 = pi/4 radians */

#define LF_COEF_RSH_CNT    (14)

/* Ki0 and Kp0 are fast-converge parameters */
#define LF_KI0          ((int16)((0.024*(1<<LF_COEF_RSH_CNT))+0.5))
#define LF_KP0          ((int16)((1.22*(1<<LF_COEF_RSH_CNT))+0.5))

/* Ki1 and Kp1 are slow-converge parameters */
#define LF_KI1          ((int16)((0.00049*(1<<LF_COEF_RSH_CNT))+0.5))
#define LF_KP1          ((int16)((0.03125*(1<<LF_COEF_RSH_CNT))+0.5))

#define PLL_STATE_UNLOCK   (0)                           /* PLL unlock state */
#define PLL_STATE_LOCK     (1)                         /* PLL lock state */

#define PLL_ACQUISITION_LEN0  (130)
#define PLL_ACQUISITION_LEN1  (650)

#define PLL_STABILIZATION_LEN_DIS  (-1)
#define PLL_STABILIZATION_LEN_300  (300)
#define PLL_STABILIZATION_LEN_650  (650)


#define MAXIMUM_PHASE_ERRORS_IN_LOG   (300)

//#define   PHASE_ERROR_p00_to_p11deg      4
//#define   PHASE_ERROR_p10_to_p22deg      0

#define   PHASE_ERROR_p00_to_p22deg      0
#define   PHASE_ERROR_p22_to_p45deg      1
#define   PHASE_ERROR_p45_to_p90deg      2
#define   PHASE_ERROR_p90_to_p180deg     3
#define   PHASE_ERROR_m22_to_m45deg     -1
#define   PHASE_ERROR_m45_to_m90deg     -2
#define   PHASE_ERROR_m90_to_m180deg    -3
#define   PLL_PI_BY_8_RADIANS_22p5DEG   (3217)// 3217 = pi/8  radians = 22.5 Degree

//#define   PLL_PI_BY_8_RADIANS_11p25DEG  (1608) // 1430 = pi/16 radians = 11.25 Degree


/**********************************************************************
 * VARIABLES
 **********************************************************************/

/**********************************************************************
 * FUNCTIONS
 **********************************************************************/
void ResetPLL(PT_ArrIdx_te ArrayIdx, int16 s_Kp, int16 s_Ki, int16 s_PhaseErrThreshold);
void ResetPllRefTone(PT_ArrIdx_te ArrayIdx, PilotConfig_t *pt_PilotConfig, int16 *ps_InTone_Real, int16 *ps_InTone_Imag, int16 s_NumPllRefTones);
void RotatePilotRef(int16 X, int16 Y);
void PLL(PT_ArrIdx_te UsedPilot);
void ScalePLL(int16 s_scaling);
void ConvertDataToPllRef(int16 *sa_DataTone);
void PllScalingCalc(int16 s_pilotTone, int16 *ps_scaling);
void RunPLL(void);
int16 MapPllRefTone(PT_ArrIdx_te ArrayIdx, int16 s_PhaseError);
void PllPhaseOffsetZoneMap(int16 s_PhaseError);

#endif /* _PLL_H */

