/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2004 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
#ifndef _PROFILE_H
#define _PROFILE_H

/**********************************************************************
 *
 * Aware DMT Technology. Proprietary and Confidential.
 *
 * ADDRESS:          40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 * TELEPHONE:        781.276.4000
 * FAX:              781.276.4001
 * WEB:              http://www.aware.com
 *
 * FILE:             profile.h
 * DESCRIPTION:      Header file for profile.c
 *
 **********************************************************************/


 #ifdef VRX518_BRINGUP_DEBUG
 #define CD_REV_SNR_ECHO_OFF_POST_PGA1     0x1
 #define CD_REV_SNR_ECHO_ON_POST_PGA2      0x2
 #define CD_REV_SNR_ECHO_OFF               0x4
 #define CD_ROP_TRAIN1_SNR                 0x8
 #define CA_POST_MEDLEY_SNR                0x10
 #endif  // VRX518_BRINGUP_DEBUG

//-------------------------------------------------------------------
// Debug Trail Control and Delimitters
//-------------------------------------------------------------------

//-------------------------------------------------------------------
// Debug Trail - TRAIL TYPE ENABLES
//-------------------------------------------------------------------

#define DEBUG_TRAIL_STATES_ENABLE            0x0001
#define DEBUG_TRAIL_SUBSTATES_ENABLE         0x0002
#define DEBUG_TRAIL_TONE_ENABLE              0x0004
#define DEBUG_TRAIL_RXHDLC_ENABLE            0x0008
#define DEBUG_TRAIL_EOC_ENABLE               0x0010
#define DEBUG_TRAIL_TXHDLC_ENABLE            0x0020
#define DEBUG_TRAIL_MIPS_ENABLE              0x0040
#define DEBUG_TRAIL_TIMESTAMP_ENABLE         0x0080
#define DEBUG_TRAIL_MAXPHERR_ENABLE          0x0100
#define DEBUG_TRAIL_10_TRAIL_ENABLE          0x0200
#define DEBUG_TRAIL_11_TRAIL_ENABLE          0x0400
#define DEBUG_TRAIL_SHOWTIME_EVENTS_ENABLE   0x0800
#define DEBUG_TRAIL_13_TRAIL_ENABLE          0x1000
#define DEBUG_TRAIL_14_TRAIL_ENABLE          0x2000
#define DEBUG_TRAIL_GHS_ENABLE               0x4000
#define DEBUG_TRAIL_AUTOMSG_TRAIL_ENABLE     0x8000
#define DEBUG_TRAIL_BONDING_TRAIL_ENABLE     0x2000
#define DEBUG_TRAIL_SHOWTIME_CNTRS_ENABLE    0x0001



//-------------------------------------------------------------------
// Debug Trail - SHOWTIME EVENTS TRAIL
//-------------------------------------------------------------------

//Enables
#define DEBUG_TRAIL_SHOW_EVENTS_NE_CRC_ENABLE         0x0001
#define DEBUG_TRAIL_SHOW_EVENTS_FE_CRC_ENABLE         0x0002
#define DEBUG_TRAIL_SHOW_EVENTS_NE_FEC_ENABLE         0x0004
#define DEBUG_TRAIL_SHOW_EVENTS_FE_FEC_ENABLE         0x0008
#define DEBUG_TRAIL_SHOW_EVENTS_NE_LOS_ENABLE         0x0010
#define DEBUG_TRAIL_SHOW_EVENTS_FE_LOS_ENABLE         0x0020
#define DEBUG_TRAIL_SHOW_EVENTS_NE_LOM_ENABLE         0x0040
#define DEBUG_TRAIL_SHOW_EVENTS_FE_LOM_ENABLE         0x0080
#define DEBUG_TRAIL_SHOW_EVENTS_FE_IB_CHANGE_ENABLE      0x0100
#define DEBUG_TRAIL_SHOW_EVENTS_EOC_ENABLE            0x0200
#define DEBUG_TRAIL_SHOW_EVENTS_NE_SHOWFAIL_ENABLE    0x0400
#define DEBUG_TRAIL_SHOW_EVENTS_FE_SHOWFAIL_ENABLE    0x0800
#define DEBUG_TRAIL_SHOW_EVENTS_PILOT_CHANGE_ENABLE      0x1000
#define DEBUG_TRAIL_SHOW_EVENTS_MICROINT_ENABLE       0x2000
#define DEBUG_TRAIL_SHOW_EVENTS_EOC_HEADER_ENABLE     0x4000

//Delimitters
#define DEBUG_TRAIL_SHOW_EVENTS_NE_CRC             0xAA00
#define DEBUG_TRAIL_SHOW_EVENTS_FE_CRC             0xAA10
#define DEBUG_TRAIL_SHOW_EVENTS_NE_FEC             0xBB00
#define DEBUG_TRAIL_SHOW_EVENTS_FE_FEC             0xBB10

#define DEBUG_TRAIL_SHOW_EVENTS_NE_LOS_DEF_OFF        0xCC00
#define DEBUG_TRAIL_SHOW_EVENTS_NE_LOS_DEF_ON         0xCC01
#define DEBUG_TRAIL_SHOW_EVENTS_FE_LOS_DEF_OFF        0xCC10
#define DEBUG_TRAIL_SHOW_EVENTS_FE_LOS_DEF_ON         0xCC11

#define DEBUG_TRAIL_SHOW_EVENTS_NE_LOM_DEF_OFF        0xCC02
#define DEBUG_TRAIL_SHOW_EVENTS_NE_LOM_DEF_ON         0xCC03
#define DEBUG_TRAIL_SHOW_EVENTS_NE_SEF_DEF_OFF        0xCC04
#define DEBUG_TRAIL_SHOW_EVENTS_NE_SEF_DEF_ON         0xCC05

#define DEBUG_TRAIL_SHOW_EVENTS_MICROINT_STATE        0xCC12

#define DEBUG_TRAIL_SHOW_EVENTS_FE_IB_CHANGE       0xCC20
#define DEBUG_TRAIL_SHOW_EVENTS_EOC                0xDD00

#define DEBUG_TRAIL_SHOW_EVENTS_NE_SHOWFAIL           0xEE00
#define DEBUG_TRAIL_SHOW_EVENTS_FE_SHOWFAIL           0xEE01
#define DEBUG_TRAIL_SHOW_EVENTS_PILOT_CHANGE       0xEE10

// s_debugTrailPrevEvent
#define DEBUG_TRAIL_SHOW_PREEVENT_NE_CRC_ON        0x0001
#define DEBUG_TRAIL_SHOW_PREEVENT_FE_CRC_ON        0x0002
#define DEBUG_TRAIL_SHOW_PREEVENT_NE_LOS_ON        0x0004
#define DEBUG_TRAIL_SHOW_PREEVENT_FE_LOS_ON        0x0008
#define DEBUG_TRAIL_SHOW_PREEVENT_NE_LOM_ON        0x0010
#define DEBUG_TRAIL_SHOW_PREEVENT_PILOT_ON         0x0020


//-------------------------------------------------------------------
// Debug Trail - SHOWTIME COUNTERS TRAIL
//-------------------------------------------------------------------

//Enables
#define DEBUG_TRAIL_SHOW_CNTRS_NE_CRC_ENABLE       0x0001
#define DEBUG_TRAIL_SHOW_CNTRS_FE_CRC_ENABLE       0x0002
#define DEBUG_TRAIL_SHOW_CNTRS_NE_FEC_ENABLE       0x0004
#define DEBUG_TRAIL_SHOW_CNTRS_FE_FEC_ENABLE       0x0008
//#define DEBUG_TRAIL_SHOW_CNTRS_tbd_ENABLE        0x0010   //rsvd
//#define DEBUG_TRAIL_SHOW_CNTRS_tbd_ENABLE        0x0020   //rsvd
#define DEBUG_TRAIL_SHOW_CNTRS_NE_SNRM_ENABLE         0x0040
#define DEBUG_TRAIL_SHOW_CNTRS_FE_SNRM_ENABLE         0x0080


//Delimitters
#define DEBUG_TRAIL_SHOW_CNTRS_NE_CRC              0xA000
#define DEBUG_TRAIL_SHOW_CNTRS_FE_CRC              0xA010
#define DEBUG_TRAIL_SHOW_CNTRS_NE_FEC              0xB000
#define DEBUG_TRAIL_SHOW_CNTRS_FE_FEC              0xB010

#define DEBUG_TRAIL_SHOW_RSVD1                     0xC000
#define DEBUG_TRAIL_SHOW_RSVD2                     0xC010
#define DEBUG_TRAIL_SHOW_CNTRS_NE_SNRM             0xC002
#define DEBUG_TRAIL_SHOW_CNTRS_FE_SNRM             0xC012


/**********************************************************************
 * FUNCTIONS
 **********************************************************************/
#ifdef DEBUG_TRAIL
void DebugTrail1(int16 s_count, ... );
#endif // DEBUG_TRAIL
void TxProfileHandler(void);
void RxProfileHandler(void);


#ifdef PROFILE_TASKS
int16 LogTaskProfile(int16 s_TimeLabelId, int16 s_StartTime);
#endif

#ifdef PROFILE_TASKS_VR9
//void LogTaskProfile(int16 s_TimeLabelId,  int32 l_StartTime);
int32 LogTaskProfile(int16 s_TimeLabelId,  int32 l_StartTime);
#endif

#endif /* _PROFILE_H */

