/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2004 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   filename: showtime.h
*
*   Header file for showtime Tx/Rx TC and FG code.
*
*-------------------------------------------------------------------------------
*/

#ifndef _SHOWTIME_H
#define _SHOWTIME_H

//Showtime debug control bitmap
#define  TX_SET_FC_REGISTER_START                  (0x1)
#define  TX_SET_XTC_REGISTER_START                 (0x2)
#define  TX_ENABLE_MULTIPLE_AZ_RUNS                (0x4)
#define  TX_DISABLE_SCRAMBLE_BITREVERSE_CRC           (0x8)
#define  RX_SET_FC_REGISTER_START                  (0x10)
#define  RX_DISABLE_SCRAMBLE_BITREVERSE_CRC           (0x20)
#define  DISABLE_EOC_OVHD_MESSAGING                (0x40)
#define  VDSL1_TX_EOC_SWAP_ADDRESS_CONTROL_FIELD         (0x80)
#define  VDSL1_TX_EOC_SWAP_LSB_MSB_DATA_FIELD         (0x100)
#define  VDSL1_TX_EOC_SEND_ECHO_FAR_END_FCS           (0x200)
#define  VDSL1_RX_EOC_IGNORE_FAR_END_FCS              (0x400)
#define  VDSL1_RX_EOC_SWAP_ADDRESS_CONTROL_FIELD         (0x800)
#define  VDSL1_RX_EOC_SWAP_LSB_MSB_DATA_FIELD         (0x1000)
#define  VDSL1_RX_EOC_PROCESS_OPCODE_IN_READ_WRITE_STATE (0x2000)
#define  VDSL1_RX_REFORMAT_LATTN_FOR_CNXT_FAREND         (0x4000)
#define  VDSL1_RX_REFORMAT_SNRM_FOR_CNXT_FAREND       (0x8000)
#define  VDSL1_DISABLE_IB_VOC                   (0x10000)
#define VDSL2_START_WITH_REVERB_FOR_SYNC_SYMBOL       (0x40000)
#define VDSL2_USE_SHOWTIME_LIKE_CONST_MAP_FOR_SYNC_SYMBOL   (0x80000)
#define DISABLE_ZEP_TX_SCRAMBLE                    (0x100000)
#define DISABLE_ZEP_RX_SCRAMBLE                    (0x200000)

// VDSL2 function prototypes

// ShowtimeTxTC_VDSL2.c
void ShowtimeTxTC_VDSL2(void);

// ShowtimeTxF_VDSL2.c
void ShowtimeTxF_VDSL2(void);

// ShowtimeRxTC.c
void ShowtimeRxTC_QT_VDSL2(void);
void ShowtimeRxTC_FC_VDSL2(void);

// ShowtimeRxF_VDSL2.c
void ShowtimeRxF_QT_VDSL2(void);
void ShowtimeRxF_FC_VDSL2(void);
void RxDataFrameProcess_VDSL2(void);

void StartTxDataPath_VDSL2(void);      // Wrapper function for StartTxDataPath
void StartRxDataPath_VDSL2(void);      // Wrapper function for StartRxDataPath

#ifdef PPE_ENGINE
   void DFE_PPE_RxDataStatus_EnterShow(void);
   void DFE_PPE_LinkStatus_TxRxShow(void);
#endif //PPE_ENGINE
// Common function prototypes

// ShowtimeTestControl.c
void ShowtimeTxTCTestControl(void);
void ShowtimeTxFGTestControl(void);
void ShowtimeRxTCTestControl(void);
void ShowtimeRxFGTestControl(void);

#endif // _SHOWTIME_H
