/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C) 2016 Intel Corporation
    Copyright (C), 1994-2005 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
#ifndef _SOCMESSAGE_H
#define _SOCMESSAGE_H

/****************************************************************************
;
;  Aware DMT Technology. Proprietary and Confidential.
;
;   40 Middlesex Turnpike, Bedford, MA 01730-1413
;  Phone (781) 276 - 4000
;   Fax   (781) 276 - 4001
;
;  File Name: socmessage.h
;
;   Special Operation Channel Messaging.
;
'
*****************************************************************************/

#include "hdlc.h"
#include "vdsl_compiler.h"   // #ifdef ANXQ_35BLITE

//VDSL1 message
#define  SOC_MSG_REPEAT_REQUEST                   (0x55)
#define  SOC_MSG_R_ACK                            (0x00)
#define  SOC_MSG_R_NACK                           (0xFF)
#define  SOC_MSG_ACK_SEG                          (0x0F)
#define  SOC_MSG_O_SIGNATURE                      (0x01)
#define  SOC_MSG_O_UPDATE                         (0x02)
#define  SOC_MSG_O_MSG1                           (0x03)
#define  SOC_MSG_O_MSG2                           (0x04)
#define  SOC_MSG_O_CONTRACT                       (0x05)
#define  SOC_MSG_O_BG                             (0x06)
#define  SOC_MSG_R_MSG1                           (0x81)
#define  SOC_MSG_R_MSG2                           (0x82)
#define  SOC_MSG_R_CONTRACT1                      (0x83)
#define  SOC_MSG_R_MARGIN                         (0x84)
#define  SOC_MSG_R_BG                             (0x85)

//VDSL2 message code
#define  VDSL2_SOC_MSG_O_SIGNATURE                (0x01)
#define  VDSL2_SOC_MSG_O_UPDATE                   (0x02)
#define  VDSL2_SOC_MSG_O_PRM                      (0x04)
#define  VDSL2_SOC_MSG_R_MSG                      (0x81)
#define  VDSL2_SOC_MSG_R_UPDATE                   (0x82)
#define  VDSL2_SOC_MSG_R_PRM                      (0x84)
#define  VDSL2_SOC_MSG_O_ACK                      (0x00)
#define  VDSL2_SOC_MSG_O_TA_UPDATE                (0x05)
#define  VDSL2_SOC_MSG_R_TA_UPDATE                (0x85)
#define  VDSL2_SOC_MSG_O_MSG1                     (0x03)
#define  VDSL2_SOC_MSG_R_MSG2                     (0x83)
#define  VDSL2_SOC_MSG_O_TPS                      (0x06)
#define  VDSL2_SOC_MSG_R_TPS_ACK                  (0x86)
#define  VDSL2_SOC_MSG_O_PMS                      (0x07)
#define  VDSL2_SOC_MSG_R_PMS                      (0x87)
#define  VDSL2_SOC_MSG_O_PMD                      (0x08)
#define  VDSL2_SOC_MSG_R_PMD                      (0x88)
#define  VDSL2_SOC_MSG_R_ACK                      (0x80)

//Diagnostic mode message code
#define  VDSL2_SOC_MSG_O_PRM_LD                 (0x09)
#define  VDSL2_SOC_MSG_O_MSG_LD                 (0x0A)
#define  VDSL2_SOC_MSG_R_PRM_LD                 (0x89)
#define  VDSL2_SOC_MSG_R_MSG_LD                 (0x8A)

#define  NUM_TONE_CLUSTERS_FOR_MSG_DECODING       (3)

//Message decoding state
#define MSG_DECODE_IN_PROGRESS (0)
#define MSG_DECODE_DONE       (1)

#define ACK_MSG               (0) //send R/O-ACK message
#define NACK_MSG              (1) //send R/O-NACK message

#define NUM_RESEND_O_UPDATE   (3) //the number of times to resend O-UPDATE if it is not
                                 //respensed correctly
#define NUM_TX_REPEAT_REQUEST    (0) //the maximum number of times to send REPEAT_REQUEST
#define JMAX   (0)               //jmax in messge O/R-Msg2

#define RECEIVE_ACK_SEG_IDLE  (0) //not expect ACK-SEG
#define RECEIVE_ACK_SEG_EXP    (1) //expect to receive ACK-SEG
#define RECEIVE_ACK_SEG_DONE  (2) //ACK-SEG has been received

//XDSLRTFW-1619: VDSL_CI_Policy1_2 (Start)
// TPS-TC Options
// Pre-emption (bit 0)
#define TPS_TC_OPTION_PREEMPT                       (0x1u)
// Short Packet mode (bit 1)
#define TPS_TC_OPTION_SHORTPACKET                   (0x2u)
// CI-policy Max INP
#define TPS_TC_OPTION_CIP_MAX_INP                   (0x4u)
// CI-policy Max Net rate then Margin
#define TPS_TC_OPTION_CIP_MAX_NETRATE_THEN_SNRM     (0x8u)
//XDSLRTFW-1619: VDSL_CI_Policy1_2 (End)

//SOC message debug control bitmap
#define CHECK_MSG_LENGTH_MATCH                     (0x1)
#define TX_FLIP_01_SENSE                            (0x10)
#define TX_SKIP_HDLC_FCS_INVERSION                 (0x20)
#define TX_SWITCH_HDLC_FCS_BYTEORDER               (0x40)
#define TX_BIT_REVERSE_HDLC_FCS                    (0x80)
#define RX_FLIP_01_SENSE                           (0x100)
#define RX_INVERT_HDLC_FCS                            (0x200)
#define RX_SWITCH_HDLC_FCS_BYTEORDER               (0x400)
#define RX_BIT_REVERSE_HDLC_FCS                    (0x800)
#define IGNORE_FAREND_CE                           (0x1000)
#define IGNORE_FAREND_TA                           (0x2000)
#define FORCE_M0_I0_EOC1_VOC1                         (0x4000)
#define FORCE_R8_ADAPTIVE_RATE_BITLOAD                (0x8000)
#define FORCE_N144_RCONTRACT1                      (0x10000)
#define FORCE_NEW_BITLOAD_FOR_RMARGIN              (0x20000)
#define TX_FORCE_INTEGER_1_OVER_S                  (0x40000)
#define RX_FORCE_INTEGER_1_OVER_S                  (0x80000)
#define FORCE_RX_MEDLEY_TRAINING_IN_R_O_MSG2       (0x100000)
#define FORCE_GAIN_UPDATE_FIELD_IN_O_UPDATE        (0x200000)
#define IGNORE_M_AND_I_IN_R_CONTRACT_AND_RECOMPUTE    (0x400000)
#define FORCE_I_EQUALTO_N_IF_I_EQUALS_0            (0x800000)
#define OVERRIDE_INTLV_MEM_SIZE                    (0x1000000)
#define APPEND_DSRATE_TO_RMARGINMSG                (0x2000000)
#define CONTROL_TX_TCM_ENABLE_USING_BAT            (0x4000000)
#define FORCE_PSD_DESCRIPTOR_IN_0PT5_dB_FORMAT     (0x8000000)
#define FORCE_IDLE_IN_PERIODIC1                    (0x10000000)
#define FORCE_PERIODIC2_DISABLE                    (0x20000000)
#define WORKAROUND_IKANOS_CO_INIT_TIMING_ADVANCE   (0x40000000)
#define DISABLE_PRBS_RESET_FOR_SYNCHRO6            (0x80000000)

// Defines for variable "gul_dbgSocMsgControl2"
#define SWAP_TONE_INDEX_IN_TRT_MSG_EXCHANGE        (0x0001)
#define DISABLE_APPLY_BAND_LIMIT                   (0x0002)
#define AMENDMENT1_OMSG1_SRA_SUPPORT                (0x0010)
#define AMENDMENT1_OTPS_MAX_DELAY_VAR_SUPPORT       (0x0020)
#define AMENDMENT1_OPMS_MAX_DELAY_OCTET_SUPPORT     (0x0040)
#define AMENDMENT1_OPMD_INITIALIZATION_STAT_SUPPORT (0x0080)
#define AMENDMENT2_OSIG_UPBO_SUPPORT                (0x0100)
#define AMENDMENT3_OMSG1_SOS_ROC_SUPPORT            (0x0200)
#define AMENDMENT5_RETX_SUPPORT                     (0x0400)
#define AMENDMENT5_VECTORING_SUPPORT                (0x0800)
#define AMENDMENT7_AELM_SUPPORT                     (0x1000)
#define AMENDMENT7_TIME_SYNC_SUPPORT                (0x2000)


// amendment not compliance bit masks
#define AMEND1_NOT_COMPLIED_IN_OMsg1                (0x000001)
#define AMEND1_NOT_COMPLIED_IN_OTps                 (0x000002)
#define AMEND1_NOT_COMPLIED_IN_OPms                 (0x000004)
#define AMEND1_NOT_COMPLIED_IN_OPmd                 (0x000008)

#define AMEND2_NOT_COMPLIED_IN_OSignature           (0x000010)

#define AMEND3_NOT_COMPLIED_IN_OMsg1                (0x000100)
#define AMEND3_NOT_COMPLIED_IN_OTps                 (0x000200)
#define AMEND3_NOT_COMPLIED_IN_OPms                 (0x000400)

#define AMEND5_NOT_COMPLIED_IN_OSignature           (0x001000)
#define AMEND5_NOT_COMPLIED_IN_OUpdate              (0x002000)
#define AMEND5_NOT_COMPLIED_IN_OPrm                 (0x004000)
#define AMEND5_NOT_COMPLIED_IN_OTaUpdate            (0x008000)
#define AMEND5_NOT_COMPLIED_IN_OMsg1                (0x010000)
#define AMEND5_NOT_COMPLIED_IN_OTps                 (0x020000)
#define AMEND5_NOT_COMPLIED_IN_OPms                 (0x040000)
#define AMEND5_NOT_COMPLIED_IN_OPmd                 (0x080000)

#define AMEND6_NOT_COMPLIED_IN_OSignature           (0x100000)
#define O_SIG_FIELD24_NOT_COMPILED_IN_OSignature    (0x200000)

//O-Signature interpretation error code
#define O_SIG_FIELD2_BANDS_DS                       (0x0001)
#define O_SIG_FIELD3_BANDS_US                       (0x0002)
#define O_SIG_BAND_OVERLAP                          (0x0004)
#define O_SIG_FIELD4_PSD_DS                         (0x0008)
#define O_SIG_FIELD5_PSD_US                         (0x0010)
#define O_SIG_FIELD6_1                              (0x0020)
#define O_SIG_FIELD7_1                              (0x0040)
#define O_SIG_FIELD9_1                              (0x0080)
#define O_SIG_FIELD16_1                             (0x0100)
#define O_SIG_FIELD17_1                             (0x0200)
#define O_SIG_FIELD18_1                             (0x0400)
#define O_SIG_FIELD19_1                             (0x0800)
#define O_SIG_FIELD21_VEC_BANDS_DS                  (0x1000)
#define O_SIG_FIELD21_VEC_PILOT_SEQ_US              (0x2000)
#define O_SIG_FIELD21_VEC_XTALK_LINK                (0x4000)
#define O_SIG_FIELD24_VEC_FDPS_NOT_SUPPORTED        (0x8000)

// Used to communicate between Tx and Rx state machine in VDSL1 mode
#define  DELAY_R_MSG2               (0)
#define  READY_R_MSG2               (1)

#define O_R_P_SYNCHRO1_DETECT_DONE  (1)
#define O_P_SYNCHRO1_SENT           (1)
//#ifdef MTK_VECTORING_SUPPORT
#define O_SIG_FIELD21_G9935_VCE_INFO_BLOCKFIELD8_NUMBYTES  (10)
#define O_SIG_FIELD21_G9935_VTUR_ID_BLOCKFIELD9_NUMBYTES    (4)
#define O_TA_UPDATE_G9935_MAX_N_BANDS                       (8)
//#endif

// XDSLRTFW-3581 (Start)
// Decoding of showtime backchannel encapsulation in O-PMS
#define SHOWTIME_BACKCHANNEL_EOC_ENCAPSULATION        (0x0)
#define SHOWTIME_BACKCHANNEL_L2_ENCAPSULATION         (0x1)
// XDSLRTFW-3581 (End)

// ***********************************
// Descriptors:
// ***********************************
// TwelveBitsPair_t: Two 12-bits numbers (First and Second) spread out over 3 bytes (24bits):
typedef struct
{
   uint8  uc_Byte0; // = First & 0x0FF
   uint8  uc_Byte1; // = Second & 0x00F | First & 0xF00
   uint8  uc_Byte2; // = Second & 0xFF0
} TwelveBitsPair_t;

// Decoded PSD descriptor
typedef struct
{
   uint8  uc_NumTones;
   int16  sa_ToneIndex[MAX_NUM_PSD_POINTS];
   int16  sa_PSDLevel[MAX_NUM_PSD_POINTS];
} DecPSD_Descriptor_t;


// ***********************************
// Training State Messages:
// ***********************************
//Decoded O-Signature Message
typedef struct
{

   uint8    uc_PSDMaskSel;
   uint8    uc_BetaLength;
} DecMsg_O_Signature_t;

//Decoded O-Update Message
typedef struct
{
   int16  s_GainUpdateNumTones;
   int16  s_TimingAdvance;
} DecMsg_O_Update_t;

typedef struct
{
   uint8    uc_EcTrainFlag;
} DecMsg_R_Msg1_t;

// TonePSDPair_t is used to initialize TwelveBitsPair_t structures.
typedef struct
{
   int16  s_ToneIndex; // range: 0-4095
   int16  s_PSDLevel;  // dBm/Hz in 0.5 dBm/Hz increments, offset by -140 dBm/Hz
} TonePSDPair_t;


// ***********************************
// Analysis & Exchange State Messages:
// ***********************************
//
typedef struct
{
   uint8  uc_I;
   uint8  uc_q;
   uint8  uc_Mmin;
   uint8  uc_Mmax;
} Inlv_Descriptor_t;

// O-Msg2 and R-Msg 2 Message
typedef struct
{
   int8   c_MinSNRMargin;         //in O-MSG2 only
   int8   c_MaxConsSize;            //DS for O-MSG2, and US for R-MSG2
   int8   c_RSSetting;
   int8   c_InlvSetting;
   Inlv_Descriptor_t *pta_DetailedInlvSetting;
   uint8  uc_MaxPower;           //in steps of 0.25dBm, DS for O-MSG2, and US for R-MSG2
   uint8  uc_MaxInlvDelay;       //In O-MSG2 only
   int32  l_MaxInlvMemory;       //in R-MSG2 only
   int8   c_MaxEOCBytesPerFrame; //DS for O-MSG2, and US for R-MSG2
   int8   c_MaxVOCBytesPerFrame; //DS for O-MSG2, and US for R-MSG2
   int8   c_ExpressBSSupported;
   uint8  uc_jmax;
} R_O_Msg2_t;

typedef struct
{
   uint16 us_rate[NUM_DATA_PATHS];     //rate in terms of 64kbps
   uint16 us_cw_size[NUM_DATA_PATHS];  //codeword size
   uint16 us_R[NUM_DATA_PATHS];        //no. of RS check bytes per codeword
   uint16 us_I[NUM_DATA_PATHS];        //interleaving block size (not used for fast path, initialized to codeword size)
   uint16 us_M[NUM_DATA_PATHS];        //interleave depth = D = M*I+1 (not used for fast path, initialized to 0)
} Contract_t;

//#ifdef MTK_VECTORING_SUPPORT
typedef struct
{
   uint8  uc_MsgLength;
   uint8  uc_MaxFEXTsymbPerSuperFrame;
   uint8  uc_Optn_ParBackChannel;
} R_Msg1_G993_5;
//#endif //MTK_VECTORING_SUPPORT
//Functions in SocMsgs_Common.c
void InitTwelveBitsPair(int16 First, int16 Second, TwelveBitsPair_t *Pair);
int16 CheckMsgCode(HDLC_Fifo_attrib_t *pt_FIFO);
void BkgdInterpretMsg(void);

int16 CalculatePSD(int16 s_psdLevelOfTone, int16 s_power);

int16 InterpMsg_RT_VDSL2(uint8 uc_MsgCode);
void InitBitloadParam_CPE(void);


// VDSL2 structures
//Decoded O-Signature Message
typedef struct
{
   uint16 us_MaxTargetLineRate;
   uint16 us_DS_TxWinLen;
   int16    s_DS_CyclicPrefix;
   int16  s_InitValTimingAdv;
   uint8  uc_SnrMode;
} DecMsg_O_Signature_VDSL2_t;

typedef struct
{
   uint8  uc_NumTones;
   uint16 sa_ToneIndex[16];
} PilotTone_VDSL2_t;

typedef struct
{
   int16  s_EstimateElecLen;
   PilotTone_VDSL2_t t_PilotTones;
   int16    s_TimingAdvance;
   uint8    uc_O_P_PILOTSetting;
   uint16 us_UsTxWinLen;
   uint16 us_UsTxCpLen;
} DecMsg_R_Msg_VDSL2_t;

typedef struct
{
   int16  s_FinalElecLen;
   int16  s_Proposed_US_PSDCeiling;
   uint16 us_HighestAllowed_US_Tone;
   uint16 us_LowestAllowed_US_Tone;

   // There is a global var for this
   int16  s_TimingAdvanceCorrection;
} DecMsg_O_Update_VDSL2_t;

typedef struct
{
   int16  s_Proposed_DS_PSDCeiling;
   uint16 us_ProposedHighest_DS_Tone;
   uint16 us_ProposedLowest_DS_Tone;
   uint16 us_SuggestedCyclicExtension;
} DecMsg_R_Update_VDSL2_t;

typedef struct
{
   uint8  uc_NumTones;
   int16  sa_ToneIndex[MAX_NUM_DS_TSSI_PSD_POINTS];
   int16  sa_LogTssiVal[MAX_NUM_DS_TSSI_PSD_POINTS];
} DecLogTssiDescriptor_VDSL2_t;

typedef struct
{
   int16  s_CELength;
   int16  s_DsCpLength;
   int16  s_DsBetaLength;
   int16  s_VTUO_IDFTSize;
   uint8  uc_Duration_VTUO_ECTraining;
   uint8  uc_Duration_VTUO_TEQTraining;
   uint8  uc_Duration_VTUR_TEQTraining;
   uint8  uc_DurationPeriodicSignal;
   DecLogTssiDescriptor_VDSL2_t t_DS_fdSpectrumShaping;
} DecMsg_O_Prm_VDSL2_t;

//#ifdef MTK_VECTORING_SUPPORT
typedef struct
{
   uint8  uc_Nband;
   uint8  uc_Padding;
   uint8  uc_Fblock ;
   uint16 usa_VectoredBandParams[O_TA_UPDATE_G9935_MAX_N_BANDS];
   uint8  uc_SOCRepetitionFactor;
   uint8  uc_FEXTSymbolsPerSF;
} G9935_O_TA_Update_Prm_VDSL2_t;
//#endif
typedef struct
{
   int16  s_TimeAdv;    // time advance
   uint8  uc_Bex_ds_O; // Desired number of bytes per DMT symbol in downstream
                       // during exchange phase
   uint8  uc_Bex_us_O; // Desired number of bytes per DMT symbol in downstream
                       // during exchange phase
//#ifdef MTK_VECTORING_SUPPORT
   G9935_O_TA_Update_Prm_VDSL2_t t_G9935_O_TA_Update_Prm;
//#endif
} DecMsg_O_TA_Update_VDSL2_t;


typedef struct
{
   int16  s_UsCpLength;
   int16  s_UsBetaLength;
   int16  s_VTUR_IDFTSize;
   uint8  uc_Duration_VTUR_ECTraining;
   uint8  uc_Duration_VTUR_TEQTraining;
   uint8  uc_Duration_VTUO_TEQTraining;
   uint8  uc_DurationPeriodicSignal;
   uint8  uc_DurationRPTrainingSignal;
} DecMsg_R_Prm_VDSL2_t;


typedef struct
{
   int16  s_CurrTimingAdvance;
   int16  s_TimingAdvanceCorrection;
   int16  s_MaxValTimingAdv;
   uint8  uc_Bex_ds_R;                  // Desired number of bytes per DMT symbol in downstream
                                       // during exchange phase
   uint8  uc_Bex_us_R;                  // Desired number of bytes per DMT symbol in downstream
                                       // during exchange phase
} DecMsg_R_TA_Update_VDSL2_t;

// O-MSG1 and R-MSG2 macros and struct typedefs
#define TPS_TC_STM_BC0_SUPPORT   (1<<7)
#define TPS_TC_ATM_BC0_SUPPORT   (1<<6)
#define TPS_TC_PTM_BC0_SUPPORT   (1<<5)
#define TPS_TC_STM_BC1_SUPPORT   (1<<3)
#define TPS_TC_ATM_BC1_SUPPORT   (1<<2)
#define TPS_TC_PTM_BC1_SUPPORT   (1<<1)


 // XDSRTFW-442: Feature_All_All_All_All_Vdsl2Sra [Start]
//RA mode definations
#define INFO2_RA_Mode_MANUAL             1
#define INFO2_RA_Mode_AT_INIT            2
#define INFO2_RA_Mode_DYNAMIC            3
#define INFO2_RA_Mode_SOS_DYNAMIC        4
// XDSRTFW-442: Feature_All_All_All_All_Vdsl2Sra [End]

// TPS-TC (bearer channel) control
typedef struct
{
   uint16 us_MinNetDataRate;         // in multiple of 8kbps
   uint16 us_MaxNetDataRate;         // in multiple of 8kbps
   uint16 us_MinResNetDataRate;      // in multiple of 8kbps
   int16  s_MaxLatency;              // Maximum interleaving delay
   uint8  uc_IMAxINP;                // Impulse noise protection and dynamic interleaver reconfiguration
   uint8  uc_TPSTCoptions;
} TPS_TC_Type_SOC_t;

typedef struct
{
   int16  s_Control;
   TPS_TC_Type_SOC_t ta_TpsTcType[MAX_TPS_TC_TYPE];
} TPS_TC_BearerChannel_SOC_t;

// TPS-TC (bearer channel) control
typedef struct {
   int16 s_TypeEnabled;
   TPS_TC_Type_SOC_t ta_TpsTcType;
} TPS_TC_BearerChanAct_t;

typedef struct
{
   uint16 us_MaxDataRate;           // in multiple of 8kbps
   int16  s_MaxR;
   int16  s_MaxD;
} PMS_TC_LatencyPathAct_t;

typedef struct
{
   uint8  uc_RAMode;                                         // Rate-adaptive mode
   uint8  uc_NTRCap;                                         // Ability to transport NTR in the ds direction

   uint8  uc_MaxNumDsTpsTcs;                                 // Maximum number of DS TPS-TCs of each type
   uint8  uc_MaxNumUsTpsTcs;                                 // Maximum number of US TPS-TCs of each type
   uint8  uc_DsBcAndTpsTcs;                                  // Supported combinations of DS bearer channels and TPS-TCs
   uint8  uc_UsBcAndTpsTcs;                                  // Supported combinations of US bearer channels and TPS-TCs

   TPS_TC_BearerChannel_SOC_t ta_DsBC[NUM_BEARER_CHANNELS];  // Supported DS TPS-TCs
   TPS_TC_BearerChannel_SOC_t ta_UsBC[NUM_BEARER_CHANNELS];  // Supported US TPS-TCs

   uint8  uc_DsDynamicIlv;                                   // DS dynamic interleaver in unit of 8kbps
   uint8  uc_UsDynamicIlv;                                   // US dynamic interleaver in unit of 8kbps

   uint8  uc_DsOvhdRate;                                     // DS overhead messaging rate in kbps
   uint8  uc_UsOvhdRate;                                     // US overhead messaging rate in kbps

   int16  s_DsMaxDataRate[NUM_DATA_PATHS];                  // DS max data rate per latency path
   int16  s_UsMaxDataRate[NUM_DATA_PATHS];                  // US max data rate per latency path

   uint8  uc_DS1byS;                                           // DS 1/S
   uint8  uc_US1byS;                                           // US 1/S
} DecMsg_O_Msg1_VDSL2_t;

typedef struct
{
   uint8  uc_MaxNumDsTpsTcs;                                 // Maximum number of DS TPS-TCs of each type
   uint8  uc_MaxNumUsTpsTcs;                                 // Maximum number of US TPS-TCs of each type
   uint8  uc_DsBcAndTpsTcs;                                  // Supported combinations of DS bearer channels and TPS-TCs
   uint8  uc_UsBcAndTpsTcs;                                  // Supported combinations of US bearer channels and TPS-TCs

   TPS_TC_BearerChannel_SOC_t ta_DsBC[NUM_BEARER_CHANNELS];    // Supported DS TPS-TCs
   TPS_TC_BearerChannel_SOC_t ta_UsBC[NUM_BEARER_CHANNELS];    // Supported US TPS-TCs

   uint8  uc_DsDynamicIlv;                                   // DS dynamic interleaver
   uint8  uc_UsDynamicIlv;                                   // US dynamic interleaver

   uint8  uc_DsOvhdRate;                                     // DS overhead messaging rate
   uint8  uc_UsOvhdRate;                                     // US overhead messaging rate

   int16  s_DsMaxDataRate[NUM_DATA_PATHS];                  // DS max data rate per latency path
   int16  s_UsMaxDataRate[NUM_DATA_PATHS];                  // US max data rate per latency path

   uint8  uc_DS1byS;                                           // DS 1/S
   uint8  uc_US1byS;                                           // US 1/S
} DecMsg_R_Msg2_VDSL2_t;

typedef struct
{
  uint8   uc_Mapped_DS_FrameBearers_TPSTCs;                  // Mapped configurations of DS frame
                                                             // bearers and TPS-TC types
  uint8   uc_Mapped_US_FrameBearers_TPSTCs;                  // Mapped configurations of US frame
                                                             // bearers and TPS-TC types
  uint8   uc_DS_RateAdaptRatio;                              // DS rate adaption ratio
} DecMsg_O_TPS_VDSL2_t;

typedef struct
{
   uint8  uc_MSG_LP;                                         // Latency path (0 or 1) in which the message based overhead
                                                             // information is to be transmitted
   uint8  uc_Bearers_LPaths_Map;                             // Mapping of bearers to latency paths
   uint8  uc_MSG_C;                                          // Number of bytes in the message based portion of the overhead
                                                             // structure
   uint8  uc_Tp;                                             // The number of MDF in a sub-frame
   uint8  uc_Gp;                                             // The total number of OH bytes in a sub-frame
   uint8  uc_Fp;                                             // Number of OH frames in the super-frame
   uint8  uc_OFT;                                            // OH frame type
   uint8  uc_PER;                                            // Period of the OH frame in ms
   uint8  uc_Bx0;                                            // Number of bytes from bearer0, per mux data frame
   uint8  uc_Bx1;                                            // Number of bytes from bearer1, per mux data frame
   uint8  uc_M0;                                             // The value of Mp for latency path0
   uint8  uc_M1;                                             // The value of Mp for latency path1
   uint8  uc_I0;                                             // The value of Ip for latency path0
   uint8  uc_I1;                                             // The value of Ip for latency path1
   uint8  uc_R0;                                             // The value of Rp for latency path0
   uint8  uc_R1;                                             // The value of Rp for latency path1
   uint16 us_D0;                                             // Interleaver depth Dp for latency path0
   uint16 us_D1;                                             // Interleaver depth Dp for latency path1
   uint16 us_L0;                                             // The value of Lp for latency path0
   uint16 us_L1;                                             // The value of Lp for latency path1
   uint16 us_MaxD0;                                          // Maximal interleaver delay in DS latency path0
   uint16 us_MaxD1;                                          // Maximal interleaver delay in DS latency path1
} DecMsg_PMS_VDSL2_t;

//#ifdef  MTK_VECTORING_SUPPORT  // this portion of can be done combindly with PMS message handling
typedef struct
{
   uint16 us_L2LineID;                                      // Table10-10 G.993.5 Field#4
   uint8  uc_ShowtimeBackChannelEncapsulation;               // Table10-10 G.993.5 Field#2
   uint8  uc_L2VceMacAddress[6];                             // Table10-10 G.993.5 Field#3
} DecMsg_PMS_VDSL2_Vectoring_t;
//#endif  // MTK_VECTORING_SUPPORT
typedef struct
{
   uint8  uc_NumCodedBits;
   uint16 us_GainScaleFactor;
} BitsGainsTable_t;

typedef struct
{
   // Field5 sub-carrier group size (coded)
   PilotTone_VDSL2_t t_PilotTones;
} DecMsg_PMD_VDSL2_t;



// VDSL2 functions

// common
void Skip12Or16BitPairDescriptors(int16 *ps_PtrMsgIndex, int16 s_NumberOfPairs);
void DecodeBands(int16 *ps_PtrMsgIndex, int16 s_NumberOfPairs, uint8 *puca_OctetBuffer,
                 int16 *psa_LSBword, int16 *psa_MSBword);
void Unpack12BitsPair(int16 *ps_PtrMsgIndex, int16 s_NumberOfPairs, uint8 *puca_ByteBuf,
                      int16 *psa_LSBword, int16 *psa_MSBword);
void Unpack16BitsPair(int16 *ps_PtrMsgIndex, int16 s_NumberOfPairs, uint8 *puca_ByteBuf,
                      int16 *psa_LSBword, int16 *psa_MSBword);  // ANXQ_SUPPORT
void Unpack3Bits8Data(uint8 *puca_ByteBuf, uint8 *puca_data);
void UnpackPSD(int16 *ps_PtrMsgIndex, int16 s_NumOfPoints, uint8 *puca_OctetBuffer,
               int16 *ps_MaxNomPSD,
               int16 s_MaxNomPSD,
               PSDDescriptorTable_t *pt_PSDDesc);
void UnpackVNPSD(int16 *ps_PtrMsgIndex, int16 s_NumOfPoints, uint8 *puca_OctetBuffer,
                 PSDDescriptorTable_t *pt_PSDDesc);
void EncodeNumOfSamples(int16 *ps_PtrMsgIndex, int16 s_InputVal, uint8 *puca_TxSocMsg);
void EncodeBands(int16 *ps_PtrMsgIndex, int16 s_NumOfBands,
                 int16 sa_LeftChannel[], int16 sa_RightChannel[],
                 uint8 *puca_TxSocMsg);
void EncodePSDs(int16 *ps_PtrMsgIndex, int16 s_NumOfPoints,
                void *pt_PSDDescriptorTable,
                int16 s_MaxNomPSD, uint8 *puca_TxSocMsg);
void EncodeVNPSDs(int16 *ps_PtrMsgIndex, int16 s_NumOfPoints,
                  PSDDescriptorTable_t * pt_PSDDescriptorTable,
                  uint8 *puca_TxSocMsg);
void EncodeTones(int16 *ps_PtrMsgIndex, int16 s_NumOfTones,
                 int16 *psa_ToneArray, uint8 *puca_TxSocMsg, int16 s_SwapToneTransmission);  // ANXQ_SUPPORT

FlagT UnpackedMsgLengthCheck(int16 s_DecodedMsgLength, int16 s_ActualWholeMsgLength);
void FormORRepeatRqstMsg_VDSL2(void);

void FormMsgLD_VDSL2(void);
int16 InterpMsgLD_VDSL2(void);

void PackQlnHlog_VDSL2(uint8 *puca_OctetBuffer, int16 *ps_idx);
void UnpackQlnHlog_VDSL2(uint8 *puca_OctetBuffer, int16 *ps_idx);
void SaveChannelMeasureInfo(void);
void ProcessCpBeta(uint16 us_CpLength, uint16 BetaLength);

int16 InterpOSignatureMsg_VDSL2(void);
int16 InterpOUpdateMsg_VDSL2(void);
int16 InterpOPrmMsg_VDSL2(void);
int16 InterpOTAUpdateMsg_VDSL2(void);
int16 InterpOMsg1Msg_VDSL2(void);
int16 InterpOTpsMsg_VDSL2(void);
int16 InterpOPmsMsg_VDSL2(void);
int16 InterpOPmdMsg_VDSL2(void);

void FormRMsg1Msg_VDSL2(void);
void FormRUpdateMsg_VDSL2(void);
void FormRPrmMsg_VDSL2(void);
void FormRTAUpdateMsg_VDSL2(void);
void FormRAckMsg_VDSL2(void);
void FormRMsg2Msg_VDSL2(void);
void FormRTpsAckMsg_VDSL2(void);
void FormRPmsMsg_VDSL2(void);
void FormRPmdMsg_VDSL2(void);

void TxSocAckSeg(void);

void LimitBandPlanToHighestTone(int16 *psa_BandLeft, int16 *psa_BandRight, int16 *ps_NumOfBands, int16 s_FakeBandRight);
void GetMaxNomPSDPerBand(int16 *psa_MaxNomPSDBand, PSDDescriptorTable_t *pt_PSDDesc, int16 s_MaxNomPSD, int16 *psa_BandRight, int16 s_NumOfBands);

#endif //_SOCMESSAGE_H
