/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2006 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
#ifndef _STATES_H
#define _STATES_H

/**********************************************************************
 *
 * Aware DMT Technology. Proprietary and Confidential.
 *
 * ADDRESS:          40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 * TELEPHONE:        781.276.4000
 * FAX:              781.276.4001
 * WEB:              http://www.aware.com
 *
 * FILE:             states.h
 * DESCRIPTION:      Header file for functions that implement the state
 *                   machine.
 *
 **********************************************************************/

/**********************************************************************
 * VARIABLES
 **********************************************************************/

#define TX_FOREGROUND_STATE         (1)
#define RX_FOREGROUND_STATE         (2)
#define FOREGROUND_STATE_END        (3)

// Fail states information
typedef struct {
   uint32 ul_ExceptionCode;
   int32 l_TxSymbolCount_AtFail;
   int16 s_TxState_AtFail;
   int16 s_TxSubState_AtFail;
   int32 l_RxSymbolCount_AtFail;
   int16 s_RxState_AtFail;
   int16 s_RxSubState_AtFail;
   // kernel exception debug info:
   int16 s_TaskID;
   int16 s_dummy;         //insert for alignment
   int32 l_TxTimerValue;
   int32 l_RxTimerValue;
   uint16 us_BitloadErrorCode;
   int16 s_ToneReorderErrorCode;
   int16 s_RxMsgErrorCode;
} FailStateInfo_t;

#ifdef DEBUG_ALIGNMENT

/* the alignment variables are used to monitor the relationship between the Tx/RxForground   */
/* functions and the frame timing                                                            */
/* To monitor the alignment, Tx and Rx timers are set to trigger on the Tx and Rx frames     */
/* strobes respectively.  Each will count down from 0x7fff.  Both counters are read at the   */
/* start of RxForeGround and TxForeground.  The RxRx and RxTx variables correspond to the    */
/* Rx timer and Tx timer increments (i.e. 0x7fff - current value) read in RxForeGround.      */
/* Similarly, the TxRx and TxTx variables correspond to the Rx and Tx timer counts           */
/* calculated in TxForeGround.                                                               */

extern int16 gs_RxRxAlignment;
extern int16 gs_RxTxAlignment;
extern int16 gs_TxRxAlignment;
extern int16 gs_TxTxAlignment;
#endif

/**********************************************************************
 * FUNCTIONS
 **********************************************************************/
void TxForeGround(void);
void TxProcessTones(void);
void TxParrReshuffle(void);
void RxForeGround(void);
void RxProcessTones(void);
void RxProcessTime(void);
void EmptyState(void);
void FailTxF(void);
void FailRxF(void);
void EnterFailStates(uint32);
void CheckTimeout(uint32 l_CurrentTimer, uint32 l_TimeoutThreshold, uint32 ul_ErrorCode);

extern void Pause(int16 s_Marker);   //For debug.
#endif /* _STATES_H */
