/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2003 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
#ifndef _SYS_CONST_H
#define _SYS_CONST_H

/****************************************************************************
;  Aware DMT Technology. Proprietary and Confidential.
;
;   40 Middlesex Turnpike, Bedford, MA 01730-1413
;  Phone (781) 276 - 4000
;   Fax   (781) 276 - 4001
;
;  File Name: sys_const.h
;
;  System constants for both CO and CPE.
;
*****************************************************************************/

// ***********************************************************************************************************
// sys_const.h
//
// History
//
// 16/05/2012 Vinjam: Code Pointers connected to Downstream Virtual Noise feature
//            Grep for XDSLRTFW-439: Feature_All_DS_All_All_SupportDsTxRefVirtualNoise
// ************************************************************************************************************
#include "typedef.h"
#include "vdsl_compiler.h"   // #ifdef ANXQ_35BLITE

#ifndef C_SCOPE
   #define C_SCOPE
#endif

#ifndef TRUE
#define TRUE         (1)
#endif

#ifndef FALSE
#define FALSE        (0)
#endif

#ifndef FAIL
#define FAIL         (0)
#endif

#ifndef SUCCEED
#define SUCCEED      (1)
#endif

// The range of SDRAM
#define SRAM_START_ADDR  (0x100000)
#define SRAM_END_ADDR    (0x2FFFFF)   // XDSLRTFW-2629 (Start_End)

// Mask bits
#define MASK_BIT0             (0x00000001)
#define MASK_BIT1             (0x00000002)
#define MASK_BIT2             (0x00000004)
#define MASK_BIT3             (0x00000008)
#define MASK_BIT4             (0x00000010)
#define MASK_BIT5             (0x00000020)
#define MASK_BIT6             (0x00000040)
#define MASK_BIT7             (0x00000080)
#define MASK_BIT8             (0x00000100)
#define MASK_BIT9             (0x00000200)
#define MASK_BIT10            (0x00000400)
#define MASK_BIT11            (0x00000800)
#define MASK_BIT12            (0x00001000)
#define MASK_BIT13            (0x00002000)
#define MASK_BIT14            (0x00004000)
#define MASK_BIT15            (0x00008000)
#define MASK_BIT16            (0x00010000)
#define MASK_BIT17            (0x00020000)
#define MASK_BIT18            (0x00040000)
#define MASK_BIT19            (0x00080000)
#define MASK_BIT20            (0x00100000)
#define MASK_BIT21            (0x00200000)
#define MASK_BIT22            (0x00400000)
#define MASK_BIT23            (0x00800000)
#define MASK_BIT24            (0x01000000)
#define MASK_BIT25            (0x02000000)
#define MASK_BIT26            (0x04000000)
#define MASK_BIT27            (0x08000000)
#define MASK_BIT28            (0x10000000)
#define MASK_BIT29            (0x20000000)
#define MASK_BIT30            (0x40000000)
#define MASK_BIT31            (0x80000000)

// Declare common memory block size. This buffer is used to hold:
// 1) 4096 FDQ coefficients (real and imaginary)
// 2) TX/RX SOC message of upto 15 segments. Segment size is upto 2048+4 bytes.
//    Therefore a memory of at least 15*2052bytes = 30780 bytes is needed.
//    (Note: TX and RX soc message use the same buffer.
//           The largest SOC message is R-PMD, which contains B&G and TRT information
//           dependent of the RX bandplan, i.e. NSCds = MEDLEYds set.
//           Therefore the RX-define must be used.
//           R-PMD:
//              8 to 17a:
//                   2 + 2*NSCds + 3*NSCds + x*3 + 3, with x = [0, 16] and NSCds = MEDLEYds set
//              35b:
//                   2 + 2*NSCds + 4*NSCds + x*4 + 3, with x = [0, 16] and NSCds = MEDLEYds set
//
#define  COMMON_MEM_BLOCK_SIZE         (RX_MAX_NUM_TONES*2) // Words

// States Trail buffer length
#define STATES_TRAIL_LENGTH 512

//  training states, which are assigned to guc_TdqTrainingState, guc_FdqTrainingState, and guc_EcTrainingState
#define TRAINING_WAITING               (0)            //  indicate the waiting for training to start
#define TRAINING_IN_PROGRESS           (1)            //  indicate the training is in process
#define TRAINING_DONE                  (2)            //  indicate the training is done

#define STATE_MACHINE_DONE             (-1) // can be used for general state machine to indicate state machine is terminated by setting state to -1

// Note: the compiler switches need to be specified at compile time.

// Compiler switch to configure US FFT related size.
// Note: Although it says FFT here, the lengths also apply to IFFT, depending on CO/CPE config.
#define US_LOG2_FFT_LENGTH_16384  (14)
#define US_LOG2_FFT_LENGTH_8192   (13)
#define US_LOG2_FFT_LENGTH_4096   (12)
#define TX_LOG2_MAX_FFT_LENGTH  US_LOG2_FFT_LENGTH_8192       // log2(IFFT length)
//    #define TX_LOG2_MAX_FFT_LENGTH   US_LOG2_FFT_LENGTH_16384   // log2(IFFT length)
#define TX_MAX_FFT_LENGTH         (1<<TX_LOG2_MAX_FFT_LENGTH)     // TX IFFT length
#define TX_MAX_NUM_TONES          (TX_MAX_FFT_LENGTH>>1)          // TX number of tones

// Compiler switch to configure DS FFT related size
// Note: Although it says FFT here, the lengths also apply to IFFT, depending on CO/CPE config.
#define DS_LOG2_FFT_LENGTH_16384    (14)
#define DS_LOG2_FFT_LENGTH_8192     (13)
#define DS_LOG2_FFT_LENGTH_4096     (12)
#define RX_LOG2_MAX_FFT_LENGTH      DS_LOG2_FFT_LENGTH_16384      // RX log2(FFT length)
#define RX_MAX_FFT_LENGTH           (1<<RX_LOG2_MAX_FFT_LENGTH)      // RX FFT length
#define RX_MAX_NUM_TONES            (RX_MAX_FFT_LENGTH>>1)           // RX number of tones

#define RX_MAX_NUM_TONES_ADSL (512) //max. number of DS tones

// VDSL Bands
// VDSL2 Standard defines upto 32 US/DS bands and 16 RFI/Blackout bands
// For now, we allow a maximum of 9 US/DS/RFI/Blackout bands within our codebase
#define MAX_NUM_US_BANDS         (9)
#define MAX_NUM_DS_BANDS         (9)
#define MAX_NUM_RFI_BANDS        (16)
#define MAX_NUM_BLACKOUT_BANDS   (9)
// MAX_NUM_BANDS is the greater of # of US, DS, RFI and blackout bands.
#define MAX_NUM_BANDS            (16)
#define MAX_NUM_UPBO_BANDS       (8)

// VDSL2 Standard defines upto 64 PSD breakpoints
// For now, we allow a maximum of 32 beakpoints within our codebase
#define MAX_NUM_PSD_POINTS       (64)
#define MAX_NUM_DS_PSD_POINTS    (48)
#define MAX_NUM_DS_REFPSD_POINTS (48)
#define MAX_NUM_US_PSD_POINTS    (32)

//XDSLRTFW-439: Feature_All_DS_All_All_SupportDsTxRefVirtualNoise (Start_End)
#define MAX_NUM_VN_DS_PSD_POINTS (32)

#define MAX_NUM_VN_US_PSD_POINTS (16)

#define MAX_NUM_DS_TSSI_PSD_POINTS     (64)
#define MAX_NUM_DS_RAW_TSSI_PSD_POINTS (16) // it should be 16 since MAX_NUM_DS_PSD_POINTS = 48 (MAX_NUM_RAW_DS_TSSI_PSD_POINTS + MAX_NUM_DS_PSD_POINTS <= MAX_NUM_DS_TSSI_PSD_POINTS)
#define MAX_NUM_US_TSSI_PSD_POINTS     (64)
#define MAX_NUM_US_RAW_TSSI_PSD_POINTS (16) // it can be 32 theoretically since MAX_NUM_US_PSD_POINTS = 32 (MAX_NUM_RAW_US_TSSI_PSD_POINTS + MAX_NUM_US_PSD_POINTS <= MAX_NUM_US_TSSI_PSD_POINTS)

//XDSLRTFW-2260 (Start)
#define MAX_NUM_RX_PATH_GAIN_CALIBRATION_POINTS       (52)
#define MAX_NUM_RX_EXTERNAL_GAIN_CALIBRATION_POINTS   (16)
#define MAX_NUM_TX_EXTERNAL_GAIN_CALIBRATION_POINTS   (32)

     //XDSLRTFW-2260 (End)

#define MAX_NUM_TX_BANDS                  (MAX_NUM_US_BANDS)
#define MAX_NUM_RX_BANDS                  (MAX_NUM_DS_BANDS)
#define MAX_NUM_RX_VEC_BANDS              (8)

#define VDSL_BAND0_LEFT_CHANNEL           (161)
#define VDSL_BAND0_RIGHT_CHANNEL          (857)
#define VDSL_BAND1_LEFT_CHANNEL           (882)
#define VDSL_BAND1_RIGHT_CHANNEL          (1193)
#define VDSL_BAND2_LEFT_CHANNEL           (1218)
#define VDSL_BAND2_RIGHT_CHANNEL          (1959)
#define VDSL_BAND3_LEFT_CHANNEL           (1984)
#define VDSL_BAND3_RIGHT_CHANNEL          (2770)
#define VDSL_BAND4_LEFT_CHANNEL           (2795)
#define VDSL_BAND4_RIGHT_CHANNEL          (4083)

#define LOG2_NUM_CHANNELS_PER_GROUP_10    (10) // Number of tones to process in a group is 1024.
#define NUM_CHANNELS_PER_GROUP_1024       (1 << LOG2_NUM_CHANNELS_PER_GROUP_10)
#define LOG2_NUM_CHANNELS_PER_GROUP_9     (9)  // Number of tones to process in a group is 512.
#define NUM_CHANNELS_PER_GROUP_512        (1 << LOG2_NUM_CHANNELS_PER_GROUP_9)
#define LOG2_NUM_CHANNELS_PER_GROUP_8     (8)  // Number of tones to process in a group is 256.
#define NUM_CHANNELS_PER_GROUP_256        (1 << LOG2_NUM_CHANNELS_PER_GROUP_8)

// Should be combined with RTV_BUF_NUM_TONES!!
#define MAX_LOG2_NUM_CHANNELS_PER_GROUP   (LOG2_NUM_CHANNELS_PER_GROUP_10)
#define MAX_NUM_CHANNELS_PER_GROUP        (1 << MAX_LOG2_NUM_CHANNELS_PER_GROUP) // Maximum number of tones to process in a group.

#define NUM_CHANNELS_PER_CLUSTER          (10)                                   // No. of tones used to modulate 1/2 message bytes

#define PILOT_TONE                        (320) // Must be integer multiple of 320

#define MAX_NUM_ERB_SEGMENTS              (9)

// REVIEW_STEFAN: TBD: How can we calculate exactly: MAX_NUM_BITS_HEADER_CALC and MAX_SIZE_OF_ERB_SEGMENT?
//                     e.g. Ethernet frame length according to ... standard is x bytes
//                          Ethernet header                                    y bytes
//                          Ethernet CRC                                       z bytes
//                          => total max number of payload bytes:          x-y-z bytes

// REVIEW_STEFAN: Following table needs to be reviewed and understood!
// Overhead due to L2 back channel Header:
// PPD = Protocol Payload Data
// Header for L2 Back channel ERB data                             Length | PPD
//------------------------------------                            ------- | ---
// [ 0 -  5]:  VCE MAC Address                                    6 bytes | no
// [ 6 - 11] : VTU-R MAC Address                                  6 bytes | no
// [12 - 13] : Length of segment                                  2 bytes | no
// The length does NOT include preamble/32-bit CRC/DLC addr and length field itself
// An Ethernet frame can no be shorter than 64 bytes total length and no longer than 1518 bytes
//    TO BE VERIFIED: => minimum payload: 64-6-6-2 ???
// The Length field shall equal the length of the protocol payload data, increased with the
//    8-byte LLC SNAP header length, and shall not exceed 1024+8=1032
//    max "PPD VECTOR PAYLOAD"    = 1032 bytes
//                                    -3 bytes LLC header
//                                    -3 bytes ITU-T OUI
//                                    -2 bytes PROTOCOL ID
//                                ------------
//                                 1024 bytes

//    max "Error VECTOR PAYLOAD"  = 1024 bytes PPD VECTOR PAYLOAD
//                                    -2 bytes LINE ID
//                                    -2 bytes Sync-Symbol Count
//                                    -1 byte  Segment Code / end flags
//                                ------------
//                                  1019 bytes

// [14 - 16] : LLC header (0xAA - 0xAA - 0x3)                     3 bytes | no
// [17 - 19] : ITU-T OUI (0x0 - 0x19 - 0xA7)                      3 bytes | no
// [20 - 21] : Protocol ID (0x0 - 0x3)                            2 bytes | no
// [22 - 23] : LINE ID                                            2 bytes | yes
// [24 - 25] : Sync Symbol Count (gs_RxSuperFrmCnt_ForEOC)        2 bytes | yes
// [26]      : guc_SegmentCode + end flag                         1 byte  | yes
// [END-x:END-4] : PADDING (if required)                                  | no
// [END-3:END]   : FCS                                            4 bytes | no

// When the ERB data is more than 1024 byes, segmentation is required.
// REVIEW-STFAN: TBD: Why do we allow following restriction?
// Based on discussions, it was decided that the ERB data for a single tone
// need not be split across 2 segments.
// Hence, to prevent such a scenario we are
// checking the length of data. When data is greater than 1022 bytes, we do a
// segmentation. Thereby the last tone in the segment may lie between 1022 and 1024 bytes.
// And it wont be split across 2 segments or 1024 bytes wont be crossed within a
// segment.
#define MIN_PPD_PROTOCOL_PAYLOAD_DATA_SIZE   (46)
#define MAX_PPD_PROTOCOL_PAYLOAD_DATA_SIZE   (1024)

//=================================================================
//Macros for operations
//=================================================================
#define MAX(A, B) ((A) > (B) ? (A) : (B))
#define MIN(A, B) ((A) < (B) ? (A) : (B))

#endif // _SYS_CONST_H
