/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C) 2016 Intel Corporation
    Copyright (C), 1994-2011 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------------
*
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   filename: vdsl_compiler.h
*
*   Header file for compiler switches.
*
*-------------------------------------------------------------------------------
*/

#ifndef _VDSL_COMPILER_H
#define _VDSL_COMPILER_H

//-----------------------------------------------------------------------------------------------------------------------
// Defines coming from build process
//-----------------------------------------------------------------------------------------------------------------------

   // ****  Common  ****
   // #define ADSL_VDSL_MODE_SWITCH
   // #define ARC6
   // #define DEVELOPMENT
   // #define DMT_SCOPE
   // #define DO_NOT_USE_MDIO_HW
   // #define TARGET_HW
   // #define VR9_AFE
   // #define VDSL_62
   // #define VDSL_CPE

   // ****  Vectoring Build ****
   // #define VECTORING_BUILD
   // #define VECTORING_MEM_LYT
   //

   // **** VR318 Build ****
   // #define VRX318

   // **** VR518 Build ****
   // #define VRX518
   // #define DVRX518_CASCADED_SCHEDULING

//-------------------------------------------------------------------------------------------------------------------------
// Common defines
//-------------------------------------------------------------------------------------------------------------------------

   #define BIT_PATTERN_TEST         // if defined, include the bit pattern test
                                    // enable logging of CW's issued by API; only available under 1-port mode due to memory usage
   #define CUSTOMER_TASKS           // This invokes Customer tasks (which was infineon) and held infineon specfic code.We have converted
                                    // most of these tasks to stubs now, as most of it was either AFE or XTc specific. Removing this cleanly
                                    // could save a little memory.
   #define CLEAR_EOC                // Encapsulation of Clear EOC related code
   #define DEBUG_TRACES
   #define DEBUG_TRAIL
   #define DEBUG_GINP_MSGS
   #define DEBUG_VRX518_AFE
   #define DEBUG_FLOW_TEST
   #define DUAL_LATENCY_VR9
   #define ENABLE_SHOW_LPBK         // enable showtime loopback code
   #define ENABLE_VR9_HW_ERR_CNT    // if defined, log the error counts of core registers eg strymon overflows at diff pts in training
   #define FAST_PATH_CRC_WORKAROUND // added control to turn off TCM in low latency to remove CRCs THIS only kicks in for CO mode!
   #define FLOAT_IN_SW              // Used to invoke home made floating point calculations
                                    // instead of using intel floating point co processor for cocomo sims.
   #define HW_SNR_FDQ               // Share ddsnrfdqHandler.c states for HW based SNR with CO 6.0
   #define HW_VECPOW                // Use new QT feature to cal Vector Power.
   #define HW_TRT                   // Use HW tables for TRT. THis define removes code that kept a SW verion of the TRT in a compressed form.
   #define LOG_PILOT_CONSTELLATION  // include the code for logging the pilot tone constellation
   #define LOG_FA_DEBUG_INFO        // if defined, log frame alignment iterations
   #define PILOT_TONE_LOS_DETECT    // if defined, use the pilot tone power for LOS detection
   #define PORT0_AFE_BYPASS    FALSE
   #define PORT1_AFE_BYPASS    TRUE // need to enable this when AFEs populated on both ports
   #define PPE_ENGINE               // if defined, include PPE configuration code
   #define PROFILE_TASKS_VR9
   #define PROFILE_TASKS_35B        // XDSLRTFW-3362 (Start-End)
   #define VDSL_BONDING
   #define VRX518_SINGAPORE_BRINGUP
   #define VR9_BRINGUP_DBG          // if defined, include the VR9 bringup debug code


//-------------------------------------------------------------------------------------------------------------------------
// Commented out defines
//-------------------------------------------------------------------------------------------------------------------------

   //#define ENABLE_PMS_DONE_INT_FOR_PMS_CYCLE_MEASUREMENT   //if defined, DSP uses Tx & Rx PMS done interrupt for PMS cycle measurement //XDSLRTFW-3322 (Start_End)
   //#define O_SINATURE_PAUSE_DEBUG
   //#define ANXQ_35BLITE_PAUSE_DEBUG
   //#define VRX518_LOG_DEBUG_INFO
   //#define GHS_TN_DBG
   //#define EXTRA_RETX_LOG
   //#define ENABLE_RETX_DS_DEBUG            // Commented Out as this memory being used as RTXus buffer
   //#define ENABLE_THREE_NEEDLE_TEST        // XDSLRTFW-1571 (Start_End)
   //#define ENABLE_RETX_US_DEBUG1
   //#define ILV_DBG_BUFFER                  // 16kbyte debug buffer in interleaver memory. If enabled by define and gft_EnableIlvDbgBuffer the ILV/DILV memory, reported to CO, gets reduced by 32kbyte.
   //#define VR9_ERASURE
   //#define MICROCODE_USE_FIFO3             // if defined use Zephyr microcode which uses FIFO3, this also initialized FIFO3s
   //#define VR9_SAVE_CDPSD
   //#define VR9_DBG_HYB
   //#define MIPS_PROFILE_USRETX
   //#define NTR_INTRPT_POLL_ENABLE          // CPE only, "NTR" must be enabled at the same time
   //#define PROFILE_TASKS                   // VR9 task profiling is done using the different code (under #define PROFILE_TASKS_VR9)
   //#define FORCE_RETX_FRAMING              // XDSLRTFW-3020
   //#define LOG_HMP_CMV_WRITES


//-------------------------------------------------------------------------------------------------------------------------
// Conditional defines
//-------------------------------------------------------------------------------------------------------------------------

#ifdef VRX518_BRINGUP_DEBUG
      #define O_SINATURE_PAUSE_DEBUG
#endif

#ifdef MICROCODE_USE_FIFO3
     #define ZEP_DEBUG_BLD          //if defined, include the code to capture the scrambler in/out data
#endif


//-------------------------------------------------------------------------------------------------------------------------
// Undefines
//-------------------------------------------------------------------------------------------------------------------------

   #undef QT_LATCH_LP_BITS           // QT latches bits needed from Zephyr. HW is not used in Vinax so we do the same - though no
                                     // problem with HW is known.
   // XDSLRTFW-3725 (Start)
   // We are enabling Debug Trail (states trail) be default. This was removed when Tracee was introduced. But since we have
   // not yet migrated to Tracee completely, we need to have support of States Trail
   //#undef DEBUG_TRAIL
   // XDSLRTFW-3725 (End)
#endif // _VDSL_COMPILER_H

