/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C) 2016 Intel Corporation
    Copyright (C), 1994-2006 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   filename: vdsl_const.h
*
*   Header file for shared constant definitions.
*
*-------------------------------------------------------------------------------
*/

// ***********************************************************************************************************
// vdsl_const.h
//
// History
//
// 18/09/2012 Ram: 1. Added code to support ReTx CMV - INFO 229 (to check if DS showtime is in ReTx mode or not)
//                 Grep for: "XDSLRTFW-443: Feature_DS_VDSL2_All_ReTx_CMV_INFO_229"
// 8/11/2012 Kannan: Byte offset 9 of portmode control structure "uc_AfePowerUp" bits b1-0 are used to
//                   indicate the AFE initialization status. This is common for both VR9 & VRX318
//                 Grep for: "XDSLRTFW-542: Platform_VR9_VRX318_AFE_InitStatus"
// 21/05/2013 Fuss: Link drop on CO due to FE LOF indication
//            Grep for XDSLRTFW-947 BUGFIX_US_VDSL2_All_LofIndication
//
// 27/08/2013  Varun : Modified the code to make CMV INFO 229 0 common for both DS and US ReTx
//
// 24/02/2014 Kannan: Changed US0 switching point for 12a oISDN
//                    Grep for XDSLRTFW-1536
// 13/03/2014 Kannan: Added IFX/LANTIQ CO platform ID's
//                    Grep for "XDSLRTFW-1639"
//
// 30/10/2014 Anantha Ramu: Added constants for Intra DTU Interleaving.
//                          Grep for "XDSLRTFW-1617"
//
// 8/10/2014 Vinay: Added code to support reporting of 3 more parameters (Recieve signal, Transmit signal, SOC message) to STAT 0
//                Grep for XDSLRTFW-1901
//
// 23/02/2016 Vinay: Modified the value of LATN of switching point (from 2 bands to 1 band) from 29dB to 30dB
//                   Grep for XDSRTFW-2553
// 07/12/2016 XDSLRTFW-3015 SHINE protection lower than reported : it is a PLL issue!
//            i. Pilot tone phase error saturation value while external noise detected was 1 degree.
//               When long SHINE noise comes, sometime it deviated the pilot tone phase in a way that
//               SHINE noise pulse appeared longer in Rx Path than the original SHINE pulse. As a result,
//               in some corner cases ( eg. SHINE protection 58 DMT symbol, SHINE noise 56 DMT symbol),
//               SHINE protection did not work well. To solved this issue, new pilot tone phase saturation values are introduced.
//
//           ii a. On very short loops, with low power SHINE pulses ( eg. 10 dB more than the background  noise),
//                 external noise detection threshold was not optimum.
//           ii b. On very long loops, where the DS data rates are < 5Mbps and Max Erasure Metric in Showtime is around 10, fixed threshold
//                 for noise detection logic may lead false external noise detection in case of margin verification test.
//                 To solve this issue, new noise detection threshold logic is introduced.
//
//              Grep for: XDSLRTFW-3015
//11/07/2017 Abu Rahman : XDSLRTFW-3554 DS datarate exceeds configured max datarate
//           - Enabled Min-Max Rate check for IKNS and CNXT DSLAMs
//           - Forced LP to the round(Multiple of 8) and then re-compute the rate for IKNS and CNXT DSLAM
//           - Added debug variable to debug framing generation algorithm
//           Grep for XDSLRTFW-3554
//
// 22/11/2017 Abu Rahman
//            XDSLRTFW-3556: VRx518 shows different method_0 attainable datarate than VR9(R7)
//            Introduced a CMV based option to select Method_0 framing based DS ATTNDR or
//            channel capacity based DS ATTNDR calculation algorithm.
//                Set CNFG 86 3 = 0 : to select frame based Method_0 ATTNDR algorithm or
//                Set CNFG 86 3 = 1 : to select channel capacity based Method_0 ATTNDR algorithm (VR9-R7 like)
//            Note that this switching works only with Method_0 configuration
//            SEARCH PATTERN: XDSLRTFW-3556
//
// 02/03/2018 Sriram Shastry : VRX518 VDSL2 Wrong values for LATN & SATN
// The LATN in Band 3 LATN[2] shows sometimes the reseved value 127.1 & SATN in Band 3 SATN[2] show sometimes a much too high value in short loops
// This is  due to overflow in calculating the LATN and SATN.
// All Psds are normalized to "57dB"
// Linear interpretation of 57dB is: round(10^(57/10)) = 501187
// Highest supported value is 2^31
// In 17MHz we use max 4096 tones. So the highest accumulated value could be: 4096 * 501187 = 2.05e9, which is a little bit lower than 2^31
// In 35Mhz we use max 8196 tones. So the highest accumulated value could be: 8192 * 501187 = 4.11e9, which is a little bit higher than 2^31
// Solution:
// Psds are normalized to "54dB" .Power log2(round(10^(54/10)) * 8192) = 30.9384.
// Search for  XDSLRTFW-3673
//
// ************************************************************************************************************


#ifndef _VDSL_CONST_H
#define _VDSL_CONST_H
#include "vdsl_compiler.h"   // #ifdef ANXQ_35BLITE

#define CPE_MODE              (0)
#define CO_MODE               (1)

#define TX                    (1)
#define RX                    (0)

#define MODEM_OPERATION_MODE_VDSL2  (1<<1)

//==============================================================================
// Modem HW mode setting (VDSL mode, ADSL mode, retraining, dynamic reconfig, etc)
//==============================================================================

#define VDSL_MODE                         (0x0) // VDSL
#define ADSL_PLUS_PLUS_MODE               (0x1) // ADSL++
#define ADSL_PLUS_MODE                    (0x2) // ADSL+
#define RETRAIN_VDSL_TO_ADSL_PLUS_PLUS    (0xE) // retrain VDSL to ADSL++
#define DYNAMIC_RECONFIG                  (0xF) // dynamic reconfiguration

#define VDSL_MODE_35C                     (0x4) //35C VDSL (DS 8K, US 8K)
#define VDSL_MODE_35B                     (0x5) //35B VDSL (DS 8K, US 4K)

//Double train
#define NO_2ND_TRAIN             0
#define DO_2ND_TRAIN_DS512       1
#define DO_2ND_TRAIN_DS1024      2

//==============================================================================

#define NUM_BEARER_CHANNELS      (2)
#define BC0                      (0)
#define BC1                      (1)

#define NUM_DATA_PATHS           (2)
#define LP0                      (0)
#define LP1                      (1)
#define INLV                     (LP0)
#define FAST                     (LP1)
#define DISABLED_LP              (0xF)

#define H                        (138)
#define VDSL2_FRAMING_MODE       (0x7)
#define VDSL_TP                  (1)

#define MAX_TPS_TC_TYPE          (3)
#define MAX_TPS_TC_TYPE_API      (2)           // Note: The API and PP driver is not supporting STM!
#define TPS_TC_TYPE_STM          (0x4)
#define TPS_TC_TYPE_ATM_PTM      (0x3)
#define TPS_TC_TYPE_ATM          (0x2)
#define TPS_TC_TYPE_PTM          (0x1)
#define TPS_TC_DISABLED          (0x0)

#define BONDING_ENABLED          (0x4)

//XDSLRTFW-1924 (Start)
// DREG_MISCRAM4_ADDR values
#define DREG_MISCRAM4_ATM        (0x1)
#define DREG_MISCRAM4_PTM        (0x2)
//XDSLRTFW-1924 (End)

// default modem configuration
#define DEFAULT_MIN_RATE               (0)
#define SRA_SUPPORTED_PER_AMENDMENT1   (0x04)


#define DEFAULT_MAX_RATE               (95000) // 380Mbps in multiple of 4 kbps
#define DEFAULT_MAX_RATE_US            (27500) // 110Mbps in multiple of 4 kbps
#define DEFAULT_MAX_CHECKBYTE          (16)
#define DEFAULT_MAX_INLV_DEPTH         (1873)  // M*I+1 with M=52, I=36
#define DEFAULT_MAX_INLV_DELAY         (20)    // ms
#define DEFAULT_MAX_BER                (0)     // 0: E-3, 1: E-5, 2: E-7
#define DEFAULT_INP                    (0)     // 0: not required, 1: 0.5 frame, 2: 1 frame, 3: 2 frame
#define DEFAULT_TPSTC_OPTIONS          (0xC)     // Bit0-Preempt_PTM, Bit1-ShortPacket_PTM, Bit2-CIPolicy1 and Bit3-CIPolicy2 (No Bit2/3 set - CIPolicy0)

#define DEFAULT_TAR_SNR_MARGIN         (6)     // in dB
#define DEFAULT_MAX_SNR_MARGIN         (31)    // in dB
#define DEFAULT_MIN_SNR_MARGIN         (0)     // in dB
#define DEFAULT_MAX_ONE_OVER_S         (64)    //maximum of 1/S
#define DEFAULT_MIN_OHMSG_RATE         (16)    //min. overhead message rate in kbps

#define MAX_INLV_MEMORY_SIZE           (65520) // M*I*(I-1), with M=52, I=36
#define MAX_EOC_BYTES_PER_SYMBOL       (1)
#define MAX_VOC_BYTES_PER_SYMBOL       (1)
#define MAX_NUM_CHECK_BYTE             (9)     // R=0,2,4,6,8,10,12,14,16

#define NSM_ADD_AGC_GAIN                     (0x300)     //3db addtional AGC gain 8.8 dB format
#define NMS_MINIMUM_GAIN_TOBE_CONSIDERED     (0x100)    // 1dB in 8.8 dB format

// masks for gus_PhysicalTransportMode
#define TX_BC0_ATM0_MASK               (0x0001)
#define TX_BC0_ATM1_MASK               (0x0002)
#define TX_BC0_STM_MASK                (0x0004)
#define TX_BC0_PTM_MASK                (0x0008)

#define TX_BC1_ATM0_MASK               (0x0010)
#define TX_BC1_ATM1_MASK               (0x0020)
#define TX_BC1_STM_MASK                (0x0040)
#define TX_BC1_PTM_MASK                (0x0080)

#define RX_BC0_ATM0_MASK               (0x0100)
#define RX_BC0_ATM1_MASK               (0x0200)
#define RX_BC0_STM_MASK                (0x0400)
#define RX_BC0_PTM_MASK                (0x0800)

#define RX_BC1_ATM0_MASK               (0x1000)
#define RX_BC1_ATM1_MASK               (0x2000)
#define RX_BC1_STM_MASK                (0x4000)
#define RX_BC1_PTM_MASK                (0x8000)

#define TX_BC0_ATM_MASK                (TX_BC0_ATM0_MASK|TX_BC0_ATM1_MASK)
#define TX_BC1_ATM_MASK                (TX_BC1_ATM0_MASK|TX_BC1_ATM1_MASK)
#define TX_ATM0_MASK                   (TX_BC0_ATM0_MASK|TX_BC1_ATM0_MASK)
#define TX_ATM1_MASK                   (TX_BC0_ATM1_MASK|TX_BC1_ATM1_MASK)

#define RX_BC0_ATM_MASK                (RX_BC0_ATM0_MASK|RX_BC0_ATM1_MASK)
#define RX_BC1_ATM_MASK                (RX_BC1_ATM0_MASK|RX_BC1_ATM1_MASK)
#define RX_ATM0_MASK                   (RX_BC0_ATM0_MASK|RX_BC1_ATM0_MASK)
#define RX_ATM1_MASK                   (RX_BC0_ATM1_MASK|RX_BC1_ATM1_MASK)

//==============================================================================
// Parameter with signal power
//==============================================================================
#define TX_NEG165DBM                   (0x304D)   //This equals 2-bit constellation output from TX QT (16 MSBs)
                                                  //Power level/carrier of -1.65dBm for two-bit constellation
#define TX_NEG165DBM_DB                (0x51D8)   //10log10(TX_NEG165DBM*TX_NEG165DBM) in Q8.8 format
#define TX_POW_LEVEL                   (0x2000)
#define RX_POW_LEVEL                   (0x2000)
#define VDSL_CO_NOMINAL_GAIN           (60)
#define VDSL_CPE_NOMINAL_GAIN          (60)

//==============================================================================
// Parameter associated with algorithm handlers
//==============================================================================
   #define MAX_NUM_TA_INIT_REPETITION              (0)
   #define MAX_NUM_TA_ITERATIONS                   ((4)+ (2*MAX_NUM_TA_INIT_REPETITION))  // R-MSG1 (O-Signature TA),
                                                                                          // Begin-TransceiverTraining (before FA + TA ), End-TransceiverTraining (TA)
   #define MAX_NUM_FRAME_ALIGN_ITERATIONS          (15)
   #define MIN_NUM_FRAME_ALIGN_ITERATIONS          (9)
   #define LOG2_NUM_TONE_CLUSTERS_FRAME_ALIGN      (4)
   #define LOG2_NUM_FRAME_ALIGN_SYMBOLS            (1)
   #define LOG2_NUM_FDQ_TRAINING_SYMBOLS           (8)
   #define LOG2_NUM_SNR_TRAINING_SYMBOLS           (8)
   #define LOG2_NUM_PSD_TRAINING_SYMBOLS           (8)
   #define LOG2_NUM_MFDQ_TRAINING_SYMBOLS          (7)
   #define LOG2_DD_SNRFDQ_NUM_TRAINING_SYMBOLS     (8)
   #define DD_SNRFDQ_NUM_CHANNELS_PER_GROUP        (256) // max 256
   #define DD_SNRFDQ_NUM_CHANNELS_PER_GROUP_256    (256) // max 256
   #define DD_SNRFDQ_NUM_CHANNELS_PER_GROUP_512    (512) // max 512

//==============================================================================
// Parameter associated with Bitloading
//==============================================================================
#define RX_MAX_BITS_PER_TONE     (15) // Max receive constellation size
#define RX_MIN_BITS_PER_TONE     (1)  // Min receive constellation size
#define RX_MIN_BITS_PER_TONE_2   (2)
//XDSLRTFW-3493(Start_End)
#define MAX_BI_INDEX             (16) //Index to count number of tones per Bi

//XDSLRTFW-3300 (Start)
#define DS_MAX_BITS_FOR_HRT_5_0  (14) //For short loops < 150m
//XDSLRTFW-3300 (End)

#define SNR_THRESH_LOAD_MIN_BITS                      (4 << 8) // 4 dB in Q8.8
#define NEG_INFINITY_DB                               ((int16)0x8000) // Actually -128dB in 8.8, but used to represent log(0)... inverse log of this value should be 0
#define LARGEST_MARGIN_AFTER_ADDING_1_BIT             (0)
#define SMALLEST_MARGIN                               (1)
#define LARGEST_ACTUAL_MARGIN                         (2)

#define UNITY_FINEGAIN_LIN                            (8192)   // 1.0 * 8192
#define MAX_FINEGAIN_DB                               (640)   // 2.5 dB in Q8.8
#define MAX_FINEGAIN_LIN                              (10924) // 1.3335*8192
#define MIN_FINEGAIN_DB                               (-3712)   // -14.5 dB in Q8.8
#define MIN_FINEGAIN_LIN                              (1547)  // 0.1888*8192

//Mei, in the current implementation, since the fine gain variables
//are defined as the signed 16-bit number (it should be unsigned),
//thus the minimum fine gain of -14.5 dB cannot be represented.
//The lowest fine can we can represent is about -12 dB.
//To be conservative, we choose -10 dB as default for now.
#define DEFAULT_MIN_FINEGAIN_DB                       (-2560)   // use -10 dB in Q8.8, the current code
#define DEFAULT_MIN_FINEGAIN_LIN                      (2590)   // 0.3162*8192

// macros for manipulating the RxToneFlags datatype
#define SETTONEFLAG(ToneFlagArray, ToneIndex)         ToneFlagArray[(ToneIndex)>>3] |= 1 << ((ToneIndex)&0x7)
#define CLEARTONEFLAG(ToneFlagArray, ToneIndex)       ToneFlagArray[(ToneIndex)>>3] &= ~(1 << ((ToneIndex)&0x7))
#define ORTONEFLAG(ToneFlagArray, ToneIndex, Flag)    ToneFlagArray[(ToneIndex)>>3] |= ((Flag) << ((ToneIndex)&0x7))
#define IS_TONEFLAGSET(ToneFlagArray, ToneIndex)      ((ToneFlagArray[(ToneIndex)>>3] >> ((ToneIndex)&0x7)) & 0x1)

#define CLEAR_TONES_SUPPORTED_SET                     0x1
#define SET_TONES_SUPPORTED_SET                       0x2

//==============================================================================
// Parameter associated with Reed-Solomon and TCM coding
//==============================================================================
#define RS_CODING_GAIN_0       (0)
#define RS_CODING_GAIN_2       (24)  // 1.5 dB in Q4.4 format
#define RS_CODING_GAIN_4       (48)  // 3.0 dB
#define RS_CODING_GAIN_6       (56)  // 3.5 dB
#define RS_CODING_GAIN_8       (64)  // 4.0 dB
#define RS_CODING_GAIN_10      (72)  // 4.5 dB
#define RS_CODING_GAIN_12      (80)  // 5.0 dB
#define RS_CODING_GAIN_14      (80)  // 5.0 dB
#define RS_CODING_GAIN_16      (88)  // 5.5 dB

#define TCM_CODING_GAIN        (88)  // TCM coding gain 5.5 dB in Q4.4 format
#define MAX_CODING_GAIN        (120) //(96) // maximum coding gain  6.0 dB in Q4.4 format
#define MAX_CODING_GAIN_INTLV  (128) // maximum coding gain 8 dB in Q4.4 format
//XDSLRTFW-3493(Start)
//XDSLRTFW-3571 (Start)
//For Profile <= 17a, Q is limited to use upto 8 with R = 16 and
//with the coding gain of 9.5dB in iDTU, seeing huge amount DS uncorrected DTUs
//followed by link drop while doing DS SRA functional test, i.e when
//noise floor is increased by 3.0dB at a time. i.e noise delta increase as
//+1dB, +1dB, +1dB & +3dB (Link drop).
//Not seeing any DS uncorrected DTU if coding gain is limited upto 8.5dB
//Test was done at 450m loop.
#define MAX_CODING_GAIN_IDTU_R16 (136) // maximum coding gain 8.5 dB with R=16 in Q4.4 format
//XDSLRTFW-3571 (End)
//XDSLRTFW-3590 (Start)
//To use R as 8 for iDTU, 0.5dB coding gain reduction is required to pass the SRA test
//from 8.5dB to 8.0dB. This is applicable for profiles <=17a and 35B as well.
//Performed Loop Reach and SRA test, Not seeing any link drop and DS uncorrected DTU's.
#define MAX_CODING_GAIN_IDTU_R08 (128) // maximum coding gain 8.0 dB with R=08 in Q4.4 format
//XDSLRTFW-3590 (End)
//XDSLRTFW-3493(End)
//==============================================================================
// Parameter associated with Pilot tone selection & PLL
//==============================================================================
// XDSLRTFW-3280 - Start - PLL improvement / pilot tone selection improvement
#define MAX_NUM_PILOT_TONES              (3) // standard limited it to 16, HW support 3 pilot tones hence not more are needed
#define MAX_NUM_DOP_PTS                  (MAX_NUM_PILOT_TONES-1) // Data-on-pilot (DOP) enabled pilot tones (PTs) are not communicated to the CO
                                                                 // since they are treated by CO as normal data tones. We need to communicate
                                                                 // at lease one pilot tone to CO, hence maximum numbe of DOP PTs is 1 less than
                                                                 // the maximum number of pilot tones
// pilot tone selection control
#define DISABLE_MULTI_PILOT_SELECT       (0x01)
#define ADD_OFFSET_FROM_BANDEDGE         (0x02)
#define SWITCH_PILOT_IN_SHOWTIME         (0x04)   /* XDSLRTFW-2302 */
#define IGNORE_PHASE_ERROR_WHEN_SWITCH   (0x08)
#define DISABLE_PREFER_DS3_PILOT         (0x10)

#define PILOT_PWR_REDUCTION_MI           (1)
// XDSLRTFW-3280 - End - PLL improvement / pilot tone selection improvement

#ifdef PILOT_TONE_LOS_DETECT
#define LOS_INIT                    (0)
#define LOS_SETUP                   (1)
#define LOS_DETECT                  (2)

#define NUM_SYMS_FOR_THRESH         (128)
#define LOG2_NUM_SYMS_FOR_THRESH    (7)

#define NUM_SYMS_FOR_DETECT         (512)    //per VDSL2 spec., power should be averaged over 0.1 sec
                                             //(which is 400 synbols for 4Khz frame rate)
#define LOG2_NUM_SYMS_FOR_DETECT    (9)      //To simplify the computation, we choose to use 512 symbols for average
#endif

//==============================================================================
// Defines for training signals Tone cluster, e.g. G993.2, Table 12-37.
//==============================================================================
#define EVEN_CLUSTER_INDEX       (0)
#define ODD_CLUSTER_INDEX        (1)

#define TONE_CLUSTER_INDEX0      (0)
#define TONE_CLUSTER_INDEX1      (1)
#define TONE_CLUSTER_INDEX2      (2)
#define TONE_CLUSTER_INDEX3      (3)
#define TONE_CLUSTER_INDEX4      (4)
#define TONE_CLUSTER_INDEX5      (5)
#define TONE_CLUSTER_INDEX6      (6)
#define TONE_CLUSTER_INDEX7      (7)
#define TONE_CLUSTER_INDEX8      (8)
#define TONE_CLUSTER_INDEX9      (9)

#define TONE_CLUSTER_END_INDEX   (TONE_CLUSTER_INDEX9)

//==============================================================================
// Defines for training Select RxBand Limit
// - File SelectRxBandLimit.c and fct. SelectRxBandLimit()
//==============================================================================
#define SNR_THRESH_FOR_HIGHEST_TONE                            (5<<8)
#define SNR_THRESH_FOR_HIGHEST_TONE_BAND_START                 (6<<8) // this threshold should be little conservative since it is compared against the average SNR over the window size
#define SNR_THRESH_FOR_HIGHEST_TONE_NO_VECTORING               (7<<8)
#define SNR_THRESH_FOR_HIGHEST_TONE_NO_VECTORING_BAND_START    (8<<8) // this threshold should be little conservative since it is compared against the average SNR over the window size
#define WINDOW_SIZE                                            (10)

#define MIN_BAND_METRIC                         (int32)(SNR_THRESH_FOR_HIGHEST_TONE * WINDOW_SIZE)
#define MIN_BAND_METRIC_BAND_START              (int32)(SNR_THRESH_FOR_HIGHEST_TONE_BAND_START * WINDOW_SIZE)
#define MIN_BAND_METRIC_NO_VECTORING            (int32)(SNR_THRESH_FOR_HIGHEST_TONE_NO_VECTORING * WINDOW_SIZE)
#define MIN_BAND_METRIC_NO_VECTORING_BAND_START (int32)(SNR_THRESH_FOR_HIGHEST_TONE_NO_VECTORING_BAND_START * WINDOW_SIZE)

//==============================================================================
// Subcarrier Group
// - G993.2, 3.57 subcarrier group: A grouping of G (where G = 1, 2, 4, or 8) adjacent subcarriers.
// - test parameter (see clause 11.4.1)
//==============================================================================
#define SUBCAR_GROUP_SIZE_LOG2_1                (0)
#define SUBCAR_GROUP_SIZE_LOG2_2                (1)
#define SUBCAR_GROUP_SIZE_LOG2_4                (2)
#define SUBCAR_GROUP_SIZE_LOG2_8                (3)
#define SUBCAR_GROUP_SIZE_LOG2_16               (4)

#define SUBCAR_GROUP_SIZE_LOG2_MAX_DS           SUBCAR_GROUP_SIZE_LOG2_8
#define SUBCAR_GROUP_SIZE_LOG2_MAX_DS_35B       SUBCAR_GROUP_SIZE_LOG2_16
#define SUBCAR_GROUP_SIZE_LOG2_MAX_US           SUBCAR_GROUP_SIZE_LOG2_8

#define MAX_TESTPARAMETER_ARRAY_SIZE            512            // subcarrier group index = 0 to 511

//==============================================================================
// Showtime constants
//==============================================================================

#define PACKETS_PER_SFRAME                     (10) // # of (U+E) packets per superframe

// Synch frame processing macros
#define TX_DATA_SYMBOLS_PER_SUPERFRAME          256
#define RX_DATA_SYMBOLS_PER_SUPERFRAME          TX_DATA_SYMBOLS_PER_SUPERFRAME

#define NUM_PRBS_SAVE_REGS_32BIT                3
#define NUM_PRBS_SAVE_REGS                      (NUM_PRBS_SAVE_REGS_32BIT << 1)      // # of int16 array save members

// Overhead messaging macros
#define MAX_IB_BYTES_PER_SFRAME                 (3)     // # of IB bytes per superframe
#define NO_INDICATIONS                          (0x00)  // Default value for indicator bits (no indications)

// Define the period of IBits-based OH info in terms of number of PMD frame.
// Note: we assume the frame rate of 4 kHz for both VDSL1 and VDSL2 when computing this constant.
/*
    In VDSL2, the max period of IBits-based OH is 20 ms, therefore 20/0.25 = 80 PMD frames/IBitsOH.
*/
#define VDSL2_MAX_NUM_PMD_FRAMES_PER_IB_STRUCT  (80)

// Set in values for VDSL2
#define RX_OVHD_MSG_SWFIFO_LEN                  (20)   // Length of Rx Ovhd SW fifo message buffer (bytes)
#define TX_OVHD_MSG_SWFIFO_LEN                  (20)   // Length of Tx Ovhd SW fifo message buffer (bytes)
#define MAX_OVHD_BYTES_PER_FRAME                (13)
// XDSLRTFW-947 BUGFIX_US_VDSL2_All_LofIndication (start)
#define MAX_OVHD_BYTES_PER_FRAME_INIT           (16) // Max 8 Overhead bytes (OPI) can be transmitted per mux data frame.
                                                     // Hw needs twice at showtime entry.
// XDSLRTFW-947 BUGFIX_US_VDSL2_All_LofIndication (end)

#define SYNC_BYTE                               (0x3C)
#define NTR_BYTE                                (0xFF)
#define SYNC_BYTE_SFRAME                        (0xAC)

// VDSL2 ovhd states
#define INSERT_SYNC                             (0)
#define INSERT_IB0                              (1)
#define INSERT_IB1                              (2)
#define INSERT_IB2                              (3)
#define INSERT_NTR                              (4)
#define INSERT_HDLC                             (5)

#define GET_SYNC                                (0)
#define GET_IB0                                 (1)
#define GET_IB1                                 (2)
#define GET_IB2                                 (3)
#define GET_NTR                                 (4)
#define GET_HDLC                                (5)

#define MONITOR_OH_BYTE          0
#define ADD_OH_BYTE_TO_FIFO      1

// IB byte #2
#define IB_FEBE_S_SHIFT          (0)
#define IB_FFEC_S_SHIFT          (1)
#define IB_FEBE_F_SHIFT          (2)
#define IB_FFEC_F_SHIFT          (3)
#define IB_FLOS_SHIFT            (4)
#define IB_FRDI_SHIFT            (5)
#define IB_FPO_SHIFT             (6)
#define IB_FLPR_SHIFT            (7)
// IB byte #3
#define IB_LOM_SHIFT             (0)
#define IB_HEC_S_SHIFT           (1)
#define IB_HEC_F_SHIFT           (2)
#define IB_NCD_OCD_S_SHIFT       (3)
#define IB_NCD_OCD_F_SHIFT       (4)

#define LOS_SUPERFRAMES          (6) // number of consecutive superframes to report LOS
#define LOS_TERMINATE_SFRAMES    (2) // number of superframes to terminate LOS defect
#define LOS_PRESENT_SFRAMES      (4) // number of superframes to present LOS defect

#define LCD_SUPERFRAMES          (4) // number of consecutive ncd-i before declaring lcd defect

#define VOC_BSR_MSG_LEN          (11) // # of bytes/VOC message for bitswap request (express bitswap is var length)
#define VOC_BSA_MSG_LEN          (3)    // # of bytes/VOC message for bitswap ack

#define TX_VOC_MSG_SWFIFO_LEN    (32)   // Length of Tx VOC SW fifo message buffer (bytes)
#define RX_VOC_MSG_SWFIFO_LEN    (32)   // Length of Rx VOC SW fifo message buffer (bytes)
#define MAX_TX_VOC_MSG_LEN       (VOC_BSR_MSG_LEN)
#define MAX_RX_VOC_MSG_LEN       (VOC_BSR_MSG_LEN * VOC_MSG_REPEAT_CNT)   // Max length of Rx VOC message buffer (bytes)

// VOC message macros
#define VOC_IDLE_BYTE               (0x00)
#define VOC_BITSWAP                 (0xFF)
#define VOC_BITSWAP_ACK             (0xFF)
#define VOC_EXP_BITSWAP_NEXT        (0xF2)
#define VOC_EXP_BITSWAP_NEXT_NEXT   (0xF3)

// TX VOC message state machine macros
#define TX_VOC_IDLE              (0)
#define TX_VOC_NEXT_MSG          (1)
#define TX_VOC_SEND_MSG          (2)
#define TX_VOC_IDLE_BETWEEN_MSGS (3)
#define TX_VOC_REPLICATE_MSG     (4)

// RX VOC message state machine macros
#define RX_VOC_IDLE            (0)
#define RX_VOC_BS_REQ_MSG      (1)
#define RX_VOC_BS_ACK_MSG      (2)

// bit masks for gus_ShowtimeControl
#define MASK_TX_RX_SHOWTIME               (0x0001) // set if both TX and RX go to showtime
#define MASK_PROCESS_TX_IB                (0x0002) // set when Tx IB bytes are available for processing
#define MASK_PROCESS_RX_IB                (0x0004) // set when Rx IB bytes are available for processing
#define MASK_PROCESS_TX_VOC               (0x0008) // set when Tx VOC bytes are available for processing
#define MASK_PROCESS_RX_BS_REQ            (0x0010) // set when Rx bitswap request bytes are available for processing
#define MASK_PROCESS_RX_BS_ACK            (0x0020) // set when Rx bitswap acknowledge bytes are available for processing
#define MASK_PROCESS_TX_EOC               (0x0040) // set when Tx EOC bytes are available for processing
#define MASK_PROCESS_RX_EOC               (0x0080) // set when Rx EOC bytes are available for processing
#define MASK_READ_RX_FFTOUT               (0x0100) // set to read FFT output from RTV buffer
#define MASK_READ_RX_ERROUT               (0x0200) // set to read QAM decision error output from RTV buffer
#define MASK_RX_SYNC_FRAME_PROC           (0x0400) // set to enable Rx synch frame processing
#define MASK_SHOW_2_PAGE_LOADED           (0x0800) // set when SHOW_2 page loaded
#define MASK_RX_NTR_PROC                  (0x1000) // Set when a new NTR byte is received
// (0x2000) reserved
#define MASK_ENABLE_DEC_ADAPT_TC_TASKS    (0x4000) // set to enable DEC adaptation TC tasks (used to disable calls when
                                     // Tx/Rx bitswaps are being applied

#define RUN_SNR_FDQ_UPDATE          (1)
#define RUN_DEC_UPDATE              (2)

// showtime loopback buffer size (in terms of 32-bit word)
#define NUM_LPBK_WORDS_PER_BATCH    (256) // currently share with gsa_RxHlog[512]

// states used in RxDataFrameProcess()
#define SNR_FDQ_UPDATE           (0) // update SNR and FDQ
#define BIT_SWAP_DECISION        (1) // run US bit-swap decision algorithm

// states/constants used to copy ping-pong buffers
#define COPY_INIT                (0)
#define COPY_BAT_GST_EGT         (1)
#define COPY_TRT                 (2)
#define COPY_DONE                (3)
#define NUM_COPY_TONES_PER_GROUP (128)

// constants used in NOISE_MARGIN_SEPARATE Algorithm Handler
#define  NOISE_MARGIN_SEP_DONE             0
#define  CALCULATE_SNR_3DB_AGC_GAIN        1
#define  CALCULATE_SNR_DEFAULT_AGC_GAIN    2
#define  NOISE_MARGIN_SEP_DISABLED         3
#define  NOISE_MARGIN_SEP_NO_SNR_UPDATE    4

#define  NOISE_MARGIN_SEP_SRA_TEST         8

//============================================================================================
// Indicator Bits Parameters
//============================================================================================
#define TERMINATED            (0) // Anomaly or Defect terminated
#define PRESENT               (1) // Anomaly or Defect present

//============================================================================================
// PARR constants
//============================================================================================

#define NUM_PARR_TONES         (20) // Number of parr tones used

//==============================================================================
// Vendor ID for INTEROP
//==============================================================================
#define NO_VENDOR_ID          (0)
#define IFX_VENDOR_ID         (0x4946544E) // IFTN
#define BRCM_VENDOR_ID        (0x4244434D) // BDCM
#define IKNS_VENDOR_ID        (0x494B4E53) // IKNS
//#define CNXT_VENDOR_ID        (0x4753504E) // GSPN
#define CNXT_VENDOR_ID        (0x43585359) // CXSY (e.g. Audiocodes: Argentina)
#define CNXT_VENDOR_ID_NS     (0x414C4342) // ALCB (provider code that CNXT sends in the NS info field)

#define AWRE_VENDOR_ID        (0x41575245)
#define TI_VENDOR_ID          (0x54535443)
#define CTLM_VENDOR_ID        (0x50000000)
#define CTLM_VENDOR_ID2       (0x43454E54)
#define ADI_VENDOR_ID         (0x414E4456)
//XDSLRTFW-2323 (Start)
#define METANOIA_VENDOR_ID    (0x4D455441) //META - Old Metanoia Vendor ID
#define METANOIA_VENDOR_ID2   (0x4D544941) //MTIA - New Metanoia Vendor ID
//XDSLRTFW-2323 (End)

// XDSLRTFW-3573 (Start_End)
#define REALTEK_VENDOR_ID     (0x5245544B)

//==============================================================================
// IFX/LANTIQ CO Platform ID's for INTEROP
//==============================================================================
//XDSLRTFW-634 : BUG_DS_ALL_ALL_ReTxThroughput (Start_End)
#define AVINAX_PLATFORM          (13)
#define VINAX_REV_2_L_PLATFORM   (12)  //XDSLRTFW-1639 (start_end)
#define VINAX_REV_2_M_PLATFORM   (11)
#define VINAX_REV_1_4_PLATFORM   (10)
#define VINAX_REV_1_PLATFORM     (9)

//==============================================================================
// Alphaeus (ATM) constants - may be HW specific
//==============================================================================
#define ATM_NUM_BC            (2)
#define ABC0                  (0)
#define ABC1                  (1)
#define DISABLED_ABC          (0xF)

// Alphaeus interface mode setting (AT_CONFIG/AR_CONFIG)
#define UTOPIA_MODE           (0x0)
#define UTOPIA_BYPASS_MODE    (0x1)
#define DSP_INTERCEPT_MODE    (0x2)

// # cell page, cell page start address (AT_CB_CFG_BCx/AR_CB_CFG_BCx)
#define CB_START_ADDR_BC0     (0x0000)
#define CB_NUM_PAGE_BC0       (0x2F)
#define CB_START_ADDR_BC1     (0x0292)
#define CB_NUM_PAGE_BC1       (0x2E)

// byte-flip, scramble enable option (AT_PCNTL_BCx/AR_PCNTL_BCx)
#define ALP_BYTE_FLIP_DISABLE       (1) // 1 = disable

// idle cell payload (AT_IDLE_BCx/AR_IDLE_BCx)
#define   TX_IDLE_CELL_PAYLOAD      (0x6A)
#define   RX_IDLE_CELL_PAYLOAD      (0x6A)

// byte pattern insertion in IMA mode (AR_IMAHEC)
#define IMA_GOOD_HEC                (0x00)
#define IMA_BAD_HEC                 (0x80)

// cell delinataion parameter (AR_DELIN_BCx)
#define CELL_DELIN_DELTA         (1) // # HEC errors needed to jump out of sync state
#define CELL_DELIN_ALPHA         (3) // # good HEC needed to enter sync state

// starting from ALP_T_CELL_CNT_BC0_ADDR to ALP_T_IDLE_CNT_BC0_ADDR, or
// starting from ALP_T_CELL_CNT_BC1_ADDR to ALP_T_IDLE_CNT_BC1_ADDR
#define NUM_READ_TX_ATM_REGS     (2)
#define TX_CELL_CNT              (0)
#define TX_IDLE_CNT              (1)

// starting from ALP_R_ATM_STAT_BC0_ADDR to ALP_R_CD_CNT_BC0_ADDR, or
// starting from ALP_R_ATM_STAT_BC1_ADDR to ALP_R_CD_CNT_BC1_ADDR
#define NUM_READ_RX_ATM_REGS     (7)
#define RX_ATM_STAT              (0)
#define RX_CELL_CNT              (1)
#define RX_IDLE_CNT              (2)
#define RX_AIDLE_CNT             (3)
#define RX_BE_CNT                (4)
#define RX_HEC_CNT               (5)
#define RX_CD_CNT                (6)

#define ATM_NULL                 (0)
#define NCD                      (1)
#define SYNC                     (2)
#define OCD                      (3)
#define LCD                      (4)

#define NUM_READ_TX_ATM_REGS     (2)
#define TX_CELL_CNT              (0)
#define TX_IDLE_CNT              (1)

#ifdef PPE_ENGINE
//PPE PTM registers
#define NUM_READ_TX_PTM_REGS     (1)
#define TX_CW_CNT                (0)
//#define TX_IDLE_CNT            (1)

#define NUM_READ_RX_PTM_REGS     (6)
#define RX_PTM_STAT              (0)
#define RX_CW_CNT                (1)
#define RX_CERRN_CNT             (2)
#define RX_CERRNP_CNT            (3)
#define RX_CVN_CNT               (4)
#define RX_CVNP_CNT              (5)
#endif //#ifdef PPE_ENGINE

//==============================================================================
// BCR constants - may be HW specific
//==============================================================================
#define MAP2NONE            (0) // used to set BT_VBC_MAP/BR_VBC_MAP
#define MAP2ABC0            (1)
#define MAP2ABC1            (2)
#define MAP2EBC             (3)

//==============================================================================
// CRI constants - may be HW specific
//==============================================================================

//Set the time slot control
//Note: The number of clocks per time slot is computed as:
//The assumed core high speed clock rate is R = 282.624 Mhz.
//Each frame (not including the CE) is L = 4096*2 = 8192 samples
//The sampling rate for 4096 tones is S = 35.328 Mhz
//The number of clocks per frame is R*L/S = 65536
//The number of clocks per time-slot is 65536/4 = 16384
//NUM_TS = 3
//NUM_CLKS = 16383
//CLKS_LAST = 0
//TSC_ENABLE = 0 (will enable TSC right at LinkStart)

#define CRI_TSC_CTRL_NUM_CLKS                (16384)
#define CRI_FFT_STALL_CTL_FFT_DONE_CLKS      (29000)

//Set the time slot control
#define CRI_TSC_CTRL_NUM_TS_4K      (4-1)
#define CRI_TSC_CTRL_NUM_TS_8K      (2-1)
#define CRI_TSC_CTRL_CLKS_LAST      (0)
#define CRI_TSC_CTRL_ENABLE         (1)
#define CRI_TSC_CTRL_DISABLE        (0)

//Set other clocks
#define CRI_TX_QT_STALL_CLKS_4K        (5684)
#define CRI_TX_QT_STALL_CLKS_8K        (5684)

#define CRI_RX_QT_STALL_CLKS_4K        (0)
#define CRI_RX_QT_STALL_CLKS_8K        (5383)

#define TX_IFFT_START_TIMER_4K         (36536)
#define TX_IFFT_START_TIMER_8K         (3768)


#define CRI_TX_PMS_GO_CNT_4K        (0)
#define CRI_TX_QTP_GO_CNT_4K        (0)
#define CRI_TX_QT_GO_CNT_4K         (0)
#define CRI_RX_PMS_GO_CNT_4K        (0)
#define CRI_RX_QTP_GO_CNT_4K        (0)
#define CRI_RX_QT_GO_CNT_4K         (0)

#define CRI_TX_PMS_GO_CNT_8K        (CRI_TSC_CTRL_NUM_CLKS/2)
#define CRI_TX_QTP_GO_CNT_8K        (CRI_TSC_CTRL_NUM_CLKS/2)
#define CRI_TX_QT_GO_CNT_8K         (CRI_TSC_CTRL_NUM_CLKS/4)

#define CRI_TX_PMS_GO_CNT_8K_ST     (13000)
#define CRI_TX_QTP_GO_CNT_8K_ST     (13000)
#define CRI_TX_QT_GO_CNT_8K_ST      (4000) //XDSLRTFW-2559 (Start_End)

#define CRI_RX_PMS_GO_CNT_8K     (6000)
#define CRI_RX_QTP_GO_CNT_8K     (6000)
#define CRI_RX_QT_GO_CNT_8K      (0)

#define AFE_CLK_FREQ             (144000)
#define AFE_CLK_FREQ_NOM         (141312)                  //=70.656 MHz * 2
#define HS_CLOCK_FREQ            (AFE_CLK_FREQ<<1)            //=288 MHZ
#define FFT_CLK_FREQ_NOM         (AFE_CLK_FREQ_NOM>>2)         //=35.328 MHz

//Maximum number of clocks per frame (including cyclic extention)
#define MAX_TIME_PER_FRAME_4K    ((2*4096+640)*(HS_CLOCK_FREQ/256)/(FFT_CLK_FREQ_NOM/256))
#define MAX_TIME_PER_FRAME_8K    (MAX_TIME_PER_FRAME_4K>>1)

//72000 - 16000 = 56000
//Cascaded mode
#define MAX_RX_PMS_ALLOWED_CYCLES   56000

// Max cycles for Tx PMS Computation
// The QT starts at 35K cycles and executs for 9K cycles.
// In worst case (max cycles), We receive Rx QT done interrupt just before getting the Tx QT done interrupt.
// Hence, we need to wait till Rx TC is finshed. This takes a maximum of 18K cycles.
// We check the Tx PMS done at this point.
// Also, we take another 2K-3K cycles for interrupt handling which is an overhead to DSP.
// Max cycles:
// 35K + 9K + 18K + 3K - 17.9K =
#define MAX_TX_PMS_ALLOWED_CYCLES   47000

// XDSLRTFW-3229 (Start)
// For every register read and increment of an loop count variable, we take 30 cycles in vectoring
// and non vectoring mode of operation in 35B. Hence, we need to divide the maximum number of cycles by 30
// The below values are obtained by dividing the maximum number of cycles by 30.
#define MAX_TX_LOOP_COUNT           1567
#define MAX_RX_LOOP_COUNT           1867
// XDSLRTFW-3229 (End)

//Choose the number of clocks per time slot for frequency domain connectivity test
//to speed up the COCOMO test

//Choose N = 32 (the minimum number to be dividiable by 32)
//Frame length = 2*N = 64;
//CE Length = m*N/32 = 5*32/32 = 5
//gs_NumSamplesPerDmtSymbol = 2*N + m*N/32 = 64+5= 69

//We need to change the time slot control accordingly for
//the fixed frame length of 2*N (= 64)
//Note1: For 4kHz frame rate, the ratio of the high speed clock rate to the sampling rate
//is 282.624/35.328 = 8. Thus, the number of clock cycles per the time-slot is
//(gs_NumSamplesPerDmtSymbol-CELength)*8/4 = 64*2 = 128
//Note2: For 8kHz frame rate, the ratio of the high speed clock rate to the sampling rate
//is 282.624/(35.3282) = 4, but there are only 2 time slots per frame,
//so the number of clock cycles per the time-slot is
//(gs_NumSamplesPerDmtSymbol-CELength)*4/2 = 64*2 = 128
#define NUM_CLKS_FDCONN             (128)

//==============================================================================
// Electra (STM) constants - may be HW specific
//==============================================================================

//==============================================================================
// Zephyr (FC-ILV) constants - may be HW specific
//==============================================================================
#define ZEP_MAX_RX_FC_RUN_CNT       (10)

// indicate ILV/DILV memory type for NE and FE modem
// used for gft_NE_IlvDilvMemType, gft_FE_IlvDilvMemType
#define UNKNOWN_ILV           (0)
#define SHARED_ILV            (1)
#define SEPARATE_ILV          (2)


// the following constants are used to indicate FE ILV/DILV buffer limit for known modem
#define VINAX_REV1_HW_ILV_MEM_SIZE        (34048)
#define VINAX_REV1_HW_DILV_MEM_SIZE       (34048)
#define VINAX_REV2_HW_ILV_MEM_SIZE        (49000) // needs to be updated!
#define VINAX_REV2_HW_DILV_MEM_SIZE       (49000) // needs to be updated!

#define NUM_OF_UPROCESSORS                (10)
#define NUM_OF_UPROC_STATES               (5)

//==============================================================================
// Iridia (QT-FT) constants - may be HW specific
//==============================================================================
#define RTV0_CFG_LATENCY                  (2)      // Number of frames required for configuring RTV buffer 0
// This specifies the settel time/delay until the HW change gets be visible for the FW.
// The delay is based on the time taken by HW and it is schedule. For cascaded mode with 8K tones FFT
// a delay of 4 symbols and for 4K tones FFT of 3 symbols should be used.
// It is mainly scheduling dependent and therefore a variable must be used!
// Note: 35b Scheduling: AFE-Strymon-FFT-QT
#define AFE_TO_QT_LATENCY                 (3)      // Number of frames/symbols until the changed setting is visable for FW

#define RTV0_CFG_LATENCY_35B              (2)      // Number of frames required for configuring RTV buffer 0
#define AFE_TO_QT_LATENCY_35B             (4)      // Number of frames/symbols until the changed setting is visable for FW

//==============================================================================
// Hybrid handler control defines "guc_EnableHybCapacitorSearch"
//==============================================================================
#define ENABLE_CAP_SEARCH_CPB      0x01
#define ENABLE_CAP_SEARCH_CPC      0x02

#define CHANGE_CAP_SEARCH_START    0x10
#define CHANGE_CAP_SEARCH_CPB      0x20
#define CHANGE_CAP_SEARCH_CPC      0x40

#define CHANGE_CAP_SEARCH_CPB_POS  5
//==============================================================================
// Output options for RTV buffers
//==============================================================================
// RTV_OUTx field in IR_RTVx
#define FFT_OUTPUT         (0)
#define SFDQ_OUTPUT        (1)
#define GAIN_INPUT         (2)
#define GAIN_OUTPUT        (3)
#define NOISE_CONSTEL      (4)      //noise contellation
#define CDEC_OUTPUT        (6)      //constellation decision
#define ERROR_OUTPUT       (7)
#define HW_ACCUM_POW       (1<<8)   //accumulated signal power
#define RTV_NOTYPE         (-1)

// RTV_CNTx field in IR_RTVx
#define MAX_RTV_TONE_NUM   (512)

// format options for RTV buffers
#define RTV_FMT0           (0)
#define RTV_FMT1           (1)

#define TPP_SET_0          (0) // MSB in TPP
#define TPP_SET_1          (1)
#define RPP_SET_0          (0) // MSB in RPP
#define RPP_SET_1          (1)

#define NUM_IFFT_BUFFERS   3

/* =========================================================================================== */
/* Parameters associated with FDQ implementation */
/* =========================================================================================== */
#define FDQ_MANTISSA_WORDLENGTH           (16)      /*  wordlength (in bits) of signed FDQ mantissa      */
#define FDQ_MANTISSA_FRAC_BITS            (15)      /*  number of fractional bits in FDQ mantissa   */
#define FDQ_EXPONENT_BITS                 (4)      /* 4-bit, unsigned exponent */
#define FDQ_EXPONENT_MAX                  (15)      /* Max representable exponent */
#define FDQ_MANTISSA_MAX                  ((1<<FDQ_MANTISSA_FRAC_BITS)-1)   // Maximum mantissa
#define MIN_TONE_AMPLITUDE                (-32768)   // Min possible value of Rx tone real or imag component.
#define MAX_TONE_AMPLITUDE                (32767)      // Max possible value of Rx tone real or imag component.

#define MAX_MFDQ_TONES                    (64)
#define MAX_MFDQ_BUF_SIZE                 (MAX_MFDQ_TONES+4) // to hold all tones between min{MFDQ tone, FB tone} and max{MFDQ tone, FB tone}

#define MFDQ_COV_MATRIX_SIZE              (12)
#define COV_M11_R_H                       (0)
#define COV_M11_R_L                       (1)
#define COV_M12_R_H                       (2)
#define COV_M12_R_L                       (3)
#define COV_M12_I_H                       (4)
#define COV_M12_I_L                       (5)
#define COV_M13_R                         (6)
#define COV_M13_I                         (7)
#define COV_M22_R_H                       (8)
#define COV_M22_R_L                       (9)
#define COV_M23_R                         (10)
#define COV_M23_I                         (11)

#define MFDQ_COR_VECTOR_SIZE              (6)
#define COR_V11_R                         (0)
#define COR_V11_I                         (1)
#define COR_V21_R                         (2)
#define COR_V21_I                         (3)
#define COR_V31_R                         (4)
#define COR_V31_I                         (5)

#define MFDQ_MANTISSA_FRAC_BITS           (15)
#define MFDQ_MAX_FB_EXP_RSHFT             (9)
#define MFDQ_MAX_EXP_SHFT                 (15)

//==============================================================================
// Strymon (FDF) constants - may be HW specific
//==============================================================================

//----------------------------------------------
// TDQ constants
//----------------------------------------------

//  TDQ filter length
#define MIN_TDQ_LENGTH           (4) // minimum TDQ length for bypass mode (when TDQ is disabled, should be multiple of 4)
#define TDQ_LENGTH               (24)

#define STR_NO_LPBK              (0)      //not lpbk in strymon
#define STR_TX_RX_LPBK           (1)      //loopback from strymon TX interp to ADC adjust
#define STR_AFEIF_LPBK           (2)      //loopback at strymon to AFE interface
//----------------------------------------------
// DEC constants
//----------------------------------------------
#define DEC_LENGTH                  (560)            // DEC filter length - computed in FW
#define DEC_LENGTH_HW               (480)            // DEC length loaded to HW. MUST be integer multiple of DEC_ADAPT_BLOCK_SIZE.
#define DEC_ADAPT_BLOCK_SIZE        (80)              // Number of coefficients that will be updated per block
#define MAX_NUM_DEC_UPDATE_BLOCKS   (6)              // Max number of coefficient update blocks used in showtime Dec adaptation

#define MIN_DS2US_RATE_RATIO        (8)               //= min((1024/64), (512/64));
#define MAX_TX_PATH_DEALY           (16)            // the maximum total TX path fixed delay

#define EC_TAIL_WIN_LEN             14               // Tail window length for EC coeff.
#define EC_TAIN_WIN_RSH             15               // Tail window coefficient right shift count

#define DEC_COEF_FRAC_WIDTH         (15)               // DEC coeff fractional width in bits
#define MIN_DEC_FIR_EXP             (-4)            // Min DEC exponent - right shift by 4
#define MAX_DEC_FIR_EXP             (3)               // Max DEC exponent - left shift by 3

//----------------------------------------------
// Tx/Rx Cyclic Extension Parameters
//----------------------------------------------
#define MAX_BETA_LENGTH                (256)
#define TX_WINDOW_LENGTH               (240)
#define RX_WINDOW_LENGTH               (TX_WINDOW_LENGTH)
#define TX_WINDOW_LENGTH_8K_IFFT       (480)    //Removed all code sections with TX_WINDOW_LENGTH_35B since we
                                                //do not support 8K IFFT size and the implementation was wrong (bound to mode select instead of gs_TxLog2IfftLength / HW configuration)
#define RX_WINDOW_LENGTH_8K_FFT        (TX_WINDOW_LENGTH_8K_IFFT)

#define TX_WINDOW_LENGTH_BDCM          (128)
#define RX_WINDOW_LENGTH_BDCM          (TX_WINDOW_LENGTH_BDCM)
#define TX_WINDOW_LENGTH_8K_IFFT_BDCM  (256)    //Removed all code sections with TX_WINDOW_LENGTH_35B since we
                                                //do not support 8K IFFT size and the implementation was wrong (bound to mode select instead of gs_TxLog2IfftLength / HW configuration)
#define RX_WINDOW_LENGTH_8K_FFT_BDCM   (TX_WINDOW_LENGTH_8K_IFFT_BDCM)

#define TX_WINDOW_LENGTH_ADSL_MODE     (60)

// defines for "gs_DbgRecnfgCpCsBeta" to control the debug of Tx/Rx Cyclic Extension Parameters
#define TX_CYCLIC_EXTENSION_DBG_EN         0x01
#define RX_CYCLIC_EXTENSION_DBG_EN         0x02
#define RX_WINOWING_BDCM_FIX_DIS           0x04
#define TX_TIMING_ADVANCE_ZERO_EN          0x08
#define TX_TIMING_ADVANCE_DELAY_EN         0x10
#define TX_TIMING_ADVANCE_DELAY_2STEP_EN   0x20
#define RX_CP_CS_BETA_BDCM_FIX_DIS         0x40
#define TX_CP_CS_BETA_BDCM_FIX_DIS         0x80

#define RX_CP_CS_BETA_BDCM_EN             0x100
#define TX_CP_CS_BETA_BDCM_EN             0x200


//----------------------------------------------
// Unity Tx variable gain = (1/2)*(2^1)
//----------------------------------------------
#define UNITY_TX_VAR_GAIN           (0x4000)      //  = 1/2 in Q1.15
#define UNITY_TX_VAR_GAIN_EXP       (1)
#define UNITY_RX_VAR_GAIN           (0x4000)      //  = 1/2 in Q1.15
#define UNITY_RX_VAR_GAIN_EXP       (1)

//----------------------------------------------
// TxVarGain Limits
//----------------------------------------------
#define MAX_TXVARGAIN_dB      (18<<8)      //18 dB in 8.8 format) = 1.0 *20 log10(2^3)
#define MAX_TXVARGAIN_EXP     (3)            //max TX vargain exponent
#define MIN_TXVARGAIN_EXP     (-6)            //min TX vargain exponent

//----------------------------------------------
// Tx US0 bands tone limits
//----------------------------------------------
#define US0_POTS_ISDN_DETECT_TONE            (25)
#define US0_POTS_MAX_TONE                    (32)
#define US0_ISDN_POTSDOUBLE_MAX_TONE         (64)
#define US0_ISDNDOUBLE_POTSQUAD_MAX_TONE     (128)

#define FIRST_BIN_US1                        (696)   // Fist bin US1, i.e. 3.0MHz of 997 Band plan
                                                   // Note: Can be used to determinate US band decisions, i.e. if-case.
#define FIRST_BIN_US2                        (1635)   // First bin US2, i.e. 7.05MHz of 997 Band plan
                                                   // Note: Can be used to determinate US band decisions, i.e. if-case.
//----------------------------------------------
// Rx bands tone limits
//----------------------------------------------
#define LAST_BIN_DS1                         (870)   // equal to  3.75 MHZ
#define LAST_BIN_DS2                         (2348)   // equal to 10.125MHz

//----------------------------------------------
// DS PSD defines
//----------------------------------------------
//XDSLRTFW-1836
//Identify the wrong MaxNomPSD Values Calulated
//If wrong, assign default MaxNomPSD to DS & US
#define STD_MAXNOMPSD_DS                     (400)
#define STD_MAXNOMPSD_US                     (380)
//XDSLRTFW-1836

// defines for variable "gs_ForceSpecialCeilValueDs_Cntl"
//#define CNFG_V2_PROFILE_NONE_MASK           (0x00)
//#define CNFG_V2_PROFILE_8A_MASK             (0x01)
//#define CNFG_V2_PROFILE_8B_MASK             (0x02)
//#define CNFG_V2_PROFILE_8C_MASK             (0x04)
//#define CNFG_V2_PROFILE_8D_MASK             (0x08)
//#define CNFG_V2_PROFILE_12A_MASK            (0x10)
//#define CNFG_V2_PROFILE_12B_MASK            (0x20)
//#define CNFG_V2_PROFILE_17A_MASK            (0x40)
//#define CNFG_V2_PROFILE_30A_MASK            (0x80)
//#define CNFG_V2_PROFILE_35B_MASK            (0x100)
#define WRONG_DS_NOM_PSD                    (0x4000)
#define BYPASS_FORCE_SECIAL_VALUE_SELECTION (0x8000)

//==============================================================================
// Parameters used for Test - Cocomo or HW debug purpose
//==============================================================================

#define SNR_FDQ_UPDATE_LOG_LENGTH            (10)

// bit map for gus_VdslStatusFlag
#define BITMAP_DISABLE_TX_CE_VDSL2           (1<<0) // if set, indicate the TX CE insertion is disabled
#define BITMAP_TX_PILOT_EGT_VDSL2            (1<<1) // if set, indicate the TX EGT used is for sending pilot tones
#define BITMAP_RX_SYNCHRO_VDSL2              (1<<2) // if set, indicate the expected synchro state is detected
#define BITMAP_TX_APPLY_BLACKOUT             (1<<3) // if set, indicate the blackout carriers should not have power
#define BITMAP_DISABLE_RX_CE_VDSL2           (1<<4) // if set, indicate the RX CE insertion is disabled
#define BITMAP_LOAD_TX_GAINS                 (1<<5) // if set, indicate the TX Gains are loaded
#define BITMAP_PERFORM_2ND_TA                (1<<6) // if set, indicate the 2nd timing advance should be performed

// bit map for gus_VdslCntlFlag
#define BITMAP_ENABLE_MEASURE_ROTRAIN_ECHOOFF_PSD     (1<<0) // if set, enable measurement of echo-off PSD
#define BITMAP_ENABLE_PSD_TRAIN1_VDSL2                (1<<1) // if set, enable PSD measurement during Training phase
#define BITMAP_ENABLE_2ND_FA_TRAIN1_VDSL2             (1<<2) // if set, enable 2nd Frame Alignment during Training phase
#define BITMAP_ENABLE_PERIODIC2_FA_VDSL2              (1<<3) // if set, enable frame alignment during the periodic2 state
#define BITMAP_ENABLE_1BYTE_ANAEXC_SYMBOLS            (1<<4) // if set, enable switch to 1 byte per Analysis/Exchange symbol
#define BITMAP_ENABLE_MEASURE_ORTRAIN_PREPGA_PSD      (1<<5) // if set, enable measurement of PSD pre-pga in ORTrain
#define BITMAP_ENABLE_MEASURE_ORTRAIN_PREHYB_PSD      (1<<6) // if set, enable measurement of PSD pre-hybrid in ORTrain
#define BITMAP_ENABLE_MEASURE_ORTRAIN_POSTHYB_PSD     (1<<7) // if set, enable measurement of PSD post-hybrid in ORTrain
#define BITMAP_ENABLE_KL0_COMPUTE_SPEEDUP             (1<<8) // if set, enable speeding up of the KL0 computation
//#define Not used   (1<<9)                              // if set, enable measurement of echo-on PSD
#define BITMAP_ENABLE_ONEPASS_MEDLEY_FDQ              (1<<10) // if set, enable one-pass Medley MFDQ calculation using known reference (e.g., 0x7E for all message carrying tones)
#define BITMAP_ENABLE_FDQ_AFTER_MEDLEY                (1<<11) // if set, retrain FDQ or SNR after Medley

//==============================================================================
// TASK PROFILE   (OR 0x40 to indicate a RX Task, OR 0x80 to indicate a NTC task)
//==============================================================================
#define RX_TIMER_MAX_CNT                              (0xFFFFF);

#ifdef PROFILE_TASKS
#define NUM_OF_PROFILE_POINTS                26

#define TX_QT_DONE_TC_START                  (0)
#define TX_QT_DONE_TC_END                    (1)
#define TX_QT_DONE_NTC_START                 (0x80 | 2)
#define TX_QT_DONE_NTC_END                   (0x80 | 3)

#define RX_QT_DONE_TC_START                  (0x40 | 4)
#define RX_QT_DONE_TC_END                    (0x40 | 5)
#define RX_QT_DONE_NTC_START                 (0x80 | 0x40 | 6)
#define RX_QT_DONE_NTC_END                   (0x80 | 0x40 | 7)

#define RX_SHOWTIME_FC_DONE_TC_START         (0x40 | 8)
#define RX_SHOWTIME_FC_DONE_TC_END           (0x40 | 9)
#define RX_SHOWTIME_FC_DONE_NTC_START        (0x80 | 0x40 | 10)
#define RX_SHOWTIME_FC_DONE_NTC_END          (0x80 | 0x40 | 11)

#define RX_SHOWTIME_QT_DONE_TC_START         (0x40 | 12)
#define RX_SHOWTIME_QT_DONE_TC_END           (0x40 | 13)
#define RX_SHOWTIME_QT_DONE_NTC_START        (0x80 | 0x40 | 14)
#define RX_SHOWTIME_QT_DONE_NTC_END          (0x80 | 0x40 | 15)
#define RX_SHOWTIME_QT_DONE_DDSNRFDQ_STATES  (0x80 | 0x40 | 64)

#define TX_SHOWTIME_QT_DONE_TC_START         (16)
#define TX_SHOWTIME_QT_DONE_TC_END           (17)
#define TX_SHOWTIME_QT_DONE_NTC_START        (0x80 | 18)
#define TX_SHOWTIME_QT_DONE_NTC_END          (0x80 | 19)

#define TX_CUSTOMER_NTC_START                (0x80 | 20)
#define TX_CUSTOMER_NTC_END                  (0x80 | 21)
#define RX_CUSTOMER_NTC_START                (0x80 | 0x40 | 22)
#define RX_CUSTOMER_NTC_END                  (0x80 | 0x40 | 23)

#define TX_SHOWTIME_TXTIMER_TC_START         (24)
#define TX_SHOWTIME_TXTIMER_TC_END           (25)

#endif //PROFILE_TASKS

//XDSLRTFW-3362 (Start)
#ifdef PROFILE_TASKS_35B
//Showtime Tx FW tasks
#define ST_TX_TC_QT_DONE_SYNC_SYMBOL     (0x80 | 0)
#define ST_TX_TC_QT_DONE_DATA_SYMBOL     (0x80 | 1)
#define ST_TX_NTC_QT_DONE_SYNC_SYMBOL    (0x80 | 2)
#define ST_TX_NTC_QT_DONE_DATA_SYMBOL    (0x80 | 3)
//Showtime Rx FW tasks
#define ST_RX_TC_QT_DONE_SYNC_SYMBOL     (0x40 | 4)
#define ST_RX_TC_QT_DONE_DATA_SYMBOL     (0x40 | 5)
#define ST_RX_NTC_QT_DONE_SYNC_SYMBOL    (0x40 | 6)
#define ST_RX_NTC_QT_DONE_DATA_SYMBOL    (0x40 | 7)
#define ST_RX_TC_PMS_SYNC_SYMBOL         (0x40 | 8)
#define ST_RX_TC_PMS_DATA_SYMBOL         (0x40 | 9)
#define ST_RX_NTC_PMS_SYNC_SYMBOL        (0x40 | 10)
#define ST_RX_NTC_PMS_DATA_SYMBOL        (0x40 | 11)

#define CASCADE_ST_NUM_FW_TASKS          (12)

//Cascaded mode: Training and Showtime Mips count to
//know overall Mips consumption in TC & NTC tasks.
#define TX_QT_DONE_TC                    (0x80 | 0x20 | 0)
#define TX_QT_DONE_NTC                   (0x80 | 0x20 | 1)
#define RX_QT_DONE_TC                    (0x40 | 0x20 | 2)
#define RX_QT_DONE_NTC                   (0x40 | 0x20 | 3)
#define CASCADE_NUM_TC_NTC_FW_TASKS      (4)

#endif //#ifdef PROFILE_TASKS_35B
//XDSLRTFW-3362 (End)

#ifdef PROFILE_TASKS_VR9

#define FG_TASK_ID               (0)               //include all foreground tasks
#define FG_TC_TASK_ID            (1)             //include all time-critical tasks

#define FG_TX_TC_TASK_ID         (2)               //include all TX TC tasks
#define FG_RX_TC_TASK_ID         (3)               //include all RX TC tasks
#define FG_TX_NTC_TASK_ID        (4)               //include all TX NTC tasks
#define FG_RX_NTC_TASK_ID        (5)               //include all RX NTC tasks

#define NUM_OF_MIPS_CNTS         (6)

#endif //PROFILE_TASKS_VR9

/* olr and pm states */
#define L0_STEADY_STATE                   1
#define OLR_SEND_SYNC_INDICATOR           3
#define OLR_RECV_SYNC_INDICATOR           4
#define OLR_RECONFIGURE                   5
#define OLR_SEND_RTX_SYNC_INDICATOR       6
#define OLR_TX_TBLCP_WAIT                 18

#define L3_REQUEST                        13
#define L3_STEADY_STATE                   14

/* olr and pm events */
#define LOAD_BAT                    0x0001
#define LOAD_GAIN                   0x0002
#define LOAD_TRB                    0x0004
#define RECONFIG_BiGi               0x0008
#define RECONFIG_Lp                 0x0010
#define RECONFIG_Bpn                0x0020
#define RECONFIG_PCB                0x0040
#define READ_BAT                    0x0080
#define READ_GAIN                   0x0100

/* Inverted synch detection */
#define NEITHER   (-1)
#define REVERB    (0)
#define SEGUE     (1)

//4 bit response reason code:
#define RESP_BUSY                         0x01   // For OLR, L0,L2,L3 requests. Not valid response to L2 trim request.
#define RESP_INVALID_PARAMETERS           0x02   // For OLR, L0,L2, L2 trim, L3 requests.

#define RESP_NOT_ENABLED                  0x03
#define RESP_NOT_SUPPORTED                0x04

//STAT_OLRError 4-bit internal error code (common for OLR and PM)
#define REQ_INVALID_BiGi                  0x10
#define REQ_INVALID_Lp                    0x20
#define REQ_INVALID_Bpn                   0x30
#define REQ_INVALID_FRAMING_CONSTRAINT    0x40
#define REQ_NOT_IN_L0_STATE               0x50
#define REQ_NOT_IN_L2_STATE               0x60
#define REQ_INVALID_PCB                   0x70
#define REQ_VIOLATES_MARGIN               0x80
#define SYNCFRAME_INDICATOR_TIMEOUT       0x90
#define REQ_ACTION_DISABLED               0xA0


// defines to determine which background functions shall be re-queued after execution
#define DSH_REQUEUE_DSH_BG_SERVICE        0x0001
#define DSH_REQUEUE_NMP_BG_SERVICE        0x0002

//===========================================================================
// VDSL1/2 datarate conversion constants - from 4Kbps to 64Kbps (VDSL1) or
// 8Kbps (VDSL2)
//===========================================================================
#define VDSL1_DATARATE_CONVERSION         16
#define VDSL2_DATARATE_CONVERSION         2

//============================================================================
//The ACE filter control option
//============================================================================
#define ACE_DEFAULT_MODE      (0)         //whatever used before this check
#define ACE_EQ_MODE           (1)         //always in the equalizer mode
#define ACE_BYPASS_MODE       (2)         //always in the bypass mode
#define ACE_TEST_MODE         (3)         //always in the test mode (high-pass mode)
#define ACE_ADAPTIVE_MODE     (4)         //adaptively selection, either EQ or High-Pass mode
                                          //based on SNR metric
//=====================================================================
//VDSL framing constants
//======================================================================
#define FRAME_RATE_SHIFT_CNT     (10)

//=====================================================================
//QLN, Hlog, Hlin related constants
//=====================================================================
#define OUT_OF_BAND              (0xFFFF)
#define OUT_OF_RANGE_QLN         (255)
#define OUT_OF_RANGE_HLOG        (1023)
#define OUT_OF_RANGE_SNR         (255)
#define OUT_OF_RANGE_LATN        (1023)
#define OUT_OF_RANGE_SATN        (1023)
#define OUT_OF_RANGE_SNRM        (-512)
#define OUT_OF_RANGE_ACTATP      (-512)
#define OUT_OF_RANGE_ACTPSD      (255)
#define OUT_OF_RANGE_HLIN        (0x8000)

//===========================================================================
// VDSL2 Diagnostic Mode constants
//===========================================================================
#define NUM_SYMBOLS_PER_BIT_DIAG                (5)

#define NUM_SYMBOLS_FOR_BIT_SEARCH_ACCUM        (32)   //no. of symbols used for searching the bit boundary
#define LOG2_NUM_SYMBOLS_FOR_BIT_SEARCH_ACCUM   (5)      //log2(NUM_SYMBOLS_FOR_BIT_SEARCH_ACCUM)

#define DISABLE_LD_DEMOD_SOC_MSG                (0)
#define ENABLE_LD_DEMOD_SOC_MSG                 (1)
#define ENABLE_LD_DEMOD_CNT_UPDATE              (2)      //if set, only run the count update to maintain byte synch

// XDSLRTFW-3344 (Start_End)
#define LOG2SYMBOLCNT_MEASURE_QLN_DIAG          (8)   //256 symbols for diag. mode
#define LOG2SYMBOLCNT_MEASURE_QLN               (3)   // The symbols (averaging factor)increased 8 to
                                                // get better per-tone QLN

//===========================================================================
// constants for power
//===========================================================================
#define VAL_invsqrt_binw4_in_sqrtMHZ_12p4       (244) //round(2^4*sqrt(1/(4312.5*1e-6)))
#define VAL_invsqrt_binw8_in_sqrtMHZ_12p4       (172) //round(2^4*sqrt(1/(2*4312.5*1e-6)))
#define VAL_binw4_in_dBHZ_8p8                   (9305) //=(10*log(4312.5))*256
#define VAL_binw8_in_dBHZ_8p8                   (10076) //=(10*log(4312.5*2))*256

//===========================================================================
// constants for misc ontrol
//===========================================================================
#define DISABLE_PLL_IF_PILOT_LESS_THAN_THRESHOLD      (0x1)
#define FOLLOW_VER4_5_VDSL2_DRAFT_STANDARD            (0x2)
#define DISABLE_TX_PERIODIC_TRANSITION                (0x4)
#define DISABLE_RX_PERIODIC_TRANSITION                (0x8)
#define ENABLE_SYNCHRO2_DETECTION                     (0x10)
#define FORCE_MULTIPLE_OF_8_L_ADAPTIVE_RATE_BITLOAD   (0x20)
#define DISABLE_NESTED_INTERRUPTS                     (0x40)
#define IGNORE_BI0_TONES_FOR_NOMATP_COMPUTATION       (0x80)

#define ALLOW_RECNFG_FOR_VDSL2_US0_ONLY               (0x100)
#define FORCE_Sp_LESS_THAN_1                          (0x200)
#define  FORCE_MULTIPLE_OF_64_PILOTTONE               (0x400)
#define FORCE_D1_FOR_MAXDELAY0                        (0x800)
//XDSLRTFW-3554: DS datarate exceeds configured max (Start)
#define DISABLE_MIN_MAX_RATE_CHECK_IFEC_MODE          (0x1000)
#define ROUND_LP_TO_32KBPS                            (0x2000)
#define FLOOR_LP_TO_32KBPS                            (0x4000)
//XDSLRTFW-3554: DS datarate exceeds configured max (end)


#define DISABLE_ACCURATE_PERBp_COMPUTATION_FIX         (0x10000000)
//===========================================================================
// constants for sniffer operation
//===========================================================================
#define   SNIFFER_TX_DISABLE_VARGAIN                  0x1
#define SNIFFER_DISABLE_SWAP_TIMING                   0x2
#define   SNIFFER_PREPONE_GHSCODESWAP                 0x4
#define   SNIFFER_DISABLE_GHSSTATEMACHINE             0x8
#define   SNIFFER_DISABLE_GHSTIMEOUTCHECK             0x10
#define   SNIFFER_DISABLE_TRAININGSTATEMACHINE        0x20
#define   SNIFFER_RX_ENABLE_DDPILOT                   0x40
#define   SNIFFER_RX_BYPASS_SOC_MSG_INTERP            0x80
#define   SNIFFER_RX_RETRAIN_AFTER_SYNCHRO3           0x100
#define SNIFFER_PAUSE_AFTER_MSG                       0x80000000

//===========================================================================
// constants control SNR/FDQ calculation
//===========================================================================
#define SNRFDQCTRL_ALL_FW        (0)      // 0x0 -> FW based FDQ  + FW based SNR
#define SNRFDQCTRL_SYNCHFDQ_HW   (1)      // 0x1 -> HW based synch FDQ + FW based SNR
#define SNRFDQCTRL_SYNCHSNR_HW   (2)      // 0x2 -> FW based FDQ + HW based synch SNR
#define SNRFDQCTRL_ASYNCHSNR_HW  (4)      // 0x4 -> HW based asynch FDQ + HW based asynch SNR
#define SNRFDQCTRL_VECPOW_HW     (0x10)   // 0x10 -> HW based Vector Power

//===========================================================================
// VR9 - constants control port mode and AFE init
//===========================================================================

 //
 // PortModeControl_t
 //

 // valid values for uc_DualPortModePreferred and uc_DualPortModeCurrent
#define SINGLE_PORT_MODE        0
#define DUAL_PORT_MODE          1

 // valid values for uc_XdslModePreferred and uc_XdslModeCurrent
#define VDSL_PORT_MODE          0
#define ADSL_PORT_MODE          1

#define INVALID_MODE            0xFF

 // valid values for us_Signature0 and us_Signature1
#define BOOT_SIGNATURE_0        0x2468
#define BOOT_SIGNATURE_1        0xB11D

 #define MAX_BG_DURATION        8

 // valid values for uc_AfePowerUp
 #define AFE_COLD_START                   1
 #define AFE_1PORT_STARTED                2
 #define AFE_2PORTS_STARTED               3

 //XDSLRTFW-542: Platform_VR9_VRX318_AFE_InitStatus (START)
 //AFE Powerup status mask for "uc_AfePowerUp"
 #define AFE_POWERUP_MASK                 0x3
 //XDSLRTFW-542: Platform_VR9_VRX318_AFE_InitStatus (END)

 // valid values for uc_AfeInitState
 #define NO_AFE_EVENT                     0
 #define AFE_PORT1_INIT_REGS              1
 #define AFE_PORT1_INIT_REGS_DONE         2
 #define AFE_PORT1_INIT_3GLP              3
 #define AFE_PORT1_INIT_3GLP_DONE         4
 #define AFE_PORT1_FUSE_TUNE_TRIM         5
 #define AFE_PORT1_FUSE_TUNE_TRIM_DONE    6
 #define AFE_INIT_DONE                    7

 // boot errors used by loader_62
 #define BOOT_ERROR_INVALID_IMAGE                    0xE1
 #define BOOT_ERROR_INVALID_MEMEXT_SEL               0xE2
 #define BOOT_ERROR_XDMA_FAILURE                     0xE3

//--------------------------------------------------------------
//VR9 debug flag bitmap
//--------------------------------------------------------------

//gs_CRI_DbgCntl
#define CRI_DBG_CNTL_DISABLE_IFFT      (1<<0)
#define CRI_DBG_CNTL_DISABLE_TXQT      (1<<1)
#define CRI_DBG_CNTL_DISABLE_TXQTP     (1<<2)

#define CRI_DBG_CNTL_DISABLE_FFT       (1<<8)
#define CRI_DBG_CNTL_DISABLE_RXQT      (1<<9)
#define CRI_DBG_CNTL_DISABLE_RXQTP     (1<<10)

//gs_STR_DbgCntl
//(For Strymon filters, disable means bypass)
#define STR_DBG_CNTL_DISABLE_TXIIR     (1<<0)
#define STR_DBG_CNTL_DISABLE_SRC       (1<<1)
#define STR_DBG_CNTL_DISABLE_TXINP     (1<<2)
#define STR_DBG_CNTL_DISABLE_TXHB      (1<<3)

#define STR_DBG_CNTL_DISABLE_RXIIR     (1<<8)
#define STR_DBG_CNTL_DISABLE_RXDEC     (1<<9)

//set bit 0: disable FFT, set bit 1: disable RX QT




#define DS_RRC_BYTES                   3
#define US_RRC_BYTES                   3
#define DS_RRC_BITS                    (DS_RRC_BYTES*8)
#define US_RRC_BITS                    (US_RRC_BYTES*8)


// more to be defined when porting SOS feature
#define MAX_SOS_TONE_GROUPS            64

#define DELAY_MAX                      63
#define MAX_XDTU_TABLE_SIZE            4

// Defines for variable "gus_ReTxOptionsEnabled"
// Low byte definition is same as for CMV: CNFG 80 = CMD_RTX_Control
#define CPE_RETX_INCAPABLE               (0x000)
#define CPE_DS_RETX_CAPABLE              (0x001)
#define CPE_DS_US_RETX_CAPABLE           (0x002)
#define DS_INTRA_DTU_ILV_CAPABLE         (0x008)
#define US_INTRA_DTU_ILV_CAPABLE         (0x010)
#define G9984_ANNEXD_SUPPORT             (0x100) // Form this bit onwards (i.e. high byte) the bit definition
                                                 // from G.994.1 has to be used (i.e. uc_G9984_Extensions)
// -----------------------------------
#define CO_RETX_DS_OPT_BLK_ILV_SUPPPORT         (1)

// valid values for uc_OMSG1_DsReTxEnabled
#define RETX_SELECTED                           0
#define CO_RETX_INCAPABLE                       1
#define CO_RETX_CAPABLE                         2
#define CO_RETX_CAPABLE_BUT_NOT_SELECTED        3


// CMV: INFO2Map[INFO2_RETX_STATUS] = INFO 229 =  CMD_RTX_StatusGet
// valid values for gus_DsUsReTxStatus
// -----------------------------------
//XDSLRTFW-1193 Feature_US_VDSL2_ALL_UsReTx_CMV(START)
//XDSLRTFW-443: Feature_DS_VDSL2_All_ReTx_CMV_INFO_229 (Start)
#define RETX_NOT_USED                           0x00
#define RETX_DS_IN_USE                          0x01
#define US_RETX_IN_USE                          0x02
#define RETX_EXTENDED_MEMORY_IN_USE             0x04
#define RETX_DS_INTRA_DTU_ILV_IN_USE            0x08
#define RETX_US_INTRA_DTU_ILV_IN_USE            0x10
#define FORCE_DISABLE_US_RETX_FOR_AVINAX        0x100   // XDSLRTFW-2012 (Start_End)
#define FORCE_DISABLE_DS_INTRA_DTU_ILV_30a      0x200   // XDSLRTFW-3020 (Start_End)
#define FORCE_DISABLE_DS_INTRA_DTU_ILV_35bLite  0x400  // XDSLRTFW-3189 (Start_End)

// -----------------------------------
//XDSLRTFW-1617 (Start_End)
#define US_MAX_INTRA_DTU_ILV_D                  16
//XDSLRTFW-443: Feature_DS_VDSL2_All_ReTx_CMV_INFO_229 (End)
//XDSLRTFW-1193 Feature_US_VDSL2_ALL_UsReTx_CMV(END)

#define RPMS_DTU_FRAMING_TYPE_1                 0
#define RPMS_DTU_FRAMING_TYPE                   RPMS_DTU_FRAMING_TYPE_1

#define RPMS_ASSUMED_Qtx_DELAY                  16

#define HQV_NUM_ROW                   63
#define HQV_IDILV_NUM_ROW             62
#define HQV_IDILV_POW2_NUM_ROW        62
#define HQV_NUM_COLUMN                3
#define HQV_IDILV_NUM_COLUMN          3
#define HQV_IDILV_POW2_NUM_COLUMN     3

//XDSLRTFW-3493(Start)
#define HQV_MAX_ROWS                   (MAX(HQV_NUM_ROW, HQV_IDILV_POW2_NUM_ROW))
#define LP_DELTA                       (20000)
//XDSLRTFW-3493(End)

//#define QRETX_TRANS_TABLE_SIZE       (64*4)
#define QRETX_TRANS_TABLE_SIZE         (64*3)
#define TS_FUZZ_OFFSET                 2

#define SID_MODULO          256
#define TS_MODULO           255

// valid values for uc_DtuStat of ReTX_Params_t
#define GOOD_DTU            0
#define BAD_DTU             1
#define EMPTY_DTU           0xFF

// FIFO1 of LP1 will be populated with DTU info
#define RETX_FIFO1          1
#define RETX_LP1            1

// SID, TS, DTU_STAT
#define DTU_INFO_BYTES_IN_FIFO1                 (3) //4


#define G9935_G9932_VECTORING_DISABLED          0x0000 // Full Vectoring and any vectoring-friendly operation disabled
#define G9935_FULL_VECTORING_SUPPORT            0x0001 // G.993.5 Vectoring Support (DS+US)
#define G9932_FULL_VECTORING_FRIENDLY_SUPPORT   0x0002 // G.993.2 Annex Y (Full vectoring-friendly) Support
#define G9932_VECTORING_FRIENDLY_SUPPORT        0x0004 // Placeholder for G.993.2 Annex X (vectoring-friendly) Support
                                                    // Note: Not supported by FW so far

#define G9932_VECTORING_IR_NPR_DECIM            0x0001 // Fsub = 2

// Vectoring debug defines for variable guc_VecDebugSwitchEnable
#define VEC_DEBUG_SKIP_QUITESIGNAL_RPVEC1    0x04          // Skip setup QUITE signal on Non Sync Frames at R-P Vector1 state
#define VEC_DEBUG_SKIP_SIGNAL_RPVEC1         0x08          // Skip setup Iridia QT data path to send R-P_Vector1 signal at Sync frame
#define VEC_DEBUG_STOP_TX_RPVEC1             0x10          // Stop to transmit R-P-Vector1 signal for 1:30min or nearly for ever by changing the
                                                        // variables to:
                                                        //           mwd gl_RxStateTimeOutCount_ 1 7fffffff
                                                        //           mwd gl_TxStateTimeOutCount_ 1 7fffffff
#define VEC_DEBUG_DISABLE_OPVEC_FA           0x20          // Disable of frame alignment for O-P_Vector1
#define VEC_DEBUG_TRACE_OPVEC_TRANSIT        0x40          // Trace 15 superframes of O-P_Vector1/11 including the exit transition
#define VEC_DEBUG_ENABLE_DIF_OPVEC_ALGO      0x80          // For different usage

#define DEFAULT_PGA_IN_TRAIN                 (-9<<8)

/* XDSLRTFW-3898 */
// Bitfield:
// gt_Reconf_Hybrid_Coeff.s_control
// cmv INFO 119 0
#define RECONF_HYB_FORCE_HYBRID_SETTING          (0x0001)            // 0: FW selects hybrid coefs, 1: Hybrid coefs of cmv ... are used
#define RECONF_HYB_DISABLE_CPB_SEARCH            (0x0002)            // 0: CPB search is enabled,   1: CPB search is disabled
#define RECONF_HYB_DISABLE_CPC_SEARCH            (0x0004)            // 0: CPC search is enabled,   1: CPC search is disabled
#define USE_RX_POWER_INSTEAD_OF_RX_AMPL_FOR_RXVARGAINCONFIG   (0x1000)            // 0: use amplitude of signal,   1: use signal power
#define DO_FC_TUNING_BEFORE_FINAL_PGA_TRAINING                (0x2000)
#define ENABLE_ALL_HYB_FOR_NON_BRCM                           (0x4000)

#define VRX518_RECONF_HYB_NUM_SETTINGS       (4)
/* XDSLRTFW-3898 */
// ---------------------------------------------------
// LATN defines
// ---------------------------------------------------
#define NORMALIZATION_VAL_LATN_SATN          (54)     ///XDSLRTFW-3673 (Start_End)
//---------------------------------------------
//---------------------------------------------End_LATN

// ---------------------------------------------------
// KL0 defines and kl0 calculations.
// - used for ACE/Hybrid/TX-Band switching
// - used for intermediate fix 14bit cap on short loops
// ---------------------------------------------------
// KL0 Ref values measured from FW (unit 0.1 dB)
// Measured for 35b and checked with 17a reference points (0-1200m in steps of 200m)!
#define KL0_0M_PE04                         18
#define KL0_25M_PE04                        21
#define KL0_50M_PE04                        25
#define KL0_75M_PE04                        32
#define KL0_100M_PE04                       38
#define KL0_150M_PE04                       51
#define KL0_200M_PE04                       65
#define KL0_250M_PE04                       77
#define KL0_300M_PE04                       90
#define KL0_350M_PE04                       103
#define KL0_400M_PE04                       115
#define KL0_430M_PE04                       125
#define KL0_450M_PE04                       129
#define KL0_500M_PE04                       143
#define KL0_550M_PE04                       155
#define KL0_600M_PE04                       167
#define KL0_650M_PE04                       183
#define KL0_675M_PE04                       191
#define KL0_700M_PE04                       196
#define KL0_750M_PE04                       207
#define KL0_800M_PE04                       220
#define KL0_850M_PE04                       232
#define KL0_900M_PE04                       243
#define KL0_950M_PE04                       256
#define KL0_975M_PE04                       263
#define KL0_1000M_PE04                      269
#define KL0_1050M_PE04                      281
#define KL0_1100M_PE04                      292
#define KL0_1150M_PE04                      305
#define KL0_1200M_PE04                      317
#define KL0_1250M_PE04                      329
#define KL0_1300M_PE04                      340
#define KL0_1350M_PE04                      352
#define KL0_1400M_PE04                      364
#define KL0_1500M_PE04                      391   // old value

// Hybrid (RX) switching defines, used for array "gusa_SwitchingThreshRxHyb"
// - LATN/KL0 values
// - Array Idx
//--------------------------------------------
#define LATN_TRESH_SWITCH_TO_PROFILE_X_HYB     (0x0080)         //  0.5dB Q8.8, switching from special hybrid to profile hybrids and
                                                                //              switching from cap search {-5, -4, -2, +2, +4, +5} to cap search {-4, -2, +2, +4
#define LATN_TRESH_SWITCH_TO_PROFILE_17_HYB    (0x0E00)         // 14.00dB
#define LATN_TRESH_SWITCH_TO_PROFILE_8_HYB     (0x1600)         // 22.00dB
#define LATN_TRESH_SWITCH_TO_PROFILE_US0_HYB   (0x1E00)         // 30.00dB

#define KL0_TRESH_SWITCH_TO_PROFILE_X_HYB      (20)             //  0.5dB Q8.8, switching from special hybrid to profile hybrids and
                                                                //              switching from cap search {-5, -4, -2, +2, +4, +5} to cap search {-4, -2, +2, +4
#define KL0_TRESH_SWITCH_TO_PROFILE_17_HYB     (KL0_550M_PE04)  // 15.50dB {Villach KL0: 0x0f - 15.0dB Q8.8, switching from profile 35b/30a hybrids to profile 17a hybrids}
#define KL0_TRESH_SWITCH_TO_PROFILE_8_HYB      (KL0_850M_PE04)  // 22.00dB {Villach KL0: 0x19 - 25.0dB Q8.8, switching from profile 17a hybrids to profile 12x/8x hybrids}
#define KL0_TRESH_SWITCH_TO_PROFILE_US0_HYB    (KL0_1400M_PE04) // 30.00dB {Villach KL0: 0x21 - 33.0dB Q8.8, switching from profile 12/8 hybrids to profile US0 hybrids}

#define SWITCH_TO_PROFILE_X_HYB                (0)
#define SWITCH_TO_PROFILE_17_HYB               (1)
#define SWITCH_TO_PROFILE_8_HYB                (2)
#define SWITCH_TO_PROFILE_US0_HYB              (3)
#define RX_HYB_SWITCH_ARRAY_SIZE               (SWITCH_TO_PROFILE_US0_HYB + 1)

// US band (TX) switching defines, used for array "gusa_SwitchingThreshTxBands"
// - LATN/KL0 values
// - Array Idx
//--------------------------------------------
#define LATN_TRESH_SWITCH_TO_2BAND             (0x1600)         // 22dB -  880m PE04
#define LATN_TRESH_SWITCH_TO_1BAND             (0x1E00)         // 30dB - 1380m PE04
//XDSLRTFW-3916
// BDCM CPE US0 switch observed around 4400ft to 4500ft (XDSLRTFW-3916)
// Co configures US0 only from 4700ft. Changing TxFilter from 4700ft will not solve US
// Rate dip issue at 4500ft. So LATN based US0 switching is required around 4400ft/4500ft
// fine tune US0 switch logic to match BDCM CPE performance.
#define LATN_TRESH_SWITCH_TO_1BAND_CTL         (0x1B4D)         // 27.3dB - around 4400ft ANSI


#define KL0_TRESH_SWITCH_TO_2BAND              (KL0_900M_PE04)  // 22dB -  900m PE04
#define KL0_TRESH_SWITCH_TO_1BAND              (KL0_1400M_PE04) // 30dB - 1400m PE04

#define SWITCH_TO_1BAND_IDX0                   (0)
#define SWITCH_TO_2BAND_IDX1                   (1)
#define TX_BANDS_SWITCH_ARRAY_SIZE             (SWITCH_TO_2BAND_IDX1 + 1)

// ACE mode switching defines, used for array "gusa_SwitchingThreshAceMode"
// - LATN/KL0 values
// - Array Idx
//--------------------------------------------
#define LATN_TRESH_ACE_MODE_15PF               (0x0100)         //  1.0dB < LA <  2.5dB Q8.8
#define LATN_TRESH_ACE_MODE_30PF               (0x0280)         //  2.5dB < LA <  5.0dB Q8.8
#define LATN_TRESH_ACE_MODE_52DOT5PF           (0x0500)         //  5.0dB < LA < 14.0dB Q8.8
#define LATN_TRESH_ACE_MODE_15PF_LR            (0x0e00)         // 14.0dB < LA < 22.0dB Q8.8
#define LATN_TRESH_ACE_MODE_7DOT5PF            (0x1600)         // 22.0dB < LA < 30.0dB Q8.8
#define LATN_TRESH_ACE_MODE_OFF                (0x1E00)         // 30.0dB < LA

#define KL0_TRESH_ACE_MODE_15PF                (KL0_25M_PE04)   //  2.1dB < KL0 <  3.8dB (unit 0.1 dB) ( 25m -   75m PE04)
#define KL0_TRESH_ACE_MODE_30PF                (KL0_75M_PE04)   //  3.2dB < KL0 <  6.5dB (unit 0.1 dB) ( 75m -  150m PE04)
#define KL0_TRESH_ACE_MODE_52DOT5PF            (KL0_150M_PE04)  //  5.1dB < KL0 < 16.7dB (unit 0.1 dB) (150m -  600m PE04)
#define KL0_TRESH_ACE_MODE_15PF_LR             (KL0_600M_PE04)  // 16.7dB < KL0 < 25.6dB (unit 0.1 dB) (600m -  975m PE04)
#define KL0_TRESH_ACE_MODE_7DOT5PF             (KL0_975M_PE04)  // 26.3dB < KL0 < 36.4dB (unit 0.1 dB) (975m - 1400m PE04)
#define KL0_TRESH_ACE_MODE_OFF                 (KL0_1400M_PE04) // 36.4dB < KL0                        (     > 1400m PE04)

#define SWITCH_ACE_MODE_IDX0_15PF              (0)
#define SWITCH_ACE_MODE_IDX1_30PF              (1)
#define SWITCH_ACE_MODE_IDX2_52DOT5PF          (2)
#define SWITCH_ACE_MODE_IDX3_15PF_LR           (3)
#define SWITCH_ACE_MODE_IDX4_7DOT5PF           (4)
#define SWITCH_ACE_MODE_IDX5_OFF               (5)
#define ACE_MODE_SWITCH_ARRAY_SIZE             (SWITCH_ACE_MODE_IDX5_OFF + 1)


// XDSLRTFW-3300 (Start_End)
#define LATN_FOR_LIMIT_DS_MAX_BITS_HRT_5_0     (0x400) //4.0 dB for 150m


// KL0 / AELEM values
#define KL0_MIN_VALUE                          0           // see G.993.2, 12.3.3.2.2.1  R-MSG 1
#define KL0_MAX_VALUE                       1280           // 128dB in 0.1dB steps, see G.993.2, 12.3.3.2.2.1  R-MSG 1
#define KL0_OUT_OF_RANGE                    2047           // "Out of range" (greater than 128 dB), see G.997.1 (7.5.1.23.4)
#define KL0_UNUSED_BAND                     2048           // CMD_PBO_AELEM_Status_Get
                                                           //           Message Identifier: 0xEA03
                                                           //           CMV: INFO 234
#define NUM_CHANNELS_KL0_ESTIMATION         (32)           // No. of tones used to estimate kl0

#define KL0_START_BIN                       50
//---------------------------------------------
//---------------------------------------------End_KL0

// Defines for variable "gul_35bLiteConfig", which is used for 35B and 35BLite
#define EN_CASCADED_MODE                        0x00000001
#define EN_TXIIR_17MHZ_35B                      0x00000002
#define EN_RESTRICT_MAX_IDX_HQV_TO_54           0x00000004
#define EN_RESTRICT_MAX_DTU_PER_SYM_TO_3        0x00000008
#define EN_ADMA_COPYBETWEEN_XRAM_RTV            0x00000010
#define EN_BDCM_DS_TONES_GT_6000                0x00000020
#define EN_ST_QT_PMS_DONE_STATUS_TIME_SLOT      0x00000040
#define EN_HRT_5_0_SCHEDULING_FOR_CASCADED_MODE 0x00000080  //XDSLRTFW-2168 (Start_End)
// #define Not defined                            0x00000100
// #define Not defined                            0x00000200
// #define Not defined                            0x00000400
// #define Not defined                            0x00000800


// Defines for 35b
#define DS_START_IDX_35B                        4096
#define DS_END_IDX_35B                          8192



// Defines for variable "guc_TxRxCommunicator"
#define TX_COMMUNICATOR_RESET                  (0x00)
#define TX_IIRFILTER_RECONF_START              (0x01)
#define TX_IIRFILTER_RECONF_COMPLETED          (0x02)
#define TX_RMSG1_START                         (0x04)
//#ifdef MTK_VECTORING_SUPPORT
//Vectoring: signals between Rx and Tx state machine
#define TX_TIMING_ADVANCE_START                (0x08)
#define TX_TIMING_ADVANCE_COMPLETED            (0x10)
//#endif
#define TX_RPVECTOR1_START                     (0x20)
#define TX_TIMING_ADVANCE_TRAIN1_START         (0x40)
#define TX_TIMING_ADVANCE_TRAIN1_COMPLETED     (0x80)



// Defines for fct. VDSL2_BandControlGet()
#define BAND_CONTROL_UPDATE_DS                  0x01
#define BAND_CONTROL_UPDATE_US                  0x02
#define BAND_CONTROL_UPDATE_RFI                 0x04

// Defines for variable "guc_HybridAlgoCtrl"
// Note: Bit "HYB_ALGO_ECHO_BASED" is not independent from the bit "HYB_ALGO_GAIN_BASED"
//       HYB_ALGO_GAIN_BASED = 0  AND  HYB_ALGO_ECHO_BASED = 0  => SNR  based
//       HYB_ALGO_GAIN_BASED = 1  AND  HYB_ALGO_ECHO_BASED = 0  => GAIN based
//       HYB_ALGO_GAIN_BASED = 1  AND  HYB_ALGO_ECHO_BASED = 1  => ECHO based
#define HYB_ALGO_SNR_BASED                      0x00     // only long reach
#define HYB_ALGO_GAIN_BASED                     0x01     // DTAG: R6 for vectoring
#define HYB_ALGO_ECHO_BASED                     0x02     // AVM (R755...): R7 always (vect + non-vect) echo based, exception: long reach


// Defines for variable "gus_VectoringOptionsEnabled"
#define VEC_OPTIONS_DS_MASK                     0x0001
#define VEC_OPTIONS_US_MASK                     0x0002
#define VEC_OPTIONS_FULL_FRIENDLY_MASK          0x0004
#define VEC_OPTIONS_FRIENDLY_MASK               0x0008
#define VEC_OPTIONS_PILOT_SEQ_LEN_MULTI4_MASK   0x0010
#define VEC_OPTIONS_FDPS_US_MASK                0x0020
#define VEC_OPTIONS_OP_VEC1_DURATION_EXT_MASK   0x0040
#define VEC_OPTIONS_OP_VEC1_FLAG_TONES_MASK     0x0080
#define VEC_OPTIONS_TRANSCEIVER_ID_MASK         0x1000

// Defines for variable "gus_UseUS0OnlyCntrl"
#define TX_NUM_BAND_MASK                        0x00FF
#define TX_US0_ONLY_CONF_RX_HYB                 0x0100
#define TX_US0_ONLY_CONF_IIR                    0x0200
#define TX_US0_ONLY_CONF_POFIPOCO_LD            0x0400
#define TX_US0_ONLY_CONF_PSD_CEIL               0x0800
#define TX_US0US1_ONLY_INDICATION_CO            0x1000
#define TX_US0_ONLY_INDICATION_GHS              0x2000
#define TX_US0_ONLY_INDICATION_CO               0x4000
#define TX_US0_ONLY_INDICATION                  0x8000


// XDSLRTFW-1958 (Start)
#define INIT_SUCCESS                            0x80
#define INIT_CONFIG_ERROR                       0x81
#define INIT_CONFIG_NOT_FEASIBLE                0x82
#define INIT_STATUS_NOT_SUPPORTED               0x00
// XDSLRTFW-1958 (End)

// Ceiling defines
#define MAX_US0_CEILING                         (390)    // XDSLRTFW-1628
#define INITIAL_UP_PSDCEIL                      (520)    // -52.dB
#define DISABLE_US0_CEILING                     (0x8000) // XDSLRTFW-2819

#define KL0_MIN_VALUE                           0 // see G.993.2, 12.3.3.2.2.1  R-MSG 1
#define KL0_MAX_VALUE                           1280 // 128dB in 0.1dB steps, see G.993.2, 12.3.3.2.2.1  R-MSG 1
#define KL0_OUT_OF_RANGE                        2047 // "Out of range" (greater than 128 dB), see G.997.1 (7.5.1.23.4)
#define KL0_UNUSED_BAND                         2048 // CMD_PBO_AELEM_Status_Get
#define ELE_M0_METHOD_SLOPE_ALGO                (0) // XDSLRTFW-4052(Start_End)
#define ELE_M1_METHOD_PERCENTILE_ALGO           (1) // XDSLRTFW-4052(Start_End)
// XDSLRTFW-1877 (Start)
#define ATTNDR_METHOD_0 0
#define ATTNDR_METHOD_1 1
#define ATTNDR_METHOD_2 2
// XDSLRTFW-1877 (End)

//XDSLRTFW-3556 : VRx518 shows different method_0 attainable datarate than VR9(R7)  (Start)
// gt_DbgImprovedATTNDR.us ATTNDR_MISC_CONFIGURATION definition
#define ATTNDR_ALGO_1_FRAMING_BASED                            0
#define ATTNDR_ALGO_2_METHOD_0_CHANNEL_CAPACITY_BASED          1 // VR9-R7 like
#define ATTNDR_ALGO_3_RESERVED                                 2 // Reserved
#define ATTNDR_ALGO_4_RESERVED                                 3 // Reserved
//XDSLRTFW-3556 : VRx518 shows different method_0 attainable datarate than VR9(R7) (End)


//==============================================================================
//XDSLRTFW-1901: ADSL/VDSL ACTIVATION STATE MACHINE (START)
// ---------------- HANDSHAKE STATES (gsa_IndirectStat0[3])-----------------
#define VDSL2_INITIAL_TRANSACTION_STATE                  ( 0x0001 )
#define VDSL2_CLR                                        ( 0x0002 )
#define VDSL2_CL_OK_ACK1                                 ( 0x0003 )
#define VDSL2_PARTIAL_CL_ACK2                            ( 0x0004 )
#define VDSL2_MP                                         ( 0x0005 )
#define VDSL2_MR                                         ( 0x0006 )
#define VDSL2_MS                                         ( 0x0007 )
#define VDSL2_MS_OK_ACK1                                 ( 0x0008 )
#define VDSL2_PARIAL_MS_ACK2                             ( 0x0009 )
#define VDSL2_NAK_EF                                     ( 0x000A )
#define VDSL2_NAK_NR                                     ( 0x000B )
#define VDSL2_NAK_NS                                     ( 0x000C )
#define VDSL2_NAK_CD                                     ( 0x000D )

//---------VDSL2 CPE Vectoring Rx State (gsa_IndirectStat0[3])-----------------------
// ---------------- HANDSHAKE PHASE ------------------
#define VDSL2_R_C_TONES                                  ( 0x0001 )
#define VDSL2_R_C_GALF1                                  ( 0x0002 )
#define VDSL2_R_C_FLAG1                                  ( 0x0003 )
#define VDSL2_R_C_SILENT1                                ( 0x0004 )
#define VDSL2_R_C_FLAG2                                  ( 0x0005 )
#define VDSL2_R_C_GALF2                                  ( 0x0006 )

// ------------ CHANNEL DISCOVERY PHASE --------------
#define VDSL2_R_O_P_QUIET1                               ( 0x1001 )
#define VDSL2_R_O_P_VECTOR1                              ( 0x1002 )
#define VDSL2_R_O_P_CHANNEL_DISCOVERY_V1                 ( 0x1003 )
#define VDSL2_R_O_P_SYNCHRO_V1                           ( 0x1004 )
#define VDSL2_R_O_P_CHANNEL_DISCOVERY1                   ( 0x1005 )
#define VDSL2_R_O_P_SYNCHRO_1                            ( 0x1006 )
#define VDSL2_R_O_P_QUIET2_PILOT1                        ( 0x1007 )
#define VDSL2_R_O_P_PERIODIC1                            ( 0x1009 )
#define VDSL2_R_O_P_SYNCHRO_2                            ( 0x100A )
#define VDSL2_R_O_P_CHANNEL_DISCOVERY2                   ( 0x100B )
#define VDSL2_R_O_P_SYNCHRO_3                            ( 0x100C )

// -----------------TRAINING PHASE ----------------------
#define VDSL2_R_O_P_VECTOR1_1                            ( 0x100D )
#define VDSL2_R_O_P_TRAINING_V1                          ( 0x100E )
#define VDSL2_R_O_P_SYNCHRO_V2                           ( 0x100F )
#define VDSL2_R_O_P_TRAINING1                            ( 0x1010 )
#define VDSL2_R_O_P_SYNCHRO_4                            ( 0x1012 )
#define VDSL2_R_O_P_PILOT_2                              ( 0x1013 )
#define VDSL2_R_O_P_TEQ                                  ( 0x1014 )
#define VDSL2_R_O_P_ECT                                  ( 0x1015 )
#define VDSL2_R_O_P_PILOT_3                              ( 0x1016 )
#define VDSL2_R_O_P_PERIODIC2                            ( 0x1017 )
#define VDSL2_R_O_P_TRAINING2                            ( 0x1018 )
#define VDSL2_R_O_P_SYNCHRO_5                            ( 0x101A )
#define VDSL2_R_O_P_VECTOR2                              ( 0x101B )
#define VDSL2_R_O_P_SYNCHRO_V3                           ( 0x101C )
#define VDSL2_R_O_P_VECTOR2_1                            ( 0x101D )
#define VDSL2_R_O_P_SYNCHRO_V4                           ( 0x101E )

// --------CHANNEL ANALYSIS AND EXCHANGE PHASE ----------
#define VDSL2_R_O_P_MEDLEY                               ( 0x101F )
#define VDSL2_R_O_P_SYNCHRO_6                            ( 0x1020 )

// ---------------  SHOWTIME   ---------------------------
#define VDSL2_SHOWTIME_RX_NO_TC_SYNC                     ( 0x10D0 )
#define VDSL2_SHOWTIME_RX_WITH_TC_SYNC                   ( 0x10D1 )

// -------------------- FAIL STATE ----------------
#define VDSL2_FAIL_STATE_RX                              ( 0xFF )

// ============== SOC MESSAGES (gsa_IndirectStat0[2])==========================
#define VDSL2_R_O_ACK                                    ( 0x1000 )
#define VDSL2_R_O_SIGNATURE                              ( 0x1001 )
#define VDSL2_R_O_UPDATE                                 ( 0x1002 )
#define VDSL2_R_O_MSG1                                   ( 0x1003 )
#define VDSL2_R_O_PRM                                    ( 0x1004 )
#define VDSL2_R_O_TA_UPDATE                              ( 0x1005 )
#define VDSL2_R_O_TPS                                    ( 0x1006 )
#define VDSL2_R_O_PMS                                    ( 0x1007 )
#define VDSL2_R_O_PMD                                    ( 0x1008 )


//---------VDSL2 CPE Vectoring Tx State-----------------------
// ---------------- HANDSHAKE PHASE (gsa_IndirectStat0[4])---------------------
#define VDSL2_R_SILENT0                                  ( 0x0001 )
#define VDSL2_R_TONES_REQ                                ( 0x0002 )
#define VDSL2_R_SILENT1                                  ( 0x0003 )
#define VDSL2_R_TONE1                                    ( 0x0004 )
#define VDSL2_R_FLAG1                                    ( 0x0005 )
#define VDSL2_R_FLAG2                                    ( 0x0006 )
#define VDSL2_R_GALF2                                    ( 0x0007 )

// ------------ CHANNEL DISCOVERY PHASE -----------------
#define VDSL2_R_P_QUIET1                                 ( 0x2001 )
#define VDSL2_R_P_VECTOR1                                ( 0x2002 )
#define VDSL2_R_P_CHANNEL_DISCOVERY1                     ( 0x2003 )
#define VDSL2_R_P_SYNCHRO_1                              ( 0x2004 )
#define VDSL2_R_P_LINEPROBE                              ( 0x2005 )
#define VDSL2_R_P_PERIODIC1                              ( 0x2006 )
#define VDSL2_R_P_SYNCHRO_2                              ( 0x2007 )
#define VDSL2_R_P_CHANNEL_DISCOVERY2                     ( 0x2008 )
#define VDSL2_R_P_SYNCHRO_3                              ( 0x2009 )


// -------------- TRAINING PHASE ----------------------
#define VDSL2_R_P_QUIET2                                 ( 0x200A )
#define VDSL2_R_P_QUIET_V1                               ( 0x200A )
#define VDSL2_R_P_VECTOR1_1                              ( 0x200B )
#define VDSL2_R_P_TRAINING1                              ( 0x200C )
#define VDSL2_R_P_SYNCHRO_4                              ( 0x200D )
#define VDSL2_R_P_TEQ                                    ( 0x200E )
#define VDSL2_R_P_QUIET3                                 ( 0x200F )
#define VDSL2_R_P_ECT                                    ( 0x2010 )
#define VDSL2_R_P_PERIODIC2                              ( 0x2011 )
#define VDSL2_R_P_TRAINING2                              ( 0x2012 )
#define VDSL2_R_P_SYNCHRO_5                              ( 0x2013 )
#define VDSL2_R_P_VECTOR1_2                              ( 0x2014 )
#define VDSL2_R_P_SYNCHRO_V1                             ( 0x2015 )
#define VDSL2_R_P_VECTOR2                                ( 0x2016 )
#define VDSL2_R_P_SYNCHRO_V2                             ( 0x2017 )

// ------- CHANNEL ANALYSIS AND EXCHANGE PHASE ----------
#define VDSL2_R_P_MEDLEY                                 ( 0x2018 )
#define VDSL2_R_P_SYNCHRO_6                              ( 0x2019 )

// ------------------ SHOWTIME --------------------------
#define VDSL2_SHOWTIME_TX_NO_TC_SYNC                     ( 0x2050 )
#define VDSL2_SHOWTIME_TX_WITH_TC_SYNC                   ( 0x2051 )

// -------------------- FAIL STATE ----------------
#define VDSL2_FAIL_STATE_TX                              ( 0xFF )

//================== SOC MESSAGES (gsa_IndirectStat0[2])=================
#define VDSL2_R_ACK                                      ( 0x1080 )
#define VDSL2_R_MSG1                                     ( 0x1081 )
#define VDSL2_R_UPDATE                                   ( 0x1082 )
#define VDSL2_R_MSG2                                     ( 0x1083 )
#define VDSL2_R_PRM                                      ( 0x1084 )
#define VDSL2_R_TA_UPDATE                                ( 0x1085 )
#define VDSL2_R_TPS_ACK                                  ( 0x1086 )
#define VDSL2_R_PMS                                      ( 0x1087 )
#define VDSL2_R_PMD                                      ( 0x1088 )
//XDSLRTFW-1784 (Showtime Margin Equalization - START)
#define RMS_GAIN_INIT      0   //initial value
#define RMS_GAIN_ADD       1   //gain is added without viloating the rms constraint
#define RMS_GAIN_NOT_ADD   2   //gain cannot be added otherwise it will violate the rms constrain
#define RMS_GAIN_SKIP      3   //no gain can be added to this band anymore
#define NUM_RESERVED_BITS  2   //no. of reserved bits which may be cut in forcing number of 1-bit tone

#define REACH_RMS_LIMIT    1
#define REACH_MAX_BITS     2
//XDSLRTFW-1784 (Showtime Margin Equalization - END)

//XDSLRTFW-1901: ADSL/VDSL ACTIVATION STATE MACHINE (END)
// XDSLRTFW-2481 (Start)
#define NO_MI_OR_EXTRA_SHOWTIME_NOISE_DETECTED          (0x0000)
#define MICRO_INTERRUPTION_DETECTED                     (0x0001)
#define SUDDEN_SHOWTIME_NOISE_DETECTED                  (0x0002)
// XDSLRTFW-2481 (End)

// XDSLRTFW-3015 (Start)
#define ERASURE_METRIC_THRESHOLD_HIGH_DS_DR                       60  // ~>40000kbps
#define ERASURE_METRIC_THRESHOLD_MID_DS_DR                        20  // ~> 13000kbps
#define ED_THRESHOLD_FOR_PLL_DURING_EXTERNAL_NOISE_SHORT_LOOP     10
#define ED_THRESHOLD_FOR_PLL_DURING_EXTERNAL_NOISE_MID_LONG_LOOP  5
// XDSLRTFW-3015 (End)

//XDSLRTFW-2527 (Start)
#define LOW_OP_VECTOR_POWER        (0x01)
#define LOW_RX_PILOT_TONE_POWER    (0x02)
//XDSLRTFW-2527 (End)

//XDSLRTFW-2547(Start)
#define ReTx_SHINE_INP_41_REIN_INP_0  (0x1)
//XDSLRTFW-2547(End)

// XDSLRTFW-2774 (Start)
#define MAX_MIPS_LOGGING_COUNT            512      //1024
#define LOG2_MAX_MIPS_LOGGING_COUNT       9     //10      //log2( MAX_MIPS_LOGGING_COUNT)
// XDSLRTFW-2774 (End)

#define NUM_CEILING_VALUES 98

// Defines for gus_DebugControlVRX518, which should be later removed!
#define US_NOISE_DETECTION_EN                0x01
#define PGA_PREFI_FC_REDUCTION_EN            0x02
#define PREFI_IC_TUNE_06_VDSL_EN             0x04
#define ENA_TX_NOISESHAPER_VDSL17_35B        0x08
#define TX_US0_POFI_FC_SELECT_EN             0x10
#define ENA_TA_CONSIDER_FA                   0x20
#define ENA_KL0_BASED_SWITCHING              0x40
#define PGA_OF_CHDISC_FOR_TRANSTRAIN_EN      0x80
//#define Reserved                           0x100
#define CEILING_PER_LAST_TONE_EN             0x200
#define PGA1_SWITCH_NO_ACE_SWITCH            0x400
#define PREFI_GAIN_OVERSHOOT_PGA1_SWITCH     0x800
//#define Reserved                           0x1000
#define LD_POWER_DOWN_QUIET                  0x2000
#define US0_TRANSMISSION_DIS                 0x4000

// XDSLRTFW-3565 (Start)
// XDSLRTFW-3711 (Start)
// Please refer to MCAT 3.1 or above for the values used and their definitions
#define PPE_CLOCK_576MHz      (0x1)      // PPE32 clock frequency of 576 MHz
#define PPE_CLOCK_494MHz      (0x2)      // PPE32 clock frequency of 494 MHz
#define PPE_CLOCK_432MHz      (0x3)      // PPE32 clock frequency of 432 MHz
#define PPE_CLOCK_288MHz      (0x4)      // PPE32 clock frequency of 288 MHz

#define TRIGGER_PPE_WRITE     (0x10)            // This bit is used to trigger/force the PPE32 frequency
#define PPE_CLOCK_FREQ_MASK   (0x3)             // The PPE32 clock frequency which is to be forced (576 MHz or 494MHz or 432MHz or 288 MHz)

#define FSCALE_AUTO_OFF       (0x0)             // No change in PPE32 clock frequency.
#define FSCALE_AUTO_A         (0x1)             // PPE32 clock frequency is changed based on the profile or bonding capability
#define FSCALE_AUTO_B         (0x2)             // PPE32 clock frequency is changed based on the datarates after SRA (For Future, Not supported currently)
#define FSCALE_AUTO_C         (0x3)             // PPE32 clock frequency is changed based on the user traffic (For Future, Not supported currently)
// XDSLRTFW-3711 (End)
// XDSLRTFW-3565 (End)

// XDSLRTFW-3344 (Start)
#define QLN_PERTONE           (0x0)
#define HLOG_PERTONE          (0x1)
// XDSLRTFW-3344 (End)
#define SNR_OFFSET_TONEGROUPS           16   //XDSLRTFW-3823

// XDSLRTFW-4051 Fast downstream up shift SRA(start)
#define MAX_NO_OF_SRA_UPDATE_AFTER_SNRFDQ_UPDATE   (10)

#define FAST_DS_UPSHIFT_SRA_ENABLED                (0x0001)  // Control bit for runtime enabling/disable fast SRA feature
#define FAST_DS_SRA_USED_IN_PRESENT_LINK           (0x0002)  // Info bit for fast SRA
// XDSLRTFW-4051 Fast downstream up shift SRA(End)

// XDSLRTFW-4075 Optimize input arguments of Bitswap and SRA functions (Start)
#define FT_STOP_AT_MARGIN_THRESHOLD                (0x0001)    // bit 0
#define FT_FORCE_EVEN_1_BIT                        (0x0002)    // bit 1
#define FT_ADD_FINE_GAIN_PLUS_DELTA_LP             (0x0004)    // bit 2
#define FT_FAST_UPSHIFT_SRA_MODE                   (0x0008)    // bit 3
// XDSLRTFW-4075 Optimize input arguments of Bitswap and SRA functions (End)

#endif // _VDSL_CONST_H
