/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2005 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
#ifndef _VDSL_STATE_H
#define _VDSL_STATE_H
/*
*-------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   VDSL_STATE.H
*
*   VDSL States.
*
*-------------------------------------------------------------------------
*/

/*  general states */
#define UNKNOWN                              (0)
#define FAIL_TX                              (1)
#define FAIL_RX                              (2)

/*  temporary states to terminate processing */
#define DONE_TX                              (3)
#define DONE_RX                              (4)
#define STOP_TX                              (5)
#define STOP_RX                              (6)

/* Do nothing */
#define SLEEP_TX                             (7)
#define SLEEP_RX                             (8)


#define SAME_STATE                           (9)      //indicate the current state is as the same as the next state

      // ============== VDSL_CPE ====================================
      // ============================================================
// ----------- VDSL RT TX states ---------------
//#define R_P_QUITE1_TX                      (159) // Tx Transition state between G.Hs and VDSL2 training

#define R_MSG1_TX                            (10)
#define R_ACK_TX                             (11)
#define R_P_SYNCHRO1_TX                      (12)
#define R_MSG2_TX                            (13)
#define R_CONTRACT1_TX                       (14)
#define R_MARGIN_TX                          (15)
#define R_BG_TX                              (16)
#define R_P_SYNCHRO2_TX                      (17)

// ----------- VDSL  T1.413 states ---------------

#define R_ACT_REQ_TX                                    (98)
#define R_C_ACT_RX                                      (99)

// ----------- VDSL RT RX states ---------------
//#define R_O_P_QUITE1_RX                    (169) // Rx Transition state between G.Hs and VDSL2 training

#define R_O_TRAIN_RX                         (20)
#define R_O_SIGNATURE_RX                     (21)
#define R_O_UPDATE_RX                        (22)
#define R_O_MSG1_RX                          (23)
#define R_O_P_SYNCHRO1_RX                    (24)
#define R_O_MSG2_RX                          (25)
#define R_O_MEDLEY_TRAINING_RX               (26)
#define R_O_CONTRACT_RX                      (27)
#define R_O_BG_RX                            (28)
#define R_O_P_SYNCHRO2_RX                    (29)

#define R_SHOWTIME_TX                        (31)
#define R_O_SHOWTIME_RX                      (32)

#define R_PRE_SHOWTIME_TX                    (33)
#define R_O_PRE_SHOWTIME_RX                  (34)

//--------- VDSL2 CPE TX states -----------------
#define VDSL2_R_MSG1_TX                      (R_MSG1_TX) //=10, shared with VDSL1

//Discovery Phase TX States
#define VDSL2_R_TX_STATE_START               (40)
#define VDSL2_R_P_SYNCHRO1_TX                (40) //(VDSL2_R_TX_STATE_START+0)
#define VDSL2_R_P_LINEPROBE_TX               (41) //(VDSL2_R_TX_STATE_START+1)
#define VDSL2_R_P_PERIODIC1_TX               (42) //(VDSL2_R_TX_STATE_START+2)
#define VDSL2_R_P_SYNCHRO2_TX                (43) //(VDSL2_R_TX_STATE_START+3)
#define VDSL2_R_UPDATE_TX                    (44) //(VDSL2_R_TX_STATE_START+4)
#define VDSL2_R_PRM_TX                       (45) //(VDSL2_R_TX_STATE_START+5)
#define VDSL2_R_REPEAT_REQUEST_TX            (46) //(VDSL2_R_TX_STATE_START+6)
#define VDSL2_R_P_SYNCHRO3_TX                (47) //(VDSL2_R_TX_STATE_START+7)

//Training Phase TX States
#define VDSL2_R_P_QUIET2_TX                  (48) //(VDSL2_R_TX_STATE_START+8)
#define VDSL2_R_P_TRAIN1_TX                  (49) //(VDSL2_R_TX_STATE_START+9)
#define VDSL2_R_P_SYNCHRO4_TX                (50) //(VDSL2_R_TX_STATE_START+10)
#define VDSL2_R_P_TEQ_TX                     (51) //(VDSL2_R_TX_STATE_START+11)
#define VDSL2_R_P_QUIET3_TX                  (52) //(VDSL2_R_TX_STATE_START+12)
#define VDSL2_R_P_ECT_TX                     (53) //(VDSL2_R_TX_STATE_START+13)
#define VDSL2_R_P_PERIODIC2_TX               (54) //(VDSL2_R_TX_STATE_START+14)
#define VDSL2_R_P_TRAIN2_TX                  (55) //(VDSL2_R_TX_STATE_START+15)
#define VDSL2_R_TA_UPDATE_TX                 (56) //(VDSL2_R_TX_STATE_START+16)
#define VDSL2_R_ACK_TX                       (57) //(VDSL2_R_TX_STATE_START+17)
#define VDSL2_R_P_SYNCHRO5_TX                (58) //(VDSL2_R_TX_STATE_START+18)

//Exchange Phase TX States
#define VDSL2_R_P_MEDLEY_TX                  (59) //(VDSL2_R_TX_STATE_START+19)
#define VDSL2_R_MSG2_TX                      (60) //(VDSL2_R_TX_STATE_START+20)
#define VDSL2_R_TPS_ACK_TX                   (61) //(VDSL2_R_TX_STATE_START+21)
#define VDSL2_R_PMS_TX                       (62) //(VDSL2_R_TX_STATE_START+22)
#define VDSL2_R_PMD_TX                       (63) //(VDSL2_R_TX_STATE_START+23)
#define VDSL2_R_P_SYNCHRO6_TX                (64) //(VDSL2_R_TX_STATE_START+24)

//Diagnostic mode specific states
#define VDSL2_R_P_TRAIN3_TX                  (65) //(VDSL2_R_TX_STATE_START+25)
#define   VDSL2_R_MSG_LD_TX                  (66) //(VDSL2_R_TX_STATE_START+26)
#define VDSL2_R_P_SYNCHRO7_TX                (67) //(VDSL2_R_TX_STATE_START+27)
#define VDSL2_R_DIAG_DONE_TX                 (68) //(VDSL2_R_TX_STATE_START+28)

//---------- VDSL2 CPE RX states -------------------

//Discovery Phase RX States
#define VDSL2_R_O_TRAIN_RX                   (R_O_TRAIN_RX)       //=20, shared with VDSL1
#define VDSL2_R_O_SIGNATURE_RX               (R_O_SIGNATURE_RX)   //=21, shared with VDSL2

#define VDSL2_R_O_RX_STATE_START             (70)
#define VDSL2_R_O_P_SYNCHRO1_RX              (70) //(VDSL2_R_O_RX_STATE_START+0)
#define VDSL2_R_O_P_QUIET_PILOT1_RX          (71) //(VDSL2_R_O_RX_STATE_START+1)
#define VDSL2_R_O_P_PERIODIC1_RX             (72) //(VDSL2_R_O_RX_STATE_START+2)
#define VDSL2_R_O_P_SYNCHRO2_RX              (73) //(VDSL2_R_O_RX_STATE_START+3)
#define VDSL2_R_O_UPDATE_RX                  (74) //(VDSL2_R_O_RX_STATE_START+4)
#define VDSL2_R_O_PRM_RX                     (75) //(VDSL2_R_O_RX_STATE_START+5)
#define VDSL2_R_O_ACK_RX                     (76) //(VDSL2_R_O_RX_STATE_START+6)
#define VDSL2_R_O_P_SYNCHRO3_RX              (77) //(VDSL2_R_O_RX_STATE_START+7)

//Training Phase RX States
#define VDSL2_R_O_P_TRAIN1_RX                (78) //(VDSL2_R_O_RX_STATE_START+8)
#define VDSL2_R_O_P_SYNCHRO4_RX              (79) //(VDSL2_R_O_RX_STATE_START+9)
#define VDSL2_R_O_P_PILOT2_RX                (80) //(VDSL2_R_O_RX_STATE_START+10)
#define VDSL2_R_O_P_ECT_RX                   (81) //(VDSL2_R_O_RX_STATE_START+11)
#define VDSL2_R_O_P_TEQ_RX                   (82) //(VDSL2_R_O_RX_STATE_START+12)
#define VDSL2_R_O_P_PILOT3_RX                (83) //(VDSL2_R_O_RX_STATE_START+13)
#define VDSL2_R_O_P_PERIODIC2_RX             (84) //(VDSL2_R_O_RX_STATE_START+14)
#define VDSL2_R_O_TA_UPDATE_RX               (85) //(VDSL2_R_O_RX_STATE_START+15)
#define VDSL2_R_O_P_SYNCHRO5_RX              (86) //(VDSL2_R_O_RX_STATE_START+16)

//Exchange Phase RX States
#define VDSL2_R_O_MSG1_RX                    (87) //(VDSL2_R_O_RX_STATE_START+17)
#define VDSL2_R_O_P_MEDLEY_RX                (88) //(VDSL2_R_O_RX_STATE_START+18)
#define VDSL2_R_O_TPS_RX                     (89) //(VDSL2_R_O_RX_STATE_START+19)
#define VDSL2_R_O_PMS_RX                     (90) //(VDSL2_R_O_RX_STATE_START+20)
#define VDSL2_R_O_PMD_RX                     (91) //(VDSL2_R_O_RX_STATE_START+21)
#define VDSL2_R_O_PMD_ACK_RX                 (92) //(VDSL2_R_O_RX_STATE_START+22)
#define VDSL2_R_O_P_SYNCHRO6_RX              (93) //(VDSL2_R_O_RX_STATE_START+23)

//Diagnostic mode specific states
#define VDSL2_R_O_P_TRAIN3_RX                (94) //(VDSL2_R_O_RX_STATE_START+24)
#define VDSL2_R_O_P_SYNCHRO7_RX              (95) //(VDSL2_R_O_RX_STATE_START+25)
#define VDSL2_R_O_DIAG_DONE_RX               (96) //(VDSL2_R_O_RX_STATE_START+26)

// -------- VDSL2 CPE Bridge States ---------------------------

#define VDSL2_R_BRIDGE_STATE_START           (130)
#define VDSL2_R_MSG1_TX_BRIDGE               (130) //(VDSL2_R_BRIDGE_STATE_START+0)
#define VDSL2_R_O_SIGNATURE_RX_BRIDGE        (131) //(VDSL2_R_BRIDGE_STATE_START+1)
#define VDSL2_R_P_TRAIN1_TX_BRIDGE           (132) //(VDSL2_R_BRIDGE_STATE_START+2)
#define VDSL2_R_O_P_TRAIN1_RX_BRIDGE         (133) //(VDSL2_R_BRIDGE_STATE_START+3)
#define VDSL2_R_P_MEDLEY_TX_BRIDGE           (134) //(VDSL2_R_BRIDGE_STATE_START+4)
#define VDSL2_R_O_P_MEDLEY_RX_BRIDGE         (135) //(VDSL2_R_BRIDGE_STATE_START+5)

//-----------VDSL2 CPE Rx New State---------------
#define VDSL2_R_O_P_TRAINING1_COMMON_RX      (140)     // this state is shared between Vectoring and non Vectoring state code

// -------  CPE TX Handshake states -------------
#define GHS_START_STATE                      (150)    //Mei??? need to change to 40
#define R_SILENT0_TX                         (150) //(GHS_START_STATE+0)
#define R_TONES_REQ_TX                       (151) //(GHS_START_STATE+1)
#define R_SILENT1_TX                         (152) //(GHS_START_STATE+2)
#define R_TONE1_TX                           (153) //(GHS_START_STATE+3)
#define R_FLAG1_TX                           (154) //(GHS_START_STATE+4)
#define R_HS_MSG_TX                          (155) //(GHS_START_STATE+5)
#define R_GALF2_TX                           (156) //(GHS_START_STATE+6)
#define R_FLAG2_TX                           (157) //(GHS_START_STATE+7)
#define R_QUIET_EF1_TX                       (158) //(GHS_START_STATE+8)

#define GHS_TX_FIRST_STATE                   (150) //(GHS_START_STATE+0)
#define GHS_TX_LAST_STATE                    (158) //(GHS_START_STATE+8)

// Tx Transition state between G.Hs an  d VDSL2 training
#define R_P_QUITE1_TX                        (159)

// --------  CPE RX Handshake states ------------
#define R_C_SILENT1_RX                       (160) //(GHS_START_STATE+10)
#define R_C_TONES_RX                         (161) //(GHS_START_STATE+11)
#define R_C_GALF1_RX                         (162) //(GHS_START_STATE+12)
#define R_C_FLAG1_RX                         (163) //(GHS_START_STATE+13)
#define R_C_HS_MSG_RX                        (164) //(GHS_START_STATE+14)
#define R_C_FLAG2_RX                         (165) //(GHS_START_STATE+15)
#define R_C_GALF2_RX                         (166) //(GHS_START_STATE+16)
#define R_C_QUIET_EF1_RX                     (167) //(GHS_START_STATE+17)

#define GHS_RX_FIRST_STATE                   (160) //(GHS_START_STATE+10)
#define GHS_RX_LAST_STATE                    (167) //(GHS_START_STATE+17)

#define MAX_STATES                           (168) //(R_C_QUIET_EF1_RX+1)   //Mei??? Need to change if GHS_START_STATE is changed
                                                   // Need to verify for COCOMO
// Rx Transition state between G.Hs and VDSL2 training
#define R_O_P_QUITE1_RX                      (169)


//---------VDSL2 CPE Vectoring Rx State-----------------------

#define VDSL2_R_O_P_VECTOR1_RX               (180)
#define VDSL2_R_O_P_VECTOR1_1_RX             (181)
#define VDSL2_R_O_P_TRAINING_V1_RX           (182)
#define VDSL2_R_O_P_SYNCRO_V2_RX             (183)

#define VDSL2_R_O_P_VECTOR2_RX               (184)
#define VDSL2_R_O_P_SYNCHRO_V3_RX            (185)
#define VDSL2_R_0_P_VECTOR2_1_RX             (186)
#define VDSL2_R_O_P_SYNCHRO_V4_RX            (187)    // this rx state is not yet used in the FW


//---------VDSL2 CPE Vectoring Tx State-----------------------

#define VDSL2_R_P_VECTOR1_TX                 (190)
#define VDSL2_R_P_QUIET_V1_TX                (191)    // this tx state is not yet used in the FW
#define VDSL2_R_P_VECTOR1_1_TX               (192)

#define VDSL2_R_P_VECTOR1_2_TX               (193)
#define VDSL2_R_P_SYNCHRO_V1_TX              (194)
#define VDSL2_R_P_VECTOR2_TX                 (195)
#define VDSL2_R_P_SYNCHRO_V2_TX              (196)




//------------- Other VDSL2 Constants ---------------------------------
// VDSL2 State lengths

#define VDSL2_MAX_O_QUIET_TX_LENGTH          (1024)
#define VDSL2_MIN_O_QUIET_TX_LENGTH          (512)

#define VDSL2_DIAG_MAX_O_QUIET_TX_LENGTH     (16384)
#define VDSL2_DIAG_MIN_O_QUIET_TX_LENGTH     (8192)

#define VDSL2_O_IDLE1_TX_LENGTH              (1500)
#define VDSL2_O_P_QUIET_PILOT1_TX_LENGTH     (640)
#define VDSL2_P_PERIODIC1_TX_LENGTH          (2048)      //the length for the symbol size of (2N+beta)
#define VDSL2_R_P_QUIET2_LENGTH              (64)
#define VDSL2_R_IDLE1_TX_LENGTH              (512)
#define VDSL2_R_P_LINEPROBE_TX_LENGTH        (512)
#define VDSL2_MIN_R_IDLE_TX_TRAIN2           (128)      //should be >=128


//#ifdef MTK_VECTORING_SUPPORT
#define O_P_VECTOR1_MIN_LENGTH               (4 * 257)         // Minimum length of O_P_VECTOR1  4*257
#define O_P_VECTOR1_MAX_LENGTH               (1024 * 257)      // Maximum  length of O_P_VECTOR1  1024*257
//#endif
// VDSL2 CO timeout counts (the timeout is set based on 8Khz frame rate, for 4 kHz frame rate, it only need to be half of it)
#define TIMEOUT_CNT_RX_R_P_SYNCHRO1          (15+64+15+50)     //50 is extra allowance
#define TIMEOUT_CNT_RX_R_P_SYNCHRO2          (300)
#define TIMEOUT_CNT_RX_R_P_SYNCHRO4          (3000)
#define TIMEOUT_CNT_RX_R_P_SYNCHRO6          (750)

// VDSL CPE timeout counts
#define TIMEOUT_CNT_RX_O_P_SYNCHRO1          (64000)           //about 16 seconds
#define TIMEOUT_CNT_RX_O_P_SYNCHRO2          (200)
#define TIMEOUT_CNT_TWO_SECONDS              (16000+100)       //about 4 seconds
#define TIMEOUT_CNT_RX_MEDLEY                (40000)           //10 seconds

#define TIMEOUT_CNT_1_SECONDS                (4000)            //1 seconds

//Timeout used by both CO and CPE
#define TIMEOUT_CNT_RX_P_SYNCHRO7_DIAG       (32000)

//Durations of VDSL2 CO Requested Training states
#define VTU_O_EC_TRAIN_LENGTH                (16)     //should be 0 to 1024/64 (in unit of 64)
#define VTU_O_LOG2_EC_TRAIN_LENGTH           (10)     //log2(1024)
#define VTU_O_TEQ_TRAIN_LENGTH               (100)    //should be 0 to 16320/64
#define VTU_O_R_TEQ_TRAIN_LENGTH             (0)      //should be 0 to 16320/64
#define VTU_O_PERIODIC_LENGTH                (8)      //should be 0 to 2048/64

//Durations of VDSL2 RT Requested Training states
#define VTU_R_EC_TRAIN_LENGTH                (8)      //should be 0 to 1024/64 (in unit of 64)
#define VTU_R_TEQ_TRAIN_LENGTH               (16)     //should be 0 to 16320/64
#define VTU_R_O_TEQ_TRAIN_LENGTH             (0)      //should be 0 to 16320/64
#define VTU_R_PERIODIC_LENGTH                (8)      //should be 0 to 2048/64
#define VTU_R_P_TRAIN_LENGTH                 (16000/64) //calibrated based on the time needed for training



//==============================================================================
// State Lengths
//==============================================================================


#define R_O_P_SYNCHRO1_RX_TIMEOUT_LEN        (8000)
#define R_O_P_SYNCHRO2_RX_TIMEOUT_LEN        (8000)
#define R_O_CONTRACT_RX_TIMEOUT_LEN          (8000)
#define R_O_MSG2_RX_TIMEOUT_LEN              (8000)


#define FAIL_STATE_LEN                       (1000)   // 0.25 sec in 4kHz frame rate

#define STATE_TIMEOUT_LEN                    (80000)  // 20 sec in 4kHz frame rate
#define VECTORING_STATE_TIMEOUT_LEN          (O_P_VECTOR1_MAX_LENGTH + (O_P_VECTOR1_MIN_LENGTH << 7))
#define OP_VECTOR1_STATE_TIMEOUT_LEN         (O_P_VECTOR1_MAX_LENGTH<<3)
#define DIAG_MODE_STATE_TIMEOUT_LEN          (360000) // 90 sec

#define SWITCH_GLOBAL_TIMEOUT_TX             (0x01)
#define SWITCH_GLOBAL_TIMEOUT_RX             (0x02)

//Diagnostic state length
#define MEDLEY_DIAG_TX_LENGTH                (80000)  //was (32280) before

#endif /*  #ifndef _VDSL_STATE_H */
