/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C) 2016 Intel Corporation
    Copyright (C), 1994-2011 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   filename: vdsl_typedef.h
*
*   Header file for type definitions.
*
*-------------------------------------------------------------------------------
*/

// ***********************************************************************************************************
// vdsl_typedef.h
//
// History
//
// 16/05/2012 Vinjam: Code Pointers connected to Downstream Virtual Noise feature
//            Grep for XDSLRTFW-439: Feature_All_DS_All_All_SupportDsTxRefVirtualNoise
//
// 23/08/2012 VENKATESH: Workaround for XDSLRTFW-506 Lower DS Rates with INP > 2 cases & No Connect with INP = 16
//                       CMV INFO 232 Index 1 Bit 0x4 included, Default Enabled
//                    Grep for XDSLRTFW-506-TELEFONICA_MAXPROFILE-WORKAROUND-INP-CASES
//
// 27/11/2012 Ram: Merged IOP fix corresponding to JIRA XDSLRTFW-458
//                 Grep for: "XDSLRTFW-458: IOP_ALL_VDSL2_ALL_TACorrection"
//
// 17/01/2013 Ram: Fix added for JIRA 285 - Implement a 'Feature MAP' indicating the features supported by FW
//                 Added a new typedef as required by CMV 'DSL 20' (Refer Msg Spec ver 1.9 for more details on CMV)
//                 Grep for XDSLRTFW-285: Feature_ALL_ALL_ALL_Config_Modem_Feature_Map
//
// 29/01/2013 Sooraj: Added a new typedef to support CMV "INFO 234" used to convey the AELEM status
//                 Grep for: XDSLRTFW-487_VR9_VRX318_VDSL2_All_AELEM_Support (START)
//
// 24/04/2013 Vinjam: Added a new "IOP generic bits" to Customer IOP bits (CMV INFO 232 3 Bit#0) to enable/disable conveying AELEM capability in G.Hs CLR Message.
//                 It is controlled by Operator bits (CMV DSL 21). Based on the operator bits (DSL 21), Customer IOP bit (CMV INFO 232 3 Bit#0) will be enabled/disabled.
//                 Grep for XDSLRTFW-789 IOP_ALL_ALL_ALL_AelemCapabilityInGHsCLRMsg
//
// 06/05/2013 Varun : Added 4 new typedef to Debug Buffer Operation and control
//                Grep for "XDSLRTFW-598 FEATURE_ALL_ALL_ALL_Debug_Buffer" and
//                           "XDSLRTFW-600 FEATURE_ALL_ALL_ALL_Debug_Buffer"
//
// 20/06/2013 Anantha Ramu: EFTR calculated for reporting to API, in CMV CNTR 43. New element ul_EFTR_API added for ReTX_Stats_t.
//                          Grep for XDSLRTFW-974 Fix_DS_VDSL2_All_Reporting_ReTx_Counters
//
// 19/07/2013 Kannan: Changes to set the Tx Data pump setup
//                    Grep for "XDSLRTFW-1079 Feature_US_VDSL2_ALL_UsReTx"
//
// 24/07/2013 Ram: Incorporated review comments from Stefan. Look at JIRA 1098 for review comments.
//                 Grep for XDSLRTFW-1098: BugFix_DS_VDSL2_ALL_SES_Not_Incrementing_In_ReTx
//
// 27/08/2013  Varun :Modified code to make CMV CNFG 80 0 common for both DS and US ReTx
//                   Grep for "XDSLRTFW-1193 Feature_US_VDSL2_ALL_UsReTx_CMV"
//
// 06/09/2013 Ram: Added bug fix for 'No connect' with Vinax v1.4 CO when Bonding is enabled in CLR
//                 Grep for XDSLRTFW-1216: BugFix_ALL_ALL_IFTN_No_Connect_In_Bonding_Mode
//
// 10/09/2013 Sooraj: Added support for DS-SRA with ReTx
//                 Grep for XDSLRTFW-1063: SRAds_Support_with_DS_ReTx
//
// 13/09/13 Varun : Added stucture for configuaration parameter in US ReTx
//                  Grep for Feature_US_VDSL2_ALL_UsReTx_CMV
//
//
// 15/12/2014 Prashant: Following things are implemented wrt RetxDegug feature
//            1. Transmitter should offer an RRC codeword capture feature for up to 256 RRC CWs and capturing is started with the
//               first RRC CW where Nack[1:0] is unequal 0b00. (256 * 24bits to be stored).
//               Capture can be enabled by setting gt_RtxDbgCapture.us_RtxUsRrcCaptureCnt to 0. Once set to zero,
//               capture will start from first bad dtu and gt_RtxDbgCapture.us_RtxUsRrcCaptureCnt will be incremented upto 255.
//               To re-capture again set gt_RtxDbgCapture.us_RtxUsRrcCaptureCnt to 0.
//            2. Transmitter should offer the possibility to measure the actual roundtrip in number of DTUs per DTU from DTU TX insertion
//               until getting the first ACK info and should report the max./min. value captured during operation. (This already exist)
//               Reseting the measurement during operation is suppoterd now.
//            3. The structure RtxDbgCapture_t has been mapped to a new CMV INFO 241.
//    Grep for XDSLRTFW-1622
//
// 05/08/2015 Vinay: Added two more field to DSL 3 ( DSL 3 17 and DSL 3 18) to accomadate the pilot tone constellation for the pilot tone(only 1 being used).
//                   The first field represents the real part and the second field represents the imaginary part of the constellation.
//                   Grep: XDSLRTFW-214
//
// 21/9/2016 Sriram shastry  : NBN / VR9 DS performance is 100,871Mbps, expected is 103Mbps. vectoring+US&DS Retx
//       Internal 1-symbol HRTrx reduction in case of [RTX + G.Vector] operation for all  CO.
//      The test cases Vect=off with internal memory split show that the operator should not rely on a good internal split decision.
//      The internal split is not well-balanced for the wished service rates.
//      According to 998.4: + 1 sym can be ignored for vectoring+ 1 DTU (processing needs to wait for the last bit of each DTU)(+ 1 symbol because  of US/DS sync symbol alignment)
//      According to equation 1 of 9.5.1/G.998.4, it can be checked that the minimum required Qtx calculated by this equation (with the communicated HRT values and with the selected
//      framing parameters Q, NFEC1, L1) results to a required number of RTX buffer bytes Qtx*Q*H which exceeds the selected physical buffer size of MAXDELAYOCTETds/2 according to
//      D1.1/G.998.4 and would lead to a violation. It doesn't lead to a violation if the mentioned equation 1 doesn't take into account the extra +1 symbol
//      Added  debug code to  simulate  FW Internal Rein like disturber
//      1-symbol reduction in Qtx,min calculation:
//      It can be seen as a gap compensation. If only the ACK related gap occurs in the drawn triangle from start of Tack until end of Tret then
//      the +1 symbol in the Qtx,min calculation has to be taken into account. But if both gaps, the ACK related gap as well as the TX related gap,
//      occur within this triangle then these gaps are compensating each other w.r.t. Qtx,min demand and it is not needed to take into account the
//      +1 symbol in the Qtx,min calculation.
//      If both gaps occur in the triangle, two cases can be distinguished SSdsOffset >= 0 (SSds comes after SSus) and SSds <= 0 (Ssus comes after SSds).
//      For SSdsOffset >= 0, the ds gap must be located within Tret, the right triangle part. For SSdsOffset <= 0, the ds gap must be located within Tack,
//      the left triangle part.
//      If both transceivers have no DTU specific HRT contribution (HRT_RX_D=0, HRT_TX_D=0) then the only DTU specific contribution in the total roundtrip
//      is the DTU transmission time itself which is already considered extra in the Qtx,min equation (not included in the HRTs, outside Tack/Tret) and
//      shown in the drawings before the triangle.
//      So from the figures it could be derived:
//      No +1 symbol in the Qtx,min calculation needed if  -HRT_RX <= SSdsOffset <= HRT_TX
//      But w.r.t. the mentioned uncertainty in which HRTs the PMD associated transmission times are included the range should be reduced by a symbol, i.e.
//      No +1 symbol in the Qtx,min calculation needed if  -HRT_RX+1 <= SSdsOffset <= HRT_TX-1
//      CMV Description : TEST 52 0 "Value"  can be used to over write, Internal HRT Rx Symb used in RTX  Framing generation.
//       Default setting : Disable [ TEST 52 0 0]
//      Grep for : XDSLRTFW-2858
//
// 22/11/2017 Abu Rahman
//            XDSLRTFW-3556: VRx518 shows different method_0 attainable datarate than VR9(R7)
//            Introduced a CMV based option to select Method_0 framing based DS ATTNDR or
//            channel capacity based DS ATTNDR calculation algorithm.
//                Set CNFG 86 3 = 0 : to select frame based Method_0 ATTNDR algorithm or
//                Set CNFG 86 3 = 1 : to select channel capacity based Method_0 ATTNDR algorithm (VR9-R7 like)
//            Note that this switching works only with Method_0 configuration
//            SEARCH PATTERN: XDSLRTFW-3556
//14/12/2018 Sriram Shastry :XDSLRTFW-4052 : Low upstream data rates in 30a profile
//   Improvement for Kl0 alogorithm estimation for  30a profile
//   Control option to use AELEM for reporting KL0
//   Control option to set  Kl0 in RMSG1
//   Control option to set AELEM method instead of  KL0 method
//   Control option to Enable/disble psdpreprocessing (inter polation) 
//   Initialize AELEM structure (gt_AELEM_UPBOInfo) and rename the structure variable
//  Grep for XDSLRTFW-4052
// ************************************************************************************************************

#include "eoc.h"
#include "vdsl_compiler.h"   // #ifdef ANXQ_35BLITE

#ifndef _VDSL_TYPEDEF_H
#define _VDSL_TYPEDEF_H

// Misc modem configuration / VDSL-mode only configurations
typedef struct {
   int16 s_DsMinConstSize; // min # of bits per tone
   int16 s_DsMaxConstSize; // max # of bits per tone
   int16 s_DsMaxNumEocBytes; // max # of EOC bytes per frame
   int16 s_DsMaxNumVocBytes; // max # of VOC bytes per frame

   int16 s_UsMinConstSize; // min # of bits per tone
   int16 s_UsMaxConstSize; // max # of bits per tone
   int16 s_UsMaxNumEocBytes; // max # of EOC bytes per frame
   int16 s_UsMaxNumVocBytes; // max # of VOC bytes per frame
} ModemConfig_t;

//==============================================================================
// Utility Structures
//==============================================================================
typedef struct {
   uint32 ul_MinNetDataRate;        // in multiple of 4kbps
   uint32 ul_MaxNetDataRate;        // in multiple of 4kbps
   uint32 ul_MinResNetDataRate;     // in multiple of 4kbps
   int16  s_MaxLatency;             // maxDelay
   uint8  uc_MaxBER;                // [uc_TPSTCoptions|uc_MaxBER], i.e.
   uint8  uc_TPSTCoptions;          // [RES[4]|CIpolicy[2]|ShortPacket_PTMds|Preempt_PTMds||RES[6]|BER_PTMds[2]]
   int16  s_IMAxINP;
// Note: For VRX518 the MspSpc defines a reserved parameter between PTM and ATM parameters for R10 onwards.
//       This is needed to get the alignment to the 32bit NetDataRate variables.
//       !!It is done automaticaly by the compiler incase of an array definition of this type, e.g.
//         TPS_TC_Type_t ta_TpsTcType[MAX_TPS_TC_TYPE_API];!!
//   uint16 us_Res;                   // alignment 16bit word
} TPS_TC_Type_t;

// Band Control Utility Structures
typedef struct {
   uint16   us_FirstTone;         // First tone of band
   uint16   us_LastTone;         // Last tone of band
} BandRecord_t;

typedef struct {
   uint16   us_IndexOfTone;            // Index of tone being described
   int16   s_PSDLevelOfTone;         // Attenuation below MAXNOMPSD in steps of 0.5 dB
   uint16   us_InSupportedSet;         // Supported Set
} PSDRecord_t;

  //XDSLRTFW-2260 (Start)
typedef struct {
   uint16   us_IndexOfTone;            // Index of tone being described
   int16   s_PSDLevelOfTone;         // Compensation value in dB*10 format
} PSDCompRecord_t;
  //XDSLRTFW-2260 (End)

//XDSLRTFW-2059 (START)
// !!!! Note !!!! Very Important !!!!
// The size of this structure should always be multiple of 4 bytes, if not DMA from
// SDRAM will fail. If size not a multiple of 4 bytes, please add uint8 variable(s)
// to this structure as "padding bytes".
typedef struct {
    PSDCompRecord_t   ut_PSDRecord[9];
} PSDCompDescriptorTable_t;

typedef struct {
    uint16 us_TxIIRFilter;  //Unity = 0; SingleUS0 VDSL = 1, DaubleUS0 VDSL = 2, ISDN = 3, 35B = 4, SingleUS0 ADSL = 5 DaubleUS0 ADSL = 6
    uint16 us_PofiPocoCutOffFreq; // 33MHz, 20 MHz, 10 MHz, 5 MHz
    int16 s_PofiExtraGain;  // -12dB, -6dB, 0dB
    int16 s_PofiGain;
    uint16 us_FilterCompIdx;
    uint16 us_NumberOfCompBreakPoint;   // # of tones described in the generic PSD Descriptor Table
    PSDCompDescriptorTable_t t_PSDCompTable;
} PSDCompData_t;
//XDSLRTFW-2059 (End)



typedef struct {
   int16   s_a;         // Attenuation below MAXNOMPSD in steps of 0.01 dB
   int16   s_b;         // Inband shaping scale factor in steps of 0.01 dB
} UPBOPSDRecord_t;

//XDSLRTFW-3020 (Start)
typedef struct{
   uint32 ul_Lp;
   int16  s_Np;
   int16  s_Qp;
} ReTxForcedFraming_t;
//XDSLRTFW-3020 (End)
//==============================================================================
// Modem configuration variables (CMV able)
// Data structures that ME 'generally' configures
// In normal mode of operation used by CO only
// We connect these in RT mode too for sleep state, showtime only tests etc
//==============================================================================
// TPS-TC (bearer channel) control
// Note: The API and PP driver is not supporting STM!
typedef struct {
   int16 s_Control;

// Note: For VRX518 the MspSpc defines a reserved parameter for R10 onwards.
//       This is needed to get the alignment to the 32bit NetDataRate variables.
//       !!This is done automaticaly by the compiler!!
//   uint16 us_Res;        // alignment 16bit word
   TPS_TC_Type_t ta_TpsTcType[MAX_TPS_TC_TYPE_API];
} TPS_TC_BearerChannel_t;

// PMS-TC (latency path) control
typedef struct {
   uint32 ul_MaxDataRate;           // in multiple of 4kbps
   int16 s_MaxR;
   int16 s_MaxD;
} PMS_TC_LatencyPath_t;

// Min Overhead Rate control
typedef struct {
   uint16 us_DsMinMsgOHR;
   uint16 us_UsMinMsgOHR;
} MinMsgOHR_t;

// SNR margin configuration (DS/US target/min/max)
typedef struct {
   int16 s_TARSNRMds; // 0-31 dB with 0.1 dB step (default 6 dB)
   int16 s_TARSNRMus; // 0-31 dB with 0.1 dB step (default 6 dB)
   int16 s_MAXSNRMds; // 0-31 dB with 0.1 dB step (default 6 dB)
   int16 s_MAXSNRMus; // 0-31 dB with 0.1 dB step (default 6 dB)
   int16 s_MINSNRMds; // 0-31 dB with 0.1 dB step (default 6 dB)
   int16 s_MINSNRMus; // 0-31 dB with 0.1 dB step (default 6 dB)
} SnrMgnConfig_t;

typedef struct {
   int16  s_NM_Delta;    // NM - NoiseMargin Default: 0 dB; Range: -5 to +5 dB in 0.1 dB steps
   int16  s_NM_Ctrl;     // Bit field
   int16  s_max_NMS_Gain_ToBe_considered;  // 8.8 dB format, Max threshold variable
   int16  s_min_NMS_Gain_ToBe_considered;  // 8.8 dB format, Lower threshold variable, it applies only to high noise cases.
   int16  s_max_Used_NMS_Gain;             // 8.8 dB format
   int16  s_min_Used_NMS_Gain;             // 8.8 dB format
} NoiseMarginChange_t;

//XDSLRTFW-3823
typedef struct {
   int16  s_ToneGroupStartIdx;    // Start Index in a Tone group
   int16  s_ToneGroupSNROffset;   // Offset value in 8.8 format dB for SNR.
} SNROffsetChange_t;
typedef struct {
   int16  s_NoOfToneGroups;    // No Of tone groups
   SNROffsetChange_t ta_SNROffset[SNR_OFFSET_TONEGROUPS];// ToneIdx, SNR Offset
} SNROffsetControl_t;

// Auto SRA Ctrl Structure
typedef struct {
  uint16 us_RA_DSNRM;
  uint16 us_RA_DTIME;
  uint16 us_RA_USNRM;
  uint16 us_RA_UTIME;
} AutoSRA_t;

typedef struct {
   int16   s_Dn_MaxNomPSD;      //For CO, Dn means Transmit power and for CPE, Dn means receive power
   int16   s_Up_MaxNomPSD;      //For CO, Up means Receive power and for CPE, Up means transmit power
   int16   s_Dn_MaxNomAggrPwr; //Same comment as above
   int16   s_Up_MaxNomAggrPwr; //Same comment as above
   int16   s_Up_MaxAggrPwr; //Same comment as above
   int16   s_Dn_InitialPsdCeiling;   //Initial Downstream PSD ceiling
   int16   s_Up_InitialPsdCeiling;   //Initial Upstream PSD ceiling
   int16   s_Dn_ProposedPsdCeiling;   //Proposed Downstream PSD ceiling
   int16   s_Up_ProposedPsdCeiling;   //Proposed Upstream PSD ceiling
} PwrConfigParam_t;

// DS/US Band Control Structures
typedef struct {
   uint16         us_NumberOfBands;   //Number of bands described in the PSD Descriptor Table
   BandRecord_t   ut_BandRecord[MAX_NUM_BANDS];
} BandDescriptorTable_t;

// PSD Control Structures
typedef struct {
   uint16 us_NumberOfTones; // # of tones described in the generic PSD Descriptor Table
   PSDRecord_t   ut_PSDRecord[MAX_NUM_PSD_POINTS];
} PSDDescriptorTable_t;
 //XDSLRTFW-2260 (Start))
typedef struct {
   uint16 us_NumberOfTones; // # of tones described in the generic PSD Descriptor Table
    PSDCompRecord_t   ut_PSDRecord[MAX_NUM_RX_EXTERNAL_GAIN_CALIBRATION_POINTS];
} PSDCompDescriptorTable16_t;

typedef struct {
   uint16 us_NumberOfTones; // # of tones described in the generic PSD Descriptor Table
    PSDCompRecord_t   ut_PSDRecord[MAX_NUM_TX_EXTERNAL_GAIN_CALIBRATION_POINTS];
} PSDCompDescriptorTable32_t;

typedef struct {
   uint16 us_NumberOfTones; // # of tones described in the generic PSD Descriptor Table
   //PSDCompRecord_t   ut_PSDRecord[MAX_NUM_PSD_POINTS];
    PSDCompRecord_t   ut_PSDRecord[MAX_NUM_RX_PATH_GAIN_CALIBRATION_POINTS+MAX_NUM_RX_EXTERNAL_GAIN_CALIBRATION_POINTS];
} PSDCompDescriptorTableCombined_t;

 //XDSLRTFW-2260 (End)
typedef struct {
   uint16 us_NumberOfTones; // # of tones described in the DS PSD Descriptor Table
   PSDRecord_t   ut_PSDRecord[MAX_NUM_DS_PSD_POINTS];
} DsPSDDescriptorTable_t;

typedef struct {
   uint16 us_NumberOfTones; // # of tones described in the DS PSD Descriptor Table
   PSDRecord_t ut_PSDRecord[MAX_NUM_DS_REFPSD_POINTS];
} DsRefPSDDescriptorTable_t;

typedef struct {
   uint16 us_NumberOfTones; // # of tones described in the US PSD Descriptor Table
   PSDRecord_t   ut_PSDRecord[MAX_NUM_US_PSD_POINTS];
} UsPSDDescriptorTable_t;

//XDSLRTFW-439: Feature_All_DS_All_All_SupportDsTxRefVirtualNoise (Start)
typedef struct {
   uint16 us_NumberOfTones; // # of tones described in the DS Virtual Noise PSD Descriptor Table
   PSDRecord_t   ut_PSDRecord[MAX_NUM_VN_DS_PSD_POINTS];
} DsVnPSDDescriptorTable_t;
//XDSLRTFW-439: Feature_All_DS_All_All_SupportDsTxRefVirtualNoise (End)

typedef struct {
   uint16 us_NumberOfTones; // # of tones described in the US Virtual Noise PSD Descriptor Table
   PSDRecord_t   ut_PSDRecord[MAX_NUM_VN_US_PSD_POINTS];
} UsVnPSDDescriptorTable_t;

typedef struct {
   uint16 us_NumberOfTones; // # of tones described in the raw TSSI PSD Descriptor Table
   PSDRecord_t   ut_PSDRecord[MAX_NUM_US_RAW_TSSI_PSD_POINTS];
} UsRawTssiPSDDescriptorTable_t;

typedef struct {
   uint16 us_NumberOfTones; // # of tones described in the integrated TSSI PSD Descriptor Table
   PSDRecord_t   ut_PSDRecord[MAX_NUM_US_TSSI_PSD_POINTS];
} UsTssiPSDDescriptorTable_t;

typedef struct {
   uint16         us_NumberOfBands;   //Number of bands described in the UPBOPSD Descriptor Table
   UPBOPSDRecord_t   ut_UPBOPSDRecord[MAX_NUM_UPBO_BANDS];
   uint16           usa_kl0_REF[MAX_NUM_UPBO_BANDS]; // Ref kl0 in steps of 0.1 dB (see Amendment 2)
} UPBOPSDDescriptorTable_t;

   typedef struct {
      uint16 us_NumberOfTones; // # of tones described in the integrated TSSI PSD Descriptor Table
      PSDRecord_t   ut_PSDRecord[MAX_NUM_RX_PATH_GAIN_CALIBRATION_POINTS];
   } RxPathGainPSDDescriptorTable_t;

// Profile Control
typedef struct {
   // 0x00 - None,
   // 0x01 - V2_PROFILE_8A,0x02 - V2_PROFILE_8B, 0x04 - V2_PROFILE_8C,
   // 0x08 - V2_PROFILE_8D,0x10 - V2_PROFILE_12A,0x20 - V2_PROFILE_12B,
   // 0x40 - V2_PROFILE_17A,0x80 - V2_PROFILE_30A
   uint16 us_ProfileSupported;
   uint16 us_ProfilePreferred;

   // 0x00 - None,
   // 0x01 - V2_ANXA_US0_EU_32,0x02 - V2_ANXA_US0_EU_36, 0x04 - V2_ANXA_US0_EU_40,
   // 0x08 - V2_ANXA_US0_EU_44,0x10 - V2_ANXA_US0_EU_48,0x20 - V2_ANXA_US0_EU_52,
   // 0x40 - V2_ANXA_US0_EU_56,0x80 - V2_ANXA_US0_EU_60,0x100 - V2_ANXA_US0_EU_64
   // 0x200 - V2_ANXA_US0_ADLU_32,0x400 - V2_ANXA_US0_ADLU_36, 0x800 - V2_ANXA_US0_ADLU_40,
   // 0x1000 - V2_ANXA_US0_ADLU_44,0x2000 - V2_ANXA_US0_ADLU_48,0x4000 - V2_ANXA_US0_ADLU_52,
   // 0x8000 - V2_ANXA_US0_ADLU_56,0x10000 - V2_ANXA_US0_ADLU_60,0x20000 - V2_ANXA_US0_ADLU_64
   // 0x40000 - V2_ANXA_US0_IN_12B,0x80000 - V2_ANXA_US0_IN_17A
   uint32 ul_AnxAUS0PsdSupported;
   uint32 ul_AnxAUS0PsdPreferred;

   // 0x00 - None,
   // 0x01 - V2_ANXB_US0_25_138,0x02 - V2_ANXB_US0_25_276, 0x04 - V2_ANXB_US0_120_276,
   // 0x08 - V2_ANXB_US0_IN_12B,0x10 - V2_ANXB_US0_IN_17A
   uint16 us_AnxBUS0PsdSupported;
   uint16 us_AnxBUS0PsdPreferred;

   // 0x00 - None,
   uint16 us_AnxCUS0PsdSupported;
   uint16 us_AnxCUS0PsdPreferred;

} ProfileControl_t;

// RFI Band Control Structures
typedef struct {
   uint16         us_NumberOfBands;   //Number of bands described in the PSD Descriptor Table
   BandRecord_t   ut_BandRecord[MAX_NUM_RFI_BANDS];
} RFIBandDescriptorTable_t;


//==============================================================================
// Modem configured variables
//==============================================================================

// Line Atten (LATN), Signal Atten (SATN) and SNR margin structure
typedef struct {
    int16 s_LATN; // in q8.8 dB format ?
    int16 s_SATN; // in q8.8 dB format ?
    int16 s_SNRM; // in q8.8 dB format ?
} AttenSnrM_t;

// LATN, SATN and SNRM per Rx band
typedef struct {
    uint16       us_NumberOfBands;   // Number of bands
    AttenSnrM_t  t_AttenSnrM[MAX_NUM_RX_BANDS];
} AttenSnrMPerRxBand_t;

// Actual Profile Selected
typedef struct {
   uint16 us_GvectorSelected;    // Table 11.68.10 in G.994.1

   // 0x00 - None,
   // 0x01 - V2_PROFILE_8A,0x02 - V2_PROFILE_8B, 0x04 - V2_PROFILE_8C,
   // 0x08 - V2_PROFILE_8D,0x10 - V2_PROFILE_12A,0x20 - V2_PROFILE_12B,
   // 0x40 - V2_PROFILE_17A,0x80 - V2_PROFILE_30A
   uint16 us_ProfileSelected;

   // 0x00 - None,
   // 0x0001 - V2_ANXA_US0_EU_32, 0x0002 - V2_ANXA_US0_EU_36, 0x0004 - V2_ANXA_US0_EU_40, 0x0008 - V2_ANXA_US0_EU_44,
   // 0x0010 - V2_ANXA_US0_EU_48, 0x0020 - V2_ANXA_US0_EU_52, 0x0040 - V2_ANXA_US0_EU_56, 0x0080 - V2_ANXA_US0_EU_60,
   // 0x0100 - V2_ANXA_US0_EU_64,
   // 0x0200 - V2_ANXA_US0_ADLU_32, 0x0400 - V2_ANXA_US0_ADLU_36, 0x0800 - V2_ANXA_US0_ADLU_40,
   // 0x1000 - V2_ANXA_US0_ADLU_44, 0x2000 - V2_ANXA_US0_ADLU_48, 0x4000 - V2_ANXA_US0_ADLU_52, 0x8000 - V2_ANXA_US0_ADLU_56,
   // 0x10000 - V2_ANXA_US0_ADLU_60,0x20000 - V2_ANXA_US0_ADLU_64, 0x40000 - Reserved, 0x80000 - Reserved,
   // 0x100000 - V2_ANXA_US0_EU_128_MASK, 0x200000 - V2_ANXA_US0_ADLU_128_MASK
   uint32 ul_AnxAUS0PsdSelected;

   // 0x00 - None,
   // 0x01 - V2_ANXB_US0_25_138,0x02 - V2_ANXB_US0_25_276, 0x04 - V2_ANXB_US0_120_276,
   // 0x08 - V2_ANXB_US0_IN_12B,0x10 - V2_ANXB_US0_IN_17A
   uint16 us_AnxBUS0PsdSelected;

   // 0x00 - None,
   uint16 us_AnxCUS0PsdSelected;

} ProfileActual_t;

//==============================================================================
// Psd Analysis (LATN, SATN, HLOG) input parameters
//==============================================================================
typedef struct {
   int16* psa_Psd;            //pointer to PSD measurement

   int16 s_PGA_set;         //PGA setting at PSD measurement time
   int16 s_RxVarGainDB;      //RxVarGaindB setting at PSD measurement time
   int16 s_ResidualGain;      //ResidualGain setting at PSD measurement time

} PsdAnalysisInput_t;

//==============================================================================
// Bitload input parameters
//==============================================================================

typedef uint8 TxToneFlags[(TX_MAX_NUM_TONES+7)>>3];   // Byte array containing one bit per tone.
typedef uint8 RxToneFlags[(RX_MAX_NUM_TONES+7)>>3];   // Byte array containing one bit per tone.

// holds all input parameters for bitloading algorithm
// may be negotiated via GHS and O-MSG2/R-MSG2
typedef struct {
   int16 s_MinRate; // in multiple of 64 kbps
   int16 s_MaxRate; // in multiple of 64 kbps
   int16 s_MaxR; // max value of check byte
   int16 s_MaxD; // max value of interleave depth
   int16 s_MinSnrMgn; // dB in Q8.8 format
   int16 s_TarSnrMgn; // dB in Q8.8 format
   int16 s_MaxInlvDelay; // in terms of 0.5 ms
   int32 l_MaxInlvMemory;
   int16 s_MaxNumEocBytes;
   int16 s_MaxNumVocBytes;
} BitloadParam_t;


// wng+
// holds all the input parameters for the framing parameter selection module
// Note: MinRate and MaxRate are unsigned (follow the standard)
typedef struct {
   // Inputs related to latency path and bearer channel mapping
   // Note: current framing parameter selection module only handle single latency and single bearer channel
   int16 s_BCtoLP[NUM_BEARER_CHANNELS];

   // Inputs coming from VDSL2 Profile
   int16 s_Dmax;           // D <= Dmax
   int16 s_OneOverSmax;   // 1/S <= 1/Smax
   int16 s_fs;             // symbol rate in ksymbols/s

   // Input negotiated in SOC messages (i.e. O/R-MSG1, O/R-TPS)
   uint16 us_MinRate;      // Min Net Data Rate (in 8 kbps) - definition same as Table 12-43 (v5.4)
   uint16 us_MaxRate;      // Max Net Data Rate (in 8 kbps) - ditto
   int16 s_MinMsgOHR;      // Min Message-based Overhead Rate (in kbps)
   int16 s_MaxMsgOHR;      // Max Message-based Overhead Rate (in kbps).  NOTE: this is actually not exchanged, but keep it here with MinMsgOHR
   int16 s_MinDelay;      // Min Delay (in ms).  NOTE: Annex K specifies that for ATM bonding, MinDelay can be set by ME or derived from "MinDelay = MaxDelay - MaxDelayVariation".
   int16 s_MaxDelay;      // Max Delay (in ms)
   int16 s_MinINP;         // Min INP (in DMT symbols).  Valid value from 0 to 16 symbols.
   int16 s_OHFrameType;   // 1=OHFrameType1, 2=OHFrameType2.  NOTE: this is actually not exchanged, but can be specified from ME.
   int16 s_MinR;
   int16 s_MaxR;
   int16 s_RStep;
   //XDSLRTFW-1619: VDSL_CI_Policy1_2 (Start/End)
   uint8 uc_ChannelInitPolicy;  // 0=Margin optimized, 1=INP optimized
} VDSL2FramingParamsInputs_t;

//==============================================================================
// Framing, Showtime structures
//==============================================================================

typedef struct {

   int16 s_B[NUM_BEARER_CHANNELS]; // payload

   // per latency variables
   int16 s_U[NUM_DATA_PATHS]; // # data bytes per frame (including dummy bye)
   int16 s_Dz[NUM_DATA_PATHS]; // # dummy bytes for payload adaptation per H frames
   int16 s_E[NUM_DATA_PATHS]; // # overhead bytes per frame
   int16 s_Drs[NUM_DATA_PATHS]; // # RS dummy bytes per N frames
   int16 s_K[NUM_DATA_PATHS]; // # information bytes in a RS codeword
   int16 s_R[NUM_DATA_PATHS]; // RS check bytes
   int16 s_N[NUM_DATA_PATHS]; // RS codeword length
   int16 s_P[NUM_DATA_PATHS]; // # RS encoded bytes per frame
   int16 s_M[NUM_DATA_PATHS]; // interleaving depth parameter
   int16 s_I[NUM_DATA_PATHS]; // interleaver block length
   int16 s_q[NUM_DATA_PATHS]; // N/I
   int16 s_D[NUM_DATA_PATHS]; // interleave depth D=M*I+1
} Config_t;

typedef struct {

   int16 sa_Bpn[NUM_DATA_PATHS][NUM_BEARER_CHANNELS];
                                 // payload
   // per latency variables
   int16 s_Tp[NUM_DATA_PATHS];            // Number of mux data frames in an OH sub-frame
   int16 s_Gp[NUM_DATA_PATHS];            // Total number of ovhd octets in an OH sub-frame
   int16 s_Fp[NUM_DATA_PATHS];            // Total number of ovhd frames in an OH superframe
   int16 s_Mp[NUM_DATA_PATHS];            // Number of mux data frames in a codeword
   uint32 ul_Lp[NUM_DATA_PATHS];            // The number of bits transmitted per data symbol
   int16 s_Rp[NUM_DATA_PATHS];            // Number of check bytes per codeword
   int16 s_Ip[NUM_DATA_PATHS];            // interleaver block length
   int16 s_Dp[NUM_DATA_PATHS];            // Interleaver depth parameter

   // Derived parameters
   int16 s_PERp[NUM_DATA_PATHS];         // Period of OH in ms
   int32 l_DRp[NUM_DATA_PATHS];         // The line data rate
   int16 s_Nfecp[NUM_DATA_PATHS];         // Size of codeword per latency path in bytes
   int16 s_q[NUM_DATA_PATHS];            // N/I
   int16 s_SEQp[NUM_DATA_PATHS];         // Number of OH bytes in the OH frame
   int16 s_Up[NUM_DATA_PATHS];            // Number of OH sub-frames in the OH frame
   int32 l_PERBp[NUM_DATA_PATHS];         // Number of bytes in OH frame
   int16 s_MSGc;                     // # of octets in message based portion of overhead structure

   int16 s_OHSWITCHp[NUM_DATA_PATHS];      // Number of MDFs at the start of each block
                                 // of Tp frames that have TX_OH1RATE overhead bytes
                                 // per frame

   int16 s_OHRate2p[NUM_DATA_PATHS];      // Number of ovhd bytes per MDF in frames OH2Switch
                                 // to (Tp -1)

   int16 s_OHRate1p[NUM_DATA_PATHS];      // Number of ovhd bytes per MDF in frames 0 to (Tp -1)
   int16 s_INPp[NUM_DATA_PATHS];         // INP value
// XDSRTFW-442: Feature_All_All_All_All_Vdsl2Sra [Start]
// OLR related framing
    int16 s_Nlp;                                // Number of active latency paths
    uint32 ul_Reconfig_Lp[NUM_DATA_PATHS];      // New Lp value for OLR
    int16 s_Reconfig_Dp[NUM_DATA_PATHS];        // New Dp value for OLR
    int16 s_Reconfig_Tp[NUM_DATA_PATHS];        // New Tp value for OLR
    int16 s_Reconfig_Gp[NUM_DATA_PATHS];        // New Gp value for OLR
    int16 sa_Reconfig_Bpn[NUM_DATA_PATHS][NUM_BEARER_CHANNELS];     // New Bpn value for OLR
// XDSRTFW-442: Feature_All_All_All_All_Vdsl2Sra [End]

} VDSL2Config_t;

typedef struct {
   int16  s_Path;
   int16  s_Nfec;
   int16  s_Rp;
   uint32 ul_Lp;
   uint16 us_Gp;
   uint16 us_Mp;
   uint16 us_Tp;

} VDSL2ComputeRates_t;

typedef struct {

   int16 s_BCtoLP[NUM_BEARER_CHANNELS];   // LP # assigned to BCx, 0: LP0, 1: LP1
   int16 s_IBITSlp;                  // LP # carrying indicator bits
                                 // It is the same as MSGlp for VDSL2

   int16 s_BCtoTPS[NUM_BEARER_CHANNELS];   // TPS-TC type assigned to BCx, 0:Disabled, 1:BC0, 2:BC1
   int16 s_LPtoABC[NUM_DATA_PATHS];      // ATM BC # assigned to LPx, 0: ABC0, 1: ABC1, 0xF: no ATM

} BC_LP_TPS_Map_t;

//==============================================================================
// IB structures (see VDSL spec 10.3 OAM primitives)
//==============================================================================

typedef struct {
   // members corresponding to IB
   uint8 uc_be_anom[NUM_DATA_PATHS];   // Block Error (BE) anomaly
   uint8 uc_fec_anom[NUM_DATA_PATHS];   // Forward Error Correction (FEC) anomaly
   uint8 uc_los_def;               // Loss of Signal (LOS) defect
   uint8 uc_sef_def;               // Severely Errored Frame (SEF) defect - used to generate LOF
   uint8 uc_pro_fail;               // Power Off (PRO) failure of CPE to CO. CPE sends DGASP by
                              // setting bit 6 set in IB for 3 continuos superframes.
   uint8 uc_lpr_def;               // Loss of Power (LPR) defect
   uint8 uc_lom_fail;               // Loss of Margin - When average SNR margin falls 6 dB below reference
                              // SNR margin set by operator
   uint8 uc_lol_fail;               // Loss of Link - no DGASP but LOS is present
   uint8 uc_ese_def;               // Excessive Serverely Errored seconds anomaly
   //XDSLRTFW-956 : ENH_DS_ALL_ALL_SESx_ESx_LOMx
   uint8 uc_es_def;               // Errored seconds anomaly
   uint8 uc_hec_anom[NUM_DATA_PATHS];   // HEC Error Check
   uint8 uc_ncd_anom[NUM_DATA_PATHS];   // No Cell Delineation
   uint8 uc_ocd_anom[NUM_DATA_PATHS];   // Out of Cell Delineation
   uint8 uc_lcd_def[NUM_DATA_PATHS];   // Loss of Cell Delineation (LCD) defect flag
   uint8 uc_fpo_def;               // Set when a PRO failure happens; At the CPE only
   // members used internally
   uint8 uc_cd_flag[NUM_DATA_PATHS];   // Cell Delineation (CD) flag
   int16 s_ocd_cnt[NUM_DATA_PATHS];   // count of consecutice OCD anomalies
   uint8 uc_atm_state[NUM_DATA_PATHS];   // indicates different states in UpdateATMAnomaly()
   uint8 uc_oos_def;               // out of Sync (OOS) defect XDSLRTFW-2094/2050
} TxIbDataStruct_t;

typedef struct {
   // members corresponding to IB
   uint8 uc_febe_anom[NUM_DATA_PATHS]; // Far-end Block Error (FEBE) anomaly
   uint8 uc_ffec_anom[NUM_DATA_PATHS]; // Far-end Forward Error Correction (FFEC) anomaly
   uint8 uc_flos_def;               // Far-end Loss of Signal (FLOS) defect
   uint8 uc_frdi_def;               // Far-end Remote Defect Indication (FRDI) defect
   uint8 uc_fpo_anom;               // Far-end Power Off (FPO) failure
   uint8 uc_flpr_def;               // Far-end Loss of Power (FLPR) defect
   uint8 uc_flom_fail;               // Far-end Loss of Margin
   uint8 uc_flol_fail;               // Far End Loss of Link - no DGASP but LOS is present
   uint8 uc_fese_def;               //Excessive Serverely Errored seconds
   uint8 uc_fhec_anom[NUM_DATA_PATHS]; // Far-end HEC Error Check
   uint8 uc_fncd_anom[NUM_DATA_PATHS]; // Far-end No Cell Delineation
   uint8 uc_focd_anom[NUM_DATA_PATHS]; // Far-end Out of Cell Delineation
   uint8 uc_flcd_def[NUM_DATA_PATHS]; // Far-end Loss of Cell Delineation
   // members used internally
   uint8 uc_flos_ind;               // to process LOS defect
   uint8 uc_flos_hist;               // to process LOS defect
   uint8 uc_fncd_ind[NUM_DATA_PATHS];
   uint8 uc_fncd_hist[NUM_DATA_PATHS];
   uint8 uc_atm_state[NUM_DATA_PATHS];   //Indicates whether we are in SYNC, NCD/OCD or LCD state
   int16 s_fncd_cnt[NUM_DATA_PATHS];   //How many ncds' have been received
} RxIbDataStruct_t;

//==============================================================================
// Alphaeus (ATM) structures
//==============================================================================

typedef struct {
   // global registers
   uint16 us_UtopiaTxEnable[ATM_NUM_BC];
   uint16 us_UtopiaRxEnable[ATM_NUM_BC];
   uint16 us_UtopiaAddress[ATM_NUM_BC];
   uint16 us_DcpEnable;
   uint16 us_DcpAddress;
   uint16 us_DcpVciValue;
   uint16 us_DcpVpiValue;
   // TX registers
   uint16 us_TxPstmMode;
   uint16 us_TxIntfMode[ATM_NUM_BC];
   uint16 us_TxCBNumPage[ATM_NUM_BC];
   uint16 us_TxCBStartAddr[ATM_NUM_BC];
   // RX registers
   uint16 us_RxPstmMode;
   uint16 us_RxIntfMode[ATM_NUM_BC];
   uint16 us_RxCBNumPage[ATM_NUM_BC];
   uint16 us_RxCBStartAddr[ATM_NUM_BC];
   uint16 us_RxInsertImaHec;
} AlphaeusConfig_t;

//==============================================================================
// AFE configuration structures
//==============================================================================

typedef struct {
   // global registers
   uint16 us_AFERegOp;       //XDSLRTFW-3705 (Start_End)
   uint16 us_AFERegAddr;
   uint16 us_AFERegData;
} AFEConfig_t;

//==============================================================================
// Algorithm Control Structures
//==============================================================================

typedef struct {
   int16 s_AlgHandlerState;
   int16 s_AlgLog2NumFramesToAccum;
} PgaConfig_t;

typedef struct {
   int16 s_AlgHandlerState;
   int16 s_AlgLog2NumFramesToAccum;
   int16 s_NumChannelsPerGroup;
   int16 s_MinNumIterations;
   int16 s_MaxNumIterations;
   int16 s_MaxAlignmentOffset;
} FrameAlignConfig_t;

typedef struct {
   int16 s_AlgHandlerState;
   int16 s_AlgLog2NumFramesToAccum;
   int16 s_NumChannelsPerGroup;
} FdqConfig_t;


typedef struct {
   int16 s_AlgHandlerState;
   int16 s_AlgLog2NumFramesToAccum;
   int16 s_NumChannelsPerGroup;
} SnrConfig_t;

typedef struct {
   int16 s_AlgHandlerState;
   int16 s_AlgLog2NumFramesToAccum;
   int16 s_MedleyAlignOffsetStep;      // the frame re-alignment step
   int16 s_NumOfMedleyAlignPoints;      //the number of frame realignment offsets to test
} SnrFrameAlignConfig_t;

typedef struct {
   int16 s_AlgHandlerState;
   int16 s_AlgLog2NumFramesToAccum;
   int16 s_NumChannelsPerGroup;
   // 0x0 - No o/p buffer i.e. we do not save the vector o/p as we go to next tone group
   // 0x1 - Initialize o/p buffer with vector o/p and increment buffer pointer for next tone group
   // 0x2 - Add o/p buffer with vector o/p and increment buffer pointer for next tone group
   int16 s_AlgCalcType;
   int16 s_FirstChannel;
   int16 s_LastChannel;
} PsdConfig_t;

typedef struct {
   int16 s_AlgHandlerState;
   int16 s_AlgLog2NumFramesToAccum;
   int16 s_DDSnrFdqNumChannelsPerGroup;
} DDSnrFdqConfig_t;

typedef struct {
   int16 s_TxParrEnable;
} TxParrConfig_t;

// INFO CMV -
typedef struct {
  // for vdsl modes (ifft length > 2048)
  int16 s_mu_vdsl;
  int16 s_scalar_A_offset_dB_vdsl;      //parr "ceiling", in dB above rms signal.
  int16 s_pvec_scale_2p14_vdsl;         //multiplicative scale to apply to parr vector 2.14 format.
  // for adsl modes (ifft length <= 2048)
  int16 s_mu_adsl;
  int16 s_scalar_A_offset_dB_adsl;      //parr "ceiling", in dB above rms signal.
  int16 s_pvec_scale_2p14_adsl;         //multiplicative scale to apply to parr vector 2.14 format.
  // shared vdsl/adsl
  uint16 us_NumTones;
  int16 s_tone[NUM_PARR_TONES];
} ParrTones_t;

typedef struct {
   int16 s_AlgHandlerState;
   int16 s_AlgLog2NumFramesToAccum;
   int16 s_ErrorCode; // error indicators
   int16 s_NumMfdqTones; // # of tones at which MFDQ is applied
   int16 s_ReadToneStart; // physical tone index of starting tone
   int16 s_NumReadTone; // # of tones to read from HW
   int16 s_MfdqMargin; // extra bitload margin applied to MFDQ tones
   int16 *psa_MfdqTones; // pointer to array containing physical tone indices at which MFDQ is applied
   int16 *psa_FbckTones; // pointer to array containing physical tone indices for the corresponding feedback tones
   int16 *psa_FdqOutput; // pointer to SFDQ output
   int16 *psa_DecOutput; // pointer to final decision output
   int16 *psa_SfdqCoef; // pointer to original SFDQ coefficients
   uint8 *puca_SfdqExp; // pointer to original SFDQ exponents
   int32 *pla_CovMatrix; // pointer to accumulation buffer for covariance matrix
   int32 *pla_CorVector; // pointer to accumulation buffer for correlation vector
   int32 *pla_ToneTable; // pointer to MFDQ tone table
   int16 *psa_sf_coef; // pointer to MFDQ SFDQ coefficients
   uint8 *puca_sf_exp; // pointer to MFDQ SFDQ exponents
   int16 *psa_ff_coef; // pointer to MFDQ FeedForward coefficients
   uint8 *puca_ff_exp; // pointer to MFDQ FeedForward exponents
   int16 *psa_fb_coef; // pointer to MFDQ Feedback coefficients
   uint8 *puca_fb_exp; // pointer to MFDQ Feedback exponents
} MfdqConfig_t;

// Configures which tones will be used for mfdq anchors.
// This is for workaround of HW MFDQ bug:  no feedback is used in showtime, and feedforward
// is from anchors only, which will be forced to 0-bitloading.
typedef struct {
   // Only first three may be written via CMV
   int16 s_first_cand_anchor_offset;
   int16 s_anchor_spacing;
   int16 s_max_num_anchors;
   // The last two are determined internally in FW.
   int16 s_num_anchors;
   int16 sa_anchors[16];
} MfdqHwWkArndConfig_t;

// XDSLRTFW-3280 - Start - PLL improvement / pilot tone selection improvement
typedef enum { PT_ARRAY_IDX_0 = 0,        // 0
               PT_ARRAY_IDX_1,            // 1
               PT_ARRAY_IDX_2             // 2  MAX_NUM_PILOT_TONES=3
              }PT_ArrIdx_te;

typedef struct{
   FlagT ft_DeRotatePilot;          //                                                    Byte 1
   uint8 DUMMY_PADDING_BYTE;        // JUST A PADDING BYTE                                Byte 2
   int16 s_PilotToneIdx;            //                                                    Byte 3..4
   int16 s_PilotTone_Re;            //                                                    Byte 5..6
   int16 s_PilotTone_Im;            //                                                    Byte 7..8
   int16 s_PilotToneAtSyncSymb_Re;  //                                                    Byte 9..10
   int16 s_PilotToneAtSyncSymb_Im;  //                                                    Byte 11..12
   int16 s_PllRefTone_Re;           // PLL reference tone (real)                          Byte 13..14
   int16 s_PllRefTone_Im;           // PLL reference tone (imag)                          Byte 15..16
   int16 gs_PhaseError;             //                                                    Byte 17..18
   int16 s_Ki;                      // Current Ki parameters in the PLL loop filter       Byte 19..20
   int16 s_Kp;                      // Current Kp parameters in the PLL loop filter       Byte 21..22
   int16 s_PilotToneScale;          // Scale factor for scaling the pilot tone            Byte 23..24
   int16 s_PilotToneScale_over_4;   // Scale factor divided by four                       Byte 25..26
   int32 l_Metric;                  //                                                    Byte 27....30
   uint32 ul_AvgPhaseError;         //                                                    Byte 31....34
   uint32 ul_AvgPhaseErrorNorm;     // Normalized Phase error (normalized wrt tone index) Byte 35....38      // XDSLRTFW-3695 (Start / End)
   uint32 ul_PilotTonePwr;          //                                                    Byte 39....42
   uint32 ul_RxAvgPilotPWR;         //                                                    Byte 43....46
   uint32 ul_RxMaxPilotPWR;         //                                                    Byte 47....50
   uint32 ul_RxMinPilotPWR;         //                                                    Byte 51....54
   uint32 ul_PilotToneRefPwr;       //                                                    Byte 55....58
   uint32 ul_PilotThresholdPwr;     //                                                    Byte 59....52
} PilotToneParams_t;

typedef struct {
   int32 DUMMY_PADDING_LONG_WORD;         // This is needed to ensure we are 32-bit aligned. This avoids padding byte depending on memory layout and is required for debug streaming.
   int16 s_NumPilotTones;
   int16 sa_PilotTonesIndex[16];          // This pilot tone index values are redundant to ta_PilotTones[x].s_PilotToneIdx. They are kept to be backward compatible to DSL 3 CMV
   uint16 usa_PilotToneConstellation[2];  // This pilot tone constellation is redundant to ta_PilotTones[UsedPilot].s_PilotTone_Re & Im. They are kept to be backward compatible to DSL 3 CMV
   int16 s_PilotToneControl;
   PT_ArrIdx_te te_UsedPTArrayIdx;
   PT_ArrIdx_te te_BestPTArrayIdx;
   PilotToneParams_t ta_PilotTones[MAX_NUM_PILOT_TONES];
} PilotConfig_t;
// XDSLRTFW-3280 - End - PLL improvement / pilot tone selection improvement
typedef struct
{
    int32  l_SymbolCount;
    int16  s_SectorIdx;
    int16  s_PhaseError;
} PllPhaseRotInfo_t;

//==============================================================================
// Diagnostic information
//==============================================================================
typedef struct {
   uint16 us_HlinSC;     //Hlin scale
   uint16 us_HlinG;      //Hlin, subcarrier group size
   uint16 us_HlogMT;     //Hlog measurement time (in symbols)
   uint16 us_HlogG;      //Hlog, subcarrier group size
   uint16 us_QlnMT;      //Qln, measurement time (in symbols)
   uint16 us_QlnG;       //Qln, subcarrier group size
   uint16 us_SnrMT;      //Snr, measurement time (in symbols)
   uint16 us_SnrG;       //Snr, subcarrier group size
} ChannelMeasurement_t;

//==============================================================================
// Other Structures
//==============================================================================

typedef struct {
   //Input Arguments
   int16               s_MaxNomPsdIn;       // in -1*10XdB format.
   int16               s_MaxAtp;            // in 10XdB format.
   int16               s_PsdCeiling;
   int16               s_MaxAtpCeil;
   int16               s_PsdCeilingUsed;
   PSDDescriptorTable_t   *pt_MaxPsdDescIn; // pointer to DsPSDDescriptorTable_t/UsPSDDescriptorTable_t
   void               *pt_RefPsdDescIn; // pointer to UsPSDDescriptorTable_t/UPBOPSDDescriptorTable_t
   int16               s_kl0In;
    uint16                  usa_Kl0EstimOPb[4];   // XDSLRTFW-487_VR9_VRX318_VDSL2_All_AELEM_Support
   //Output Arguments
   int16               s_MaxNomPsdOut;
   PSDDescriptorTable_t   *pt_ActPsdDescOut;
   int16               s_US_PSD_Boost_0dB1[5];   // US PSD Boost [0.1 dB] steps
   int16               s_US_PSD_Boost_CD_0dB1[5];   // US PSD Boost [0.1 dB] steps
   int16               s_US_PSD_Boost_TRTR_0dB1[5];   // US PSD Boost [0.1 dB] steps
   int16               s_Force_kl0_estimate;
   int16               s_Force_kl0_final;
   int16               s_Force_US_PSD_Ceiling_CD_0dB1;
   int16               s_Force_US_PSD_Ceiling_TRTR_0dB1;
   int16               s_Force_TxIfftGain_dB;
   int16               s_US_PSD_Boost_TimeDomain; //XDSLRTFW-3990: Frequency independent US PSD boost in time domain, 8.8 dB format (+ve value --> increase PSD )
   int16               s_Force_kl0_estimate_in_RMSG1;    // XDSLRTFW-4052(Start_End)
} TxPsdControl_t;

typedef struct {
   //Input Arguments
   // 0x1 -- Force CO-MIB electrical loop length configured within this structure
   // 0x2 -- UPBO Boost Mode
   // 0x4 -- UPBO compliance check
   int16               s_control;

} UPBOControl_t;

typedef struct {
   // Estimate of electrical loop length (kl0) @ CPE
   int16               s_kl0_estimate;
   // Final Value of electrical loop length (kl0) from CO
   int16               s_kl0_final;
} Kl0ElectricalLength_t;

typedef struct {
   int32 l_Pa;
   int16 s_AvRxTimePwr; // average time domain received power per sample measure during showtime
   int16 s_AvRxTimePwr_Threshold; // threshold Rx Power (based on s_AvRxTimePwr_Threshold_Delta)
   int16 s_AvRxTimePwr_Threshold_Delta; // power decrease required to declare LOS
} DDRxPowerCalc_t;

typedef struct {
   int16 s_TxGain; // default: 0   in 0.1 dB steps. Range: [-1.5, +1.5] dB
   int16 s_RxGain; // default: 0   in 0.1 dB steps. Range: [-1.5, +1.5] dB
} GainCalibration_t;

//==============================================================================
// Debug Structures
//==============================================================================
#ifdef DEBUG_TRAIL
typedef struct {
   int16* psa_Trail;
   int16 s_TrailIndex;
   int16 s_TrailIndexMax;
   int16 s_RxStateTrigger;
   int16 s_RxSubStateTrigger;
} DebugTrail_t;

//-------------------------------------------
//Structure used for Debug Trail Control CMV
typedef struct {
   int16 s_logType[2];
   int16 s_triggerRxState;
   int16 s_triggerRxSubState;
   int16 s_triggerRxSymbolCount;
   int16 s_toneIndex;
   int16 s_numTones;
   int16 s_cyclicTrailUpdate;
   int16 s_ShowtimeEventControl;
   int16 s_ShowtimeCounterControl;
   int16 s_ShowtimeCounterPeriod;
   int16 s_CounterPeriod;

   // Internal variables used for implementation only
   int16 s_prevRxState;
   int16 s_prevRxSubState;
   int16 s_prevTxState;
   int16 s_prevTxSubState;
   FlagT ft_RxStateTrigger;
   FlagT ft_TxStateTrigger;

} DebugTrailControl_t;



//-------------------------------------------
//Structure used for Debug Trail Status CMV
typedef struct {
   int16 s_debugTrailIndex;
   int16 s_debugTrailSize;
   int16 s_debugTrailWrapCount;
   int16 s_debugTrailPrevEvent;
} DebugTrailStatus_t;
#endif

#ifdef DEBUG_TRACES
//Structure used for Debug Trail Status CMV
typedef struct {
   int16 s_debugBufIndex;
   int16 s_debugBufSize;
   int16 s_debugBufWrapCount;
   int16 s_debugBufPrevEvent;
} DebugBufStatus_t;

// XDSLRTFW-3935 Wrong HLOG reporting in DPBO range
#define NUM_OF_TONES_FDQ_BASED_HLOG 512

typedef struct {
   int16 sa_FdqMantissa[2*NUM_OF_TONES_FDQ_BASED_HLOG]; // 2* for real and imag
   uint8 uca_FdqExponent[NUM_OF_TONES_FDQ_BASED_HLOG];
} FDQ_t;
// XDSLRTFW-3935 End

//XDSLRTFW-600 FEATURE_ALL_ALL_ALL_Debug_Buffer(START)
//XDSLRTFW-598 FEATURE_ALL_ALL_ALL_Debug_Buffer(START)
//structure used for updating the debug buffer status CMV
typedef struct {
   int16 s_debugBuffer_GHS_TO_EXCHANGE_length;
   int16 s_debugBuffer_Showtime_length;
   int16 s_debugBuffer_Showtime_Oldested_data_Start;
   int16 s_debugBuffer_Size_of_Per_Symbol_structure_Bytes;
   int16 s_debugBuffer_Size_of_Super_Frame_structure_Bytes;
   uint16 us_debugBuffer_Version;             // XDSLRTFW-3035   Update Showtime debug buffer / add version for ST DBG buffer
}DebugBufferStatus_t;
//XDSLRTFW-598 FEATURE_ALL_ALL_ALL_Debug_Buffer(END)

//structure used for updating the debug buffer status CMV
typedef struct {
   int16 s_debugBuffer_STCaptureXSymbol;
   uint16 us_debugBuffer_StopStartCaptureData;
}DebugBufferControl_t;



#pragma Align_members(1)//no padding bytes for alignment
//Structure which is used for collection data for every Nth symbol in showtime in Debug Buffer
typedef struct {
   //int32 l_symbolCountBuff;
   int16 s_rx_PilotToneReal;
   int16 s_rx_PilotToneImaginary;

/*   struct Erasure_Met{
      uint32 ul_metric_value;
      uint32 ul_num_frame_lowmetric;
      uint16 us_metric_eval_cnt;
      uint16 us_lowmetric_detect_cnt ;
      uint16 us_lowmetric_detect_period;
      uint16 us_lowmetric_discard_cnt;
      uint16 us_lowmetric_discard_max;
      uint16 us_metric_eval_period;
      uint16 us_LowPowerSetting;
      uint8 uc_metric_discard_threshold;
      uint8 uc_max_metric;
      uint8 uc_min_metric;
      FlagT ft_frame_with_lowmetric ,ft_cal_discard_metric_threshold;
      FlagT ft_DisableDiscardFrame;
   } Erasure_Metric_Buff; // 14 words = length of this structure  */

} DebugShowTimeBuffSymbol_t;


// Version + 16-bit start address
// ---------------------------------------------|---|---|---|---|---|---|---|
// ---------------------------------------------| 0 |   |   |   |   |   |   |
// ---------------------------------------------| 2 |   |   |   |   |   |   |
// ---------------------------------------------| 0 |   |   |   |   |   |   |
// ---------------------------------------------| 1 |   |   |   |   |   |   |
// ---------------------------------------------|---|---|---|---|---|---|---|
// l_sync_structure_start_delimiter             | 0 |   |   |   |   |   |   |
// l_SymbolCount                                | 2 |   |   |   |   |   |   |
// sa_RxPilotToneAtSyncSymbol[2]                | 4 |   |   |   |   |   |   |
// sa_RxPilotTone2[2]                           | 6 |   |   |   |   |   |   |
// usa_EocNumTimeouts[3]                        | 8 |   |   |   |   |   |   |
// OLR_PM_COUNT_US.us_SimpleOLRPMReq_Cnt        |11 |   |   |   |   |   |   |
// OLR_PM_COUNT_US.us_OLRPMUTCResp_Cnt          |12 |   |   |   |   |   |   |
// OLR_PM_COUNT_US.us_ActualOLRPMPerform_Cnt    |13 |   |   |   |   |   |   |
// OLR_PM_COUNT_DS.us_SimpleOLRPMReq_Cnt        |14 |   |   |   |   |   |   |
// OLR_PM_COUNT_DS.us_OLRPMUTCResp_Cnt          |15 |   |   |   |   |   |   |
// OLR_PM_COUNT_DS.us_ActualOLRPMPerform_Cnt    |16 |   |   |   |   |   |   |
// OLR_PM_COUNT_DS.us_RespTimeOut_Cnt           |17 |   |   |   |   |   |   |
// us_NeSefDefectCounter                        |18 |   |   |   |   |   |   |
// s_SnrMargin                                  |19 |   |   |   |   |   |   |
// s_RxMinMargin                                |20 |   |   |   |   |   |   |
// s_RxMinMarginTone                            |21 |   |   |   |   |   |   |
// usa_g997_Failure_Flag_NE[2]                  |22 |   |   |   |   |   |   |
// s_g997_Failure_Flag_FE                       |24 |   |   |   |   |   |   |
// usa_NonInhibit_CRC_Cntr_NE[2]                |25 |   |   |   |   |   |   |
// ReTx_Status.us_RetransmittedDtuCnt           |27 |   |   |   |   |   |   |
// ReTx_Status.us_CorrectedDtuCnt               |28 |   |   |   |   |   |   |
// ReTx_Status.us_UncorrectedDtuCnt             |29 |   |   |   |   |   |   |
// ReTx_Status.us_TotalDtuCnt                   |30 |   |   |   |   |   |   |
// ReTx_Status.us_UnexpectedDtuCnt              |31 |   |   |   |   |   |   |
// us_EOC_ErrorFB_CMD_count                     |32 |   |   |   |   |   |   |
// us_ErrVectDiscard                            |33 |   |   |   |   |   |   |
// us_ErrVecTransmitted                         |34 |   |   |   |   |   |   |
// us_ErrVecTotal                               |35 |   |   |   |   |   |   |
// ---------------------------------------------|---|---|---|---|---|---|---|

//Structure which is used for collection data for every sync symbol in showtime in Debug Buffer
typedef struct {

   int32 l_sync_structure_start_delimiter;

   //Please add any new variables after the above delimiter declaration
   int32 l_SymbolCount;

   int16 sa_RxPilotToneAtSyncSymbol[2];      // XDSLRTFW-3034 (Start_End)
   int16 sa_RxPilotTone2[2];   /* sriram for  Debug Buffer */
   uint16 usa_EocNumTimeouts[MAX_OVHD_PRIORITY];

   struct OLR_PM_CNT_US
   {
      uint16 us_SimpleOLRPMReq_Cnt;
      uint16 us_OLRPMUTCResp_Cnt;
      uint16 us_ActualOLRPMPerform_Cnt;
   } OLR_PM_COUNT_US;

   struct OLR_PM_CNT_DS
   {
      uint16 us_SimpleOLRPMReq_Cnt;
      uint16 us_OLRPMUTCResp_Cnt;
      uint16 us_ActualOLRPMPerform_Cnt;
      uint16 us_RespTimeOut_Cnt;
   } OLR_PM_COUNT_DS;

   // helps to identify Loss of Frame condition
   uint16 us_NeSefDefectCounter;

   //help to idenfify Loss of Margin conditions
   int16 s_SnrMargin;
   int16 s_RxMinMargin;
   int16 s_RxMinMarginTone;

   // !!!!! Note: The order of the two failure flag variables is not allowed to be changed !!!!
   uint16 usa_g997_Failure_Flag_NE[2];
   uint16 s_g997_Failure_Flag_FE;

   // CRC LP0 and LP1 (IFEC mode)
   uint16 usa_NonInhibit_CRC_Cntr_NE[NUM_DATA_PATHS];

   struct ReTx_Status_Variables
   {
      //XDSLRTFW-1098: BugFix_DS_VDSL2_ALL_SES_Not_Incrementing_In_ReTx (Start_End)
      uint16 us_RetransmittedDtuCnt;
      uint16 us_CorrectedDtuCnt;
      uint16 us_UncorrectedDtuCnt;
      uint16 us_TotalDtuCnt;
      uint16 us_UnexpectedDtuCnt;
   } ReTx_Status;

   // #ifdef VRX518_SINGAPORE_BRINGUP
   // uint16  Debug1;
   // uint16  Debug2;
   // uint16  Debug3;
   // uint16  Debug4;
   // uint16  Debug5;
   // uint16  Debug6;
   // #endif

   // Vectoring variables
   // XDSLRTFW-3033 (Start)
   uint16 us_EOC_ErrorFB_CMD_count;    // Number of received EOC ErrorFB commands
   uint16 us_ErrVectDiscard;           // Discarded L2 Error Vectors counter //XDSLRTFW-1524 (start-end) --> This should be ideally Zero
   uint16 us_ErrVecTransmitted;        // Number of ERB segments transmitted to PPE
   uint16 us_ErrVecRequested;          // Number of ERB requests received at sync symbol
   // XDSLRTFW-3033 (End)
} DebugShowTimeBuffSuperframe_t;

// XDSLRTFW-3507 (Start)
typedef struct{
   uint32 ul_ERB_Calculation_State;        // 0/1
   uint32 ul_RxSymbolCount_StartERBCalc;   // 2/3
   uint32 ul_RxSymbolCount_EndERBCalc;     // 4/5
   uint16 us_RxFrmCount_StartERBCalc;      // 6
   uint16 us_RxFrmCount_EndERBCalc;        // 7
   uint16 us_Msg_Type;                     // 8 Octet 2 + MSBit = 1: New Parameters have been received / 0: no update required
   uint16 us_First_SSC;                    // 9 Octet 3/4
   uint16 us_ErrorSampleUpdatePeriod_m;    // 10 Octet 5/6
   uint16 us_ErrorSampleShiftPeriod_z;     // 11 Octet 7/8
   uint16 us_Nband_BandConfig;             // 12 Octet 8   | Octet 8
   uint8  uc_Padding;                      // 13
   uint8  uc_Fblock;
   uint16 usa_RxVecBandLeftChannel[ 8];    // 14-21
   uint16 usa_RxVecBandRightChannel[8];    // 22-29
   uint16 usa_VectoredBandParams[8];
   uint16 us_Nband_ERBConfig;              // 30
   uint16 usa_Fsub[8];                      // 31-38
   uint16 usa_Lw[  8];                      // 39-46
   uint16 usa_Bmin[8];                      // 47-54
   uint16 usa_Bmax[8];                      // 55-62
   uint16 usa_Header_Length[MAX_NUM_ERB_SEGMENTS];                // 62   length: 9
   uint8  uc_NumOfSegments;                                       // 71
   uint8  uc_Dummy1;
   uint16 us_EOC_ErrorFB_CMD_count;                               // 72
   uint16 us_EOC_ErrorFB_StartMsg_WithParameterChange_count;      // 73
   uint16 us_EOC_ErrorFB_StartMsg_WithoutParameterChange_count;   // 74
   uint16 us_EOC_ErrorFB_StopMsg_count;                           // 75
   uint16 us_EOC_ErrorFB_Parameter_Mismatch_count;                // 76
   uint16 us_Delay_ERB_Processing_count;                          // 77
   uint16 us_Delay_ERBStartMsg_Processing_count;                  // 78
   uint16 us_Delay_ERBEndMsg_Processing_count;                    // 79
   uint16 us_ErbByteCounter;                                      // 80
   uint16 us_ByteCounter_For_Segment;                             // 81
   uint16 us_RxToneTobeCranched;                                  // 82
   uint8  uc_SegmentCode;                                         // 83
   uint8  uc_Flags;
}ERBParams_t;
// XDSLRTFW-3507 (Start)

//XDSLRTFW-1392(START)
typedef struct{

   int32 l_symbolCountBuff;
   uint8 uc_DTU_Qtx_index;
   uint16 us_SID_Timestamp_requsted;//lower 8 bit(LSB)=SID and upper 8 bit(MSB)=Timestamp

}DebugShowTimeBuffUsReTxOnly_t;
//XDSLRTFW-1392(END)
#pragma Align_members(4)
#endif // DEBUG_TRACES
//XDSLRTFW-600 FEATURE_ALL_ALL_ALL_Debug_Buffer(END)

// Structures to provide CMV control and filter of Debug Streams
/** Enables/Disables the output of so-called "debug streams" with additional
   debug information (see also EVT_DBG_DebugStream). */
typedef struct{
   /** Parameter0.  */
   uint16 Parameter0;
} DebugStreamControl_t;


typedef struct{
   /** Mask_1.
       - Default: 0x00000000
   */
   uint32 Mask1;
   /** Mask_2.
       - Default: 0x00000192
   */
   uint32 Mask2;
   /** Mask_3.
       - Default: 0x0000007F
   */
   uint32 Mask3;
   /** Mask_4.
       - Default: 0x0000007F
   */
   uint32 Mask4;
   /** Mask_5 (SOC).
       Useful in VDSL only, not evaluated in ADSL modes ("Don't care")
       - Default: 0x00000000
   */
   uint32 Mask5;
}DebugStreamConfigure_t;


/** Autonomous message indicating a FIFO overflow in the mailbox interface.
    The message is placed into the mailbox  b e f o r e  the message which
    would cause an overflow.
*/
typedef struct
{
   /** Message ID.
   The message ID of the message which did not fit into the internal FIFO (for
   data from the VINAX to the host).
   */
   uint16 MsgID;
   /** Total Message Length.
   The total length in bytes (=the payload "Length" parameter of the message header + 10)
   of the message which did not fit into the internal FIFO.
   */
   uint16 MsgLength;
} EvtDbgBufferOverflow_t;

typedef struct
{
   //Note, every element consists of 2 bytes to make decoding script easier
   int16 s_PgaHandlerRun;
   FlagT ft_StartHybTrn;
   uint8 uc_HybTrIndex;
   int16 s_AvRxTimePwr;
   int16 s_MaxRxTonePwr;
   int16 s_PGA_required_Pre;
   int16 s_PGA_required;
   int16 s_AGC1_Gain_Set;
   int16 s_AGC2_Gain_Set;
   int16 s_RxVarGainDB;
   int16 s_PrefiAceMode_Selected;
}DshHwConfEventPga_t;



// structure used to measure timing
typedef struct {
   int32 l_TxOSignature_Start; // ChDisc TX Start
   int32 l_TxOSignature_IdleStart; // O-SIGNATURE Idle start
   int32 l_TxOSignature_MsgStart; // O-SIGNATURE Message start
   int32 l_TxOPSynchro1_End; // O-P-SYNCHRO1 end

   int32 l_RxCRSilent1_Start; // GHS RX Start
   int32 l_RxORTrain_Start; // ChDisc RX Start
   int32 l_RxORTrain_QlnMeasEnd; // QLN measurement is done
   int32 l_RxORTrain_IdleStart; // Detect R-MSG1 idle cells
   int32 l_RxORTrain_MsgReady; // Decode R-MSG1 ready
   int32 l_RxORTrain_MsgEnd; // Decode R-MSG1 done
   int32 l_RxORPSynchro1_End; // R-P-SYNCHRO1 end
} CO_DebugTiming_t;

typedef struct {
   int32 l_TxRMsg1_Start;           // ChDisc TX Start
   int32 l_TxRMsg1_TxConfig;        // Start Tx path config
   int32 l_TxRMsg1_IdleStart;       // R-MSG1 Idle start
   int32 l_TxRMsg1_MsgStart;        // R-MSG1 Message start
   int32 l_TxRPSynchro1_End;        // R-P-SYNCHRO1 start

   int32 l_RxROTrain_Start;         // ChDisc RX Start
   int32 l_RxROTrain_QlnMeasEnd;    // QLN measurement is done
   int32 l_RxROTrain_IdleStart;     // Detect O-SIGNATURE idle cells
   int32 l_RxROSignature_MsgReady;  // Decode O-SIGNATURE ready
   int32 l_RxROSignature_MsgEnd;    // Decode O-SIGNATURE done
   int32 l_RxROPSynchro1_End;       // R-P-SYNCHRO1 end
} RT_DebugTiming_t;

/* XDSLRTFW-2858 */
// Test structures / cmvs for FW internal REIN tests

/* Used variable */
/*   us_REIN_TEST_CONFIG,us_Length_Rx_REIN_in_DMT_symbols,us_Distance_between_two_Rx_REIN_pulses_in_DMT_symbols, us_Number_of_Rx_REIN_pulses */
/*    us_REIN_TEST_STATUS,us_Number_of_Triggered_Rx_REIN_pulses,us_Number_of_Remaining_Rx_REIN_pulses,us_Rx_Symbols_Since_Start_of_REIN_pulse */


/* NOTE !  Only Rx path  variables are used at  present. Tx Path is NOT  developed now */
/* Dummy & rest are placeholder Kindly don't Not replace them */

typedef struct {
    uint16 us_REIN_TEST_CONFIG;           // Configuration Register for REIN test
                                          // Bit 0: Start Rx REIN Test
                                          // Bit 1: Start Tx REIN Test
    int16  s_Delay_between_Rx_Tx_REIN;    // INITIAL Delay between Rx and Tx REIN pulses
                                                // pos:  Rx REIN precedes Tx REIN
                                                // neg:  Rx REIN follows  Tx REIN
    uint16 us_dummy_2;
    uint16 us_dummy_3;
    uint16 us_Length_Rx_REIN_in_DMT_symbols;
    uint16 us_Distance_between_two_Rx_REIN_pulses_in_DMT_symbols; // measured from start of one REIN pulse to the start of the following one
    uint16 us_Number_of_Rx_REIN_pulses;                           // special value 0xFFFF: repeat until TRIGGER_RX_REIN bit is reset back to OFF ('0')
    uint16 us_Rx_REIN_Power;                                      // special value 0x0000: Micro-Interruption
    uint16 us_dummy_8;
    uint16 us_dummy_9;
    uint16 us_dummy_10;
    uint16 us_dummy_11;
    uint16 us_Length_Tx_REIN_in_DMT_symbols;
    uint16 us_Distance_between_two_Tx_REIN_pulses_in_DMT_symbols; // measured from start of one REIN pulse to the start of the following one
    uint16 us_Number_of_Tx_REIN_pulses;                           // special value 0xFFFF: repeat until TRIGGER_TX_REIN bit is reset back to OFF ('0')
    uint16 us_Tx_REIN_Power;                                      // special value 0x0000: Micro-Interruption
} REIN_Test_Config_t;

typedef struct {
   uint16 us_REIN_TEST_STATUS;            // Status uf REIN tests
                                          // Bit 0: Rx REIN Test currently ongoing
                                          // Bit 1: Tx REIN Test currently ongoing
   uint16 us_Number_of_Triggered_Rx_REIN_pulses;
   uint16 us_Number_of_Remaining_Rx_REIN_pulses;
   uint16 us_Rx_Symbols_Since_Start_of_REIN_pulse;
   uint16 us_Number_of_Triggered_Tx_REIN_pulses;
   uint16 us_Number_of_Remaining_Tx_REIN_pulses;
   uint16 us_Tx_Symbols_Since_Start_of_REIN_pulse;
} REIN_Test_Status_t;
/* XDSLRTFW-2858 */

//==============================================================================
// Inventory/Vendor Information Structures
//==============================================================================

// In 997.1 rev3, see Table 7-4 Vendor ID information block (8 octets)
typedef struct {
  uint16 us_dummy;
  uint8 uca_CountryCode[2]; // 'octets' according to 7.4.1 G.994.1 Vendor ID
  uint8 uca_VendorId[4];
  uint8 uca_VendorSpecific[2];
} G994_VendorInformation_t;

// XDSLRTFW-458: IOP_ALL_VDSL2_ALL_TACorrection (Start)
//Master Control for Customers IOP changes
//CMV 21 0
typedef struct {
   uint16 us_Operator_Select;
}Dsl_Operator_Select_t;
// XDSLRTFW-458: IOP_ALL_VDSL2_ALL_TACorrection (End)

//XDSLRTFW-956 : ENH_DS_ALL_ALL_SESx_ESx_LOMx
typedef struct {
   int16 s_SESx_ReInit_Threshold;
   int16 s_LOM_ReInit_Threshold;
   int16 s_ESx_ReInit_Threshold;
} ReInit_Thresholds_t;
//XDSLRTFW-956 : ENH_DS_ALL_ALL_SESx_ESx_LOMx

//----------------------------
//   VDSL_BONDING
//----------------------------
#ifdef VDSL_BONDING

typedef struct {
   int16 s_PCS_control;            // Bit [0] = Use PAF (Reg 3.61). Only CO-side: Bit [1] = Use internal/external bonding
   int16 s_Disc_PMEAggr_control;   // (CO only use)
                                 // Bit [0] = Exchange Only
                                 // Bit [2:1] = Disc Control      (Reg 6.16)
                                 // Bit [5:4] = PME Aggr Control   (Reg 6.21)
   int16 sa_DiscCode[3];         //(Reg 6.18-6.20 for CO) ;; (Remote_Disc_Reg for CPE)
   int16 sa_PMEAggr_data[2];      //(Reg 6.22-6.23 for CO) ;; (PME_Aggr_Reg for CPE)
} Bonding_DiscAggr_Control_t;

typedef struct {
   int16 s_PAF_status;               // Bit [0] = Remote PAF supported
                              // Bit [1] = Disc operation result (CO only)
                              // Bit [2] = PME Aggr operation result (CO only)
   int16 sa_DiscCode[3];            // Rx-ed Remote_Disc_Reg content
   int16 sa_PMEAggr_data[2];         // Rx-ed PME_Aggr_Reg content (CPE's actual PME_Aggr_Reg Rx-ed at CO, 0/1 Rx-ed at CPE)
} Bonding_DiscAggr_Status_t;
// XDSLRTFW-487_VR9_VRX318_VDSL2_All_AELEM_Support (START)
typedef struct {
    uint16 us_AeleMode;
    uint16 usa_Kl0EstimRPb[4];
    uint16 usa_Kl0EstimOPb[4];
    uint16 us_UpboElmt;
    int16 s_RxThreshDs;
} AELEM_UPBOInfo_t;
// XDSLRTFW-487_VR9_VRX318_VDSL2_All_AELEM_Support (END)

typedef struct {
   int16 s_continue;                 // 0: 'CPE FW waiting': The CPE FW clears the LSB bit during CLR exchange
                                        //    to indicate it's waiting for the CPE ME to process any pending
                                        //    bonding commands and return discovery register and aggregate data.
                                        // 1: 'CPE FW continue': The CPE ME sets the LSB bit to indicate to
                                        //    the CPE FW that it has finished writing discovery register and
                                        //    aggregate data and the CPE FW can now continue with the rest of GHS.
   int16 sa_DiscCode[3];            // Disc_Reg populated by the CPE ME.
   int16 sa_PMEAggr_data[2];         // PME_Aggr_Reg populated from the CPE ME.
} Bonding_Continue_t;
#endif // #ifdef VDSL_BONDING


   // this structure should be at most 6 long words so that it can
   // fit into one entry in the Image Swap Header Table
   typedef struct {
        // PM entry
       uint16 us_Signature0;               // offset 0; a hardcode value of 0x2468
       uint8 uc_DualPortModeLock;          // offset 2; true/false that mode is locked by a port at end of  GHS
       uint8 uc_XdslModeLock;              // offset 3; true/false that mode is locked by a port at end of GHS

       uint8 uc_DualPortModePreferred;     // offset 4; power-up default;
       uint8 uc_XdslModePreferred;         // offset 5; power-up default;
       uint8 uc_DualPortModeCurrent;       // offset 6; Being loaded; default - 0xFF
       uint8 uc_XdslModeCurrent;           // offset 7; Being loaded; default - 0xFF
        uint8 uc_BootError;                 // offset 8; this will be used to communicate with driver if errors
                                            // detected early in the boot process

        uint8 uc_AfePowerUp;                // offset 9; AFE_COLD_START = 1; AFE_1PORT_STARTED = 2; AFE_2PORTS_STARTED = 3;

       uint16 us_Signature1;               // offset 10; a hardcode value of 0xB11D

        // DM entry
        int32 l_SRAMImageOffset;            // offset 12; set by the BootLoader based on info in .bin file
        int32 ul_BgPortSelRegValue;         // offset 16;
        uint8 uc_BgPort;                    // offset 20;
        uint8 uc_BgDuration;                // offset 21;
        uint8 uc_MaxBgDuration;             // offset 22;
        volatile uint8 uc_AfeInitState;     // offset 23;
   } PortModeControl_t;

   //XDSLRTFW-3493(Start)
   typedef struct
   {
      int32 l_ndr_eff;
      uint8 ul_ndr_idx;
   } HQV_ETRu_t;
   //XDSLRTFW-3493(End)

   typedef struct {
       uint8  uc_CWsPerDtu_Q;
        uint8  uc_DtuPaddingSize_V;     // num of padding bytes
       uint8  uc_1stCWPayloadSize;     // (H - V - 2) bytes
        uint8  uc_QrxFull;           // queue full
    } UcodeReTXParam1_t;

   typedef struct {
        uint8  uc_DtusToForward_XDTU;     // num of DTU to be forwarded to PPE during next frame
        //XDSLRTFW-1571 (Start_End)
        uint8  uc_FIFO3_DTU_FwdCount;     //DTU forward count updated by ReTx micro code
        uint16 us_DtuPayloadSize;         // (H*Q - V - 2) bytes  for framing type 1
    } UcodeReTXParam2_t;


    typedef struct{
        uint8   uc_G_Inp_Amend1_Support;
       //XDSLRTFW-1193 Feature_US_VDSL2_ALL_UsReTx_CMV(START_END)
        uint16   us_DsUsReTxCapable;    // CPE DS US ReTx capability , hooked to CMV CNFG 80 0

        uint16  us_OTPS_ETR_min;
        uint16  us_OTPS_ETR_max;
        uint16  us_OTPS_MaxNetDataRate;
        uint16  us_OTPS_INP_min;
        uint16  us_OTPS_SHINE_ratio;
        uint16  us_OTPS_INP_min_REIN;
        uint16  us_OTPS_DelayMax;         // delay_max in symbols/TS
        uint16  us_OTPS_DelayMin;         // delay_max in symbols/TS
        uint16  us_OTPS_DS_LEFTR_thresh;
        uint16  us_OTPS_CI_policy;
      uint16  us_US_DelayMax;
      uint16  us_OTPS_US_DelayMin;
        uint16  us_OTPS_US_INP_min_REIN;
        uint16  us_OTPS_US_INP_min;
    } RTX_ConfigCMV_t;

    // XDSLRTFW-1063: SRAds_Support_with_DS_ReTx (START)
    typedef struct {
        uint32 ul_ReTX_ReceiverETR;
        uint8 uc_ReTXQueueSize_Qrx_SIZE;
        uint8 uc_CWsPerDtu_Q;
        uint8 uc_DtuPaddingSize_V;
        uint8 uc_RPMS_Qtx;
        int16 s_Reconfig_Rp;        // New Rp value for OLR
        int16 s_Reconfig_Mp;        // New Mp value for OLR
        int16 s_Reconfig_Nfecp;     // Size of codeword per latency path in bytes
        int16 s_Reconfig_Ip;        // interleaver block length
        uint8 uc_RPMS_DsLookBackValue;
    } ReTX_ShowtimeParams_t;
    // XDSLRTFW-1063: SRAds_Support_with_DS_ReTx (END)

    typedef struct {

        RTX_ConfigCMV_t    t_ReTXConfigCMV;

        uint16             us_DS_ReTx_DtuSize;          // (H*Q)

        uint8              uc_DtuPerFrame;      //(1/(S*Q) in 4.4

        uint8              uc_ReTX_N;           // RS codeword size
        uint8              uc_ReTX_H;           // payload size per codeword
        uint8              uc_amend2_support;

        // contents of O-MSG1
        uint8              uc_OMSG1_DsReTxEnabled;    // negotiated DsReTx capability
                                                      // during training this field will be set to:
                                                      // CO-DS-CAPABILITY, then RETX_SELECTED or RETX_NOT_SELECTED
        uint8              uc_UsReTxStatus;

        uint8              uc_OMSG1_DsFramingType;      // 1-4
        uint8              uc_OMSG1_DsHalfRoundTripInDTUS;

        uint8              uc_OMSG1_DsHalfRoundTripInSyms;

        uint8              uc_OMSG1_UsHalfRoundTripInDTUS;
        uint8              uc_OMSG1_UsHalfRoundTripInSyms;

        uint8              uc_OMSG1_Ds1overSMax;
        uint8              uc_OMSG1_Us1overSMax;
        uint8              uc_OMSG1_DsIntDepthsupported;

        // contents of O-TPS
        // contained within t_ReTXConfigCMV

        // contents of RMSG2
        uint8              uc_RMSG2_CpeTxHalfRoundTripDelays;
        uint8              uc_RMSG2_CpeRxHalfRoundTripDelays;
        uint8              uc_RMSG2_Us1overSMax;
        uint8              uc_RMSG2_Ds1overSMax;
        uint16             us_RMSG2_UsNetDataRateMax;

        // contents of R-PMS
        uint8              uc_RPMS_DsLookBackValue;
        uint8              uc_RPMS_Qtx;

        //XDSLRTFW-1571 (Start_End)
        uint8              uc_Qrx; // size of ReTX-Queue in DTUs

        // contents of O-PMS -- mapped to INFO 237 0(all 16 bit ==> API requirement)
        uint16              us_OPMS_UsFramingType;
        uint16              us_OPMS_UsCodeWordPerDtu_Q;
        uint16              us_OPMS_UsPaddingPerDtu_V;
        uint16              us_OPMS_UsQtx;
        uint16              us_OPMS_UsLookBackValue;
        uint8              uc_OPMS_G_Inp_Amend1_Support;
        uint8              uc_OPMS_US_BlkILV_Depth_selected;
        union {
            UcodeReTXParam1_t   t_Param1;
            uint32              l_ReTXParam1;
        } Un_UcodeReTXParam1;


        union {
            UcodeReTXParam2_t   t_Param2;
            uint32              l_ReTXParam2;
        } Un_UcodeReTXParam2;

        //XDSLRTFW-1209: BugFix_DS_VDSL2_ALL_PacketLoss_In_ReTX_Mode (Start_End)
        uint32             l_NumPaddingBytes;
        //XDSLRTFW-1393 (Start_End)
        uint32             ul_DtuPayloadSize;       // (H*Q - V - 2) bytes  for framing type 1

//XDSLRTFW-1079 Feature_US_VDSL2_ALL_UsReTx(START)
        uint32             ul_DS_ReTXQueue_BaseAddress;
        uint32             ul_US_ReTXQueue_BaseAddress;
        uint16             us_US_ReTx_DtuSize;          // (H*Q)
        uint16             us_US_SHINEratio;
        uint8              uc_US_H ; //The number of payload bytes per Reed-Solomon codeword in a DTU
        uint8              uc_US_W ; // DTU overhead octets related to CRC insertion
//XDSLRTFW-1079 Feature_US_VDSL2_ALL_UsReTx(END)
   uint8            uc_CpeRxHalfRoundTripDelays_UsedInFraming;   /* XDSLRTFW-2858 */
   } ReTX_Params_t;


    //XDSLRTFW-1522 (Start)
    typedef struct {
      uint16  us_SHINE_ratio;
      uint16  us_INP_min;
      uint16  us_INP_min_REIN;
      uint16  us_Iat_rein_flag;
      uint16  us_DelayMax;         // delay_max in symbols/TS

      int16 s_Nfecp;
      uint32 ul_Lp;
      uint16 us_Qtx;
      uint16 us_Q;
      uint16 us_V;
      uint16 us_H;
    } ReTx_ComputeInp_Params_t;
    //XDSLRTFW-1522 (End)

    typedef struct
    {
       int16 s_DTUSizeInSymbols[2];
       int16 s_HQV_MaxIdx[2];
    } ReTx_RxDebug;

    typedef struct {
      // these are mapped to CNTR[43]
      uint32 ul_ErrorFreeBits;  //0
      uint32 ul_ErrorFreeBits_Prev;///1
        uint32 ul_EFTR_min;//bits/sec ///2
      uint32 ul_EFTR_min_Prev;//bits/sec ///3
        uint32 ul_LEFTR_Cntr;  ///4
      uint32 ul_EFTR; /// 5 EFTR reported to API in units of kbps //XDSLRTFW-974 Fix_DS_VDSL2_All_Reporting_ReTx_Counters (Start_End)
        uint32 ul_ReTX_ReceiverETR;         //  6 case RETX_RECEIVER_ETR:
        uint16 us_ReTX_ReceiverActualDelay; // 7 case RETX_RECEIVER_ACTUAL_DELAY:
        uint16 us_FE_InpActShine;           //   case FE_INP_act_SHINE:
        uint16 us_FE_InpActRine;            // 8  case FE_INP_act_RINE:
        //XDSLRTFW-1172: BugFix_DS_VDSL2_ALL_InAccurate_NDR_ETR_Reported_InReTx (Start_End)
        uint32 ul_ReTX_NDR; // 10 Q28.4        //9

        // these are mapped to CNTR[44]
        //XDSLRTFW-1098: BugFix_DS_VDSL2_ALL_SES_Not_Incrementing_In_ReTx (Start_End)
        uint32  ul_RetransmittedDtuCnt;     //10 // Counter maintained by CPE
        //XDSLRTFW-1210: BugFix_DS_VDSL2_ALL_Incorrect_CPE_FE_Counter_Values_In_ReTXMode (Start_End)
        uint32  ul_RetransmittedDtuCntFE;   //11 // Counter maintained by CO
        uint32 ul_CorrectedDtuCnt;          //12
        uint32 ul_UncorrectedDtuCnt;        //13
      uint32 ul_UncorrectedDtuCnt_Prev;   //14
    //
    // End of CNTR CMV mapping
    //


        // RX side
        uint32 ul_TotalDtuCnt;              //15
        uint32 ul_GoodDtuCnt;               //16            // good DTUs that are written to ReTX trans table
        uint32 ul_BadDtuCnt;                //17            // bad DTUs + une
        uint32 ul_LastBadDtus;              //18          // (SID_N-1 << 24 | TS_N-1 << 16) | (SID_N << 8 | TS_N)
        uint32 ul_LastRetxDtus;             //19          // (SID_N-1 << 24 | TS_N-1 << 16) | (SID_N << 8 | TS_N)
        uint32 ul_UnexpectedDtuCnt;         //20
        uint32 ul_LastUnexpectedDtus;       //21
        uint32 ul_ErroredBitsPerSec;        //22

        // TX side
        uint32 ul_ForwardedDtuCnt;          //23
        uint32 ul_LastUncorrectedDtus;      //24
        uint32 ul_LastRrcs;                 //25

        //XDSLRTFW-1098: BugFix_DS_VDSL2_ALL_SES_Not_Incrementing_In_ReTx (Start_End)
        //Set to TRUE when EFTR_Min is computed afresh
        //Set to FALSE once EFTR_Min is reported on EOC/Ovhd channel
        uint16 us_New_EFTRMin_Avail;        //26
      //US RETX related -- tied to RATE 3 0
      uint32 ul_UsReTX_ReceiverETR;       //27  //is in Kbps
        uint16 us_UsReTX_ReceiverActualDelay; //28 //Delay in 0.01 milli seconds granularity
        uint16 us_US_InpActShine;                 //INP in 0.1 dmt symbols granularity
        uint16 us_US_InpActRein;              //29 //INP in 0.1 dmt symbols granularity

   } ReTX_Stats_t;


    typedef struct {
        uint8  uc_TS;
        uint8  uc_SID;
        uint8  uc_Stat;
        uint8  uc_DTU_idx;
    } QretxTableEntry_t;

    //XDSLRTFW-1393 (Start)
    typedef struct {
       uint8  uc_SID;
       uint8  uc_DTU_Stat;
    } DTU_Status_t;
   //XDSLRTFW-1393 (End)

   typedef struct {
       uint32 ul_PrevRrc;
       uint64 ull_64MostRecentDtuStats;
       FlagT  ft_RrcStatUpdated;
       uint8  uc_AbsDtuNum;
   } RRC_Stat_t;

   //XDSLRTFW-1571 (Start)
   typedef struct QueueNode {
      //uint8 is sufficient as Max buffers in QRx = (Max_QTx * 3) = 63*3 = 189
      uint8 uc_NextNode;
      uint8 uc_Indx;
   } QueueNode_t;

   typedef struct QueueStatus {
      //uint8 is sufficient as Max nodes in QRx = (Max_QTx * 3) = 63*3 = 189
      uint8 uc_Head;
      uint8 uc_NumNodes;
   } QueueStatus_t;
   //XDSLRTFW-1571 (End)

   typedef struct {
   uint32 base;
   uint32 lines;
   uint32 state[NUM_OF_UPROC_STATES];
} t_code_engine_info;


typedef struct {
   uint32 version;
   uint32 uproc_ena;
   t_code_engine_info engine[NUM_OF_UPROCESSORS];
   uint32 flags0;
   uint32 flags1;
   uint32 total_lines;
} t_microcode_header;

#ifdef PROFILE_TASKS_VR9

typedef struct {
   int32 l_MaxMIPSCnt;      //maximum no. of foreground MIPS count
   int32 l_TxTC_MIPSCnt;   //TX TC MIPS count
   int32 l_RxTC_MIPSCnt;   //RX TC MIPS count
   int32 l_TxNTC_MIPSCnt;   //TX TC MIPS count
   int32 l_RxNTC_MIPSCnt;   //RX TC MIPS count
   int16 s_TxState;
   int16 s_TxSubState;
   int16 s_RxState;
   int16 s_RxSubState;
} MaxMipsCnt_t;

//XDSLRTFW-3362 (Start)
#ifdef PROFILE_TASKS_35B
typedef struct {
   int32 l_MaxMips;
   int32 l_MaxMipsPmdFrameCnt;
   int32 l_MinMips;
   int32 l_MinMipsPmdFrameCnt;
} CasMipsCnt_t;

typedef struct {
   CasMipsCnt_t  t_CasMipsCntFwTasks[CASCADE_ST_NUM_FW_TASKS];
   int32 l_Start_TX_TCtask_min;
   int32 l_Start_TX_TCtask_max;
   int32 l_Start_RX_TCtask_min;
   int32 l_Start_RX_TCtask_max;
   int32 l_Start_RX_PMS_min;
   int32 l_Start_RX_PMS_max;
   //XDSLRTFW-3901 (Start)
   uint32 ul_RX_TC_MaxMipsCnt;
   uint32 ul_TX_TC_MaxMipsCnt;
   //XDSLRTFW-3901 (End)
} CasFwTasksMips_t;

typedef struct {
   int32 l_MaxMips;
   int16 s_TxState;
   int16 s_TxSubState;
   int16 s_RxState;
   int16 s_RxSubState;
} CascadeMaxMipsCnt_t;

#endif //#ifdef PROFILE_TASKS_35B
//XDSLRTFW-3362 (End)

#endif //#ifdef PROFILE_TASKS_VR9

   //Feature_ALL_ALL_ALL_AFE_DFE_3GLP_Status (Start)
   // Struct "RdyOvfUdf_t" is defined currently for 3GLP block only status can be extended for DFE,AFE also
   typedef struct {
      // Status of 3GLP block in VR9
      //index 0 =>Macro_0,index 1 Macro_1
      int16 s_DS_GLP_SYNC_ERR[2];         //GLP_TOP_STATUS
      int16 s_DS_GLP_FR_ERR[2];            //GLPM_GLP_FR_ERR_0,GLPM_GLP_FR_ERR_1
      int16 s_DS_GLP_DFE_FIFO_ERR_OVF[2]; //Overflow  of GLP_RX0FIFO_CFG,GLP_RX1FIFO_CFG
      int16 s_DS_GLP_DFE_FIFO_ERR_UDF[2]; //Underflow of GLP_RX0FIFO_CFG,GLP_RX1FIFO_CFG
      int16 s_DS_GLP_AFE_FIFO_ERR[2];

      int16 s_US_GLP_SYNC_ERR[2];
      int16 s_US_GLP_FR_ERR[2];
      int16 s_US_GLP_DFE_FIFO_ERR_OVF[2];  //Overflow of  GLP_TX0FIFO_CFG,GLP_TX1FIFO_CFG
      int16 s_US_GLP_DFE_FIFO_ERR_UDF[2];  //Underflow of GLP_TX0FIFO_CFG,GLP_TX1FIFO_CFG
      int16 s_US_GLP_AFE_FIFO_ERR[2];

   } RdyOvfUdf_t;
   //Feature_ALL_ALL_ALL_AFE_DFE_3GLP_Status (End)

   //XDSLRTFW-506-TELEFONICA_MAXPROFILE-WORKAROUND-INP-CASES
   typedef struct {
      uint16 us_ECI; //Dummy Presently, To keep in CMV in sync with IOP Branch
      uint16 us_TELEFONICA_DS_US_RATES;
     uint16 us_TELIASONERA_UPBO;
     //XDSLRTFW-789 IOP_ALL_ALL_ALL_AelemCapabilityInGHsCLRMsg (Start_End)
     uint16 us_Generic_IOP_Fixes; //Tied AELEM enable/disable to this
   } CustomerIOPBits_t;
   //XDSLRTFW-506-TELEFONICA_MAXPROFILE-WORKAROUND-INP-CASES

//L2_Back_Channel
//Refer to Message catalog: CNTR 55
// XDSLRTFW-3492 (Start)
typedef struct
{
   uint32 ul_ErrVectDiscard; // Discarded L2 Error Vectors counter //XDSLRTFW-1524 (start-end) --> This should be ideally Zero
   uint32 ul_ErrVecTransmitted;  // Number of ERB segments transmitted to PPE
   uint32 ul_ErrVecRequested; // Number of ERBs requeted by the CO (incremented at every sync symbol when m=1)
   // Internal counters
   uint32 ul_ErrVecTransmittedSegments;   // Number of ERB segments transmitted to the PPE
   uint32 ul_NumOfSymbols_ERB;   // Maximum number of symbols taken by the DSL FW to compute ERB and to transmit to the PPE
   // We cannot find out when the ERB is actualy sent on the line. We can only find the number of symbols taken by
   // PPE to clear the owner bit in ERB descriptor.
   uint32 ul_TotalNumofSymbols_ERB;   // Total number of symbols taken to put ERBs in codeword buffer (computation + transmission to PPE + PPE copying to codeword buffer)
}DSM_Stats_t;
// XDSLRTFW-3492 (End)

//Refer to Message catalog: CNFG 83
typedef struct
{
    uint16 SrcMacAdrsB0_1; // Source MAC Address Octets 0 to 1
    uint16 SrcMacAdrsB2_3; // Source MAC Address Octets 2 to 3
    uint16 SrcMacAdrsB4_5; // Source MAC Address Octets 4 to 5
}MacFrameConfigure_t;

//XDSLRTFW-285: Feature_ALL_ALL_ALL_Config_Modem_Feature_Map (Start)
//Refer to CMV 'DSL 20' in Message Spec ver 3.1
typedef struct {
   uint16 us_Length; // parameter 2    // XDSLRTFW-3637 (Start_End)
   uint16 Param[3];  //Parameter 3 to 5
} ModemFeatureMap_t;
//XDSLRTFW-285: Feature_ALL_ALL_ALL_Config_Modem_Feature_Map (End)

//XDSLRTFW-1193 Feature_US_VDSL2_ALL_UsReTx_CMV(START)
typedef struct {

//following 3 variables mapped to CNFG 84 0
int16 s_UsReTx_FrameType_Support; //framing types supported by CPE in US ReTx... bit wise... bit0=type 2, bit1=type 3 and bit2=type 4.
int16 s_TxHalfRoundTripInDTUs;
int16 s_TxHalfRoundTripInSymbols;
} ConfigVar_USReTx_t;
//XDSLRTFW-1193 Feature_US_VDSL2_ALL_UsReTx_CMV(END)

typedef struct {

   //following variables tied to INFO 239 0
   uint16 us_MinRoundTripDelay_DTUS; //Minimum round trip delay in DTUs(upstream ReTx)
   uint16 us_MaxRoundTripDelay_DTUS; //Maximum round trip delay in DTUs(upstream ReTx)
} UsReTxDelay_DTU_t;

// XDSLRTFW-1479 (Start)
typedef struct {
      int16 s_NumPilotTones;
      int16 ta_PilotTones[16];
      //XDSLRTFW - 214 (Start_End)
      uint16 usa_PilotToneConstellation[2];     // The size of this array is 2 because we have only 1 pilot tone. The size has to be increased if more than 1 pilot tones are used. To store constellation of one pilot tone, we need 4 bytes of data.
} DsStPilotDescriptorTable_t;

typedef struct {
      int16 s_OOS_Failure;
   int16 s_LCD_NCD_Failure;
} DataPathFailures_t;

// XDSLRTFW-1479 (End)

// XDSLRTFW-1877 : VDSL2 IFEC ATTNDR (Start)
typedef struct {
   uint16 us_DBG_ATTNDR_METHOD_FORCED; // 0, 1, 2
   uint16 us_DBG_ATTNDR_MDO_FORCED_LO;
    uint16 us_DBG_ATTNDR_MDO_FORCED_HI;
    uint16 us_ATTNDR_MISC_CONFIGURATION; // XDSLRTFW-3556 : VRx518 shows different method_0 attainable datarate than VR9(R7)
} ConfigVar_Improved_ATTNDR_t;

typedef struct {
   uint16 us_ATTNDR_ACT_METHOD; // 0, 1, 2
    uint16 us_ATTNDR_ACT_INPds;
    uint16 us_ATTNDR_ACT_INP_REINds;
    uint16 us_ATTNDR_ACT_DELAYds;
} Improved_ATTNDR_ActParam_t;

// XDSLRTFW-1877 : VDSL2 IFEC ATTNDR (End)

// XDSLRTFW-1622 (Start)
typedef struct {
   uint16 us_RtxUsRrcCaptureCnt; // 0, 1, 2 .. 255
   uint16 us_ResetRoundTripDelay;
} RtxDbgCapture_t;
// XDSLRTFW-1622 (End)


// Bonding and TC type information
// This consists of both TC type and the Bonding Information
// Bit 0  ==> ATM TC loaded or not
// Bit 1  ==> PTM TC loaded or not
// Bit 2  ==> Bonding FW loaded or not
// If the bit is set to 1, then that is loaded
typedef struct {
   int16 s_TC_Type;
} Bonding_TC_Info;

// ERB descriptor
typedef struct {
   uint32 ul_DW0;   // This is the offset of destination for ERB ethernet segments to make DMA
   uint32 ul_DW1;   // It contains the length of erb ethernet segment, owner bit and few other parameters
} ERBDescriptor;

typedef struct {
   uint8 ft_ERB_Configure_DMA;
   uint8 ft_Trigger_DMA;
   uint8 ft_Triggered_DMA;
   uint8 uc_ping_pong;
   uint8 ft_ERB_Last_Segment;
   uint8 uc_EVB_DebugBuff_flag;
   uint16 us_ERB_DMA_STATE;
   uint8 c_FormErbInShowtimeState;
} SDRAMDebug;

// XDSLRTFW-3359 (Start)
typedef struct {
   uint16 Hp_stats;
   uint16 Mp_stats;
   uint16 Rp_stats;
   uint16 Np_stats;
   uint16 Q_stats;
   uint16 V_stats;
   uint16 Qtx_stats;
   uint16 Loopback_Stats;
   uint16 Memory_stats;
   uint16 DTU_stats;
}US_SRA_Stats_t;
// XDSLRTFW-3359 (End)

// XDSLRTFW-3367 (Start)
typedef struct {
   uint16 us_Busy;
   uint16 us_Invalid_Parameters;
   uint16 us_Not_Enabled;
   uint16 us_Not_Supported;
}OLR_Reject_t;

typedef struct {
   OLR_Reject_t t_Bitswap;
   OLR_Reject_t t_SRA;
}DS_OLR_Reject_t;
// XDSLRTFW-3367 (End)

// XDSLRTFW-3441 Start
//DFE/AFE blocks Gain settings
typedef struct {
   int16 s_RxPathTrafo_Gain_dB;                // RxPath Transformer gain
   int16 s_AfeLevelShiftDfe_Gain_dB;           // analog voltage at ADC input to digital signal in range (+/-1v)
   int16 s_Rx_CIC_Gain_dB;                     // typically: 0dB
   int16 s_Rx_WDF_DEC2_Gain_dB;                // typically: 0dB
   int16 s_ADC_Adjust_Gain_dB;                 // digital signal in range (+/-32768) to (+/-28672)=20*log((32768-4096)/32768) =-1.16 db
   int16 s_Rx_WDF_DEC1_Gain_dB;                // typically: 0dB, option to change with the WDF Scaling
   int16 s_Rx_FIR_Decim1_Gain_dB;              // typically: 0dB, option to change with the RXDECIMX Scaling/Coefficients
   int16 s_Rx_SRC_Gain_dB;                     // typically: 0dB,option to change with the RXDECIMX Scaling/Coefficients
   int16 s_Rx_IIR_Gain_dB;                     // typically: 0dB,option to change with the Output Scaling/Coefficients
   int16 s_Rx_TDQ_Gain_dB;                     // typically: 0dB,option to change with the Output Scaling/Coefficients
   int16 s_Rx_VGWin_Gain_dB;                   // RxVarGain 0dB during Gain training, after PGA2 train = Avg-Peak power
   int16 s_Rx_FFT_Gain_Rms_dB;                 // FFT Gain RMS[dB] = 20*log10(sqrt(FFTSize)/2^RSH), with FFTSize = 2*Nfft
   int16 s_Rx_FFT_Gain_dBPerHz;                // FFT Gain dBm/Hz = 20*log(2^RSH / (2Nfft)) + 10*log(2), with FFTSize = 2*Nfft
   int16 s_Rx_Total_TdqToAfeInterface_Gain_dB; // Rx DFE gain from AFE/DFI interface to TDQ block (used at present)
   int16 s_Rx_Total_FftToAfeInterface_Gain_dB; // Rx DFE gain from AFE/DFI interface to FFT  block(Not used at present, may be useful later)
} RxPathGains_t;
// XDSLRTFW-3441 End

//XDSLRTFW-3596 Start
typedef struct {
   FlagT ft_eFuseDataAvailOnChip;     //Indicates whether AFE fusing data available or not(if bit#0 of AFE_VEGA_EFUSE is 1)
   int16 s_RX_IN_IMP_in;            //bits[21:16] RX_IN_IMP of AFE_ADCDSL_EFUSE;Range:-32% to +31% in 1% steps
   int16 s_RX_GAIN_ERR_in;          //bits[28:24]abs_error_rx of AFE_ADCDSL_EFUSE;RX absolute gain error in RX path.Range:-1.6dB to +1.5dB in 0.1dB steps
   int16 s_RX_GAIN_ERR_dB_Out;         //Convert s_RX_GAIN_ERR_in value into 8.8
   int16 s_imp_error_rx_dB_out;     //input impedance variation correction in dB 8.8
   int16 s_corr_gain_rxa_dB_out;       //Total RxGain correction for input RXA(corr_gain_rxa=-abs_error_rximp_error_rx(var)) in dB 8.8
} RxPathDslGainCorrection_t;
//XDSLRTFW-3596 End

// XDSLRTFW-3741 (Start_End)
typedef struct {
   int16 s_HighestAllowedRxTone;
   int16 s_LowestAllowedRxTone;
   int16 s_HighestAllowedTxTone;
   int16 s_LowestAllowedTxTone;
}DbgAllowedToneInfo_t;
// XDSLRTFW-3898(Start)
typedef struct {
   int16 s_control;
   uint16 usa_hyb_coeff_idx[VRX518_RECONF_HYB_NUM_SETTINGS];
}Reconfig_Hyb_Coeff_t;
// XDSLRTFW-3898(End)

// XDSLRTFW-4051 Fast downstream up shift SRA(Start)
typedef struct {
   uint16 us_FastDsSraConfig;
   uint16 us_TimeAfterShowtimeToDisableFastSra;      // Time in sec, - value: never disable Fast SRA option
   uint16 us_TimeAfterShowtimeToCheckForRejection_3; // Time in sec, - value: never look for SRA rejection code 3
}FastDsSraConfig_t;
// XDSLRTFW-4051 Fast downstream up shift SRA(End)

#endif // _VDSL_TYPEDEF_H
