/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2011 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
#ifndef _VDSL_XCEPTION_H
#define _VDSL_XCEPTION_H

/**********************************************************************
 *
 * Aware DMT Technology. Proprietary and Confidential.
 *
 * ADDRESS:          40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 * TELEPHONE:        781.276.4000
 * FAX:              781.276.4001
 * WEB:              http://www.aware.com
 *
 * FILE:             vdsl_xception.h
 * DESCRIPTION:      Header file exception codes
 *
 **********************************************************************/

// *************************************************************************************************
// vdsl_xception.h
//
// History
//
// 12/12/2012 Ram: Indicating correct "System error code" & "System sub error code" when failed in showtime
//                 Grep for: "XDSLRTFW-405: BugFix_DS_VDSL2_ALL_Incorrect_Error_Code_On_Showtime_Fail"
//
// 19/12/2012 Abu: FAST Loss detection in training (vectoring mode)
//                 Grep XDSLRTFW-645 / XDSLRTFW-674
// 21/01/2013 Ram: Added error/exception codes for LOM and OOS.
//
//15/01/2013 Kannan: Added exception codes for AFE init fail indication.
//                   Grep for: "XDSLRTFW-118: VR9_VRX318_AFE_Init_Fail_Indication"
//
//15/01/2013 Kannan: Added an exception code for Orderly shutdown.
//                   Grep for: "XDSLRTFW-710 VR9_VRX318_PDBRAM_Handover_OrderlyShutDown"
// 12/04/2013 Fuss: Added an exception code for Vectoring OP-Vertor1/1-1 signal loss, i.e. E_CODE_RX_OPVECTOR_SIGNAL_LOSS
//            XDSLRTFW-791: OP-Vect1: transition to OP-CD-V1 fails (IVE exception: 0x7D4)
//            XDSLRTFW-792: OP-Vect1_1: transition to OP-training-V1 fails (IVE exception: 0x7D4)
//            Grep for: XDSLRTFW-791,XDSLRTFW-792
//
// 10/07/2013 Sriram : Endless G.Hs training session in case of missing common mode in CO / CPE capabilities
//                     Grep for   XDSLRTFW-961 :BugFix_ALL_ALL_ALL_Hsk_NAKEF_Error
//
// 11/07/2013 Vinjam: Added New sub error code "S_FAST_LOS" (0x14)
// 05/07/2013 Varun : Added exception codes to identify the wrong values/contents of O-PMS in ReTx mode
//                    Grep for "XDSLRTFW-1046 Feature_US_VDSL2_ALL_UsReTx"
// 18/11/2013 Prashant: Resolved "UnKnown" System/SubSystem Error Codes" reported during failure state.
//                    Grep for XDSLRTFW-1385 BugFix_DS_VDSL2_ALL_ErrorCodes_On_FailState
//
// 05/12/2013 Prashant: Clean-up re-using of suberror code '0x26'. Confirmed with Thomos, that they are not using
//                      this sub-error code. So instaed of defining new costant reusing the existing one Esub_ReTrain.
//                      Clean-up for reusing the exception codes.
//                      Grep for XDSLRTFW-972
//
// 29/01/2014 Abu: XDSLRTFW-1535 CMV Controlled Link Drop
//                 Grep : XDSLRTFW-1535 CMV_Controlled_Link_Drop
//
//
// 24/09/2015 Vinay: Added new exception for G.Fast in G.Hs session
//                   Grep for XDSLRTFW-2298
//
//07/02/2018 Sriram shastry: VRX518: VDSL2 35b Vect. Sync Prob. with ADTRAN IUVDSL:48:SVM:F
//               No sync issue is seen when the maxETR is higher than maxNDR. Due to  CO Mis configuration
//               CPE fail with E_CODE_RX_LOW_PILOT_TONE_POWER.So the solution is cap max ETR to max NDR if maxETR > maxNDR
//               cmv description : TEST 55 0 1
//               (Default:ON)
//               Search  pattern : XDSLRTFW-3677
//
// ************************************************************************************************************

// XDSLRTFW-405: BugFix_DS_VDSL2_ALL_Incorrect_Error_Code_On_Showtime_Fail (Start)
// XDSLRTFW-1385 BugFix_DS_VDSL2_ALL_ErrorCodes_On_FailState (Start)
// System Error Code
// Refer sec 5.1.7 (STAT 5) of Msg catalog/Spec, Revision 1.8
#define E_OK                                                0x0             // No Error
#define E_CONFIG                                            0x1             // Configuration Error
#define E_NOTFEASIBLE                                       0x2             // Not feasible on line
#define E_COMM                                              0x3             // Communication problem (Protocol init failure)
#define E_COMMCRC                                           0x4             // Communication problem (Data init failure)
#define E_NOPEER                                            0x5             // No peer modem
#define E_CHIPSET                                           0x6             // Chipset failure
#define E_UNKNOWN                                           0x7             // Any other unknown failure
#define E_RESERVED                                          0x8             // Reserved
#define E_SHOWTIME_NE                                       0x10            // Near-End (showtime) failure causing the fall-out of steady state
#define E_SHOWTIME_FE                                       0x11            // Far-End (showtime) failure causing the fall-out of steady state


// System Sub Error Code
// Refer sec 5.1.7 (STAT 5) of Msg catalog/Spec, Revision 1.8
#define Esub_Unknown                                        0x0             // S_OK - No error
#define Esub_CodeSwap                                       0x1             // S_CODESWAP
#define Esub_PSD                                            0x2             // Not defined in Msg catalog/Spec
#define Esub_RateUS                                         0x3             // Not defined in Msg catalog/Spec
#define Esub_RateDS                                         0x4             // S_MINRATE_DS
#define Esub_ReTrain                                        0x5             // S_INIT
#define Esub_INIT                                           Esub_ReTrain
#define Esub_S_TC_Mode                                      Esub_ReTrain    // TC Not If Not Supported By DSLAM // XDSLRTFW-972 (Start_End)
#define Esub_GhsNoCommonMode                                0x6             // S_MODE
#define Esub_HwModeChange                                   0x7             // Unique sub error code for double training: needed by the host to recognize the double training
                                                                            // Not defined in Msg catalog/Spec
#define Esub_UpboCheck                                      0x8             // Unique sub error code for UPBO compliance check: needed by the host to report error to the user API
                                                                            // Not defined in Msg catalog/Spec
#define Esub_Timeout                                        0x9             // S_TIMEOUT
#define Esub_S_XDSL_MODE                                    0xA             // S_XDSL_MODE - Retrain reqd with opp xDSL flavour
#define Esub_S_PORT_MODE                                    0xB             // S_PORT_MODE - Retrain reqd with opp Port mode but in same xDSL flavour
#define Esub_S_T1413_MODE                                   0xC             // S_T1413_MODE- Retrain required with ADSL FW in T1.413 mode
#define Esub_G_FAST_MODE                                    0xD             // G_FAST_MODE - To switch to G.Fast HW   // XDSLRTFW-2298 (Start_End)
#define Esub_FWInitiatedRetrain                             0xE             // S_FW_RETRY - FW forced retrain with the same xDSL flavour
#define Esub_FW_HYB_MISMATCH                                0xF             // S_FW_HYB - Wrong FW for the used Hybrid type
#define Esub_S_LOS                                          0x10            // S_LOS - Loss of Signal
#define Esub_S_LOF                                          0x11            // S_LOF - Loss of Frame
#define Esub_S_LPR                                          0x12            // S_LPR - Loss of Power
#define Esub_S_LOM                                          0x13            // S_LOM - Loss of Margin
#define Esub_S_FAST_LOS                                     0x14            // S_FAST_LOS - Fast LOS
#define Esub_S_ESE                                          0x15            // S_ESE - Excessive Severe Errors
#define Esub_S_ESX                                          0x16            // S_ESx - Error Seconds
#define Esub_S_SESX                                         0x17            // S_SESx - Excessive Severe Error Seconds
#define Esub_S_OOS0                                         0x18            // S_OOS0 - Out of Synchronization BC0 (PTM)
#define Esub_S_LCD0                                         0x20            // S_LCD0 - Loss of Cell Delineation BC0 (ATM only)
#define Esub_S_NCD0                                         0x22            // S_NCD0 -  No Cell Delineation BC0 (ATM only)
#define Esub_S_CRC_DS                                       0x24            // S_CRC_DS -  Excessive DS CRCs (ADSL only)
#define Esub_S_PP_DRIVER                                    0x25            // S_PP_DRIVER  - Driver for selected TPS-TC mode not ready for Showtime entry
#define Esub_S_INTENDED_LOCAL_SHUTDOWN                      0x26            // S_INTENDED_LOCAL_SHUTDOWN  - API initiated shutdown
#define Esub_S_HW_Error                                     0x27
#define Esub_S_PSD_CALIBRATION                              0x28            // XDSLRTFW-2260
#define Esub_S_AUTO_MSG                                     0x29            // S_AUTO_MSG
#define Esub_S_ERB_INIT                                     0x2A            // XDSLRTFW-4041 (Start_End)
#define Esub_S_REBOOT_REQ                                   0x2B            // XDSLRTFW-4041 (Start_End)
#define Esub_S_MAX_SOS                                      0x2C            // S_MAX_SOS_DS  // not used in R5
#define Esub_S_SOS_MINRATE                                  0x2D            // S_SOS_MINRATE // not used in R5

/* ============================================================================================ */
/* T1.413/G.992.1/G.992.2 Exception Codes */
/* *** do not add any new exception code here except for the merge from ADSL code base *** */
/* ============================================================================================ */
#define E_CODE_NO_ERROR                                     (0)                                                                 ///< (0x0000)
#define E_CODE_BAT_TX                                       (E_NOTFEASIBLE | (Esub_Unknown<<8)              | ((  1)<<16))          ///< (0x0001) TX BAT table is incorrect */
#define E_CODE_BAT_RX                                       (E_NOTFEASIBLE | (Esub_Unknown<<8)              | ((  2)<<16))          ///< (0x0002) RX BAT table is incorrect */
#define E_CODE_PROFILE                                      (E_CONFIG      | (Esub_ReTrain<<8)              | ((  3)<<16))          ///< (0x0003) profile is not selected in fast retrain */
#define E_CODE_TX_AOC_FIFO_OVERFLOW                         (E_COMM        | (Esub_Unknown<<8)              | ((  4)<<16))          ///< (0x0004)
#define E_CODE_TRUNCATE_FR                                  (E_CONFIG      | (Esub_ReTrain<<8)              | ((  5)<<16))          ///< (0x0005) Fast Retrain truncated due to no stored profiles*/
#define E_CODE_BITLOAD                                      (E_NOTFEASIBLE | (Esub_Unknown<<8)              | ((  6)<<16))          ///< (0x0006) bit loading fails */
#define E_CODE_ST_ERROR                                     (E_COMMCRC     | (Esub_Unknown<<8)              | ((  7)<<16))          ///< (0x0007) showtime CRC error */
#define E_CODE_RESERVED                                     (E_CONFIG      | (Esub_Unknown<<8)              | ((  8)<<16))          ///< (0x0008) using parameters reserved by the ITU-T */
#define E_CODE_C_TONES                                      (E_UNKNOWN     | (Esub_Unknown<<8)              | ((  9)<<16))          ///< (0x0009) detected C_TONES */
#define E_CODE_CODESWAP_ERR                                 (E_UNKNOWN     | (Esub_CodeSwap<<8)             | (( 10)<<16))         ///< (0x000a) codeswap not finished in time */
#define E_CODE_FIFO_OVERFLOW                                (E_UNKNOWN     | (Esub_Unknown<<8)              | (( 11)<<16))         ///< (0x000b) we have run out of fifo space */
#define E_CODE_C_BG_DECODE_ERR                              (E_COMMCRC     | (Esub_Unknown<<8)              | (( 12)<<16))         ///< (0x000c) error in decoding C-BG message */
#define E_CODE_C_RATES2_DECODE_ERR                          (E_COMMCRC     | (Esub_Unknown<<8)              | (( 13)<<16))         ///< (0x000d) error in decoding C-MSGS2 and C-RATES2 */
#define E_CODE_RCMedleyRx_C_SEGUE2_Failure                  (E_COMM        | (Esub_Unknown<<8)              | (( 14)<<16))         ///< (0x000e) Timeout after RCMedleyRx waiting for C_SEGUE2 */
#define E_CODE_RReverbRATx_C_SEGUE2_Failure                 (E_COMM        | (Esub_Unknown<<8)              | (( 15)<<16))         ///< (0x000f) Timeout after RReverbRATx waiting for C_SEGUE2 */
#define E_CODE_RReverb3Tx_C_SEGUE1_Failure                  (E_COMM        | (Esub_Unknown<<8)              | (( 16)<<16))         ///< (0x0010) Timeout after RReverb3Tx waiting for C_SEGUE1 */
#define E_CODE_RCCRC2Rx_C_RATES1_DECOD_ERR                  (E_COMMCRC     | (Esub_Unknown<<8)              | (( 17)<<16))         ///< (0x0011) Received CRC not equal to computed CRC */
#define E_CODE_RCCRC1Rx_C_RATES1_DECOD_ERR                  (E_COMMCRC     | (Esub_Unknown<<8)              | (( 18)<<16))         ///< (0x0012) Received CRC not equal to computed CRC */
#define E_CODE_RReverb5Tx_C_SEGUE2_Failure                  (E_COMM        | (Esub_Unknown<<8)              | (( 19)<<16))         ///< (0x0013) Timeout after RReverb5Tx waiting for C_SEGUE2 */
#define E_CODE_RReverb6Tx_C_SEGUE3_Failure                  (E_COMM        | (Esub_Unknown<<8)              | (( 20)<<16))         ///< (0x0014) Timeout after RReverb6Tx waiting for C_SEGUE3 */
#define E_CODE_RSegue5Tx_C_SEGUE3_Failure                   (E_COMM        | (Esub_Unknown<<8)              | (( 21)<<16))         ///< (0x0015) Timeout after RSegue5Tx waiting for C_SEGUE3 */
#define E_CODE_RCReverb5Rx_C_SEGUE_Failure                  (E_COMM        | (Esub_Unknown<<8)              | (( 22)<<16))         ///< (0x0016) Timeout after RCReverb5Rx waiting for C_SEGUE */
#define E_CODE_RCReverbRARx_C_SEGUE2_Failure                (E_COMM        | (Esub_Unknown<<8)              | (( 23)<<16))         ///< (0x0017) Timeout after RCReverbRARx waiting for C_SEGUE2 */
#define E_CODE_RCCRC4Rx_CMSGS2_DECOD_ERR                    (E_COMMCRC     | (Esub_Unknown<<8)              | (( 24)<<16))         ///< (0x0018) Received CRC not equal to computed CRC */
#define E_CODE_RCCRC5Rx_C_BG_DECOD_ERR                      (E_COMMCRC     | (Esub_Unknown<<8)              | (( 25)<<16))         ///< (0x0019) Received CRC not equal to computed CRC */
#define E_CODE_RCCRC3Rx_DECOD_ERR                           (E_COMMCRC     | (Esub_Unknown<<8)              | (( 26)<<16))         ///< (0x001a) Received CRC not equal to computed CRC */
#define E_CODE_RCPilot3_DEC_PATH_DEL_TIMEOUT                (E_COMM        | (Esub_Unknown<<8)              | (( 27)<<16))         ///< (0x001b) DEC Path Delay timeout */
#define E_CODE_RCPilot3_DEC_TRAINING_TIMEOUT                (E_COMM        | (Esub_Unknown<<8)              | (( 28)<<16))         ///< (0x001c) DEC Training timeout */
#define E_CODE_RCReverb3Rx_C_SEGUE1_Failure                 (E_COMM        | (Esub_Unknown<<8)              | (( 29)<<16))         ///< (0x001d) Timeout after RCReverb3Rx waiting for C_SEGUE1 */
#define E_CODE_RCReverb2Rx_SignalEnd_Failure                (E_COMM        | (Esub_Unknown<<8)              | (( 30)<<16))         ///< (0x001e) Timeout waiting for the end of RCReverb2Rx signal */
#define E_CODE_RQuiet2_SignalEnd_Failure                    (E_COMM        | (Esub_Unknown<<8)              | (( 31)<<16))         ///< (0x001f) Timeout waiting for the end of RQuiet2 signal */
#define E_CODE_RCReverbFR1Rx_Failure                        (E_COMM        | (Esub_Unknown<<8)              | (( 32)<<16))         ///< (0x0020) Timeout waiting for the end of RCReverbFR1Rx signal */
#define E_CODE_RCPilotFR1Rx_SignalEnd_Failure               (E_COMM        | (Esub_Unknown<<8)              | (( 33)<<16))         ///< (0x0021) Timeout waiting for the end of RCPilotFR1Rx signal */
#define E_CODE_RCReverbFR2Rx_C_Segue_Failure                (E_COMM        | (Esub_Unknown<<8)              | (( 34)<<16))         ///< (0x0022) Timeout after RCReverbFR2Rx waiting for C_SEGUE */
#define E_CODE_RCReverbFR5Rx_SignalEnd_TIMEOUT              (E_COMM        | (Esub_Unknown<<8)              | (( 35)<<16))         ///< (0x0023) Timeout waiting for the end of RCReverbFR5Rx signal */
#define E_CODE_RCReverbFR6Rx_C_SEGUE_Failure                (E_COMM        | (Esub_Unknown<<8)              | (( 36)<<16))         ///< (0x0024) Timeout after RCReverbFR6Rx waiting for C_SEGUE */
#define E_CODE_RCReverbFR8Rx_C_SEGUE_FR4_Failure            (E_COMM        | (Esub_Unknown<<8)              | (( 37)<<16))         ///< (0x0025) Timeout after RCReverbFR8Rx waiting for C_SEGUE_FR4 */
#define E_CODE_RCReverbFR8Rx_No_PROFILE                     (E_COMM        | (Esub_Unknown<<8)              | (( 38)<<16))         ///< (0x0026) Timeout since no profile was selected */
#define E_CODE_RCReverbFR8Rx_SignalEnd_TIMEOUT              (E_COMM        | (Esub_Unknown<<8)              | (( 39)<<16))         ///< (0x0027) Timeout waiting for the end of RCReverbFR8Rx signal */
#define E_CODE_RCCRCFR1_DECOD_ERR                           (E_COMMCRC     | (Esub_Unknown<<8)              | (( 40)<<16))         ///< (0x0028) Received CRC not equal to computed CRC */
#define E_CODE_RCRecovRx_SingnalEnd_TIMEOUT                 (E_COMM        | (Esub_Unknown<<8)              | (( 41)<<16))         ///< (0x0029) Timeout waiting for the end of RCRecovRx signal */
#define E_CODE_RSegueFR5Tx_TX_Not_Ready_TIMEOUT             (E_COMM        | (Esub_Unknown<<8)              | (( 42)<<16))         ///< (0x002a) Timeout after RSegueFR5Tx waiting for C_SEGUE2 */
#define E_CODE_RRecovTx_SignalEnd_TIMEOUT                   (E_COMM        | (Esub_Unknown<<8)              | (( 43)<<16))         ///< (0x002b) Timeout waiting for the end of RRecovTx signal */
#define E_CODE_RCMedleyFRRx_C_SEGUE2_Failure                (E_COMM        | (Esub_Unknown<<8)              | (( 44)<<16))         ///< (0x002c) Timeout after RCMedleyFRRx waiting for C_SEGUE2 */
#define E_CODE_CONFIGURATION_PARAMETERS_ERROR               (E_CONFIG      | (Esub_Unknown<<8)              | (( 45)<<16))         ///< (0x002d) one of the configuration parameters do not meet the standard */
#define E_CODE_BAD_MEM_ACCESS                               (E_UNKNOWN     | (Esub_Unknown<<8)              | (( 46)<<16))         ///< (0x002e)
#define E_CODE_BAD_INSTRUCTION_ACCESS                       (E_UNKNOWN     | (Esub_Unknown<<8)              | (( 47)<<16))         ///< (0x002f)
#define E_CODE_TX_EOC_FIFO_OVERFLOW                         (E_COMM        | (Esub_Unknown<<8)              | (( 48)<<16))         ///< (0x0030)
#define E_CODE_RX_EOC_FIFO_OVERFLOW                         (E_COMM        | (Esub_Unknown<<8)              | (( 49)<<16))         ///< (0x0031)
#define E_CODE_GHS_CD_FLAG_TIME_OUT                         (E_COMM        | (Esub_Unknown<<8)              | (( 50)<<16))         ///< (0x0032) Timeout when transmitting Flag in handshake cleardown */


/* ============================================================================================ */
/* G.992.3/G.992.5 Exception Codes */
/* *** do not add any new exception code here except for the merge from ADSL code base *** */
/* ============================================================================================ */
#define E_CODE_RCReverb3Rx_bis_SignalEnd_Failure            (E_COMM         | (Esub_Unknown<<8)             | (( 51)<<16))         ///< (0x0033) Timeout waiting for the beginning of RCTref2Rx_bis signal
#define E_CODE_RCTref2_bis_DEC_PATH_DEL_TIMEOUT             (E_COMM         | (Esub_Unknown<<8)             | (( 52)<<16))         ///< (0x0034) DEC Path Delay timeout
#define E_CODE_RCTref2_bis_DEC_TRAINING_TIMEOUT             (E_COMM         | (Esub_Unknown<<8)             | (( 53)<<16))         ///< (0x0035) DEC Training timeout
#define E_CODE_RReverb5Tx_bis_C_SEGUE1_Failure              (E_COMM         | (Esub_Unknown<<8)             | (( 54)<<16))         ///< (0x0036) Timeout after RReverb5Tx waiting for C_SEGUE1
#define E_CODE_RCReverb4Rx_Bis_C_SEGUE1_Failure             (E_UNKNOWN      | (Esub_Unknown<<8)             | (( 55)<<16))         ///< (0x0037)
#define E_CODE_RCCRC1Rx_Bis_C_MSG1_DECOD_ERR                (E_UNKNOWN      | (Esub_Unknown<<8)             | (( 56)<<16))         ///< (0x0038)
#define E_CODE_RCReverb5Rx_Bis_C_SEGUE_Failure              (E_UNKNOWN      | (Esub_Unknown<<8)             | (( 57)<<16))         ///< (0x0039)
#define E_CODE_RCMsgFmtRx_Bis_DECOD_ERR                     (E_COMMCRC      | (Esub_Unknown<<8)             | (( 58)<<16))         ///< (0x003a) CRC mismatch for C-MSG-FMT or C-MSG-PCB
#define E_CODE_RCQuietRx_Bis_TIME_OUT                       (E_COMM         | (Esub_Unknown<<8)             | (( 59)<<16))         ///< (0x003b)
#define E_CODE_RQuietTx_Bis_TIME_OUT                        (E_COMM         | (Esub_Unknown<<8)             | (( 60)<<16))         ///< (0x003c)
#define E_CODE_RCCRC1Rx_Bis_C_MSG2_DECOD_ERR                (E_UNKNOWN      | (Esub_Unknown<<8)             | (( 61)<<16))         ///< (0x003d)
#define E_CODE_RReverb6Tx_Bis_TIME_OUT                      (E_COMM         | (Esub_Unknown<<8)             | (( 62)<<16))         ///< (0x003e)
#define E_CODE_RCReverb6Rx_Bis_C_SEGUE3_Failure             (E_UNKNOWN      | (Esub_Unknown<<8)             | (( 63)<<16))         ///< (0x003f)
#define E_CODE_RCCRC1Rx_Bis_C_PARAMS_DECOD_ERR              (E_UNKNOWN      | (Esub_Unknown<<8)             | (( 64)<<16))         ///< (0x0040)
#define E_CODE_RCReverb7Rx_Bis_C_SEGUE_Failure              (E_UNKNOWN      | (Esub_Unknown<<8)             | (( 65)<<16))         ///< (0x0041)
#define E_CODE_RReverb7Tx_Bis_TIME_OUT                      (E_COMM         | (Esub_Unknown<<8)             | (( 66)<<16))         ///< (0x0042)
//#define E_CODE_BIS_RC_CRC_CALC_BG_INCOMPLETE              (E_UNKNOWN      | (Esub_Unknown<<8)             | (( 67)<<16))         ///< (0x0043)
//#define E_CODE_BIS_FORM_RPARAMS_BG_INCOMPLETE             (E_UNKNOWN      | (Esub_Unknown<<8)             | (( 68)<<16))         ///< (0x0044)
#define E_CODE_RSegue4Tx_DATA_PUMP_SETUP_Failure            (E_UNKNOWN      | (Esub_Unknown<<8)             | (( 69)<<16))         ///< (0x0045)
#define E_CODE_BIT_LOADING_FAILURE                          (E_UNKNOWN      | (Esub_Unknown<<8)             | (( 70)<<16))         ///< (0x0046)Bit-loading failed
#define E_CODE_FAREND_CONFIGURATION_ERR_BIS                 (E_UNKNOWN      | (Esub_Unknown<<8)             | (( 71)<<16))         ///< (0x0047)
#define E_CODE_FAREND_CONFIGURATION_NOT_FEASIBLE_ERR_BIS    (E_NOTFEASIBLE  | (Esub_Unknown<<8)             | (( 72)<<16))         ///< (0x0048)
#define E_CODE_RQuiet5Tx_Bis_SignalEnd_TIMEOUT              (E_COMM         | (Esub_Unknown<<8)             | (( 73)<<16))         ///< (0x0049)Timeout waiting for the equalizers to be trained on the Rx side
//#define E_CODE_BITLOAD_ALLOCFIXED_RATE_FAIL               (E_UNKNOWN      | (Esub_Unknown<<8)             | (2<<16))          ///< (0x0002)
//#define E_CODE_BITLOAD_VERIFY_PMS_FAIL                    (E_UNKNOWN      | (Esub_Unknown<<8)             | (3<<16))          ///< (0x0003)
//#define E_CODE_BITLOAD_INVALID_NUM_LATENCY_PATHS          (E_UNKNOWN      | (Esub_Unknown<<8)             | (4<<16))          ///< (0x0004)
//#define E_CODE_BITLOAD_INVALID_NUM_BEARER_CHANNELS        (E_UNKNOWN      | (Esub_Unknown<<8)             | (5<<16))          ///< (0x0005)
//#define E_CODE_BITLOAD_INSUFFICIENT_BITS                  (E_UNKNOWN      | (Esub_Unknown<<8)             | (6<<16))          ///< (0x0006)
//#define E_CODE_BITLOAD_FIXEDRATE_NOT_CONVERGE             (E_UNKNOWN      | (Esub_Unknown<<8)             | (7<<16))          ///< (0x0007)
//#define E_CODE_BITLOAD_NOVALID_CONFIG                     (E_UNKNOWN      | (Esub_Unknown<<8)             | (8<<16))          ///< (0x0008)
//#define E_CODE_BITLOAD_LP_TOOLARGE                        (E_UNKNOWN      | (Esub_Unknown<<8)             | (9<<16))          ///< (0x0009)
//#define E_CODE_BITLOAD_NOVALID_CONFIG_ADAPTIVERATE        (E_UNKNOWN      | (Esub_Unknown<<8)             | (10<<16))         ///< (0x000a)

//==============================================================================
// Kernel Exception Codes
// *** may add new exception code here ***
//==============================================================================
//#define E_CODE_TIMER_INTERRUPT_FOREGROUND                 (E_UNKNOWN      | (Esub_Unknown<<8)             | ((201)<<16))        ///< (0x00c9)
#define E_CODE_REAL_TIME_EXCEPTION                          (E_CHIPSET      | (Esub_S_HW_Error<<8)          | ((202)<<16))        ///< (0x00ca)
#define E_CODE_QUEUE_ADD_EXCEPTION                          (E_CHIPSET      | (Esub_S_HW_Error<<8)          | ((203)<<16))        ///< (0x00cb)
#define E_CODE_QUEUE_DELETE_EXCEPTION                       (E_CHIPSET      | (Esub_S_HW_Error<<8)          | ((204)<<16))        ///< (0x00cc)
#define E_CODE_LOADFUNC_FIFO_OVERFLOW                       (E_CHIPSET      | (Esub_S_HW_Error<<8)          | ((205)<<16))        ///< (0x00cd)
#define E_CODE_WRONG_LOADING_FUNCTION_FIFO                  (E_CHIPSET      | (Esub_S_HW_Error<<8)          | ((206)<<16))        ///< (0x00ce)
#define E_CODE_TX_STATE_TIMEOUT                             (E_COMM         | (Esub_Timeout<<8)             | ((207)<<16))        ///< (0x00cf) TX state timeout
#define E_CODE_RX_STATE_TIMEOUT                             (E_COMM         | (Esub_Timeout<<8)             | ((208)<<16))        ///< (0x00d0) RX state timeout
#define E_CODE_BKGTASK_INCOMPLETE                           (E_CHIPSET      | (Esub_S_HW_Error<<8)          | ((209)<<16))        ///< (0x00d1) background task is not finished
#define E_CODE_HOSTLESS_CFG_ERROR                           (E_CONFIG       | (Esub_S_HW_Error<<8)          | ((210)<<16))        ///< (0x00d2) hostless CPE detects config/codeswap errors
#define E_CODE_AFE_LOCK_LOST                                (E_CHIPSET      | (Esub_S_HW_Error<<8)          | ((211)<<16))        ///< (0x00d3)
#define E_CODE_BKGD_FIFO_ADD_EXCEPTION                      (E_CHIPSET      | (Esub_S_HW_Error<<8)          | ((212)<<16))        ///< (0x00d4)

#define E_CODE_AFE_RC_MEAS_ERR                              (E_CHIPSET      | (Esub_S_HW_Error<<8)          | ((215)<<16))        ///< (0x00d7) AFE Rev1: RC measurement not completed
#define E_CODE_AFE_POFI_TUNE_ERR                            (E_CHIPSET      | (Esub_S_HW_Error<<8)          | ((216)<<16))        ///< (0x00d8) AFE Rev1: POFI tuning not completed
#define E_CODE_LUT_ACCESS_ERR                               (E_CHIPSET      | (Esub_Unknown<<8)             | ((217)<<16))        ///< (0x00d9) LUT access error for VDSL 6.1
#define E_CODE_XDMA_ERROR                                   (E_CHIPSET      | (Esub_S_HW_Error<<8)          | ((218)<<16))        ///< (0x00da) XMDA completed with errors
#define E_CODE_ADMA_ERROR                                   (E_CHIPSET      | (Esub_S_HW_Error<<8)          | ((219)<<16))        ///< (0x00db) XMDA completed with errors
#define E_CODE_TX_PMS_TIMEOUT                               (E_CHIPSET      | (Esub_Timeout<<8)             | ((220)<<16))        ///< (0x00dc) TX PMS (Tx Zephyr) could not complete its task within the time.
#define E_CODE_RX_PMS_TIMEOUT                               (E_CHIPSET      | (Esub_Timeout<<8)             | ((221)<<16))        ///< (0x00dd) RX PMS (Rx Zephyr) could not complete its task within the time.

#define E_CODE_ADC_TRIM_TIMEOUT                             (E_CHIPSET      | (Esub_Unknown<<8)             | ((230)<<16))        ///< (0x00e6)
#define E_CODE_AFE_EXCEPTION                                (E_CHIPSET      | (Esub_Unknown<<8)             | ((231)<<16))        ///< (0x00e7)
#define E_CODE_AFE_NOT_READY                                (E_CHIPSET      | (Esub_FWInitiatedRetrain<<8)  | ((232)<<16))        ///< (0x00e8)
#define E_CODE_GLP_EXCEPTION                                (E_CHIPSET      | (Esub_Unknown<<8)             | ((233)<<16))        ///< (0x00e9)
#define E_CODE_AFE_RC_CALIB_ERROR                           (E_CHIPSET      | (Esub_FWInitiatedRetrain<<8)  | ((234)<<16))        ///< (0x00ea)
#define E_CODE_AFE_RC_MEAS_ERROR                            (E_CHIPSET      | (Esub_FWInitiatedRetrain<<8)  | ((235)<<16))        ///< (0x00eb)
#define E_CODE_AFE_RC_CALIB_TIMEOUT                         (E_CHIPSET      | (Esub_FWInitiatedRetrain<<8)  | ((236)<<16))        ///< (0x00ec)
#define E_CODE_AFE_RC_MEAS_TIMEOUT                          (E_CHIPSET      | (Esub_FWInitiatedRetrain<<8)  | ((237)<<16))        ///< (0x00ed)

#define E_CODE_ADC_TRIM_TOP_THRESHOLD_TIMEOUT_ERROR         (E_CHIPSET      | (Esub_FWInitiatedRetrain<<8)  | ((246)<<16))        ///< (0x00f6)
#define E_CODE_ADC_TRIM_FSCALE_TIMEOUT_ERROR                (E_CHIPSET      | (Esub_FWInitiatedRetrain<<8)  | ((247)<<16))        ///< (0x00f7)
#define E_CODE_ADC_TRIM_CAL_TIMEOUT_ERROR                   (E_CHIPSET      | (Esub_FWInitiatedRetrain<<8)  | ((248)<<16))        ///< (0x00f8)
#define E_CODE_AFE_WRITE_EXCEPTION_ERROR                    (E_CHIPSET      | (Esub_FWInitiatedRetrain<<8)  | ((249)<<16))        ///< (0x00f9)
#define E_CODE_AFE_READ_EXCEPTION_ERROR                     (E_CHIPSET      | (Esub_FWInitiatedRetrain<<8)  | ((250)<<16))        ///< (0x00fa)
#define E_CODE_GLP_MASTER_DFE_NOT_READY                     (E_CHIPSET      | (Esub_FWInitiatedRetrain<<8)  | ((251)<<16))        ///< (0x00fb)
#define E_CODE_GLP_SLAVE_AFE_NOT_READY                      (E_CHIPSET      | (Esub_FWInitiatedRetrain<<8)  | ((252)<<16))        ///< (0x00fc)
/** XDSLRTFW-3766 Graceful shutdown due to unexpected value/situation which normally should have
    never occurred and which could cause indirectly issues (e.g. division by zero) */
#define E_CODE_UNEXPECTED_VALUE                             (E_UNKNOWN      | (Esub_FWInitiatedRetrain<<8)  | ((254)<<16))        ///< (0x00fe)
#define E_CODE_DEVELOPER_VALUE                              (E_UNKNOWN      | (Esub_FWInitiatedRetrain<<8)  | ((255)<<16))        ///< (0x00ff)
#define E_CODE_NOT_SUPPORTED_PORT_MODE                      (E_UNKNOWN      | (Esub_FWInitiatedRetrain<<8)  | ((256)<<16))        ///< (0x0100)


//==============================================================================
// GHS error code
// *** may add new exception code here ***
//==============================================================================
#define E_CODE_GHS_CLEARDOWN                                (E_CONFIG       | (Esub_GhsNoCommonMode<<8)     | ((300)<<16))        ///< (0x012c) Handshake terminated without a mode selection */
#define E_CODE_GHS_SILENT                                   (E_COMM         | (Esub_INIT<<8)                | ((301)<<16))        ///< (0x012d) One minute of silent requested */
#define E_CODE_GHS_NO_COMMON_MODE                           (E_COMM         | (Esub_GhsNoCommonMode<<8)     | ((302)<<16))        ///< (0x012e) no common mode found during handshake negotiation */
#define E_CODE_GHS_TIMEOUT                                  (E_COMM         | (Esub_Timeout<<8)             | ((303)<<16))        ///< (0x012f) timeout during handshake */
#define E_CODE_GHS_TONE_LOSS_OR_TIME_OUT                    (E_COMM         | (Esub_Timeout<<8)             | ((304)<<16))        ///< (0x0130) timeout or tone loss in the Rx side in ghs */
#define E_CODE_R_HS_NOT_UNDERSTOOD                          (E_COMM         | (Esub_Timeout<<8)             | ((305)<<16))        ///< (0x0131) timeout or tone loss in the Rx side in ghs */
#define E_CODE_GHS_RETRAIN                                  (E_CONFIG       | (Esub_INIT<<8)                | ((306)<<16))        ///< (0x0132) retrain due to inconsistency in GHS config */
#define E_CODE_GHS_STD_NONCOMPLIANT                         (E_CONFIG       | (Esub_INIT<<8)                | ((307)<<16))        ///< (0x0133) retrain due to inconsistency in GHS config */
#define E_CODE_GHS_TIME_OUT                                 (E_COMM         | (Esub_Timeout<<8)             | ((308)<<16))        ///< (0x0134) TX state timeout
#define E_CODE_GHS_FE_NOT_BONDABLE                          (E_COMM         | (Esub_Timeout<<8)             | ((309)<<16))        ///< (0x0135) FE expected to be bonding capable but it's not
#define E_CODE_GHS_NOT_SUPPORTED_IN_DUALPORT                (E_COMM         | (Esub_S_PORT_MODE<<8)         | ((310)<<16))        ///< (0x0136) dual port VR9 cannot support non-8x profiles */
#define E_CODE_GHS_CO_NOT_BONDABLE                          (E_COMM         | (Esub_S_PORT_MODE<<8)         | ((311)<<16))        ///< (0x0137) CO doesn't need bonding; CPE to switch to single port mode */
#define E_CODE_GHS_M_NAK_EF_NearEnd                         (E_COMM         | (Esub_FWInitiatedRetrain<<8)  | ((312)<<16))        ///< (0x0138) Unable to decode CO's Message ,so CPE send back NAK_EF*/
#define E_CODE_GHS_M_NAK_EF_FarEnd                          (E_COMM         | (Esub_FWInitiatedRetrain<<8)  | ((313)<<16))        ///< (0x0139) Unable to decode CO's Message ,so CPE send back NAK_CD*/
#define E_CODE_GHS_XTALK_LINK                               (E_COMM         | (Esub_FWInitiatedRetrain<<8)  | ((314)<<16))        ///< (0x013a)
#define E_CODE_GHS_S_XDSL_MODE                              (E_COMM         | (Esub_S_XDSL_MODE<<8)         | ((315)<<16))        ///< (0x013b) no common mode found during handshake, mode switch required */
#define E_CODE_GHS_FWInitiatedRetrain                       (E_COMM         | (Esub_FWInitiatedRetrain<<8)  | ((316)<<16))        ///< (0x013c) placehold for fw initiated retrain */
#define E_CODE_VR9_NO_VDSL_MODE                             (E_CHIPSET      | (Esub_S_XDSL_MODE << 8)       | ((317)<<16))        ///< (0x013d)
#define E_CODE_GHS_T1413_MODE                               (E_CHIPSET      | (Esub_S_T1413_MODE << 8)      | ((318)<<16))        ///< (0x013e)

//==============================================================================
// VDSL1 (E_FAIL_1 | (G993.1 << 16)) Exception Codes (E_FAIL_1 | (starts from 400 << 16))
// *** add common VDSL exception code & VDSL1-specific exception codes here ***
//==============================================================================
#define E_CODE_BITLOAD_ADAPTIVE_RATE_FAIL                   (E_NOTFEASIBLE  | (Esub_RateDS<<8)              | ((400)<<16))        ///< (0x0190)
#define E_CODE_BITLOAD_FIXED_RATE_FAIL                      (E_NOTFEASIBLE  | (Esub_RateDS<<8)              | ((401)<<16))        ///< (0x0191)
#define E_CODE_BITLOAD_EXPLICIT_RATE_FAIL                   (E_NOTFEASIBLE  | (Esub_RateDS<<8)              | ((402)<<16))        ///< (0x0192)
#define E_CODE_BITLOAD_CONTRACT_GEN_FAIL                    (E_NOTFEASIBLE  | (Esub_RateDS<<8)              | ((403)<<16))        ///< (0x0193)
#define E_CODE_TONE_ORDERING_ERROR                          (E_NOTFEASIBLE  | (Esub_INIT<<8)                | ((404)<<16))        ///< (0x0194)
#define E_CODE_SYNCHRO_DETECT_TIMEOUT_ERROR                 (E_COMM         | (Esub_Timeout<<8)             | ((405)<<16))        ///< (0x0195)
#define E_CODE_MODEM_FAIL                                   (E_UNKNOWN      | (Esub_INIT<<8)                | ((406)<<16))        ///< (0x0196) Modem failure
#define E_CODE_MODEM_RESET                                  (E_OK           | (Esub_INIT<<8)                | ((407)<<16))        ///< (0x0197) Modem reset
#define E_CODE_SHOWTIME_NE                                  (E_UNKNOWN      | (Esub_Unknown<<8)             | ((408)<<16))        ///< (0x0198) Showtime NE failure
#define E_CODE_SHOWTIME_FE                                  (E_UNKNOWN      | (Esub_Unknown<<8)             | ((409)<<16))        ///< (0x0199) Showtime FE failure
#define E_CODE_TX_HDLC_MSG_SEGMENTS                         (E_COMM         | (Esub_Timeout<<8)             | ((410)<<16))        ///< (0x019a) the no. of TX HDLC message segments exceeds the limit
#define E_CODE_ZERO_TONE_CLUSTERS_FRAMEALIGNMENTHANDLER     (E_COMM         | (Esub_INIT<<8)                | ((411)<<16))        ///< (0x019b) No tone cluster can be found for message decoding
#define E_CODE_MESSAGE_DECODE_TIMEOUT_ERROR                 (E_COMM         | (Esub_Timeout<<8)             | ((412)<<16))        ///< (0x019c)
#define E_CODE_US_DS_BAND_OVERLAP                           (E_NOTFEASIBLE  | (Esub_Unknown<<8)             | ((413)<<16))        ///< (0x019d)
#define E_CODE_QUIET_PSD_COMPUTE_FAIL                       (E_COMM         | (Esub_Timeout<<8)             | ((414)<<16))        ///< (0x019e)
#define E_CODE_BITLOAD_INIT_FAIL                            (E_NOTFEASIBLE  | (Esub_INIT<<8)                | ((415)<<16))        ///< (0x019f)
#define E_CODE_PILOT_TONE_SELECTION_FAIL                    (E_NOTFEASIBLE  | (Esub_INIT<<8)                | ((416)<<16))        ///< (0x01a0)
#define E_CODE_KL0_THRESHOLD_FAIL                           (E_NOTFEASIBLE  | (Esub_INIT<<8)                | ((417)<<16))        ///< (0x01a1)
#define E_CODE_ENABLE_DOUBLE_TRAIN                          (E_COMM         | (Esub_HwModeChange<<8)        | ((418)<<16))        ///< (0x01a2) nable double-train
#define E_CODE_ADD_PSD_BRKPT_FAIL                           (E_COMM         | (Esub_INIT<<8)                | ((419)<<16))        ///< (0x01a3) Error occurs when adding PSD breakpoints
#define E_CODE_G997_1SEC_TASK_FAIL                          (E_COMM         | (Esub_Timeout<<8)             | ((420)<<16))        ///< (0x01a4) Error occurs if 1 sec task is not finished in time
#define E_CODE_ILV_INIT_FAIL                                (E_CHIPSET      | (Esub_S_HW_Error<<8)          | ((421)<<16))        ///< (0x01a5) Error occurs if ILV FIFO base, RD/WR pointer initialization fail
#define E_CODE_DILV_INIT_FAIL                               (E_CHIPSET      | (Esub_S_HW_Error<<8)          | ((422)<<16))        ///< (0x01a6) Error occurs if DILV FIFO base, RD/WR pointer initialization fail
#define E_CODE_UPBO_CHECK_FAIL                              (E_NOTFEASIBLE  | (Esub_UpboCheck<<8)           | ((423)<<16))        ///< (0x01a7) UPBO compliance check failed
#define E_CODE_ZERO_TONE_CLUSTERS_R_O_P_TRAIN1              (E_COMM         | (Esub_INIT<<8)                | ((424)<<16))        ///< (0x01a8) No tone cluster can be found for message decoding
#define E_CODE_ZERO_TONE_CLUSTERS_R_O_SIGNATURE             (E_COMM         | (Esub_INIT<<8)                | ((425)<<16))        ///< (0x01a9) No tone cluster can be found for message decoding
#define E_CODE_ZERO_TONE_CLUSTERS_R_O_TRAIN                 (E_COMM         | (Esub_INIT<<8)                | ((426)<<16))        ///< (0x01aa) No tone cluster can be found for message Decoding
#define E_CODE_ZERO_TONE_CLUSTERS_MEDLEY                    (E_COMM         | (Esub_INIT<<8)                | ((427)<<16))        ///< (0x01ab) No tone cluster can be found for message Decoding




//==============================================================================
// VDSL2 (E_FAIL_1 | (G993.2 << 16)) Exception Codes (E_FAIL_1 | (starts from 500 << 16))
// *** add G993.2 only exception code here ***
//==============================================================================
#define E_CODE_TX_DISCOVERY2_FAIL                           (E_COMM         | (Esub_Timeout<<8)             | ((500)<<16))      ///< (0x01f4) Discovery2 message has been sent 3 times, but not get response
#define E_CODE_RX_R_UPDATE_FAIL                             (E_COMMCRC      | (Esub_INIT<<8)                | ((501)<<16))      ///< (0x01f5) fail to receive R-UPDATE
#define E_CODE_RX_O_ACK_FAIL                                (E_COMMCRC      | (Esub_INIT<<8)                | ((502)<<16))      ///< (0x01f6) fail to receive O-ACK
#define E_CODE_RX_O_UPDATE_FAIL                             (E_COMMCRC      | (Esub_INIT<<8)                | ((503)<<16))      ///< (0x01f7) fail to receive O-UPDATE
#define E_CODE_RX_R_PRM_FAIL                                (E_COMMCRC      | (Esub_INIT<<8)                | ((504)<<16))      ///< (0x01f8) fail to receive R-PRM
#define E_CODE_RX_O_PRM_FAIL                                (E_COMMCRC      | (Esub_INIT<<8)                | ((505)<<16))      ///< (0x01f9) fail to receive O-PRM
#define E_CODE_RX_R_TA_UPDATE_FAIL                          (E_COMMCRC      | (Esub_INIT<<8)                | ((506)<<16))      ///< (0x01fa) fail to receive R-TA-UPDATE
#define E_CODE_RX_R_ACK_FAIL                                (E_COMMCRC      | (Esub_INIT<<8)                | ((507)<<16))      ///< (0x01fb) fail to receive R-ACK
#define E_CODE_TX_TRAIN2_FAIL                               (E_COMM         | (Esub_Unknown<<8)             | ((508)<<16))      ///< (0x01fc) TRAIN2 message has been sent 3 times, but not get response
#define E_CODE_RX_O_TA_UPDATE_FAIL                          (E_COMMCRC      | (Esub_INIT<<8)                | ((509)<<16))      ///< (0x01fd) fail to receive O_TA_UPDATE
#define E_CODE_UNEXPECTED_TX_TRAIN2_MSG                     (E_COMM         | (Esub_INIT<<8)                | ((510)<<16))      ///< (0x01fe) unexpected Train2 TX message
#define E_CODE_TX_MEDLEY_FAIL                               (E_COMM         | (Esub_INIT<<8)                | ((511)<<16))      ///< (0x01ff) fail to transmit medley state message
#define E_CODE_RX_R_TPS_ACK_FAIL                            (E_COMMCRC      | (Esub_INIT<<8)                | ((512)<<16))      ///< (0x0200) fail to receive R-TPS-ACK
#define E_CODE_RX_R_PMS_FAIL                                (E_COMMCRC      | (Esub_INIT<<8)                | ((513)<<16))      ///< (0x0201) fail to receive R-PMS
#define E_CODE_RX_R_PMD_FAIL                                (E_COMMCRC      | (Esub_INIT<<8)                | ((514)<<16))      ///< (0x0202) fail to receive R-PMD
#define E_CODE_RX_R_MSG2_FAIL                               (E_COMMCRC      | (Esub_INIT<<8)                | ((515)<<16))      ///< (0x0203) fail to receive R-MSG2
#define E_CODE_RX_O_MSG1_FAIL                               (E_COMMCRC      | (Esub_INIT<<8)                | ((516)<<16))      ///< (0x0204) fail to receive O-MSG1
#define E_CODE_RX_O_PMS_FAIL                                (E_COMMCRC      | (Esub_INIT<<8)                | ((517)<<16))      ///< (0x0205) fail to receive O-PMS
#define E_CODE_RX_O_PMD_FAIL                                (E_COMMCRC      | (Esub_INIT<<8)                | ((518)<<16))      ///< (0x0206) fail to receive O-PMD
#define E_CODE_RX_O_TPS_FAIL                                (E_COMMCRC      | (Esub_INIT<<8)                | ((519)<<16))      ///< (0x0207) fail to receive O-TPS
#define E_CODE_FORM_TPS_FAIL                                (E_COMM         | (Esub_INIT<<8)                | ((520)<<16))      ///< (0x0208) fail to find common TPS parameters
#define E_CODE_FORM_PMS_FAIL                                (E_COMM         | (Esub_INIT<<8)                | ((521)<<16))      ///< (0x0209) fail to find common PMS parameters
#define E_CODE_PILOTTONE_BITLOADED                          (E_COMM         | (Esub_INIT<<8)                | ((522)<<16))      ///< (0x020a) fail because of non-zero constellation for pilot in BAT
#define E_CODE_RX_SYNCHRO1_DETECT_FAIL                      (E_COMM         | (Esub_Timeout<<8)             | ((523)<<16))      ///< (0x020b) fail to detect SYNCHRO1 (for both CO and RT)
#define E_CODE_RX_SYNCHRO2_DETECT_FAIL                      (E_COMM         | (Esub_Timeout<<8)             | ((524)<<16))      ///< (0x020c) fail to detect SYNCHRO2 (for both CO and RT)
#define E_CODE_RX_SYNCHRO3_DETECT_FAIL                      (E_COMM         | (Esub_Timeout<<8)             | ((525)<<16))      ///< (0x020d) fail to detect SYNCHRO3 (for both CO and RT)
#define E_CODE_RX_SYNCHRO4_DETECT_FAIL                      (E_COMM         | (Esub_Timeout<<8)             | ((526)<<16))      ///< (0x020e) fail to detect SYNCHRO4 (for both CO and RT)
#define E_CODE_RX_SYNCHRO5_DETECT_FAIL                      (E_COMM         | (Esub_Timeout<<8)             | ((527)<<16))      ///< (0x020f) fail to detect SYNCHRO5 (for both CO and RT)
#define E_CODE_RX_SYNCHRO6_DETECT_FAIL                      (E_COMM         | (Esub_Timeout<<8)             | ((528)<<16))      ///< (0x0210) fail to detect SYNCHRO6 (for both CO and RT)
#define E_CODE_UNEXPECTED_TX_TRAIN3_MSG                     (E_COMM         | (Esub_INIT<<8)                | ((529)<<16))      ///< (0x0211) unexpected TX message in TX train3 state
#define E_CODE_TX_TRAIN3_FAIL                               (E_COMM         | (Esub_INIT<<8)                | ((530)<<16))      ///< (0x0212) failed at TX_TRAIN3
#define E_CODE_RX_R_MDG_LD_FAIL                             (E_COMMCRC      | (Esub_INIT<<8)                | ((531)<<16))      ///< (0x0213) fail to receive R-MSG-LD
#define E_CODE_RX_SYNCHRO7_DETECT_FAIL                      (E_COMM         | (Esub_Timeout<<8)             | ((532)<<16))      ///< (0x0214) fail to detect SYNCHRO7 (for both CO and RT)
#define E_CODE_QLN_G_CONVERSION                             (E_COMM         | (Esub_INIT<<8)                | ((533)<<16))      ///< (0x0215) G for QLN is incorrect
#define E_CODE_HLOG_G_CONVERSION                            (E_COMM         | (Esub_INIT<<8)                | ((534)<<16))      ///< (0x0216) G for HLOG is incorrect
#define E_CODE_HLIN_G_CONVERSION                            (E_COMM         | (Esub_INIT<<8)                | ((535)<<16))      ///< (0x0217) G for HLIN is incorrect
#define E_CODE_RX_MEDLEY_MSG_TIMEOUT                        (E_COMM         | (Esub_Timeout<<8)             | ((536)<<16))      ///< (0x0218) fail to receive Medley state message within timeout
#define E_CODE_INVALID_FE_IDFT_SIZE                         (E_COMM         | (Esub_INIT<<8)                | ((537)<<16))      ///< (0x0219) remote modem sends a wrong IDFT size
#define E_CODE_INVALID_FE_CS_SIZE                           (E_COMM         | (Esub_INIT<<8)                | ((538)<<16))      ///< (0x021a) remote modem sends a wrong CP or beta size
#define E_CODE_NO_TX_BAND                                   (E_COMM         | (Esub_Unknown<<8)             | ((539)<<16))      ///< (0x021b) no TX band available
#define E_CODE_NO_RX_BAND                                   (E_COMM         | (Esub_Unknown<<8)             | ((540)<<16))      ///< (0x021c) no RX band available
#define E_CODE_PERIODIC_PROC_TIMEOUT                        (E_COMM         | (Esub_Timeout<<8)             | ((541)<<16))      ///< (0x021d) proces during periodic state took too long
#define E_CODE_RX_DEC_TRAIN_TIMEOUT                         (E_COMM         | (Esub_Timeout<<8)             | ((542)<<16))      ///< (0x021e) entire RX DEC train is too long
#define E_CODE_RX_DEC_PERIOD_TIMEOUT                        (E_COMM         | (Esub_Timeout<<8)             | ((543)<<16))      ///< (0x021f) one period of DEC train is too long
#define E_CODE_TX_DEC_TRAIN_TIMEOUT                         (E_COMM         | (Esub_Timeout<<8)             | ((544)<<16))      ///< (0x0220) entire TX DEC train is too long
#define E_CODE_O_R_P_TEQ_RX_OVERRUN                         (E_COMM         | (Esub_Timeout<<8)             | ((545)<<16))      ///< (0x0221) O_R_P_TEQ_RX state is too long to finish
#define E_CODE_WRONG_INLV_BLOCK_SIZE                        (E_COMM         | (Esub_INIT<<8)                | ((546)<<16))      ///< (0x0222) Nfecp/Ip is not integer
#define E_CODE_CSDIFF_ERR1                                  (E_COMM         | (Esub_INIT<<8)                | ((547)<<16))      ///< (0x0223)
#define E_CODE_CSDIFF_ERR2                                  (E_COMM         | (Esub_INIT<<8)                | ((548)<<16))      ///< (0x0224)
#define E_CODE_TX_VECTORING_TIMEOUT                         (E_COMM         | (Esub_Unknown<<8)             | ((549)<<16))      ///< (0x0225) Global Timeout in Vectoring Tx Training State Machine (0x225)
#define E_CODE_RX_VECTORING_TIMEOUT                         (E_COMM         | (Esub_Unknown<<8)             | ((550)<<16))      ///< (0x0226) Global Timeout in Vectoring Rx Training State Machine (0x226)
#define E_CODE_RX_LOW_PILOT_TONE_POWER                      (E_COMM         | (Esub_S_FAST_LOS<<8)          | ((551)<<16))      ///< (0x0227) Pilot tone power is not good enough for some symbols  (0x227)
#define E_CODE_TC_NOT_SUPPORTED                             (E_CONFIG       | (Esub_S_TC_Mode<<8)           | ((552)<<16))      ///< (0x0228) TC Not If Not Supported By DSLAM
#define E_CODE_PPE_MISS_MATCH                               (E_CONFIG       | (Esub_S_PP_DRIVER<<8)         | ((553)<<16))      ///< (0x0229) PPE F/W Miss Match, cannot enter Showtime
#define E_CODE_RX_OPVECTOR_SIGNAL_LOSS                      (E_COMM         | (Esub_INIT<<8)                | ((554)<<16))      ///< (0x022a)
#define E_CODE_RXTX_SYNCSYM_DELTA                           (E_COMM         | (Esub_Unknown<<8)             | ((555)<<16))      ///< (0x022b)
#define E_CODE_RETX_QTX_OUT_OF_RANGE                        (E_COMM         | (Esub_Unknown<<8)             | ((556)<<16))      ///< (0x022c) The QTX value sent by CO is out of range [1, 63]
#define E_CODE_RETX_LOOKBACK_OUT_OF_RANGE                   (E_COMM         | (Esub_Unknown<<8)             | ((557)<<16))      ///< (0x023d) The lookback value sent by CO is out of range.
#define E_CODE_RX_VECTORING_XTALK_LINK                      (E_COMM         | (Esub_FWInitiatedRetrain<<8)  | ((558)<<16))      ///< (0x023e)
// XDSLRTFW-405: BugFix_DS_VDSL2_ALL_Incorrect_Error_Code_On_Showtime_Fail (Start)
// New exception codes. Refer to 'STAT 5' in Msg catalog/Spec Rev 1.8 for new 'System Error Code'
// and 'System Sub Error Code'
#define E_CODE_SHOWTIME_NE_LOS                              (E_SHOWTIME_NE  | (Esub_S_LOS << 8)             | ((560) << 16))    ///< (0x0230)
#define E_CODE_SHOWTIME_NE_LOF                              (E_SHOWTIME_NE  | (Esub_S_LOF << 8)             | ((561) << 16))    ///< (0x0231)
#define E_CODE_SHOWTIME_NE_LPR                              (E_SHOWTIME_NE  | (Esub_S_LPR << 8)             | ((562) << 16))    ///< (0x0232)
#define E_CODE_SHOWTIME_NE_LOM                              (E_SHOWTIME_NE  | (Esub_S_LOM << 8)             | ((563) << 16))    ///< (0x0233)
#define E_CODE_SHOWTIME_NE_ESE                              (E_SHOWTIME_NE  | (Esub_S_ESE << 8)             | ((564) << 16))    ///< (0x0234)
#define E_CODE_SHOWTIME_NE_OOS0                             (E_SHOWTIME_NE  | (Esub_S_OOS0 << 8)            | ((565) << 16))    ///< (0x0235)
#define E_CODE_SHOWTIME_NE_LCD_BC0                          (E_SHOWTIME_NE  | (Esub_S_LCD0 << 8)            | ((566) << 16))    ///< (0x0236)
#define E_CODE_SHOWTIME_NE_NCD_BC0                          (E_SHOWTIME_NE  | (Esub_S_NCD0 << 8)            | ((567) << 16))    ///< (0x0237)
#define E_CODE_SHOWTIME_NE_Retrain                          (E_SHOWTIME_NE  | (Esub_FWInitiatedRetrain << 8)| ((568) << 16))    ///< (0x0238)
#define E_CODE_SHOWTIME_FE_LOS                              (E_SHOWTIME_FE  | (Esub_S_LOS << 8)             | ((570) << 16))    ///< (0x023a)
#define E_CODE_SHOWTIME_FE_LOF                              (E_SHOWTIME_FE  | (Esub_S_LOF << 8)             | ((571) << 16))    ///< (0x023b)
#define E_CODE_SHOWTIME_FE_LPR                              (E_SHOWTIME_FE  | (Esub_S_LPR << 8)             | ((572) << 16))    ///< (0x023c)
#define E_CODE_SHOWTIME_FE_LOM                              (E_SHOWTIME_FE  | (Esub_S_LOM << 8)             | ((573) << 16))    ///< (0x023d)
#define E_CODE_SHOWTIME_FE_ESE                              (E_SHOWTIME_FE  | (Esub_S_ESE << 8)             | ((574) << 16))    ///< (0x023e)
#define E_CODE_SHOWTIME_FE_OOS0                             (E_SHOWTIME_FE  | (Esub_S_OOS0 << 8)            | ((575) << 16))    ///< (0x023f)
#define E_CODE_SHOWTIME_FE_LCD_BC0                          (E_SHOWTIME_FE  | (Esub_S_LCD0 << 8)            | ((576) << 16))    ///< (0x0240)
#define E_CODE_SHOWTIME_FE_NCD_BC0                          (E_SHOWTIME_FE  | (Esub_S_NCD0 << 8)            | ((577) << 16))    ///< (0x0241)
#define E_CODE_SHOWTIME_FE_Retrain                          (E_SHOWTIME_FE  | (Esub_FWInitiatedRetrain << 8)| ((578) << 16))    ///< (0x0242)
#define E_CODE_SHOWTIME_NE_ESX                              (E_SHOWTIME_NE  | (Esub_S_ESX << 8)             | ((579) << 16))    ///< (0x0243)
#define E_CODE_SHOWTIME_NE_SESX                             (E_SHOWTIME_NE  | (Esub_S_SESX << 8)            | ((580) << 16))    ///< (0x0244)
#define E_CODE_RETX_FRAMING_TYPE_NOT_SUPPORTED              (E_COMM         | (Esub_Unknown<<8)             | ((581) << 16))    ///< (0x0245) CPE cannot support the framing type requested.
#define E_CODE_CMV_CONTROLLED_LINK_DROP_TX_GAIN_ZERO        (E_COMM         | (Esub_FWInitiatedRetrain<<8)  | ((582) << 16))    ///< (0x0246)
#define E_CODE_CMV_CONTROLLED_LINK_DROP_RX_GAIN_ZERO        (E_COMM         | (Esub_FWInitiatedRetrain<<8)  | ((583) << 16))    ///< (0x0247)
#define E_CODE_G_FAST_SWITCH                                (E_COMM         | (Esub_G_FAST_MODE<<8)         | ((584) << 16))    ///< (0x0248) XDSLRTFW-2298 (Start_End)
#define E_CODE_BAR_NOT_CONFIGURED                           (E_CONFIG       | (Esub_S_HW_Error<<8)          | ((585) << 16))    ///< (0x0249) BAR registers (e.g. BAR-15,16) not configured  //XDSLRTFW-3255 (Start_End)
#define E_CODE_ERB_BAR_NOT_CONFIGURED                       (E_CONFIG       | (Esub_S_PP_DRIVER<<8)         | ((586) << 16))    ///< (0x024a) ERB related BAR registers (BAR 14 and BAR 17) are not configured correctly
#define E_CODE_RETX_API_INCORRECT_CONFIG                    (E_CONFIG       | (Esub_S_HW_Error<<8)          | ((587) << 16))    ///< (0x024b) API configuration for Retx support is incorrect  XDSLRTFW-2998 (Start_End)
#define E_CODE_RX_LOW_PILOT_TONE_POWER_R_O_TRAIN_RX         (E_COMM         | (Esub_S_FAST_LOS<<8)          | ((589) << 16))    ///< (0x024d) Pilot tone power is not good enough for some symbols  (0x227)
#define E_CODE_RX_LOW_PILOT_TONE_POWERR_O_SIGNATURE_RX      (E_COMM         | (Esub_S_FAST_LOS<<8)          | ((590) << 16))    ///< (0x024e) Pilot tone power is not good enough for some symbols  (0x227)
#define E_CODE_TX_EXTERNAL_PSD_COMPENSATIOM_CONFIGURATION   (E_CONFIG       | (Esub_S_PSD_CALIBRATION << 8) | ((591) << 16))    ///< (0x024f)
#define E_CODE_RX_EXTERNAL_PSD_COMPENSATIOM_CONFIGURATION   (E_CONFIG       | (Esub_S_PSD_CALIBRATION << 8) | ((592) << 16))    ///< (0x0250)
#define E_CODE_FORCE_US0_SETTINGS                           (E_COMM         | (Esub_FWInitiatedRetrain<<8)  | ((593) << 16))    ///< (0x0251)
#define E_CODE_ADMA_NOT_FINISHED_CASCADED_MODE              (E_SHOWTIME_NE  | (Esub_Unknown<<8)             | ((594) << 16))    ///< (0x0252)
#define E_CODE_ADMA_NOT_FINISHED_TS_MODE                    (E_SHOWTIME_NE  | (Esub_Unknown<<8)             | ((595) << 16))    ///< (0x0253)
#define E_CODE_ADMA_RETX_INVALID_ADDRESS                    (E_SHOWTIME_NE  | (Esub_Unknown<<8)             | ((596) << 16))    ///< (0x0254)
#define E_CODE_QRX_BUFFER_NOT_AVAILABLE                     (E_SHOWTIME_NE  | (Esub_Unknown<<8)             | ((597) << 16))    ///< (0x0255)
#define E_CODE_INVALID_NUM_OF_DTU_US                        (E_COMM         | (Esub_Unknown<<8)             | ((598) << 16))    ///< (0x0256)
#define E_CODE_RETX_RP_OUT_OF_RANGE                         (E_COMM         | (Esub_Unknown<<8)             | ((599) << 16))    ///< (0x0257)
#define E_CODE_RETX_V_OUT_OF_RANGE                          (E_COMM         | (Esub_Unknown<<8)             | ((600) << 16))    ///< (0x0258)
#define E_CODE_RETX_BP_OUT_OF_RANGE                         (E_COMM         | (Esub_Unknown<<8)             | ((601) << 16))    ///< (0x0259)
#define E_CODE_RETX_MP_OUT_OF_RANGE                         (E_COMM         | (Esub_Unknown<<8)             | ((602) << 16))    ///< (0x025a)
#define E_CODE_RETX_NFEC_OUT_OF_RANGE                       (E_COMM         | (Esub_Unknown<<8)             | ((603) << 16))    ///< (0x025b)
#define E_CODE_US_iDTU_SIZE_EXCEED_ESTIMATED_MAX_iDTU_SIZE  (E_COMM         | (Esub_Unknown<<8)             | ((604) << 16))    ///< (0x025c) XDSLRTFW-3322
#define E_CODE_ERB_DESCRIPTOR_OWNER_BIT                     (E_CONFIG       | (Esub_S_ERB_INIT<<8)          | ((605) << 16))    ///< (0x025d) //XDSLRTFW-3454: If any of the ERB Descriptor Owner bit not cleared by PPE at the linkstart
#define E_CODE_SWITCH_SINGLE_PORT_MODE_FW                   (E_COMM         | (Esub_Unknown<<8)             | ((606) << 16))    ///< (0x025e) XDSLRTFW-3447: Used as "605" in R5
#define E_CODE_ERB_DESCRIPTOR_NUMBER                        (E_COMM         | (Esub_S_ERB_INIT<<8)          | ((607) << 16))    ///< (0x025f) If the ERB descriptors are more than 9
#define E_CODE_PPE_CLOCK_INCORRECT                          (E_CONFIG       | (Esub_Unknown<<8)             | ((608) << 16))    ///< (0x0260) XDSLRTFW-3565 (Start_End)
#define E_CODE_FORCED_FAIL_AFTER_FRAMINIG_GENERATION        (E_COMM         | (Esub_Unknown<<8)             | ((609) << 16))    ///< (0x0261) //XDSLRTFW-3554: DS datarate exceeds configured max
#define E_CODE_INVALID_CO_CONFIGURATION_MAXETRMAXNDR        (E_COMM         | (Esub_RateDS<<8)              | ((610) << 16))    ///< (0x0262) XDSLRTFW-3677 (Start_End)
#define E_CODE_MAILBOX_BUSY                                 (E_COMM         | (Esub_S_HW_Error<<8)          | ((611) << 16))    ///< (0x0263) XDSLRTFW-3377 (Start_End)
#define E_CODE_ERB_ENCAPSULATION_NOT_SUPPORTED              (E_COMM         | (Esub_Unknown<<8)             | ((612) << 16))    ///< (0x0264) ERB L2 encapsulation is not requested
#define E_CODE_INVALID_SOS_MULTISTEP_CONFIGURATION          (E_COMM         | (Esub_Unknown<<8)             | ((613) << 16))    ///< (0x0265) XDSLRTFW-3847 (Start_End)
#define E_CODE_INVALID_SOS_TRIGGER_CRITERIA                 (E_COMM         | (Esub_Unknown<<8)             | ((614) << 16))    ///< (0x0266) XDSLRTFW-3847 (Start_End)
#define E_CODE_INVALID_SOS_ROC_RETX_API_CONFIGURATION       (E_NOTFEASIBLE  | (Esub_Unknown<<8)             | ((615) << 16))    ///< (0x0267) XDSLRTFW-3848 (Start_End)
#define E_CODE_NOT_USED                                     (E_NOTFEASIBLE  | (Esub_Unknown<<8)             | ((616) << 16))    ///< (0x0268) can be used for an exception
//XDSLRTFW-3901 (START)
//Exception code for cascaded mode FW tasks
#define E_CODE_RX_TC_CYCLES_TIMEOUT                         (E_SHOWTIME_NE  | (Esub_Unknown<<8)             | ((617) << 16))    ///< (0x0269)
#define E_CODE_TX_TC_CYCLES_TIMEOUT                         (E_SHOWTIME_NE  | (Esub_Unknown<<8)             | ((618) << 16))    ///< (0x026A)
#define E_CODE_ST_RX_NTC_CYCLES_TIMEOUT                     (E_SHOWTIME_NE  | (Esub_Unknown<<8)             | ((619) << 16))    ///< (0x026B)
#define E_CODE_TX_NTC_CYCLES_TIMEOUT                        (E_SHOWTIME_NE  | (Esub_Unknown<<8)             | ((620) << 16))    ///< (0x026C)
//XDSLRTFW-3901 (END)
#define E_CODE_BG_TASK_TOO_LONG                             (E_COMM         | (Esub_Timeout<<8)             | ((621) << 16))    ///< (0x026D) XDSLRTFW-3834 (Start_End)
#define E_CODE_MAX_OCCUPANCY_BG_QUEUE                       (E_COMM         | (Esub_Timeout<<8)             | ((622) << 16))    ///< (0x026E) XDSLRTFW-3834 (Start_End)
#define E_CODE_ERB_CO_CONFIGURATION_NOT_SUPPORTED           (E_COMM         | (Esub_Unknown<<8)             | ((623) << 16))    ///< (0x026F) XDSLRTFW-3882 (Start_End)
#define E_CODE_TIMESLOT_TC_CYCLES_TIMEOUT                   (E_SHOWTIME_NE  | (Esub_Unknown<<8)             | ((624) << 16))    ///< (0x0270)
#define E_CODE_TIMESLOT_NTC_CYCLES_TIMEOUT                  (E_SHOWTIME_NE  | (Esub_Unknown<<8)             | ((625) << 16))    ///< (0x0271)
#define E_CODE_MODEM_FSM_EVENT_NOT_ALLOWED_CONFIGURATION    (E_CONFIG       | (Esub_S_AUTO_MSG<<8)          | ((626) << 16))    ///< (0x0272) XDSLRTFW-4050
#define E_CODE_MODEM_FSM_EVENT_CONFIGURATION_ERROR          (E_CONFIG       | (Esub_S_AUTO_MSG<<8)          | ((627) << 16))    ///< (0x0273) XDSLRTFW-4050
#define E_CODE_CO_CONFIG_ERROR                              (E_CONFIG       | (Esub_Unknown<<8)             | ((628) << 16))    ///< (0x0274)
#define E_CODE_CO_CONFIG_NOT_FEASIBLE                       (E_CONFIG       | (Esub_Unknown<<8)             | ((629) << 16))    ///< (0x0275)



#define E_CODE_L3_ORDERLY_SHUTDOWN                          (E_OK           | (Esub_S_INTENDED_LOCAL_SHUTDOWN<<8) | (65535<<16)) //< (0xFFFF) L3 orderly shutdown //XDSLRTFW-710 VR9_VRX318_PDBRAM_Handover_OrderlyShutDown
#define E_CODE_ORDERLY_SHUTDOWN                             (E_OK           | (Esub_S_INTENDED_LOCAL_SHUTDOWN<<8) | (65535<<16)) //< (0xFFFF) Orderly shutdown    //XDSLRTFW-710 VR9_VRX318_PDBRAM_Handover_OrderlyShutDown

// VDSL Bitswap Error Codes
// JBK - ??? this will be moved out of this file later
// since these are not used to set gt_FailStateInfo.us_ExceptionCode
#define E_CODE_BITSWAP_REQ_INVALID_COMMAND                  (220)                           ///< (0x00dc)Invalid BS command
#define E_CODE_BITSWAP_REQ_TOO_SOON                         (221)                           ///< (0x00dd) New request before previous req is finished
#define E_CODE_BITSWAP_REQ_INVALID_TONE                     (222)                           ///< (0x00de) Invalid requested BS tone.
#define E_CODE_BITSWAP_REQ_INVALID_BIT_INC                  (223)                           ///< (0x00df) Invalid requested BS constellation increment.
#define E_CODE_BITSWAP_REQ_INVALID_BIT_DEC                  (224)                           ///< (0x00e0) Invalid requested BS constellation decrement.
#define E_CODE_BITSWAP_REQ_INVALID_BIT_SUM                  (225)                           ///< (0x00e1) Invalid requested BS constellation sum.
#define E_CODE_BITSWAP_REQ_TIMEOUT                          (226)                           ///< (0x00e2) BS request timeout (no ACK received back).
#define E_CODE_BITSWAP_UTC_RECEIVED                         (227)                           ///< (0x00e3) Received UTC.
#define E_CODE_BITSWAP_RECEIVED_MSG_CORRUPT                 (228)                           ///< (0x00e4) Bitswap VOC msg doesn't match 3 out of 5.

//Message decoding error codes bit
// JBK - ??? this will be moved out of this file later
// since these are not used to set gt_FailStateInfo.us_ExceptionCode
//=================================================================================================
//Message decoding error codes bit
//================================================================================================
#define E_CODE_MSG_NO_ERROR                                 (0)

#define E_CODE_MSG_START                                    (1)
#define E_CODE_MSG_IDX_ERROR                                (E_CODE_MSG_START+0)            //Message index is not expected
#define E_CODE_MSG_SEG_IDX_ERROR                            (E_CODE_MSG_START+1)            //Segment index is wrong
#define E_CODE_MSG_CODE_ERROR                               (E_CODE_MSG_START+2)            //Message code is not expected
#define E_CODE_MSG_FCS_ERROR                                (E_CODE_MSG_START+3)            //FCS error
#define E_CODE_MSG_RR_ERROR                                 (E_CODE_MSG_START+4)            //REPEAT-REQUEST error
#define E_CODE_MSG_RX_SEG_LIMIT                             (E_CODE_MSG_START+5)            //the no. of RX segments is greater than what can be handled

#define E_CODE_O_SIGNATURE_ERROR                            (E_CODE_MSG_START+10)           //Message cannot be understand
#define E_CODE_O_UPDATE_ERROR                               (E_CODE_MSG_START+11)           //error in interpreting O_UPDATE
#define E_CODE_O_MSG1_ERROR                                 (E_CODE_MSG_START+12)           //error in interpreting O_MSG1
#define E_CODE_O_MSG2_ERROR                                 (E_CODE_MSG_START+13)           //error in interpreting O_MSG2
#define E_CODE_O_CONTRACT_ERROR                             (E_CODE_MSG_START+14)           //error in interpreting O_CONTRACTn
#define E_CODE_O_BG_ERROR                                   (E_CODE_MSG_START+15)           //error in interpreting O_B&G

#define E_CODE_O_PRM_ERROR_VDSL2                            (E_CODE_MSG_START+20)           //error in interpreting O-PRM
#define E_CODE_OTA_UPDATE_ERROR_VDSL2                       (E_CODE_MSG_START+21)           //error in interpreting O-TA-UPDATE
#define E_CODE_O_TPS_ERROR_VDSL2                            (E_CODE_MSG_START+22)           //error in interpreting O-TPS
#define E_CODE_O_PMS_ERROR_VDSL2                            (E_CODE_MSG_START+23)           //error in interpreting O-PMS
#define E_CODE_O_PMD_ERROR_VDSL2                            (E_CODE_MSG_START+24)           //error in interpreting O-PMD
#define E_CODE_O_SIGNATURE_ERROR_VDSL2                      (E_CODE_MSG_START+25)           //error in interpreting O-Signature
#define E_CODE_O_UPDATE_ERROR_VDSL2                         (E_CODE_MSG_START+26)
#define E_CODE_O_MSG1_ERROR_VDSL2                           (E_CODE_MSG_START+27)
#define E_CODE_O_MSG_LD_ERROR_VDSL2                         (E_CODE_MSG_START+28)           //error in interpreting O-MSG-LD

//=================================================================================================
//Tone reordering error codes
//================================================================================================
#define E_CODE_TRT_NO_ERROR                                 (0)

#define E_CODE_TRT_START                                    (1)
#define E_CODE_TRT_RXNUMTONE                                (E_CODE_TRT_START+0)            //Number of RX tones incorrect
#define E_CODE_TRT_TXNUMTONE                                (E_CODE_TRT_START+1)            //Number of TX tones incorrect
#define E_CODE_TRT_RX_1BIT_TONES                            (E_CODE_TRT_START+2)            //Number of 1-bit RX tones is odd
#define E_CODE_TRT_TX_1BIT_TONES                            (E_CODE_TRT_START+3)            //Number of 1-bit TX tones is odd
#define E_CODE_TRT_FILL_UNUSEDTONE                          (E_CODE_TRT_START+4)            //Number of unused tone is incorrect


// XDSLRTFW-1385 BugFix_DS_VDSL2_ALL_ErrorCodes_On_FailState (End)
//==============================================================================
// Function Prototypes
//==============================================================================

void KernelException(uint32 i);

#endif // _VDSL_XCEPTION_H

