/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2004 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
#ifndef _VOC_H
#define _VOC_H

/****************************************************************************
;  Aware DMT Technology. Proprietary and Confidential.
;
;   40 Middlesex Turnpike, Bedford, MA 01730-1413
;  Phone (781) 276 - 4000
;   Fax   (781) 276 - 4001
;
;
;  File Name: voc.h
;
;  This file is the head file for doing VOC operations.
;
*****************************************************************************/


/* ======================= Define Constants =================================// */
/* ============================================================================================= */
/* ============================================================================================= */
/* VOC parameters */
/* ============================================================================================= */
/* ============================================================================================= */

/* message headers */
#define VOC_STUFFING_BYTE     (0x00)      /* stuffing byte pattern */
#define VOC_HEADER_UTC        (0xF0)      /* unable to comply */
#define VOC_HEADER_EBSR       (0xFC)      /* extended bit swap request */
#define VOC_HEADER_BSR        (0xFF)      /* bit swap request */
#define VOC_HEADER_BSA        (0xFF)      /* bit swap acknowledge */

/* message length */
#define VOC_MSG_UTC_LEN       (1)         /* unable to comply  */
#define VOC_MSG_BSR_LEN       (11)        /* bit swap request  */
#define VOC_MSG_BSA_LEN       (3)         /* bit swap acknowledge */

/* message command fields */
#define VOC_CMD_DO_NOTHING    (0x00)      /* do nothing */
#define VOC_CMD_BIT_INC1      (0x01)      /* increase the number of allocated bits by 1 */
#define VOC_CMD_BIT_DEC1      (0x02)      /* decrease the number of allocated bits by 1 */
#define VOC_CMD_PWR_INC1      (0x03)      /* increase the transmitted power by 1 dB */
#define VOC_CMD_PWR_INC2      (0x04)      /* increase the transmitted power by 2 dB */
#define VOC_CMD_PWR_INC3      (0x05)      /* increase the transmitted power by 3 dB */
#define VOC_CMD_PWR_DEC1      (0x06)      /* decrease the transmitted power by 1 dB */
#define VOC_CMD_PWR_DEC2      (0x07)      /* decrease the transmitted power by 2 dB */
#define VOC_CMD_BSA           (0xFF)      /* bit swap acknowledge */

/* message type (represnted in different numbers) */
#define VOC_MSG_ID_UTC        (0)         /* unable to comply */
#define VOC_MSG_ID_PMR        (1)         /* profile management request */
#define VOC_MSG_ID_PMA        (2)         /* profile management acknowledge */
#define VOC_MSG_ID_BSR        (3)         /* bit swap request */
#define VOC_MSG_ID_BSA        (4)         /* bit swap acknowledge */
#define VOC_MSG_ID_EBSR       (5)         /* extended bit swap request */
#define VOC_MSG_ID_UNDEFINED  (6)         /* undefined message */

/* others */
#define VOC_MIN_NUM_STUFFING_BYTES (20)     /* min. number of stuffing bytes between messages */
#define VOC_MAX_MSG_LENGTH         (13)     /* maximum msg length in byte */
#define VOC_NUM_MSG_HEADERS        (6)      /* no. of different valid message headers */
#define VOC_MSG_REPEAT_CNT         (5)      /* no. of times for the same message to be sent repeatively */
#define VOC_TX_MAX_RETRIES         (1)      /* maximum no. of times that same message is retried */
#define VOC_TX_TIMEOUT             (2000)   /* 2000 = 500msec/250usec, VOC TX timeout in DMT symbols */
#define VOC_INFINITY               (0x7FFF) /* represent number infinity */

#define VOC_NEW_MSG           (1)         /* search for new message */
#define VOC_CONT_MSG       (0)         /* continue with the current message */


#define VOC_TXMSG_BSR_IDLE          (1)
#define VOC_TXMSG_BSR_READY_TO_SEND (2)
#define VOC_TXMSG_BSR_OUTSTANDING   (3)

#define VOC_TXMSG_BSA_IDLE          (1)
#define VOC_TXMSG_BSA_READY_TO_SEND (2)
#define VOC_TXMSG_BSA_OUTSTANDING   (3)

#define NEG_SNR_MARGIN_FOR_BIT_SWAP    (3<<8)   /* dB in @8.8 format) */
                                    /* negative SNR margin */
#define POS_SNR_MARGIN_FOR_BIT_SWAP    (3<<8)   /* dB in @8.8 format) */
                                    /* positive SNR margin */

#define NUM_BFI_FRAMES_WAIT_FOR_BITSWAP   (10)  // 200 = number of BFI frames to wait...
                                              // ...set to 10 temporarily to shorten simulation time

/* the following parameters are calculated as 512*10^(del_gain/20)*(2^5), */
/* i.e., 10^(del_gain) in Q2.14 format */
/* where del_gain is the fine gain change sent from BSR or EBSR  */
/* (which can be 1, 2, 3 or -1, -2, -3 dB) */
#define BS_GAIN_INC1 (0x47CF)    /* 512*10^(1/20) * (2^5) */
#define BS_GAIN_INC2 (0x5092)    /* 512*10^(2/20) * (2^5) */
#define BS_GAIN_INC3 (0x5A67)    /* 512*10^(3/20) * (2^5) */
#define BS_GAIN_DEC1 (0x390A)    /* 512*10^(-1/20) * (2^5) */
#define BS_GAIN_DEC2 (0x32D6)    /* 512*10^(-2/20) * (2^5) */
#define BS_GAIN_DEC3 (0x2D4F)    /* 512*10^(-3/20) * (2^5) */

#define NEW_VOC_MESSAGE 0x100          /* packed bit created to indicate new valid VOC message */

/* ======================= Define Structures =================================// */

/* Structure containing TX VOC message variables */
typedef struct {
   uint8 uc_msg_length;          /* message length in bytes */
   uint8 uc_msg_id;              /* message identifier */
   uint8 uca_msg_body[MAX_TX_VOC_MSG_LEN]; /* message body buffer */
} TxVOCMsgStruc_t;

/* Structure containing RX VOC message variables */
typedef struct {
   int16 s_msg_timer;            /* message timer in DMT symbols */
   uint8 uc_msg_retry_count;        /* message retry (resent) count */
   uint8 uc_msg_length;          /* message length in bytes */
   uint8   uc_msg_flag;          /* flag indicating the status of this message */
                              /* which can be OUTSTANDING, FAIL or SUCCEED    */
   uint8 uc_msg_id;              /* message identifier */
    uint8   uc_reason_of_fail;         /* reason of fail (either UTC is received or timeout occurs) */
   uint8 uca_msg_body[MAX_RX_VOC_MSG_LEN]; /* message body buffer */

} RxVOCMsgStruc_t;

typedef struct {
   uint8 uca_msg_body[VOC_MAX_MSG_LENGTH]; /* message body buffer */
   uint8 uc_BFI_Count;                 /* bitswap frame interval count after which  */
                                 /* bit swap takes place */
} BitSwapInfoStruc_t;



void SendVocMsgs(void);
void RxVocHandler(void);
uint8 VocMsgMatch(uint8 *puca_msg_buf, uint8 uc_msg_length);

#endif /* _VOC_H */
