/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2003 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/****************************************************************************
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   L3StateMachine.c
*
*
****************************************************************************/

/*-------------------------------------------------------------------------*/
//
//   File L3StatMachine.c
//
//   History :
// 22/11/2012 Prashant: Added framework for L3 Orderly shutdown procedure for both CO and CPE driven.
//            Grep for XDSLRTFW-650 / XDSLRTFW-1384
//
// 03/07/2014 Prashant: Added fix for CPE stuck in showtime when no response from CO for auto L3 request from CPE.
//            Handled the response timeout correctly.
//            Grep for XDSLRTFW-1893

/*-------------------------------------------------------------------------*/
#include <string.h>
#include "typedef.h"
#include "gdata.h"
#include "cmv.h"
#include "eoc.h"
#include "vdsl_xception.h"

/*^^^
 *------------------------------------------------------------------------
 *
 *  Name : PM_L3_State_Machine(void)
 *
 *  Description:  This subroutine implements the PM L3 state machine
 *
 *  Prototype:
 *      void  PM_L3_State_Machine(void)
 *
 *  Input Arguments:
 *      None
 *
 *  Output Arguments:
 *      1. (a)STATArray[STAT_ME_PMREQ_STATUS] (b)STATArray[STAT_ME_PMREQ_ERROR]
 *
 *  Return:
 *      None
 *
 *  Global Variables Used:
 *      1. guc_PM_L3_InternalState
 *      2. guc_PM_L3_Response
 *
 *  Notes:
 *
 *------------------------------------------------------------------------
 *^^^
 */
// XDSLRTFW-650 / XDSLRTFW-1384 (Start)
void PM_L3_State_Machine(void)
{

   TxOvhdMsgInfoRequest_t t_TxOvhdMsgInfoRequest;    // will contain the info about the message to be generated

   switch(guc_PM_L3_InternalState)
   {

   case WAITING_FOR_L3_REQUEST:

      if((TESTArray[TEST_Control3] & TEST_DisableL3Mode))
      {

         guc_PM_L3_InternalState = WAITING_FOR_L3_REQUEST;
         guc_PM_L3_Response = PM_L3_RESPONSE_DISABLED;
         STATArray[STAT_ME_PMREQ_STATUS] = STAT_OLRPM_L3_FAILED;
         STATArray[STAT_ME_PMREQ_ERROR] = REQ_ACTION_DISABLED;
      }

      else if(CNTLArray[CNTL_ShutDownRequest] & CNTL_L3OrderlyShutDown)
      {
         CNTLArray[CNTL_ShutDownRequest] ^= CNTL_L3OrderlyShutDown;   //Clear the bit
         if ((gt_RxOLRPMVars.uc_rxOLRPMState == L0_STEADY_STATE) )
         {
            // Change the rxOLRPMState here so we don't consider other OLR/PM until
            // this L3 request is resolved
            gt_RxOLRPMVars.uc_rxOLRPMState = L3_REQUEST;
            STATArray[STAT_ME_PMREQ_STATUS] = STAT_OLRPM_L3_IN_PROGRESS;
            STATArray[STAT_ME_PMREQ_ERROR] = 0;
            guc_PM_L3_InternalState = WAITING_FOR_QUEUE_IN_HDLC_TX_QUEUE;
         }
         else
         {
            STATArray[STAT_ME_PMREQ_STATUS] = STAT_OLRPM_L3_FAILED;
            STATArray[STAT_ME_PMREQ_ERROR] = REQ_NOT_IN_L0_STATE;   // Actually, not in L0 or L2 state.
         }
      }
      break;

   case WAITING_FOR_QUEUE_IN_HDLC_TX_QUEUE:
      //Fill up the structure members of "TxOvhdMsgInfoRequest_t"
      memset(&t_TxOvhdMsgInfoRequest,0,sizeof(t_TxOvhdMsgInfoRequest));
      t_TxOvhdMsgInfoRequest.uc_message_type = STATE_TRANS_REQ;
      t_TxOvhdMsgInfoRequest.uc_message_designator = POWER_MGMT_CMD_DESIG;
      t_TxOvhdMsgInfoRequest.uc_Source = AUTO_CMD_SOURCE;
      t_TxOvhdMsgInfoRequest.uc_Segmented = FALSE;
      t_TxOvhdMsgInfoRequest.uc_TestParameterId = L3_STATE;

      //Push Simple PM L3 request in HDLC Tx Queue. If this fails, remain in this
      // state and try again next time.
      if (EOC_QUEUE_ADDED == TxEocSendRequest(OVHD_NORMAL_PRIORITY /* priority */, t_TxOvhdMsgInfoRequest))
      {
         guc_PM_L3_InternalState = WAITING_FOR_L3_RESPONSE;
         guc_PM_L3_Response = 0;      //Reset the variable
      }
      break;


   case WAITING_FOR_L3_RESPONSE:
      if(guc_PM_L3_Response > 0)   //Either response recived or time out occured
      {
         guc_PM_L3_InternalState = WAITING_FOR_L3_REQUEST;

         if(guc_PM_L3_Response == PM_L3_GRANT_RECEIVED)
         {
            // L3 request/grant is complete, then reset
            gft_EnterL3State = TRUE;
            gt_RxOLRPMVars.uc_rxOLRPMState = L3_STEADY_STATE;
            STATArray[STAT_ME_PMREQ_STATUS] = (STAT_OLRPM_L3_ACCEPTED | STAT_OLRPM_RESPONSE);
            gsa_IndirectStat0[1] = (int16) STAT_PM_L3;
            EnterFailStates(E_CODE_L3_ORDERLY_SHUTDOWN);
         }

         if(guc_PM_L3_Response == PM_L3_REJECT_RECEIVED)
         {
            gt_RxOLRPMVars.uc_rxOLRPMState = L0_STEADY_STATE;
            STATArray[STAT_ME_PMREQ_STATUS] = (STAT_OLRPM_L3_REJECTED | STAT_OLRPM_RESPONSE);
            gft_EnterL3State = TRUE; // XDSLRTFW-1893 Start_End
         }

         if(guc_PM_L3_Response == PM_L3_RESPONSE_TIMEOUT)
         {
            gt_RxOLRPMVars.uc_rxOLRPMState = L0_STEADY_STATE;
            STATArray[STAT_ME_PMREQ_STATUS] = STAT_OLRPM_L3_FAILED;
            STATArray[STAT_ME_PMREQ_ERROR] = REQ_L3_RESPONSE_TIMEOUT;
            gft_EnterL3State = TRUE; // XDSLRTFW-1893 Start_End
            guc_PM_L3_InternalState = WAITING_FOR_L3_REQUEST;
         }
      }
      break;
   }

}
// XDSLRTFW- XDSLRTFW-650 / XDSLRTFW-1384 (End)
//#endif


