/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2004 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/****************************************************************************
;   Aware DMT Technology. Proprietary and Confidential.
;
;   40 Middlesex Turnpike, Bedford, MA 01730-1413
;   Phone (781) 276 - 4000
;   Fax   (781) 276 - 4001
;
;
;   File Name: ovhd.c
;
;   Functions for implementing VDSL2 overhead channel
;
;***************************************************************************/
// ***********************************************************************************************************
// ovhd.c
//
// History
//
// 21/05/2013 Fuss: Link drop on CO due to FE LOF indication
//            Grep for XDSLRTFW-947 BUGFIX_US_VDSL2_All_LofIndication
// ************************************************************************************************************

#include <string.h>
#include "common.h"
#include "gdata.h"
#include "OvhdMsg_IOf.h"
#include "PrintTrail.h"
#include "vdsl_xception.h"
#include "LL_IOf.h"
#include "vdsl_state.h"
#include "eoc.h"
#include "fifo.h"
#include "cmv.h"
#include "cmv_data.h"
#ifdef DEBUG_TRAIL
#include "LeaveStatesTrail.h"
#endif //DEBUG_TRAIL

extern void UpdateTCSyncState(uint8 uc_TCSync);
extern void UpdateAtmPrimitive_NE(int16 s_lp, int16 s_abc);
extern void UpdateLineFailurePrimitive_NE(void);
extern void G997_CheckTxFailure(void);
extern void UpdateG997Counters(void);
extern void G997_SuperFrame_Task(void);

int16 ReadByteFromRxOvhdSwFifo(uint8 *puc_byte);

/****************************************************************************
; Name: WriteTxOvhdSwFifo
;
; Prototype:
;   uint16 WriteTxOvhdSwFifo(uint8 *puca_inbuf, uint16 us_NumBytes)
;
; Description:
;   This function copies VOC bytes to the Tx overhead byte SW FIFO.
;
; Arguments:
;   *puca_inbuf - pointer to input buffer
;   us_NumBytes - # of bytes to write to SW FIFO
;
; Return Value:
;   i - # of bytes to written to SW FIFO
;
; Globals:
;
*****************************************************************************/
uint16 WriteTxOvhdSwFifo(uint8 *puca_inbuf, uint16 us_NumBytes)
{
   int16 i;

   for(i=0; i<us_NumBytes; i++)
   {
      // Stop writing if SW FIFO is full.
// XDSLRTFW-947 BUGFIX_US_VDSL2_All_LofIndication (start)
// Note: Two case have to be avoided:
//       1) That not more bytes are written to the SW FIFO than the max size (at the beginning).
//          Otherwise the first bytes would be directly overwritten and were lost.
//       2) It is not allowed that the write pointer is overtaking the read pointer,
//          because than old not transmitted values would be overwritten with new values.
//
//       The old check "if(gs_TxOvhdSwFifoDepth == (TX_OVHD_MSG_SWFIFO_LEN-1))" covers only point 1.
//       The new check covers both cases!

      if ((gs_TxOvhdWrPtr == gs_TxOvhdRdPtr) && (gs_TxOvhdSwFifoDepth != 0))
// XDSLRTFW-947 BUGFIX_US_VDSL2_All_LofIndication (stop)
      {
         break;
      }

      // Copy byte to SW FIFO buffer
      guca_TxOvhdSwFifoBuf[gs_TxOvhdWrPtr++] = puca_inbuf[i];

      // Increment SW FIFO depth
      gs_TxOvhdSwFifoDepth++;

      // Increment the Tx message index
      gs_TxOvhdMsgIndex++;

      // Check for buffer wrap
      if(gs_TxOvhdWrPtr == TX_OVHD_MSG_SWFIFO_LEN)
      {
         gs_TxOvhdWrPtr = 0;
      }

   }

   return(i);
}


/*
*-------------------------------------------------------------------------------
*
*   Prototype: void TxOvhdHandler(void)
*
*   This function returns the overhead bytes needed
*
*   Input Arguments:
*
*   Output Arguments:
*
*   Returns:
*
*   Global Variables:
*
*-------------------------------------------------------------------------------
*/

void TxOvhdHandler(void)
{
   uint8 uc_ovhd_byte;

   // Add bytes to the SW fifo until full to support max possible
   // ovhd bytes for a PMD frame
   while (gs_TxOvhdSwFifoDepth < MAX_OVHD_BYTES_PER_FRAME)
   {
      switch( gs_TxOvhdState)
      {
      case INSERT_SYNC:

         if (gs_TxState == R_SHOWTIME_TX)
         {
            // Enable flag for processing Tx IB bytes
            gus_ShowtimeControl |= MASK_PROCESS_TX_IB;

         }

         uc_ovhd_byte = SYNC_BYTE;

         // The sync byte is 0xAC for the first OH frame in a superframe
         if (gs_NumOHFrames == gt_tx_config_v2.s_Fp[LP0])
         {
            // Reset the count to start counting next set of Fp OH frames
            gs_NumOHFrames = 0;
         }

         // Take care of the sync byte value at the beginnning of an OH
         // superframe
         if (gs_NumOHFrames == 0)
         {
            uc_ovhd_byte = SYNC_BYTE_SFRAME;
         }

         // Add the sync byte to the SW fifo
         WriteTxOvhdSwFifo(&uc_ovhd_byte, (uint16)1);

         // Increment the ovhd state
         gs_TxOvhdState ++;

         break;

      case INSERT_IB0:
      case INSERT_IB1:
      case INSERT_IB2:

         uc_ovhd_byte = guca_TxIbMsgBuf[gs_TxOvhdState - 1];

         // Increment the ovhd state
         gs_TxOvhdState ++;

         WriteTxOvhdSwFifo(&uc_ovhd_byte, (uint16)1);
         break;

      case INSERT_NTR:

         // Insert the NTR byte read from the ZT_NTR_IBITS register
         uc_ovhd_byte = guc_TxNTRByte;
         // Increment the ovhd state
         gs_TxOvhdState ++;

         WriteTxOvhdSwFifo(&uc_ovhd_byte, (uint16)1);

         break;

      case INSERT_HDLC:

         // Check if a complete Tx EOC message is available and not yet fully transmitted
         // 9i.e. the fifo isn't empty yet)
         if (gft_StartTxEOC == TRUE)
         {
            // Check if any message to be transmitted
            if(!RemoveMessageFromOvhdFifo(&gt_TxEocMsgFifo, &uc_ovhd_byte))
            {
               // Generate closing flag
               uc_ovhd_byte = HDLC_FLAG;

               // Prevent message byte removal from fifo until next message available
               gft_StartTxEOC = FALSE;
            }
         }
         else
         {
            // No message to be transmitted, fill in the HDLC flag
            uc_ovhd_byte = HDLC_FLAG;
         }

         WriteTxOvhdSwFifo(&uc_ovhd_byte, (uint16)1);

         // Start back from SYNC byte every (SEQp -1) bytes
         if (gs_TxOvhdMsgIndex == (gt_tx_config_v2.s_SEQp[LP0] - 1))
         {
            // Increment the number of overhead frames every SEQp
            // bytes of overhead
            gs_NumOHFrames++;

            gs_TxOvhdMsgIndex = 0;
            gs_TxOvhdState = INSERT_SYNC;
         }
         break;

      } // end of swich

   } // End of while

}

/*
*-------------------------------------------------------------------------------
*
*   Prototype: void RxOvhdHandler(void)
*
*   This function returns the overhead bytes received
*
*   Input Arguments:
*
*   Output Arguments:
*
*   Returns:
*
*   Global Variables:
*
*
*-------------------------------------------------------------------------------
*/

void RxOvhdHandler(void)
{
   int16 s_index;
   uint8 uc_byte;

   // Empty out the SW fifo every time there is new data to be read
   // Read one byte from SW FIFO if available
   while (ReadByteFromRxOvhdSwFifo(&uc_byte))
   {
      switch( gs_RxOvhdState)
      {
      case GET_SYNC:

         // Store the received sync byte
         guc_RxSyncByte = uc_byte;

         // Increment the ovhd state
         gs_RxOvhdState ++;

         break;

      case GET_IB0:
      case GET_IB1:
      case GET_IB2:

         s_index = gs_RxOvhdMsgIndex - 2;

         // use double buffer to delay processing of the IB and then
         // use CRC indicator to determine whether IBs are valid.
         guca_RxIbMsgBuf[s_index] = guca_RxIbMsgBufTemp[s_index];
         guca_RxIbMsgBufTemp[s_index] = uc_byte;

         // Increment the ovhd state
         gs_RxOvhdState ++;

         break;

      case GET_NTR:

         // Set control bit to process indicator bits and perform
         // other once-per-superframe tasks
         gus_ShowtimeControl |= MASK_PROCESS_RX_IB ;
         gft_NTR_Rcvd = TRUE;
         guc_RxNTRByte = uc_byte;

         // Increment the ovhd state
         gs_RxOvhdState ++;

         break;

      case GET_HDLC:

         // Only add non-FLAG values to the fifo
         // If a message received, also add a closing flag to mark
         // the end of the received message
         switch (gs_RxOvhdSubState)
         {

         case MONITOR_OH_BYTE:

            // Start of message indicated by received byte which is not an HDLC_FLAG
            if (uc_byte != HDLC_FLAG)
            {
               // Add the received message to the EOC fifo
               AddMessageToOvhdFifo(&gt_RxEocMsgFifo, uc_byte);
               // XDSLRTFW-3107 store the first bytes of a message into an array to identify OLR messages.
               // This is needed to start the US OLR timeout handler correctly
               gul_first_OHC_bytes = uc_byte;
               gus_first_OHC_bytes_cnt++;

               gs_RxOvhdSubState = ADD_OH_BYTE_TO_FIFO;
            }
#ifdef DEBUG_TRAIL
            // Let EOC trail log code decide whether to skip logging this flag
            else
            {
               LeaveEOCOvhdMsgTrail(0x6666, uc_byte);
            }
#endif //DEBUG_TRAIL
            break;

         case ADD_OH_BYTE_TO_FIFO:
            // Add the received message to the EOC fifo
            AddMessageToOvhdFifo(&gt_RxEocMsgFifo, uc_byte);
            // XDSLRTFW-3107 START Add US OHC timout check for high prio messages (i.e. OLR)
            gus_first_OHC_bytes_cnt++;
            //
            if (gus_first_OHC_bytes_cnt <= 3)
            {
               //shift the current result up and add new byte to the LS byte
               gul_first_OHC_bytes = (gul_first_OHC_bytes << 8);
               gul_first_OHC_bytes |= uc_byte;

               //check for OLR message
               // byte 0 (MS Byte) not used due to check of only the first 3 bytes
               // byte 1 = 0 -> High Prio message i.e. OLR
               // byte 2 = 0 -> Command
               // byte 3 = 1 -> Message Type: OLR
               if ((gul_first_OHC_bytes == 0x00000001) && (gus_first_OHC_bytes_cnt == 3))
               {
                  //OLR message detected, start timer
                  gft_UsOlrInProgress = TRUE;
                  gla_RxMessageTimer[0] = gl_RxSymbolCount;
                  DSH_SendEvent(DSH_EVT_START_COUNTER,sizeof(uint32),(void *)&gl_RxSymbolCount);
               }
            }
            // XDSLRTFW-3107 END

            // Stop adding to fifo after closing flag received
            if (uc_byte == HDLC_FLAG)
            {
               gs_RxOvhdSubState = MONITOR_OH_BYTE;
               gus_first_OHC_bytes_cnt = 0;
            }

            break;
         }

         // Start back from SYNC byte every (SEQp -1) bytes
         if (gs_RxOvhdMsgIndex == (gt_rx_config_v2.s_SEQp[LP0] - 1))
         {
            gs_RxOvhdMsgIndex = 0;
            gs_RxOvhdState = GET_SYNC;
         }
         break;

      } // end of swich

   } // End of while

}

/****************************************************************************
; Name: ReadByteFromRxOvhdSwFifo
;
; Prototype:
;   int16 ReadByteFromRxOvhdSwFifo(uint8 *puc_byte)
;
; Description:
;   This function reads 1 Ovhd byte from the Rx overhead byte SW FIFO.
;
; Arguments:
;   *puc_byte - pointer to byte to be read
;
; Return Value:
;   1 if there is a byte to be read.
;   0 if no more bytes can be read.
;
*****************************************************************************/
int16 ReadByteFromRxOvhdSwFifo(uint8 *puc_byte)
{

   if (gs_RxOvhdRdPtr != gs_RxOvhdWrPtr)
   {
      *puc_byte = guca_RxOvhdSwFifoBuf[gs_RxOvhdRdPtr++];

      gs_RxOvhdMsgIndex++;

      // Reset pointer if it reaches end of buffer
      if (gs_RxOvhdRdPtr == RX_OVHD_MSG_SWFIFO_LEN)
      {
         gs_RxOvhdRdPtr = 0;
      }

      return 1;
   }
   else
   {
      return 0;
   }
}


// Add Ovhd message to fifo
void AddMessageToOvhdFifo(MessageOvhdFifo_t *fifo, uint8 message)
{
   int16 s_NextAvailableAfterUpdate;

   s_NextAvailableAfterUpdate = fifo->NextAvailable + 1;

   if (s_NextAvailableAfterUpdate==fifo->BufferSize)
   {
      s_NextAvailableAfterUpdate=0;
   }

   if (s_NextAvailableAfterUpdate == fifo->IndexOfOldest)
   {
// DFH - define later      fifo->ErrorCode = E_CODE_OVHD_FIFO_OVERFLOW;
      fifo->us_OvflowCnt++;
      return; //discard the incoming message byte
   }

   fifo->ErrorCode = 0;  //clear error code

   // First add message to fifo.
   fifo->MessageBuffer[fifo->NextAvailable] = message;

   // Then indicate new message.
   fifo->NextAvailable = s_NextAvailableAfterUpdate;
#ifdef DEBUG_TRAIL
   // TX OVHD MESSAGE
   if (fifo == &gt_TxEocMsgFifo)
   {
      LeaveEOCOvhdMsgTrail(0x5555, message);
   }
   // RX OVHD MESSAGE
   else
   {
      LeaveEOCOvhdMsgTrail(0x6666, message);
   }
#endif //DEBUG_TRAIL
}

// Remove Ovhd message from fifo
// Returns a 1 if there is a message, returns a 0 if fifo is empty
int16 RemoveMessageFromOvhdFifo(MessageOvhdFifo_t *fifo, uint8 *message)
{
   if (fifo->IndexOfOldest == fifo->NextAvailable)
   {
      return 0;
   }

   // First read message from fifo.
   *message = fifo->MessageBuffer[fifo->IndexOfOldest];

   // Then indicate message has been removed.
   if ((fifo->IndexOfOldest + 1) == fifo->BufferSize)
   {
      fifo->IndexOfOldest=0;
   }
   else
   {
      fifo->IndexOfOldest++;
   }

   return 1;
}

